/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.utils.bytebuffer;

import com.prosysopc.ua.stack.encoding.binary.ByteUtils;
import com.prosysopc.ua.stack.utils.bytebuffer.IBinaryWriteable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class OutputStreamWriteable
implements IBinaryWriteable {
    ByteOrder DM = ByteOrder.LITTLE_ENDIAN;
    OutputStream out;
    private final byte[] ur = new byte[2];
    private final byte[] us = new byte[4];
    private final byte[] uu = new byte[8];

    public OutputStreamWriteable(OutputStream outputStream) {
        if (outputStream == null) {
            throw new IllegalArgumentException("null arg");
        }
        this.out = outputStream;
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    public OutputStream getStream() {
        return this.out;
    }

    @Override
    public ByteOrder order() {
        return this.DM;
    }

    @Override
    public void order(ByteOrder byteOrder) {
        this.DM = byteOrder;
    }

    @Override
    public void put(byte by) throws IOException {
        this.E(by);
    }

    @Override
    public void put(byte[] byArray) throws IOException {
        this.out.write(byArray);
    }

    @Override
    public void put(byte[] byArray, int n2, int n3) throws IOException {
        this.out.write(byArray, n2, n3);
    }

    @Override
    public void put(ByteBuffer byteBuffer) throws IOException {
        if (byteBuffer.hasArray()) {
            byte[] byArray = byteBuffer.array();
            this.put(byArray, byteBuffer.position(), byteBuffer.remaining());
            byteBuffer.position(byteBuffer.limit());
        } else {
            while (byteBuffer.hasRemaining()) {
                this.E(byteBuffer.get());
            }
        }
    }

    @Override
    public void put(ByteBuffer byteBuffer, int n2) throws IOException {
        if (byteBuffer.hasArray()) {
            byte[] byArray = byteBuffer.array();
            this.put(byArray, byteBuffer.position(), n2);
            byteBuffer.position(n2);
        } else {
            for (int i2 = 0; i2 < n2; ++i2) {
                this.E(byteBuffer.get());
            }
        }
    }

    @Override
    public void putDouble(double d2) throws IOException {
        this.putLong(Double.doubleToLongBits(d2));
    }

    @Override
    public void putFloat(float f2) throws IOException {
        this.putInt(Float.floatToIntBits(f2));
    }

    @Override
    public void putInt(int n2) throws IOException {
        this.put(ByteUtils.writeInt(n2, this.us, 0, this.DM));
    }

    @Override
    public void putLong(long l2) throws IOException {
        this.put(ByteUtils.writeLong(l2, this.uu, 0, this.DM));
    }

    @Override
    public void putShort(short s2) throws IOException {
        this.put(ByteUtils.writeShort(s2, this.ur, 0, this.DM));
    }

    private void E(int n2) throws IOException {
        this.out.write(n2);
    }
}

