/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.utils.bytebuffer;

import com.prosysopc.ua.stack.encoding.binary.ByteUtils;
import com.prosysopc.ua.stack.utils.bytebuffer.ByteBufferUtils;
import com.prosysopc.ua.stack.utils.bytebuffer.IBinaryWriteable;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ByteBufferArrayWriteable2
implements IBinaryWriteable {
    ByteBuffer[] DK;
    int DL = 0;
    ByteBuffer cur;
    ByteOrder DM;
    ChunkListener DN;

    public ByteBufferArrayWriteable2(ByteBuffer[] byteBufferArray, ChunkListener chunkListener) {
        if (byteBufferArray == null || chunkListener == null) {
            throw new IllegalArgumentException("null arg");
        }
        this.DK = byteBufferArray;
        this.DN = chunkListener;
        this.cur = byteBufferArray[0];
    }

    @Override
    public void flush() {
    }

    @Override
    public ByteOrder order() {
        return this.DM;
    }

    @Override
    public void order(ByteOrder byteOrder) {
        this.DM = byteOrder;
        this.cur.order(byteOrder);
    }

    @Override
    public void put(byte by) throws IOException {
        this.eua();
        this.cur.put(by);
        this.etZ();
    }

    @Override
    public void put(byte[] byArray) throws IOException {
        this.put(byArray, 0, byArray.length);
    }

    @Override
    public void put(byte[] byArray, int n2, int n3) throws IOException {
        while (n3 > 0) {
            this.eua();
            int n4 = Math.min(n3, this.cur.remaining());
            this.cur.put(byArray, n2, n4);
            n2 += n4;
            n3 -= n4;
            this.etZ();
        }
    }

    @Override
    public void put(ByteBuffer byteBuffer) throws IOException {
        while (byteBuffer.hasRemaining()) {
            this.eua();
            ByteBufferUtils.copyRemaining(byteBuffer, this.cur);
            this.etZ();
        }
    }

    @Override
    public void put(ByteBuffer byteBuffer, int n2) throws IOException {
        while (n2 > 0) {
            this.eua();
            int n3 = Math.min(n2, Math.min(byteBuffer.remaining(), this.cur.remaining()));
            ByteBufferUtils.copy(byteBuffer, this.cur, n3);
            n2 -= n3;
            this.etZ();
        }
    }

    @Override
    public void putDouble(double d2) throws IOException {
        this.putLong(Double.doubleToLongBits(d2));
    }

    @Override
    public void putFloat(float f2) throws IOException {
        this.putInt(Float.floatToIntBits(f2));
    }

    @Override
    public void putInt(int n2) throws IOException {
        if (this.cur.remaining() >= 4) {
            this.cur.putInt(n2);
            this.etZ();
        } else {
            this.put(ByteUtils.intToBytes(n2, this.DM));
        }
    }

    @Override
    public void putLong(long l2) throws IOException {
        if (this.cur.remaining() >= 8) {
            this.cur.putLong(l2);
            this.etZ();
        } else {
            this.put(ByteUtils.longToBytes(l2, this.DM));
        }
    }

    @Override
    public void putShort(short s2) throws IOException {
        if (this.cur.remaining() >= 2) {
            this.cur.putShort(s2);
            this.etZ();
        } else {
            this.put(ByteUtils.shortToBytes(s2, this.DM));
        }
    }

    private void etZ() {
        if (!this.cur.hasRemaining()) {
            this.fireChunkComplete(this.DL);
        }
    }

    private void eua() {
        while (!this.cur.hasRemaining()) {
            ++this.DL;
            if (this.DL >= this.DK.length) {
                throw new BufferOverflowException();
            }
            this.cur = this.DK[this.DL];
            this.cur.order(this.DM);
        }
    }

    protected void fireChunkComplete(int n2) {
        if (this.DN != null) {
            this.DN.onChunkComplete(this.DK, n2);
        }
    }

    void E(int n2) throws IOException {
        this.eua();
        this.cur.put((byte)n2);
        this.etZ();
    }

    public static interface ChunkListener {
        public void onChunkComplete(ByteBuffer[] var1, int var2);
    }
}

