/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.utils.bytebuffer;

import com.prosysopc.ua.stack.utils.bytebuffer.ByteQueue;
import com.prosysopc.ua.stack.utils.bytebuffer.IBinaryReadable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ByteBufferArrayReadable
implements IBinaryReadable {
    final ByteQueue DH;

    public ByteBufferArrayReadable(ByteBuffer[] byteBufferArray) {
        if (byteBufferArray == null) {
            throw new IllegalArgumentException("null");
        }
        this.DH = new ByteQueue();
        for (ByteBuffer byteBuffer : byteBufferArray) {
            this.DH.offer(byteBuffer);
        }
    }

    public ByteBufferArrayReadable(ByteQueue byteQueue) {
        if (byteQueue == null) {
            throw new IllegalArgumentException("null");
        }
        this.DH = byteQueue;
    }

    @Override
    public byte get() throws IOException {
        return this.DH.getReadChunk().get();
    }

    @Override
    public void get(byte[] byArray) throws IOException {
        this.DH.get(byArray);
    }

    @Override
    public void get(byte[] byArray, int n2, int n3) throws IOException {
        this.DH.get(byArray, n2, n3);
    }

    @Override
    public void get(ByteBuffer byteBuffer) throws IOException {
        this.DH.get(byteBuffer);
    }

    @Override
    public void get(ByteBuffer byteBuffer, int n2) throws IOException {
        this.DH.get(byteBuffer, n2);
    }

    public ByteQueue getByteQueue() {
        return this.DH;
    }

    @Override
    public double getDouble() throws IOException {
        if (this.DH.getReadChunk().remaining() >= 8) {
            return this.DH.getReadChunk().getDouble();
        }
        return this.DH.get(8).getDouble();
    }

    @Override
    public float getFloat() throws IOException {
        if (this.DH.getReadChunk().remaining() >= 4) {
            return this.DH.getReadChunk().getFloat();
        }
        return this.DH.get(4).getFloat();
    }

    @Override
    public int getInt() throws IOException {
        if (this.DH.getReadChunk().remaining() >= 4) {
            return this.DH.getReadChunk().getInt();
        }
        return this.DH.get(4).getInt();
    }

    @Override
    public long getLong() throws IOException {
        if (this.DH.getReadChunk().remaining() >= 8) {
            return this.DH.getReadChunk().getLong();
        }
        return this.DH.get(8).getLong();
    }

    @Override
    public short getShort() throws IOException {
        if (this.DH.getReadChunk().remaining() >= 2) {
            return this.DH.getReadChunk().getShort();
        }
        return this.DH.get(2).getShort();
    }

    @Override
    public long limit() {
        return this.DH.getBytesWritten();
    }

    @Override
    public ByteOrder order() {
        return this.DH.order();
    }

    @Override
    public void order(ByteOrder byteOrder) {
        this.DH.order(byteOrder);
    }

    @Override
    public long position() {
        return this.DH.getBytesRead();
    }
}

