/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.utils.asyncsocket;

import com.prosysopc.ua.stack.utils.asyncsocket.AsyncSelector;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListenableServerSocketChannel {
    static Logger logger = LoggerFactory.getLogger(ListenableServerSocketChannel.class);
    AtomicReference<ServerSocketChannel> gl = new AtomicReference<Object>(null);
    AsyncSelector Dq;
    Executor executor;
    volatile ServerSocketAcceptable Dr;
    boolean Ds = false;
    boolean Dt = false;
    Runnable Du;
    AsyncSelector.SelectListener Dv = new AsyncSelector.SelectListener(){

        @Override
        public void onSelected(AsyncSelector asyncSelector, SelectableChannel selectableChannel, int n2, int n3) {
            Runnable runnable;
            selectableChannel.keyFor(asyncSelector.CK).interestOps(0);
            if ((n2 & 0x10) != 0 && (runnable = ListenableServerSocketChannel.this.Du) != null) {
                if (ListenableServerSocketChannel.this.executor == null) {
                    ListenableServerSocketChannel.this.Ds = true;
                    try {
                        runnable.run();
                    }
                    catch (Throwable throwable) {
                        logger.trace("failure while selected channel", throwable);
                    }
                } else {
                    ListenableServerSocketChannel.this.Ds = true;
                    ListenableServerSocketChannel.this.executor.execute(runnable);
                }
            }
            asyncSelector.interestOps(selectableChannel, ListenableServerSocketChannel.this.getInterestOps());
        }
    };

    public ListenableServerSocketChannel(ServerSocketChannel serverSocketChannel, Executor executor) throws IOException {
        this(serverSocketChannel, executor, new AsyncSelector(Selector.open()));
        this.Dt = true;
    }

    public ListenableServerSocketChannel(ServerSocketChannel serverSocketChannel, Executor executor, AsyncSelector asyncSelector) throws ClosedChannelException {
        if (serverSocketChannel.isBlocking()) {
            throw new IllegalArgumentException("channel arg must be in non-blocking mode. (SocketChannel.configureBlocking(false))");
        }
        if (asyncSelector == null) {
            throw new IllegalArgumentException("null arg");
        }
        this.executor = executor;
        this.gl.set(serverSocketChannel);
        this.Dq = asyncSelector;
        asyncSelector.register(serverSocketChannel, 0, this.Dv);
    }

    public void bind(SocketAddress socketAddress, int n2) throws IOException {
        ServerSocketChannel serverSocketChannel = this.getChannel();
        serverSocketChannel.socket().bind(socketAddress, n2);
        if (socketAddress instanceof InetSocketAddress && ((InetSocketAddress)socketAddress).getPort() == 0) {
            logger.debug("OS chose port: {} as the next free port where to bind", (Object)serverSocketChannel.socket().getLocalPort());
        }
        logger.debug("bind, address:{}, backlog:{}, socket:{}", new Object[]{socketAddress, n2, serverSocketChannel});
        this.Dq.register(serverSocketChannel, 16, this.Dv);
    }

    public void close() throws IOException {
        ServerSocketChannel serverSocketChannel = this.gl.getAndSet(null);
        if (serverSocketChannel == null) {
            return;
        }
        this.Dq.unregister(serverSocketChannel);
        if (this.Dt) {
            this.Dq.close();
        }
        serverSocketChannel.close();
        logger.debug("closed");
    }

    public ServerSocketAcceptable getAcceptableListener() {
        return this.Dr;
    }

    public ServerSocketChannel getChannel() {
        return this.gl.get();
    }

    public AsyncSelector getSelectorThread() {
        return this.Dq;
    }

    public void setAcceptableListener(final ServerSocketAcceptable serverSocketAcceptable) {
        this.Dr = serverSocketAcceptable;
        this.Du = serverSocketAcceptable != null ? new Runnable(){

            @Override
            public void run() {
                try {
                    serverSocketAcceptable.onConnectionAcceptable(ListenableServerSocketChannel.this);
                }
                finally {
                    ListenableServerSocketChannel.this.Ds = false;
                    ListenableServerSocketChannel.this.etV();
                }
            }
        } : null;
        this.etV();
    }

    int getInterestOps() {
        ServerSocketChannel serverSocketChannel = this.gl.get();
        if (serverSocketChannel == null || !serverSocketChannel.isOpen() || !serverSocketChannel.isRegistered()) {
            return 0;
        }
        int n2 = 0;
        if (this.Dr != null && !this.Ds) {
            n2 |= 0x10;
        }
        return n2;
    }

    void etV() {
        ServerSocketChannel serverSocketChannel = this.gl.get();
        if (serverSocketChannel != null) {
            this.Dq.interestOps(serverSocketChannel, this.getInterestOps());
        }
    }

    public static interface ServerSocketAcceptable {
        public void onConnectionAcceptable(ListenableServerSocketChannel var1);
    }
}

