/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.utils.asyncsocket;

import com.prosysopc.ua.stack.utils.AbstractState;
import com.prosysopc.ua.stack.utils.asyncsocket.BufferMonitorState;
import java.io.IOException;
import java.util.concurrent.Executor;

public abstract class BufferMonitor
extends AbstractState<BufferMonitorState, IOException>
implements Comparable<BufferMonitor> {
    long Dn;
    Executor Do;

    BufferMonitor(long l2, Executor executor) {
        super(BufferMonitorState.Waiting, BufferMonitorState.Error);
        this.Dn = l2;
        this.Do = executor;
    }

    public synchronized void cancel() {
        if (this.getState() != BufferMonitorState.Waiting) {
            return;
        }
        this.setState(BufferMonitorState.Canceled, this.Do, null);
    }

    @Override
    public int compareTo(BufferMonitor bufferMonitor) {
        long l2 = this.Dn - bufferMonitor.Dn;
        return l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
    }

    public long getTriggerPos() {
        return this.Dn;
    }

    @Override
    protected synchronized void setError(IOException iOException) {
        super.setError(iOException);
    }

    synchronized void close() {
        if (this.getState() != BufferMonitorState.Waiting) {
            return;
        }
        super.setState(BufferMonitorState.Closed, this.Do, null);
    }

    synchronized void trigger() {
        if (this.getState() != BufferMonitorState.Waiting) {
            return;
        }
        super.setState(BufferMonitorState.Triggered, this.Do, null);
    }
}

