/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.utils;

import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.transport.AsyncResult;
import com.prosysopc.ua.stack.transport.ResultListener;
import com.prosysopc.ua.stack.utils.MultiDimensionArrayUtils;
import com.prosysopc.ua.stack.utils.TimerUtil;
import com.prosysopc.ua.stack.utils.asyncsocket.AsyncSelector;
import java.io.EOFException;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.ConnectException;
import java.net.SocketException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.Selector;
import java.util.Locale;
import java.util.Random;
import java.util.Timer;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StackUtils {
    private static Logger logger = LoggerFactory.getLogger(StackUtils.class);
    private static int Cm = 64;
    private static long Cn = 3L;
    private static final int Co = Runtime.getRuntime().availableProcessors();
    private static Executor Cp;
    private static Executor Cq;
    private static ExecutorService Cr;
    private static Integer Cs;
    private static Integer Ct;
    private static Integer Cu;
    private static AsyncSelector Cv;
    @Deprecated
    public static Random RANDOM;
    private static UnsignedInteger Cw;
    private static UnsignedInteger Cx;
    public static final int TCP_PROTOCOL_VERSION = 0;
    public static String NON_BLOCKING_WORK_EXECUTOR_NAME_PATTERN;
    public static String BLOCKING_WORK_EXECUTOR_NAME_PATTERN;
    public static String UA_TIMER_NAME_PATTERN;
    public static String SELECTOR_NAME_PATTERN;
    private static volatile Thread.UncaughtExceptionHandler Cy;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean barrierWait(AsyncResult<?>[] asyncResultArray, long l2) throws InterruptedException {
        final Semaphore semaphore = new Semaphore(0);
        ResultListener resultListener = new ResultListener(){

            public void onCompleted(Object object) {
                semaphore.release();
            }

            @Override
            public void onError(ServiceResultException serviceResultException) {
                semaphore.release();
            }
        };
        AsyncResult<?>[] asyncResultArray2 = asyncResultArray;
        int n2 = asyncResultArray2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            AsyncResult<?> asyncResult;
            AsyncResult<?> asyncResult2 = asyncResult = asyncResultArray2[i2];
            synchronized (asyncResult2) {
                if (asyncResult.getStatus() != AsyncResult.AsyncResultStatus.Waiting) {
                    semaphore.release();
                } else {
                    asyncResult.setListener(resultListener);
                }
                continue;
            }
        }
        return semaphore.tryAcquire(asyncResultArray.length, l2, TimeUnit.SECONDS);
    }

    public static int cores() {
        return Co;
    }

    public static synchronized Executor createBlockingWorkExecutor(String string, int n2) {
        if (Cq == null) {
            final AtomicInteger atomicInteger = new AtomicInteger(0);
            ThreadFactory threadFactory = new ThreadFactory(){

                @Override
                public Thread newThread(Runnable runnable) {
                    Thread thread = new Thread(runnable, String.format(Locale.ROOT, BLOCKING_WORK_EXECUTOR_NAME_PATTERN, atomicInteger.incrementAndGet()));
                    thread.setDaemon(true);
                    thread.setUncaughtExceptionHandler(Cy);
                    Integer n2 = StackUtils.getBlockingWorkExecutorThreadPriority();
                    if (n2 != null) {
                        thread.setPriority(n2);
                    }
                    return thread;
                }
            };
            LinkedBlockingQueue<Runnable> linkedBlockingQueue = new LinkedBlockingQueue<Runnable>(Integer.MAX_VALUE);
            Cq = new ThreadPoolExecutor(Cm, n2, Cn, TimeUnit.SECONDS, linkedBlockingQueue, threadFactory);
            ((ThreadPoolExecutor)Cq).setRejectedExecutionHandler(new RejectedExecutionHandler(){

                @Override
                public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
                    StackUtils.getRejectionExecutor().execute(runnable);
                }
            });
        }
        return Cq;
    }

    public static Integer getAsyncSelectorThreadPriority() {
        return Cu;
    }

    public static int getBlockingWorkerThreadPoolCoreSize() {
        return Cm;
    }

    public static long getBlockingWorkerThreadPoolTimeout() {
        return Cn;
    }

    public static Executor getBlockingWorkExecutor() {
        return StackUtils.createBlockingWorkExecutor("Blocking-Work-Executor", 256);
    }

    public static Integer getBlockingWorkExecutorThreadPriority() {
        return Cs;
    }

    public static synchronized Executor getNonBlockingWorkExecutor() {
        if (Cp == null) {
            final AtomicInteger atomicInteger = new AtomicInteger(0);
            ThreadFactory threadFactory = new ThreadFactory(){

                @Override
                public Thread newThread(Runnable runnable) {
                    Thread thread = new Thread(runnable, String.format(Locale.ROOT, NON_BLOCKING_WORK_EXECUTOR_NAME_PATTERN, atomicInteger.incrementAndGet()));
                    thread.setDaemon(true);
                    thread.setUncaughtExceptionHandler(Cy);
                    Integer n2 = StackUtils.getNonBlockingWorkExecutorThreadPriority();
                    if (n2 != null) {
                        thread.setPriority(n2);
                    }
                    return thread;
                }
            };
            LinkedBlockingQueue<Runnable> linkedBlockingQueue = new LinkedBlockingQueue<Runnable>(Integer.MAX_VALUE);
            RejectedExecutionHandler rejectedExecutionHandler = new RejectedExecutionHandler(){

                @Override
                public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
                    StackUtils.getBlockingWorkExecutor().execute(runnable);
                }
            };
            Cp = new ThreadPoolExecutor(Co, Co, 3L, TimeUnit.SECONDS, linkedBlockingQueue, threadFactory, rejectedExecutionHandler);
        }
        return Cp;
    }

    public static Integer getNonBlockingWorkExecutorThreadPriority() {
        return Ct;
    }

    public static synchronized Executor getRejectionExecutor() {
        if (Cr == null) {
            ThreadFactory threadFactory = new ThreadFactory(){

                @Override
                public Thread newThread(Runnable runnable) {
                    Thread thread = new Thread(runnable, "RejectedRunnableHanlder");
                    thread.setDaemon(true);
                    thread.setUncaughtExceptionHandler(Cy);
                    return thread;
                }
            };
            Cr = Executors.newSingleThreadExecutor(threadFactory);
        }
        return Cr;
    }

    public static UnsignedInteger getSecurityTokenLifetimeMax() {
        return Cx;
    }

    public static UnsignedInteger getSecurityTokenLifetimeMin() {
        return Cw;
    }

    public static AsyncSelector getSelector() {
        if (Cv == null) {
            try {
                Cv = new AsyncSelector(Selector.open());
            }
            catch (IOException iOException) {
                throw new Error(iOException);
            }
        }
        return Cv;
    }

    public static Thread.UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return Cy;
    }

    public static void logStatus() {
        StackUtils.a("BLOCKING_EXECUTOR", (ThreadPoolExecutor)Cq);
        StackUtils.a("NON_BLOCKING_EXECUTOR", (ThreadPoolExecutor)Cp);
    }

    public static ThreadFactory newNamedThreadFactory(String string) {
        return new a(string);
    }

    public static void setAsyncSelectorThreadPriority(Integer n2) {
        Cu = n2;
    }

    public static void setBlockingWorkerThreadPoolCoreSize(int n2) {
        Cm = n2;
    }

    public static void setBlockingWorkerThreadPoolTimeout(long l2) {
        Cn = l2;
    }

    public static void setBlockingWorkExecutorThreadPriority(Integer n2) {
        Cs = n2;
    }

    public static void setNonBlockingWorkExecutorThreadPriority(Integer n2) {
        Ct = n2;
    }

    public static void setSecurityTokenLifetimeMax(UnsignedInteger unsignedInteger) {
        if (unsignedInteger == null) {
            throw new IllegalArgumentException("The given value cannot be null");
        }
        Cx = unsignedInteger;
    }

    public static void setSecurityTokenLifetimeMin(UnsignedInteger unsignedInteger) {
        if (unsignedInteger == null) {
            throw new IllegalArgumentException("The given value cannot be null");
        }
        Cw = unsignedInteger;
    }

    public static void setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        Cy = uncaughtExceptionHandler;
    }

    public static void shutdown() {
        WeakReference<Timer> weakReference;
        Timer timer;
        if (Cq != null) {
            ((ThreadPoolExecutor)Cq).shutdown();
            Cq = null;
        }
        if (Cp != null) {
            ((ThreadPoolExecutor)Cp).shutdown();
            Cp = null;
        }
        if (Cr != null) {
            Cr.shutdown();
            Cr = null;
        }
        if (Cv != null) {
            try {
                Cv.close();
                Cv = null;
            }
            catch (IOException iOException) {
                logger.debug("SELECTOR.close failed", (Throwable)iOException);
            }
        }
        Timer timer2 = timer = (weakReference = TimerUtil.timer) == null ? null : (Timer)weakReference.get();
        if (timer != null) {
            timer.cancel();
            TimerUtil.timer = null;
        }
        MultiDimensionArrayUtils.Cc.clear();
    }

    public static ServiceResultException toServiceResultException(Exception exception) {
        if (exception instanceof ServiceResultException) {
            return (ServiceResultException)exception;
        }
        if (exception instanceof ClosedChannelException) {
            return new ServiceResultException(StatusCodes.Bad_ConnectionClosed, (Throwable)exception);
        }
        if (exception instanceof EOFException) {
            return new ServiceResultException(StatusCodes.Bad_ConnectionClosed, (Throwable)exception, "Connection closed (graceful)");
        }
        if (exception instanceof ConnectException) {
            return new ServiceResultException(StatusCodes.Bad_ConnectionRejected, (Throwable)exception);
        }
        if (exception instanceof SocketException) {
            return new ServiceResultException(StatusCodes.Bad_ConnectionClosed, (Throwable)exception, "Connection closed (unexpected)");
        }
        if (exception instanceof IOException) {
            return new ServiceResultException(StatusCodes.Bad_ConnectionClosed, (Throwable)exception);
        }
        return new ServiceResultException(exception);
    }

    private static void a(String string, ThreadPoolExecutor threadPoolExecutor) {
        logger.debug("{}: ActiveCount={} CompletedTaskCount={} PoolSize={} LargestPoolSize={} TaskCount={}", new Object[]{string, threadPoolExecutor.getActiveCount(), threadPoolExecutor.getCompletedTaskCount(), threadPoolExecutor.getPoolSize(), threadPoolExecutor.getLargestPoolSize(), threadPoolExecutor.getTaskCount()});
    }

    static {
        Cs = null;
        Ct = null;
        Cu = null;
        RANDOM = new Random();
        Cw = UnsignedInteger.getFromBits(600000);
        Cx = UnsignedInteger.getFromBits(3600000);
        NON_BLOCKING_WORK_EXECUTOR_NAME_PATTERN = "OPC-UA-Stack-Non-Blocking-Work-Executor-%d";
        BLOCKING_WORK_EXECUTOR_NAME_PATTERN = "OPC-UA-Stack-Blocking-Work-Executor-%d";
        UA_TIMER_NAME_PATTERN = "OPC-UA-Stack-Timer";
        SELECTOR_NAME_PATTERN = "OPC-UA-Stack-Async-Selector";
        Cy = new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable throwable) {
                logger.error("Uncaught Exception in Thread: {}", (Object)thread, (Object)throwable);
            }
        };
    }

    static class a
    implements ThreadFactory {
        static final AtomicInteger poolNumber = new AtomicInteger(1);
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix;

        a(String string) {
            this.namePrefix = string + "-pool-" + poolNumber.getAndIncrement() + "-thread-";
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable, this.namePrefix + this.threadNumber.getAndIncrement());
            if (thread.isDaemon()) {
                thread.setDaemon(false);
            }
            if (thread.getPriority() != 5) {
                thread.setPriority(5);
            }
            thread.setUncaughtExceptionHandler(Cy);
            return thread;
        }
    }
}

