/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.utils;

import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStructure
implements Structure {
    private static final Logger logger = LoggerFactory.getLogger(AbstractStructure.class);

    @Override
    public void clear() {
    }

    @Override
    public AbstractStructure clone() {
        try {
            return (AbstractStructure)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            logger.error("Got a CloneNotSupportedException, should be impossible", (Throwable)cloneNotSupportedException);
            throw new Error("Every Structure implementation shall be Cloneable", cloneNotSupportedException);
        }
    }

    @Override
    public Object get(String string) {
        return this.get(this.specification().getField(string));
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return null;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return null;
    }

    @Override
    public void set(String string, Object object) {
        this.set(this.specification().getField(string), object);
    }

    @Override
    public Map<String, Object> toFieldNamesMap() {
        LinkedHashMap linkedHashMap = new LinkedHashMap(this.specification().getFields().size());
        this.toFieldsMap().forEach((fieldSpecification, object) -> linkedHashMap.put(fieldSpecification.getName(), object));
        return Collections.unmodifiableMap(linkedHashMap);
    }

    @Override
    public Map<String, Object> toFieldNamesMap(StructureSpecification structureSpecification) {
        LinkedHashMap linkedHashMap = new LinkedHashMap(this.specification().getFields().size());
        this.toFieldsMap(structureSpecification).forEach((fieldSpecification, object) -> linkedHashMap.put(fieldSpecification.getName(), object));
        return Collections.unmodifiableMap(linkedHashMap);
    }

    @Override
    public Map<FieldSpecification, Object> toFieldsMap() {
        LinkedHashMap linkedHashMap = new LinkedHashMap(this.specification().getFields().size());
        this.specification().getFields().forEach(fieldSpecification -> linkedHashMap.put(fieldSpecification, this.get((FieldSpecification)fieldSpecification)));
        return Collections.unmodifiableMap(linkedHashMap);
    }

    @Override
    public Map<FieldSpecification, Object> toFieldsMap(StructureSpecification structureSpecification) {
        if (structureSpecification == null) {
            throw new IllegalArgumentException("The given other StructureSpecification cannot be null");
        }
        StructureSpecification structureSpecification2 = this.specification();
        if (structureSpecification2 == structureSpecification || structureSpecification2.getTypeId().equals(structureSpecification.getTypeId())) {
            return this.toFieldsMap();
        }
        boolean bl = this.specification().getSuperTypeIds().contains(structureSpecification.getTypeId());
        boolean bl2 = structureSpecification.getSuperTypeIds().contains(this.specification().getTypeId());
        if (!bl && !bl2) {
            throw new IllegalArgumentException("The given other StructureSpecification is not a super nor a subtype, this: " + this.specification().getTypeId() + ", other: " + structureSpecification.getTypeId());
        }
        Map<FieldSpecification, Object> map = this.toFieldsMap();
        HashMap hashMap = new HashMap();
        map.forEach((fieldSpecification, object) -> hashMap.put(fieldSpecification.getName(), object));
        LinkedHashMap linkedHashMap = new LinkedHashMap(structureSpecification.getFields().size());
        structureSpecification.getFields().forEach(fieldSpecification -> linkedHashMap.put(fieldSpecification, hashMap.get(fieldSpecification.getName())));
        return Collections.unmodifiableMap(linkedHashMap);
    }

    public String toString() {
        StructureSpecification structureSpecification = this.specification();
        if (structureSpecification == null) {
            logger.warn("StructureSpecification is null, cannot do toString properly");
            return super.toString();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(structureSpecification.getName());
        stringBuilder.append(" [");
        List<FieldSpecification> list = structureSpecification.getFields();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            FieldSpecification fieldSpecification = list.get(i2);
            stringBuilder.append(fieldSpecification.getName());
            stringBuilder.append("=\"");
            Object object = this.get(fieldSpecification);
            if (object == null) {
                stringBuilder.append("null");
            } else if (object.getClass().isArray()) {
                stringBuilder.append(Arrays.deepToString((Object[])object));
            } else {
                stringBuilder.append(object);
            }
            if (i2 == list.size() - 1) {
                stringBuilder.append("\"");
                continue;
            }
            stringBuilder.append("\", ");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    protected static abstract class Builder
    implements Structure.Builder {
        protected Builder() {
        }

        @Override
        public Builder clear() {
            return this;
        }

        @Override
        public Object get(String string) {
            return this.get(this.specification().getField(string));
        }

        @Override
        public Structure.Builder set(String string, Object object) {
            return this.set(this.specification().getField(string), object);
        }

        public String toString() {
            StructureSpecification structureSpecification = this.specification();
            if (structureSpecification == null) {
                logger.warn("StructureSpecification is null, cannot do toString properly");
                return super.toString();
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(structureSpecification.getName() + ".Builder");
            stringBuilder.append(" [");
            List<FieldSpecification> list = structureSpecification.getFields();
            for (int i2 = 0; i2 < list.size(); ++i2) {
                FieldSpecification fieldSpecification = list.get(i2);
                stringBuilder.append(fieldSpecification.getName());
                stringBuilder.append("=\"");
                if (fieldSpecification.getValueRank() > 1) {
                    stringBuilder.append(Arrays.deepToString((Object[])this.get(fieldSpecification)));
                } else if (fieldSpecification.getValueRank() == 1) {
                    stringBuilder.append(Arrays.toString((Object[])this.get(fieldSpecification)));
                } else {
                    stringBuilder.append(this.get(fieldSpecification));
                }
                if (i2 == list.size() - 1) {
                    stringBuilder.append("\"");
                    continue;
                }
                stringBuilder.append("\", ");
            }
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
    }
}

