/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.tcp.io;

import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.ServiceRequest;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.common.RuntimeServiceResultException;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.ChannelSecurityToken;
import com.prosysopc.ua.stack.core.CloseSecureChannelRequest;
import com.prosysopc.ua.stack.core.EndpointConfiguration;
import com.prosysopc.ua.stack.core.EndpointDescription;
import com.prosysopc.ua.stack.core.MessageSecurityMode;
import com.prosysopc.ua.stack.core.OpenSecureChannelRequest;
import com.prosysopc.ua.stack.core.OpenSecureChannelResponse;
import com.prosysopc.ua.stack.core.ResponseHeader;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.encoding.DecodingException;
import com.prosysopc.ua.stack.encoding.EncodeType;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.encoding.EncodingException;
import com.prosysopc.ua.stack.encoding.IEncodeable;
import com.prosysopc.ua.stack.encoding.binary.BinaryDecoder;
import com.prosysopc.ua.stack.encoding.binary.BinaryEncoder;
import com.prosysopc.ua.stack.transport.IConnectionListener;
import com.prosysopc.ua.stack.transport.ReverseConnectionListener;
import com.prosysopc.ua.stack.transport.ReverseTransportChannelSettings;
import com.prosysopc.ua.stack.transport.TransportChannelSettings;
import com.prosysopc.ua.stack.transport.UriUtil;
import com.prosysopc.ua.stack.transport.security.Cert;
import com.prosysopc.ua.stack.transport.security.CertificateValidator;
import com.prosysopc.ua.stack.transport.security.KeyPair;
import com.prosysopc.ua.stack.transport.security.PrivKey;
import com.prosysopc.ua.stack.transport.security.SecurityAlgorithm;
import com.prosysopc.ua.stack.transport.security.SecurityConfiguration;
import com.prosysopc.ua.stack.transport.security.SecurityMode;
import com.prosysopc.ua.stack.transport.security.SecurityPolicy;
import com.prosysopc.ua.stack.transport.tcp.impl.AbstractUaTcpCommMessage;
import com.prosysopc.ua.stack.transport.tcp.impl.Acknowledge;
import com.prosysopc.ua.stack.transport.tcp.impl.ChunkAsymmDecryptVerifier;
import com.prosysopc.ua.stack.transport.tcp.impl.ChunkAsymmEncryptSigner;
import com.prosysopc.ua.stack.transport.tcp.impl.ChunkFactory;
import com.prosysopc.ua.stack.transport.tcp.impl.ChunkSymmDecryptVerifier;
import com.prosysopc.ua.stack.transport.tcp.impl.ChunkSymmEncryptSigner;
import com.prosysopc.ua.stack.transport.tcp.impl.ChunkUtils;
import com.prosysopc.ua.stack.transport.tcp.impl.ErrorMessage;
import com.prosysopc.ua.stack.transport.tcp.impl.Hello;
import com.prosysopc.ua.stack.transport.tcp.impl.InternalBinaryEncodingsHelper;
import com.prosysopc.ua.stack.transport.tcp.impl.InternalClientSideDecodingServiceFault;
import com.prosysopc.ua.stack.transport.tcp.impl.ReverseHello;
import com.prosysopc.ua.stack.transport.tcp.impl.SecurityToken;
import com.prosysopc.ua.stack.transport.tcp.io.IConnection;
import com.prosysopc.ua.stack.transport.tcp.io.OpcTcpSettings;
import com.prosysopc.ua.stack.transport.tcp.io.SequenceNumber;
import com.prosysopc.ua.stack.transport.tcp.io.TcpConnectionLimits;
import com.prosysopc.ua.stack.transport.tcp.io.TcpQuotas;
import com.prosysopc.ua.stack.utils.CertificateUtils;
import com.prosysopc.ua.stack.utils.CryptoUtil;
import com.prosysopc.ua.stack.utils.SizeCalculationOutputStream;
import com.prosysopc.ua.stack.utils.StackUtils;
import com.prosysopc.ua.stack.utils.TimerUtil;
import com.prosysopc.ua.stack.utils.bytebuffer.ByteBufferArrayReadable;
import com.prosysopc.ua.stack.utils.bytebuffer.ByteBufferArrayWriteable2;
import com.prosysopc.ua.stack.utils.bytebuffer.InputStreamReadable;
import com.prosysopc.ua.stack.utils.bytebuffer.OutputStreamWriteable;
import com.prosysopc.ua.types.opcua.Ids;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpConnection
implements IConnection {
    static Logger logger = LoggerFactory.getLogger(TcpConnection.class);
    private static int zP = 0;
    private static int zQ = 60000;
    private static int zR = 0;
    private static int zS = 0;
    private static SocketFactory hi = new DefaultSocketFactory();
    private static ReverseConnectionProvider zT = new DefaultReverseConnectionProvider();
    private static ExecutorProvider zU = new DefaultExecutorProvider();
    EncodeType encodeType;
    PrivKey su;
    Cert st;
    Cert ss;
    EndpointConfiguration gs;
    EndpointDescription zV;
    CertificateValidator cF;
    InetSocketAddress addr;
    TcpConnectionLimits zW;
    TcpQuotas zX = TcpQuotas.DEFAULT_CLIENT_QUOTA;
    EnumSet<OpcTcpSettings.Flag> zs = EnumSet.noneOf(OpcTcpSettings.Flag.class);
    int connectTimeout = zQ;
    int zt = zQ;
    SecurityConfiguration securityConfiguration;
    final List<SecurityToken> zY = new CopyOnWriteArrayList<SecurityToken>();
    final Map<Integer, SecurityToken> zZ = new ConcurrentHashMap<Integer, SecurityToken>();
    final Map<Integer, ByteString> Aa = new ConcurrentHashMap<Integer, ByteString>();
    final Map<Integer, SequenceNumber> Ab = new ConcurrentHashMap<Integer, SequenceNumber>();
    private SocketWrapper Ac = null;
    int Ad;
    OutputStreamWriteable Ae;
    ReentrantLock lock = new ReentrantLock();
    b Af;
    EncoderContext ctx;
    List<IConnection.IMessageListener> listeners = new CopyOnWriteArrayList<IConnection.IMessageListener>();
    List<IConnectionListener> Ag = new CopyOnWriteArrayList<IConnectionListener>();
    ReverseConnectionListener he = null;
    boolean Ah = false;
    int zu = zR;
    private SocketFactory Ai;

    public static int getDefaultHandshakeTimeout() {
        return zQ;
    }

    public static int getDefaultReverseHelloAcceptTimeout() {
        return zR;
    }

    public static ExecutorProvider getExecutorProvider() {
        return zU;
    }

    public static int getReceiveBufferSize() {
        return zP;
    }

    public static ReverseConnectionProvider getReverseConnectionProvider() {
        return zT;
    }

    public static int getSendBufferSize() {
        return zS;
    }

    public static SocketFactory getSocketFactory() {
        return hi;
    }

    public static void setDefaultHandshakeTimeout(int n2) {
        zQ = n2;
    }

    public static void setDefaultReverseHelloAcceptTimeout(int n2) {
        zR = n2;
    }

    public static void setExecutorProvider(ExecutorProvider executorProvider) {
        zU = executorProvider;
    }

    public static void setReceiveBufferSize(int n2) {
        zP = n2;
    }

    public static void setReverseConnectionProvider(ReverseConnectionProvider reverseConnectionProvider) {
        zT = reverseConnectionProvider;
    }

    public static void setSendBufferSize(int n2) {
        zS = n2;
    }

    public static void setSocketFactory(SocketFactory socketFactory) {
        hi = socketFactory;
    }

    @Override
    public void addConnectionListener(IConnectionListener iConnectionListener) {
        this.Ag.add(iConnectionListener);
    }

    @Override
    public void addMessageListener(IConnection.IMessageListener iMessageListener) {
        this.listeners.add(iMessageListener);
    }

    @Override
    public void close() {
        b b2 = this.Af;
        if (b2 != null) {
            b2.Ap = true;
        }
        this.a(new ServiceResultException(StatusCodes.Bad_CommunicationError, "Socket closed by the user"));
    }

    @Override
    public void dispose() {
        this.lock.lock();
        try {
            this.close();
            this.su = null;
            this.st = null;
            this.ss = null;
            this.gs = null;
            this.zV = null;
            this.cF = null;
            this.setSocket(null);
            this.ctx = null;
            this.Ae = null;
            this.zX = null;
            this.zW = null;
        }
        finally {
            this.lock.unlock();
        }
    }

    public EndpointConfiguration getEndpointConfiguration() {
        return this.gs;
    }

    public EndpointDescription getEndpointDescription() {
        return this.zV;
    }

    public int getHandshakeTimeout() {
        return this.zt;
    }

    public EncoderContext getMessageContext() {
        return this.ctx;
    }

    public int getProtocolVersion() {
        return this.Ad;
    }

    public int getReverseHelloAcceptTimeout() {
        return this.zu;
    }

    public SocketAddress getSocketAddress() {
        return this.addr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize(InetSocketAddress inetSocketAddress, TransportChannelSettings transportChannelSettings, EncoderContext encoderContext) throws ServiceResultException {
        this.lock.lock();
        try {
            if (transportChannelSettings.getOpctcpSettings().getConnectTimeout() >= 0) {
                this.connectTimeout = transportChannelSettings.getOpctcpSettings().getConnectTimeout();
            }
            if (transportChannelSettings.getOpctcpSettings().getHandshakeTimeout() >= 0) {
                this.zt = transportChannelSettings.getOpctcpSettings().getHandshakeTimeout();
            }
            if (transportChannelSettings.getOpctcpSettings().getReverseHelloAcceptTimeout() >= 0) {
                this.zu = transportChannelSettings.getOpctcpSettings().getReverseHelloAcceptTimeout();
            }
            this.addr = inetSocketAddress;
            if (transportChannelSettings instanceof ReverseTransportChannelSettings) {
                this.he = ((ReverseTransportChannelSettings)transportChannelSettings).getReverseConnectionListener();
                this.Ah = true;
            } else {
                this.he = null;
                this.Ah = false;
                this.Ai = transportChannelSettings.getOpctcpSettings().getSocketFactory();
            }
            this.gs = transportChannelSettings.getConfiguration().clone();
            this.zV = transportChannelSettings.getDescription().clone();
            this.cF = transportChannelSettings.getOpctcpSettings().getCertificateValidator();
            this.ctx = encoderContext;
            this.st = transportChannelSettings.getOpctcpSettings().getClientCertificate();
            this.ss = transportChannelSettings.getServerCertificate();
            this.su = transportChannelSettings.getOpctcpSettings().getPrivKey();
            this.encodeType = EncodeType.Binary;
            if (this.gs.getUseBinaryEncoding() != null && !this.gs.getUseBinaryEncoding().booleanValue()) {
                this.encodeType = EncodeType.Xml;
            }
            this.zs = transportChannelSettings.getOpctcpSettings().getFlags();
            KeyPair keyPair = this.st == null ? null : new KeyPair(this.st, this.su);
            SecurityPolicy securityPolicy = SecurityPolicy.getSecurityPolicy(this.zV.getSecurityPolicyUri());
            SecurityMode securityMode = new SecurityMode(securityPolicy, this.zV.getSecurityMode());
            this.securityConfiguration = new SecurityConfiguration(securityMode, keyPair, this.ss);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void initialize(String string, TransportChannelSettings transportChannelSettings, EncoderContext encoderContext) throws ServiceResultException {
        try {
            InetSocketAddress inetSocketAddress = UriUtil.getSocketAddress(string);
            this.initialize(inetSocketAddress, transportChannelSettings, encoderContext);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.error("Error while TcpConnection.initialize", (Throwable)illegalArgumentException);
            throw new ServiceResultException(StatusCodes.Bad_ServerUriInvalid);
        }
    }

    public void initialize(TransportChannelSettings transportChannelSettings, EncoderContext encoderContext) throws ServiceResultException {
        this.initialize(transportChannelSettings.getDescription().getEndpointUrl(), transportChannelSettings, encoderContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() throws ServiceResultException {
        this.lock.lock();
        try {
            SocketWrapper socketWrapper = this.getSocket();
            if (socketWrapper != null && socketWrapper.isConnected()) {
                return;
            }
            if (!this.Ah) {
                try {
                    logger.info("{} Connecting", (Object)this.addr);
                    socketWrapper = this.Ai != null ? this.Ai.createSocket(this) : hi.createSocket(this);
                    socketWrapper.setTcpNoDelay(true);
                    if (zP > 0) {
                        socketWrapper.setReceiveBufferSize(zP);
                    }
                    if (zS > 0) {
                        socketWrapper.setSendBufferSize(zS);
                    }
                    this.setSocket(socketWrapper);
                    if (this.zt > 0) {
                        socketWrapper.setSoTimeout(this.zt);
                    }
                    if (this.connectTimeout == 0) {
                        socketWrapper.connect(this.addr);
                    } else {
                        socketWrapper.connect(this.addr, this.connectTimeout);
                    }
                }
                catch (ConnectException connectException) {
                    logger.info(this.addr + " Connect failed", (Throwable)connectException);
                    throw new ServiceResultException(StatusCodes.Bad_ConnectionRejected, (Throwable)connectException);
                }
                catch (IOException iOException) {
                    logger.info(this.addr + " Connect failed", (Throwable)iOException);
                    throw new ServiceResultException(StatusCodes.Bad_ConnectionRejected, (Throwable)iOException);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new ServiceResultException(StatusCodes.Bad_ServerUriInvalid);
                }
                logger.debug("{} Socket connected", (Object)this.addr);
            } else {
                try {
                    try {
                        socketWrapper = zT.provideOpenReverseConnectionSocket(this);
                    }
                    catch (SocketException socketException) {
                        logger.info("ServerSocket.accept {} failed (or the socket was closed while waiting)", (Object)this.addr, (Object)socketException);
                        throw new ServiceResultException(StatusCodes.Bad_UnexpectedError, (Throwable)socketException, "ServerSocket.accept failed (or was closed, possibly due to a timeout)");
                    }
                    socketWrapper.setTcpNoDelay(true);
                    if (zP > 0) {
                        socketWrapper.setReceiveBufferSize(zP);
                    }
                    if (zS > 0) {
                        socketWrapper.setSendBufferSize(zS);
                    }
                    if (this.zt > 0) {
                        socketWrapper.setSoTimeout(this.zt);
                    }
                    this.setSocket(socketWrapper);
                    logger.debug("{} Socket connected", (Object)socketWrapper.getRemoteSocketAddress());
                }
                catch (IOException iOException) {
                    logger.info(this.addr + " Connect failed", (Throwable)iOException);
                    throw new ServiceResultException(StatusCodes.Bad_ConnectionRejected, (Throwable)iOException);
                }
            }
            try {
                AbstractUaTcpCommMessage abstractUaTcpCommMessage;
                this.etF();
                OutputStreamWriteable outputStreamWriteable = new OutputStreamWriteable(new BufferedOutputStream(socketWrapper.getOutputStream()));
                outputStreamWriteable.order(ByteOrder.LITTLE_ENDIAN);
                InputStreamReadable inputStreamReadable = new InputStreamReadable(new BufferedInputStream(socketWrapper.getInputStream()), Long.MAX_VALUE);
                inputStreamReadable.order(ByteOrder.LITTLE_ENDIAN);
                BinaryDecoder binaryDecoder = new BinaryDecoder(inputStreamReadable);
                binaryDecoder.setEncoderContext(this.ctx);
                BinaryEncoder binaryEncoder = new BinaryEncoder(outputStreamWriteable);
                binaryEncoder.setEncoderContext(this.ctx);
                if (this.Ah) {
                    abstractUaTcpCommMessage = this.a(inputStreamReadable, binaryDecoder);
                    logger.debug("Got ReverseHello: {}", (Object)abstractUaTcpCommMessage);
                    if (((ReverseHello)abstractUaTcpCommMessage).getServerUri() == null || ((ReverseHello)abstractUaTcpCommMessage).getServerUri().length() > 4096) {
                        logger.error("ReverseHello did not contain ServerUri, or is too long, got:{}", (Object)((ReverseHello)abstractUaTcpCommMessage).getServerUri());
                        throw new ServiceResultException(StatusCodes.Bad_TcpEndpointUrlInvalid);
                    }
                    if (((ReverseHello)abstractUaTcpCommMessage).getEndpointUrl() == null || ((ReverseHello)abstractUaTcpCommMessage).getEndpointUrl().length() > 4096) {
                        logger.error("ReverseHello did not contain correct EndpointUrl, or is too long, got:{}", (Object)((ReverseHello)abstractUaTcpCommMessage).getEndpointUrl());
                        throw new ServiceResultException(StatusCodes.Bad_TcpEndpointUrlInvalid);
                    }
                    if (this.he != null && !this.he.onConnect(((ReverseHello)abstractUaTcpCommMessage).getServerUri(), ((ReverseHello)abstractUaTcpCommMessage).getEndpointUrl(), socketWrapper.getRemoteSocketAddress())) {
                        throw new ServiceResultException(StatusCodes.Bad_ConnectionClosed, "Reverse Connection rejected by the ReverseConnectionListener");
                    }
                    if (this.zV.getEndpointUrl() == null) {
                        this.zV.setEndpointUrl(((ReverseHello)abstractUaTcpCommMessage).getEndpointUrl());
                    }
                }
                abstractUaTcpCommMessage = new Hello();
                ((Hello)abstractUaTcpCommMessage).setEndpointUrl(this.zV.getEndpointUrl());
                ((Hello)abstractUaTcpCommMessage).setMaxChunkCount(UnsignedInteger.valueOf(this.gs.getMaxBufferSize() == null ? 65535L : (long)this.gs.getMaxBufferSize().intValue()));
                ((Hello)abstractUaTcpCommMessage).setMaxMessageSize(UnsignedInteger.valueOf(this.ctx.getMaxMessageSize()));
                ((Hello)abstractUaTcpCommMessage).setReceiveBufferSize(UnsignedInteger.valueOf(this.zX.maxBufferSize));
                ((Hello)abstractUaTcpCommMessage).setSendBufferSize(UnsignedInteger.valueOf(this.zX.maxBufferSize));
                ((Hello)abstractUaTcpCommMessage).setProtocolVersion(UnsignedInteger.valueOf(0L));
                if (this.zW != null) {
                    ((Hello)abstractUaTcpCommMessage).setProtocolVersion(UnsignedInteger.valueOf(this.Ad));
                    ((Hello)abstractUaTcpCommMessage).setMaxChunkCount(UnsignedInteger.valueOf(this.zW.maxRecvChunkCount));
                    ((Hello)abstractUaTcpCommMessage).setMaxMessageSize(UnsignedInteger.valueOf(this.zW.maxRecvMessageSize));
                    ((Hello)abstractUaTcpCommMessage).setSendBufferSize(UnsignedInteger.valueOf(this.zW.maxSendBufferSize));
                    ((Hello)abstractUaTcpCommMessage).setReceiveBufferSize(UnsignedInteger.valueOf(this.zW.maxRecvBufferSize));
                }
                logger.debug("Writing Hello: {}", (Object)abstractUaTcpCommMessage);
                SizeCalculationOutputStream sizeCalculationOutputStream = new SizeCalculationOutputStream();
                BinaryEncoder binaryEncoder2 = new BinaryEncoder(sizeCalculationOutputStream);
                binaryEncoder2.setEncoderContext(this.ctx);
                outputStreamWriteable.putInt(1179403592);
                InternalBinaryEncodingsHelper.putUaTcpCommMessage(binaryEncoder2, abstractUaTcpCommMessage);
                int n2 = sizeCalculationOutputStream.getLength() + 8;
                outputStreamWriteable.putInt(n2);
                InternalBinaryEncodingsHelper.putUaTcpCommMessage(binaryEncoder, abstractUaTcpCommMessage);
                outputStreamWriteable.flush();
                int n3 = -1;
                while (n3 == -1) {
                    try {
                        n3 = inputStreamReadable.getInt();
                    }
                    catch (EOFException eOFException) {
                        n3 = inputStreamReadable.getInt();
                    }
                }
                n2 = inputStreamReadable.getInt();
                if (n2 < 8 || n2 > 4096) {
                    throw new ServiceResultException(StatusCodes.Bad_TcpMessageTooLarge);
                }
                if (n3 == 1179800133) {
                    binaryDecoder.getEncoderContext().setMaxStringLength(4096);
                    ErrorMessage errorMessage = InternalBinaryEncodingsHelper.getUaTcpCommMessage(binaryDecoder, ErrorMessage.class);
                    throw new ServiceResultException(StatusCode.valueOf(errorMessage.getError()), errorMessage.getReason());
                }
                if (n3 != 1179337537) {
                    throw new ServiceResultException(StatusCodes.Bad_TcpMessageTypeInvalid, "Message type was " + n3 + ", expected " + 1179337537);
                }
                Acknowledge acknowledge = InternalBinaryEncodingsHelper.getUaTcpCommMessage(binaryDecoder, Acknowledge.class);
                logger.debug("Received Acknowledge: {}", (Object)acknowledge);
                if (acknowledge.getProtocolVersion().intValue() < ((Hello)abstractUaTcpCommMessage).getProtocolVersion().intValue()) {
                    throw new ServiceResultException(StatusCodes.Bad_ProtocolVersionUnsupported, "Version " + ((Hello)abstractUaTcpCommMessage).getProtocolVersion().intValue() + " requested, got " + acknowledge.getProtocolVersion());
                }
                this.Ad = Math.min(((Hello)abstractUaTcpCommMessage).getProtocolVersion().intValue(), acknowledge.getProtocolVersion().intValue());
                if (acknowledge.getMaxMessageSize().equals(UnsignedInteger.valueOf(0L))) {
                    acknowledge.setMaxMessageSize(UnsignedInteger.valueOf(Integer.MAX_VALUE));
                }
                if (acknowledge.getMaxChunkCount().equals(UnsignedInteger.valueOf(0L))) {
                    acknowledge.setMaxChunkCount(UnsignedInteger.valueOf(Integer.MAX_VALUE));
                }
                if (acknowledge.getReceiveBufferSize().longValue() > ((Hello)abstractUaTcpCommMessage).getReceiveBufferSize().longValue()) {
                    throw new ServiceResultException(StatusCodes.Bad_TcpInternalError, "Acknowledge.ReceiveBufferSize > Hello.ReceiveBufferSize");
                }
                if (acknowledge.getReceiveBufferSize().longValue() < 8192L) {
                    throw new ServiceResultException(StatusCodes.Bad_TcpInternalError, "Server recv buffer size < 8192");
                }
                if (acknowledge.getSendBufferSize().longValue() > ((Hello)abstractUaTcpCommMessage).getSendBufferSize().longValue()) {
                    throw new ServiceResultException(StatusCodes.Bad_TcpInternalError, "Acknowledge.SendBufferSize > Hello.SendBufferSize");
                }
                if (acknowledge.getSendBufferSize().longValue() < 8192L) {
                    throw new ServiceResultException(StatusCodes.Bad_TcpInternalError, "Server send buffer size < 8192");
                }
                this.zW = new TcpConnectionLimits();
                this.zW.maxSendBufferSize = (int)Math.min(acknowledge.getSendBufferSize().longValue(), Integer.MAX_VALUE);
                this.zW.maxRecvBufferSize = (int)Math.min(acknowledge.getReceiveBufferSize().longValue(), Integer.MAX_VALUE);
                this.zW.maxSendChunkCount = (int)Math.min(acknowledge.getMaxChunkCount().longValue(), Integer.MAX_VALUE);
                this.zW.maxRecvChunkCount = (int)Math.min(((Hello)abstractUaTcpCommMessage).getMaxChunkCount().longValue(), Integer.MAX_VALUE);
                this.zW.maxSendMessageSize = (int)Math.min(acknowledge.getMaxMessageSize().longValue(), Integer.MAX_VALUE);
                this.zW.maxRecvMessageSize = (int)Math.min(((Hello)abstractUaTcpCommMessage).getMaxMessageSize().longValue(), Integer.MAX_VALUE);
                socketWrapper.setSoTimeout(0);
                socketWrapper.setKeepAlive(true);
                if (this.Ah) {
                    logger.info("Connected (reverse), handshake completed, local={}, remote={}", (Object)socketWrapper.getLocalSocketAddress(), (Object)socketWrapper.getRemoteSocketAddress());
                } else {
                    logger.info("Connected (non-reverse), handshake completed, local={}, remote={}", (Object)socketWrapper.getLocalSocketAddress(), (Object)socketWrapper.getRemoteSocketAddress());
                }
                for (IConnectionListener iConnectionListener : this.Ag) {
                    iConnectionListener.onOpen();
                }
                logger.debug("Creating ReadThread");
                this.Af = new b(socketWrapper, binaryDecoder.getEncoderContext());
                this.Af.start();
                this.ctx = binaryEncoder.getEncoderContext();
                this.Ae = outputStreamWriteable;
            }
            catch (IOException iOException) {
                try {
                    socketWrapper.close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                this.setSocket(null);
                logger.info(this.addr + " Connect failed", (Throwable)iOException);
                throw new ServiceResultException(StatusCodes.Bad_CommunicationError, (Throwable)iOException);
            }
            catch (ServiceResultException serviceResultException) {
                try {
                    socketWrapper.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.setSocket(null);
                logger.info(this.addr + " Connect failed", (Throwable)serviceResultException);
                throw serviceResultException;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void reconnect() throws ServiceResultException {
        this.lock.lock();
        try {
            SocketWrapper socketWrapper = this.getSocket();
            if (socketWrapper != null && socketWrapper.isConnected() && !socketWrapper.isClosed()) {
                this.close();
            }
            this.open();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void removeConnectionListener(IConnectionListener iConnectionListener) {
        this.Ag.remove(iConnectionListener);
    }

    @Override
    public void removeMessageListener(IConnection.IMessageListener iMessageListener) {
        this.listeners.remove(iMessageListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendRequest(ServiceRequest serviceRequest, int n2, int n3) throws ServiceResultException {
        block16: {
            if (serviceRequest == null) {
                logger.warn("sendRequest: request=null");
            }
            boolean bl = serviceRequest instanceof OpenSecureChannelRequest;
            SocketWrapper socketWrapper = this.getSocket();
            logger.debug("sendRequest: socket={}", (Object)socketWrapper);
            try {
                ByteBuffer[] byteBufferArray;
                ByteBuffer[] byteBufferArray2;
                a a2;
                if (socketWrapper == null || !socketWrapper.isConnected() || socketWrapper.isClosed()) {
                    throw new ServiceResultException(StatusCodes.Bad_ServerNotConnected);
                }
                logger.debug("sendRequest: {} Sending Request rid:{}", (Object)n2, (Object)n3);
                logger.trace("sendrequest: request={}", (Object)serviceRequest);
                SecurityToken securityToken = null;
                SizeCalculationOutputStream sizeCalculationOutputStream = new SizeCalculationOutputStream();
                BinaryEncoder binaryEncoder = new BinaryEncoder(sizeCalculationOutputStream);
                binaryEncoder.setEncoderContext(this.ctx);
                InternalBinaryEncodingsHelper.putServiceRequest(binaryEncoder, serviceRequest);
                int n4 = sizeCalculationOutputStream.getLength();
                if (n2 != 0) {
                    securityToken = this.v(n2);
                }
                logger.debug("sendRequest: token={}", (Object)securityToken);
                SecurityMode securityMode = this.a(bl, serviceRequest, securityToken);
                int n5 = securityToken != null ? securityToken.getSecurityPolicy().getEncryptionKeySize() : 0;
                logger.debug("sendRequest: keySize={}", (Object)n5);
                ChunkFactory chunkFactory = this.a(bl, securityMode, n5);
                if (chunkFactory == null || (a2 = this.a(chunkFactory, n4, serviceRequest)) == null || !((byteBufferArray2 = a2.etH()) != null & (byteBufferArray = a2.etI()) != null)) break block16;
                try {
                    this.lock.lock();
                    try {
                        if (bl) {
                            ByteString byteString = ((OpenSecureChannelRequest)serviceRequest).getClientNonce();
                            this.Aa.put(n3, byteString);
                            for (int i2 = 0; i2 < byteBufferArray2.length; ++i2) {
                                boolean bl2 = i2 == byteBufferArray2.length - 1;
                                this.a(n2, n3, securityMode, byteBufferArray2[i2], byteBufferArray[i2], bl2);
                                byteBufferArray[i2] = null;
                                byteBufferArray2[i2] = null;
                            }
                        } else {
                            this.zZ.put(n2, securityToken);
                            SequenceNumber sequenceNumber = this.Ab.get(n2);
                            for (int i3 = 0; i3 < byteBufferArray2.length; ++i3) {
                                ByteBuffer byteBuffer = byteBufferArray2[i3];
                                ByteBuffer byteBuffer2 = byteBufferArray[i3];
                                boolean bl3 = byteBuffer == byteBufferArray2[byteBufferArray2.length - 1];
                                int n6 = 1128747853;
                                if (bl3) {
                                    n6 = 1179079501;
                                }
                                if (serviceRequest instanceof CloseSecureChannelRequest) {
                                    n6 = 1179601987;
                                }
                                this.a(n3, securityToken, sequenceNumber, byteBuffer, byteBuffer2, n6);
                                byteBufferArray[i3] = null;
                                byteBufferArray2[i3] = null;
                            }
                        }
                        this.Ae.flush();
                    }
                    catch (IOException iOException) {
                        this.Aa.remove(n3);
                        logger.info(this.addr + " Connect failed", (Throwable)iOException);
                        this.close();
                        throw new ServiceResultException(StatusCodes.Bad_CommunicationError, (Throwable)iOException);
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
            catch (RuntimeException runtimeException) {
                logger.warn(String.format(Locale.ROOT, "sendRequest %s failed: socket=%s, asymm=%s", serviceRequest.getClass().getName(), socketWrapper, bl), (Throwable)runtimeException);
                throw runtimeException;
            }
        }
    }

    public void setHandshakeTimeout(int n2) {
        this.zt = n2;
    }

    public void setReverseHelloAcceptTimeout(int n2) {
        this.zu = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(ServiceResultException serviceResultException) {
        this.lock.lock();
        try {
            SocketWrapper socketWrapper = this.getSocket();
            if (socketWrapper == null || !socketWrapper.isConnected() || socketWrapper.isClosed()) {
                return;
            }
            try {
                socketWrapper.close();
            }
            catch (IOException iOException) {
                logger.warn(this.addr + " Close error", (Throwable)iOException);
            }
            this.setSocket(null);
            this.Aa.clear();
            logger.info(this.addr + " Closed");
        }
        finally {
            this.lock.unlock();
        }
        for (IConnectionListener iConnectionListener : this.Ag) {
            iConnectionListener.onClosed(serviceResultException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private a a(ChunkFactory chunkFactory, int n2, ServiceRequest<?> serviceRequest) throws ServiceResultException {
        int n3;
        if (this.ctx.getMaxMessageSize() != 0 && n2 > this.ctx.getMaxMessageSize()) {
            EncodingException encodingException = new EncodingException(StatusCodes.Bad_EncodingLimitsExceeded, "MaxMessageSize " + this.ctx.getMaxMessageSize() + " < " + n2);
            logger.warn("encodeMessage: failed", (Throwable)encodingException);
            throw encodingException;
        }
        int n4 = (n2 + chunkFactory.maxPlaintextSize - 1) / chunkFactory.maxPlaintextSize;
        this.lock.lock();
        try {
            if (this.zW == null) {
                a a2 = null;
                return a2;
            }
            n3 = this.zW.maxSendChunkCount;
        }
        finally {
            this.lock.unlock();
        }
        if (n3 != 0 && n4 > n3) {
            throw new ServiceResultException(StatusCodes.Bad_TcpMessageTooLarge);
        }
        int n5 = n2;
        ByteBuffer[] byteBufferArray = new ByteBuffer[n4];
        ByteBuffer[] byteBufferArray2 = new ByteBuffer[n4];
        for (int i2 = 0; i2 < n4; ++i2) {
            byteBufferArray[i2] = chunkFactory.allocate(n5);
            byteBufferArray2[i2] = chunkFactory.expandToCompleteChunk(byteBufferArray[i2]);
            n5 -= byteBufferArray[i2].remaining();
        }
        ByteBufferArrayWriteable2.ChunkListener chunkListener = new ByteBufferArrayWriteable2.ChunkListener(){

            @Override
            public void onChunkComplete(ByteBuffer[] byteBufferArray, int n2) {
            }
        };
        ByteBufferArrayWriteable2 byteBufferArrayWriteable2 = new ByteBufferArrayWriteable2(byteBufferArray, chunkListener);
        byteBufferArrayWriteable2.order(ByteOrder.LITTLE_ENDIAN);
        BinaryEncoder binaryEncoder = new BinaryEncoder(byteBufferArrayWriteable2);
        binaryEncoder.setEncoderContext(this.ctx);
        InternalBinaryEncodingsHelper.putServiceRequest(binaryEncoder, serviceRequest);
        return new a(byteBufferArray2, byteBufferArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChunkFactory a(boolean bl, SecurityMode securityMode, int n2) throws ServiceResultException {
        int n3;
        MessageSecurityMode messageSecurityMode = securityMode.getMessageSecurityMode();
        this.lock.lock();
        try {
            if (this.zW == null) {
                ChunkFactory chunkFactory = null;
                return chunkFactory;
            }
            n3 = this.zW.maxSendBufferSize;
        }
        finally {
            this.lock.unlock();
        }
        if (bl) {
            return new ChunkFactory.AsymmMsgChunkFactory(n3, this.securityConfiguration);
        }
        SecurityPolicy securityPolicy = securityMode.getSecurityPolicy();
        SecurityAlgorithm securityAlgorithm = securityPolicy.getSymmetricEncryptionAlgorithm();
        SecurityAlgorithm securityAlgorithm2 = securityPolicy.getSymmetricSignatureAlgorithm();
        int n4 = CryptoUtil.getCipherBlockSize(securityAlgorithm, null);
        int n5 = CryptoUtil.getSignatureSize(securityAlgorithm2, null);
        return new ChunkFactory(n3, 8, 8, 8, n5, n4, messageSecurityMode, n2);
    }

    private SecurityMode a(boolean bl, ServiceRequest<?> serviceRequest, SecurityToken securityToken) {
        SecurityPolicy securityPolicy;
        MessageSecurityMode messageSecurityMode;
        if (bl) {
            messageSecurityMode = ((OpenSecureChannelRequest)serviceRequest).getSecurityMode();
            securityPolicy = this.securityConfiguration.getSecurityMode().getSecurityPolicy();
        } else {
            messageSecurityMode = securityToken.getMessageSecurityMode();
            securityPolicy = securityToken.getSecurityPolicy();
        }
        return new SecurityMode(securityPolicy, messageSecurityMode);
    }

    private SecurityToken v(int n2) throws ServiceResultException {
        this.ett();
        SecurityToken securityToken = null;
        logger.debug("tokens={}", this.zY);
        for (SecurityToken securityToken2 : this.zY) {
            if (securityToken2.getSecureChannelId() != n2 || securityToken != null && securityToken.getCreationTime() >= securityToken2.getCreationTime()) continue;
            securityToken = securityToken2;
        }
        logger.debug("getSecurityTokenToUse={}", securityToken);
        if (securityToken == null) {
            throw new ServiceResultException(StatusCodes.Bad_CommunicationError, "All security tokens have expired");
        }
        return securityToken;
    }

    private void etF() {
        int n2 = Math.min(this.gs.getMaxMessageSize() != null ? this.gs.getMaxMessageSize() : Integer.MAX_VALUE, this.zX.maxMessageSize);
        this.ctx.setMaxMessageSize(n2);
        this.ctx.setMaxArrayLength(this.gs.getMaxArrayLength() != null ? this.gs.getMaxArrayLength() : 0);
        this.ctx.setMaxStringLength(this.gs.getMaxStringLength() != null ? this.gs.getMaxStringLength() : 0);
        this.ctx.setMaxByteStringLength(this.gs.getMaxByteStringLength() != null ? this.gs.getMaxByteStringLength() : 0);
    }

    private void ett() {
        logger.debug("pruneInvalidTokens: tokens({})={}", (Object)this.zY.size(), this.zY);
        for (SecurityToken securityToken : this.zY) {
            if (securityToken.isValid()) continue;
            this.zY.remove(securityToken);
        }
    }

    private ReverseHello a(InputStreamReadable inputStreamReadable, BinaryDecoder binaryDecoder) throws IOException, ServiceResultException, DecodingException {
        int n2 = -1;
        while (n2 == -1) {
            try {
                n2 = inputStreamReadable.getInt();
            }
            catch (EOFException eOFException) {
                n2 = inputStreamReadable.getInt();
            }
        }
        int n3 = inputStreamReadable.getInt();
        if (n3 < 8 || n3 > 4096) {
            throw new ServiceResultException(StatusCodes.Bad_TcpMessageTooLarge);
        }
        if (n2 != 1178945618) {
            logger.error("Did not receive correct message type, expecting: {}, got: {}", (Object)1178945618, (Object)n2);
            throw new ServiceResultException(StatusCodes.Bad_TcpMessageTypeInvalid, "Message type was " + n2 + ", expected " + 1178945618);
        }
        ReverseHello reverseHello = InternalBinaryEncodingsHelper.getUaTcpCommMessage(binaryDecoder, ReverseHello.class);
        return reverseHello;
    }

    private void a(int n2, int n3, SecurityMode securityMode, ByteBuffer byteBuffer, ByteBuffer byteBuffer2, boolean bl) throws ServiceResultException, IOException {
        SequenceNumber sequenceNumber;
        byteBuffer.rewind();
        byteBuffer.putInt(bl ? 1179537487 : 1129205839);
        byteBuffer.position(8);
        byteBuffer.putInt(n2);
        byte[] byArray = securityMode.getSecurityPolicy().getEncodedPolicyUri();
        byteBuffer.putInt(byArray.length);
        byteBuffer.put(byArray);
        byArray = this.securityConfiguration.getEncodedLocalCertificate();
        byteBuffer.putInt(byArray == null ? -1 : byArray.length);
        if (byArray != null) {
            byteBuffer.put(byArray);
        }
        byteBuffer.putInt((byArray = this.securityConfiguration.getEncodedRemoteCertificateThumbprint()) == null ? -1 : byArray.length);
        if (byArray != null) {
            byteBuffer.put(byArray);
        }
        int n4 = (sequenceNumber = this.Ab.get(n2)) == null ? 1 : sequenceNumber.getNextSendSequencenumber();
        byteBuffer.putInt(n4);
        byteBuffer.putInt(n3);
        logger.debug("SecureChannelId={} SequenceNumber={}, RequestId={}", new Object[]{n2, n4, n3});
        try {
            new ChunkAsymmEncryptSigner(byteBuffer, byteBuffer2, this.securityConfiguration).run();
        }
        catch (RuntimeServiceResultException runtimeServiceResultException) {
            throw runtimeServiceResultException.getCause();
        }
        byteBuffer.rewind();
        this.Ae.put(byteBuffer);
    }

    private void a(int n2, SecurityToken securityToken, SequenceNumber sequenceNumber, ByteBuffer byteBuffer, ByteBuffer byteBuffer2, int n3) throws ServiceResultException, IOException {
        byteBuffer.rewind();
        byteBuffer.putInt(n3);
        byteBuffer.position(8);
        byteBuffer.putInt(securityToken.getSecureChannelId());
        byteBuffer.putInt(securityToken.getTokenId());
        int n4 = sequenceNumber.getNextSendSequencenumber();
        byteBuffer.putInt(n4);
        byteBuffer.putInt(n2);
        try {
            new ChunkSymmEncryptSigner(byteBuffer, byteBuffer2, securityToken).run();
        }
        catch (RuntimeServiceResultException runtimeServiceResultException) {
            throw runtimeServiceResultException.getCause();
        }
        byteBuffer.rewind();
        this.Ae.put(byteBuffer);
    }

    protected SocketWrapper getSocket() {
        this.lock.lock();
        try {
            SocketWrapper socketWrapper = this.Ac;
            return socketWrapper;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void setSocket(SocketWrapper socketWrapper) {
        this.Ac = socketWrapper;
    }

    class b
    extends Thread {
        SocketWrapper Ao;
        EncoderContext ctx;
        ServiceResultException lT;
        boolean Ap;

        b(SocketWrapper socketWrapper, EncoderContext encoderContext) {
            super("TcpConnection/Read");
            this.lT = null;
            this.Ap = false;
            this.setDaemon(true);
            this.Ao = socketWrapper;
            this.ctx = encoderContext;
        }

        @Override
        public void run() {
            block48: {
                try {
                    InputStreamReadable inputStreamReadable = new InputStreamReadable(new BufferedInputStream(this.Ao.getInputStream()), Long.MAX_VALUE);
                    inputStreamReadable.order(ByteOrder.LITTLE_ENDIAN);
                    ArrayList<ByteBuffer> arrayList = new ArrayList<ByteBuffer>(256);
                    while (this.Ao == TcpConnection.this.getSocket()) {
                        int n2;
                        Object object;
                        Object object2;
                        Object object3;
                        Object object4;
                        Object object5;
                        int n3;
                        arrayList.clear();
                        int n4 = 0;
                        int n5 = 0;
                        int n6 = 0;
                        int n7 = 0;
                        int n8 = 0;
                        do {
                            Object object6;
                            if (n5 > TcpConnection.this.zW.maxRecvChunkCount) {
                                this.lT = new ServiceResultException("Recv chunk count exceeded (max = " + n5 + ")");
                                logger.warn("{} Recv chunk count exceeded (max = {})", (Object)TcpConnection.this.addr, (Object)n5);
                                break block48;
                            }
                            int n9 = inputStreamReadable.getInt();
                            n3 = n9 & 0xFFFFFF;
                            n6 = n9 & 0xFF000000;
                            if (n5 == 0) {
                                n4 = n3;
                            } else if (n3 != n4) {
                                this.lT = new ServiceResultException("Error, message type changed between chunks");
                                logger.warn("{} Error, message type changed between chunks", (Object)TcpConnection.this.addr);
                                break block48;
                            }
                            if (n3 != 5132367 && n3 != 4674381 && n9 != 1179800133) {
                                this.lT = new ServiceResultException("Error, unknown message type " + String.format(Locale.ROOT, "0x%08x", n9));
                                logger.warn("{} Error, unknown message type {}", (Object)TcpConnection.this.addr, (Object)String.format(Locale.ROOT, "0x%08x", n9));
                                break block48;
                            }
                            int n10 = inputStreamReadable.getInt();
                            if (n10 > TcpConnection.this.zW.maxRecvBufferSize) {
                                this.lT = new ServiceResultException("Error, chunk too large (max = " + TcpConnection.this.zW.maxRecvBufferSize + ")");
                                logger.warn("{} Error, chunk too large (max = {})", (Object)TcpConnection.this.addr, (Object)TcpConnection.this.zW.maxRecvBufferSize);
                                break block48;
                            }
                            object5 = ByteBuffer.allocate(n10);
                            ((ByteBuffer)object5).order(ByteOrder.LITTLE_ENDIAN);
                            ((ByteBuffer)object5).putInt(n9);
                            ((ByteBuffer)object5).putInt(n10);
                            inputStreamReadable.get((ByteBuffer)object5, n10 - 8);
                            if (n9 == 1179800133) {
                                ServiceResultException serviceResultException;
                                ((ByteBuffer)object5).position(8);
                                BinaryDecoder binaryDecoder = new BinaryDecoder((ByteBuffer)object5);
                                binaryDecoder.setEncoderContext(this.ctx);
                                ErrorMessage errorMessage = InternalBinaryEncodingsHelper.getUaTcpCommMessage(binaryDecoder, ErrorMessage.class);
                                this.lT = serviceResultException = new ServiceResultException(errorMessage.getError(), errorMessage.getReason());
                                logger.warn(this.Ao.getRemoteSocketAddress() + " Error", (Throwable)serviceResultException);
                                break block48;
                            }
                            int n11 = ChunkUtils.getSecureChannelId((ByteBuffer)object5);
                            if (n5 == 0) {
                                n8 = n11;
                            } else if (n8 != n11) {
                                this.lT = new ServiceResultException("Error, SecureChannelId mismatch");
                                logger.warn("{} Error, SecureChannelId mismatch", (Object)TcpConnection.this.addr);
                                break block48;
                            }
                            if (n4 == 5132367) {
                                try {
                                    String string = ChunkUtils.getSecurityPolicyUri((ByteBuffer)object5);
                                    object4 = SecurityPolicy.getSecurityPolicy(string);
                                    object6 = ChunkUtils.getByteString((ByteBuffer)object5);
                                    object3 = ChunkUtils.getByteString((ByteBuffer)object5);
                                    if (object4 != TcpConnection.this.securityConfiguration.getSecurityPolicy()) {
                                        this.lT = new ServiceResultException("Error, unexpected security policy in OpenSecureChannelResponse");
                                        logger.warn("{} Error, unexpected security policy in OpenSecureChannelResponse", (Object)TcpConnection.this.addr);
                                        break block48;
                                    }
                                    if (TcpConnection.this.securityConfiguration.getSecurityPolicy() != SecurityPolicy.NONE && !Arrays.equals((byte[])object3, TcpConnection.this.securityConfiguration.getEncodedLocalCertificateThumbprint())) {
                                        this.lT = new ServiceResultException("Error, certificate thumbprint mismatch");
                                        logger.warn("{} Error, certificate thumbprint mismatch", (Object)TcpConnection.this.addr);
                                        break block48;
                                    }
                                    object2 = null;
                                    if (object6 != null && ((Object)object6).length > 0) {
                                        try {
                                            object2 = new Cert(CertificateUtils.decodeX509Certificate((byte[])object6));
                                        }
                                        catch (CertificateException certificateException) {
                                            this.lT = new ServiceResultException(StatusCodes.Bad_CertificateInvalid, "Error, Invalid Remote Certificate");
                                            logger.warn(TcpConnection.this.addr + " Error, Invalid Remote Certificate", (Throwable)certificateException);
                                            break block48;
                                        }
                                    }
                                    if (TcpConnection.this.cF != null && (object = TcpConnection.this.cF.validateCertificate((Cert)object2)) != null && !((StatusCode)object).isGood()) {
                                        this.lT = new ServiceResultException((StatusCode)object, "Remote certificate not accepted");
                                        logger.info("{} Remote certificate not accepted: {}", (Object)TcpConnection.this.addr, object);
                                        break block48;
                                    }
                                    TcpConnection.this.securityConfiguration = new SecurityConfiguration(TcpConnection.this.securityConfiguration.getSecurityMode(), TcpConnection.this.securityConfiguration.getLocalCertificate2(), (Cert)object2);
                                    object = new ChunkAsymmDecryptVerifier((ByteBuffer)object5, TcpConnection.this.securityConfiguration);
                                    ((ChunkAsymmDecryptVerifier)object).run();
                                }
                                catch (ServiceResultException serviceResultException) {
                                    this.lT = serviceResultException;
                                    logger.warn(TcpConnection.this.addr + "", (Throwable)serviceResultException);
                                    break block48;
                                }
                            }
                            if (n4 == 4674381) {
                                int n12 = ChunkUtils.getTokenId((ByteBuffer)object5);
                                object4 = null;
                                logger.debug("tokens({})={}", (Object)TcpConnection.this.zY.size(), TcpConnection.this.zY);
                                object6 = TcpConnection.this.zY.iterator();
                                while (object6.hasNext()) {
                                    object3 = (SecurityToken)object6.next();
                                    if (((SecurityToken)object3).getTokenId() != n12 || ((SecurityToken)object3).getSecureChannelId() != n11) continue;
                                    object4 = object3;
                                }
                                logger.debug("token={}", object4);
                                if (object4 == null) {
                                    this.lT = new ServiceResultException("Unexpected securityTokenId = " + n12);
                                    logger.warn("{} Unexpected securityTokenId = {}", (Object)TcpConnection.this.addr, (Object)n12);
                                    break block48;
                                }
                                if (!((SecurityToken)object4).isValid()) {
                                    this.lT = new ServiceResultException("SecurityToken " + n12 + " has timeouted");
                                    logger.warn("{} SecurityToken {} has timeouted", (Object)TcpConnection.this.addr, object4);
                                    break block48;
                                }
                                TcpConnection.this.zZ.put(n11, (SecurityToken)object4);
                                object6 = new ChunkSymmDecryptVerifier((ByteBuffer)object5, (SecurityToken)object4);
                                ((ChunkSymmDecryptVerifier)object6).run();
                                ((ByteBuffer)object5).position(24);
                            }
                            ((ByteBuffer)object5).position(((Buffer)object5).position() - 8);
                            int n13 = ((ByteBuffer)object5).getInt();
                            object4 = TcpConnection.this.Ab.get(n8);
                            if (!(n4 != 4674381 && object4 == null || ((SequenceNumber)object4).testAndSetRecvSequencenumber(n13))) {
                                this.lT = new ServiceResultException("Sequence number mismatch");
                                logger.warn("{} Sequence number mismatch: {} vs. {}", new Object[]{TcpConnection.this.addr, ((SequenceNumber)object4).getRecvSequenceNumber(), n13});
                                break block48;
                            }
                            n2 = ((ByteBuffer)object5).getInt();
                            if (n5 == 0) {
                                n7 = n2;
                            } else if (n2 != n7) {
                                this.lT = new ServiceResultException("Request id mismatch");
                                logger.warn("{} Request id mismatch", (Object)TcpConnection.this.addr);
                                break block48;
                            }
                            arrayList.add((ByteBuffer)object5);
                            ++n5;
                        } while (n6 == 0x43000000);
                        if (n6 == 0x41000000) continue;
                        ByteBufferArrayReadable byteBufferArrayReadable = new ByteBufferArrayReadable(arrayList.toArray(new ByteBuffer[arrayList.size()]));
                        byteBufferArrayReadable.order(ByteOrder.LITTLE_ENDIAN);
                        n3 = (int)byteBufferArrayReadable.getByteQueue().remaining();
                        byte[] byArray = new byte[n3];
                        byteBufferArrayReadable.getByteQueue().get(byArray);
                        object5 = new BinaryDecoder(byArray);
                        ((BinaryDecoder)object5).setEncoderContext(this.ctx);
                        NodeId nodeId = object5.getNodeId(null);
                        NodeId nodeId2 = new NodeId(0, (UnsignedInteger)Ids.OpenSecureChannelResponse_DefaultBinary.getValue());
                        if (nodeId2.equals(nodeId)) {
                            OpenSecureChannelResponse openSecureChannelResponse;
                            block49: {
                                object5 = new BinaryDecoder(byArray);
                                ((BinaryDecoder)object5).setEncoderContext(this.ctx);
                                object4 = InternalBinaryEncodingsHelper.getServiceResponse((BinaryDecoder)object5);
                                openSecureChannelResponse = (OpenSecureChannelResponse)object4;
                                object3 = openSecureChannelResponse.getSecurityToken();
                                object2 = TcpConnection.this.Aa.get(n7);
                                object = openSecureChannelResponse.getServerNonce();
                                int n14 = n8;
                                int n15 = ((ChannelSecurityToken)object3).getChannelId().intValue();
                                if (n15 != n14) {
                                    logger.warn("{} OpenSecureChannel, server sent two secureChannelIds {} and {} using {}", new Object[]{TcpConnection.this.addr, n14, n15, n14});
                                }
                                try {
                                    SecurityToken securityToken = new SecurityToken(TcpConnection.this.securityConfiguration, n14, ((ChannelSecurityToken)object3).getTokenId().intValue(), System.currentTimeMillis(), ((ChannelSecurityToken)object3).getRevisedLifetime().longValue(), (ByteString)object2, (ByteString)object);
                                    logger.debug("new token={}", (Object)securityToken);
                                    TcpConnection.this.zY.add(securityToken);
                                    if (TcpConnection.this.Ab.containsKey(n14)) break block49;
                                    TcpConnection.this.Ab.put(n14, new SequenceNumber());
                                }
                                catch (ServiceResultException serviceResultException) {
                                    this.lT = serviceResultException;
                                    logger.warn(TcpConnection.this.addr + " SecurityTokenError ", (Throwable)serviceResultException);
                                    break;
                                }
                            }
                            TcpConnection.this.Aa.remove(n7);
                            int n16 = n7;
                            int n17 = n8;
                            for (IConnection.IMessageListener iMessageListener : TcpConnection.this.listeners) {
                                iMessageListener.onMessage(n16, n17, openSecureChannelResponse);
                            }
                            continue;
                        }
                        TcpConnection.this.Aa.remove(n7);
                        int n18 = n7;
                        n2 = n8;
                        zU.get(TcpConnection.this).execute(() -> {
                            IEncodeable iEncodeable;
                            BinaryDecoder binaryDecoder = new BinaryDecoder(byArray);
                            binaryDecoder.setEncoderContext(this.ctx);
                            AtomicReference atomicReference = new AtomicReference();
                            binaryDecoder.setStructureFieldDecodeListener((fieldSpecification, object) -> {
                                if (UaIds.ResponseHeader.equals(fieldSpecification.getDataTypeId()) && "ResponseHeader".equals(fieldSpecification.getName())) {
                                    atomicReference.compareAndSet(null, (ResponseHeader)object);
                                }
                            });
                            try {
                                iEncodeable = InternalBinaryEncodingsHelper.getMessage(binaryDecoder);
                            }
                            catch (DecodingException decodingException) {
                                ResponseHeader object2 = (ResponseHeader)atomicReference.get();
                                if (object2 == null) {
                                    logger.error("Decoding error for Message", (Throwable)decodingException);
                                    return;
                                }
                                iEncodeable = new InternalClientSideDecodingServiceFault(object2, decodingException);
                            }
                            for (IConnection.IMessageListener iMessageListener : TcpConnection.this.listeners) {
                                iMessageListener.onMessage(n18, n2, iEncodeable);
                            }
                        });
                    }
                }
                catch (IOException iOException) {
                    if (iOException instanceof SocketException) {
                        if (!this.Ap) {
                            logger.info("{} Closed (unexpected)", (Object)TcpConnection.this.addr);
                            this.lT = new ServiceResultException(StatusCodes.Bad_ConnectionClosed, (Throwable)iOException, "Connection closed (unexpected)");
                        } else {
                            logger.info("{} Closed (expected)", (Object)TcpConnection.this.addr);
                            this.lT = new ServiceResultException(StatusCodes.Bad_ConnectionClosed, (Throwable)iOException, "Connection closed (expected)");
                        }
                    } else if (iOException instanceof EOFException) {
                        this.lT = new ServiceResultException(StatusCodes.Bad_ConnectionClosed, (Throwable)iOException, "Connection closed (graceful)");
                        logger.info("{} Closed (graceful)", (Object)TcpConnection.this.addr);
                    } else {
                        this.lT = StackUtils.toServiceResultException(iOException);
                        logger.warn(TcpConnection.this.addr + " Error", (Throwable)iOException);
                    }
                }
                catch (DecodingException decodingException) {
                    if (decodingException.getCause() != null && decodingException.getCause() instanceof EOFException) {
                        logger.info("{} Closed", (Object)TcpConnection.this.addr);
                    } else {
                        logger.warn(TcpConnection.this.addr + " Error", (Throwable)decodingException);
                    }
                    this.lT = decodingException;
                }
                catch (RuntimeServiceResultException runtimeServiceResultException) {
                    ServiceResultException serviceResultException = runtimeServiceResultException.getCause();
                    logger.warn(TcpConnection.this.addr + " Error", (Throwable)serviceResultException);
                    this.lT = serviceResultException;
                }
                catch (Exception exception) {
                    this.lT = new ServiceResultException(StatusCodes.Bad_InternalError, (Throwable)exception);
                    logger.error("Error in ReadThread", (Throwable)this.lT);
                }
                catch (StackOverflowError stackOverflowError) {
                    this.lT = new ServiceResultException(StatusCodes.Bad_DecodingError, (Throwable)stackOverflowError);
                    logger.error("Error in ReadThread", (Throwable)this.lT);
                }
            }
            TcpConnection.this.a(this.lT);
        }
    }

    private class a {
        private ByteBuffer[] Am;
        private ByteBuffer[] An;

        public a(ByteBuffer[] byteBufferArray, ByteBuffer[] byteBufferArray2) {
            this.Am = byteBufferArray;
            this.An = byteBufferArray2;
        }

        public ByteBuffer[] etH() {
            return this.Am;
        }

        public ByteBuffer[] etI() {
            return this.An;
        }
    }

    public static interface SocketWrapper {
        public void close() throws IOException;

        public void connect(InetSocketAddress var1) throws IOException;

        public void connect(InetSocketAddress var1, int var2) throws IOException;

        public InputStream getInputStream() throws IOException;

        public SocketAddress getLocalSocketAddress();

        public OutputStream getOutputStream() throws IOException;

        public SocketAddress getRemoteSocketAddress();

        public boolean isClosed();

        public boolean isConnected();

        public void setKeepAlive(boolean var1) throws IOException;

        public void setReceiveBufferSize(int var1) throws IOException;

        public void setSendBufferSize(int var1) throws IOException;

        public void setSoTimeout(int var1) throws IOException;

        public void setTcpNoDelay(boolean var1) throws IOException;
    }

    public static interface SocketFactory {
        public SocketWrapper createSocket(TcpConnection var1) throws IOException;
    }

    public static interface ReverseConnectionProvider {
        public SocketWrapper provideOpenReverseConnectionSocket(TcpConnection var1) throws IOException;
    }

    public static interface ExecutorProvider {
        public Executor get(TcpConnection var1);
    }

    public static class DelegatingSocketWrapper
    implements SocketWrapper {
        protected final Socket delegate;

        public DelegatingSocketWrapper(Socket socket) {
            this.delegate = socket;
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
        }

        @Override
        public void connect(InetSocketAddress inetSocketAddress) throws IOException {
            this.delegate.connect(inetSocketAddress);
        }

        @Override
        public void connect(InetSocketAddress inetSocketAddress, int n2) throws IOException {
            this.delegate.connect(inetSocketAddress, n2);
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this.delegate.getInputStream();
        }

        @Override
        public SocketAddress getLocalSocketAddress() {
            return this.delegate.getLocalSocketAddress();
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            return this.delegate.getOutputStream();
        }

        @Override
        public SocketAddress getRemoteSocketAddress() {
            return this.delegate.getRemoteSocketAddress();
        }

        @Override
        public boolean isClosed() {
            return this.delegate.isClosed();
        }

        @Override
        public boolean isConnected() {
            return this.delegate.isConnected();
        }

        @Override
        public void setKeepAlive(boolean bl) throws IOException {
            this.delegate.setKeepAlive(bl);
        }

        @Override
        public void setReceiveBufferSize(int n2) throws IOException {
            this.delegate.setReceiveBufferSize(n2);
        }

        @Override
        public void setSendBufferSize(int n2) throws IOException {
            this.delegate.setSendBufferSize(n2);
        }

        @Override
        public void setSoTimeout(int n2) throws IOException {
            this.delegate.setSoTimeout(n2);
        }

        @Override
        public void setTcpNoDelay(boolean bl) throws IOException {
            this.delegate.setTcpNoDelay(bl);
        }
    }

    public static class DefaultSocketFactory
    implements SocketFactory {
        @Override
        public SocketWrapper createSocket(TcpConnection tcpConnection) {
            return new DelegatingSocketWrapper(new Socket());
        }
    }

    public static class DefaultReverseConnectionProvider
    implements ReverseConnectionProvider {
        @Override
        public SocketWrapper provideOpenReverseConnectionSocket(TcpConnection tcpConnection) throws IOException {
            final ServerSocket serverSocket = new ServerSocket();
            serverSocket.bind(tcpConnection.addr);
            logger.info("Opened ServerSocket at:{}, waiting ReverseHello connection", (Object)tcpConnection.addr);
            if (tcpConnection.zu > 0) {
                TimerUtil.getTimer().schedule(new TimerTask(){

                    @Override
                    public void run() {
                        try {
                            serverSocket.close();
                        }
                        catch (IOException iOException) {
                            logger.error("Could not close ServerSocket in timeout", (Throwable)iOException);
                        }
                    }
                }, tcpConnection.zu);
            }
            DelegatingSocketWrapper delegatingSocketWrapper = new DelegatingSocketWrapper(serverSocket.accept());
            try {
                serverSocket.close();
            }
            catch (IOException iOException) {
                try {
                    delegatingSocketWrapper.delegate.close();
                }
                catch (Exception exception) {
                    logger.warn("Closing ReverseHello related ServerSocket failed and also closing the accepted connection failed", (Throwable)exception);
                }
                throw iOException;
            }
            logger.debug("ReverseHello ServerSocket {} closed.", (Object)tcpConnection.addr);
            return delegatingSocketWrapper;
        }
    }

    public static class DefaultExecutorProvider
    implements ExecutorProvider {
        @Override
        public Executor get(TcpConnection tcpConnection) {
            return StackUtils.getBlockingWorkExecutor();
        }
    }
}

