/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.tcp.io;

import com.prosysopc.ua.stack.transport.security.Cert;
import com.prosysopc.ua.stack.transport.security.CertificateValidator;
import com.prosysopc.ua.stack.transport.security.PrivKey;
import com.prosysopc.ua.stack.transport.tcp.io.TcpConnection;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.EnumSet;

public class OpcTcpSettings
implements Cloneable {
    PrivKey zr;
    Cert st;
    CertificateValidator cF;
    EnumSet<Flag> zs = EnumSet.noneOf(Flag.class);
    int zt = -1;
    int connectTimeout = -1;
    int zu = -1;
    int wm = 0;
    TcpConnection.SocketFactory hi;

    public OpcTcpSettings clone() {
        OpcTcpSettings opcTcpSettings = new OpcTcpSettings();
        opcTcpSettings.setClientCertificate(this.st);
        opcTcpSettings.setCertificateValidator(this.cF);
        opcTcpSettings.setPrivKey(this.zr);
        opcTcpSettings.zs = this.zs.clone();
        opcTcpSettings.setConnectTimeout(this.connectTimeout);
        opcTcpSettings.setHandshakeTimeout(this.zt);
        opcTcpSettings.setReverseHelloAcceptTimeout(this.zu);
        opcTcpSettings.setSocketFactory(this.hi);
        return opcTcpSettings;
    }

    public CertificateValidator getCertificateValidator() {
        return this.cF;
    }

    public Cert getClientCertificate() {
        return this.st;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public EnumSet<Flag> getFlags() {
        return this.zs;
    }

    public int getHandshakeTimeout() {
        return this.zt;
    }

    public int getMaxConnections() {
        return this.wm;
    }

    public PrivKey getPrivKey() {
        return this.zr;
    }

    public int getReverseHelloAcceptTimeout() {
        return this.zu;
    }

    public TcpConnection.SocketFactory getSocketFactory() {
        return this.hi;
    }

    public void readFrom(OpcTcpSettings opcTcpSettings) {
        if (opcTcpSettings.st != null) {
            this.st = opcTcpSettings.st;
        }
        if (opcTcpSettings.cF != null) {
            this.cF = opcTcpSettings.cF;
        }
        if (opcTcpSettings.zr != null) {
            this.zr = opcTcpSettings.zr;
        }
        this.zs = opcTcpSettings.zs;
        this.zu = opcTcpSettings.zu;
        this.zt = opcTcpSettings.zt;
        this.connectTimeout = opcTcpSettings.connectTimeout;
        this.wm = opcTcpSettings.wm;
        this.hi = opcTcpSettings.hi;
    }

    public void setCertificateValidator(CertificateValidator certificateValidator) {
        this.cF = certificateValidator;
    }

    public void setClientCertificate(Cert cert) {
        this.st = cert;
    }

    public void setClientCertificate(X509Certificate x509Certificate) throws CertificateEncodingException {
        this.st = new Cert(x509Certificate);
    }

    public void setConnectTimeout(int n2) {
        this.connectTimeout = n2;
    }

    public void setFlags(EnumSet<Flag> enumSet) {
        this.zs = enumSet;
    }

    public void setHandshakeTimeout(int n2) {
        this.zt = n2;
    }

    public void setMaxConnections(int n2) {
        this.wm = n2;
    }

    public void setPrivKey(PrivKey privKey) {
        this.zr = privKey;
    }

    public void setReverseHelloAcceptTimeout(int n2) {
        this.zu = n2;
    }

    public void setSocketFactory(TcpConnection.SocketFactory socketFactory) {
        this.hi = socketFactory;
    }

    public static enum Flag {
        MultiThread;

    }
}

