/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.security;

import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.transport.security.Cert;
import com.prosysopc.ua.stack.transport.security.SecurityAlgorithm;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public enum SecurityPolicy {
    NONE("http://opcfoundation.org/UA/SecurityPolicy#None", null, null, null, null, null, null, 0, 0, 0, 1, 1024, 2048, 0),
    BASIC128RSA15("http://opcfoundation.org/UA/SecurityPolicy#Basic128Rsa15", SecurityAlgorithm.HmacSha1, SecurityAlgorithm.Aes128, SecurityAlgorithm.RsaSha1, SecurityAlgorithm.KwRsa15, SecurityAlgorithm.Rsa15, SecurityAlgorithm.PSha1, 20, 16, 16, 16, 1024, 2048, 16),
    BASIC256("http://opcfoundation.org/UA/SecurityPolicy#Basic256", SecurityAlgorithm.HmacSha1, SecurityAlgorithm.Aes256, SecurityAlgorithm.RsaSha1, SecurityAlgorithm.KwRsaOaep, SecurityAlgorithm.RsaOaep, SecurityAlgorithm.PSha1, 20, 24, 32, 16, 1024, 2048, 32),
    BASIC256SHA256("http://opcfoundation.org/UA/SecurityPolicy#Basic256Sha256", SecurityAlgorithm.HmacSha256, SecurityAlgorithm.Aes256, SecurityAlgorithm.RsaSha256, SecurityAlgorithm.KwRsaOaep, SecurityAlgorithm.RsaOaep, SecurityAlgorithm.PSha256, 32, 32, 32, 16, 2048, 4096, 32),
    AES128_SHA256_RSAOAEP("http://opcfoundation.org/UA/SecurityPolicy#Aes128_Sha256_RsaOaep", SecurityAlgorithm.HmacSha256, SecurityAlgorithm.Aes128, SecurityAlgorithm.RsaSha256, SecurityAlgorithm.KwRsaOaep, SecurityAlgorithm.RsaOaep, SecurityAlgorithm.PSha256, 32, 32, 16, 16, 2048, 4096, 32),
    AES256_SHA256_RSAPSS("http://opcfoundation.org/UA/SecurityPolicy#Aes256_Sha256_RsaPss", SecurityAlgorithm.HmacSha256, SecurityAlgorithm.Aes256, SecurityAlgorithm.RsaPssSha256, SecurityAlgorithm.KwRsaOaep, SecurityAlgorithm.RsaOaep256, SecurityAlgorithm.PSha256, 32, 32, 32, 16, 2048, 4096, 32);

    @Deprecated
    public static final Set<SecurityPolicy> ALL_SECURE_101;
    @Deprecated
    public static final Set<SecurityPolicy> ALL_SECURE_102;
    @Deprecated
    public static final Set<SecurityPolicy> ALL_SECURE_103;
    public static final Set<SecurityPolicy> ALL_SECURE_104;
    public static final Set<SecurityPolicy> ALL_SECURE_105;
    public static final SecurityPolicy[] EMPTY_ARRAY;
    private static Map<String, SecurityPolicy> yw;
    private final SecurityAlgorithm yx;
    private final SecurityAlgorithm yy;
    private final SecurityAlgorithm yz;
    private final byte[] yA;
    private final int yB;
    private final int yC;
    private final SecurityAlgorithm yD;
    private final int ye;
    private final int yf;
    private final String yg;
    private final int yE;
    private final SecurityAlgorithm yF;
    private final SecurityAlgorithm yG;
    private final int yH;
    private final String jG;
    private final int yI;

    @Deprecated
    public static SecurityPolicy[] getAllSecurityPolicies() {
        return SecurityPolicy.values();
    }

    public static SecurityPolicy getSecurityPolicy(String string) throws ServiceResultException {
        if (string == null || string.isEmpty()) {
            return NONE;
        }
        SecurityPolicy securityPolicy = yw.get(string);
        if (securityPolicy == null) {
            throw new ServiceResultException(StatusCodes.Bad_SecurityPolicyRejected);
        }
        return securityPolicy;
    }

    private static void a(SecurityPolicy securityPolicy) {
        yw.put(securityPolicy.yg, securityPolicy);
    }

    private SecurityPolicy(String string2, SecurityAlgorithm securityAlgorithm, SecurityAlgorithm securityAlgorithm2, SecurityAlgorithm securityAlgorithm3, SecurityAlgorithm securityAlgorithm4, SecurityAlgorithm securityAlgorithm5, SecurityAlgorithm securityAlgorithm6, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.yx = securityAlgorithm5;
        this.yy = securityAlgorithm4;
        this.yz = securityAlgorithm3;
        this.yD = securityAlgorithm6;
        this.yg = string2;
        this.yF = securityAlgorithm2;
        this.yG = securityAlgorithm;
        this.yA = string2.getBytes(StandardCharsets.UTF_8);
        this.yH = n3;
        this.yE = n4;
        this.yC = n5;
        this.yB = n6;
        this.yf = n7;
        this.ye = n8;
        this.yI = n9;
        this.jG = string2.substring(string2.indexOf("#") + 1, string2.length()).replace("_", "");
    }

    public SecurityAlgorithm getAsymmetricEncryptionAlgorithm() {
        return this.yx;
    }

    public SecurityAlgorithm getAsymmetricKeyWrapAlgorithm() {
        return this.yy;
    }

    public SecurityAlgorithm getAsymmetricSignatureAlgorithm() {
        return this.yz;
    }

    public String getDisplayName() {
        return this.jG;
    }

    public byte[] getEncodedPolicyUri() {
        return this.yA;
    }

    public int getEncryptionBlockSize() {
        return this.yB;
    }

    public int getEncryptionKeySize() {
        return this.yC;
    }

    public SecurityAlgorithm getKeyDerivationAlgorithm() {
        return this.yD;
    }

    public int getMaxAsymmetricKeyLength() {
        return this.ye;
    }

    public int getMinAsymmetricKeyLength() {
        return this.yf;
    }

    public String getPolicyUri() {
        return this.yg;
    }

    public int getSecureChannelNonceLength() {
        return this.yI;
    }

    public int getSignatureKeySize() {
        return this.yE;
    }

    public SecurityAlgorithm getSymmetricEncryptionAlgorithm() {
        return this.yF;
    }

    public SecurityAlgorithm getSymmetricSignatureAlgorithm() {
        return this.yG;
    }

    public int getSymmetricSignatureSize() {
        return this.yH;
    }

    public boolean isUsableWith(Cert cert) {
        int n2 = cert.getKeySize();
        return n2 >= this.yf && n2 <= this.ye;
    }

    public String toString() {
        return this.yg;
    }

    static {
        ALL_SECURE_101 = Collections.unmodifiableSet(EnumSet.of(BASIC128RSA15, BASIC256));
        ALL_SECURE_102 = Collections.unmodifiableSet(EnumSet.of(BASIC128RSA15, BASIC256, BASIC256SHA256));
        ALL_SECURE_103 = Collections.unmodifiableSet(EnumSet.of(BASIC128RSA15, BASIC256, BASIC256SHA256));
        ALL_SECURE_104 = Collections.unmodifiableSet(EnumSet.of(BASIC256SHA256, AES128_SHA256_RSAOAEP, AES256_SHA256_RSAPSS));
        ALL_SECURE_105 = Collections.unmodifiableSet(EnumSet.of(BASIC256SHA256, AES128_SHA256_RSAOAEP, AES256_SHA256_RSAPSS));
        EMPTY_ARRAY = new SecurityPolicy[0];
        yw = new ConcurrentHashMap<String, SecurityPolicy>();
        SecurityPolicy.a(NONE);
        SecurityPolicy.a(BASIC128RSA15);
        SecurityPolicy.a(BASIC256);
        SecurityPolicy.a(BASIC256SHA256);
        SecurityPolicy.a(AES128_SHA256_RSAOAEP);
        SecurityPolicy.a(AES256_SHA256_RSAPSS);
    }
}

