/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.security;

import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.transport.security.Cert;
import com.prosysopc.ua.stack.utils.CertificateUtils;
import com.prosysopc.ua.stack.utils.CryptoUtil;
import com.prosysopc.ua.stack.utils.FileUtil;
import com.prosysopc.ua.stack.utils.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Scanner;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class PrivKey {
    private static final String yi = StringUtils.lineSeparator() + "-----END RSA PRIVATE KEY-----";
    private static final String yj = "-----BEGIN RSA PRIVATE KEY-----" + StringUtils.lineSeparator();
    private static final String yk = "-----END .*PRIVATE KEY-----";
    private static final String yl = "-----BEGIN .*PRIVATE KEY-----";
    public final RSAPrivateKey privateKey;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PrivKey load(byte[] byArray, String string) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, InvalidParameterSpecException {
        boolean bl = false;
        String string2 = "";
        byte[] byArray2 = null;
        if (byArray[0] == 45 && byArray[1] == 45 && byArray[2] == 45 || byArray[3] == 45 && byArray[4] == 45 && byArray[5] == 45) {
            boolean bl2;
            StringBuilder stringBuilder;
            String string3 = new String(byArray, StandardCharsets.UTF_8);
            try (Scanner scanner = new Scanner(string3);){
                stringBuilder = new StringBuilder();
                String string4 = "";
                bl2 = false;
                while (scanner.hasNextLine()) {
                    String string5 = scanner.nextLine();
                    if (string5.matches(yl)) {
                        bl2 = true;
                        continue;
                    }
                    if (string5.matches(yk)) {
                        break;
                    }
                    if (string5.startsWith("Proc-Type: 4,ENCRYPTED")) {
                        bl = true;
                        continue;
                    }
                    if (string5.startsWith("DEK-Info:")) {
                        String[] stringArray = string5.substring(10).split(",");
                        string2 = stringArray[0];
                        string4 = stringArray[1];
                        byArray2 = CryptoUtil.hexToBytes(string4);
                        continue;
                    }
                    stringBuilder.append(string5.trim());
                }
            }
            if (!bl && bl2) {
                byArray = CryptoUtil.base64Decode(stringBuilder.toString());
            }
        }
        if (bl) {
            if (string == null || string.isEmpty()) {
                throw new SecurityException("Encrypted private key requires a password.");
            }
            return new PrivKey(CertificateUtils.readPrivateKey(new ByteArrayInputStream(byArray), string, "AES-128-CBC").getEncoded());
        }
        return new PrivKey(byArray);
    }

    @Deprecated
    public static PrivKey load(File file) throws IOException, InvalidKeySpecException, NoSuchAlgorithmException {
        byte[] byArray = FileUtil.readFile(file);
        return new PrivKey(byArray);
    }

    public static PrivKey load(File file, String string) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, InvalidParameterSpecException {
        if (file.length() < 3L) {
            throw new IllegalArgumentException("file is not a valid private key (too short file)");
        }
        if (string == null || string.isEmpty()) {
            byte[] byArray = FileUtil.readFile(file);
            return PrivKey.load(byArray, string);
        }
        return new PrivKey(CertificateUtils.readPrivateKey(file, string, "AES-128-CBC").getEncoded());
    }

    public static PrivKey load(InputStream inputStream, String string) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, InvalidParameterSpecException {
        byte[] byArray = FileUtil.readStream(inputStream);
        return PrivKey.load(byArray, string);
    }

    public static PrivKey loadFromKeyStore(File file, String string) throws IOException, UnrecoverableKeyException, NoSuchAlgorithmException, CertificateException, KeyStoreException {
        return PrivKey.loadFromKeyStore(file.toURI().toURL(), string);
    }

    public static PrivKey loadFromKeyStore(URL uRL, String string) throws IOException, UnrecoverableKeyException, NoSuchAlgorithmException, CertificateException, KeyStoreException {
        RSAPrivateKey rSAPrivateKey = CertificateUtils.loadFromKeyStore(uRL, string);
        return new PrivKey(rSAPrivateKey);
    }

    public PrivKey(byte[] byArray) throws IOException, InvalidKeySpecException, NoSuchAlgorithmException {
        if (byArray == null) {
            throw new IllegalArgumentException("null arg");
        }
        try {
            this.privateKey = CertificateUtils.decodePKCS8EncodedRSAPrivateKey(ByteString.valueOf(byArray));
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw invalidKeySpecException;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw noSuchAlgorithmException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new RuntimeException("Could not decode private key", exception);
        }
    }

    public PrivKey(RSAPrivateKey rSAPrivateKey) {
        this.privateKey = rSAPrivateKey;
    }

    public byte[] getEncodedPrivateKey() {
        return this.privateKey.getEncoded();
    }

    public RSAPrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public void save(File file) throws IOException {
        FileUtil.writeFile(file, this.getEncodedPrivateKey());
    }

    public void save(File file, String string) throws IOException {
        block25: {
            if (string == null || string.length() == 0) {
                PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(this.getPrivateKey().getEncoded());
                try (FileOutputStream fileOutputStream = new FileOutputStream(file);
                     OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, StandardCharsets.UTF_8);){
                    ((Writer)outputStreamWriter).append(yj);
                    ((Writer)outputStreamWriter).append(StringUtils.addLineBreaks(CryptoUtil.base64Encode(pKCS8EncodedKeySpec.getEncoded()), 64));
                    ((Writer)outputStreamWriter).append(yi);
                    break block25;
                }
            }
            CertificateUtils.writePrivateKey((PrivateKey)this.getPrivateKey(), file, string, "AES-128-CBC");
        }
    }

    public void saveToKeyStore(Cert cert, File file, String string, String string2, String string3) throws IOException, KeyStoreException, NoSuchProviderException, NoSuchAlgorithmException, CertificateException {
        String string4 = "key";
        CertificateUtils.saveToProtectedStore(this.getPrivateKey(), cert.getCertificate(), file, string4, string, string2, string3);
    }
}

