/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.https;

import com.prosysopc.ua.stack.builtintypes.ServiceRequest;
import com.prosysopc.ua.stack.builtintypes.ServiceResponse;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.encoding.DecodingException;
import com.prosysopc.ua.stack.encoding.EncodingException;
import com.prosysopc.ua.stack.encoding.IEncodeable;
import com.prosysopc.ua.stack.encoding.binary.BinaryDecoder;
import com.prosysopc.ua.stack.encoding.binary.BinaryEncoder;
import com.prosysopc.ua.stack.transport.UriUtil;
import com.prosysopc.ua.stack.transport.https.HttpsClient;
import com.prosysopc.ua.stack.transport.impl.AsyncResultImpl;
import com.prosysopc.ua.stack.transport.tcp.impl.ErrorMessage;
import com.prosysopc.ua.stack.transport.tcp.impl.InternalBinaryEncodingsHelper;
import com.prosysopc.ua.stack.utils.SizeCalculationOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Arrays;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.nio.entity.NByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class a<T extends ServiceResponse>
implements Runnable {
    private static Logger logger = LoggerFactory.getLogger(a.class);
    HttpsClient wx;
    long wy = System.currentTimeMillis();
    long wz = 0L;
    int requestId;
    AsyncResultImpl<T> wA;
    ServiceRequest<T> wB;
    HttpPost wC;
    UnsignedInteger wD = null;
    int wc;
    String wE;

    public a(HttpsClient httpsClient, ServiceRequest<T> serviceRequest) {
        long l2;
        this.wx = httpsClient;
        this.wB = serviceRequest;
        this.wA = new AsyncResultImpl();
        UnsignedInteger unsignedInteger = serviceRequest.getRequestHeader() != null ? serviceRequest.getRequestHeader().getTimeoutHint() : null;
        long l3 = l2 = unsignedInteger != null ? unsignedInteger.longValue() : (long)httpsClient.getOperationTimeout();
        if (l2 != 0L) {
            this.wz = this.wy + l2;
        }
    }

    public void cancel() {
        if (this.wx.wp.remove(this.requestId) == null) {
            return;
        }
        this.wD = StatusCodes.Bad_RequestCancelledByRequest;
        HttpPost httpPost = this.wC;
        if (httpPost != null) {
            httpPost.abort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            CloseableHttpResponse closeableHttpResponse;
            if (this.wD != null) {
                this.wA.setError(new ServiceResultException(this.wD));
                return;
            }
            InetSocketAddress inetSocketAddress = UriUtil.getSocketAddress(this.wx.wi);
            String string = inetSocketAddress.getHostName();
            int n2 = inetSocketAddress.getPort();
            String string2 = UriUtil.getTransportProtocol(this.wx.wi);
            HttpHost httpHost = new HttpHost(string, n2, string2);
            String string3 = this.wx.wh.getDescription().getEndpointUrl();
            String string4 = string3 == null ? "" : string3;
            this.wC = new HttpPost(string4);
            this.wC.addHeader("OPCUA-SecurityPolicy", this.wx.wo);
            this.wC.addHeader("Content-Type", "application/octet-stream");
            SizeCalculationOutputStream sizeCalculationOutputStream = new SizeCalculationOutputStream();
            BinaryEncoder binaryEncoder = new BinaryEncoder(sizeCalculationOutputStream);
            binaryEncoder.setEncoderContext(this.wx.ws);
            InternalBinaryEncodingsHelper.putServiceRequest(binaryEncoder, this.wB);
            int n3 = sizeCalculationOutputStream.getLength();
            int n4 = this.wx.ws.getMaxMessageSize();
            if (n4 != 0 && n3 > n4) {
                EncodingException encodingException = new EncodingException(StatusCodes.Bad_EncodingLimitsExceeded, "MaxStringLength " + n4 + " < " + n3);
                logger.warn("run: failed", (Throwable)encodingException);
                throw encodingException;
            }
            byte[] byArray = new byte[n3];
            BinaryEncoder binaryEncoder2 = new BinaryEncoder(byArray);
            binaryEncoder2.setEncoderContext(this.wx.ws);
            InternalBinaryEncodingsHelper.putServiceRequest(binaryEncoder2, this.wB);
            this.wC.setEntity((HttpEntity)new NByteArrayEntity(byArray));
            if (this.wD != null) {
                this.wA.setError(new ServiceResultException(this.wD));
                return;
            }
            try {
                closeableHttpResponse = this.wx.wn.execute(httpHost, (HttpRequest)this.wC);
            }
            catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                this.wA.setError(new ServiceResultException(StatusCodes.Bad_SecurityPolicyRejected, (Throwable)sSLPeerUnverifiedException, "Could not negotiate a TLS security cipher or the server did not provide a valid certificate."));
                this.wx.wp.remove(this.requestId);
                return;
            }
            HttpEntity httpEntity = closeableHttpResponse.getEntity();
            int n5 = closeableHttpResponse.getStatusLine().getStatusCode();
            if (n5 != 200) {
                UnsignedInteger unsignedInteger = StatusCodes.Bad_UnknownResponse;
                if (n5 == 501) {
                    unsignedInteger = StatusCodes.Bad_ServiceUnsupported;
                }
                String string5 = EntityUtils.toString((HttpEntity)httpEntity);
                this.wA.setError(new ServiceResultException(unsignedInteger, n5 + ": " + string5));
                return;
            }
            if (this.wD != null) {
                this.wA.setError(new ServiceResultException(this.wD));
                return;
            }
            byArray = EntityUtils.toByteArray((HttpEntity)httpEntity);
            BinaryDecoder binaryDecoder = new BinaryDecoder(byArray);
            binaryDecoder.setEncoderContext(this.wx.ws);
            IEncodeable iEncodeable = InternalBinaryEncodingsHelper.getMessage(binaryDecoder);
            if (iEncodeable instanceof ErrorMessage) {
                ErrorMessage errorMessage = (ErrorMessage)iEncodeable;
                ServiceResultException serviceResultException = new ServiceResultException(new StatusCode(errorMessage.getError()), errorMessage.getReason());
                this.wA.setError(serviceResultException);
                return;
            }
            try {
                ServiceResponse serviceResponse = (ServiceResponse)iEncodeable;
                this.wA.setResult(serviceResponse);
            }
            catch (ClassCastException classCastException) {
                this.wA.setError(new ServiceResultException(classCastException));
                logger.error("Cannot cast response to ServiceResponse, response=" + iEncodeable.getClass(), (Throwable)classCastException);
            }
        }
        catch (EncodingException encodingException) {
            this.wA.setError(new ServiceResultException(StatusCodes.Bad_EncodingError, (Throwable)encodingException));
        }
        catch (ClientProtocolException clientProtocolException) {
            this.wA.setError(new ServiceResultException(StatusCodes.Bad_CommunicationError, (Throwable)clientProtocolException));
        }
        catch (IOException iOException) {
            if (this.wD != null) {
                this.wA.setError(new ServiceResultException(this.wD, (Throwable)iOException));
            } else {
                this.wA.setError(new ServiceResultException(StatusCodes.Bad_CommunicationError, (Throwable)iOException));
            }
        }
        catch (DecodingException decodingException) {
            this.wA.setError(new ServiceResultException(StatusCodes.Bad_DecodingError, (Throwable)decodingException));
        }
        catch (ServiceResultException serviceResultException) {
            this.wA.setError(serviceResultException);
        }
        catch (RuntimeException runtimeException) {
            this.wA.setError(new ServiceResultException(runtimeException));
        }
        catch (StackOverflowError stackOverflowError) {
            this.wA.setError(new ServiceResultException(StatusCodes.Bad_DecodingError, "Stack overflow: " + Arrays.toString(Arrays.copyOf(stackOverflowError.getStackTrace(), 30)) + "..."));
        }
        finally {
            this.wx.wp.remove(this.requestId);
        }
    }

    public void timeout() {
        if (this.wx.wp.remove(this.requestId) == null) {
            return;
        }
        this.wD = StatusCodes.Bad_Timeout;
        HttpPost httpPost = this.wC;
        if (httpPost != null) {
            httpPost.abort();
        }
        this.wA.setError(new ServiceResultException(this.wD));
    }
}

