/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.https;

import com.prosysopc.ua.server.ReverseConnectionParameters;
import com.prosysopc.ua.stack.application.Application;
import com.prosysopc.ua.stack.application.Server;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.transport.CloseableObject;
import com.prosysopc.ua.stack.transport.CloseableObjectState;
import com.prosysopc.ua.stack.transport.ConnectionMonitor;
import com.prosysopc.ua.stack.transport.Endpoint;
import com.prosysopc.ua.stack.transport.EndpointBinding;
import com.prosysopc.ua.stack.transport.EndpointServer;
import com.prosysopc.ua.stack.transport.ServerConnection;
import com.prosysopc.ua.stack.transport.UriUtil;
import com.prosysopc.ua.stack.transport.endpoint.EndpointBindingCollection;
import com.prosysopc.ua.stack.transport.https.HttpsServerConnection;
import com.prosysopc.ua.stack.transport.https.HttpsServerEndpointHandler;
import com.prosysopc.ua.stack.transport.https.HttpsSettings;
import com.prosysopc.ua.stack.transport.impl.ConnectionCollection;
import com.prosysopc.ua.stack.transport.security.CertValidatorTrustManager;
import com.prosysopc.ua.stack.transport.security.CertificateValidator;
import com.prosysopc.ua.stack.transport.security.HttpsSecurityPolicy;
import com.prosysopc.ua.stack.transport.security.SecurityMode;
import com.prosysopc.ua.stack.transport.security.SecurityPolicy;
import com.prosysopc.ua.stack.utils.AbstractState;
import com.prosysopc.ua.stack.utils.CryptoUtil;
import com.prosysopc.ua.stack.utils.asyncsocket.AsyncServerSocket;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.nio.DefaultHttpServerIODispatch;
import org.apache.http.impl.nio.DefaultNHttpServerConnection;
import org.apache.http.impl.nio.DefaultNHttpServerConnectionFactory;
import org.apache.http.impl.nio.NHttpConnectionBase;
import org.apache.http.impl.nio.SSLNHttpServerConnectionFactory;
import org.apache.http.impl.nio.reactor.DefaultListeningIOReactor;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.nio.NHttpConnectionFactory;
import org.apache.http.nio.NHttpServerConnection;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.nio.protocol.HttpAsyncRequestHandlerResolver;
import org.apache.http.nio.protocol.HttpAsyncService;
import org.apache.http.nio.reactor.IOEventDispatch;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.nio.reactor.IOSession;
import org.apache.http.nio.reactor.ListenerEndpoint;
import org.apache.http.nio.reactor.ListeningIOReactor;
import org.apache.http.nio.reactor.ssl.SSLSetupHandler;
import org.apache.http.params.HttpParams;
import org.apache.http.params.SyncBasicHttpParams;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.ImmutableHttpProcessor;
import org.apache.http.protocol.ResponseConnControl;
import org.apache.http.protocol.ResponseContent;
import org.apache.http.protocol.ResponseDate;
import org.apache.http.protocol.ResponseServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpsServer
extends AbstractState<CloseableObjectState, ServiceResultException>
implements EndpointServer {
    static Logger sj = LoggerFactory.getLogger(HttpsServer.class);
    public static final HttpParams DEFAULT_HTTPPARAMS = new SyncBasicHttpParams().setIntParameter("http.socket.timeout", 0).setIntParameter("http.socket.buffer-size", 8192).setParameter("http.origin-server", (Object)"OpcUA/1.1").setParameter("http.useragent", (Object)"OpcUA/1.1");
    Application application;
    String[] wH;
    String[] wI;
    String[] wu;
    AtomicInteger wJ = new AtomicInteger();
    AsyncServerSocket wK;
    int wm;
    private boolean initialized = false;
    EndpointBindingCollection endpointBindings = new EndpointBindingCollection();
    ConnectionCollection wL = new ConnectionCollection(this);
    Thread wM;
    Thread wN;
    Semaphore wO;
    Semaphore wP;
    HttpAsyncService wQ;
    ConnectionReuseStrategy wR;
    a wS;
    NHttpConnectionFactory<DefaultNHttpServerConnection> wT;
    NHttpConnectionFactory<DefaultNHttpServerConnection> wU;
    SSLEngine wV;
    SSLSetupHandler wW;
    IOEventDispatch wX;
    IOEventDispatch wY;
    ListeningIOReactor wZ;
    IOReactorConfig xa;
    HttpsSecurityPolicy[] wj;
    Map<SocketAddress, SocketHandle> xb = new HashMap<SocketAddress, SocketHandle>();
    Server discoveryServer;
    HttpsServerEndpointHandler xc;
    private int xd = -1;

    public static TrustManager[] makeTrustManager(CertificateValidator ... certificateValidatorArray) {
        TrustManager[] trustManagerArray = new TrustManager[certificateValidatorArray.length];
        for (int i2 = 0; i2 < trustManagerArray.length; ++i2) {
            trustManagerArray[i2] = new CertValidatorTrustManager(certificateValidatorArray[i2]);
        }
        return trustManagerArray;
    }

    public HttpsServer(Application application) throws ServiceResultException {
        super(CloseableObjectState.Closed, CloseableObjectState.Closed);
        this.application = application;
        this.xa = new IOReactorConfig();
        this.wj = application.getHttpsSettings().getHttpsSecurityPolicies();
        this.xa.setTcpNoDelay(true);
        ImmutableHttpProcessor immutableHttpProcessor = new ImmutableHttpProcessor(new HttpResponseInterceptor[]{new ResponseDate(), new ResponseServer(), new ResponseContent(), new ResponseConnControl()});
        this.wS = new a();
        final Map map = Collections.synchronizedMap(new HashMap());
        this.wR = new DefaultConnectionReuseStrategy();
        this.wQ = new HttpAsyncService((HttpProcessor)immutableHttpProcessor, this.wR, (HttpAsyncRequestHandlerResolver)this.wS, this.getHttpParams()){

            @Override
            public void closed(NHttpServerConnection nHttpServerConnection) {
                NHttpConnectionBase nHttpConnectionBase = (NHttpConnectionBase)((Object)nHttpServerConnection);
                sj.info("closed: {} {}<-> {} context={} socketTimeout={}", new Object[]{HttpsServer.this.getBoundSocketAddresses(), nHttpConnectionBase.getLocalAddress(), nHttpConnectionBase.getRemoteAddress(), nHttpConnectionBase.getContext(), nHttpConnectionBase.getSocketTimeout()});
                HttpsServerConnection httpsServerConnection = (HttpsServerConnection)map.remove(nHttpServerConnection);
                HttpsServer.this.wL.removeConnection(httpsServerConnection);
                super.closed(nHttpServerConnection);
            }

            @Override
            public void connected(NHttpServerConnection nHttpServerConnection) {
                NHttpConnectionBase nHttpConnectionBase = (NHttpConnectionBase)((Object)nHttpServerConnection);
                sj.info("connected: {} {}<-> {} context={} socketTimeout={}", new Object[]{HttpsServer.this.getBoundSocketAddresses(), nHttpConnectionBase.getLocalAddress(), nHttpConnectionBase.getRemoteAddress(), nHttpConnectionBase.getContext(), nHttpConnectionBase.getSocketTimeout()});
                HttpsServerConnection httpsServerConnection = new HttpsServerConnection(HttpsServer.this, nHttpServerConnection);
                map.put(nHttpServerConnection, httpsServerConnection);
                HttpsServer.this.wL.addConnection(httpsServerConnection);
                super.connected(nHttpServerConnection);
                ArrayList<ServerConnection> arrayList = new ArrayList<ServerConnection>();
                HttpsServer.this.wL.getConnections(arrayList);
                sj.trace("Checking maximum number of connections, limit: {}, current: {}", (Object)HttpsServer.this.wm, (Object)arrayList.size());
                if (arrayList.size() >= HttpsServer.this.wm) {
                    int n2 = HttpsServer.this.wm - arrayList.size() + 1;
                    sj.trace("We are at max or over limit, closing this connection");
                    try {
                        nHttpServerConnection.shutdown();
                        HttpsServer.this.wL.removeConnection(httpsServerConnection);
                    }
                    catch (IOException iOException) {
                        sj.error("Cannot close opc.https connection properly", (Throwable)iOException);
                    }
                }
            }
        };
        this.discoveryServer = new Server(application);
        this.discoveryServer.setEndpointBindings(this.endpointBindings);
        EndpointBinding endpointBinding = new EndpointBinding(this, discoveryEndpoint, this.discoveryServer);
        this.xc = new HttpsServerEndpointHandler(endpointBinding);
    }

    @Override
    public void addConnectionListener(ConnectionMonitor.ConnectListener connectListener) {
        this.wL.addConnectionListener(connectListener);
    }

    @Override
    public EndpointServer.EndpointHandle bind(SocketAddress socketAddress, EndpointBinding endpointBinding) throws ServiceResultException {
        Object object;
        Object object2;
        String string;
        if (endpointBinding == null || socketAddress == null || endpointBinding.endpointServer != this) {
            throw new IllegalArgumentException();
        }
        this.init();
        String string2 = string = endpointBinding.endpointAddress.getEndpointUrl();
        string2 = UriUtil.getEndpointName(string);
        if (string2 == null) {
            string2 = "";
        }
        if ((object2 = this.wS.lookup(string2)) == null) {
            object = new HttpsServerEndpointHandler(endpointBinding);
            this.wS.a(string2, (HttpsServerEndpointHandler)object);
            this.wS.a("", this.xc);
        } else {
            object = (HttpsServerEndpointHandler)object2;
            if (((HttpsServerEndpointHandler)object).xs != endpointBinding.endpointServer) {
                throw new ServiceResultException(StatusCodes.Bad_UnexpectedError, "Cannot bind endpoint " + string + " and " + ((HttpsServerEndpointHandler)object).xi.endpointAddress.getEndpointUrl() + " with two different sets of service.");
            }
        }
        string2 = UriUtil.getTransportProtocol(endpointBinding.endpointAddress.getEndpointUrl());
        object2 = this.a(socketAddress, string2);
        object = ((SocketHandle)object2).a(endpointBinding);
        try {
            InetSocketAddress inetSocketAddress;
            SocketHandle socketHandle2;
            int n2;
            int n3;
            this.shutdownReactor();
            this.initReactor();
            if (((SocketHandle)object2).getPort() > 0) {
                SocketHandle[] object3 = this.socketHandleSnapshot();
                n3 = object3.length;
                for (n2 = 0; n2 < n3; ++n2) {
                    socketHandle2 = object3[n2];
                    if (socketHandle2.xm != null) continue;
                    socketHandle2.xm = this.wZ.listen(socketHandle2.getSocketAddress());
                    inetSocketAddress = (InetSocketAddress)socketHandle2.getSocketAddress();
                    socketHandle2.setBoundSocketAddress(new InetSocketAddress(inetSocketAddress.getAddress(), inetSocketAddress.getPort()));
                }
            } else if (this.xd > 0 && ((SocketHandle)object2).getPort() == 0) {
                SocketHandle[] serviceResultException = this.socketHandleSnapshot();
                n3 = serviceResultException.length;
                for (n2 = 0; n2 < n3; ++n2) {
                    socketHandle2 = serviceResultException[n2];
                    if (socketHandle2.xm != null) continue;
                    endpointBinding.rewriteEndpointUrlPort(this.xd);
                    inetSocketAddress = (InetSocketAddress)socketHandle2.getSocketAddress();
                    socketHandle2.setBoundSocketAddress(new InetSocketAddress(inetSocketAddress.getAddress(), this.xd));
                    socketHandle2.xm = this.wZ.listen(socketHandle2.getBoundSocketAddress());
                }
            }
            if ("opc.https".equals(string2) && (this.wM == null || !this.wM.isAlive())) {
                final ListeningIOReactor listeningIOReactor = this.wZ;
                final Semaphore semaphore = this.wO = new Semaphore(0);
                this.wM = new Thread(){

                    @Override
                    public void run() {
                        try {
                            HttpsServer.this.setState((Object)CloseableObjectState.Open);
                            listeningIOReactor.execute(HttpsServer.this.wY);
                        }
                        catch (IOException iOException) {
                            HttpsServer.this.setError(new ServiceResultException(iOException));
                        }
                        finally {
                            semaphore.release(9999);
                        }
                    }
                };
                if (!((CloseableObjectState)((Object)this.getState())).isOpen()) {
                    this.setState(CloseableObjectState.Opening);
                }
                this.wM.start();
            }
            if ("http".equals(string2) && (this.wN == null || !this.wN.isAlive())) {
                final ListeningIOReactor listeningIOReactor = this.wZ;
                final Semaphore semaphore = this.wP = new Semaphore(0);
                this.wN = new Thread(){

                    @Override
                    public void run() {
                        try {
                            HttpsServer.this.setState((Object)CloseableObjectState.Open);
                            listeningIOReactor.execute(HttpsServer.this.wX);
                        }
                        catch (IOException iOException) {
                            HttpsServer.this.setError(new ServiceResultException(iOException));
                        }
                        finally {
                            semaphore.release(9999);
                        }
                    }
                };
                if (!((CloseableObjectState)((Object)this.getState())).isOpen()) {
                    this.setState(CloseableObjectState.Opening);
                }
                this.wN.start();
            }
            if (((SocketHandle)object2).getPort() == 0 && ((SocketHandle)object2).getBoundSocketAddress() == null) {
                for (SocketHandle socketHandle2 : this.socketHandleSnapshot()) {
                    if (socketHandle2.xm != null) continue;
                    socketHandle2.xm = this.wZ.listen(socketHandle2.getSocketAddress());
                    if (socketHandle2.getBoundSocketAddress() != null) continue;
                    try {
                        socketHandle2.xm.waitFor();
                        this.xd = ((InetSocketAddress)socketHandle2.xm.getAddress()).getPort();
                        sj.info("Replace port number 0 in socket addresses with: {}", (Object)this.xd);
                        endpointBinding.rewriteEndpointUrlPort(this.xd);
                        inetSocketAddress = (InetSocketAddress)socketHandle2.getSocketAddress();
                        socketHandle2.setBoundSocketAddress(new InetSocketAddress(inetSocketAddress.getAddress(), this.xd));
                    }
                    catch (InterruptedException interruptedException) {
                        sj.error("InterruptedException", (Throwable)interruptedException);
                    }
                }
            }
        }
        catch (ServiceResultException serviceResultException) {
            ((HttpsEndpointHandle)object).close();
            throw serviceResultException;
        }
        sj.info("HTTPS Socket bound to {}", (Object)(((SocketHandle)object2).getBoundSocketAddress() != null ? ((SocketHandle)object2).getBoundSocketAddress() : ((SocketHandle)object2).getSocketAddress()));
        sj.info("Endpoint bound to {}", (Object)((HttpsEndpointHandle)object).endpointBinding().endpointAddress.getEndpointUrl());
        return object;
    }

    @Override
    public EndpointServer.ReverseEndpointHandle bindReverse(SocketAddress socketAddress, ReverseConnectionParameters reverseConnectionParameters, ScheduledExecutorService scheduledExecutorService) {
        throw new UnsupportedOperationException("HTTPS does not support ReverseHello");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized CloseableObject close() {
        for (EndpointBinding endpointBinding : this.endpointBindings.getAll()) {
            endpointBinding.endpointServer.getEndpointBindings().remove(endpointBinding);
        }
        this.endpointBindings.clear();
        try {
            this.setState(CloseableObjectState.Closing);
            for (SocketHandle socketHandle : this.socketHandleSnapshot()) {
                socketHandle.close();
            }
        }
        finally {
            try {
                if (this.wZ != null) {
                    this.wZ.shutdown();
                }
                if (this.wM != null) {
                    this.wM.interrupt();
                    this.wM = null;
                }
                if (this.wN != null) {
                    this.wN.interrupt();
                    this.wN = null;
                }
            }
            catch (IOException iOException) {}
            this.setState(CloseableObjectState.Closed);
        }
        return this;
    }

    @Override
    public List<SocketAddress> getBoundSocketAddresses() {
        ArrayList<SocketAddress> arrayList = new ArrayList<SocketAddress>();
        for (SocketHandle socketHandle : this.socketHandleSnapshot()) {
            arrayList.add(socketHandle.getBoundSocketAddress() != null ? socketHandle.getBoundSocketAddress() : socketHandle.getSocketAddress());
        }
        return arrayList;
    }

    @Override
    public void getConnections(Collection<ServerConnection> collection) {
        this.wL.getConnections(collection);
    }

    @Override
    public EncoderContext getEncoderContext() {
        return this.application.getEncoderContext();
    }

    @Override
    public EndpointBindingCollection getEndpointBindings() {
        return this.endpointBindings;
    }

    public HttpsSettings getHttpsSettings() {
        return this.application.getHttpsSettings();
    }

    public Collection<HttpsSecurityPolicy> getSupportedSecurityPolicies() {
        if (this.wj == null) {
            return HttpsSecurityPolicy.getAvailablePolicies().values();
        }
        return Arrays.asList(this.wj);
    }

    public int getWorkerThreadCount() {
        return this.xa.getIoThreadCount();
    }

    @Override
    public void removeConnectionListener(ConnectionMonitor.ConnectListener connectListener) {
        this.wL.removeConnectionListener(connectListener);
    }

    public void setWorkerThreadCount(int n2) {
        if (this.wZ != null) {
            throw new RuntimeException("Set workercount before binding the first socket address");
        }
        this.xa.setIoThreadCount(n2);
    }

    public SocketHandle[] socketHandleSnapshot() {
        return this.xb.values().toArray(new SocketHandle[this.xb.size()]);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("HttpServer");
        stringBuilder.append("(");
        for (SocketHandle socketHandle : this.socketHandleSnapshot()) {
            stringBuilder.append(socketHandle.toString());
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    private void init() {
        if (!this.initialized) {
            int n2 = this.application.getHttpsSettings().getMaxConnections();
            if (n2 <= 0) {
                throw new IllegalStateException("Maximum number of connections was not configured; must be greater than 0");
            }
            this.wm = n2;
            this.initialized = true;
        }
    }

    protected void initReactor() throws ServiceResultException {
        boolean bl = false;
        boolean bl2 = false;
        for (SocketHandle socketHandle : this.xb.values()) {
            bl |= socketHandle.scheme.equals("opc.https");
            bl2 |= socketHandle.scheme.equals("http");
        }
        try {
            Object[] objectArray;
            if (bl && this.wW == null) {
                try {
                    objectArray = SSLContext.getInstance("TLSv1.2");
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    sj.debug("No TLSv1.2 implementation found, trying TLS");
                    objectArray = SSLContext.getInstance("TLS");
                }
                objectArray.init(this.application.getHttpsSettings().getKeyManagers(), this.application.getHttpsSettings().getTrustManagers(), null);
                this.wW = new SSLSetupHandler(){

                    @Override
                    public void initalize(SSLEngine sSLEngine) throws SSLException {
                    }

                    @Override
                    public void verify(IOSession iOSession, SSLSession sSLSession) throws SSLException {
                    }
                };
                this.wU = new SSLNHttpServerConnectionFactory((SSLContext)objectArray, this.wW, this.getHttpParams());
                this.wY = new DefaultHttpServerIODispatch<HttpAsyncService>(this.wQ, this.wU);
                this.wV = objectArray.createSSLEngine();
                sj.info("Enabled protocols in SSL Engine are {}", (Object)Arrays.toString(this.wV.getEnabledProtocols()));
                this.wH = this.wV.getEnabledCipherSuites();
                sj.info("Enabled CipherSuites in SSL Engine are {}", (Object)Arrays.toString(this.wH));
            }
            if (bl) {
                objectArray = this.wu;
                this.wI = this.etx();
                this.wu = CryptoUtil.filterCipherSuiteList(this.wH, this.wI);
                this.wV.setEnabledCipherSuites(this.wu);
                if (objectArray == null || !Arrays.equals(objectArray, this.wu)) {
                    sj.info("CipherSuites for policies ({}) are {}", (Object)Arrays.toString((Object[])this.wj), (Object)Arrays.toString(this.wu));
                }
            }
            if (bl2 && this.wT == null) {
                this.wT = new DefaultNHttpServerConnectionFactory(this.getHttpParams());
                this.wX = new DefaultHttpServerIODispatch<HttpAsyncService>(this.wQ, this.wT);
            }
            if (this.wZ == null) {
                this.wZ = new DefaultListeningIOReactor(this.xa, null);
            }
        }
        catch (KeyManagementException keyManagementException) {
            throw new ServiceResultException(keyManagementException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new ServiceResultException(noSuchAlgorithmException);
        }
        catch (IOReactorException iOReactorException) {
            throw new ServiceResultException(iOReactorException);
        }
    }

    protected void shutdownReactor() {
        for (SocketHandle socketHandle : this.socketHandleSnapshot()) {
            ListenerEndpoint listenerEndpoint = socketHandle.xm;
            if (listenerEndpoint != null) {
                listenerEndpoint.close();
            }
            socketHandle.xm = null;
        }
        if (this.wZ != null) {
            try {
                this.wZ.shutdown();
            }
            catch (IOException iOException) {
                sj.error("Failed to shutdown ioReactor", (Throwable)iOException);
            }
            this.wZ = null;
        }
        if (this.wM != null) {
            this.wM.interrupt();
            try {
                this.wO.acquire();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.wO = null;
            this.wM = null;
        }
        if (this.wN != null) {
            this.wN.interrupt();
            try {
                this.wP.acquire();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.wP = null;
            this.wN = null;
        }
    }

    String[] etx() throws ServiceResultException {
        Collection<HttpsSecurityPolicy> collection = this.getSupportedSecurityPolicies();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (HttpsSecurityPolicy httpsSecurityPolicy : collection) {
            String[] stringArray = httpsSecurityPolicy.getCipherSuites();
            if (stringArray == null) continue;
            for (String string : stringArray) {
                if (arrayList.contains(string)) continue;
                arrayList.add(string);
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    Set<SecurityPolicy> ety() {
        HashSet<SecurityPolicy> hashSet = new HashSet<SecurityPolicy>();
        for (EndpointBinding endpointBinding : this.endpointBindings.getAll()) {
            for (SecurityMode securityMode : endpointBinding.endpointAddress.getSecurityModes()) {
                hashSet.add(securityMode.getSecurityPolicy());
            }
        }
        return hashSet;
    }

    int a(Endpoint endpoint) {
        int n2 = 0;
        for (SocketHandle socketHandle : this.socketHandleSnapshot()) {
            for (HttpsEndpointHandle httpsEndpointHandle : socketHandle.endpointHandleSnapshot()) {
                if (!httpsEndpointHandle.xi.endpointAddress.equals(endpoint)) continue;
                ++n2;
            }
        }
        return n2;
    }

    List<HttpsEndpointHandle> ax(String string) {
        ArrayList<HttpsEndpointHandle> arrayList = new ArrayList<HttpsEndpointHandle>();
        for (SocketHandle socketHandle : this.socketHandleSnapshot()) {
            socketHandle.c(arrayList);
        }
        return arrayList;
    }

    HttpParams getHttpParams() {
        return this.application.getHttpsSettings().getHttpParams() == null ? DEFAULT_HTTPPARAMS : this.application.getHttpsSettings().getHttpParams();
    }

    synchronized SocketHandle a(SocketAddress socketAddress, String string) throws ServiceResultException {
        SocketHandle socketHandle = this.xb.get(socketAddress);
        if (socketHandle == null) {
            socketHandle = new SocketHandle(socketAddress, string);
            this.xb.put(socketAddress, socketHandle);
        } else if (!string.equals(socketHandle.scheme)) {
            throw new ServiceResultException(StatusCodes.Bad_UnexpectedError, "Socket port=" + (socketHandle.getBoundSocketAddress() != null ? socketHandle.getBoundSocketAddress().getPort() : socketHandle.getPort()) + " cannot be bound as http and https.");
        }
        return socketHandle;
    }

    class a
    implements HttpAsyncRequestHandlerResolver {
        Map<String, HttpsServerEndpointHandler> map = new HashMap<String, HttpsServerEndpointHandler>();

        public Map<String, HttpAsyncRequestHandler<?>> getHandlers() {
            return new HashMap(this.map);
        }

        @Override
        public HttpAsyncRequestHandler<?> lookup(String string) {
            HttpAsyncRequestHandler httpAsyncRequestHandler = this.map.get(string);
            if (httpAsyncRequestHandler == null && (string.equals("") || string.equals("/"))) {
                return HttpsServer.this.xc;
            }
            return httpAsyncRequestHandler;
        }

        public void a(String string, HttpsServerEndpointHandler httpsServerEndpointHandler) {
            this.map.put(string, httpsServerEndpointHandler);
        }

        public void setHandlers(Map<String, HttpAsyncRequestHandler<?>> map) {
            this.map.clear();
            for (Map.Entry<String, HttpAsyncRequestHandler<?>> entry : map.entrySet()) {
                this.map.put(entry.getKey(), (HttpsServerEndpointHandler)entry.getValue());
            }
        }

        public void unregister(String string) {
            this.map.remove(string);
        }
    }

    public class SocketHandle {
        private SocketAddress xk;
        private InetSocketAddress xl;
        ListenerEndpoint xm;
        String scheme;
        Map<Endpoint, HttpsEndpointHandle> endpoints = new HashMap<Endpoint, HttpsEndpointHandle>();

        SocketHandle(SocketAddress socketAddress, String string) {
            this.setSocketAddress(socketAddress);
            this.scheme = string;
        }

        public synchronized HttpsEndpointHandle[] endpointHandleSnapshot() {
            return this.endpoints.values().toArray(new HttpsEndpointHandle[this.endpoints.size()]);
        }

        public InetSocketAddress getBoundSocketAddress() {
            return this.xl;
        }

        public SocketAddress getSocketAddress() {
            return this.xk;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.scheme + "(" + (this.getBoundSocketAddress() != null ? this.getBoundSocketAddress() : this.getSocketAddress()) + ", ");
            for (HttpsEndpointHandle httpsEndpointHandle : this.endpoints.values()) {
                stringBuilder.append(httpsEndpointHandle.toString());
            }
            stringBuilder.append(")");
            return stringBuilder.toString();
        }

        void close() {
            for (HttpsEndpointHandle httpsEndpointHandle : this.endpoints.values()) {
                httpsEndpointHandle.etA();
            }
            HttpsServer.this.xb.remove(this.getSocketAddress());
            if (this.xm != null) {
                this.xm.close();
            }
        }

        synchronized void c(Collection<HttpsEndpointHandle> collection) {
            collection.addAll(this.endpoints.values());
        }

        synchronized HttpsEndpointHandle a(EndpointBinding endpointBinding) throws ServiceResultException {
            HttpsEndpointHandle httpsEndpointHandle = this.endpoints.get(endpointBinding.endpointAddress);
            if (httpsEndpointHandle == null) {
                httpsEndpointHandle = new HttpsEndpointHandle(this, endpointBinding);
                this.endpoints.put(endpointBinding.endpointAddress, httpsEndpointHandle);
                HttpsServer.this.endpointBindings.add(endpointBinding);
                endpointBinding.serviceServer.getEndpointBindings().add(endpointBinding);
            } else if (!httpsEndpointHandle.xi.equals(endpointBinding)) {
                throw new ServiceResultException(StatusCodes.Bad_UnexpectedError, "Cannot bind an endpoint address to two different servers.");
            }
            return httpsEndpointHandle;
        }

        int getPort() {
            return ((InetSocketAddress)this.getSocketAddress()).getPort();
        }

        void setBoundSocketAddress(InetSocketAddress inetSocketAddress) {
            this.xl = inetSocketAddress;
        }

        void setSocketAddress(SocketAddress socketAddress) {
            this.xk = socketAddress;
        }
    }

    public class HttpsEndpointHandle
    implements EndpointServer.EndpointHandle {
        EndpointBinding xi;
        SocketHandle xj;

        HttpsEndpointHandle(SocketHandle socketHandle, EndpointBinding endpointBinding) {
            this.xj = socketHandle;
            this.xi = endpointBinding;
        }

        @Override
        public void close() {
            this.etz();
            this.etA();
        }

        @Override
        public EndpointBinding endpointBinding() {
            return this.xi;
        }

        @Override
        public SocketAddress socketAddress() {
            return this.xj.getBoundSocketAddress() != null ? this.xj.getBoundSocketAddress() : this.xj.getSocketAddress();
        }

        public String toString() {
            return "(" + this.xi.endpointAddress.toString() + ")";
        }

        void etz() {
            this.xj.endpoints.remove(this.xi.endpointAddress);
            if (this.xj.endpoints.isEmpty()) {
                this.xj.close();
            }
        }

        void etA() {
            int n2 = HttpsServer.this.a(this.xi.endpointAddress);
            if (n2 == 0) {
                String string = this.xi.endpointAddress.getEndpointUrl();
                HttpsServer.this.wS.unregister(string);
                HttpsServer.this.wS.unregister("");
                HttpsServer.this.endpointBindings.remove(this.xi);
                this.xi.serviceServer.getEndpointBindings().remove(this.xi);
            }
        }
    }
}

