/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.https;

import com.prosysopc.ua.stack.builtintypes.ServiceRequest;
import com.prosysopc.ua.stack.builtintypes.ServiceResponse;
import com.prosysopc.ua.stack.common.ServiceFaultException;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.EndpointConfiguration;
import com.prosysopc.ua.stack.core.EndpointDescription;
import com.prosysopc.ua.stack.core.MessageSecurityMode;
import com.prosysopc.ua.stack.core.ResponseHeader;
import com.prosysopc.ua.stack.core.ServiceFault;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.transport.AsyncResult;
import com.prosysopc.ua.stack.transport.SecureChannel;
import com.prosysopc.ua.stack.transport.TransportChannelSettings;
import com.prosysopc.ua.stack.transport.https.HttpsClient;
import com.prosysopc.ua.stack.transport.https.a;
import com.prosysopc.ua.stack.transport.impl.AsyncResultImpl;
import com.prosysopc.ua.stack.transport.security.SecurityPolicy;
import com.prosysopc.ua.stack.utils.StackUtils;
import java.util.HashMap;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpsClientSecureChannel
implements SecureChannel {
    static Logger logger = LoggerFactory.getLogger(HttpsClientSecureChannel.class);
    private EncoderContext ctx;
    int wc = -1;
    HttpsClient wF;
    Executor executor = StackUtils.getBlockingWorkExecutor();

    public HttpsClientSecureChannel(HttpsClient httpsClient) {
        this.wF = httpsClient;
    }

    @Override
    public void close() {
        if (this.wc == -1) {
            return;
        }
        int n2 = this.wc;
        this.wc = -1;
        HashMap<Integer, a> hashMap = new HashMap<Integer, a>(this.wF.wp);
        for (a a2 : hashMap.values()) {
            if (a2.wc != n2) continue;
            a2.cancel();
        }
    }

    @Override
    public AsyncResult<SecureChannel> closeAsync() {
        final AsyncResultImpl<SecureChannel> asyncResultImpl = new AsyncResultImpl<SecureChannel>();
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                HttpsClientSecureChannel.this.close();
                asyncResultImpl.setResult(HttpsClientSecureChannel.this);
            }
        });
        return asyncResultImpl;
    }

    @Override
    public void dispose() {
        this.close();
        this.executor = null;
        this.wF = null;
    }

    @Override
    public String getConnectURL() {
        return this.wF.wi;
    }

    @Override
    public EndpointConfiguration getEndpointConfiguration() {
        return this.wF.wh.getConfiguration();
    }

    @Override
    public EndpointDescription getEndpointDescription() {
        return this.wF.wh.getDescription();
    }

    @Override
    public EncoderContext getMessageContext() {
        return this.ctx;
    }

    @Override
    public MessageSecurityMode getMessageSecurityMode() {
        return this.wF.wh.getDescription().getSecurityMode();
    }

    @Override
    public int getOperationTimeout() {
        Integer n2 = this.wF.wh.getConfiguration().getOperationTimeout();
        return n2 == null ? 0 : n2;
    }

    @Override
    public int getSecureChannelId() {
        return this.wc;
    }

    @Override
    public SecurityPolicy getSecurityPolicy() {
        try {
            return SecurityPolicy.getSecurityPolicy(this.getEndpointDescription().getSecurityPolicyUri());
        }
        catch (ServiceResultException serviceResultException) {
            return null;
        }
    }

    @Override
    public void initialize(String string, TransportChannelSettings transportChannelSettings, EncoderContext encoderContext) throws ServiceResultException {
        this.ctx = encoderContext;
        this.wF.initialize(string, transportChannelSettings, encoderContext);
    }

    @Override
    public void initialize(TransportChannelSettings transportChannelSettings, EncoderContext encoderContext) throws ServiceResultException {
        this.ctx = encoderContext;
        this.wF.initialize(transportChannelSettings.getDescription().getEndpointUrl(), transportChannelSettings, encoderContext);
    }

    @Override
    public boolean isOpen() {
        return false;
    }

    @Override
    public void open() throws ServiceResultException {
        logger.debug("open");
        if (this.wc == -1) {
            this.wc = this.wF.wt.incrementAndGet();
        }
    }

    @Override
    public AsyncResult<SecureChannel> openAsync() {
        final AsyncResultImpl<SecureChannel> asyncResultImpl = new AsyncResultImpl<SecureChannel>();
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    HttpsClientSecureChannel.this.open();
                    asyncResultImpl.setResult(HttpsClientSecureChannel.this);
                }
                catch (ServiceResultException serviceResultException) {
                    asyncResultImpl.setError(serviceResultException);
                }
            }
        });
        return asyncResultImpl;
    }

    @Override
    public <T extends ServiceResponse> T serviceRequest(ServiceRequest<T> serviceRequest) throws ServiceResultException {
        AsyncResult<T> asyncResult = this.wF.serviceRequestAsync(serviceRequest, this.wF.b(serviceRequest), this.wc);
        T t2 = asyncResult.waitForResult();
        if (t2 instanceof ServiceFault) {
            throw new ServiceFaultException((ServiceFault)t2);
        }
        ServiceResponse serviceResponse = (ServiceResponse)t2;
        logger.trace("Response: {}", (Object)serviceResponse);
        logger.debug("Response: {}", (Object)serviceResponse.getClass().getSimpleName());
        ResponseHeader responseHeader = serviceResponse.getResponseHeader();
        if (responseHeader.getServiceResult().isBad()) {
            logger.debug("BAD response: {}", (Object)responseHeader.getServiceResult());
            throw new ServiceFaultException(new ServiceFault(responseHeader));
        }
        return (T)serviceResponse;
    }

    @Override
    public <T extends ServiceResponse> AsyncResult<T> serviceRequestAsync(ServiceRequest<T> serviceRequest) {
        return this.wF.serviceRequestAsync(serviceRequest, this.wF.b(serviceRequest), this.wc);
    }

    @Override
    public void setOperationTimeout(int n2) {
        EndpointConfiguration endpointConfiguration = this.wF.wh.getConfiguration();
        if (endpointConfiguration == null) {
            endpointConfiguration = new EndpointConfiguration();
            this.wF.wh.setConfiguration(endpointConfiguration);
        }
        endpointConfiguration.setOperationTimeout(n2);
    }
}

