/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport;

import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.common.NamespaceTable;
import com.prosysopc.ua.stack.common.RuntimeServiceResultException;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.EndpointConfiguration;
import com.prosysopc.ua.stack.core.EndpointDescription;
import com.prosysopc.ua.stack.transport.https.HttpsSettings;
import com.prosysopc.ua.stack.transport.security.Cert;
import com.prosysopc.ua.stack.transport.security.CertificateValidator;
import com.prosysopc.ua.stack.transport.security.KeyPair;
import com.prosysopc.ua.stack.transport.security.PrivKey;
import com.prosysopc.ua.stack.transport.tcp.io.OpcTcpSettings;
import org.apache.http.conn.ssl.X509HostnameVerifier;

public class TransportChannelSettings
implements Cloneable {
    EndpointDescription vX;
    EndpointConfiguration vY;
    NamespaceTable vZ;
    OpcTcpSettings sg = new OpcTcpSettings();
    HttpsSettings gu = new HttpsSettings();

    public TransportChannelSettings() {
    }

    public TransportChannelSettings(EndpointDescription endpointDescription, EndpointConfiguration endpointConfiguration, Cert cert, PrivKey privKey, CertificateValidator certificateValidator, NamespaceTable namespaceTable) throws RuntimeServiceResultException {
        this.vY = endpointConfiguration;
        this.vX = endpointDescription;
        this.sg.setClientCertificate(cert);
        this.sg.setCertificateValidator(certificateValidator);
        this.sg.setPrivKey(privKey);
        if (namespaceTable != null) {
            this.vZ = namespaceTable;
        }
    }

    public TransportChannelSettings(EndpointDescription endpointDescription, EndpointConfiguration endpointConfiguration, KeyPair keyPair, CertificateValidator certificateValidator, X509HostnameVerifier x509HostnameVerifier) throws RuntimeServiceResultException {
        this.vY = endpointConfiguration;
        this.vX = endpointDescription;
        this.gu.setKeyPair(keyPair, new Cert[0]);
        this.gu.setCertificateValidator(certificateValidator);
        this.gu.setHostnameVerifier(x509HostnameVerifier);
    }

    public TransportChannelSettings clone() {
        TransportChannelSettings transportChannelSettings;
        try {
            transportChannelSettings = (TransportChannelSettings)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException("super.clone failed when it should not", cloneNotSupportedException);
        }
        if (this.vX != null) {
            transportChannelSettings.setDescription(this.vX.clone());
        }
        if (this.vY != null) {
            transportChannelSettings.setConfiguration(this.vY.clone());
        }
        if (this.sg != null) {
            transportChannelSettings.sg = this.sg.clone();
        }
        if (this.gu != null) {
            transportChannelSettings.gu = this.gu.clone();
        }
        if (this.vZ != null) {
            transportChannelSettings.setNamespaceUris(this.vZ);
        }
        return transportChannelSettings;
    }

    public EndpointConfiguration getConfiguration() {
        return this.vY;
    }

    public EndpointDescription getDescription() {
        return this.vX;
    }

    public HttpsSettings getHttpsSettings() {
        return this.gu;
    }

    public NamespaceTable getNamespaceUris() {
        return this.vZ;
    }

    public OpcTcpSettings getOpctcpSettings() {
        return this.sg;
    }

    public Cert getServerCertificate() {
        try {
            if (this.vX != null && this.vX.getServerCertificate() != null && this.vX.getServerCertificate().getLength() > 0) {
                return new Cert(ByteString.asByteArray(this.vX.getServerCertificate()));
            }
            return null;
        }
        catch (ServiceResultException serviceResultException) {
            throw new RuntimeServiceResultException(serviceResultException);
        }
    }

    public void readFrom(TransportChannelSettings transportChannelSettings) {
        if (transportChannelSettings.vX != null) {
            this.vX = transportChannelSettings.vX.clone();
        }
        if (transportChannelSettings.vY != null) {
            this.vY = transportChannelSettings.vY.clone();
        }
        if (transportChannelSettings.sg != null) {
            this.sg.readFrom(transportChannelSettings.sg);
        }
        if (transportChannelSettings.gu != null) {
            this.gu.readFrom(transportChannelSettings.gu);
        }
        if (transportChannelSettings.vZ != null) {
            this.vZ = transportChannelSettings.vZ;
        }
    }

    public void setConfiguration(EndpointConfiguration endpointConfiguration) {
        this.vY = endpointConfiguration;
    }

    public void setDescription(EndpointDescription endpointDescription) {
        this.vX = endpointDescription;
    }

    public void setHttpsSettings(HttpsSettings httpsSettings) {
        this.gu = httpsSettings;
    }

    public void setNamespaceUris(NamespaceTable namespaceTable) {
        this.vZ = namespaceTable;
    }

    public void setOpctcpSettings(OpcTcpSettings opcTcpSettings) {
        this.sg = opcTcpSettings;
    }

    public String toString() {
        return "TransportChannelSettings [description=" + this.vX + ", configuration=" + this.vY + ", namespaceUris=" + this.vZ + ", opctcpSettings=" + this.sg + ", httpsSettings=" + this.gu + "]";
    }
}

