/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport;

import com.prosysopc.ua.UaAddress;
import com.prosysopc.ua.stack.application.Server;
import com.prosysopc.ua.stack.transport.Endpoint;
import com.prosysopc.ua.stack.transport.EndpointServer;

public class EndpointBinding {
    public final EndpointServer endpointServer;
    public final Endpoint endpointAddress;
    public final Server serviceServer;
    private final String vV;

    public EndpointBinding(EndpointServer endpointServer, Endpoint endpoint, Server server) {
        if (endpointServer == null || endpoint == null || server == null) {
            throw new IllegalArgumentException("null arg");
        }
        this.endpointServer = endpointServer;
        this.endpointAddress = endpoint;
        this.serviceServer = server;
        this.vV = endpoint.endpointUrl;
    }

    public boolean equals(Object object) {
        if (!(object instanceof EndpointBinding)) {
            return false;
        }
        EndpointBinding endpointBinding = (EndpointBinding)object;
        if (!endpointBinding.endpointServer.equals(this.endpointServer)) {
            return false;
        }
        if (!endpointBinding.endpointAddress.equals(this.endpointAddress)) {
            return false;
        }
        return endpointBinding.serviceServer.equals(this.serviceServer);
    }

    public String getOriginalAddress() {
        return this.vV;
    }

    public int hashCode() {
        return this.endpointServer.hashCode() + 13 * this.serviceServer.hashCode() + 7 * this.endpointAddress.hashCode();
    }

    public void rewriteEndpointUrlPort(int n2) {
        UaAddress uaAddress = UaAddress.parse(this.endpointAddress.endpointUrl);
        UaAddress uaAddress2 = UaAddress.fromComponents(uaAddress.getProtocol(), uaAddress.getHost(), n2, uaAddress.getServerName());
        this.endpointAddress.endpointUrl = uaAddress2.getAddress();
    }

    public String toString() {
        return "(EndpointServer=" + this.endpointServer + ", EndpointAddress=" + this.endpointAddress + ", ServiceServer=" + this.serviceServer + ")";
    }
}

