/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.encoding.binary;

import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNamespace;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.UaOptionSet;
import com.prosysopc.ua.stack.builtintypes.BuiltinsMap;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.Enumeration;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.ExtensionObject;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.UnsignedLong;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.builtintypes.XmlElement;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.encoding.EncodeType;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.encoding.EncoderMode;
import com.prosysopc.ua.stack.encoding.EncodingException;
import com.prosysopc.ua.stack.encoding.IEncoder;
import com.prosysopc.ua.stack.encoding.binary.ByteUtils;
import com.prosysopc.ua.stack.encoding.binary.NodeIdEncoding;
import com.prosysopc.ua.stack.utils.BijectionMap;
import com.prosysopc.ua.stack.utils.EncodingLimitsExceededIoException;
import com.prosysopc.ua.stack.utils.MultiDimensionArrayUtils;
import com.prosysopc.ua.stack.utils.bytebuffer.ByteBufferWriteable;
import com.prosysopc.ua.stack.utils.bytebuffer.IBinaryWriteable;
import com.prosysopc.ua.stack.utils.bytebuffer.OutputStreamWriteable;
import com.prosysopc.ua.typedictionary.EnumerationSpecification;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.OptionSetSpecification;
import com.prosysopc.ua.typedictionary.SimpleTypeSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.typedictionary.UaDataTypeSpecification;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.net.ConnectException;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryEncoder
implements IEncoder {
    private static final Logger logger = LoggerFactory.getLogger(BinaryEncoder.class);
    private static final Map<Class<?>, a<?>> tK = new HashMap();
    private static final a<?>[] ud = new a[51];
    private static final BijectionMap<UaNodeId, Class<?>> tM = new BijectionMap();
    private static final a<DateTime> ue;
    private static final a<ExtensionObject> uf;
    private static final a<Structure> ug;
    private static final a<DataValue> uh;
    private static final a<Variant> ui;
    private static final a<DiagnosticInfo> uj;
    private static final a<Enumeration> uk;
    private static final a<BigDecimal> ul;
    private static final a<UaOptionSet> um;
    private static final a<Object> un;
    private static final ExpandedNodeId tX;
    private static final byte[] uo;
    private final List<Locale> mA = new CopyOnWriteArrayList<Locale>();
    IBinaryWriteable up;
    EncoderContext ctx;
    EncoderMode uq = EncoderMode.NonStrict;
    private final byte[] ur = new byte[2];
    private final byte[] us = new byte[4];
    private final byte[] ut = new byte[7];
    private final byte[] uu = new byte[8];

    private static <T> void a(UaNodeId uaNodeId, Class<T> clazz, a<T> a2) throws Error {
        if (uaNodeId == null) {
            return;
        }
        Object object = uaNodeId.getValue();
        if (!(object instanceof UnsignedInteger)) {
            throw new Error("Internal error, builtintype UaNodeId was not numeric");
        }
        int n2 = ((UnsignedInteger)object).intValue();
        if (n2 != 50 && n2 > 25) {
            throw new Error("Internal error, DataType " + uaNodeId + " higher index than expected, was: " + n2);
        }
        if (ud[n2] != null) {
            throw new Error("Internal error, DataType " + uaNodeId + " already has a serializer defined");
        }
        BinaryEncoder.ud[n2] = a2;
        if (tM.containsLeft(uaNodeId)) {
            throw new Error("Internal error, DataType " + uaNodeId + " already mapped to a class");
        }
        if (tM.containsRight(clazz)) {
            throw new Error("Internal error, Class " + clazz + " already mapped to a DataTypeId");
        }
        tM.map(uaNodeId, clazz);
    }

    private static <T> void b(UaNodeId uaNodeId, Class<T> clazz, a<T> a2) {
        if (!Object.class.equals(clazz) && !Modifier.isFinal(clazz.getModifiers())) {
            throw new Error("Class " + clazz + " is not final, and cannot be put to known final classes serialization helper");
        }
        if (tK.put(clazz, a2) != null) {
            throw new Error("Class " + clazz + " already has a serializer defined");
        }
        BinaryEncoder.a(uaNodeId, clazz, a2);
    }

    private static <T> a<T> i(Class<?> clazz) throws EncodingException {
        if (clazz == null) {
            throw new EncodingException("Cannot encode class null");
        }
        a<?> a2 = tK.get(clazz);
        if (a2 != null) {
            return a2;
        }
        if (ExtensionObject.class.isAssignableFrom(clazz)) {
            return uf;
        }
        if (Structure.class.isAssignableFrom(clazz)) {
            return ug;
        }
        if (DataValue.class.isAssignableFrom(clazz)) {
            return uh;
        }
        if (Variant.class.isAssignableFrom(clazz)) {
            return ui;
        }
        if (DiagnosticInfo.class.isAssignableFrom(clazz)) {
            return uj;
        }
        if (Enumeration.class.isAssignableFrom(clazz)) {
            return uk;
        }
        if (DateTime.class.isAssignableFrom(clazz)) {
            return ue;
        }
        if (BigDecimal.class.isAssignableFrom(clazz)) {
            return ul;
        }
        if (UaOptionSet.class.isAssignableFrom(clazz)) {
            return um;
        }
        throw new EncodingException("Cannot encode class: " + clazz);
    }

    private static b<Object> a(UaNodeId uaNodeId, EncoderContext encoderContext) throws EncodingException {
        if (uaNodeId == null) {
            throw new IllegalArgumentException("The given DataTypeId cannot be null");
        }
        a<Object> a2 = BinaryEncoder.k(uaNodeId);
        UaDataTypeSpecification uaDataTypeSpecification = null;
        if (a2 == null) {
            uaDataTypeSpecification = encoderContext.getDataTypeSpecification(uaNodeId);
            if (uaDataTypeSpecification == null) {
                logger.warn("Cannot find UaDataTypeSpecification for DataTypeId: {}", (Object)uaNodeId);
            } else if (uaDataTypeSpecification instanceof SimpleTypeSpecification) {
                a2 = BinaryEncoder.k(((SimpleTypeSpecification)uaDataTypeSpecification).getBaseTypeId());
            } else if (uaDataTypeSpecification instanceof StructureSpecification) {
                a2 = ug;
            } else if (uaDataTypeSpecification instanceof OptionSetSpecification) {
                a2 = um;
            } else if (uaDataTypeSpecification instanceof EnumerationSpecification) {
                a2 = uk;
            }
        }
        if (a2 == null) {
            throw new EncodingException("Cannot find serializer for DataTypeId: " + uaNodeId);
        }
        return new b<Object>(a2, uaDataTypeSpecification);
    }

    private static UnsignedInteger b(UnsignedInteger unsignedInteger, int n2) {
        if (unsignedInteger == null) {
            throw new IllegalArgumentException("mask cannot be null");
        }
        if (n2 < 0 || n2 > 31) {
            throw new IllegalArgumentException("position must be between 0-31");
        }
        int n3 = 1 << n2;
        return unsignedInteger.or(n3);
    }

    private static EncodingException b(IOException iOException) {
        if (iOException instanceof ClosedChannelException) {
            return new EncodingException(StatusCodes.Bad_ConnectionClosed, (Throwable)iOException);
        }
        if (iOException instanceof EOFException) {
            return new EncodingException(StatusCodes.Bad_EndOfStream, (Throwable)iOException);
        }
        if (iOException instanceof ConnectException) {
            return new EncodingException(StatusCodes.Bad_ConnectionRejected, (Throwable)iOException);
        }
        if (iOException instanceof SocketException) {
            return new EncodingException(StatusCodes.Bad_CommunicationError, (Throwable)iOException);
        }
        if (iOException instanceof EncodingLimitsExceededIoException) {
            return new EncodingException(StatusCodes.Bad_EncodingLimitsExceeded, (Throwable)iOException, iOException.getMessage());
        }
        return new EncodingException(StatusCodes.Bad_UnexpectedError, (Throwable)iOException);
    }

    private static a<?> k(UaNodeId uaNodeId) {
        int n2;
        if (!UaNamespace.STANDARD.equals(uaNodeId.getNamespace())) {
            return null;
        }
        Object object = uaNodeId.getValue();
        if (object instanceof UnsignedInteger && (n2 = ((UnsignedInteger)object).toIntBits()) > 0 && n2 < 51) {
            return ud[n2];
        }
        return null;
    }

    static ExtensionObject[] a(BigDecimal[] bigDecimalArray) throws EncodingException {
        if (bigDecimalArray == null) {
            return null;
        }
        ExtensionObject[] extensionObjectArray = new ExtensionObject[bigDecimalArray.length];
        for (int i2 = 0; i2 < bigDecimalArray.length; ++i2) {
            extensionObjectArray[i2] = BinaryEncoder.a(bigDecimalArray[i2]);
        }
        return extensionObjectArray;
    }

    static ExtensionObject a(BigDecimal bigDecimal) throws EncodingException {
        int n2 = bigDecimal.scale();
        if (n2 > Short.MAX_VALUE) {
            throw new EncodingException("Decimal scale overflow Short max value: " + n2);
        }
        if (n2 < Short.MIN_VALUE) {
            throw new EncodingException("Decimal scale underflow Short min value: " + n2);
        }
        short s2 = (short)n2;
        ByteBuffer byteBuffer = ByteBuffer.allocate(2);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.putShort(s2);
        byte[] byArray = byteBuffer.array();
        byte[] byArray2 = ByteUtils.reverse(bigDecimal.unscaledValue().toByteArray());
        byte[] byArray3 = ByteUtils.concat(byArray, byArray2);
        return new ExtensionObject(tX, ByteString.valueOf(byArray3));
    }

    public BinaryEncoder(byte[] byArray) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.setWriteable(new ByteBufferWriteable(byteBuffer));
    }

    public BinaryEncoder(byte[] byArray, int n2, int n3) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n2, n3);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.setWriteable(new ByteBufferWriteable(byteBuffer));
    }

    public BinaryEncoder(ByteBuffer byteBuffer) {
        ByteBufferWriteable byteBufferWriteable = new ByteBufferWriteable(byteBuffer);
        this.setWriteable(byteBufferWriteable);
    }

    public BinaryEncoder(IBinaryWriteable iBinaryWriteable) {
        this.setWriteable(iBinaryWriteable);
    }

    public BinaryEncoder(OutputStream outputStream) {
        OutputStreamWriteable outputStreamWriteable = new OutputStreamWriteable(outputStream);
        outputStreamWriteable.order(ByteOrder.LITTLE_ENDIAN);
        this.setWriteable(outputStreamWriteable);
    }

    @Override
    public EncoderContext getEncoderContext() {
        return this.ctx;
    }

    public EncoderMode getEncoderType() {
        return this.uq;
    }

    @Override
    public List<Locale> getLocales() {
        return this.mA;
    }

    public IBinaryWriteable getOutput() {
        return this.up;
    }

    public IBinaryWriteable getWriteable() {
        return this.up;
    }

    @Override
    public void put(String string, Object object, UaNodeId uaNodeId, int n2) throws EncodingException {
        try {
            if (n2 < 0) {
                throw new EncodingException("The given dimensions cannot be negative");
            }
            this.a(object, null, uaNodeId, n2);
        }
        catch (Exception exception) {
            throw new EncodingException("Error while trying to encode DataTypeId: " + uaNodeId, exception);
        }
    }

    public void setEncoderContext(EncoderContext encoderContext) {
        this.ctx = encoderContext;
    }

    public void setEncoderMode(EncoderMode encoderMode) {
        this.uq = encoderMode;
    }

    public void setWriteable(IBinaryWriteable iBinaryWriteable) {
        if (iBinaryWriteable.order() != ByteOrder.LITTLE_ENDIAN) {
            throw new IllegalArgumentException("Writeable must be in Little-Ending byte order");
        }
        this.up = iBinaryWriteable;
    }

    private void assertArrayLength(int n2) throws EncodingException {
        int n3 = this.ctx.getMaxArrayLength();
        if (n3 > 0 && n2 > n3) {
            EncodingException encodingException = new EncodingException(StatusCodes.Bad_EncodingLimitsExceeded, "MaxArrayLength " + n3 + " < " + n2);
            logger.warn("assertArrayLength: failed", (Throwable)encodingException);
            throw encodingException;
        }
    }

    private void assertByteStringLength(int n2) throws EncodingException {
        int n3 = this.ctx.getMaxByteStringLength();
        if (n3 > 0 && n2 > n3) {
            EncodingException encodingException = new EncodingException(StatusCodes.Bad_EncodingLimitsExceeded, "MaxByteStringLength " + n3 + " < " + n2);
            logger.warn("assertByteStringLength: failed", (Throwable)encodingException);
            throw encodingException;
        }
    }

    private void j(Object object) throws EncodingException {
        if (object != null) {
            return;
        }
        if (this.uq == EncoderMode.Strict) {
            throw new EncodingException("Cannot encode null value");
        }
    }

    private void assertStringLength(int n2) throws EncodingException {
        int n3 = this.ctx.getMaxStringLength();
        if (n3 > 0 && n2 > n3) {
            EncodingException encodingException = new EncodingException(StatusCodes.Bad_EncodingLimitsExceeded, "MaxStringLength " + n3 + " < " + n2);
            logger.warn("assertStringLength: failed", (Throwable)encodingException);
            throw encodingException;
        }
    }

    private void a(Object object, Class<?> clazz, UaNodeId uaNodeId, int n2) throws EncodingException {
        UaDataTypeSpecification uaDataTypeSpecification;
        Object[] objectArray;
        if (n2 < 0) {
            throw new EncodingException("The given dimensions cannot be negative");
        }
        a a2 = null;
        UaNodeId uaNodeId2 = uaNodeId;
        if (uaNodeId2 == null && clazz != null) {
            uaNodeId2 = tM.getLeft(MultiDimensionArrayUtils.getComponentType(clazz));
        }
        if (uaNodeId2 != null) {
            objectArray = BinaryEncoder.a(uaNodeId2, this.getEncoderContext());
            a2 = ((b)objectArray).uv;
            uaDataTypeSpecification = ((b)objectArray).uc;
        } else {
            a2 = BinaryEncoder.i(MultiDimensionArrayUtils.getComponentType(clazz));
            uaDataTypeSpecification = null;
        }
        if (n2 == 0) {
            a2.put(this, null, object, uaNodeId2, uaDataTypeSpecification);
            return;
        }
        if (n2 == 1) {
            if (object == null) {
                this.esw();
                return;
            }
            objectArray = (Object[])object;
            int n3 = objectArray.length;
            this.assertArrayLength(n3);
            this.p(n3);
            for (Object object2 : objectArray) {
                a2.put(this, null, object2, uaNodeId2, uaDataTypeSpecification);
            }
            return;
        }
        if (object == null) {
            objectArray = new int[n2];
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                objectArray[i2] = -1;
            }
            this.a((int[])objectArray);
            return;
        }
        objectArray = MultiDimensionArrayUtils.getArrayLengths(object);
        Object[] objectArray2 = (Object[])MultiDimensionArrayUtils.muxArray(object, (int[])objectArray, Object.class);
        int n4 = objectArray2.length;
        this.assertArrayLength(n4);
        this.a((int[])objectArray);
        for (Object object3 : objectArray2) {
            a2.put(this, null, object3, uaNodeId2, uaDataTypeSpecification);
        }
    }

    private void a(Boolean bl) throws EncodingException {
        try {
            if (bl == null) {
                this.j(bl);
                this.putSByte(null, 0);
            } else {
                this.up.put(bl != false ? (byte)1 : 0);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    private void a(UnsignedByte unsignedByte) throws EncodingException {
        try {
            if (unsignedByte == null) {
                this.j(unsignedByte);
                this.q(0);
            } else {
                this.up.put(unsignedByte.toByteBits());
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    private void b(byte[] byArray) throws EncodingException {
        try {
            if (byArray == null) {
                this.up.put(uo);
            } else {
                this.assertByteStringLength(byArray.length);
                this.up.putInt(byArray.length);
                this.up.put(byArray);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    private void e(ByteString byteString) throws EncodingException {
        this.b(byteString == null ? null : byteString.getValue());
    }

    private void j(DataValue dataValue) throws EncodingException {
        if (dataValue == null) {
            this.q(0);
            return;
        }
        int n2 = 0;
        if (dataValue.getValue() != null) {
            n2 |= 1;
        }
        if (dataValue.getStatusCode() != null && !dataValue.getStatusCode().equals(StatusCode.GOOD)) {
            n2 |= 2;
        }
        if (dataValue.getSourceTimestamp() != null && !dataValue.getSourceTimestamp().equals(DateTime.MIN_VALUE)) {
            n2 |= 4;
        }
        if (dataValue.getServerTimestamp() != null && !dataValue.getServerTimestamp().equals(DateTime.MIN_VALUE)) {
            n2 |= 8;
        }
        if (dataValue.getSourcePicoseconds() != null && !dataValue.getSourcePicoseconds().equals(UnsignedShort.MIN_VALUE)) {
            n2 |= 0x10;
        }
        if (dataValue.getServerPicoseconds() != null && !dataValue.getServerPicoseconds().equals(UnsignedShort.MIN_VALUE)) {
            n2 |= 0x20;
        }
        this.q(n2);
        if ((n2 & 1) == 1) {
            this.d(dataValue.getValue());
        }
        if ((n2 & 2) == 2) {
            this.a(dataValue.getStatusCode());
        }
        if ((n2 & 4) == 4) {
            this.e(dataValue.getSourceTimestamp());
        }
        if ((n2 & 0x10) == 16) {
            this.a(dataValue.getSourcePicoseconds());
        }
        if ((n2 & 8) == 8) {
            this.e(dataValue.getServerTimestamp());
        }
        if ((n2 & 0x20) == 32) {
            this.a(dataValue.getServerPicoseconds());
        }
    }

    private void e(DateTime dateTime) throws EncodingException {
        try {
            if (dateTime == null) {
                this.j(dateTime);
                this.up.putLong(0L);
            } else if (dateTime.compareTo(DateTime.MAX_VALUE) >= 0) {
                this.up.putLong(Long.MAX_VALUE);
            } else if (dateTime.compareTo(DateTime.MIN_VALUE) <= 0) {
                this.up.putLong(0L);
            } else {
                this.up.putLong(dateTime.getValue());
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    private void b(BigDecimal bigDecimal) throws EncodingException {
        ExtensionObject extensionObject = BinaryEncoder.a(bigDecimal);
        this.b(extensionObject);
    }

    private void b(DiagnosticInfo diagnosticInfo) throws EncodingException {
        if (diagnosticInfo == null) {
            this.q(0);
            return;
        }
        int n2 = 0;
        if (diagnosticInfo.getSymbolicId() != null) {
            n2 |= 1;
        }
        if (diagnosticInfo.getNamespaceUriStr() != null) {
            n2 |= 2;
        }
        if (diagnosticInfo.getLocalizedTextStr() != null) {
            n2 |= 4;
        }
        if (diagnosticInfo.getLocaleStr() != null) {
            n2 |= 8;
        }
        if (diagnosticInfo.getAdditionalInfo() != null) {
            n2 |= 0x10;
        }
        if (diagnosticInfo.getInnerStatusCode() != null) {
            n2 |= 0x20;
        }
        if (diagnosticInfo.getInnerDiagnosticInfo() != null) {
            n2 |= 0x40;
        }
        try {
            this.putSByte(null, n2);
            if ((n2 & 1) == 1) {
                this.up.putInt(diagnosticInfo.getSymbolicId());
            }
            if ((n2 & 2) == 2) {
                this.up.putInt(diagnosticInfo.getNamespaceUri());
            }
            if ((n2 & 8) == 8) {
                this.up.putInt(diagnosticInfo.getLocale());
            }
            if ((n2 & 4) == 4) {
                this.up.putInt(diagnosticInfo.getLocalizedText());
            }
            if ((n2 & 0x10) == 16) {
                this.J(diagnosticInfo.getAdditionalInfo());
            }
            if ((n2 & 0x20) == 32) {
                this.a(diagnosticInfo.getInnerStatusCode());
            }
            if ((n2 & 0x40) == 64) {
                this.b(diagnosticInfo.getInnerDiagnosticInfo());
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    private void c(Double d2) throws EncodingException {
        try {
            if (d2 == null) {
                this.j(d2);
                this.up.putDouble(0.0);
            } else {
                this.up.putDouble(d2);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    private void a(Enumeration enumeration) throws EncodingException {
        try {
            if (enumeration == null) {
                this.up.putInt(0);
                return;
            }
            this.up.putInt(enumeration.getValue());
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    private void c(ExpandedNodeId expandedNodeId) throws EncodingException {
        try {
            if (expandedNodeId == null) {
                expandedNodeId = ExpandedNodeId.NULL;
            }
            int n2 = 0;
            if (expandedNodeId.getNamespaceUri() != null) {
                n2 = (byte)(n2 | 0x80);
            }
            if (expandedNodeId.getServerIndex() != null) {
                n2 = (byte)(n2 | 0x40);
            }
            switch (expandedNodeId.getIdType()) {
                case Numeric: {
                    UnsignedInteger unsignedInteger = (UnsignedInteger)expandedNodeId.getValue();
                    if (unsignedInteger.compareTo(UnsignedByte.MAX_VALUE) <= 0 && expandedNodeId.getNamespaceIndex() == 0) {
                        this.ur[0] = (byte)(NodeIdEncoding.TwoByte.getBits() | n2);
                        this.ur[1] = unsignedInteger.byteValue();
                        this.up.put(this.ur);
                        break;
                    }
                    if (unsignedInteger.compareTo(UnsignedShort.MAX_VALUE) <= 0 && expandedNodeId.getNamespaceIndex() < 256) {
                        this.us[0] = (byte)(NodeIdEncoding.FourByte.getBits() | n2);
                        this.us[1] = (byte)expandedNodeId.getNamespaceIndex();
                        ByteUtils.writeShort(unsignedInteger.shortValue(), this.us, 2, ByteOrder.LITTLE_ENDIAN);
                        this.up.put(this.us);
                        break;
                    }
                    this.ut[0] = (byte)(NodeIdEncoding.Numeric.getBits() | n2);
                    ByteUtils.writeShort((short)expandedNodeId.getNamespaceIndex(), this.ut, 1, ByteOrder.LITTLE_ENDIAN);
                    ByteUtils.writeInt(unsignedInteger.intValue(), this.ut, 3, ByteOrder.LITTLE_ENDIAN);
                    this.up.put(this.ut);
                    break;
                }
                case String: {
                    this.q(NodeIdEncoding.String.getBits() | n2);
                    this.up.putShort((short)expandedNodeId.getNamespaceIndex());
                    this.J((String)expandedNodeId.getValue());
                    break;
                }
                case Opaque: {
                    this.q(NodeIdEncoding.ByteString.getBits() | n2);
                    this.up.putShort((short)expandedNodeId.getNamespaceIndex());
                    this.e((ByteString)expandedNodeId.getValue());
                    break;
                }
                case Guid: {
                    this.q(NodeIdEncoding.Guid.getBits() | n2);
                    this.up.putShort((short)expandedNodeId.getNamespaceIndex());
                    this.a((UUID)expandedNodeId.getValue());
                    break;
                }
                default: {
                    throw new EncodingException("Unsupported (Expanded)NodeId Encoding byte " + expandedNodeId.getIdType());
                }
            }
            if (expandedNodeId.getNamespaceUri() != null) {
                this.J(expandedNodeId.getNamespaceUri());
            }
            if (expandedNodeId.getServerIndex() != null) {
                this.up.putInt(expandedNodeId.getServerIndex().intValue());
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    private void b(ExtensionObject extensionObject) throws EncodingException {
        NodeId nodeId;
        if (extensionObject == null) {
            this.j(extensionObject);
            this.o(null);
            this.q(0);
            return;
        }
        if (!extensionObject.isEncoded()) {
            this.b(ExtensionObject.binaryEncode((Structure)extensionObject.getObject(), this.ctx, this.mA));
            return;
        }
        try {
            nodeId = this.ctx.getNamespaceTable().toNodeId(extensionObject.getTypeId());
        }
        catch (ServiceResultException serviceResultException) {
            throw new EncodingException("Could not get namespace index for given id");
        }
        this.o(nodeId);
        Object object = extensionObject.getObject();
        if (object == null) {
            this.q(0);
        } else if (extensionObject.getEncodeType() == EncodeType.Binary) {
            this.q(1);
            this.e((ByteString)object);
        } else if (extensionObject.getEncodeType() == EncodeType.Xml) {
            this.q(2);
            this.a((XmlElement)object);
        } else {
            throw new EncodingException("Unexpected object " + (Object)((Object)extensionObject.getEncodeType()));
        }
    }

    private void b(Collection<ExtensionObject> collection) throws EncodingException {
        try {
            if (collection == null) {
                this.up.put(uo);
                return;
            }
            this.assertArrayLength(collection.size());
            this.up.putInt(collection.size());
            for (ExtensionObject extensionObject : collection) {
                this.b(extensionObject);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    private void c(ExtensionObject[] extensionObjectArray) throws EncodingException {
        try {
            if (extensionObjectArray == null) {
                this.up.put(uo);
                return;
            }
            this.assertArrayLength(extensionObjectArray.length);
            this.up.putInt(extensionObjectArray.length);
            for (ExtensionObject extensionObject : extensionObjectArray) {
                this.b(extensionObject);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    private void a(Structure[] structureArray) throws EncodingException {
        try {
            if (structureArray == null) {
                this.up.put(uo);
                return;
            }
            this.assertArrayLength(structureArray.length);
            this.up.putInt(structureArray.length);
            for (Structure structure : structureArray) {
                this.b(new ExtensionObject(structure));
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    private void a(Float f2) throws EncodingException {
        try {
            if (f2 == null) {
                this.j(f2);
                this.up.putFloat(0.0f);
            } else {
                this.up.putFloat(f2.floatValue());
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    private void a(UUID uUID) throws EncodingException {
        try {
            if (uUID == null) {
                this.j(uUID);
                this.up.putLong(0L);
                this.up.putLong(0L);
            } else {
                int n2;
                long l2 = uUID.getMostSignificantBits();
                long l3 = uUID.getLeastSignificantBits();
                byte[] byArray = new byte[16];
                for (n2 = 0; n2 < 8; ++n2) {
                    byArray[n2] = (byte)(l2 >>> 8 * (7 - n2));
                }
                for (n2 = 8; n2 < 16; ++n2) {
                    byArray[n2] = (byte)(l3 >>> 8 * (7 - n2));
                }
                this.up.put(byArray[3]);
                this.up.put(byArray[2]);
                this.up.put(byArray[1]);
                this.up.put(byArray[0]);
                this.up.put(byArray[5]);
                this.up.put(byArray[4]);
                this.up.put(byArray[7]);
                this.up.put(byArray[6]);
                for (n2 = 8; n2 < 16; ++n2) {
                    this.up.put(byArray[n2]);
                }
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    private void a(Short s2) throws EncodingException {
        try {
            if (s2 == null) {
                this.j(s2);
                this.up.putShort((short)0);
            } else {
                this.up.putShort(s2);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    private void c(Integer n2) throws EncodingException {
        try {
            if (n2 == null) {
                this.j(n2);
                this.up.putInt(0);
            } else {
                this.up.putInt(n2);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    private void a(int[] nArray) throws EncodingException {
        if (nArray == null) {
            this.esw();
            return;
        }
        this.assertArrayLength(nArray.length);
        this.p(nArray.length);
        for (int n2 : nArray) {
            this.p(n2);
        }
    }

    private void p(int n2) throws EncodingException {
        try {
            this.up.putInt(n2);
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    private void b(Long l2) throws EncodingException {
        try {
            if (l2 == null) {
                this.j(l2);
                this.up.putLong(0L);
            } else {
                this.up.putLong(l2);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    private void b(LocalizedText localizedText) throws EncodingException {
        try {
            if (localizedText == null) {
                this.putSByte(null, 0);
                return;
            }
            localizedText = localizedText.asSingleLocale(this.getLocales());
            String string = localizedText.getLocaleId();
            String string2 = localizedText.getText();
            boolean bl = string != null && !string.isEmpty();
            boolean bl2 = string2 != null && !string2.isEmpty();
            byte by = (byte)((bl ? 1 : 0) | (bl2 ? 2 : 0));
            this.up.put(by);
            if (bl) {
                this.J(string);
            }
            if (bl2) {
                this.J(string2);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    private void o(NodeId nodeId) throws EncodingException {
        try {
            if (nodeId == null) {
                nodeId = NodeId.NULL;
            }
            switch (nodeId.getIdType()) {
                case Numeric: {
                    UnsignedInteger unsignedInteger = (UnsignedInteger)nodeId.getValue();
                    if (unsignedInteger.compareTo(UnsignedByte.MAX_VALUE) <= 0 && nodeId.getNamespaceIndex() == 0) {
                        this.ur[0] = NodeIdEncoding.TwoByte.getBits();
                        this.ur[1] = unsignedInteger.byteValue();
                        this.up.put(this.ur);
                        break;
                    }
                    if (unsignedInteger.compareTo(UnsignedShort.MAX_VALUE) <= 0 && nodeId.getNamespaceIndex() < 256) {
                        this.us[0] = NodeIdEncoding.FourByte.getBits();
                        this.us[1] = (byte)nodeId.getNamespaceIndex();
                        ByteUtils.writeShort(unsignedInteger.shortValue(), this.us, 2, ByteOrder.LITTLE_ENDIAN);
                        this.up.put(this.us);
                        break;
                    }
                    this.ut[0] = NodeIdEncoding.Numeric.getBits();
                    ByteUtils.writeShort((short)nodeId.getNamespaceIndex(), this.ut, 1, ByteOrder.LITTLE_ENDIAN);
                    ByteUtils.writeInt(unsignedInteger.intValue(), this.ut, 3, ByteOrder.LITTLE_ENDIAN);
                    this.up.put(this.ut);
                    break;
                }
                case String: {
                    this.up.put(NodeIdEncoding.String.getBits());
                    this.up.putShort((short)nodeId.getNamespaceIndex());
                    this.J((String)nodeId.getValue());
                    break;
                }
                case Opaque: {
                    this.up.put(NodeIdEncoding.ByteString.getBits());
                    this.up.putShort((short)nodeId.getNamespaceIndex());
                    this.e((ByteString)nodeId.getValue());
                    break;
                }
                case Guid: {
                    UUID uUID = (UUID)nodeId.getValue();
                    this.up.put(NodeIdEncoding.Guid.getBits());
                    this.up.putShort((short)nodeId.getNamespaceIndex());
                    this.a(uUID);
                    break;
                }
                default: {
                    throw new EncodingException("Unknown IdType: " + nodeId.getIdType());
                }
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    private void esw() throws EncodingException {
        try {
            this.up.put(uo);
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    private void a(UaOptionSet uaOptionSet, OptionSetSpecification optionSetSpecification) throws EncodingException {
        if (uaOptionSet == null) {
            this.put(null, null, optionSetSpecification.getBaseTypeId(), 0);
        } else {
            this.put(null, uaOptionSet.getValue(), optionSetSpecification.getBaseTypeId(), 0);
        }
    }

    private void d(QualifiedName qualifiedName) throws EncodingException {
        try {
            if (qualifiedName == null) {
                this.up.putShort((short)0);
                this.J(null);
                return;
            }
            this.up.putShort((short)qualifiedName.getNamespaceIndex());
            this.J(qualifiedName.getName());
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    private void a(Byte by) throws EncodingException {
        try {
            if (by == null) {
                this.j(by);
                this.q(0);
            } else {
                this.up.put(by);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    private void q(int n2) throws EncodingException {
        this.a((byte)n2);
    }

    private void a(byte by) throws EncodingException {
        try {
            this.up.put(by);
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    private void a(StatusCode statusCode) throws EncodingException {
        try {
            if (statusCode == null) {
                this.j(statusCode);
                this.up.putInt(StatusCode.GOOD.getValueAsIntBits());
            } else {
                this.up.putInt(statusCode.getValueAsIntBits());
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    private void J(String string) throws EncodingException {
        try {
            if (string == null) {
                this.j(string);
                this.up.put(uo);
            } else {
                this.assertStringLength(string.length());
                byte[] byArray = string.getBytes(StandardCharsets.UTF_8);
                this.up.putInt(byArray.length);
                this.up.put(byArray);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    private void a(Structure structure, StructureSpecification structureSpecification) throws EncodingException {
        try {
            if (structure == null) {
                structure = structureSpecification.toInstanceBuilder().build();
            }
            Map<FieldSpecification, Object> map = structure.toFieldsMap(structureSpecification);
            switch (structureSpecification.getStructureType()) {
                case UNION: 
                case UNION_SUBTYPES: {
                    this.a(map, structureSpecification);
                    break;
                }
                case OPTIONAL: {
                    this.a(map);
                    break;
                }
                case SUBTYPES: {
                    this.b(map, structureSpecification);
                    break;
                }
                case NORMAL: {
                    this.b(map);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown StructureType: " + (Object)((Object)structureSpecification.getStructureType()));
                }
            }
        }
        catch (Exception exception) {
            throw new EncodingException("Could not encode Structure", exception);
        }
    }

    private void a(Map<FieldSpecification, Object> map) throws EncodingException {
        int n2 = -1;
        UnsignedInteger unsignedInteger = UnsignedInteger.ZERO;
        for (Map.Entry<FieldSpecification, Object> entry : map.entrySet()) {
            if (!entry.getKey().isOptional()) continue;
            ++n2;
            if (entry.getValue() == null) continue;
            unsignedInteger = BinaryEncoder.b(unsignedInteger, n2);
        }
        this.putUInt32("EncodingMask", unsignedInteger);
        for (Map.Entry<FieldSpecification, Object> entry : map.entrySet()) {
            FieldSpecification fieldSpecification = entry.getKey();
            Object object = entry.getValue();
            if (object == null && fieldSpecification.isOptional()) continue;
            int n3 = fieldSpecification.getValueRank() < 0 ? 0 : fieldSpecification.getValueRank();
            this.put(null, object, fieldSpecification.getDataTypeId(), n3);
        }
    }

    private void b(Map<FieldSpecification, Object> map) throws EncodingException {
        for (Map.Entry<FieldSpecification, Object> entry : map.entrySet()) {
            FieldSpecification fieldSpecification = entry.getKey();
            Object object = entry.getValue();
            int n2 = fieldSpecification.getValueRank() < 0 ? 0 : fieldSpecification.getValueRank();
            this.put(null, object, fieldSpecification.getDataTypeId(), n2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void a(Map<FieldSpecification, Object> map, StructureSpecification structureSpecification) throws EncodingException {
        int n2;
        long l2 = 0L;
        FieldSpecification fieldSpecification = null;
        Object object = null;
        for (Map.Entry<FieldSpecification, Object> entry : map.entrySet()) {
            ++l2;
            if (entry.getValue() == null) continue;
            fieldSpecification = entry.getKey();
            object = entry.getValue();
            break;
        }
        if (fieldSpecification == null) {
            this.putUInt32("SwitchField", UnsignedInteger.ZERO);
            return;
        }
        this.putUInt32("SwitchField", UnsignedInteger.valueOf(l2));
        int n3 = n2 = fieldSpecification.getValueRank() < 0 ? 0 : fieldSpecification.getValueRank();
        if (fieldSpecification.isAllowSubTypes()) {
            if (ExtensionObject.class.isAssignableFrom(fieldSpecification.getCompositeClass())) {
                this.put(null, object, UaIds.Structure, n2);
                return;
            } else {
                if (!Object.class.equals(fieldSpecification.getCompositeClass())) throw new EncodingException("The java class for AllowSubTypes field should either be ExtensionObject.class or Object.class, got: " + fieldSpecification + "in structure type: " + structureSpecification);
                this.put(null, object, UaIds.BaseDataType, n2);
            }
            return;
        } else {
            this.put(null, object, fieldSpecification.getDataTypeId(), n2);
        }
    }

    private void b(Map<FieldSpecification, Object> map, StructureSpecification structureSpecification) throws EncodingException {
        for (Map.Entry<FieldSpecification, Object> entry : map.entrySet()) {
            int n2;
            FieldSpecification fieldSpecification = entry.getKey();
            Object object = entry.getValue();
            int n3 = n2 = fieldSpecification.getValueRank() < 0 ? 0 : fieldSpecification.getValueRank();
            if (fieldSpecification.isAllowSubTypes()) {
                if (ExtensionObject.class.isAssignableFrom(fieldSpecification.getCompositeClass())) {
                    this.put(null, object, UaIds.Structure, n2);
                    continue;
                }
                if (Object.class.equals(fieldSpecification.getCompositeClass())) {
                    this.put(null, object, UaIds.BaseDataType, n2);
                    continue;
                }
                throw new EncodingException("The java class for AllowSubTypes field should either be ExtensionObject.class or Object.class, got: " + fieldSpecification + "in structure type: " + structureSpecification);
            }
            this.put(null, object, fieldSpecification.getDataTypeId(), n2);
        }
    }

    private void a(UnsignedShort unsignedShort) throws EncodingException {
        try {
            if (unsignedShort == null) {
                this.j(unsignedShort);
                this.up.putShort((short)0);
            } else {
                this.up.putShort(unsignedShort.toShortBits());
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    private void k(UnsignedInteger unsignedInteger) throws EncodingException {
        try {
            if (unsignedInteger == null) {
                this.j(unsignedInteger);
                this.up.putInt(0);
            } else {
                this.up.putInt(unsignedInteger.toIntBits());
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    private void a(UnsignedLong unsignedLong) throws EncodingException {
        try {
            if (unsignedLong == null) {
                this.j(unsignedLong);
                this.up.putLong(0L);
            } else {
                this.up.putLong(unsignedLong.toLongBits());
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    private void a(XmlElement xmlElement) throws EncodingException {
        try {
            if (xmlElement == null) {
                this.up.put(uo);
            } else {
                this.b(xmlElement.getData());
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Deprecated
    void a(int n2, Object object) throws EncodingException {
        switch (n2) {
            case 1: {
                this.putBooleanArray(null, (Boolean[])object);
                break;
            }
            case 2: {
                this.putSByteArray(null, (Byte[])object);
                break;
            }
            case 3: {
                this.putByteArray(null, (UnsignedByte[])object);
                break;
            }
            case 4: {
                this.putInt16Array(null, (Short[])object);
                break;
            }
            case 5: {
                this.putUInt16Array(null, (UnsignedShort[])object);
                break;
            }
            case 6: {
                this.putInt32Array((String)null, (Integer[])object);
                break;
            }
            case 7: {
                this.putUInt32Array(null, (UnsignedInteger[])object);
                break;
            }
            case 8: {
                this.putInt64Array(null, (Long[])object);
                break;
            }
            case 9: {
                this.putUInt64Array(null, (UnsignedLong[])object);
                break;
            }
            case 10: {
                this.putFloatArray(null, (Float[])object);
                break;
            }
            case 11: {
                this.putDoubleArray(null, (Double[])object);
                break;
            }
            case 12: {
                this.putStringArray(null, (String[])object);
                break;
            }
            case 13: {
                this.putDateTimeArray(null, (DateTime[])object);
                break;
            }
            case 14: {
                this.putGuidArray(null, (UUID[])object);
                break;
            }
            case 15: {
                this.putByteStringArray(null, (ByteString[])object);
                break;
            }
            case 16: {
                this.putXmlElementArray(null, (XmlElement[])object);
                break;
            }
            case 17: {
                this.putNodeIdArray(null, (NodeId[])object);
                break;
            }
            case 18: {
                this.putExpandedNodeIdArray(null, (ExpandedNodeId[])object);
                break;
            }
            case 19: {
                this.putStatusCodeArray(null, (StatusCode[])object);
                break;
            }
            case 20: {
                this.putQualifiedNameArray(null, (QualifiedName[])object);
                break;
            }
            case 21: {
                this.putLocalizedTextArray(null, (LocalizedText[])object);
                break;
            }
            case 22: {
                if (object instanceof ExtensionObject[]) {
                    this.c((ExtensionObject[])object);
                    break;
                }
                if (object instanceof Structure[]) {
                    this.a((Structure[])object);
                    break;
                }
                throw new EncodingException("cannot encode " + object);
            }
            case 23: {
                this.putDataValueArray(null, (DataValue[])object);
                break;
            }
            case 24: {
                this.putVariantArray(null, (Variant[])object);
                break;
            }
            case 25: {
                this.putDiagnosticInfoArray(null, (DiagnosticInfo[])object);
                break;
            }
            default: {
                throw new EncodingException("cannot encode builtin type " + n2);
            }
        }
    }

    @Deprecated
    void b(int n2, Object object) throws EncodingException {
        switch (n2) {
            case 1: {
                this.a((Boolean)object);
                break;
            }
            case 2: {
                this.a((Byte)object);
                break;
            }
            case 3: {
                this.a((UnsignedByte)object);
                break;
            }
            case 4: {
                this.a((Short)object);
                break;
            }
            case 5: {
                this.a((UnsignedShort)object);
                break;
            }
            case 6: {
                this.c((Integer)object);
                break;
            }
            case 7: {
                this.k((UnsignedInteger)object);
                break;
            }
            case 8: {
                this.b((Long)object);
                break;
            }
            case 9: {
                this.a((UnsignedLong)object);
                break;
            }
            case 10: {
                this.a((Float)object);
                break;
            }
            case 11: {
                this.c((Double)object);
                break;
            }
            case 12: {
                this.J((String)object);
                break;
            }
            case 13: {
                this.e((DateTime)object);
                break;
            }
            case 14: {
                this.a((UUID)object);
                break;
            }
            case 15: {
                this.e((ByteString)object);
                break;
            }
            case 16: {
                this.a((XmlElement)object);
                break;
            }
            case 17: {
                this.o((NodeId)object);
                break;
            }
            case 18: {
                this.c((ExpandedNodeId)object);
                break;
            }
            case 19: {
                this.a((StatusCode)object);
                break;
            }
            case 20: {
                this.d((QualifiedName)object);
                break;
            }
            case 21: {
                this.b((LocalizedText)object);
                break;
            }
            case 22: {
                if (object instanceof Structure) {
                    this.b(new ExtensionObject((Structure)object));
                    break;
                }
                this.b((ExtensionObject)object);
                break;
            }
            case 23: {
                this.j((DataValue)object);
                break;
            }
            case 24: {
                this.d((Variant)object);
                break;
            }
            case 25: {
                this.b((DiagnosticInfo)object);
                break;
            }
            default: {
                throw new EncodingException("cannot encode builtin type " + n2);
            }
        }
    }

    void d(Variant variant) throws EncodingException {
        boolean bl;
        int n2;
        if (variant == null) {
            this.j(variant);
            this.q(0);
            return;
        }
        ExtensionObject[] extensionObjectArray = variant.getValue();
        if (extensionObjectArray == null) {
            this.q(0);
            return;
        }
        Class<?> clazz = variant.getCompositeClass();
        Integer n3 = BuiltinsMap.ID_MAP.get(clazz);
        if (n3 != null) {
            n2 = n3;
            bl = false;
        } else if (Structure.class.isAssignableFrom(clazz)) {
            n2 = 22;
            bl = false;
        } else if (BigDecimal.class.isAssignableFrom(clazz)) {
            n2 = 22;
            bl = true;
        } else {
            throw new EncodingException("Non-suitable composite class for Variant: " + clazz);
        }
        if (!variant.isArray()) {
            this.q(n2);
            if (bl) {
                extensionObjectArray = BinaryEncoder.a((BigDecimal)extensionObjectArray);
            }
            this.b(n2, extensionObjectArray);
            return;
        }
        int n4 = variant.getDimension();
        if (n4 == 1) {
            this.q(n2 | 0x80);
            if (bl) {
                extensionObjectArray = BinaryEncoder.a((BigDecimal[])extensionObjectArray);
            }
            this.a(n2, extensionObjectArray);
            return;
        }
        int[] nArray = variant.getArrayDimensions();
        int n5 = MultiDimensionArrayUtils.getLength(nArray);
        MultiDimensionArrayUtils.ArrayIterator arrayIterator = MultiDimensionArrayUtils.arrayIterator(variant.getValue(), variant.getArrayDimensions());
        try {
            this.q(n2 | 0xC0);
            this.up.putInt(n5);
            while (arrayIterator.hasNext()) {
                Object object = arrayIterator.next();
                if (bl) {
                    object = BinaryEncoder.a((BigDecimal)object);
                }
                this.b(n2, object);
            }
            this.a(nArray);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new EncodingException("The dimensions of inner array elements of a multi-dimension variable must be equal in length", arrayIndexOutOfBoundsException);
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    static {
        tX = new ExpandedNodeId("http://opcfoundation.org/UA/", Identifiers.Decimal.getValue());
        BinaryEncoder.b(UaIds.Boolean, Boolean.class, (binaryEncoder, string, bl, uaNodeId, uaDataTypeSpecification) -> binaryEncoder.a((Boolean)bl));
        BinaryEncoder.b(UaIds.SByte, Byte.class, (binaryEncoder, string, by, uaNodeId, uaDataTypeSpecification) -> binaryEncoder.a((Byte)by));
        BinaryEncoder.b(UaIds.Byte, UnsignedByte.class, (binaryEncoder, string, unsignedByte, uaNodeId, uaDataTypeSpecification) -> binaryEncoder.a((UnsignedByte)unsignedByte));
        BinaryEncoder.b(UaIds.Int16, Short.class, (binaryEncoder, string, s2, uaNodeId, uaDataTypeSpecification) -> binaryEncoder.a((Short)s2));
        BinaryEncoder.b(UaIds.UInt16, UnsignedShort.class, (binaryEncoder, string, unsignedShort, uaNodeId, uaDataTypeSpecification) -> binaryEncoder.a((UnsignedShort)unsignedShort));
        BinaryEncoder.b(UaIds.Int32, Integer.class, (binaryEncoder, string, n2, uaNodeId, uaDataTypeSpecification) -> binaryEncoder.c((Integer)n2));
        BinaryEncoder.b(UaIds.UInt32, UnsignedInteger.class, (binaryEncoder, string, unsignedInteger, uaNodeId, uaDataTypeSpecification) -> binaryEncoder.k((UnsignedInteger)unsignedInteger));
        BinaryEncoder.b(UaIds.Int64, Long.class, (binaryEncoder, string, l2, uaNodeId, uaDataTypeSpecification) -> binaryEncoder.b((Long)l2));
        BinaryEncoder.b(UaIds.UInt64, UnsignedLong.class, (binaryEncoder, string, unsignedLong, uaNodeId, uaDataTypeSpecification) -> binaryEncoder.a((UnsignedLong)unsignedLong));
        BinaryEncoder.b(UaIds.Float, Float.class, (binaryEncoder, string, f2, uaNodeId, uaDataTypeSpecification) -> binaryEncoder.a((Float)f2));
        BinaryEncoder.b(UaIds.Double, Double.class, (binaryEncoder, string, d2, uaNodeId, uaDataTypeSpecification) -> binaryEncoder.c((Double)d2));
        BinaryEncoder.b(UaIds.String, String.class, (binaryEncoder, string, string2, uaNodeId, uaDataTypeSpecification) -> binaryEncoder.J((String)string2));
        BinaryEncoder.b(UaIds.Guid, UUID.class, (binaryEncoder, string, uUID, uaNodeId, uaDataTypeSpecification) -> binaryEncoder.a((UUID)uUID));
        BinaryEncoder.b(UaIds.ByteString, ByteString.class, (binaryEncoder, string, byteString, uaNodeId, uaDataTypeSpecification) -> binaryEncoder.b(ByteString.asByteArray(byteString)));
        BinaryEncoder.b(UaIds.XmlElement, XmlElement.class, (binaryEncoder, string, xmlElement, uaNodeId, uaDataTypeSpecification) -> binaryEncoder.a((XmlElement)xmlElement));
        BinaryEncoder.b(UaIds.NodeId, NodeId.class, (binaryEncoder, string, nodeId, uaNodeId, uaDataTypeSpecification) -> binaryEncoder.o((NodeId)nodeId));
        BinaryEncoder.b(UaIds.ExpandedNodeId, ExpandedNodeId.class, (binaryEncoder, string, expandedNodeId, uaNodeId, uaDataTypeSpecification) -> binaryEncoder.c((ExpandedNodeId)expandedNodeId));
        BinaryEncoder.b(UaIds.StatusCode, StatusCode.class, (binaryEncoder, string, statusCode, uaNodeId, uaDataTypeSpecification) -> binaryEncoder.a((StatusCode)statusCode));
        BinaryEncoder.b(UaIds.QualifiedName, QualifiedName.class, (binaryEncoder, string, qualifiedName, uaNodeId, uaDataTypeSpecification) -> binaryEncoder.d((QualifiedName)qualifiedName));
        BinaryEncoder.b(UaIds.LocalizedText, LocalizedText.class, (binaryEncoder, string, localizedText, uaNodeId, uaDataTypeSpecification) -> binaryEncoder.b((LocalizedText)localizedText));
        ue = (binaryEncoder, string, dateTime, uaNodeId, uaDataTypeSpecification) -> binaryEncoder.e((DateTime)dateTime);
        BinaryEncoder.a(UaIds.DateTime, DateTime.class, ue);
        uf = (binaryEncoder, string, extensionObject, uaNodeId, uaDataTypeSpecification) -> binaryEncoder.b((ExtensionObject)extensionObject);
        BinaryEncoder.a(UaIds.Structure, ExtensionObject.class, uf);
        ug = (binaryEncoder, string, structure, uaNodeId, uaDataTypeSpecification) -> {
            if (uaDataTypeSpecification != null) {
                binaryEncoder.a((Structure)structure, (StructureSpecification)uaDataTypeSpecification);
                return;
            }
            StructureSpecification structureSpecification = binaryEncoder.getEncoderContext().getStructureSpecification(uaNodeId);
            if (structureSpecification == null) {
                throw new EncodingException("Cannot find StructureSpecification for DataType: " + uaNodeId);
            }
            binaryEncoder.a((Structure)structure, structureSpecification);
        };
        uh = (binaryEncoder, string, dataValue, uaNodeId, uaDataTypeSpecification) -> binaryEncoder.j((DataValue)dataValue);
        BinaryEncoder.a(UaIds.DataValue, DataValue.class, uh);
        ui = (binaryEncoder, string, variant, uaNodeId, uaDataTypeSpecification) -> binaryEncoder.d((Variant)variant);
        uj = (binaryEncoder, string, diagnosticInfo, uaNodeId, uaDataTypeSpecification) -> binaryEncoder.b((DiagnosticInfo)diagnosticInfo);
        BinaryEncoder.a(UaIds.DiagnosticInfo, DiagnosticInfo.class, uj);
        uk = (binaryEncoder, string, enumeration, uaNodeId, uaDataTypeSpecification) -> binaryEncoder.a((Enumeration)enumeration);
        ul = (binaryEncoder, string, bigDecimal, uaNodeId, uaDataTypeSpecification) -> binaryEncoder.b((BigDecimal)bigDecimal);
        BinaryEncoder.a(UaIds.Decimal, BigDecimal.class, ul);
        um = (binaryEncoder, string, uaOptionSet, uaNodeId, uaDataTypeSpecification) -> {
            if (uaDataTypeSpecification != null) {
                binaryEncoder.a((UaOptionSet)uaOptionSet, (OptionSetSpecification)uaDataTypeSpecification);
                return;
            }
            OptionSetSpecification optionSetSpecification = binaryEncoder.getEncoderContext().getOptionSetSpecification(uaNodeId);
            if (optionSetSpecification == null) {
                throw new EncodingException("Cannot resolve OptionSetSpecification for: " + uaNodeId);
            }
            binaryEncoder.a((UaOptionSet)uaOptionSet, optionSetSpecification);
        };
        un = (binaryEncoder, string, object, uaNodeId, uaDataTypeSpecification) -> {
            if (object == null) {
                ui.put(binaryEncoder, string, null, UaIds.BaseDataType, uaDataTypeSpecification);
            } else if (object instanceof Variant) {
                ui.put(binaryEncoder, string, (Variant)object, UaIds.BaseDataType, uaDataTypeSpecification);
            } else {
                ui.put(binaryEncoder, string, new Variant(object), UaIds.BaseDataType, uaDataTypeSpecification);
            }
        };
        BinaryEncoder.b(null, Object.class, un);
        BinaryEncoder.ud[24] = un;
        BinaryEncoder.ud[22] = uf;
        uo = ByteUtils.intToBytes(-1, ByteOrder.LITTLE_ENDIAN);
    }

    private static class b<T> {
        private final a<T> uv;
        private final UaDataTypeSpecification uc;

        b(a<T> a2, UaDataTypeSpecification uaDataTypeSpecification) {
            this.uv = a2;
            this.uc = uaDataTypeSpecification;
        }
    }

    private static interface a<T> {
        public void put(BinaryEncoder var1, String var2, T var3, UaNodeId var4, UaDataTypeSpecification var5) throws EncodingException;
    }
}

