/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.encoding.binary;

import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNamespace;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.UaOptionSet;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.Enumeration;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.ExtensionObject;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.UnsignedLong;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.builtintypes.XmlElement;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.encoding.AbstractDecoder;
import com.prosysopc.ua.stack.encoding.DecodingException;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.encoding.IDecoder;
import com.prosysopc.ua.stack.encoding.binary.ByteUtils;
import com.prosysopc.ua.stack.encoding.binary.NodeIdEncoding;
import com.prosysopc.ua.stack.utils.BijectionMap;
import com.prosysopc.ua.stack.utils.MultiDimensionArrayUtils;
import com.prosysopc.ua.stack.utils.bytebuffer.ByteBufferReadable;
import com.prosysopc.ua.stack.utils.bytebuffer.IBinaryReadable;
import com.prosysopc.ua.stack.utils.bytebuffer.InputStreamReadable;
import com.prosysopc.ua.typedictionary.EnumerationSpecification;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.OptionSetSpecification;
import com.prosysopc.ua.typedictionary.SimpleTypeSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.typedictionary.UaDataTypeSpecification;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.ConnectException;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryDecoder
extends AbstractDecoder
implements IDecoder {
    private static final Logger logger = LoggerFactory.getLogger(BinaryDecoder.class);
    private static final Map<Class<?>, a<?>> tK = new HashMap();
    private static final a<?>[] tL = new a[51];
    private static final BijectionMap<UaNodeId, Class<?>> tM = new BijectionMap();
    private static final a<DateTime> tN;
    private static final a<ExtensionObject> tO;
    private static final a<Structure> tP;
    private static final a<Object> tQ;
    private static final a<DataValue> tR;
    private static final a<Variant> tS;
    private static final a<DiagnosticInfo> tT;
    private static final a<Enumeration> tU;
    private static final a<BigDecimal> tV;
    private static final a<UaOptionSet> tW;
    private static final ExpandedNodeId tX;
    IBinaryReadable tY;
    private BiConsumer<FieldSpecification, Object> tZ;

    private static <T> void a(UaNodeId uaNodeId, Class<T> clazz, a<T> a2) throws Error {
        if (uaNodeId == null) {
            return;
        }
        Object object = uaNodeId.getValue();
        if (!(object instanceof UnsignedInteger)) {
            throw new Error("Internal error, builtintype UaNodeId was not numeric");
        }
        int n2 = ((UnsignedInteger)object).intValue();
        if (n2 != 50 && n2 > 25) {
            throw new Error("Internal error, DataType " + uaNodeId + " higher index than expected, was: " + n2);
        }
        if (tL[n2] != null) {
            throw new Error("Internal error, DataType " + uaNodeId + " already has a serializer defined");
        }
        BinaryDecoder.tL[n2] = a2;
        if (tM.containsLeft(uaNodeId)) {
            throw new Error("Internal error, DataType " + uaNodeId + " already mapped to a class");
        }
        if (tM.containsRight(clazz)) {
            throw new Error("Internal error, Class " + clazz + " already mapped to a DataTypeId");
        }
        tM.map(uaNodeId, clazz);
    }

    private static <T> void b(UaNodeId uaNodeId, Class<T> clazz, a<T> a2) {
        if (!Object.class.equals(clazz) && !Modifier.isFinal(clazz.getModifiers())) {
            throw new Error("Class " + clazz + " is not final, and cannot be put to known final classes serialization helper");
        }
        if (tK.put(clazz, a2) != null) {
            throw new Error("Class " + clazz + " already has a serializer defined");
        }
        BinaryDecoder.a(uaNodeId, clazz, a2);
    }

    private static <T> a<T> h(Class<?> clazz) throws DecodingException {
        if (clazz == null) {
            throw new DecodingException("Cannot decode class null");
        }
        a<?> a2 = tK.get(clazz);
        if (a2 != null) {
            return a2;
        }
        if (ExtensionObject.class.isAssignableFrom(clazz)) {
            return tO;
        }
        if (Structure.class.isAssignableFrom(clazz)) {
            return tP;
        }
        if (DataValue.class.isAssignableFrom(clazz)) {
            return tR;
        }
        if (Variant.class.isAssignableFrom(clazz)) {
            return tS;
        }
        if (DiagnosticInfo.class.isAssignableFrom(clazz)) {
            return tT;
        }
        if (Enumeration.class.isAssignableFrom(clazz)) {
            return tU;
        }
        if (DateTime.class.isAssignableFrom(clazz)) {
            return tN;
        }
        if (BigDecimal.class.isAssignableFrom(clazz)) {
            return tV;
        }
        if (UaOptionSet.class.isAssignableFrom(clazz)) {
            return tW;
        }
        throw new DecodingException("Cannot decode class: " + clazz);
    }

    private static b<Object> a(UaNodeId uaNodeId, EncoderContext encoderContext, UaDataTypeSpecification uaDataTypeSpecification) throws DecodingException {
        if (uaNodeId == null) {
            throw new IllegalArgumentException("The given DataTypeId cannot be null");
        }
        a<Object> a2 = BinaryDecoder.j(uaNodeId);
        UaDataTypeSpecification uaDataTypeSpecification2 = null;
        Class<?> clazz = null;
        if (a2 == null) {
            uaDataTypeSpecification2 = uaDataTypeSpecification != null ? uaDataTypeSpecification : encoderContext.getDataTypeSpecification(uaNodeId);
            if (uaDataTypeSpecification2 == null) {
                logger.warn("Cannot find UaDataTypeSpecification for DataTypeId: {}", (Object)uaNodeId);
            } else if (uaDataTypeSpecification2 instanceof SimpleTypeSpecification) {
                a2 = BinaryDecoder.j(((SimpleTypeSpecification)uaDataTypeSpecification2).getBaseTypeId());
                clazz = uaDataTypeSpecification2.getJavaClass();
            } else if (uaDataTypeSpecification2 instanceof StructureSpecification) {
                a2 = tP;
                clazz = uaDataTypeSpecification2.getJavaClass();
            } else if (uaDataTypeSpecification2 instanceof OptionSetSpecification) {
                a2 = tW;
                clazz = uaDataTypeSpecification2.getJavaClass();
            } else if (uaDataTypeSpecification2 instanceof EnumerationSpecification) {
                a2 = tU;
                clazz = uaDataTypeSpecification2.getJavaClass();
            }
        } else {
            clazz = tM.getRight(uaNodeId);
        }
        if (a2 == null) {
            throw new DecodingException("Cannot find serializer for DataTypeId: " + uaNodeId);
        }
        if (clazz == null) {
            throw new DecodingException("Cannot find the class mapping for DataTypeId: " + uaNodeId);
        }
        return new b<Object>(a2, uaDataTypeSpecification2, clazz);
    }

    private static boolean a(UnsignedInteger unsignedInteger, int n2) {
        if (unsignedInteger == null) {
            throw new IllegalArgumentException("mask cannot be null");
        }
        if (n2 < 0 || n2 > 31) {
            throw new IllegalArgumentException("position must be between 0-31");
        }
        int n3 = 1 << n2;
        if (UnsignedInteger.ZERO.equals(unsignedInteger)) {
            return false;
        }
        return unsignedInteger.and(n3).equals(UnsignedInteger.valueOf(n3));
    }

    private static DecodingException a(IOException iOException) {
        if (iOException instanceof ClosedChannelException) {
            return new DecodingException(StatusCodes.Bad_ConnectionClosed, (Throwable)iOException);
        }
        if (iOException instanceof EOFException) {
            return new DecodingException(StatusCodes.Bad_EndOfStream, (Throwable)iOException);
        }
        if (iOException instanceof ConnectException) {
            return new DecodingException(StatusCodes.Bad_ConnectionRejected, (Throwable)iOException);
        }
        if (iOException instanceof SocketException) {
            return new DecodingException(StatusCodes.Bad_UnexpectedError, (Throwable)iOException);
        }
        return new DecodingException(StatusCodes.Bad_UnexpectedError, (Throwable)iOException);
    }

    private static a<?> j(UaNodeId uaNodeId) {
        int n2;
        if (!UaNamespace.STANDARD.equals(uaNodeId.getNamespace())) {
            return null;
        }
        Object object = uaNodeId.getValue();
        if (object instanceof UnsignedInteger && (n2 = ((UnsignedInteger)object).toIntBits()) > 0 && n2 < 51) {
            return tL[n2];
        }
        return null;
    }

    public BinaryDecoder(byte[] byArray) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.setReadable(new ByteBufferReadable(byteBuffer));
    }

    public BinaryDecoder(byte[] byArray, int n2, int n3) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n2, n3);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.setReadable(new ByteBufferReadable(byteBuffer));
    }

    public BinaryDecoder(ByteBuffer byteBuffer) {
        this.setReadable(new ByteBufferReadable(byteBuffer));
    }

    public BinaryDecoder(IBinaryReadable iBinaryReadable) {
        this.setReadable(iBinaryReadable);
    }

    public BinaryDecoder(InputStream inputStream, int n2) {
        InputStreamReadable inputStreamReadable = new InputStreamReadable(inputStream, n2);
        inputStreamReadable.order(ByteOrder.LITTLE_ENDIAN);
        this.setReadable(inputStreamReadable);
    }

    @Override
    public <T> T get(String string, UaNodeId uaNodeId, int n2) throws DecodingException {
        Class clazz;
        if (uaNodeId == null) {
            throw new IllegalArgumentException("The given DataTypeId cannot be null");
        }
        UaDataTypeSpecification uaDataTypeSpecification = null;
        if (UaIds.BaseDataType.equals(uaNodeId)) {
            clazz = Object.class;
        } else if (UaIds.Structure.equals(uaNodeId)) {
            clazz = ExtensionObject.class;
        } else {
            uaDataTypeSpecification = this.getEncoderContext().getDataTypeSpecification(uaNodeId);
            if (uaDataTypeSpecification == null) {
                throw new DecodingException("Cannot find UaDataTypeSpecification, cannot decode DataType: " + uaNodeId);
            }
            clazz = uaDataTypeSpecification.getJavaClass();
        }
        try {
            if (n2 < 0) {
                throw new DecodingException("The given dimensions cannot be negative");
            }
            Object object = this.a(clazz, uaNodeId, n2, uaDataTypeSpecification);
            return (T)object;
        }
        catch (Exception exception) {
            throw new DecodingException("Error while trying to decode, DataTypeId: " + uaNodeId, exception);
        }
    }

    @Override
    public EncoderContext getEncoderContext() {
        return this.ctx;
    }

    @Override
    public int[] getInt32Array_(String string) throws DecodingException {
        return this.esi();
    }

    public IBinaryReadable getReadable() {
        return this.tY;
    }

    public void setEncoderContext(EncoderContext encoderContext) {
        this.ctx = encoderContext;
    }

    public void setReadable(IBinaryReadable iBinaryReadable) {
        if (iBinaryReadable.order() != ByteOrder.LITTLE_ENDIAN) {
            throw new IllegalArgumentException("Readable must be in Little-Ending byte order");
        }
        this.tY = iBinaryReadable;
    }

    public void setStructureFieldDecodeListener(BiConsumer<FieldSpecification, Object> biConsumer) {
        this.tZ = biConsumer;
    }

    private BigDecimal d(ByteString byteString) {
        byte[] byArray = byteString.getValue();
        ByteBuffer byteBuffer = ByteBuffer.allocate(2);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.put(byArray[0]);
        byteBuffer.put(byArray[1]);
        byteBuffer.rewind();
        short s2 = byteBuffer.getShort();
        byte[] byArray2 = Arrays.copyOfRange(byArray, 2, byArray.length);
        byArray2 = ByteUtils.reverse(byArray2);
        BigInteger bigInteger = new BigInteger(byArray2);
        return new BigDecimal(bigInteger, s2);
    }

    private UaOptionSet b(OptionSetSpecification optionSetSpecification) throws DecodingException {
        Object obj = this.a(optionSetSpecification.getBaseTypeJavaClass(), optionSetSpecification.getBaseTypeId(), 0, null);
        try {
            return (UaOptionSet)new Variant(obj).asOptionSet(optionSetSpecification);
        }
        catch (Exception exception) {
            throw new DecodingException(exception, "Could not resolve the value as UaOptionSet");
        }
    }

    private <T> T a(Class<T> clazz, UaNodeId uaNodeId, int n2, UaDataTypeSpecification uaDataTypeSpecification) throws DecodingException {
        Class clazz2;
        UaDataTypeSpecification uaDataTypeSpecification2;
        Object[] objectArray;
        if (n2 < 0) {
            throw new DecodingException("The given dimensions cannot be negative");
        }
        a a2 = null;
        UaNodeId uaNodeId2 = uaNodeId;
        if (uaNodeId2 == null && clazz != null) {
            uaNodeId2 = tM.getLeft(MultiDimensionArrayUtils.getComponentType(clazz));
        }
        if (uaNodeId2 != null) {
            objectArray = BinaryDecoder.a(uaNodeId2, this.getEncoderContext(), uaDataTypeSpecification);
            a2 = ((b)objectArray).ub;
            uaDataTypeSpecification2 = ((b)objectArray).uc;
            clazz2 = ((b)objectArray).javaClass;
        } else {
            clazz2 = MultiDimensionArrayUtils.getComponentType(clazz);
            a2 = BinaryDecoder.h(clazz2);
            uaDataTypeSpecification2 = null;
        }
        if (n2 == 0) {
            objectArray = a2;
            return objectArray.get(this, null, clazz, uaNodeId, uaDataTypeSpecification2);
        }
        if (n2 == 1) {
            int n3 = this.esj();
            this.assertArrayLength(n3);
            if (n3 == -1) {
                return null;
            }
            if (n3 == 0) {
                return (T)this.emptyArrayForClass(clazz2);
            }
            Object[] objectArray2 = (Object[])Array.newInstance(clazz2, n3);
            a a3 = a2;
            for (int i2 = 0; i2 < n3; ++i2) {
                objectArray2[i2] = a3.get(this, null, clazz2, uaNodeId, uaDataTypeSpecification2);
            }
            return (T)objectArray2;
        }
        objectArray = this.esi();
        if (objectArray == null) {
            return null;
        }
        int n4 = 1;
        for (Object object : objectArray) {
            if (object < 0) {
                return null;
            }
            n4 *= object;
        }
        this.assertArrayLength(n4);
        Object[] objectArray3 = (Object[])Array.newInstance(clazz2, n4);
        a a4 = a2;
        for (int i3 = 0; i3 < n4; ++i3) {
            objectArray3[i3] = a4.get(this, null, clazz2, uaNodeId, uaDataTypeSpecification2);
        }
        return (T)MultiDimensionArrayUtils.demuxArray((Object)objectArray3, (int[])objectArray, clazz2);
    }

    private Object n(int n2) throws DecodingException {
        switch (n2) {
            case 1: {
                return this.getBooleanArray(null);
            }
            case 2: {
                return this.getSByteArray(null);
            }
            case 3: {
                return this.getByteArray(null);
            }
            case 4: {
                return this.getInt16Array(null);
            }
            case 5: {
                return this.getUInt16Array(null);
            }
            case 6: {
                return this.getInt32Array(null);
            }
            case 7: {
                return this.getUInt32Array(null);
            }
            case 8: {
                return this.getInt64Array(null);
            }
            case 9: {
                return this.getUInt64Array(null);
            }
            case 10: {
                return this.getFloatArray(null);
            }
            case 11: {
                return this.getDoubleArray(null);
            }
            case 12: {
                return this.getStringArray(null);
            }
            case 13: {
                return this.getDateTimeArray(null);
            }
            case 14: {
                return this.getGuidArray(null);
            }
            case 15: {
                return this.getByteStringArray(null);
            }
            case 16: {
                return this.getXmlElementArray(null);
            }
            case 17: {
                return this.getNodeIdArray(null);
            }
            case 18: {
                return this.getExpandedNodeIdArray(null);
            }
            case 19: {
                return this.getStatusCodeArray(null);
            }
            case 20: {
                return this.getQualifiedNameArray(null);
            }
            case 21: {
                return this.getLocalizedTextArray(null);
            }
            case 22: {
                return this.getExtensionObjectArray(null);
            }
            case 23: {
                return this.getDataValueArray(null);
            }
            case 24: {
                return this.getVariantArray(null);
            }
            case 25: {
                return this.getDiagnosticInfoArray(null);
            }
        }
        throw new DecodingException("Cannot decode builtin type id " + n2);
    }

    private Boolean erU() throws DecodingException {
        try {
            if (this.tY.get() == 0) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    private UnsignedByte erV() throws DecodingException {
        try {
            return UnsignedByte.getFromBits(this.tY.get());
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    private ByteString erW() throws DecodingException {
        try {
            int n2 = this.tY.getInt();
            if (n2 == -1) {
                return null;
            }
            this.assertByteStringLength(n2);
            byte[] byArray = new byte[n2];
            this.tY.get(byArray);
            return ByteString.valueOf(byArray);
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    private DataValue erX() throws DecodingException {
        try {
            byte by = this.tY.get();
            Variant variant = (by & 1) != 0 ? this.esu() : null;
            StatusCode statusCode = (by & 2) != 0 ? this.esp() : StatusCode.GOOD;
            DateTime dateTime = (by & 4) != 0 ? this.erY() : null;
            UnsignedShort unsignedShort = (by & 0x10) != 0 ? this.esr() : UnsignedShort.MIN_VALUE;
            DateTime dateTime2 = (by & 8) != 0 ? this.erY() : null;
            UnsignedShort unsignedShort2 = (by & 0x20) != 0 ? this.esr() : UnsignedShort.MIN_VALUE;
            return new DataValue(variant, statusCode, dateTime, unsignedShort, dateTime2, unsignedShort2);
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    private DateTime erY() throws DecodingException {
        try {
            long l2 = this.tY.getLong();
            return DateTime.valueOf(l2);
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    private BigDecimal erZ() throws DecodingException {
        ExtensionObject extensionObject = this.esd();
        if (!this.getEncoderContext().getNamespaceTable().nodeIdEquals(extensionObject.getTypeId(), tX)) {
            logger.error("Encountered a Decimal that does not define correct id, is {}", (Object)extensionObject.getTypeId());
        }
        try {
            return this.d((ByteString)extensionObject.getObject());
        }
        catch (ClassCastException classCastException) {
            throw new DecodingException("Did not get an ExtensionObject with ByteString data for Decimal type", classCastException);
        }
    }

    private DiagnosticInfo esa() throws DecodingException {
        try {
            byte by = this.tY.get();
            Integer n2 = (by & 1) != 0 ? this.esh() : null;
            Integer n3 = (by & 2) != 0 ? this.esh() : null;
            Integer n4 = (by & 8) != 0 ? this.esh() : null;
            Integer n5 = (by & 4) != 0 ? this.esh() : null;
            String string = (by & 0x10) != 0 ? this.esq() : null;
            StatusCode statusCode = (by & 0x20) != 0 ? this.esp() : null;
            DiagnosticInfo diagnosticInfo = (by & 0x40) != 0 ? this.esa() : null;
            return new DiagnosticInfo(string, diagnosticInfo, statusCode, n4, n5, n3, n2);
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    private Double esb() throws DecodingException {
        try {
            return this.tY.getDouble();
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    private <T extends Enumeration> T b(EnumerationSpecification enumerationSpecification) throws DecodingException {
        try {
            int n2 = this.tY.getInt();
            return (T)enumerationSpecification.getByValue(n2);
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    private ExpandedNodeId esc() throws DecodingException {
        try {
            Object object;
            int n2;
            byte by = this.tY.get();
            boolean bl = (by & 0x40) == 64;
            boolean bl2 = (by & 0x80) == 128;
            NodeIdEncoding nodeIdEncoding = NodeIdEncoding.getNodeIdEncoding(by & 0x3F);
            if (nodeIdEncoding == null) {
                throw new DecodingException("Unexpected NodeId Encoding Byte " + by);
            }
            String string = null;
            UnsignedInteger unsignedInteger = null;
            switch (nodeIdEncoding) {
                case TwoByte: {
                    n2 = 0;
                    object = UnsignedInteger.getFromBits(this.tY.get() & 0xFF);
                    break;
                }
                case FourByte: {
                    n2 = this.tY.get() & 0xFF;
                    object = UnsignedInteger.getFromBits(this.tY.getShort() & 0xFFFF);
                    break;
                }
                case Numeric: {
                    n2 = this.tY.getShort() & 0xFFFF;
                    object = UnsignedInteger.getFromBits(this.tY.getInt());
                    break;
                }
                case String: {
                    n2 = this.tY.getShort() & 0xFFFF;
                    object = this.esq();
                    break;
                }
                case ByteString: {
                    n2 = this.tY.getShort() & 0xFFFF;
                    object = this.erW();
                    break;
                }
                case Guid: {
                    n2 = this.tY.getShort() & 0xFFFF;
                    object = this.esf();
                    break;
                }
                default: {
                    throw new DecodingException("Unsupported (Expanded)NodeId Encoding byte " + (Object)((Object)nodeIdEncoding));
                }
            }
            if (bl2) {
                string = this.esq();
            }
            if (bl) {
                unsignedInteger = this.ess();
            }
            if (string != null) {
                return new ExpandedNodeId(unsignedInteger, string, object);
            }
            return new ExpandedNodeId(unsignedInteger, n2, object);
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    private ExtensionObject esd() throws DecodingException {
        try {
            ExtensionObject extensionObject;
            NodeId nodeId = this.esm();
            ExpandedNodeId expandedNodeId = this.ctx.getNamespaceTable().toExpandedNodeId(nodeId);
            byte by = this.tY.get();
            if (by == 0) {
                if (nodeId == null || nodeId.equals(NodeId.NULL)) {
                    return null;
                }
                return new ExtensionObject(expandedNodeId);
            }
            if (by == 1) {
                extensionObject = new ExtensionObject(expandedNodeId, this.erW());
            } else if (by == 2) {
                extensionObject = new ExtensionObject(expandedNodeId, this.esv());
            } else {
                throw new DecodingException("Unexpected encoding byte (" + by + ") in ExtensionObject");
            }
            if (this.a(extensionObject)) {
                return extensionObject;
            }
            try {
                Structure structure = (Structure)extensionObject.decode(this.getEncoderContext());
                return new ExtensionObject(structure);
            }
            catch (DecodingException decodingException) {
                return extensionObject;
            }
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    private Float ese() throws DecodingException {
        try {
            return Float.valueOf(this.tY.getFloat());
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    private UUID esf() throws DecodingException {
        try {
            int n2;
            byte[] byArray = new byte[16];
            byArray[3] = this.tY.get();
            byArray[2] = this.tY.get();
            byArray[1] = this.tY.get();
            byArray[0] = this.tY.get();
            byArray[5] = this.tY.get();
            byArray[4] = this.tY.get();
            byArray[7] = this.tY.get();
            byArray[6] = this.tY.get();
            for (int i2 = 8; i2 < 16; ++i2) {
                byArray[i2] = this.tY.get();
            }
            long l2 = 0L;
            long l3 = 0L;
            for (n2 = 0; n2 < 8; ++n2) {
                l2 = l2 << 8 | (long)(byArray[n2] & 0xFF);
            }
            for (n2 = 8; n2 < 16; ++n2) {
                l3 = l3 << 8 | (long)(byArray[n2] & 0xFF);
            }
            return new UUID(l2, l3);
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    private Short esg() throws DecodingException {
        try {
            return this.tY.getShort();
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    private Integer esh() throws DecodingException {
        try {
            return this.tY.getInt();
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    private int[] esi() throws DecodingException {
        try {
            int n2 = this.tY.getInt();
            if (n2 == -1) {
                return null;
            }
            this.assertArrayLength(n2);
            int[] nArray = new int[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                nArray[i2] = this.esj();
            }
            return nArray;
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    private int esj() throws DecodingException {
        try {
            return this.tY.getInt();
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    private Long esk() throws DecodingException {
        try {
            return this.tY.getLong();
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    private LocalizedText esl() throws DecodingException {
        try {
            byte by = this.tY.get();
            String string = null;
            String string2 = null;
            if ((by & 1) == 1) {
                string = this.esq();
            }
            if ((by & 2) == 2) {
                string2 = this.esq();
            }
            return LocalizedText.builder().setText(string2, string).build();
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    private NodeId esm() throws DecodingException {
        try {
            byte by = this.tY.get();
            NodeIdEncoding nodeIdEncoding = NodeIdEncoding.getNodeIdEncoding(by);
            if (nodeIdEncoding == null) {
                throw new DecodingException("Unexpected NodeId Encoding Byte " + by);
            }
            switch (nodeIdEncoding) {
                case TwoByte: {
                    return new NodeId(0, UnsignedInteger.getFromBits(this.tY.get() & 0xFF));
                }
                case FourByte: {
                    return new NodeId(this.tY.get() & 0xFF, UnsignedInteger.getFromBits(this.tY.getShort() & 0xFFFF));
                }
                case Numeric: {
                    return new NodeId(this.tY.getShort() & 0xFFFF, this.ess());
                }
                case String: {
                    return new NodeId(this.tY.getShort() & 0xFFFF, this.esq());
                }
                case Guid: {
                    return new NodeId(this.tY.getShort() & 0xFFFF, this.esf());
                }
                case ByteString: {
                    return new NodeId(this.tY.getShort() & 0xFFFF, this.erW());
                }
            }
            throw new DecodingException("Unsupported NodeId Encoding byte " + (Object)((Object)nodeIdEncoding));
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    private QualifiedName esn() throws DecodingException {
        UnsignedShort unsignedShort = this.esr();
        String string = this.esq();
        if (string == null) {
            return new QualifiedName(unsignedShort, null);
        }
        return new QualifiedName(unsignedShort, string);
    }

    private Byte eso() throws DecodingException {
        try {
            return this.tY.get();
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    private Object o(int n2) throws DecodingException {
        switch (n2) {
            case 1: {
                return this.erU();
            }
            case 2: {
                return this.eso();
            }
            case 3: {
                return this.erV();
            }
            case 4: {
                return this.esg();
            }
            case 5: {
                return this.esr();
            }
            case 6: {
                return this.esh();
            }
            case 7: {
                return this.ess();
            }
            case 8: {
                return this.esk();
            }
            case 9: {
                return this.est();
            }
            case 10: {
                return this.ese();
            }
            case 11: {
                return this.esb();
            }
            case 12: {
                return this.esq();
            }
            case 13: {
                return this.erY();
            }
            case 14: {
                return this.esf();
            }
            case 15: {
                return this.erW();
            }
            case 16: {
                return this.esv();
            }
            case 17: {
                return this.esm();
            }
            case 18: {
                return this.esc();
            }
            case 19: {
                return this.esp();
            }
            case 20: {
                return this.esn();
            }
            case 21: {
                return this.esl();
            }
            case 22: {
                return this.esd();
            }
            case 23: {
                return this.erX();
            }
            case 24: {
                return this.esu();
            }
            case 25: {
                return this.esa();
            }
        }
        throw new DecodingException("Cannot decode builtin type id " + n2);
    }

    private StatusCode esp() throws DecodingException {
        return StatusCode.valueOf(this.ess());
    }

    private String esq() throws DecodingException {
        try {
            int n2 = this.tY.getInt();
            if (n2 == -1) {
                return null;
            }
            this.assertStringLength(n2);
            byte[] byArray = new byte[n2];
            this.tY.get(byArray);
            return new String(byArray, StandardCharsets.UTF_8);
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    private Structure b(StructureSpecification structureSpecification) throws DecodingException {
        switch (structureSpecification.getStructureType()) {
            case OPTIONAL: {
                return this.e(structureSpecification);
            }
            case UNION: 
            case UNION_SUBTYPES: {
                return this.f(structureSpecification);
            }
            case SUBTYPES: {
                return this.c(structureSpecification);
            }
            case NORMAL: {
                return this.d(structureSpecification);
            }
        }
        throw new DecodingException("Unknown StructureType: " + (Object)((Object)structureSpecification.getStructureType()));
    }

    private Structure c(StructureSpecification structureSpecification) throws DecodingException {
        Structure.Builder builder = structureSpecification.toInstanceBuilder();
        for (FieldSpecification fieldSpecification : structureSpecification.getFields()) {
            logger.trace("Field: {}", (Object)fieldSpecification);
            builder.set(fieldSpecification, this.b(fieldSpecification));
        }
        return builder.build();
    }

    private Object b(FieldSpecification fieldSpecification) throws DecodingException {
        Class<?> clazz;
        int n2;
        Class<?> clazz2 = fieldSpecification.getJavaClass();
        int n3 = n2 = fieldSpecification.getValueRank() < 0 ? 0 : fieldSpecification.getValueRank();
        Object obj = fieldSpecification.isAllowSubTypes() ? (ExtensionObject.class.isAssignableFrom(clazz = fieldSpecification.getCompositeClass()) ? this.a(MultiDimensionArrayUtils.arrayClassOf(ExtensionObject.class, n2), UaIds.Structure, n2, null) : this.a(MultiDimensionArrayUtils.arrayClassOf(Variant.class, n2), UaIds.BaseDataType, n2, null)) : this.a(clazz2, fieldSpecification.getDataTypeId(), n2, null);
        Optional.ofNullable(this.tZ).ifPresent(biConsumer -> biConsumer.accept(fieldSpecification, obj));
        return obj;
    }

    private Object c(FieldSpecification fieldSpecification) throws DecodingException {
        Class<?> clazz = fieldSpecification.getJavaClass();
        int n2 = fieldSpecification.getValueRank() < 0 ? 0 : fieldSpecification.getValueRank();
        Object obj = this.a(clazz, fieldSpecification.getDataTypeId(), n2, null);
        Optional.ofNullable(this.tZ).ifPresent(biConsumer -> biConsumer.accept(fieldSpecification, obj));
        return obj;
    }

    private Structure d(StructureSpecification structureSpecification) throws DecodingException {
        Structure.Builder builder = structureSpecification.toInstanceBuilder();
        for (FieldSpecification fieldSpecification : structureSpecification.getFields()) {
            logger.trace("Field: {}", (Object)fieldSpecification);
            builder.set(fieldSpecification, this.c(fieldSpecification));
        }
        return builder.build();
    }

    private Structure e(StructureSpecification structureSpecification) throws DecodingException {
        UnsignedInteger unsignedInteger = null;
        Structure.Builder builder = structureSpecification.toInstanceBuilder();
        unsignedInteger = this.ess();
        logger.trace("EncodingMask: {}", (Object)unsignedInteger);
        int n2 = -1;
        for (FieldSpecification fieldSpecification : structureSpecification.getFields()) {
            logger.trace("Field: {}", (Object)fieldSpecification);
            if (fieldSpecification.isOptional()) {
                if (!BinaryDecoder.a(unsignedInteger, ++n2)) continue;
                builder.set(fieldSpecification, this.c(fieldSpecification));
                continue;
            }
            builder.set(fieldSpecification, this.c(fieldSpecification));
        }
        return builder.build();
    }

    private Structure f(StructureSpecification structureSpecification) throws DecodingException {
        UnsignedInteger unsignedInteger = this.ess();
        Structure.Builder builder = structureSpecification.toInstanceBuilder();
        long l2 = unsignedInteger.longValue();
        logger.trace("SwitchField: {}", (Object)l2);
        if (l2 < 0L) {
            throw new DecodingException("Union SwitchField must be >= 0");
        }
        if (l2 == 0L) {
            return builder.build();
        }
        long l3 = 0L;
        for (FieldSpecification fieldSpecification : structureSpecification.getFields()) {
            if (l2 != ++l3) continue;
            logger.trace("Decoded Union Field: {}, SwitchValue: {}", (Object)fieldSpecification, (Object)l3);
            builder.set(fieldSpecification, this.b(fieldSpecification));
            return builder.build();
        }
        throw new DecodingException("Union SwitchField overflow: " + ++l3);
    }

    private UnsignedShort esr() throws DecodingException {
        try {
            return UnsignedShort.getFromBits(this.tY.getShort());
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    private UnsignedInteger ess() throws DecodingException {
        try {
            return UnsignedInteger.getFromBits(this.tY.getInt());
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    private UnsignedLong est() throws DecodingException {
        try {
            return UnsignedLong.getFromBits(this.tY.getLong());
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    private Variant esu() throws DecodingException {
        try {
            boolean bl;
            boolean bl2;
            byte by = this.tY.get();
            int n2 = by & 0x3F;
            boolean bl3 = (by & 0x80) == 128;
            boolean bl4 = (by & 0x40) == 64;
            boolean bl5 = bl2 = n2 == 0;
            if (n2 > 25) {
                n2 = 15;
            }
            Object object = bl2 ? null : (bl3 ? this.n(n2) : this.o(n2));
            int[] nArray = bl4 ? this.getInt32Array_(null) : null;
            boolean bl6 = bl = bl3 && nArray != null && nArray.length > 1;
            if (bl4) {
                long l2;
                long l3;
                if (nArray != null && nArray.length != 0) {
                    l3 = 1L;
                    for (int n3 : nArray) {
                        l3 *= (long)n3;
                    }
                } else {
                    l3 = nArray == null ? -1L : 0L;
                }
                Object[] objectArray = object;
                long l4 = l2 = objectArray == null ? -1L : (long)objectArray.length;
                if (l2 != l3) {
                    throw new DecodingException("Variant's ArrayDimensions " + Arrays.toString(nArray) + " total size of " + l3 + " does not match defined ArrayLength of " + l2 + ". Variant value was: " + MultiDimensionArrayUtils.toString(object, this.ctx));
                }
            }
            if (object instanceof ExtensionObject && this.a((ExtensionObject)object)) {
                try {
                    object = this.d((ByteString)((ExtensionObject)object).getObject());
                }
                catch (ClassCastException classCastException) {
                    throw new DecodingException("Did not get an ExtensionObject with ByteString data for Decimal type", classCastException);
                }
            }
            if (object instanceof ExtensionObject) {
                ExtensionObject extensionObject = (ExtensionObject)object;
                try {
                    object = extensionObject.decode(this.ctx);
                }
                catch (DecodingException exception) {
                    object = extensionObject;
                }
            }
            if (bl3) {
                if (object instanceof ExtensionObject[]) {
                    object = this.b((ExtensionObject[])object);
                }
                if (object instanceof ExtensionObject[]) {
                    ExtensionObject[] extensionObjectArray = object;
                    try {
                        object = this.ctx.decode(extensionObjectArray);
                    }
                    catch (Exception exception) {
                        object = extensionObjectArray;
                    }
                }
                if (bl) {
                    try {
                        object = MultiDimensionArrayUtils.demuxArray(object, nArray);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new DecodingException("The length of ArrayDimensions-field does not match Value-field");
                    }
                }
            }
            return new Variant(object);
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    private XmlElement esv() throws DecodingException {
        ByteString byteString = this.erW();
        if (byteString == null) {
            return null;
        }
        return new XmlElement(ByteString.asByteArray(byteString));
    }

    private boolean a(ExtensionObject extensionObject) {
        if (extensionObject == null) {
            return false;
        }
        return this.ctx.getNamespaceTable().nodeIdEquals(Identifiers.Decimal, extensionObject.getTypeId());
    }

    private Object b(ExtensionObject[] extensionObjectArray) {
        BigDecimal[] bigDecimalArray = new BigDecimal[extensionObjectArray.length];
        for (int i2 = 0; i2 < extensionObjectArray.length; ++i2) {
            ExtensionObject extensionObject = extensionObjectArray[i2];
            if (!this.a(extensionObject)) {
                return extensionObjectArray;
            }
            bigDecimalArray[i2] = this.d((ByteString)extensionObject.getObject());
        }
        return bigDecimalArray;
    }

    protected long remaining() throws DecodingException {
        try {
            return this.tY.limit() - this.tY.position();
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    @Deprecated
    <T> T a(String string, Class<T> clazz) throws DecodingException {
        int n2 = MultiDimensionArrayUtils.getClassDimensions(clazz);
        return this.a(clazz, null, n2, null);
    }

    static {
        tX = new ExpandedNodeId("http://opcfoundation.org/UA/", Identifiers.Decimal.getValue());
        tM.map(UaIds.BaseDataType, Object.class);
        BinaryDecoder.b(UaIds.Boolean, Boolean.class, (BinaryDecoder binaryDecoder, String string, Class<T> clazz, UaNodeId uaNodeId, UaDataTypeSpecification uaDataTypeSpecification) -> binaryDecoder.erU());
        BinaryDecoder.b(UaIds.SByte, Byte.class, (BinaryDecoder binaryDecoder, String string, Class<T> clazz, UaNodeId uaNodeId, UaDataTypeSpecification uaDataTypeSpecification) -> binaryDecoder.eso());
        BinaryDecoder.b(UaIds.Byte, UnsignedByte.class, (BinaryDecoder binaryDecoder, String string, Class<T> clazz, UaNodeId uaNodeId, UaDataTypeSpecification uaDataTypeSpecification) -> binaryDecoder.erV());
        BinaryDecoder.b(UaIds.Int16, Short.class, (BinaryDecoder binaryDecoder, String string, Class<T> clazz, UaNodeId uaNodeId, UaDataTypeSpecification uaDataTypeSpecification) -> binaryDecoder.esg());
        BinaryDecoder.b(UaIds.UInt16, UnsignedShort.class, (BinaryDecoder binaryDecoder, String string, Class<T> clazz, UaNodeId uaNodeId, UaDataTypeSpecification uaDataTypeSpecification) -> binaryDecoder.esr());
        BinaryDecoder.b(UaIds.Int32, Integer.class, (BinaryDecoder binaryDecoder, String string, Class<T> clazz, UaNodeId uaNodeId, UaDataTypeSpecification uaDataTypeSpecification) -> binaryDecoder.esh());
        BinaryDecoder.b(UaIds.UInt32, UnsignedInteger.class, (BinaryDecoder binaryDecoder, String string, Class<T> clazz, UaNodeId uaNodeId, UaDataTypeSpecification uaDataTypeSpecification) -> binaryDecoder.ess());
        BinaryDecoder.b(UaIds.Int64, Long.class, (BinaryDecoder binaryDecoder, String string, Class<T> clazz, UaNodeId uaNodeId, UaDataTypeSpecification uaDataTypeSpecification) -> binaryDecoder.esk());
        BinaryDecoder.b(UaIds.UInt64, UnsignedLong.class, (BinaryDecoder binaryDecoder, String string, Class<T> clazz, UaNodeId uaNodeId, UaDataTypeSpecification uaDataTypeSpecification) -> binaryDecoder.est());
        BinaryDecoder.b(UaIds.Float, Float.class, (BinaryDecoder binaryDecoder, String string, Class<T> clazz, UaNodeId uaNodeId, UaDataTypeSpecification uaDataTypeSpecification) -> binaryDecoder.ese());
        BinaryDecoder.b(UaIds.Double, Double.class, (BinaryDecoder binaryDecoder, String string, Class<T> clazz, UaNodeId uaNodeId, UaDataTypeSpecification uaDataTypeSpecification) -> binaryDecoder.esb());
        BinaryDecoder.b(UaIds.String, String.class, (BinaryDecoder binaryDecoder, String string, Class<T> clazz, UaNodeId uaNodeId, UaDataTypeSpecification uaDataTypeSpecification) -> binaryDecoder.esq());
        BinaryDecoder.b(UaIds.Guid, UUID.class, (BinaryDecoder binaryDecoder, String string, Class<T> clazz, UaNodeId uaNodeId, UaDataTypeSpecification uaDataTypeSpecification) -> binaryDecoder.esf());
        BinaryDecoder.b(UaIds.ByteString, ByteString.class, (BinaryDecoder binaryDecoder, String string, Class<T> clazz, UaNodeId uaNodeId, UaDataTypeSpecification uaDataTypeSpecification) -> binaryDecoder.erW());
        BinaryDecoder.b(UaIds.XmlElement, XmlElement.class, (BinaryDecoder binaryDecoder, String string, Class<T> clazz, UaNodeId uaNodeId, UaDataTypeSpecification uaDataTypeSpecification) -> binaryDecoder.esv());
        BinaryDecoder.b(UaIds.NodeId, NodeId.class, (BinaryDecoder binaryDecoder, String string, Class<T> clazz, UaNodeId uaNodeId, UaDataTypeSpecification uaDataTypeSpecification) -> binaryDecoder.esm());
        BinaryDecoder.b(UaIds.ExpandedNodeId, ExpandedNodeId.class, (BinaryDecoder binaryDecoder, String string, Class<T> clazz, UaNodeId uaNodeId, UaDataTypeSpecification uaDataTypeSpecification) -> binaryDecoder.esc());
        BinaryDecoder.b(UaIds.StatusCode, StatusCode.class, (BinaryDecoder binaryDecoder, String string, Class<T> clazz, UaNodeId uaNodeId, UaDataTypeSpecification uaDataTypeSpecification) -> binaryDecoder.esp());
        BinaryDecoder.b(UaIds.QualifiedName, QualifiedName.class, (BinaryDecoder binaryDecoder, String string, Class<T> clazz, UaNodeId uaNodeId, UaDataTypeSpecification uaDataTypeSpecification) -> binaryDecoder.esn());
        BinaryDecoder.b(UaIds.LocalizedText, LocalizedText.class, (BinaryDecoder binaryDecoder, String string, Class<T> clazz, UaNodeId uaNodeId, UaDataTypeSpecification uaDataTypeSpecification) -> binaryDecoder.esl());
        tN = (binaryDecoder, string, clazz, uaNodeId, uaDataTypeSpecification) -> binaryDecoder.erY();
        BinaryDecoder.a(UaIds.DateTime, DateTime.class, tN);
        tO = (binaryDecoder, string, clazz, uaNodeId, uaDataTypeSpecification) -> binaryDecoder.esd();
        BinaryDecoder.a(UaIds.Structure, ExtensionObject.class, tO);
        tP = (binaryDecoder, string, clazz, uaNodeId, uaDataTypeSpecification) -> {
            if (uaDataTypeSpecification != null) {
                return binaryDecoder.b((StructureSpecification)uaDataTypeSpecification);
            }
            if (uaNodeId == null) {
                throw new DecodingException("DataTypeId is null, class: " + clazz);
            }
            StructureSpecification structureSpecification = binaryDecoder.getEncoderContext().getStructureSpecification(uaNodeId);
            if (structureSpecification == null) {
                throw new DecodingException("Cannot find StructureSpecification for DataType: " + uaNodeId);
            }
            return binaryDecoder.b(structureSpecification);
        };
        tR = (binaryDecoder, string, clazz, uaNodeId, uaDataTypeSpecification) -> binaryDecoder.erX();
        BinaryDecoder.a(UaIds.DataValue, DataValue.class, tR);
        tS = (binaryDecoder, string, clazz, uaNodeId, uaDataTypeSpecification) -> binaryDecoder.esu();
        tT = (binaryDecoder, string, clazz, uaNodeId, uaDataTypeSpecification) -> binaryDecoder.esa();
        BinaryDecoder.a(UaIds.DiagnosticInfo, DiagnosticInfo.class, tT);
        tU = (binaryDecoder, string, clazz, uaNodeId, uaDataTypeSpecification) -> {
            if (uaDataTypeSpecification != null) {
                return binaryDecoder.b((EnumerationSpecification)uaDataTypeSpecification);
            }
            if (uaNodeId == null) {
                throw new DecodingException("DataTypeId is null, class: " + clazz);
            }
            EnumerationSpecification enumerationSpecification = binaryDecoder.getEncoderContext().getEnumerationSpecification(uaNodeId);
            if (enumerationSpecification == null) {
                throw new DecodingException("Cannot find EnumerationSpecification for DataType: " + uaNodeId);
            }
            return binaryDecoder.b((EnumerationSpecification)uaDataTypeSpecification);
        };
        tV = (binaryDecoder, string, clazz, uaNodeId, uaDataTypeSpecification) -> binaryDecoder.erZ();
        BinaryDecoder.a(UaIds.Decimal, BigDecimal.class, tV);
        tW = (binaryDecoder, string, clazz, uaNodeId, uaDataTypeSpecification) -> {
            if (uaDataTypeSpecification != null) {
                return binaryDecoder.b((OptionSetSpecification)uaDataTypeSpecification);
            }
            if (uaNodeId == null) {
                throw new DecodingException("DataTypeId is null, class: " + clazz);
            }
            OptionSetSpecification optionSetSpecification = binaryDecoder.getEncoderContext().getOptionSetSpecification(uaNodeId);
            if (optionSetSpecification == null) {
                throw new DecodingException("Cannot resolve OptionSetSpecification for: " + uaNodeId);
            }
            return binaryDecoder.b(optionSetSpecification);
        };
        tQ = (binaryDecoder, string, clazz, uaNodeId, uaDataTypeSpecification) -> tS.get(binaryDecoder, string, Variant.class, uaNodeId, uaDataTypeSpecification).getValue();
        BinaryDecoder.b(null, Object.class, tQ);
        BinaryDecoder.tL[24] = tQ;
        BinaryDecoder.tL[22] = tO;
    }

    private static class b<T> {
        private final a<T> ub;
        private final UaDataTypeSpecification uc;
        private final Class<?> javaClass;

        b(a<T> a2, UaDataTypeSpecification uaDataTypeSpecification, Class<?> clazz) {
            this.ub = a2;
            this.uc = uaDataTypeSpecification;
            this.javaClass = clazz;
        }
    }

    private static interface a<T> {
        public T get(BinaryDecoder var1, String var2, Class<? extends T> var3, UaNodeId var4, UaDataTypeSpecification var5) throws DecodingException;
    }
}

