/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.encoding;

import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.encoding.DecodingException;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.encoding.IDecoder;
import java.lang.reflect.Array;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class AbstractDecoder
implements IDecoder {
    private static final ConcurrentMap<Class<?>, Object> tB = new ConcurrentHashMap();
    protected EncoderContext ctx;

    protected void assertArrayLength(int n2) throws DecodingException {
        if (n2 < -1) {
            throw new DecodingException(StatusCodes.Bad_DecodingError, "Illegal array length " + n2);
        }
        int n3 = this.ctx.getMaxArrayLength();
        if (n3 > 0 && n2 > n3) {
            throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded, "MaxArrayLength=" + n3 + " < " + n2);
        }
    }

    protected void assertByteStringLength(int n2) throws DecodingException {
        if (n2 < -1) {
            throw new DecodingException(StatusCodes.Bad_DecodingError, "Unexpected byte string length " + n2);
        }
        int n3 = this.ctx.getMaxByteStringLength();
        if (n3 > 0 && n2 > n3) {
            throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded, "MaxByteStringLength " + n3 + " < " + n2);
        }
    }

    protected void assertStringLength(int n2) throws DecodingException {
        if (n2 < -1) {
            throw new DecodingException(StatusCodes.Bad_DecodingError, "Unexpected string length " + n2);
        }
        int n3 = this.ctx.getMaxStringLength();
        if (n3 > 0 && n2 > n3) {
            throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded, "MaxStringLength " + n3 + " < " + n2);
        }
    }

    protected <T> T[] emptyArrayForClass(Class<T> clazz2) {
        Object[] objectArray = (Object[])tB.computeIfAbsent(clazz2, clazz -> Array.newInstance(clazz, 0));
        return objectArray;
    }
}

