/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaArrayDimensions;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.UaOptionSet;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.OptionSetStructure;
import com.prosysopc.ua.typedictionary.OptionSetStructureSpecification;
import com.prosysopc.ua.typedictionary.OptionSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Optional;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=12755")
public abstract class OptionSet
extends AbstractStructure
implements UaOptionSet,
OptionSetStructure {
    @Deprecated
    public static final ExpandedNodeId ID = UaIds.OptionSet.asExpandedNodeId();
    public static final OptionSetStructureSpecification SPECIFICATION;
    private ByteString value;
    private ByteString validBits;

    public OptionSet() {
    }

    public OptionSet(ByteString byteString, ByteString byteString2) {
        this.value = byteString;
        this.validBits = byteString2;
    }

    @Override
    public void clear() {
        super.clear();
        this.value = null;
        this.validBits = null;
    }

    @Override
    public OptionSet clone() {
        OptionSet optionSet = (OptionSet)super.clone();
        optionSet.value = StructureUtils.clone(this.value);
        optionSet.validBits = StructureUtils.clone(this.validBits);
        return optionSet;
    }

    @Override
    public boolean contains(OptionSpecification ... optionSpecificationArray) {
        if (optionSpecificationArray == null) {
            throw new IllegalArgumentException("Null array value not permitted");
        }
        if (optionSpecificationArray.length == 0) {
            return true;
        }
        for (OptionSpecification optionSpecification : Arrays.asList(optionSpecificationArray)) {
            if (this.isValid(optionSpecification)) {
                if (this.value.isBitSet(optionSpecification.getBitPosition())) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        OptionSet optionSet = (OptionSet)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getValue(), optionSet.getValue())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getValidBits(), optionSet.getValidBits());
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.Value.equals(fieldSpecification)) {
            return this.getValue();
        }
        if (Fields.ValidBits.equals(fieldSpecification)) {
            return this.getValidBits();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    public ByteString getValidBits() {
        return this.validBits;
    }

    @Override
    public ByteString getValue() {
        return this.value;
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getValue(), this.getValidBits());
    }

    @Override
    public boolean isBitSet(int n2) {
        return this.value.isBitSet(n2);
    }

    @Override
    public final boolean isValid(int n2) {
        if (this.validBits == null) {
            return false;
        }
        return this.validBits.isBitSet(n2);
    }

    @Override
    public final boolean isValid(OptionSpecification optionSpecification) {
        if (optionSpecification == null) {
            return false;
        }
        if (!this.specification().getOptions().contains(optionSpecification)) {
            return false;
        }
        return this.isValid(optionSpecification.getBitPosition());
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.Value.equals(fieldSpecification)) {
            this.setValue((ByteString)object);
            return;
        }
        if (Fields.ValidBits.equals(fieldSpecification)) {
            this.setValidBits((ByteString)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void setValid(int n2, boolean bl) {
        Optional<OptionSpecification> optional = this.specification().getOptions().stream().filter(optionSpecification -> optionSpecification.getBitPosition() == n2).findFirst();
        if (optional.isPresent()) {
            this.setValid(optional.get(), bl);
        }
    }

    @Override
    public void setValid(OptionSpecification optionSpecification, boolean bl) {
        BitSet bitSet;
        if (optionSpecification == null) {
            return;
        }
        if (!this.specification().getOptions().contains(optionSpecification)) {
            return;
        }
        ByteString byteString = this.validBits;
        BitSet bitSet2 = bitSet = byteString == null ? new BitSet() : byteString.toBitSet();
        if (bl) {
            bitSet.set(optionSpecification.getBitPosition());
        } else {
            bitSet.clear(optionSpecification.getBitPosition());
        }
        if (byteString == null) {
            this.setValidBits(ByteString.fromBitSet(bitSet));
        } else {
            this.setValidBits(ByteString.fromBitSet(bitSet, byteString.getLength()));
        }
    }

    public void setValidBits(ByteString byteString) {
        this.validBits = byteString;
    }

    public void setValue(ByteString byteString) {
        this.value = byteString;
    }

    @Override
    public OptionSetStructureSpecification specification() {
        return SPECIFICATION;
    }

    @Override
    public abstract Builder toBuilder();

    static {
        OptionSetStructureSpecification.Builder<OptionSetStructure.Builder> builder = OptionSetStructureSpecification.builder();
        builder.addField(Fields.Value);
        builder.addField(Fields.ValidBits);
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("OptionSet");
        builder.setJavaClass((Class)OptionSet.class);
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        SPECIFICATION = builder.build();
    }

    public static enum Fields implements FieldSpecification
    {
        Value("Value", ByteString.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=15")), -1, false),
        ValidBits("ValidBits", ByteString.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=15")), -1, false);

        private final FieldSpecification delegate;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3, boolean bl2) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            builder.setAllowSubTypes(bl2);
            this.delegate = builder.build();
        }

        @Override
        public UaArrayDimensions getArrayDimensions() {
            return this.delegate.getArrayDimensions();
        }

        @Override
        public UaNodeId getDataTypeId() {
            return this.delegate.getDataTypeId();
        }

        @Override
        public String getDescription() {
            return this.delegate.getDescription();
        }

        @Override
        public Class<?> getJavaClass() {
            return this.delegate.getJavaClass();
        }

        @Override
        public int getMaxStringLength() {
            return this.delegate.getMaxStringLength();
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Deprecated
        public FieldSpecification getSpecification() {
            return this;
        }

        @Override
        public int getValueRank() {
            return this.delegate.getValueRank();
        }

        @Override
        public boolean isAllowSubTypes() {
            return this.delegate.isAllowSubTypes();
        }

        @Override
        public boolean isArray() {
            return this.delegate.isArray();
        }

        @Override
        public boolean isOptional() {
            return this.delegate.isOptional();
        }
    }

    public static abstract class Builder
    extends AbstractStructure.Builder
    implements UaOptionSet.Builder,
    OptionSetStructure.Builder {
        private ByteString value;
        private ByteString validBits;

        protected Builder() {
        }

        @Override
        public Builder add(OptionSpecification ... optionSpecificationArray) {
            if (optionSpecificationArray == null || optionSpecificationArray.length == 0) {
                return this;
            }
            return this.addAll(Arrays.asList(optionSpecificationArray));
        }

        @Override
        public Builder addAll(Iterable<? extends OptionSpecification> iterable) {
            if (iterable == null) {
                return this;
            }
            ByteString byteString = this.value;
            BitSet bitSet = byteString == null ? new BitSet() : byteString.toBitSet();
            iterable.forEach(optionSpecification -> this.setValid((OptionSpecification)optionSpecification, true));
            for (OptionSpecification optionSpecification2 : iterable) {
                bitSet.set(optionSpecification2.getBitPosition());
            }
            if (byteString == null) {
                this.setValue(ByteString.fromBitSet(bitSet));
            } else {
                this.setValue(ByteString.fromBitSet(bitSet, byteString.getLength()));
            }
            return this;
        }

        @Override
        public abstract OptionSetStructure build();

        @Override
        public Builder clear() {
            byte[] byArray = new byte[this.value.getLength()];
            this.value = ByteString.valueOf(byArray);
            return this;
        }

        @Override
        public boolean contains(OptionSpecification ... optionSpecificationArray) {
            if (optionSpecificationArray == null) {
                throw new IllegalArgumentException("Null array value not permitted");
            }
            if (optionSpecificationArray.length == 0) {
                return true;
            }
            for (OptionSpecification optionSpecification : Arrays.asList(optionSpecificationArray)) {
                if (!this.isValid(optionSpecification)) {
                    return false;
                }
                if (this.value == null) {
                    return false;
                }
                if (this.value.isBitSet(optionSpecification.getBitPosition())) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean containsAll(Iterable<? extends OptionSpecification> iterable) {
            if (iterable == null) {
                throw new IllegalArgumentException("Null Iterable is not permitted");
            }
            for (OptionSpecification optionSpecification : iterable) {
                if (!this.isValid(optionSpecification)) {
                    return false;
                }
                if (this.value == null) {
                    return false;
                }
                if (this.value.isBitSet(optionSpecification.getBitPosition())) continue;
                return false;
            }
            return true;
        }

        @Override
        public final boolean isValid(int n2) {
            if (this.validBits == null) {
                return false;
            }
            return this.validBits.isBitSet(n2);
        }

        @Override
        public final boolean isValid(OptionSpecification optionSpecification) {
            if (optionSpecification == null) {
                return false;
            }
            if (!this.specification().getOptions().contains(optionSpecification)) {
                return false;
            }
            return this.isValid(optionSpecification.getBitPosition());
        }

        @Override
        public Builder remove(OptionSpecification ... optionSpecificationArray) {
            if (optionSpecificationArray == null || optionSpecificationArray.length == 0) {
                return this;
            }
            return this.removeAll(Arrays.asList(optionSpecificationArray));
        }

        @Override
        public Builder removeAll(Iterable<? extends OptionSpecification> iterable) {
            if (iterable == null) {
                return this;
            }
            ByteString byteString = this.value;
            if (byteString == null || byteString.getLength() == 0) {
                return this;
            }
            iterable.forEach(optionSpecification -> this.setValid((OptionSpecification)optionSpecification, true));
            BitSet bitSet = byteString.toBitSet();
            for (OptionSpecification optionSpecification2 : iterable) {
                bitSet.clear(optionSpecification2.getBitPosition());
            }
            this.setValue(ByteString.fromBitSet(bitSet, byteString.getLength()));
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.Value.equals(fieldSpecification)) {
                this.setValue((ByteString)object);
                return this;
            }
            if (Fields.ValidBits.equals(fieldSpecification)) {
                this.setValidBits((ByteString)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder setValid(int n2, boolean bl) {
            Optional<OptionSpecification> optional = this.specification().getOptions().stream().filter(optionSpecification -> optionSpecification.getBitPosition() == n2).findFirst();
            if (optional.isPresent()) {
                return this.setValid(optional.get(), bl);
            }
            return this;
        }

        @Override
        public Builder setValid(OptionSpecification optionSpecification, boolean bl) {
            BitSet bitSet;
            if (optionSpecification == null) {
                return this;
            }
            if (!this.specification().getOptions().contains(optionSpecification)) {
                return this;
            }
            ByteString byteString = this.validBits;
            BitSet bitSet2 = bitSet = byteString == null ? new BitSet() : byteString.toBitSet();
            if (bl) {
                bitSet.set(optionSpecification.getBitPosition());
            } else {
                bitSet.clear(optionSpecification.getBitPosition());
            }
            if (byteString == null) {
                this.setValidBits(ByteString.fromBitSet(bitSet));
            } else {
                this.setValidBits(ByteString.fromBitSet(bitSet, byteString.getLength()));
            }
            return this;
        }

        public Builder setValidBits(ByteString byteString) {
            this.validBits = byteString;
            return this;
        }

        public Builder setValue(ByteString byteString) {
            this.value = byteString;
            return this;
        }

        @Override
        public OptionSetStructureSpecification specification() {
            return SPECIFICATION;
        }
    }
}

