/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.InternalUaDataTypeSpecificationMappings;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaArrayDimensions;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import java.util.Map;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=12171")
public class ComplexNumberType
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = UaIds.ComplexNumberType_DefaultBinary.asExpandedNodeId();
    @Deprecated
    public static final ExpandedNodeId XML = UaIds.ComplexNumberType_DefaultXml.asExpandedNodeId();
    @Deprecated
    public static final ExpandedNodeId JSON = UaIds.ComplexNumberType_DefaultJson.asExpandedNodeId();
    @Deprecated
    public static final ExpandedNodeId ID = UaIds.ComplexNumberType.asExpandedNodeId();
    public static final StructureSpecification SPECIFICATION;
    private Float f_real;
    private Float f_imaginary;

    public ComplexNumberType() {
    }

    public ComplexNumberType(Float f2, Float f3) {
        this.f_real = f2;
        this.f_imaginary = f3;
    }

    public Float getReal() {
        return this.f_real;
    }

    public void setReal(Float f2) {
        this.f_real = f2;
    }

    public Float getImaginary() {
        return this.f_imaginary;
    }

    public void setImaginary(Float f2) {
        this.f_imaginary = f2;
    }

    @Override
    public ComplexNumberType clone() {
        ComplexNumberType complexNumberType = (ComplexNumberType)super.clone();
        complexNumberType.f_real = StructureUtils.clone(this.f_real);
        complexNumberType.f_imaginary = StructureUtils.clone(this.f_imaginary);
        return complexNumberType;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ComplexNumberType complexNumberType = (ComplexNumberType)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getReal(), complexNumberType.getReal())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getImaginary(), complexNumberType.getImaginary());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getReal(), this.getImaginary());
    }

    @Override
    public void clear() {
        super.clear();
        this.f_real = null;
        this.f_imaginary = null;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public Map<FieldSpecification, Object> toFieldsMap() {
        return StructureUtils.createFieldsMap(this.specification(), new Object[]{this.getReal(), this.getImaginary()});
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.Real.equals(fieldSpecification)) {
            return this.getReal();
        }
        if (Fields.Imaginary.equals(fieldSpecification)) {
            return this.getImaginary();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.Real.equals(fieldSpecification)) {
            this.setReal((Float)object);
            return;
        }
        if (Fields.Imaginary.equals(fieldSpecification)) {
            this.setImaginary((Float)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = ComplexNumberType.builder();
        builder.setReal(StructureUtils.clone(this.getReal()));
        builder.setImaginary(StructureUtils.clone(this.getImaginary()));
        return builder;
    }

    static {
        StructureSpecification.Builder<Structure.Builder> builder = StructureSpecification.builder();
        builder.addField(Fields.Real);
        builder.addField(Fields.Imaginary);
        builder.setBinaryEncodeId(UaIds.ComplexNumberType_DefaultBinary);
        builder.setXmlEncodeId(UaIds.ComplexNumberType_DefaultXml);
        builder.setJsonEncodeId(UaIds.ComplexNumberType_DefaultJson);
        builder.setTypeId(UaIds.ComplexNumberType);
        builder.addSuperTypeId(UaIds.Structure);
        builder.setName("ComplexNumberType");
        builder.setJavaClass(ComplexNumberType.class);
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setBuilderSupplier(Builder::new);
        SPECIFICATION = builder.build();
        InternalUaDataTypeSpecificationMappings.put(ComplexNumberType.class, SPECIFICATION);
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private Float f_real;
        private Float f_imaginary;

        protected Builder() {
        }

        public Float getReal() {
            return this.f_real;
        }

        public Builder setReal(Float f2) {
            this.f_real = f2;
            return this;
        }

        public Float getImaginary() {
            return this.f_imaginary;
        }

        public Builder setImaginary(Float f2) {
            this.f_imaginary = f2;
            return this;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Builder builder = (Builder)object;
            if (!StructureUtils.scalarOrArrayEquals(this.getReal(), builder.getReal())) {
                return false;
            }
            return StructureUtils.scalarOrArrayEquals(this.getImaginary(), builder.getImaginary());
        }

        public int hashCode() {
            return StructureUtils.hashCode(this.getReal(), this.getImaginary());
        }

        @Override
        public Object get(FieldSpecification fieldSpecification) {
            if (Fields.Real.equals(fieldSpecification)) {
                return this.getReal();
            }
            if (Fields.Imaginary.equals(fieldSpecification)) {
                return this.getImaginary();
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.Real.equals(fieldSpecification)) {
                this.setReal((Float)object);
                return this;
            }
            if (Fields.Imaginary.equals(fieldSpecification)) {
                this.setImaginary((Float)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder clear() {
            super.clear();
            this.f_real = null;
            this.f_imaginary = null;
            return this;
        }

        @Override
        public StructureSpecification specification() {
            return SPECIFICATION;
        }

        @Override
        public ComplexNumberType build() {
            return new ComplexNumberType(this.f_real, this.f_imaginary);
        }
    }

    public static enum Fields implements FieldSpecification
    {
        Real("Real", Float.class, false, UaIds.Float, -1, null, false),
        Imaginary("Imaginary", Float.class, false, UaIds.Float, -1, null, false);

        private final FieldSpecification delegate;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3, UaArrayDimensions uaArrayDimensions, boolean bl2) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            builder.setArrayDimensions(uaArrayDimensions);
            builder.setAllowSubTypes(bl2);
            this.delegate = builder.build();
        }

        @Deprecated
        public FieldSpecification getSpecification() {
            return this;
        }

        @Override
        public UaArrayDimensions getArrayDimensions() {
            return this.delegate.getArrayDimensions();
        }

        @Override
        public UaNodeId getDataTypeId() {
            return this.delegate.getDataTypeId();
        }

        @Override
        public String getDescription() {
            return this.delegate.getDescription();
        }

        @Override
        public Class<?> getJavaClass() {
            return this.delegate.getJavaClass();
        }

        @Override
        public int getMaxStringLength() {
            return this.delegate.getMaxStringLength();
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public int getValueRank() {
            return this.delegate.getValueRank();
        }

        @Override
        public boolean isAllowSubTypes() {
            return this.delegate.isAllowSubTypes();
        }

        @Override
        public boolean isArray() {
            return this.delegate.isArray();
        }

        @Override
        public boolean isOptional() {
            return this.delegate.isOptional();
        }
    }
}

