/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.common;

import com.prosysopc.ua.stack.utils.BijectionMap;
import java.util.Arrays;
import java.util.function.Function;

public class UriTable<T> {
    private final BijectionMap<Integer, String> tx = new BijectionMap();
    private final BijectionMap<Integer, T> ty = new BijectionMap();
    private final BijectionMap<String, T> tz = new BijectionMap();
    private final Function<String, T> tA;

    public UriTable(Function<String, T> function) {
        this.tA = function;
    }

    public synchronized int add(int n2, String string) {
        int n3 = this.getIndex(string);
        if (n3 >= 0) {
            return n3;
        }
        if (n2 < 0) {
            n2 = this.nextIndex();
        } else if (this.getUri(n2) != null) {
            throw new IllegalArgumentException("namespaceTable already has namespaceIndex " + n2);
        }
        this.tx.map(n2, string);
        T t2 = this.tA.apply(string);
        if (t2 != null) {
            this.ty.map(n2, t2);
            this.tz.map(string, t2);
        }
        return n2;
    }

    public synchronized int add(String string) {
        return this.add(-1, string);
    }

    public synchronized void addAll(String[] stringArray) {
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            this.add(i2, stringArray[i2]);
        }
    }

    public int getIndex(String string) {
        Integer n2 = this.tx.getLeft(string);
        if (n2 == null) {
            return -1;
        }
        return n2;
    }

    public String getUri(int n2) {
        return this.tx.getRight(n2);
    }

    public synchronized void remove(int n2) {
        this.tx.removeWithLeft(n2);
        T t2 = this.ty.removeWithLeft(n2);
        this.tz.removeWithRight(t2);
    }

    public synchronized void remove(String string) {
        this.tx.removeWithRight(string);
        T t2 = this.tz.removeWithLeft(string);
        this.ty.removeWithRight(t2);
    }

    public int size() {
        return this.tx.size();
    }

    public synchronized String[] toArray() {
        int n2 = 0;
        for (Integer n3 : this.tx.getLeftSet()) {
            if (n3 <= n2) continue;
            n2 = n3;
        }
        String[] stringArray = new String[++n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            stringArray[i2] = this.tx.getRight(i2);
        }
        return stringArray;
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }

    private int nextIndex() {
        int n2 = -1;
        for (int n3 : this.tx.getLeftSet()) {
            if (n3 <= n2) continue;
            n2 = n3;
        }
        return n2 + 1;
    }

    protected T getObjectByIndex(int n2) {
        return this.ty.getRight(n2);
    }

    protected T getObjectByUri(String string) {
        return this.tz.getRight(string);
    }

    synchronized int b(int n2, String string) {
        if (n2 < 0) {
            n2 = this.nextIndex();
        } else if (this.getUri(n2) != null) {
            throw new IllegalArgumentException("namespaceTable already has namespaceIndex " + n2);
        }
        this.tx.map(n2, string);
        T t2 = this.tA.apply(string);
        if (t2 != null) {
            this.ty.map(n2, t2);
            this.tz.map(string, t2);
        }
        return n2;
    }
}

