/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.builtintypes;

import com.prosysopc.ua.BitField;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.utils.CryptoUtil;
import java.util.Objects;

public final class UnsignedInteger
extends Number
implements BitField,
Comparable<Number> {
    private static final UnsignedInteger[] CACHE;
    private static final long serialVersionUID = 8818590379317818155L;
    public static final long L_MAX_VALUE = 0xFFFFFFFFL;
    public static final long L_MIN_VALUE = 0L;
    public static final UnsignedInteger MAX_VALUE;
    public static final UnsignedInteger MIN_VALUE;
    public static final UnsignedInteger ZERO;
    public static final UnsignedInteger ONE;
    public static final UnsignedInteger[] EMPTY_ARRAY;
    private int value;

    public static UnsignedInteger[] arrayOf() {
        return EMPTY_ARRAY;
    }

    public static UnsignedInteger[] arrayOf(long ... lArray) {
        if (lArray == null) {
            return null;
        }
        if (lArray.length == 0) {
            return EMPTY_ARRAY;
        }
        UnsignedInteger[] unsignedIntegerArray = new UnsignedInteger[lArray.length];
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            unsignedIntegerArray[i2] = UnsignedInteger.valueOf(lArray[i2]);
        }
        return unsignedIntegerArray;
    }

    public static UnsignedInteger[] arrayOf(String ... stringArray) {
        if (stringArray == null) {
            return null;
        }
        if (stringArray.length == 0) {
            return EMPTY_ARRAY;
        }
        UnsignedInteger[] unsignedIntegerArray = new UnsignedInteger[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            unsignedIntegerArray[i2] = UnsignedInteger.valueOf(stringArray[i2]);
        }
        return unsignedIntegerArray;
    }

    public static UnsignedInteger clamp(UnsignedInteger unsignedInteger, UnsignedInteger unsignedInteger2, UnsignedInteger unsignedInteger3) {
        unsignedInteger = unsignedInteger == null ? ZERO : unsignedInteger;
        unsignedInteger2 = unsignedInteger2 == null ? ZERO : unsignedInteger2;
        UnsignedInteger unsignedInteger4 = unsignedInteger3 = unsignedInteger3 == null ? ZERO : unsignedInteger3;
        if (unsignedInteger.longValue() < unsignedInteger2.longValue()) {
            return unsignedInteger2;
        }
        if (unsignedInteger.longValue() > unsignedInteger3.longValue()) {
            return unsignedInteger3;
        }
        return unsignedInteger;
    }

    public static UnsignedInteger getFromBits(int n2) {
        if (n2 >= 0 && n2 < CACHE.length) {
            return CACHE[n2];
        }
        UnsignedInteger unsignedInteger = new UnsignedInteger();
        unsignedInteger.value = n2;
        return unsignedInteger;
    }

    public static UnsignedInteger max(UnsignedInteger unsignedInteger, UnsignedInteger unsignedInteger2) {
        return unsignedInteger.longValue() < unsignedInteger2.longValue() ? unsignedInteger2 : unsignedInteger;
    }

    public static UnsignedInteger min(UnsignedInteger unsignedInteger, UnsignedInteger unsignedInteger2) {
        return unsignedInteger.longValue() < unsignedInteger2.longValue() ? unsignedInteger : unsignedInteger2;
    }

    public static UnsignedInteger parseUnsignedInteger(String string) throws NumberFormatException, IllegalArgumentException {
        return UnsignedInteger.valueOf(Long.parseLong(string));
    }

    public static UnsignedInteger parseUnsignedInteger(String string, int n2) throws NumberFormatException, IllegalArgumentException {
        return UnsignedInteger.valueOf(Long.parseLong(string, n2));
    }

    public static UnsignedInteger replaceIfNullOrEqual(UnsignedInteger unsignedInteger, UnsignedInteger unsignedInteger2, UnsignedInteger unsignedInteger3) {
        if (unsignedInteger == null || Objects.equals(unsignedInteger, unsignedInteger2)) {
            return unsignedInteger3;
        }
        return unsignedInteger;
    }

    public static UnsignedInteger replaceIfNullOrZero(UnsignedInteger unsignedInteger, UnsignedInteger unsignedInteger2) {
        return UnsignedInteger.replaceIfNullOrEqual(unsignedInteger, ZERO, unsignedInteger2);
    }

    public static UnsignedInteger valueOf(long l2) {
        if (l2 >= 0L && l2 < (long)CACHE.length) {
            return CACHE[(int)l2];
        }
        return new UnsignedInteger(l2);
    }

    public static UnsignedInteger valueOf(String string) {
        return UnsignedInteger.parseUnsignedInteger(string);
    }

    public static UnsignedInteger valueOf(String string, int n2) {
        return UnsignedInteger.parseUnsignedInteger(string, n2);
    }

    public static UnsignedInteger valueOf(UnsignedByte unsignedByte) {
        if (UnsignedByte.ZERO.equals(unsignedByte)) {
            return ZERO;
        }
        return UnsignedInteger.valueOf(unsignedByte.getValue());
    }

    @Deprecated
    public UnsignedInteger() {
        this.value = 0;
    }

    @Deprecated
    public UnsignedInteger(int n2) throws IllegalArgumentException {
        if (n2 < 0) {
            throw new IllegalArgumentException("Value underflow");
        }
        this.value = n2;
    }

    @Deprecated
    public UnsignedInteger(long l2) throws IllegalArgumentException {
        if (l2 < 0L || l2 > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Value overflow");
        }
        this.value = (int)l2;
    }

    @Deprecated
    public UnsignedInteger(String string) throws IllegalArgumentException {
        long l2 = Long.parseLong(string);
        if (l2 < 0L || l2 > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Value overflow");
        }
        this.value = (int)l2;
    }

    @Deprecated
    public UnsignedInteger(UnsignedByte unsignedByte) {
        this.value = unsignedByte.getValue();
    }

    @Deprecated
    public UnsignedInteger(UnsignedInteger unsignedInteger) {
        this.value = unsignedInteger.value;
    }

    public UnsignedInteger add(int n2) {
        return UnsignedInteger.valueOf(this.getValue() + (long)n2);
    }

    public UnsignedInteger add(long l2) {
        return UnsignedInteger.valueOf(this.getValue() + l2);
    }

    public UnsignedInteger add(UnsignedInteger unsignedInteger) {
        return UnsignedInteger.valueOf(this.getValue() + unsignedInteger.getValue());
    }

    public UnsignedInteger and(int n2) {
        return UnsignedInteger.getFromBits(this.value & n2);
    }

    public UnsignedInteger and(long l2) {
        return new UnsignedInteger((long)this.value & l2);
    }

    public UnsignedInteger and(UnsignedInteger unsignedInteger) {
        return UnsignedInteger.getFromBits(unsignedInteger.value & this.value);
    }

    @Override
    public byte byteValue() {
        return (byte)(this.value & 0xFF);
    }

    @Override
    public int compareTo(Number number) {
        long l2;
        if (number instanceof UnsignedInteger) {
            return Integer.compareUnsigned(this.value, ((UnsignedInteger)number).value);
        }
        long l3 = this.longValue();
        return l3 < (l2 = number.longValue()) ? -1 : (l3 == l2 ? 0 : 1);
    }

    public UnsignedInteger dec() {
        return UnsignedInteger.valueOf(this.getValue() - 1L);
    }

    public UnsignedInteger decOrWrap() {
        if (this.equals(MIN_VALUE)) {
            return MAX_VALUE;
        }
        return this.dec();
    }

    public UnsignedInteger decOrWrapTo(UnsignedInteger unsignedInteger) {
        if (this.equals(MIN_VALUE)) {
            return unsignedInteger;
        }
        return this.dec();
    }

    @Override
    public double doubleValue() {
        return this.getValue();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!object.getClass().equals(UnsignedInteger.class)) {
            return false;
        }
        UnsignedInteger unsignedInteger = (UnsignedInteger)object;
        return this.value == unsignedInteger.value;
    }

    @Override
    public float floatValue() {
        return this.getValue();
    }

    public long getValue() {
        return (long)this.value & 0xFFFFFFFFL;
    }

    public int hashCode() {
        return this.value;
    }

    public UnsignedInteger inc() {
        return UnsignedInteger.valueOf(this.getValue() + 1L);
    }

    public UnsignedInteger incOrWrap() {
        if (this.equals(MAX_VALUE)) {
            return MIN_VALUE;
        }
        return this.inc();
    }

    public UnsignedInteger incOrWrapTo(UnsignedInteger unsignedInteger) {
        if (this.equals(MAX_VALUE)) {
            return unsignedInteger;
        }
        return this.inc();
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public boolean isBitSet(int n2) {
        if (n2 < 0 || n2 > 31) {
            return false;
        }
        return (this.value >> n2 & 1) >= 1;
    }

    @Override
    public long longValue() {
        return (long)this.value & 0xFFFFFFFFL;
    }

    public UnsignedInteger or(int n2) {
        return UnsignedInteger.getFromBits(this.value | n2);
    }

    public UnsignedInteger or(long l2) {
        return new UnsignedInteger((long)this.value | l2);
    }

    public UnsignedInteger or(UnsignedInteger unsignedInteger) {
        return UnsignedInteger.getFromBits(unsignedInteger.value | this.value);
    }

    public UnsignedInteger subtract(int n2) {
        return UnsignedInteger.valueOf(this.getValue() - (long)n2);
    }

    public UnsignedInteger subtract(long l2) {
        return UnsignedInteger.valueOf(this.getValue() - l2);
    }

    public UnsignedInteger subtract(UnsignedInteger unsignedInteger) {
        return UnsignedInteger.valueOf(this.getValue() - unsignedInteger.getValue());
    }

    public String toHex() {
        return CryptoUtil.toHex((int)((long)this.value & 0xFFFFFFFFL));
    }

    public int toIntBits() {
        return this.value;
    }

    public String toString() {
        return Long.toString((long)this.value & 0xFFFFFFFFL);
    }

    static {
        int n2;
        CACHE = new UnsignedInteger[1024];
        MAX_VALUE = new UnsignedInteger(0xFFFFFFFFL);
        ZERO = MIN_VALUE = new UnsignedInteger(0L);
        ONE = new UnsignedInteger(1);
        EMPTY_ARRAY = new UnsignedInteger[0];
        UnsignedInteger.CACHE[0] = ZERO;
        UnsignedInteger.CACHE[1] = ONE;
        for (n2 = 2; n2 < CACHE.length; ++n2) {
            UnsignedInteger.CACHE[n2] = new UnsignedInteger(n2);
        }
        UnsignedInteger.CACHE[0] = ZERO;
        UnsignedInteger.CACHE[1] = ONE;
        for (n2 = 2; n2 < CACHE.length; ++n2) {
            UnsignedInteger.CACHE[n2] = new UnsignedInteger(n2);
        }
    }
}

