/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.builtintypes;

import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.core.Identifiers;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiagnosticInfo
implements Cloneable {
    private static final Logger logger = LoggerFactory.getLogger(DiagnosticInfo.class);
    public static boolean disableAdditionalInfo = true;
    @Deprecated
    public static final NodeId ID = Identifiers.DiagnosticInfo;
    public static final DiagnosticInfo[] EMPTY_ARRAY = new DiagnosticInfo[0];
    Integer sC;
    Integer sD;
    Integer sE;
    Integer sF;
    String additionalInfo;
    StatusCode sG;
    DiagnosticInfo sH;
    List<String> sI;
    String[] sJ;

    public static void toString(DiagnosticInfo diagnosticInfo, StringBuilder stringBuilder, boolean bl, boolean bl2, boolean bl3) {
        DiagnosticInfo diagnosticInfo2;
        stringBuilder.append(bl3 ? "Inner Info: " : "Diagnostic Info: ");
        if (!bl && diagnosticInfo.getLocalizedTextStr() != null) {
            stringBuilder.append(diagnosticInfo.getLocalizedTextStr());
            stringBuilder.append(' ');
        }
        if (!bl2 && diagnosticInfo.getInnerStatusCode() != null) {
            stringBuilder.append("(");
            stringBuilder.append(diagnosticInfo.getInnerStatusCode().toString());
            stringBuilder.append(")");
        }
        stringBuilder.append('\n');
        if (diagnosticInfo.getAdditionalInfo() != null) {
            stringBuilder.append('\t');
            stringBuilder.append(diagnosticInfo.getAdditionalInfo());
            stringBuilder.append('\n');
        }
        if (diagnosticInfo.getSymbolicIdStr() != null) {
            stringBuilder.append("\tSymbolicId: " + diagnosticInfo.getSymbolicIdStr() + "\n");
        }
        if (diagnosticInfo.getNamespaceUriStr() != null) {
            stringBuilder.append("\tNamespaceUri: " + diagnosticInfo.getNamespaceUriStr() + "\n");
        }
        if ((diagnosticInfo2 = diagnosticInfo.getInnerDiagnosticInfo()) != null) {
            DiagnosticInfo.toString(diagnosticInfo2, stringBuilder, false, false, true);
        }
    }

    public DiagnosticInfo() {
    }

    public DiagnosticInfo(String string, DiagnosticInfo diagnosticInfo, StatusCode statusCode, Integer n2, Integer n3, Integer n4, Integer n5) {
        this.setAdditionalInfo(string);
        this.sH = diagnosticInfo;
        this.sG = statusCode;
        this.sF = n2;
        this.sE = n3;
        this.sD = n4;
        this.sC = n5;
    }

    public DiagnosticInfo(String string, DiagnosticInfo diagnosticInfo, StatusCode statusCode, String string2, String string3, String string4, String string5, List<String> list) {
        this.setAdditionalInfo(string);
        this.sH = diagnosticInfo;
        this.sG = statusCode;
        this.sI = list;
        this.sF = this.addOrGetIndex(string2);
        this.sE = this.addOrGetIndex(string3);
        this.sD = this.addOrGetIndex(string4);
        this.sC = this.addOrGetIndex(string5);
    }

    public Object clone() {
        try {
            DiagnosticInfo diagnosticInfo = (DiagnosticInfo)super.clone();
            diagnosticInfo.sJ = StructureUtils.clone(this.sJ);
            diagnosticInfo.sI = Optional.ofNullable(this.sI).map(list -> new ArrayList(list)).orElse(null);
            return diagnosticInfo;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            logger.error("Got a CloneNotSupportedException, should be impossible", (Throwable)cloneNotSupportedException);
            throw new Error("Every DiagnosticInfo shall be Cloneable", cloneNotSupportedException);
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof DiagnosticInfo)) {
            return false;
        }
        DiagnosticInfo diagnosticInfo = (DiagnosticInfo)object;
        return Objects.equals(diagnosticInfo.sC, this.sC) && Objects.equals(diagnosticInfo.sD, this.sD) && Objects.equals(diagnosticInfo.sE, this.sE) && Objects.equals(diagnosticInfo.sF, this.sF) && Objects.equals(diagnosticInfo.additionalInfo, this.additionalInfo) && Objects.equals(diagnosticInfo.sG, this.sG) && Objects.equals(diagnosticInfo.sH, this.sH);
    }

    public String getAdditionalInfo() {
        return this.additionalInfo;
    }

    public DiagnosticInfo getInnerDiagnosticInfo() {
        return this.sH;
    }

    public StatusCode getInnerStatusCode() {
        return this.sG;
    }

    public Integer getLocale() {
        return this.sF;
    }

    public String getLocaleStr() {
        if (this.sF == null) {
            return null;
        }
        if (this.sJ != null) {
            return this.sJ[this.sF];
        }
        if (this.sI != null) {
            return this.sI.get(this.sF);
        }
        return this.sF.toString();
    }

    public Integer getLocalizedText() {
        return this.sE;
    }

    public String getLocalizedTextStr() {
        if (this.sE == null) {
            return null;
        }
        if (this.sJ != null) {
            return this.sJ[this.sE];
        }
        if (this.sI != null) {
            return this.sI.get(this.sE);
        }
        return this.sE.toString();
    }

    public Integer getNamespaceUri() {
        return this.sD;
    }

    public String getNamespaceUriStr() {
        if (this.sD == null) {
            return null;
        }
        if (this.sJ != null) {
            return this.sJ[this.sD];
        }
        if (this.sI != null) {
            return this.sI.get(this.sD);
        }
        return this.sD.toString();
    }

    public List<String> getStringTable() {
        return this.sI;
    }

    public Integer getSymbolicId() {
        return this.sC;
    }

    public String getSymbolicIdStr() {
        if (this.sC == null) {
            return null;
        }
        if (this.sJ != null) {
            return this.sJ[this.sC];
        }
        if (this.sI != null) {
            return this.sI.get(this.sC);
        }
        return this.sC.toString();
    }

    public int hashCode() {
        return Objects.hash(this.sC, this.sD, this.sE, this.sF, this.additionalInfo, this.sH, this.sG);
    }

    public void setAdditionalInfo(String string) {
        this.additionalInfo = disableAdditionalInfo ? null : string;
    }

    public void setInnerDiagnosticInfo(DiagnosticInfo diagnosticInfo) {
        this.sH = diagnosticInfo;
    }

    public void setInnerStatusCode(StatusCode statusCode) {
        this.sG = statusCode;
    }

    public void setLocale(Integer n2) {
        this.sF = n2;
    }

    public void setLocaleStr(String string) {
        this.sF = this.addOrGetIndex(string);
    }

    public void setLocalizedText(Integer n2) {
        this.sE = n2;
    }

    public void setLocalizedTextStr(String string) {
        this.sE = this.addOrGetIndex(string);
    }

    public void setNamespaceUri(Integer n2) {
        this.sD = n2;
    }

    public void setNamespaceUriStr(String string) {
        this.sD = this.addOrGetIndex(string);
    }

    public void setStringArray(String[] stringArray) {
        this.sI = null;
        this.sJ = stringArray;
    }

    public void setStringTable(List<String> list) {
        this.sI = list;
        this.sJ = null;
    }

    public void setSymbolicId(Integer n2) {
        this.sC = n2;
    }

    public void setSymbolicIdStr(String string) {
        this.sC = this.addOrGetIndex(string);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        DiagnosticInfo.toString(this, stringBuilder, false, false, false);
        return stringBuilder.toString();
    }

    private int addOrGetIndex(String string) {
        int n2 = this.sI.indexOf(string);
        if (n2 >= 0) {
            return n2;
        }
        this.sI.add(string);
        return this.sI.size() - 1;
    }
}

