/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.application;

import com.prosysopc.ua.InternalArguments;
import com.prosysopc.ua.stack.application.Application;
import com.prosysopc.ua.stack.application.Session;
import com.prosysopc.ua.stack.application.SessionChannel;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.ApplicationDescription;
import com.prosysopc.ua.stack.core.ApplicationType;
import com.prosysopc.ua.stack.core.CreateSessionRequest;
import com.prosysopc.ua.stack.core.CreateSessionResponse;
import com.prosysopc.ua.stack.core.EndpointConfiguration;
import com.prosysopc.ua.stack.core.EndpointDescription;
import com.prosysopc.ua.stack.core.FindServersOnNetworkRequest;
import com.prosysopc.ua.stack.core.FindServersOnNetworkResponse;
import com.prosysopc.ua.stack.core.FindServersRequest;
import com.prosysopc.ua.stack.core.FindServersResponse;
import com.prosysopc.ua.stack.core.GetEndpointsRequest;
import com.prosysopc.ua.stack.core.GetEndpointsResponse;
import com.prosysopc.ua.stack.core.MessageSecurityMode;
import com.prosysopc.ua.stack.core.RequestHeader;
import com.prosysopc.ua.stack.core.ServerOnNetwork;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.transport.ChannelService;
import com.prosysopc.ua.stack.transport.Endpoint;
import com.prosysopc.ua.stack.transport.ReverseTransportChannelSettings;
import com.prosysopc.ua.stack.transport.SecureChannel;
import com.prosysopc.ua.stack.transport.ServiceChannel;
import com.prosysopc.ua.stack.transport.TransportChannelSettings;
import com.prosysopc.ua.stack.transport.UriUtil;
import com.prosysopc.ua.stack.transport.https.HttpsClient;
import com.prosysopc.ua.stack.transport.https.HttpsClientSecureChannel;
import com.prosysopc.ua.stack.transport.https.HttpsSettings;
import com.prosysopc.ua.stack.transport.security.Cert;
import com.prosysopc.ua.stack.transport.security.KeyPair;
import com.prosysopc.ua.stack.transport.security.SecurityAlgorithm;
import com.prosysopc.ua.stack.transport.security.SecurityMode;
import com.prosysopc.ua.stack.transport.security.SecurityPolicy;
import com.prosysopc.ua.stack.transport.tcp.io.OpcTcpSettings;
import com.prosysopc.ua.stack.transport.tcp.io.SecureChannelTcp;
import com.prosysopc.ua.stack.utils.CertificateUtils;
import com.prosysopc.ua.stack.utils.CryptoUtil;
import com.prosysopc.ua.stack.utils.EndpointUtil;
import com.prosysopc.ua.stack.utils.bytebuffer.ByteBufferUtils;
import java.security.cert.CertificateParsingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Client {
    Logger logger = LoggerFactory.getLogger(Client.class);
    Application application;
    EndpointConfiguration gs = Endpoint.createDefaultEndpointConfiguration();

    public static Client createClientApplication(KeyPair keyPair) {
        Application application = new Application();
        Client client = new Client(application);
        if (keyPair != null) {
            try {
                String string = CertificateUtils.getApplicationUriOfCertificate(keyPair.certificate);
                application.setApplicationUri(string);
            }
            catch (CertificateParsingException certificateParsingException) {
                // empty catch block
            }
            application.addApplicationInstanceCertificate(keyPair);
            application.getHttpsSettings().setKeyPair(keyPair, new Cert[0]);
        }
        return client;
    }

    public Client(Application application) {
        this.application = application;
    }

    public ApplicationDescription createApplicationDescription() {
        ApplicationDescription applicationDescription = this.application.J.clone();
        applicationDescription.setApplicationType(ApplicationType.Client);
        return applicationDescription;
    }

    public SecureChannel createReverseSecureChannel(String string, ReverseTransportChannelSettings reverseTransportChannelSettings) throws ServiceResultException {
        if (reverseTransportChannelSettings == null) {
            throw new IllegalArgumentException("Given settings cannot be null");
        }
        UriUtil.MessageFormat messageFormat = UriUtil.getMessageFormat(string);
        if (messageFormat == UriUtil.MessageFormat.Binary) {
            SecureChannel secureChannel = this.A(string);
            ReverseTransportChannelSettings reverseTransportChannelSettings2 = new ReverseTransportChannelSettings();
            reverseTransportChannelSettings2.setReverseConnectionListener(reverseTransportChannelSettings.getReverseConnectionListener());
            reverseTransportChannelSettings2.setConfiguration(this.gs);
            reverseTransportChannelSettings2.getHttpsSettings().readFrom(this.application.getHttpsSettings());
            reverseTransportChannelSettings2.getOpctcpSettings().readFrom(this.application.getOpctcpSettings());
            reverseTransportChannelSettings2.readFrom(reverseTransportChannelSettings);
            KeyPair keyPair = this.application.getApplicationInstanceCertificate();
            if (keyPair != null && EndpointUtil.needsCertificate(reverseTransportChannelSettings2.getDescription())) {
                reverseTransportChannelSettings2.getOpctcpSettings().setPrivKey(keyPair.getPrivateKey());
                reverseTransportChannelSettings2.getOpctcpSettings().setClientCertificate(keyPair.getCertificate());
            }
            try {
                secureChannel.initialize(string, reverseTransportChannelSettings2, this.getEncoderContext());
                secureChannel.open();
                return secureChannel;
            }
            catch (ServiceResultException serviceResultException) {
                secureChannel.dispose();
                throw serviceResultException;
            }
        }
        throw new ServiceResultException("Unsupported protocol " + (Object)((Object)messageFormat));
    }

    public SecureChannel createSecureChannel(ApplicationDescription applicationDescription) throws ServiceResultException {
        String[] stringArray = applicationDescription.getDiscoveryUrls();
        if (stringArray == null || stringArray.length == 0) {
            throw new ServiceResultException("application description does not contain any discovery url");
        }
        for (String string : stringArray) {
            if (!string.toLowerCase(Locale.ROOT).startsWith("opc.tcp")) continue;
            SecureChannel secureChannel = this.createSecureChannel(string, string);
            return secureChannel;
        }
        for (String string : stringArray) {
            if (!string.toLowerCase(Locale.ROOT).startsWith("https")) continue;
            SecureChannel secureChannel = this.createSecureChannel(string, string);
            return secureChannel;
        }
        throw new ServiceResultException("No suitable discover url was found");
    }

    public SecureChannel createSecureChannel(EndpointDescription endpointDescription) throws ServiceResultException {
        return this.createSecureChannel(endpointDescription.getEndpointUrl(), endpointDescription);
    }

    public SecureChannel createSecureChannel(String string) throws ServiceResultException {
        return this.createSecureChannel(string, string);
    }

    public SecureChannel createSecureChannel(String string, EndpointDescription endpointDescription) throws ServiceResultException {
        TransportChannelSettings transportChannelSettings = new TransportChannelSettings();
        transportChannelSettings.setDescription(endpointDescription);
        return this.createSecureChannel(string, transportChannelSettings);
    }

    public SecureChannel createSecureChannel(String string, String string2) throws ServiceResultException {
        EndpointDescription[] endpointDescriptionArray = this.discoverEndpoints(string, "");
        EndpointDescription endpointDescription = EndpointUtil.select(endpointDescriptionArray, string);
        return this.createSecureChannel(string, endpointDescription);
    }

    public SecureChannel createSecureChannel(String string, String string2, SecurityMode securityMode, Cert cert) throws ServiceResultException {
        Cert cert2;
        EndpointDescription endpointDescription = new EndpointDescription();
        endpointDescription.setEndpointUrl(string2);
        endpointDescription.setSecurityMode(securityMode.getMessageSecurityMode());
        endpointDescription.setSecurityPolicyUri(securityMode.getSecurityPolicy().getPolicyUri());
        Cert cert3 = cert2 = securityMode.getMessageSecurityMode() == MessageSecurityMode.None ? null : cert;
        if (cert2 != null) {
            endpointDescription.setServerCertificate(ByteString.valueOf(cert2.getEncoded()));
        }
        return this.createSecureChannel(string, endpointDescription);
    }

    public SecureChannel createSecureChannel(String string, TransportChannelSettings transportChannelSettings) throws ServiceResultException {
        UriUtil.MessageFormat messageFormat = UriUtil.getMessageFormat(string);
        if (messageFormat == UriUtil.MessageFormat.Binary) {
            KeyPair keyPair;
            SecureChannel secureChannel = this.A(string);
            TransportChannelSettings transportChannelSettings2 = new TransportChannelSettings();
            transportChannelSettings2.setConfiguration(this.gs);
            transportChannelSettings2.getHttpsSettings().readFrom(this.application.getHttpsSettings());
            transportChannelSettings2.getOpctcpSettings().readFrom(this.application.getOpctcpSettings());
            if (transportChannelSettings != null) {
                transportChannelSettings2.readFrom(transportChannelSettings);
            }
            if ((keyPair = this.application.getApplicationInstanceCertificate()) != null && EndpointUtil.needsCertificate(transportChannelSettings2.getDescription())) {
                transportChannelSettings2.getOpctcpSettings().setPrivKey(keyPair.getPrivateKey());
                transportChannelSettings2.getOpctcpSettings().setClientCertificate(keyPair.getCertificate());
            }
            try {
                secureChannel.initialize(string, transportChannelSettings2, this.getEncoderContext());
                secureChannel.open();
                return secureChannel;
            }
            catch (ServiceResultException serviceResultException) {
                secureChannel.dispose();
                throw serviceResultException;
            }
        }
        throw new ServiceResultException("Unsupported protocol " + (Object)((Object)messageFormat));
    }

    public SecureChannel createSecureChannel(TransportChannelSettings transportChannelSettings) throws ServiceResultException {
        return this.createSecureChannel(transportChannelSettings.getDescription().getEndpointUrl(), transportChannelSettings);
    }

    public ServiceChannel createServiceChannel(ApplicationDescription applicationDescription) throws ServiceResultException {
        return new ServiceChannel(this.createSecureChannel(applicationDescription));
    }

    public ServiceChannel createServiceChannel(EndpointDescription endpointDescription) throws ServiceResultException {
        return new ServiceChannel(this.createSecureChannel(endpointDescription.getEndpointUrl(), endpointDescription));
    }

    public ServiceChannel createServiceChannel(String string) throws ServiceResultException {
        return new ServiceChannel(this.createSecureChannel(string, string));
    }

    public ServiceChannel createServiceChannel(String string, EndpointDescription endpointDescription) throws ServiceResultException {
        return new ServiceChannel(this.createSecureChannel(string, endpointDescription));
    }

    public ServiceChannel createServiceChannel(String string, String string2) throws ServiceResultException {
        return new ServiceChannel(this.createSecureChannel(string, string2));
    }

    public ServiceChannel createServiceChannel(String string, String string2, SecurityMode securityMode, Cert cert) throws ServiceResultException {
        return new ServiceChannel(this.createSecureChannel(string, string2, securityMode, cert));
    }

    public ServiceChannel createServiceChannel(TransportChannelSettings transportChannelSettings) throws ServiceResultException {
        return new ServiceChannel(this.createSecureChannel(transportChannelSettings));
    }

    public Session createSession(SecureChannel secureChannel) throws ServiceResultException {
        return this.createSession(secureChannel, null, null, null);
    }

    public Session createSession(SecureChannel secureChannel, UnsignedInteger unsignedInteger, Double d2, String string) throws IllegalArgumentException, ServiceResultException {
        return this.createSession(secureChannel, unsignedInteger, d2, string, null);
    }

    public Session createSession(SecureChannel secureChannel, UnsignedInteger unsignedInteger, Double d2, String string, EndpointDescription[] endpointDescriptionArray) throws IllegalArgumentException, ServiceResultException {
        EndpointDescription[] endpointDescriptionArray2;
        Object object;
        EndpointDescription[] endpointDescriptionArray3;
        if (unsignedInteger == null) {
            unsignedInteger = UnsignedInteger.valueOf(0x400000L);
        }
        if (d2 == null) {
            d2 = 3600000.0;
        }
        InternalArguments.checkNotNull(secureChannel, "channel");
        EndpointDescription endpointDescription = secureChannel.getEndpointDescription();
        Client client = this;
        if (endpointDescription == null || secureChannel == null) {
            throw new IllegalArgumentException("null arg");
        }
        Session session = new Session();
        if (string == null) {
            string = UUID.randomUUID() + "-" + String.format(Locale.ROOT, "%08X", System.identityHashCode(session));
        }
        session.gr = endpointDescription;
        session.name = string;
        KeyPair keyPair = client.application.getApplicationInstanceCertificate();
        if (keyPair != null && EndpointUtil.needsCertificate(secureChannel.getEndpointDescription())) {
            session.st = keyPair.getCertificate();
            session.su = keyPair.getPrivateKey();
        }
        session.sp = CryptoUtil.createNonce(32);
        CreateSessionRequest createSessionRequest = new CreateSessionRequest();
        createSessionRequest.setClientNonce(session.sp);
        createSessionRequest.setClientDescription(client.createApplicationDescription());
        if (session.st != null) {
            createSessionRequest.setClientCertificate(ByteString.valueOf(session.getClientCertificate().getEncoded()));
        }
        createSessionRequest.setEndpointUrl(endpointDescription.getEndpointUrl());
        createSessionRequest.setMaxResponseMessageSize(unsignedInteger);
        if (endpointDescription.getServer() != null) {
            createSessionRequest.setServerUri(endpointDescription.getServer().getApplicationUri());
        }
        createSessionRequest.setSessionName(session.name);
        createSessionRequest.setRequestedSessionTimeout(d2);
        RequestHeader requestHeader = new RequestHeader();
        requestHeader.setTimestamp(DateTime.currentTime());
        createSessionRequest.setRequestHeader(requestHeader);
        CreateSessionResponse createSessionResponse = secureChannel.serviceRequest(createSessionRequest);
        byte[] byArray = ByteString.asByteArray(createSessionResponse.getServerCertificate());
        session.ss = byArray == null || byArray.length == 0 ? null : new Cert(byArray);
        session.mB = createSessionResponse.getServerNonce();
        session.mF = createSessionResponse.getSessionId();
        session.mr = createSessionResponse.getAuthenticationToken();
        session.mC = createSessionResponse.getRevisedSessionTimeout();
        session.nz = createSessionResponse.getMaxRequestMessageSize();
        session.sr = createSessionResponse.getServerSoftwareCertificates();
        this.logger.debug("MessageSecurityMode: {}", (Object)secureChannel.getMessageSecurityMode());
        if (!MessageSecurityMode.None.equals(secureChannel.getMessageSecurityMode())) {
            String string2;
            endpointDescriptionArray3 = createSessionResponse.getServerSignature();
            if (endpointDescriptionArray3 == null) {
                throw new ServiceResultException(StatusCodes.Bad_UnexpectedError, "The CreateSessionResponse contained a null SignatureData for a non-NONE-MessageSecurityMode channel");
            }
            object = ByteBufferUtils.concatenate(ByteString.asByteArray(createSessionRequest.getClientCertificate()), ByteString.asByteArray(session.sp));
            endpointDescriptionArray2 = secureChannel.getSecurityPolicy();
            String string3 = endpointDescriptionArray2.getAsymmetricSignatureAlgorithm().getUri();
            if (!string3.equals(string2 = endpointDescriptionArray3.getAlgorithm())) {
                this.logger.error("Server gave incorrect SignatureData algorithm, expected: {}, got:{}, using:{}", new Object[]{string3, string2, string3});
            } else {
                this.logger.debug("SignatureData Algorithm: {}", (Object)string3);
            }
            SecurityAlgorithm securityAlgorithm = endpointDescriptionArray2.getAsymmetricSignatureAlgorithm();
            boolean bl = CryptoUtil.getCryptoProvider().verifyAsymm(session.ss.getCertificate().getPublicKey(), securityAlgorithm, (byte[])object, ByteString.asByteArray(endpointDescriptionArray3.getSignature()));
            if (!bl) {
                throw new ServiceResultException(StatusCodes.Bad_ApplicationSignatureInvalid, "The signature generated with the server certificate is missing or invalid.");
            }
        }
        if ((endpointDescriptionArray3 = createSessionResponse.getServerEndpoints()) == null || endpointDescriptionArray3.length == 0) {
            throw new ServiceResultException(StatusCodes.Bad_UnexpectedError, "The CreateSessionResponse's endpoint list received from the server is empty");
        }
        object = secureChannel.getEndpointDescription().getTransportProfileUri();
        this.a((String)object, endpointDescriptionArray3, endpointDescriptionArray);
        endpointDescriptionArray2 = EndpointUtil.select(endpointDescriptionArray3, endpointDescription.getEndpointUrl(), null, endpointDescription.getSecurityMode(), SecurityPolicy.getSecurityPolicy(endpointDescription.getSecurityPolicyUri()), null);
        if (endpointDescriptionArray2.length == 0 && endpointDescriptionArray == null) {
            endpointDescriptionArray2 = EndpointUtil.select(endpointDescriptionArray3, null, null, endpointDescription.getSecurityMode(), SecurityPolicy.getSecurityPolicy(endpointDescription.getSecurityPolicyUri()), null);
        }
        if (endpointDescriptionArray2.length == 0) {
            this.logger.error("Requested endpoint is not found on the server: Endpoint={}", (Object)endpointDescription);
            this.logger.debug("endpoints={}", Arrays.asList(endpointDescriptionArray3));
            throw new ServiceResultException(StatusCodes.Bad_SecurityModeRejected, "Requested endpoint is not found on the server");
        }
        if (endpointDescriptionArray2.length == 1) {
            session.gr = endpointDescriptionArray2[0];
        }
        return session;
    }

    public SessionChannel createSessionChannel(ApplicationDescription applicationDescription) throws ServiceResultException {
        SecureChannel secureChannel = this.createSecureChannel(applicationDescription);
        try {
            Session session = this.createSession(secureChannel);
            SessionChannel sessionChannel = session.createSessionChannel(secureChannel, this);
            return sessionChannel;
        }
        catch (ServiceResultException serviceResultException) {
            secureChannel.closeAsync();
            throw serviceResultException;
        }
    }

    public SessionChannel createSessionChannel(EndpointDescription endpointDescription) throws ServiceResultException {
        return this.createSessionChannel(endpointDescription.getEndpointUrl(), endpointDescription);
    }

    public SessionChannel createSessionChannel(String string) throws ServiceResultException {
        return this.createSessionChannel(string, string);
    }

    public SessionChannel createSessionChannel(String string, EndpointDescription endpointDescription) throws ServiceResultException {
        SecureChannel secureChannel = this.createSecureChannel(string, endpointDescription);
        try {
            Session session = this.createSession(secureChannel);
            SessionChannel sessionChannel = session.createSessionChannel(secureChannel, this);
            return sessionChannel;
        }
        catch (ServiceResultException serviceResultException) {
            secureChannel.closeAsync();
            throw serviceResultException;
        }
    }

    public SessionChannel createSessionChannel(String string, String string2) throws ServiceResultException {
        EndpointDescription[] endpointDescriptionArray = this.discoverEndpoints(string, string);
        EndpointDescription endpointDescription = EndpointUtil.select(endpointDescriptionArray, string2);
        SecureChannel secureChannel = this.createSecureChannel(string, endpointDescription);
        try {
            Session session = this.createSession(secureChannel);
            SessionChannel sessionChannel = session.createSessionChannel(secureChannel, this);
            return sessionChannel;
        }
        catch (ServiceResultException serviceResultException) {
            secureChannel.closeAsync();
            throw serviceResultException;
        }
    }

    public ApplicationDescription[] discoverApplications(String string) throws ServiceResultException {
        return this.discoverApplications(string, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationDescription[] discoverApplications(String string, String string2) throws ServiceResultException {
        SecurityMode securityMode = SecurityMode.NONE;
        SecureChannel secureChannel = this.createSecureChannel(string, string2, securityMode, null);
        ChannelService channelService = new ChannelService(secureChannel);
        try {
            FindServersRequest findServersRequest = new FindServersRequest(null, string2, new String[0], new String[0]);
            findServersRequest.setRequestHeader(new RequestHeader());
            findServersRequest.getRequestHeader().setTimeoutHint(UnsignedInteger.valueOf(this.getTimeout()));
            findServersRequest.getRequestHeader().setTimestamp(DateTime.currentTime());
            FindServersResponse findServersResponse = channelService.FindServers(findServersRequest);
            ApplicationDescription[] applicationDescriptionArray = findServersResponse.getServers();
            return applicationDescriptionArray;
        }
        finally {
            secureChannel.close();
            secureChannel.dispose();
        }
    }

    public EndpointDescription[] discoverEndpoints(String string) throws ServiceResultException {
        return this.discoverEndpoints(string, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EndpointDescription[] discoverEndpoints(String string, String string2) throws ServiceResultException {
        SecureChannel secureChannel = this.createSecureChannel(string, string2, SecurityMode.NONE, null);
        ChannelService channelService = new ChannelService(secureChannel);
        try {
            EndpointDescription[] endpointDescriptionArray;
            GetEndpointsRequest getEndpointsRequest = new GetEndpointsRequest(null, string2, new String[0], new String[0]);
            getEndpointsRequest.setRequestHeader(new RequestHeader());
            getEndpointsRequest.getRequestHeader().setTimeoutHint(UnsignedInteger.valueOf(this.getTimeout()));
            getEndpointsRequest.getRequestHeader().setTimestamp(DateTime.currentTime());
            GetEndpointsResponse getEndpointsResponse = channelService.GetEndpoints(getEndpointsRequest);
            EndpointDescription[] endpointDescriptionArray2 = endpointDescriptionArray = getEndpointsResponse.getEndpoints();
            return endpointDescriptionArray2;
        }
        finally {
            secureChannel.close();
            secureChannel.dispose();
        }
    }

    public ServerOnNetwork[] discoverServersOnNetwork(String string) throws ServiceResultException {
        return this.discoverServersOnNetwork(string, string);
    }

    public ServerOnNetwork[] discoverServersOnNetwork(String string, String string2) throws ServiceResultException {
        return this.discoverServersOnNetwork(string, string2, new String[0]);
    }

    public ServerOnNetwork[] discoverServersOnNetwork(String string, String string2, String[] stringArray) throws ServiceResultException {
        return this.discoverServersOnNetwork(string, string2, UnsignedInteger.ZERO, UnsignedInteger.ZERO, stringArray).getServers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FindServersOnNetworkResponse discoverServersOnNetwork(String string, String string2, UnsignedInteger unsignedInteger, UnsignedInteger unsignedInteger2, String[] stringArray) throws ServiceResultException {
        SecurityMode securityMode = SecurityMode.NONE;
        SecureChannel secureChannel = this.createSecureChannel(string, string2, securityMode, null);
        ChannelService channelService = new ChannelService(secureChannel);
        try {
            FindServersOnNetworkResponse findServersOnNetworkResponse;
            FindServersOnNetworkRequest findServersOnNetworkRequest = new FindServersOnNetworkRequest(null, unsignedInteger, unsignedInteger2, stringArray);
            findServersOnNetworkRequest.setRequestHeader(new RequestHeader());
            findServersOnNetworkRequest.getRequestHeader().setTimeoutHint(UnsignedInteger.valueOf(this.getTimeout()));
            findServersOnNetworkRequest.getRequestHeader().setTimestamp(DateTime.currentTime());
            FindServersOnNetworkResponse findServersOnNetworkResponse2 = findServersOnNetworkResponse = channelService.FindServersOnNetwork(findServersOnNetworkRequest);
            return findServersOnNetworkResponse2;
        }
        finally {
            secureChannel.close();
            secureChannel.dispose();
        }
    }

    public Application getApplication() {
        return this.application;
    }

    public HttpsSettings getApplicationHttpsSettings() {
        return this.application.getHttpsSettings();
    }

    public OpcTcpSettings getApplicatioOpcTcpSettings() {
        return this.application.getOpctcpSettings();
    }

    public EncoderContext getEncoderContext() {
        return this.application.getEncoderContext();
    }

    public EndpointConfiguration getEndpointConfiguration() {
        return this.gs;
    }

    public int getMaxMessageSize() {
        return this.gs.getMaxMessageSize();
    }

    public int getTimeout() {
        return this.gs.getOperationTimeout();
    }

    public void setEndpointConfiguration(EndpointConfiguration endpointConfiguration) {
        this.gs = endpointConfiguration;
    }

    public void setMaxMessageSize(int n2) {
        this.gs.setMaxMessageSize(n2);
    }

    public void setTimeout(int n2) {
        this.gs.setOperationTimeout(n2);
    }

    private void a(String string, EndpointDescription[] endpointDescriptionArray, EndpointDescription[] endpointDescriptionArray2) throws ServiceResultException {
        if (endpointDescriptionArray2 == null) {
            return;
        }
        ArrayList<EndpointDescription> arrayList = new ArrayList<EndpointDescription>();
        for (EndpointDescription endpointDescription : endpointDescriptionArray2) {
            EndpointDescription endpointDescription2 = endpointDescription.clone();
            endpointDescription2.setServer(null);
            endpointDescription2.setServerCertificate(null);
            arrayList.add(endpointDescription2);
        }
        ArrayList arrayList2 = new ArrayList();
        for (EndpointDescription endpointDescription2 : endpointDescriptionArray) {
            EndpointDescription endpointDescription = endpointDescription2.clone();
            endpointDescription.setServer(null);
            endpointDescription.setServerCertificate(null);
            arrayList2.add(endpointDescription);
        }
        for (EndpointDescription endpointDescription : arrayList) {
            if (arrayList2.contains(endpointDescription)) continue;
            this.logger.error("The endpoint received from GetEndpoints is not in the endpoints of CreateSessionResponse. Endpoint={}", (Object)endpointDescription);
            this.logger.error("GetEndpoints returned endpoints={}", arrayList);
            this.logger.error("CreateSessionResponse endpoints={}", (Object)arrayList2);
            throw new ServiceResultException(StatusCodes.Bad_UnexpectedError, "The endpoint received from GetEndpoints is not in the endpoints of CreateSessionResponse");
        }
    }

    SecureChannel A(String string) throws ServiceResultException {
        String string2 = UriUtil.getTransportProtocol(string);
        if (string2.equals("opc.tcp")) {
            SecureChannelTcp secureChannelTcp = new SecureChannelTcp();
            return secureChannelTcp;
        }
        if (string2.equals("opc.https")) {
            HttpsClient httpsClient = new HttpsClient(string2);
            HttpsClientSecureChannel httpsClientSecureChannel = new HttpsClientSecureChannel(httpsClient);
            return httpsClientSecureChannel;
        }
        if (string2.equals("http")) {
            HttpsClient httpsClient = new HttpsClient(string2);
            HttpsClientSecureChannel httpsClientSecureChannel = new HttpsClientSecureChannel(httpsClient);
            return httpsClientSecureChannel;
        }
        throw new ServiceResultException("Unsupported protocol: " + string2);
    }
}

