/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.application;

import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.common.NamespaceTable;
import com.prosysopc.ua.stack.common.ServerTable;
import com.prosysopc.ua.stack.core.ApplicationDescription;
import com.prosysopc.ua.stack.core.SignedSoftwareCertificate;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.transport.https.HttpsSettings;
import com.prosysopc.ua.stack.transport.security.CertificateValidator;
import com.prosysopc.ua.stack.transport.security.KeyPair;
import com.prosysopc.ua.stack.transport.tcp.io.OpcTcpSettings;
import com.prosysopc.ua.stack.utils.CryptoUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Application {
    private static final Logger logger = LoggerFactory.getLogger(Application.class);
    ApplicationDescription J = new ApplicationDescription();
    List<KeyPair> se = new CopyOnWriteArrayList<KeyPair>();
    List<SignedSoftwareCertificate> sf = new CopyOnWriteArrayList<SignedSoftwareCertificate>();
    List<Locale> mA = new CopyOnWriteArrayList<Locale>();
    HttpsSettings gu = new HttpsSettings();
    OpcTcpSettings sg = new OpcTcpSettings();
    private EncoderContext at = new EncoderContext(new NamespaceTable(), new ServerTable());

    public Application() {
        String string = "";
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        this.J.setApplicationUri("urn:" + string + ":" + UUID.randomUUID());
        this.getOpctcpSettings().setCertificateValidator(CertificateValidator.ALLOW_ALL);
        this.getHttpsSettings().setCertificateValidator(CertificateValidator.ALLOW_ALL);
    }

    public void addApplicationInstanceCertificate(KeyPair keyPair) {
        if (keyPair == null) {
            throw new IllegalArgumentException("null arg");
        }
        this.se.add(keyPair);
    }

    public void addLocale(Locale locale) {
        if (locale == null) {
            throw new IllegalArgumentException("null arg");
        }
        this.mA.add(locale);
    }

    public void addSoftwareCertificate(SignedSoftwareCertificate signedSoftwareCertificate) {
        if (signedSoftwareCertificate == null) {
            throw new IllegalArgumentException("null arg");
        }
        this.sf.add(signedSoftwareCertificate);
    }

    public ApplicationDescription getApplicationDescription() {
        return this.J;
    }

    public KeyPair getApplicationInstanceCertificate() {
        int n2 = this.se.size() - 1;
        if (n2 < 0) {
            return null;
        }
        return this.se.get(n2);
    }

    public KeyPair getApplicationInstanceCertificate(byte[] byArray) {
        logger.debug("getApplicationInstanceCertificate: expected={}", (Object)CryptoUtil.toHex(byArray));
        if (byArray != null) {
            int n2 = 0;
            for (KeyPair keyPair : this.se) {
                byte[] byArray2 = keyPair.getCertificate().getEncodedThumbprint();
                logger.debug("getApplicationInstanceCertificate: cert[{}]={}", (Object)n2++, (Object)CryptoUtil.toHex(byArray2));
                if (!Arrays.equals(byArray2, byArray)) continue;
                return keyPair;
            }
        }
        return null;
    }

    public KeyPair[] getApplicationInstanceCertificates() {
        return this.se.toArray(new KeyPair[this.se.size()]);
    }

    public String getApplicationUri() {
        return this.J.getApplicationUri();
    }

    public EncoderContext getEncoderContext() {
        return this.at;
    }

    public HttpsSettings getHttpsSettings() {
        return this.gu;
    }

    public String[] getLocaleIds() {
        ArrayList<String> arrayList = new ArrayList<String>(this.mA.size());
        for (Locale locale : this.mA) {
            arrayList.add(LocalizedText.toLocaleId(locale));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public Locale[] getLocales() {
        return this.mA.toArray(new Locale[0]);
    }

    public OpcTcpSettings getOpctcpSettings() {
        return this.sg;
    }

    public String getProductUri() {
        return this.J.getProductUri();
    }

    public SignedSoftwareCertificate[] getSoftwareCertificates() {
        return this.sf.toArray(new SignedSoftwareCertificate[this.sf.size()]);
    }

    public void removeApplicationInstanceCertificate(KeyPair keyPair) {
        this.se.remove(keyPair);
    }

    public void removeApplicationInstanceCertificates() {
        this.se.clear();
    }

    public void removeLocale(Locale locale) {
        this.mA.remove(locale);
    }

    public void setApplicationName(LocalizedText localizedText) {
        this.J.setApplicationName(localizedText);
    }

    public void setApplicationUri(String string) {
        this.J.setApplicationUri(string);
    }

    public void setHttpsSettings(HttpsSettings httpsSettings) {
        this.gu = httpsSettings;
    }

    public void setOpctcpSettings(OpcTcpSettings opcTcpSettings) {
        this.sg = opcTcpSettings;
    }

    public void setProductUri(String string) {
        this.J.setProductUri(string);
    }
}

