/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server.nodes;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.nodes.UaReference;
import com.prosysopc.ua.nodes.UaView;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.nodes.BaseNode;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.Attributes;
import com.prosysopc.ua.stack.core.EventNotifierType;
import com.prosysopc.ua.stack.core.GenericAttributeValue;
import com.prosysopc.ua.stack.core.GenericAttributes;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.stack.core.NodeAttributes;
import com.prosysopc.ua.stack.core.NodeClass;
import com.prosysopc.ua.stack.core.ViewAttributes;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class UaViewNode
extends BaseNode
implements UaView {
    static final QualifiedName ig = new QualifiedName("ViewVersion");
    boolean ih = false;
    EventNotifierType hS = EventNotifierType.of();

    public UaViewNode(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    public UaViewNode(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, String string, Locale locale) {
        super(nodeManagerUaNode, nodeId, string, locale);
    }

    protected UaViewNode(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public UaReference addProperty(UaProperty uaProperty) {
        throw new IllegalArgumentException("Cannot add property nodes to a View node");
    }

    @Override
    public NodeAttributes getAttributes() {
        return this.getAttributes(new ViewAttributes());
    }

    @Override
    public Boolean getContainsNoLoops() {
        return this.ih;
    }

    @Override
    public EventNotifierType getEventNotifier() {
        return this.hS;
    }

    @Override
    public final NodeClass getNodeClass() {
        return NodeClass.View;
    }

    @Override
    public UaProperty getViewVersion() {
        return this.getProperty(ig);
    }

    @Override
    public void setAttributes(NodeAttributes nodeAttributes) {
        if (nodeAttributes instanceof ViewAttributes) {
            ViewAttributes viewAttributes = (ViewAttributes)nodeAttributes;
            this.setContainsNoLoops(viewAttributes.getContainsNoLoops());
            this.setEventNotifier(EventNotifierType.of(viewAttributes.getEventNotifier()));
        } else if (nodeAttributes instanceof GenericAttributes) {
            GenericAttributes genericAttributes = (GenericAttributes)nodeAttributes;
            if (genericAttributes.getAttributeValues() != null) {
                for (int i2 = 0; i2 < genericAttributes.getAttributeValues().length; ++i2) {
                    GenericAttributeValue genericAttributeValue = genericAttributes.getAttributeValues()[i2];
                    if (Attributes.EventNotifier.equals(genericAttributeValue.getAttributeId())) {
                        this.setEventNotifier(EventNotifierType.of((UnsignedByte)genericAttributeValue.getValue()));
                        continue;
                    }
                    if (!Attributes.ContainsNoLoops.equals(genericAttributeValue.getAttributeId())) continue;
                    this.setContainsNoLoops((Boolean)genericAttributeValue.getValue());
                }
            }
        } else {
            throw new IllegalArgumentException("Incorrect NodeAttributes subtype given, was: " + nodeAttributes);
        }
        super.setAttributes(nodeAttributes);
    }

    @Override
    public void setContainsNoLoops(Boolean bl) {
        this.ih = bl;
    }

    @Override
    public void setEventNotifier(EventNotifierType eventNotifierType) {
        this.hS = eventNotifierType;
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    protected boolean beforeAddReference(UaReference uaReference) {
        if (uaReference.getReferenceTypeId().equals(Identifiers.HasProperty)) {
            throw new IllegalArgumentException("Cannot add property nodes to a View node");
        }
        return super.beforeAddReference(uaReference);
    }

    protected NodeAttributes getAttributes(ViewAttributes viewAttributes) {
        super.getAttributes(viewAttributes);
        viewAttributes.setContainsNoLoops(this.getContainsNoLoops());
        viewAttributes.setEventNotifier((UnsignedByte)this.getEventNotifier().asBuiltInType());
        return viewAttributes;
    }

    @Override
    protected void getAttributesMap(Map<UnsignedInteger, Object> map) {
        super.getAttributesMap(map);
        map.put(Attributes.ContainsNoLoops, this.getContainsNoLoops());
        map.put(Attributes.EventNotifier, this.getEventNotifier().asBuiltInType());
    }

    @Override
    protected void initSupportedAttributes(List<UnsignedInteger> list) {
        super.initSupportedAttributes(list);
        list.add(Attributes.ContainsNoLoops);
        list.add(Attributes.EventNotifier);
    }

    @Override
    protected void readAttributeValue(UnsignedInteger unsignedInteger, DataValue dataValue) throws StatusException {
        if (Attributes.EventNotifier.equals(unsignedInteger)) {
            dataValue.setValue(new Variant(this.hS.asBuiltInType()));
        } else if (Attributes.ContainsNoLoops.equals(unsignedInteger)) {
            dataValue.setValue(new Variant(this.ih));
        } else {
            super.readAttributeValue(unsignedInteger, dataValue);
        }
    }

    protected void setViewVersion(Integer n2) throws StatusException {
        this.setPropertyValue(ig, n2);
    }

    @Override
    protected void writeAttributeValue(UnsignedInteger unsignedInteger, Object object, StatusCode statusCode, DateTime dateTime, UnsignedShort unsignedShort) throws StatusException {
        if (Attributes.EventNotifier.equals(unsignedInteger)) {
            if (object instanceof EventNotifierType) {
                this.hS = (EventNotifierType)object;
            } else {
                byte by = 0;
                if (object instanceof UnsignedByte) {
                    by = ((UnsignedByte)object).byteValue();
                } else if (object instanceof UnsignedInteger) {
                    by = ((UnsignedInteger)object).byteValue();
                }
                this.hS = EventNotifierType.of(UnsignedByte.getFromBits(by));
            }
        } else if (Attributes.ContainsNoLoops.equals(unsignedInteger)) {
            this.ih = (Boolean)object;
        } else {
            super.writeAttributeValue(unsignedInteger, object, statusCode, dateTime, unsignedShort);
        }
    }
}

