/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server.nodes;

import com.prosysopc.ua.InternalArguments;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.nodes.UaReference;
import com.prosysopc.ua.nodes.UaReferenceType;
import com.prosysopc.ua.server.nodes.BaseNode;
import com.prosysopc.ua.server.nodes.ServerNode;
import com.prosysopc.ua.server.nodes.UaExternalNode;
import com.prosysopc.ua.server.nodes.c;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.core.Identifiers;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UaServerReference
extends UaReference {
    private static Logger logger = LoggerFactory.getLogger(UaServerReference.class);
    private UaNode rY;
    private final NodeId es;
    private Boolean rZ = null;
    private final UaNode rT;
    private final UaNode rU;
    private final int hash;

    public static UaServerReference getReferenceInstance(NodeId nodeId, UaNode uaNode, UaNode uaNode2) {
        UaServerReference uaServerReference = UaServerReference.a(nodeId, uaNode, uaNode2);
        if (uaServerReference != null) {
            return uaServerReference;
        }
        return new UaServerReference(nodeId, uaNode, uaNode2);
    }

    public static UaServerReference getReferenceInstance(UaReferenceType uaReferenceType, UaNode uaNode, UaNode uaNode2) {
        UaServerReference uaServerReference = UaServerReference.a(uaReferenceType.getNodeId(), uaNode, uaNode2);
        if (uaServerReference != null) {
            return uaServerReference;
        }
        return new UaServerReference(uaReferenceType, uaNode, uaNode2);
    }

    private static UaServerReference a(NodeId nodeId, UaNode uaNode, UaNode uaNode2) {
        if (nodeId == null) {
            throw new NullPointerException("referenceTypeId");
        }
        if (uaNode == null) {
            throw new NullPointerException("sourceNode");
        }
        if (uaNode2 == null) {
            throw new NullPointerException("targetNode");
        }
        AtomicReference<UaServerReference> atomicReference = new AtomicReference<UaServerReference>();
        if (UaServerReference.a(nodeId, uaNode, uaNode2, atomicReference)) {
            return atomicReference.get();
        }
        UaReference[] uaReferenceArray = uaNode.getReferences(nodeId, false);
        if (uaReferenceArray != null) {
            for (UaReference uaReference : uaReferenceArray) {
                if (!uaReference.getTargetId().equals(uaNode2.getNodeId())) continue;
                return (UaServerReference)uaReference;
            }
        }
        return null;
    }

    private static boolean a(NodeId nodeId, UaNode uaNode, UaNode uaNode2, AtomicReference<UaServerReference> atomicReference) {
        if (!(uaNode instanceof ServerNode) || !(uaNode2 instanceof ServerNode)) {
            return false;
        }
        ServerNode serverNode = (ServerNode)uaNode;
        c c2 = (c)serverNode.getReferenceList();
        if (!c2.cnH()) {
            return false;
        }
        if (Identifiers.HasProperty.equals(nodeId)) {
            if (uaNode instanceof BaseNode && uaNode2 instanceof UaProperty) {
                atomicReference.set((UaServerReference)((BaseNode)uaNode).getPropertyReference(uaNode2.getBrowseName()));
            } else {
                return false;
            }
        }
        atomicReference.set((UaServerReference)c2.asMap().get(new UaServerReference(nodeId, uaNode, uaNode2)));
        return true;
    }

    public UaServerReference(NodeId nodeId, UaNode uaNode, UaNode uaNode2) {
        this.es = InternalArguments.checkNotNull(nodeId, "ReferenceTypeId");
        this.rT = InternalArguments.checkNotNull(uaNode, "SourceNode");
        this.rU = InternalArguments.checkNotNull(uaNode2, "TargetNode");
        this.hash = this.calcHashCode();
    }

    public UaServerReference(UaReferenceType uaReferenceType, UaNode uaNode, UaNode uaNode2) {
        this(uaReferenceType.getNodeId(), uaNode, uaNode2);
        this.rY = uaReferenceType;
    }

    @Override
    public int compareTo(UaReference uaReference) {
        if (this == uaReference) {
            return 0;
        }
        if (!(uaReference instanceof UaServerReference)) {
            return super.compareTo(uaReference);
        }
        UaServerReference uaServerReference = (UaServerReference)uaReference;
        int n2 = 0;
        if (this.rT != uaServerReference.rT) {
            n2 = this.rT.getNodeId().compareTo(uaServerReference.rT.getNodeId());
        }
        if (n2 == 0 && this.rU != uaServerReference.rU) {
            n2 = this.rU.getNodeId().compareTo(uaServerReference.rU.getNodeId());
        }
        if (n2 == 0) {
            n2 = this.es.compareTo(uaServerReference.es);
        }
        return n2;
    }

    @Override
    public void delete() {
        this.rT.deleteReference(this);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        UaServerReference uaServerReference = (UaServerReference)object;
        if (this.hash != uaServerReference.hash) {
            return false;
        }
        if (this.rU == null ? uaServerReference.rU != null : this.rU != uaServerReference.rU) {
            return false;
        }
        if (this.rT == null ? uaServerReference.rT != null : this.rT != uaServerReference.rT) {
            return false;
        }
        return !(this.es == null ? uaServerReference.es != null : !this.es.equals(uaServerReference.es));
    }

    @Override
    public boolean getIsInverse(NodeId nodeId) {
        boolean bl;
        if (this.isSymmetric()) {
            return false;
        }
        boolean bl2 = bl = !this.rT.getNodeId().equals(nodeId);
        if (bl && !this.rU.getNodeId().equals(nodeId)) {
            throw new IllegalArgumentException("getIsInverse: node is neither targetNode nor sourceNode");
        }
        return bl;
    }

    @Override
    public boolean getIsInverse(UaNode uaNode) {
        boolean bl;
        if (uaNode == this.rT) {
            return false;
        }
        if (this.isSymmetric()) {
            return false;
        }
        if (uaNode == this.rU) {
            return true;
        }
        boolean bl2 = bl = !this.rT.getNodeId().equals(uaNode.getNodeId());
        if (bl && !this.rU.getNodeId().equals(uaNode.getNodeId())) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "getIsInverse: node (%s) is neither targetNode (%s) nor sourceNode (%s); referenceType=%s", uaNode.getNodeId(), this.getTargetId(), this.getSourceId(), this.getReferenceType().getBrowseName()));
        }
        return bl;
    }

    @Override
    public UaNode getOppositeNode(UaNode uaNode) {
        if (uaNode == this.rT) {
            return this.rU;
        }
        if (uaNode == this.rU) {
            return this.rT;
        }
        return super.getOppositeNode(uaNode);
    }

    @Override
    public UaReferenceType getReferenceType() {
        if (this.rY == null) {
            try {
                ServerNode serverNode = null;
                if (this.rT instanceof ServerNode) {
                    serverNode = (ServerNode)this.rT;
                } else if (this.rU instanceof ServerNode) {
                    serverNode = (ServerNode)this.rU;
                }
                if (serverNode != null) {
                    this.rY = serverNode.getNodeManager().getNode(this.es);
                }
            }
            catch (StatusException statusException) {
                logger.debug("ReferenceType {} could not be found", (Object)this.es);
                return null;
            }
        }
        if (this.rY instanceof UaReferenceType) {
            return (UaReferenceType)this.rY;
        }
        return null;
    }

    @Override
    public NodeId getReferenceTypeId() {
        return this.es;
    }

    @Override
    public ExpandedNodeId getSourceId() {
        return new ExpandedNodeId(this.rT.getNodeId());
    }

    @Override
    public UaNode getSourceNode() {
        return this.rT;
    }

    @Override
    public ExpandedNodeId getTargetId() {
        return new ExpandedNodeId(this.rU.getNodeId());
    }

    @Override
    public UaNode getTargetNode() {
        return this.rU;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean isSymmetric() {
        this.cnI();
        return this.rZ != null && this.rZ != false;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("");
        UaReferenceType uaReferenceType = this.getReferenceType();
        if (uaReferenceType != null) {
            stringBuilder.append(" ReferenceType=");
            stringBuilder.append(uaReferenceType.getBrowseName());
        }
        if (!(this.rT instanceof UaExternalNode)) {
            stringBuilder.append(" SourceNode=");
            stringBuilder.append(this.rT.getBrowseName());
        }
        if (!(this.rU instanceof UaExternalNode)) {
            stringBuilder.append(" TargetNode=");
            stringBuilder.append(this.rU.getBrowseName());
        }
        return super.toString() + stringBuilder.toString();
    }

    private int calcHashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + this.es.hashCode();
        n3 = 31 * n3 + this.rU.getNodeId().hashCode();
        n3 = 31 * n3 + this.rT.getNodeId().hashCode();
        return n3;
    }

    private void cnI() {
        UaReferenceType uaReferenceType;
        if (this.rZ == null && (uaReferenceType = this.getReferenceType()) != null) {
            this.rZ = uaReferenceType.getSymmetric() != false ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
    }
}

