/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server.nodes;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaReferenceType;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.nodes.UaTypeNode;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.Attributes;
import com.prosysopc.ua.stack.core.GenericAttributeValue;
import com.prosysopc.ua.stack.core.GenericAttributes;
import com.prosysopc.ua.stack.core.NodeAttributes;
import com.prosysopc.ua.stack.core.NodeClass;
import com.prosysopc.ua.stack.core.ReferenceTypeAttributes;
import com.prosysopc.ua.stack.core.StatusCodes;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class UaReferenceTypeNode
extends UaTypeNode
implements UaReferenceType {
    LocalizedText hW = null;
    Boolean hX = true;

    public UaReferenceTypeNode(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    public UaReferenceTypeNode(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, String string, Locale locale) {
        super(nodeManagerUaNode, nodeId, string, locale);
    }

    protected UaReferenceTypeNode(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public NodeAttributes getAttributes() {
        return this.getAttributes(new ReferenceTypeAttributes());
    }

    @Override
    public LocalizedText getInverseName() {
        if (this.hX.booleanValue()) {
            return this.getDisplayName();
        }
        return this.hW;
    }

    @Override
    public final NodeClass getNodeClass() {
        return NodeClass.ReferenceType;
    }

    @Override
    public Boolean getSymmetric() {
        return this.hX;
    }

    @Override
    public void setAttributes(NodeAttributes nodeAttributes) {
        if (nodeAttributes instanceof ReferenceTypeAttributes) {
            this.setInverseName(((ReferenceTypeAttributes)nodeAttributes).getInverseName());
            this.setSymmetric(((ReferenceTypeAttributes)nodeAttributes).getSymmetric());
            this.setIsAbstract(((ReferenceTypeAttributes)nodeAttributes).getIsAbstract());
        } else if (nodeAttributes instanceof GenericAttributes) {
            GenericAttributes genericAttributes = (GenericAttributes)nodeAttributes;
            if (genericAttributes.getAttributeValues() != null) {
                for (int i2 = 0; i2 < genericAttributes.getAttributeValues().length; ++i2) {
                    GenericAttributeValue genericAttributeValue = genericAttributes.getAttributeValues()[i2];
                    if (Attributes.InverseName.equals(genericAttributeValue.getAttributeId())) {
                        this.setInverseName((LocalizedText)genericAttributeValue.getValue());
                        continue;
                    }
                    if (Attributes.Symmetric.equals(genericAttributeValue.getAttributeId())) {
                        this.setSymmetric((Boolean)genericAttributeValue.getValue());
                        continue;
                    }
                    if (!Attributes.IsAbstract.equals(genericAttributeValue.getAttributeId())) continue;
                    this.setIsAbstract((Boolean)genericAttributeValue.getValue());
                }
            } else {
                throw new IllegalArgumentException("Incorrect NodeAttributes subtype given, was: " + nodeAttributes);
            }
        }
        super.setAttributes(nodeAttributes);
    }

    @Override
    public void setInverseName(LocalizedText localizedText) {
        this.hW = localizedText;
        this.hX = localizedText == null;
    }

    @Override
    public void setSymmetric(Boolean bl) {
        this.hX = bl;
        if (bl.booleanValue()) {
            this.hW = null;
        }
    }

    @Override
    public String toString() {
        return super.toString() + String.format(Locale.ROOT, ", Symmetric=%s, InverseName=%s", this.hX, this.hW);
    }

    protected ReferenceTypeAttributes getAttributes(ReferenceTypeAttributes referenceTypeAttributes) {
        super.getAttributes(referenceTypeAttributes);
        referenceTypeAttributes.setInverseName(this.getInverseName());
        referenceTypeAttributes.setIsAbstract(this.getIsAbstract());
        referenceTypeAttributes.setSymmetric(this.getSymmetric());
        return referenceTypeAttributes;
    }

    @Override
    protected void getAttributesMap(Map<UnsignedInteger, Object> map) {
        super.getAttributesMap(map);
        map.put(Attributes.InverseName, this.getInverseName());
        map.put(Attributes.IsAbstract, this.getIsAbstract());
        map.put(Attributes.Symmetric, this.getSymmetric());
    }

    @Override
    protected void initSupportedAttributes(List<UnsignedInteger> list) {
        super.initSupportedAttributes(list);
        list.add(Attributes.Symmetric);
        list.add(Attributes.InverseName);
    }

    @Override
    protected void readAttributeValue(UnsignedInteger unsignedInteger, DataValue dataValue) throws StatusException {
        if (unsignedInteger.equals(Attributes.Symmetric)) {
            dataValue.setValue(new Variant(this.hX));
        } else if (unsignedInteger.equals(Attributes.InverseName)) {
            if (Boolean.TRUE.equals(this.hX)) {
                throw new StatusException("Symmetric ReferenceTypes shall not have InverseName", StatusCodes.Bad_AttributeIdInvalid);
            }
            dataValue.setValue(new Variant(this.hW));
        } else {
            super.readAttributeValue(unsignedInteger, dataValue);
        }
    }

    @Override
    protected void writeAttributeValue(UnsignedInteger unsignedInteger, Object object, StatusCode statusCode, DateTime dateTime, UnsignedShort unsignedShort) throws StatusException {
        if (unsignedInteger.equals(Attributes.Symmetric)) {
            this.hX = (Boolean)object;
        } else if (unsignedInteger.equals(Attributes.InverseName)) {
            this.hW = (LocalizedText)object;
        } else {
            super.writeAttributeValue(unsignedInteger, object, statusCode, dateTime, unsignedShort);
        }
    }
}

