/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server.instantiation;

import com.prosysopc.ua.UaBrowseNamePath;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.UaQualifiedName;
import com.prosysopc.ua.nodes.UaInstance;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaType;
import com.prosysopc.ua.server.ModellingRule;
import com.prosysopc.ua.server.instantiation.DefaultInstantiationStrategy;
import com.prosysopc.ua.server.instantiation.InstanceDeclaration;
import com.prosysopc.ua.server.instantiation.InstantiationStrategy;
import com.prosysopc.ua.server.instantiation.UaNodeBuilderConfiguration;
import com.prosysopc.ua.stack.common.NamespaceTable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeDefinitionBasedNodeBuilderConfiguration
implements UaNodeBuilderConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(TypeDefinitionBasedNodeBuilderConfiguration.class);
    private final InstantiationStrategy ro;
    private final Map<UaBrowseNamePath, InstantiationStrategy> rp;
    private final Map<UaQualifiedName, InstantiationStrategy> rq;
    private final boolean rr;

    public static Builder builder() {
        return new Builder(new DefaultInstantiationStrategy(DefaultInstantiationStrategy.MethodInstantiationLogic.SHARED));
    }

    public static Builder builder(InstantiationStrategy instantiationStrategy) {
        return new Builder(instantiationStrategy);
    }

    public static Builder builder(DefaultInstantiationStrategy.MethodInstantiationLogic methodInstantiationLogic) {
        return new Builder(new DefaultInstantiationStrategy(methodInstantiationLogic));
    }

    private TypeDefinitionBasedNodeBuilderConfiguration(InstantiationStrategy instantiationStrategy, Map<UaBrowseNamePath, InstantiationStrategy> map, Map<UaQualifiedName, InstantiationStrategy> map2, boolean bl) {
        this.ro = instantiationStrategy;
        this.rp = map;
        this.rq = map2;
        this.rr = bl;
    }

    @Override
    public InstantiationStrategy getInstantiationStrategy(UaNodeBuilderConfiguration.InstantiationStrategySearchParameters instantiationStrategySearchParameters) {
        try {
            if (instantiationStrategySearchParameters.getHierarchy().length == 0) {
                return this.ro;
            }
            InstanceDeclaration[] instanceDeclarationArray = instantiationStrategySearchParameters.getHierarchy();
            UaNode uaNode = instanceDeclarationArray[instanceDeclarationArray.length - 1].getNode();
            logger.debug("Searching using TypeDefinition of node with id: {}, name:{}", (Object)uaNode.getNodeId(), (Object)uaNode.getBrowseName());
            if (uaNode instanceof UaInstance || uaNode instanceof UaType) {
                Comparable<UaNodeId> comparable;
                UaType uaType;
                InstantiationStrategy instantiationStrategy = null;
                NamespaceTable namespaceTable = uaType.getAddressSpace().getNamespaceTable();
                UaQualifiedName uaQualifiedName = UaQualifiedName.from(instantiationStrategySearchParameters.getInstanceDeclaration().getNode().getBrowseName(), namespaceTable);
                for (uaType = uaNode instanceof UaType ? (UaType)uaNode : ((UaInstance)uaNode).getTypeDefinition(); uaType != null && instantiationStrategy == null; uaType = uaType.getSuperType()) {
                    comparable = UaNodeId.fromLocal(uaType.getNodeId(), namespaceTable);
                    UaBrowseNamePath uaBrowseNamePath = UaBrowseNamePath.from(comparable, new UaQualifiedName[]{uaQualifiedName});
                    instantiationStrategy = this.rp.get(uaBrowseNamePath);
                    if (instantiationStrategy != null) {
                        logger.debug("Found td/id: {}/{}, found: {}", new Object[]{uaType.getBrowseName(), uaQualifiedName.toQualifiedName(namespaceTable), instantiationStrategy});
                        continue;
                    }
                    logger.debug("Not found in/td/id: {}/({})/{}, searching again using super type of the typedefinition", new Object[]{uaNode.getBrowseName(), uaType.getBrowseName(), uaQualifiedName.toQualifiedName(namespaceTable)});
                }
                if (instantiationStrategy == null) {
                    comparable = UaQualifiedName.from(instantiationStrategySearchParameters.getInstanceDeclaration().getNode().getBrowseName(), namespaceTable);
                    instantiationStrategy = this.rq.get(comparable);
                }
                if (instantiationStrategy == null && ModellingRule.Mandatory == instantiationStrategySearchParameters.getInstanceDeclaration().getModellingRule()) {
                    instantiationStrategy = this.ro;
                }
                logger.debug("Returning strategy:{}", instantiationStrategy);
                if (instantiationStrategy != null) {
                    return instantiationStrategy;
                }
            }
            if (ModellingRule.Mandatory == instantiationStrategySearchParameters.getInstanceDeclaration().getModellingRule()) {
                return this.ro;
            }
            if (this.rr && !ModellingRule.MandatoryPlaceholder.equals(instantiationStrategySearchParameters.getInstanceDeclaration().getModellingRule()) && !ModellingRule.OptionalPlaceholder.equals(instantiationStrategySearchParameters.getInstanceDeclaration().getModellingRule())) {
                return this.ro;
            }
            return null;
        }
        catch (RuntimeException runtimeException) {
            logger.error("Error while searching InstantiationStrategy", (Throwable)runtimeException);
            throw runtimeException;
        }
    }

    public static class Builder {
        private final InstantiationStrategy rs;
        private final Map<UaBrowseNamePath, InstantiationStrategy> rt;
        private final Map<UaQualifiedName, InstantiationStrategy> ru;
        private boolean rr;

        private Builder(InstantiationStrategy instantiationStrategy) {
            this.rs = instantiationStrategy;
            this.rt = new HashMap<UaBrowseNamePath, InstantiationStrategy>();
            this.ru = new HashMap<UaQualifiedName, InstantiationStrategy>();
            this.rr = false;
        }

        public Builder addOptional(Collection<UaBrowseNamePath> collection) {
            this.addOptional(collection.toArray(new UaBrowseNamePath[collection.size()]));
            return this;
        }

        public Builder addOptional(UaBrowseNamePath ... uaBrowseNamePathArray) {
            if (uaBrowseNamePathArray != null) {
                for (UaBrowseNamePath uaBrowseNamePath : uaBrowseNamePathArray) {
                    this.rt.put(uaBrowseNamePath, this.rs);
                }
            }
            return this;
        }

        public Builder addOptional(UaQualifiedName uaQualifiedName) {
            this.ru.put(uaQualifiedName, this.rs);
            return this;
        }

        public TypeDefinitionBasedNodeBuilderConfiguration build() {
            HashMap<UaBrowseNamePath, InstantiationStrategy> hashMap = new HashMap<UaBrowseNamePath, InstantiationStrategy>();
            hashMap.putAll(this.rt);
            HashMap<UaQualifiedName, InstantiationStrategy> hashMap2 = new HashMap<UaQualifiedName, InstantiationStrategy>();
            hashMap2.putAll(this.ru);
            return new TypeDefinitionBasedNodeBuilderConfiguration(this.rs, hashMap, hashMap2, this.rr);
        }

        public Builder setInstantiateAllOptionals(boolean bl) {
            this.rr = bl;
            return this;
        }

        public Builder setInstantiationStrategy(UaBrowseNamePath uaBrowseNamePath, InstantiationStrategy instantiationStrategy) {
            this.rt.put(uaBrowseNamePath, instantiationStrategy);
            return this;
        }
    }
}

