/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.InternalUaNodeSetNodeManagerUaNodeParser;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.UaArrayDimensions;
import com.prosysopc.ua.UaException;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.UaNodeSet;
import com.prosysopc.ua.UaOptionSet;
import com.prosysopc.ua.UaQualifiedName;
import com.prosysopc.ua.UaReferenceTypeIds;
import com.prosysopc.ua.internal.InternalDefinitionFieldXMLDataContainer;
import com.prosysopc.ua.internal.InternalDefinitionXMLDataContainer;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaReference;
import com.prosysopc.ua.server.GeneratedNode;
import com.prosysopc.ua.server.ModelParser;
import com.prosysopc.ua.server.NodeManagerTable;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.server.UaNodeSetLoadOptions;
import com.prosysopc.ua.stack.builtintypes.Enumeration;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.ExtensionObject;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.AddNodesItem;
import com.prosysopc.ua.stack.core.AddReferencesItem;
import com.prosysopc.ua.stack.core.GenericAttributeValue;
import com.prosysopc.ua.stack.core.GenericAttributes;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.stack.core.NodeClass;
import com.prosysopc.ua.stack.core.OptionSet;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.MultiDimensionArrayUtils;
import com.prosysopc.ua.typedictionary.DynamicOptionSetStructure;
import com.prosysopc.ua.typedictionary.DynamicStructure;
import com.prosysopc.ua.typedictionary.EnumerationSpecification;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.OptionSetSpecification;
import com.prosysopc.ua.typedictionary.OptionSetStructure;
import com.prosysopc.ua.typedictionary.OptionSetStructureSpecification;
import com.prosysopc.ua.typedictionary.OptionSpecification;
import com.prosysopc.ua.typedictionary.SimpleTypeSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.typedictionary.UaDataTypeSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class a {
    private static final Logger logger = LoggerFactory.getLogger(a.class);
    private static final UaQualifiedName jd = UaQualifiedName.standard("Default Binary");
    private static final UaQualifiedName je = UaQualifiedName.standard("Default XML");
    private static final UaQualifiedName jf = UaQualifiedName.standard("Default JSON");
    private final EncoderContext jg;
    private final List<UaNodeSet> jh;
    private final Set<UaNodeId> ji = new HashSet<UaNodeId>();
    private final Set<UaNodeId> jj = new HashSet<UaNodeId>();
    private final Set<UaNodeId> jk = new HashSet<UaNodeId>();
    private final Set<UaNodeId> jl = new HashSet<UaNodeId>();
    private final Map<UaNodeId, UaNodeId> jm = new HashMap<UaNodeId, UaNodeId>();
    private final Map<UaNodeId, UaNodeId> jn = new HashMap<UaNodeId, UaNodeId>();
    private final Map<UaNodeId, UaNodeId> jo = new HashMap<UaNodeId, UaNodeId>();
    private final Map<UaNodeId, UaNodeId> jp = new HashMap<UaNodeId, UaNodeId>();
    private final Map<UaNodeId, UaNodeId> jq = new HashMap<UaNodeId, UaNodeId>();
    private final Set<UaNodeSet.NodeData> jr = new CopyOnWriteArraySet<UaNodeSet.NodeData>();
    private final Set<UaNodeSet.NodeData> js = new CopyOnWriteArraySet<UaNodeSet.NodeData>();
    private final Set<UaNodeSet.NodeData> jt = new CopyOnWriteArraySet<UaNodeSet.NodeData>();
    private final Set<UaNodeSet.NodeData> ju = new CopyOnWriteArraySet<UaNodeSet.NodeData>();
    private final Set<UaNodeSet.NodeData> jv = new CopyOnWriteArraySet<UaNodeSet.NodeData>();
    private final Set<AddNodesItem> jw = new HashSet<AddNodesItem>();
    private final Set<AddReferencesItem> jx = new HashSet<AddReferencesItem>();
    private final UaNodeSetLoadOptions jy;

    protected static a a(EncoderContext encoderContext, UaNodeSetLoadOptions uaNodeSetLoadOptions, Iterable<UaNodeSet> iterable) {
        EncoderContext encoderContext2 = encoderContext;
        ArrayList<UaNodeSet> arrayList = new ArrayList<UaNodeSet>();
        iterable.forEach(uaNodeSet -> arrayList.add((UaNodeSet)uaNodeSet));
        return new a(encoderContext2, uaNodeSetLoadOptions, arrayList);
    }

    protected static a a(EncoderContext encoderContext, UaNodeSetLoadOptions uaNodeSetLoadOptions, UaNodeSet ... uaNodeSetArray) {
        return a.a(encoderContext, uaNodeSetLoadOptions, Arrays.asList(uaNodeSetArray));
    }

    private a(EncoderContext encoderContext, UaNodeSetLoadOptions uaNodeSetLoadOptions, List<UaNodeSet> list) {
        this.jg = encoderContext;
        this.jy = uaNodeSetLoadOptions;
        this.jh = list;
    }

    private void cjY() {
        this.jh.forEach(uaNodeSet -> uaNodeSet.getNamespaces().forEach(uaNamespace -> this.jg.getNamespaceTable().add(uaNamespace.getURI())));
    }

    private Optional<UaDataTypeSpecification> f(UaNodeId uaNodeId) {
        UaNodeId uaNodeId2 = uaNodeId;
        UaDataTypeSpecification uaDataTypeSpecification = null;
        while ((uaNodeId2 = this.jp.get(uaNodeId2)) != null && (uaDataTypeSpecification = this.jg.getDataTypeSpecifications().get(uaNodeId2)) == null) {
        }
        return Optional.ofNullable(uaDataTypeSpecification);
    }

    private void cjZ() {
        this.jh.stream().flatMap(uaNodeSet -> uaNodeSet.getNodes().stream()).filter(nodeData -> nodeData.getNodeClass() == NodeClass.DataType).forEach(nodeData -> {
            if (this.jg.getDataTypeSpecifications().containsKey(nodeData.getNodeId())) {
                return;
            }
            if (this.h(nodeData.getNodeId())) {
                this.jt.add((UaNodeSet.NodeData)nodeData);
                return;
            }
            if (this.i(nodeData.getNodeId())) {
                if (UaIds.Structure.equals(nodeData.getNodeId())) {
                    return;
                }
                this.js.add((UaNodeSet.NodeData)nodeData);
                return;
            }
            if (this.g(nodeData.getNodeId())) {
                this.jr.add((UaNodeSet.NodeData)nodeData);
                return;
            }
            InternalDefinitionXMLDataContainer internalDefinitionXMLDataContainer = (InternalDefinitionXMLDataContainer)nodeData.get(InternalUaNodeSetNodeManagerUaNodeParser.internal());
            if (internalDefinitionXMLDataContainer == null) {
                this.jv.add((UaNodeSet.NodeData)nodeData);
                return;
            }
            if (internalDefinitionXMLDataContainer.isOptionSet) {
                this.ju.add((UaNodeSet.NodeData)nodeData);
                return;
            }
            logger.warn("Encountered DataType whose kind cannot be resolved, name: {}, id: {}", (Object)nodeData.getBrowseName(), (Object)nodeData.getNodeId());
        });
        logger.debug("Unknown DataTypes to resolve counts, enumerations: {}, simpletypes: {}, optionsets: {}, structures: {}, optionsetstructures: {}", new Object[]{this.jr.size(), this.jv.size(), this.ju.size(), this.js.size(), this.jt.size()});
    }

    private boolean g(UaNodeId uaNodeId) {
        if (uaNodeId == null) {
            return false;
        }
        if (UaIds.Enumeration.equals(uaNodeId)) {
            return true;
        }
        if (this.jg.getDataTypeSpecifications().get(uaNodeId) instanceof EnumerationSpecification) {
            return true;
        }
        return this.g(this.jp.get(uaNodeId));
    }

    private boolean h(UaNodeId uaNodeId) {
        if (uaNodeId == null) {
            return false;
        }
        if (UaIds.OptionSet.equals(uaNodeId)) {
            return true;
        }
        if (this.jg.getDataTypeSpecifications().get(uaNodeId) instanceof OptionSetStructureSpecification) {
            return true;
        }
        return this.h(this.jp.get(uaNodeId));
    }

    private boolean i(UaNodeId uaNodeId) {
        if (uaNodeId == null) {
            return false;
        }
        if (UaIds.Structure.equals(uaNodeId)) {
            return true;
        }
        if (this.jg.getDataTypeSpecifications().get(uaNodeId) instanceof StructureSpecification) {
            return true;
        }
        return this.i(this.jp.get(uaNodeId));
    }

    private void cka() {
        this.ji.addAll(this.jg.getDataTypeSpecifications().keySet());
        this.ji.add(UaIds.Structure);
        this.ji.add(UaIds.Enumeration);
        this.jh.stream().flatMap(uaNodeSet -> uaNodeSet.getNodes().stream()).filter(nodeData -> nodeData.getNodeClass() == NodeClass.DataType).forEach(nodeData -> this.ji.add(nodeData.getNodeId()));
    }

    private void f(UaNodeSet.NodeData nodeData) {
        if (UaIds.Enumeration.equals(nodeData.getNodeId())) {
            return;
        }
        EnumerationSpecification.Builder builder = EnumerationSpecification.builder();
        builder.setTypeId(nodeData.getNodeId());
        builder.setName(nodeData.getBrowseName().getName());
        InternalDefinitionXMLDataContainer internalDefinitionXMLDataContainer = (InternalDefinitionXMLDataContainer)nodeData.get(InternalUaNodeSetNodeManagerUaNodeParser.internal());
        if (internalDefinitionXMLDataContainer != null) {
            HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
            internalDefinitionXMLDataContainer.fields.forEach(internalDefinitionFieldXMLDataContainer -> hashMap.put(internalDefinitionFieldXMLDataContainer.value, internalDefinitionFieldXMLDataContainer.name));
            builder.setMappings(hashMap);
        }
        logger.debug("Resolved Enumeration: {}, id: {}", (Object)nodeData.getBrowseName(), (Object)nodeData.getNodeId());
        this.jg.addDataTypeSpecification(builder.build());
    }

    private void g(UaNodeSet.NodeData nodeData) {
        Optional<UaDataTypeSpecification> optional = this.f(nodeData.getNodeId());
        if (!optional.isPresent()) {
            logger.warn("Cannot resolve parent specification for node, name: {}, id: {}", (Object)nodeData.getBrowseName(), (Object)nodeData.getNodeId());
            return;
        }
        InternalDefinitionXMLDataContainer internalDefinitionXMLDataContainer = (InternalDefinitionXMLDataContainer)nodeData.get(InternalUaNodeSetNodeManagerUaNodeParser.internal());
        if (internalDefinitionXMLDataContainer == null) {
            logger.warn("UInteger-OptionSets without <Definition> not yet supported, {}, id: {}", (Object)nodeData.getBrowseName(), (Object)nodeData.getNodeId());
            return;
        }
        OptionSetSpecification.Builder<UaOptionSet.Builder> builder = OptionSetSpecification.builder();
        builder.setTypeId(nodeData.getNodeId());
        builder.setName(nodeData.getBrowseName().getName());
        UaDataTypeSpecification uaDataTypeSpecification = optional.get();
        if (uaDataTypeSpecification instanceof SimpleTypeSpecification) {
            SimpleTypeSpecification simpleTypeSpecification = (SimpleTypeSpecification)uaDataTypeSpecification;
            builder.setBaseTypeId(simpleTypeSpecification.getBaseTypeId());
            for (InternalDefinitionFieldXMLDataContainer internalDefinitionFieldXMLDataContainer : internalDefinitionXMLDataContainer.fields) {
                OptionSpecification.Builder builder2 = OptionSpecification.builder();
                builder2.setName(internalDefinitionFieldXMLDataContainer.name);
                builder2.setBitPosition(internalDefinitionFieldXMLDataContainer.value);
                builder.addOptions(builder2.build());
            }
            this.jg.addDataTypeSpecification(builder.build());
            return;
        }
        if (uaDataTypeSpecification instanceof OptionSetSpecification) {
            OptionSetSpecification optionSetSpecification = (OptionSetSpecification)uaDataTypeSpecification;
            builder.setBaseTypeId(optionSetSpecification.getBaseTypeId());
            for (InternalDefinitionFieldXMLDataContainer internalDefinitionFieldXMLDataContainer : internalDefinitionXMLDataContainer.fields) {
                OptionSpecification.Builder builder3 = OptionSpecification.builder();
                builder3.setName(internalDefinitionFieldXMLDataContainer.name);
                builder3.setBitPosition(internalDefinitionFieldXMLDataContainer.value);
                builder.addOptions(builder3.build());
            }
            this.jg.addDataTypeSpecification(builder.build());
            return;
        }
        logger.warn("Unknown parent spec type: {}, for node, name: {}, id: {}", new Object[]{uaDataTypeSpecification, nodeData.getBrowseName(), nodeData.getNodeId()});
    }

    private void h(UaNodeSet.NodeData nodeData) {
        InternalDefinitionXMLDataContainer internalDefinitionXMLDataContainer = (InternalDefinitionXMLDataContainer)nodeData.get(InternalUaNodeSetNodeManagerUaNodeParser.internal());
        if (internalDefinitionXMLDataContainer == null) {
            logger.error("OptionSets Structures without <Definition> not yet supported, {}, id: {}", (Object)nodeData.getBrowseName(), (Object)nodeData.getNodeId());
            return;
        }
        OptionSetStructureSpecification.Builder<OptionSetStructure.Builder> builder = OptionSetStructureSpecification.builder();
        builder.setTypeId(nodeData.getNodeId());
        builder.setName(nodeData.getBrowseName().getName());
        builder.setBaseTypeId(UaIds.OptionSet);
        builder.setJavaClass((Class)DynamicOptionSetStructure.class);
        builder.setBinaryEncodeId(this.jm.get(nodeData.getNodeId()));
        builder.setXmlEncodeId(this.jn.get(nodeData.getNodeId()));
        builder.setJsonEncodeId(this.jo.get(nodeData.getNodeId()));
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.addField(OptionSet.Fields.Value.getSpecification());
        builder.addField(OptionSet.Fields.ValidBits.getSpecification());
        for (InternalDefinitionFieldXMLDataContainer internalDefinitionFieldXMLDataContainer : internalDefinitionXMLDataContainer.fields) {
            OptionSpecification.Builder builder2 = OptionSpecification.builder();
            builder2.setName(internalDefinitionFieldXMLDataContainer.name);
            builder2.setBitPosition(internalDefinitionFieldXMLDataContainer.value);
            builder.addOptions(builder2.build());
        }
        logger.debug("Resolved OptionSetStructure: {}, id: {}", (Object)nodeData.getBrowseName(), (Object)nodeData.getNodeId());
        this.jg.addDataTypeSpecification(builder.build());
    }

    private void i(UaNodeSet.NodeData nodeData) {
        Optional<SimpleTypeSpecification> optional = this.f(nodeData.getNodeId()).filter(uaDataTypeSpecification -> uaDataTypeSpecification instanceof SimpleTypeSpecification).map(uaDataTypeSpecification -> (SimpleTypeSpecification)SimpleTypeSpecification.class.cast(uaDataTypeSpecification));
        if (!optional.isPresent()) {
            logger.error("Cannot resolve parent SimpleTypeSpecification for node, name: {}, id: {}", (Object)nodeData.getBrowseName(), (Object)nodeData.getNodeId());
            return;
        }
        SimpleTypeSpecification.Builder builder = SimpleTypeSpecification.builder();
        builder.setTypeId(nodeData.getNodeId());
        builder.setName(nodeData.getBrowseName().getName());
        builder.setBaseTypeId(optional.get().getBaseTypeId());
        builder.setJavaClass(optional.get().getJavaClass());
        logger.debug("Resolved SimpleType: {}, id: {}", (Object)nodeData.getBrowseName(), (Object)nodeData.getNodeId());
        this.jg.addDataTypeSpecification(builder.build());
    }

    private void ckb() {
        this.jh.stream().flatMap(uaNodeSet -> uaNodeSet.getNodes().stream()).filter(nodeData -> nodeData.getNodeClass() == NodeClass.Object).forEach(nodeData -> {
            if (jd.equals(nodeData.getBrowseName())) {
                this.jj.add(nodeData.getNodeId());
            } else if (je.equals(nodeData.getBrowseName())) {
                this.jk.add(nodeData.getNodeId());
            } else if (jf.equals(nodeData.getBrowseName())) {
                this.jl.add(nodeData.getNodeId());
            }
        });
        this.jh.stream().flatMap(uaNodeSet -> uaNodeSet.getReferences().stream()).filter(referenceData -> UaReferenceTypeIds.HasEncoding.equals(referenceData.getReferenceType())).forEach(referenceData -> {
            UaNodeId uaNodeId;
            UaNodeId uaNodeId2 = referenceData.isForward() ? referenceData.getReferenceSource() : referenceData.getReferenceTarget();
            UaNodeId uaNodeId3 = uaNodeId = referenceData.isForward() ? referenceData.getReferenceTarget() : referenceData.getReferenceSource();
            if (this.jj.contains(uaNodeId)) {
                this.jm.put(uaNodeId2, uaNodeId);
            } else if (this.jk.contains(uaNodeId)) {
                this.jn.put(uaNodeId2, uaNodeId);
            } else if (this.jl.contains(uaNodeId)) {
                this.jo.put(uaNodeId2, uaNodeId);
            }
        });
    }

    private void ckc() {
        this.jh.stream().flatMap(uaNodeSet -> uaNodeSet.getReferences().stream()).filter(referenceData -> UaReferenceTypeIds.HasSubtype.equals(referenceData.getReferenceType())).forEach(referenceData -> {
            if (this.ji.contains(referenceData.getReferenceSource())) {
                if (referenceData.isForward()) {
                    this.jq.put(referenceData.getReferenceSource(), referenceData.getReferenceTarget());
                    this.jp.put(referenceData.getReferenceTarget(), referenceData.getReferenceSource());
                } else {
                    this.jq.put(referenceData.getReferenceTarget(), referenceData.getReferenceSource());
                    this.jp.put(referenceData.getReferenceSource(), referenceData.getReferenceTarget());
                }
            }
        });
    }

    private void ckd() {
        this.jr.forEach(nodeData -> this.f((UaNodeSet.NodeData)nodeData));
        this.jv.forEach(nodeData -> this.i((UaNodeSet.NodeData)nodeData));
        this.ju.forEach(nodeData -> this.g((UaNodeSet.NodeData)nodeData));
        this.jt.forEach(nodeData -> this.h((UaNodeSet.NodeData)nodeData));
        logger.debug("Trying to resolve {} unknown Structure DataTypes: {}", (Object)this.js.size(), (Object)this.js.stream().map(nodeData -> nodeData.getNodeId()).toArray());
        int n2 = 0;
        while (n2 != this.js.size()) {
            n2 = this.js.size();
            this.js.forEach(nodeData -> {
                if (this.j((UaNodeSet.NodeData)nodeData)) {
                    this.js.remove(nodeData);
                }
            });
        }
        logger.debug("number of unresolved datatypes: {}, datatypes: {}", (Object)this.js.size(), (Object)this.js.stream().map(nodeData -> nodeData.getNodeId()).toArray());
    }

    private boolean j(UaNodeSet.NodeData nodeData2) {
        Optional<InternalDefinitionXMLDataContainer> optional = Optional.ofNullable((InternalDefinitionXMLDataContainer)nodeData2.get(InternalUaNodeSetNodeManagerUaNodeParser.internal()));
        UaNodeId uaNodeId3 = this.jp.get(nodeData2.getNodeId());
        if (uaNodeId3 == null) {
            logger.trace("Encountered a Structure type that doesn't have a parent via references, id: {}, name: {}", (Object)nodeData2.getNodeId(), (Object)nodeData2.getBrowseName());
            return false;
        }
        if (!UaIds.Structure.equals(uaNodeId3) && !this.jg.getDataTypeSpecifications().containsKey(uaNodeId3)) {
            logger.trace("Skipping {} as it's parent type {} is not yet resolved", (Object)nodeData2.getNodeId(), (Object)uaNodeId3);
            if (!this.js.stream().map(nodeData -> nodeData.getNodeId()).anyMatch(uaNodeId2 -> uaNodeId3.equals(uaNodeId2))) {
                logger.trace("^ The yet-not-processed structure types do not contain the parent");
            }
            return false;
        }
        StructureSpecification structureSpecification = this.jg.getStructureSpecification(uaNodeId3);
        StructureSpecification.Builder<Structure.Builder> builder = StructureSpecification.builder();
        builder.setTypeId(nodeData2.getNodeId());
        builder.setName(nodeData2.getBrowseName().getName());
        builder.setBinaryEncodeId(this.jm.get(nodeData2.getNodeId()));
        builder.setXmlEncodeId(this.jn.get(nodeData2.getNodeId()));
        builder.setJsonEncodeId(this.jo.get(nodeData2.getNodeId()));
        if (structureSpecification != null) {
            structureSpecification.getFields().forEach(fieldSpecification -> builder.addField((FieldSpecification)fieldSpecification));
        }
        if (optional.isPresent()) {
            for (InternalDefinitionFieldXMLDataContainer object2 : optional.get().fields) {
                FieldSpecification.Builder bl = FieldSpecification.builder();
                bl.setDataTypeId(object2.dataType);
                bl.setIsOptional(object2.isOptional);
                bl.setAllowSubTypes(object2.allowSubTypes);
                bl.setValueRank(object2.valueRank);
                bl.setName(object2.name);
                bl.setArrayDimensions(object2.arrayDimensions);
                Class bl2 = null;
                if (UaIds.Structure.equals(object2.dataType)) {
                    bl2 = ExtensionObject.class;
                } else if (UaIds.Enumeration.equals(object2.dataType)) {
                    bl2 = Enumeration.class;
                } else {
                    bl2 = Optional.ofNullable(this.jg.getDataTypeSpecification(object2.dataType)).map(uaDataTypeSpecification -> uaDataTypeSpecification.getJavaClass()).orElse(null);
                    if (bl2 == null) {
                        if (this.js.stream().map(nodeData -> nodeData.getNodeId()).anyMatch(uaNodeId -> internalDefinitionFieldXMLDataContainer.dataType.equals(uaNodeId))) {
                            bl2 = DynamicStructure.class;
                        } else {
                            logger.debug("Cannot resolve the Java Class for type: {}", (Object)object2.dataType);
                            return false;
                        }
                    }
                    if (object2.allowSubTypes) {
                        bl2 = Structure.class.isAssignableFrom(bl2) ? ExtensionObject.class : Object.class;
                    }
                }
                if (object2.valueRank > 0) {
                    bl2 = MultiDimensionArrayUtils.arrayClassOf(bl2, object2.valueRank);
                }
                bl.setJavaClass(bl2);
                builder.addField(bl.build());
            }
        }
        if (structureSpecification != null) {
            builder.setStructureType(structureSpecification.getStructureType());
        } else {
            builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        }
        StructureSpecification structureSpecification2 = builder.build();
        StructureSpecification.Builder builder2 = structureSpecification2.toBuilder();
        boolean bl = false;
        boolean bl2 = false;
        for (FieldSpecification fieldSpecification2 : structureSpecification2.getFields()) {
            if (fieldSpecification2.isOptional()) {
                bl = true;
                break;
            }
            if (!fieldSpecification2.isAllowSubTypes()) continue;
            bl2 = true;
            break;
        }
        if (optional.isPresent() && optional.get().isUnion) {
            if (bl2) {
                builder2.setStructureType(StructureSpecification.StructureType.UNION_SUBTYPES);
            } else {
                builder2.setStructureType(StructureSpecification.StructureType.UNION);
            }
        } else if (bl) {
            builder2.setStructureType(StructureSpecification.StructureType.OPTIONAL);
        } else if (bl2) {
            builder2.setStructureType(StructureSpecification.StructureType.SUBTYPES);
        } else {
            builder2.setStructureType(StructureSpecification.StructureType.NORMAL);
        }
        logger.debug("Resolved Structure: {}, id: {}", (Object)nodeData2.getBrowseName(), (Object)nodeData2.getNodeId());
        this.jg.addDataTypeSpecification(builder2.build());
        return true;
    }

    Set<AddNodesItem> cke() {
        return Collections.unmodifiableSet(this.jw);
    }

    Set<AddReferencesItem> ckf() {
        return Collections.unmodifiableSet(this.jx);
    }

    a ckg() {
        this.cka();
        this.ckb();
        this.ckc();
        this.cjZ();
        this.ckd();
        this.cjY();
        this.jh.forEach(uaNodeSet -> uaNodeSet.nodesToAddNodesItem(this.jg).forEach(addNodesItem -> this.jw.add((AddNodesItem)addNodesItem)));
        this.jh.forEach(uaNodeSet -> uaNodeSet.referencesToAddReferencesItem(this.jg).forEach(addReferencesItem -> this.jx.add((AddReferencesItem)addReferencesItem)));
        logger.debug("Resolved {} AddNodesItems and {} AddReferencesItems", (Object)this.jw.size(), (Object)this.jx.size());
        return new a(this.jy, this.jw, this.jx);
    }

    static class com.prosysopc.ua.server.a$a {
        private final AddNodesItem[] jz;
        private final AddReferencesItem[] jA;
        private final UaNodeSetLoadOptions jy;

        com.prosysopc.ua.server.a$a(UaNodeSetLoadOptions uaNodeSetLoadOptions, AddNodesItem[] addNodesItemArray, AddReferencesItem[] addReferencesItemArray) {
            this.jy = uaNodeSetLoadOptions;
            this.jz = StructureUtils.clone(addNodesItemArray);
            this.jA = StructureUtils.clone(addReferencesItemArray);
        }

        com.prosysopc.ua.server.a$a(UaNodeSetLoadOptions uaNodeSetLoadOptions, Set<AddNodesItem> set, Set<AddReferencesItem> set2) {
            this.jy = uaNodeSetLoadOptions;
            this.jz = set.toArray(new AddNodesItem[0]);
            this.jA = set2.toArray(new AddReferencesItem[0]);
        }

        void a(AddNodesItem addNodesItem, NodeManagerTable nodeManagerTable) throws StatusException {
            try {
                NodeId nodeId = this.c(addNodesItem, nodeManagerTable);
                if (!nodeId.getValue().equals(addNodesItem.getRequestedNewNodeId().getValue())) {
                    logger.warn("addNode: {} requested NodeId={} actual NodeId={}", new Object[]{addNodesItem.getBrowseName(), addNodesItem.getRequestedNewNodeId(), nodeId});
                } else {
                    logger.debug("addNode:{} requested NodeId={}", (Object)addNodesItem.getBrowseName(), (Object)addNodesItem.getRequestedNewNodeId());
                }
            }
            catch (Exception exception) {
                if (this.jy.isIgnoreNodeAddExceptions()) {
                    logger.error("Failed to add node: {}", (Object)addNodesItem, (Object)exception);
                }
                if (exception instanceof StatusException) {
                    throw exception;
                }
                throw new StatusException(StatusCodes.Bad_InternalError, (Throwable)exception);
            }
        }

        void a(List<AddNodesItem> list, String string, NodeManagerTable nodeManagerTable) throws UaException {
            logger.debug("addNodes: {}", (Object)string);
            for (AddNodesItem addNodesItem : list) {
                this.a(addNodesItem, nodeManagerTable);
            }
        }

        void a(AddReferencesItem addReferencesItem, NodeManagerTable nodeManagerTable) throws StatusException {
            try {
                this.b(addReferencesItem, nodeManagerTable);
                if (logger.isDebugEnabled()) {
                    logger.debug("createModel: Adding refitem: " + addReferencesItem.getSourceNodeId() + " --> " + addReferencesItem.getTargetNodeId() + " forward:" + addReferencesItem.getIsForward() + " type: " + addReferencesItem.getReferenceTypeId());
                }
            }
            catch (Exception exception) {
                if (this.jy.isIgnoreReferenceAddExceptions()) {
                    logger.error("Failed to add reference: {}", (Object)addReferencesItem, (Object)exception);
                }
                if (exception instanceof StatusException) {
                    throw exception;
                }
                throw new StatusException(StatusCodes.Bad_InternalError, (Throwable)exception);
            }
        }

        void a(List<AddReferencesItem> list, NodeManagerTable nodeManagerTable) throws UaException {
            for (AddReferencesItem addReferencesItem : list) {
                this.a(addReferencesItem, nodeManagerTable);
            }
        }

        void b(AddNodesItem addNodesItem, NodeManagerTable nodeManagerTable) {
            if (!ModelParser.callAfterCreateForTopLevelNodes) {
                return;
            }
            try {
                UaReference[] uaReferenceArray;
                UaNode uaNode = nodeManagerTable.getNode(nodeManagerTable.getNamespaceTable().toNodeId(addNodesItem.getRequestedNewNodeId()));
                if (uaNode.getReference(Identifiers.HasModellingRule, false) != null) {
                    return;
                }
                if (uaNode instanceof GeneratedNode && ((uaReferenceArray = uaNode.getInverseReferences(Identifiers.Aggregates)) == null || uaReferenceArray.length == 0)) {
                    ((GeneratedNode)uaNode).afterCreate();
                }
            }
            catch (Exception exception) {
                logger.error("Could not call afterCreate for item {}", (Object)addNodesItem, (Object)exception);
            }
        }

        com.prosysopc.ua.server.a$a ckh() {
            return new com.prosysopc.ua.server.a$a(this.jy, this.jz, this.jA);
        }

        NodeId c(AddNodesItem addNodesItem, NodeManagerTable nodeManagerTable) throws StatusException {
            logger.debug("doAddNode: {}", (Object)addNodesItem);
            return nodeManagerTable.addNode(ServiceContext.INTERNAL_OPERATION_CONTEXT, addNodesItem);
        }

        void b(AddReferencesItem addReferencesItem, NodeManagerTable nodeManagerTable) throws StatusException {
            nodeManagerTable.addReference(ServiceContext.INTERNAL_OPERATION_CONTEXT, addReferencesItem);
        }

        void a(NodeManagerTable nodeManagerTable, boolean bl) throws UaException {
            List<AddReferencesItem> list;
            List<AddNodesItem> list2;
            if (bl) {
                list2 = Arrays.asList(this.jz).stream().map(addNodesItem -> StructureUtils.clone(addNodesItem)).collect(Collectors.toList());
                list = Arrays.asList(this.jA).stream().map(addReferencesItem -> StructureUtils.clone(addReferencesItem)).collect(Collectors.toList());
            } else {
                list2 = Arrays.asList(this.jz);
                list = Arrays.asList(this.jA);
            }
            ArrayList<AddNodesItem> arrayList = new ArrayList<AddNodesItem>();
            ArrayList<AddNodesItem> arrayList2 = new ArrayList<AddNodesItem>();
            ArrayList<AddNodesItem> arrayList3 = new ArrayList<AddNodesItem>();
            ArrayList<AddNodesItem> arrayList4 = new ArrayList<AddNodesItem>();
            ArrayList<AddNodesItem> arrayList5 = new ArrayList<AddNodesItem>();
            ArrayList<AddNodesItem> arrayList6 = new ArrayList<AddNodesItem>();
            ArrayList<AddNodesItem> arrayList7 = new ArrayList<AddNodesItem>();
            ArrayList<AddNodesItem> arrayList8 = new ArrayList<AddNodesItem>();
            block10: for (AddNodesItem addNodesItem2 : list2) {
                if (addNodesItem2.getNodeClass() == null) {
                    arrayList5.add(addNodesItem2);
                    continue;
                }
                switch (addNodesItem2.getNodeClass()) {
                    case ReferenceType: {
                        arrayList.add(addNodesItem2);
                        continue block10;
                    }
                    case DataType: {
                        arrayList2.add(addNodesItem2);
                        continue block10;
                    }
                    case Method: {
                        arrayList8.add(addNodesItem2);
                        continue block10;
                    }
                    case Object: {
                        arrayList3.add(addNodesItem2);
                        continue block10;
                    }
                    case ObjectType: {
                        arrayList6.add(addNodesItem2);
                        continue block10;
                    }
                    case Variable: {
                        arrayList4.add(addNodesItem2);
                        continue block10;
                    }
                    case VariableType: {
                        arrayList7.add(addNodesItem2);
                        continue block10;
                    }
                    case View: {
                        arrayList5.add(addNodesItem2);
                        continue block10;
                    }
                }
                logger.warn("Encountered unkown NodeClass: {}, ignoring node: {}", (Object)addNodesItem2.getNodeClass(), (Object)addNodesItem2.getRequestedNewNodeId());
            }
            this.a(arrayList, "ReferenceTypes", nodeManagerTable);
            this.a(arrayList2, "DataTypes", nodeManagerTable);
            this.a(arrayList6, "ObjectTypeNodes", nodeManagerTable);
            this.a(arrayList7, "VariableTypeNodes", nodeManagerTable);
            this.a(arrayList3, "ObjectNodes", nodeManagerTable);
            this.a(arrayList4, "VariableNodes", nodeManagerTable);
            this.a(arrayList5, "OtherNodes", nodeManagerTable);
            this.a(arrayList8, "MethodNodes", nodeManagerTable);
            this.a(new ArrayList<AddReferencesItem>(list), nodeManagerTable);
            for (AddNodesItem addNodesItem2 : arrayList3) {
                this.b(addNodesItem2, nodeManagerTable);
            }
        }

        void cki() {
            HashMap hashMap = new HashMap();
            HashMap hashMap2 = new HashMap();
            HashMap hashMap3 = new HashMap();
            Identifiers.allIdentifiers(true).forEach(nodeId -> hashMap.put(nodeId, nodeId));
            Ids.allIdentifiers(true).forEach(expandedNodeId -> hashMap2.put(expandedNodeId, expandedNodeId));
            HashMap hashMap4 = new HashMap();
            HashMap hashMap5 = new HashMap();
            HashMap hashMap6 = new HashMap();
            HashMap hashMap7 = new HashMap();
            HashMap hashMap8 = new HashMap();
            Arrays.asList(this.jz).forEach(addNodesItem -> {
                addNodesItem.setBrowseName(this.a(hashMap3, addNodesItem.getBrowseName()));
                addNodesItem.setRequestedNewNodeId(this.a(hashMap2, addNodesItem.getRequestedNewNodeId()));
                if (addNodesItem.getTypeDefinition() != null) {
                    addNodesItem.setTypeDefinition(this.a(hashMap2, addNodesItem.getTypeDefinition()));
                }
                GenericAttributes genericAttributes = (GenericAttributes)addNodesItem.getNodeAttributes().getObject();
                for (int i2 = 0; i2 < genericAttributes.getAttributeValues().length; ++i2) {
                    GenericAttributeValue genericAttributeValue = genericAttributes.getAttributeValues()[i2];
                    Object object = genericAttributeValue.getValue();
                    if (object instanceof NodeId) {
                        genericAttributeValue.setValue(this.a(hashMap, (NodeId)object));
                    } else if (object instanceof ExpandedNodeId) {
                        genericAttributeValue.setValue(this.a(hashMap2, (ExpandedNodeId)object));
                    } else if (object instanceof QualifiedName) {
                        genericAttributeValue.setValue(this.a(hashMap3, (QualifiedName)object));
                    } else if (object instanceof UnsignedInteger[]) {
                        genericAttributeValue.setValue(this.a(hashMap4, (UnsignedInteger[])object));
                    } else if (object instanceof Variant) {
                        genericAttributeValue.setValue(this.a(hashMap5, (Variant)object));
                    }
                    genericAttributes.getAttributeValues()[i2] = this.a(hashMap6, genericAttributeValue);
                }
                genericAttributes.setAttributeValues(this.a(hashMap8, genericAttributes.getAttributeValues()));
                addNodesItem.setNodeAttributes(this.a(hashMap7, addNodesItem.getNodeAttributes()));
            });
            Arrays.asList(this.jA).forEach(addReferencesItem -> {
                addReferencesItem.setReferenceTypeId(this.a(hashMap, addReferencesItem.getReferenceTypeId()));
                addReferencesItem.setSourceNodeId(this.a(hashMap, addReferencesItem.getSourceNodeId()));
                addReferencesItem.setTargetNodeId(this.a(hashMap2, addReferencesItem.getTargetNodeId()));
            });
        }

        ExtensionObject a(Map<Object, ExtensionObject> map, ExtensionObject extensionObject) {
            return map.computeIfAbsent(extensionObject.getObject(), object -> extensionObject);
        }

        GenericAttributeValue[] a(Map<a, GenericAttributeValue[]> map, GenericAttributeValue[] genericAttributeValueArray) {
            return map.computeIfAbsent(new a(genericAttributeValueArray), a2 -> genericAttributeValueArray);
        }

        UnsignedInteger[] a(Map<UaArrayDimensions, UnsignedInteger[]> map, UnsignedInteger[] unsignedIntegerArray) {
            return map.computeIfAbsent(UaArrayDimensions.valueOf(unsignedIntegerArray), uaArrayDimensions -> unsignedIntegerArray);
        }

        ExpandedNodeId a(Map<ExpandedNodeId, ExpandedNodeId> map, ExpandedNodeId expandedNodeId) {
            return map.computeIfAbsent(expandedNodeId, expandedNodeId2 -> expandedNodeId);
        }

        GenericAttributeValue a(Map<GenericAttributeValue, GenericAttributeValue> map, GenericAttributeValue genericAttributeValue) {
            return map.computeIfAbsent(genericAttributeValue, genericAttributeValue2 -> genericAttributeValue);
        }

        NodeId a(Map<NodeId, NodeId> map, NodeId nodeId) {
            return map.computeIfAbsent(nodeId, nodeId2 -> nodeId);
        }

        QualifiedName a(Map<QualifiedName, QualifiedName> map, QualifiedName qualifiedName) {
            return map.computeIfAbsent(qualifiedName, qualifiedName2 -> qualifiedName);
        }

        Variant a(Map<Variant, Variant> map, Variant variant) {
            return map.computeIfAbsent(variant, variant2 -> variant);
        }

        private static class a {
            private final Object[] data;

            a(Object[] objectArray) {
                this.data = objectArray;
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (!(object instanceof a)) {
                    return false;
                }
                a a2 = (a)object;
                return Arrays.deepEquals(this.data, a2.data);
            }

            public int hashCode() {
                int n2 = 31;
                int n3 = 1;
                n3 = 31 * n3 + Arrays.deepHashCode(this.data);
                return n3;
            }
        }
    }
}

