/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.ApplicationIdentity;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.server.AbstractContinuationPoint;
import com.prosysopc.ua.server.BrowseContinuationPoint;
import com.prosysopc.ua.server.DiagnosticsManager;
import com.prosysopc.ua.server.HistoryContinuationPoint;
import com.prosysopc.ua.server.ServerUserIdentity;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.server.SessionDiagnostics;
import com.prosysopc.ua.server.SessionListener;
import com.prosysopc.ua.server.SessionManager;
import com.prosysopc.ua.server.SessionSecurityDiagnostics;
import com.prosysopc.ua.server.Subscription;
import com.prosysopc.ua.server.UaServer;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.ServiceRequest;
import com.prosysopc.ua.stack.builtintypes.ServiceResponse;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.core.IdType;
import com.prosysopc.ua.stack.core.PublishRequest;
import com.prosysopc.ua.stack.core.PublishResponse;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.transport.ServerSecureChannel;
import com.prosysopc.ua.stack.transport.UriUtil;
import com.prosysopc.ua.stack.transport.security.Cert;
import com.prosysopc.ua.stack.transport.security.SecurityMode;
import com.prosysopc.ua.stack.transport.tcp.nio.OpcTcpServerSecureChannel;
import com.prosysopc.ua.stack.utils.CryptoUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Session {
    public static final Session INTERNAL_SESSION = new Session();
    private static long mq = 10000L;
    static final Logger logger = LoggerFactory.getLogger(Session.class);
    private volatile boolean active = false;
    private volatile boolean closed = false;
    private final NodeId mr;
    private final Map<Long, BrowseContinuationPoint> ms = new ConcurrentSkipListMap<Long, BrowseContinuationPoint>();
    private volatile ServerSecureChannel mt;
    private final ApplicationIdentity mu;
    private final SessionDiagnostics mv;
    private final SessionSecurityDiagnostics mw;
    private final Map<Long, HistoryContinuationPoint> mx = new ConcurrentSkipListMap<Long, HistoryContinuationPoint>();
    private volatile long my = 0L;
    private volatile long mz;
    private final List<Locale> mA = new CopyOnWriteArrayList<Locale>();
    private volatile ByteString mB;
    private volatile SessionManager sessionManager;
    private volatile double mC;
    private final List<Subscription> hd = new CopyOnWriteArrayList<Subscription>();
    private final Queue<Subscription> mD = new ConcurrentLinkedQueue<Subscription>();
    private ServerUserIdentity mE = null;
    protected List<SessionListener> listeners = new CopyOnWriteArrayList<SessionListener>();
    private final SecurityMode gL;

    public static long getActivationTimeout() {
        return mq;
    }

    public static void setActivationTimeout(long l2) {
        mq = l2;
    }

    private static NodeId ckV() {
        byte[] byArray = new byte[32];
        CryptoUtil.getRandom().nextBytes(byArray);
        return NodeId.get(IdType.Opaque, 0, ByteString.valueOf(byArray));
    }

    private Session() {
        this.sessionManager = null;
        this.mv = null;
        this.mw = null;
        this.mu = null;
        this.mr = null;
        this.gL = SecurityMode.NONE;
        this.active = true;
    }

    protected Session(SessionManager sessionManager, ApplicationIdentity applicationIdentity, String string, SecurityMode securityMode) {
        this.gL = securityMode;
        this.sessionManager = sessionManager;
        UaServer.NodeManagerUaServer nodeManagerUaServer = sessionManager.getServer().getNodeManagerUaServer();
        NodeId nodeId = NodeId.randomGUID(nodeManagerUaServer.getNamespaceIndex());
        if (string == null) {
            string = "ServerAssigned " + nodeId;
        }
        String string2 = null;
        DateTime dateTime = DateTime.currentTime();
        String string3 = null;
        String[] stringArray = null;
        DateTime dateTime2 = dateTime;
        Double d2 = null;
        UnsignedInteger unsignedInteger = null;
        this.mv = new SessionDiagnostics(nodeId, string, applicationIdentity.getApplicationDescription(), string2, string3, stringArray, d2, unsignedInteger, dateTime, dateTime2);
        Cert cert = applicationIdentity.getCertificate();
        ByteString byteString = cert != null ? ByteString.valueOf(cert.getEncoded()) : null;
        String string4 = null;
        String[] stringArray2 = new String[]{};
        String string5 = null;
        String string6 = null;
        String string7 = null;
        this.mw = new SessionSecurityDiagnostics(nodeId, string4, stringArray2, string5, string6, string7, securityMode.getMessageSecurityMode(), securityMode.getSecurityPolicy().getPolicyUri(), byteString);
        this.mu = applicationIdentity;
        this.mr = Session.ckV();
        this.mz = System.currentTimeMillis();
    }

    public void addSessionListener(SessionListener sessionListener) {
        if (!this.listeners.contains(sessionListener)) {
            this.listeners.add(sessionListener);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Session session = (Session)object;
        if (this.mr == null ? session.mr != null : !this.mr.equals(session.mr)) {
            return false;
        }
        return !(this.getSessionId() == null ? session.getSessionId() != null : !this.getSessionId().equals(session.getSessionId()));
    }

    public NodeId getAuthenticationToken() {
        return this.mr;
    }

    public ServerSecureChannel getChannel() {
        return this.mt;
    }

    public ApplicationIdentity getClientIdentity() {
        return this.mu;
    }

    public DateTime getClientLastContactTime() {
        return this.mv.clj().get();
    }

    public Locale getDefaultLocale() {
        if (this.mA == null || this.mA.isEmpty()) {
            return Locale.ENGLISH;
        }
        return this.mA.get(0);
    }

    public List<Locale> getLocales() {
        return Collections.unmodifiableList(this.mA);
    }

    public UnsignedInteger getMaxResponseMessageSize() {
        return this.mv.clx().get();
    }

    public SecurityMode getSecurityMode() {
        return this.gL;
    }

    public SessionDiagnostics getSessionDiagnostics() {
        return this.mv;
    }

    public NodeId getSessionId() {
        return this.mv == null ? null : this.mv.getSessionId();
    }

    public String getSessionName() {
        return this.mv == null ? "INTERNAL_SESSION" : this.mv.clH().get();
    }

    public SessionSecurityDiagnostics getSessionSecurityDiagnostics() {
        return this.mw;
    }

    public double getSessionTimeout() {
        return this.mC;
    }

    public int getSubscriptionCount() {
        return this.hd.size();
    }

    public ServerUserIdentity getUserIdentity() {
        return this.mE;
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.mr == null ? 0 : this.mr.hashCode());
        n3 = 31 * n3;
        if (this.mv != null) {
            n3 += this.getSessionId().hashCode();
        }
        return n3;
    }

    public boolean hasLocale(Locale locale) {
        return this.mA.contains(locale);
    }

    public boolean hasSessionListener(SessionListener sessionListener) {
        return this.listeners.contains(sessionListener);
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isTimeout() {
        long l2 = System.currentTimeMillis() - this.mz;
        double d2 = this.isActive() ? this.mC : (double)mq;
        logger.trace("isTimeout: timeout={} delay={}", (Object)d2, (Object)l2);
        return (double)l2 > d2;
    }

    public void removeSessionListener(SessionListener sessionListener) {
        this.listeners.remove(sessionListener);
    }

    public String toString() {
        return String.format(Locale.ROOT, "%s (ID=%s Token=%s Channel=(%s))", this.getSessionName(), this.getSessionId(), this.getAuthenticationToken(), this.getChannel());
    }

    private Long c(ByteString byteString) throws StatusException {
        Long l2;
        if (byteString == null) {
            throw new StatusException("null", StatusCodes.Bad_ContinuationPointInvalid);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteString.getValue());
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        try {
            l2 = dataInputStream.readLong();
        }
        catch (IOException iOException) {
            throw new StatusException("Too short array: " + byteString, StatusCodes.Bad_ContinuationPointInvalid);
        }
        return l2;
    }

    private void ckW() {
        for (SessionListener sessionListener : this.listeners) {
            try {
                sessionListener.onSessionActivated(this);
            }
            catch (Exception exception) {
                logger.warn("Exception in SessionListener, onSessionActivated:", (Throwable)exception);
            }
        }
    }

    private void ckX() {
        for (SessionListener sessionListener : this.listeners) {
            try {
                sessionListener.onSessionChanged(this);
            }
            catch (Exception exception) {
                logger.warn("Exception in SessionListener, onSessionChanged:", (Throwable)exception);
            }
        }
    }

    private void ckY() {
        for (SessionListener sessionListener : this.listeners) {
            try {
                sessionListener.onSessionClosed(this);
            }
            catch (Exception exception) {
                logger.warn("Exception in SessionListener, onSessionClosed:", (Throwable)exception);
            }
        }
    }

    private AbstractContinuationPoint a(ByteString byteString, Map<Long, ? extends AbstractContinuationPoint> map) throws StatusException {
        Long l2 = this.c(byteString);
        AbstractContinuationPoint abstractContinuationPoint = map.remove(l2);
        logger.debug("getContinuationPoint: i={} result={}", (Object)l2, (Object)abstractContinuationPoint);
        if (abstractContinuationPoint == null) {
            throw new StatusException("Not found: " + byteString, StatusCodes.Bad_ContinuationPointInvalid);
        }
        return abstractContinuationPoint;
    }

    private DiagnosticsManager getDiagnosticsManager() {
        SessionManager sessionManager = this.getSessionManager();
        return sessionManager == null ? null : sessionManager.getServer().getDiagnosticsManager();
    }

    private boolean isDiagnosticsEnabled() {
        DiagnosticsManager diagnosticsManager = this.getDiagnosticsManager();
        return diagnosticsManager == null ? false : diagnosticsManager.isEnabled();
    }

    private boolean isInternal() {
        return this == INTERNAL_SESSION;
    }

    private ByteString a(Long l2) throws StatusException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeLong(l2);
            dataOutputStream.flush();
        }
        catch (IOException iOException) {
            throw new StatusException("Cannot create long");
        }
        return ByteString.valueOf(byteArrayOutputStream.toByteArray());
    }

    private synchronized long ckZ() {
        return ++this.my;
    }

    private void a(ServiceContext serviceContext, Map<Long, ? extends AbstractContinuationPoint> map, int n2) throws StatusException {
        if (n2 == 0) {
            return;
        }
        Iterator<? extends AbstractContinuationPoint> iterator = map.values().iterator();
        try {
            while (map.size() >= n2) {
                AbstractContinuationPoint abstractContinuationPoint = iterator.next();
                if (abstractContinuationPoint.getServiceContext().equals(serviceContext)) continue;
                iterator.remove();
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new StatusException(StatusCodes.Bad_NoContinuationPoints);
        }
    }

    protected void activate(ServerUserIdentity serverUserIdentity) {
        this.mE = serverUserIdentity;
        this.active = true;
        logger.debug("ServerUserIdentity: {}", (Object)serverUserIdentity);
        if (serverUserIdentity != null) {
            this.mw.clX().set(serverUserIdentity.getType().name());
            if (serverUserIdentity.getName() != null && serverUserIdentity.getName().length() > 0) {
                this.mw.clY().add(serverUserIdentity.getName());
            }
            this.mw.clZ().set(serverUserIdentity.getName());
        }
        this.ckW();
    }

    protected ByteString addBrowseContinuationPoint(BrowseContinuationPoint browseContinuationPoint) throws StatusException {
        Object object;
        int n2;
        if (this.isInternal()) {
            n2 = Integer.MAX_VALUE;
        } else {
            object = this.getSessionManager();
            if (object == null) {
                throw new StatusException(StatusCodes.Bad_SessionClosed);
            }
            n2 = ((SessionManager)object).getMaxBrowseContinuationPoints();
        }
        this.a(browseContinuationPoint.getServiceContext(), this.ms, n2);
        object = this.ckZ();
        logger.debug("addContinuationPoint: i={}", object);
        this.ms.put((Long)object, browseContinuationPoint);
        this.ckX();
        return this.a((Long)object);
    }

    protected ByteString addHistoryContinuationPoint(HistoryContinuationPoint historyContinuationPoint) throws StatusException {
        int n2;
        if (this.isInternal()) {
            n2 = Integer.MAX_VALUE;
        } else {
            SessionManager sessionManager = this.getSessionManager();
            if (sessionManager == null) {
                throw new StatusException(StatusCodes.Bad_SessionClosed);
            }
            n2 = sessionManager.getMaxHistoryContinuationPoints();
        }
        this.a(historyContinuationPoint.getServiceContext(), this.mx, n2);
        long l2 = this.ckZ();
        this.mx.put(l2, historyContinuationPoint);
        this.ckX();
        return this.a(l2);
    }

    protected void addSubscription(Subscription subscription) {
        this.hd.add(subscription);
        this.ckX();
    }

    protected void cancel() {
    }

    protected void close(boolean bl) {
        logger.debug("close");
        this.ckY();
        this.listeners.clear();
        this.active = false;
        this.sessionManager = null;
        this.closed = true;
        this.ms.clear();
        this.mx.clear();
        ServerSecureChannel serverSecureChannel = this.getChannel();
        if (serverSecureChannel instanceof OpcTcpServerSecureChannel) {
            OpcTcpServerSecureChannel opcTcpServerSecureChannel = (OpcTcpServerSecureChannel)serverSecureChannel;
            opcTcpServerSecureChannel.getConnection().setActiveSession(false);
        }
    }

    protected void deactivate() {
        this.active = false;
        this.ckX();
    }

    protected BrowseContinuationPoint getBrowseContinuationPoint(ByteString byteString) throws StatusException {
        return (BrowseContinuationPoint)this.a(byteString, this.ms);
    }

    protected QualifiedName getDefaultEncoding() {
        return QualifiedName.DEFAULT_BINARY_ENCODING;
    }

    protected HistoryContinuationPoint getHistoryContinuationPoint(ByteString byteString) throws StatusException {
        return (HistoryContinuationPoint)this.a(byteString, this.mx);
    }

    protected ByteString getNewServerNonce(int n2) {
        this.mB = CryptoUtil.createNonce(n2);
        this.ckX();
        return this.mB;
    }

    protected ByteString getServerNonce() {
        return this.mB;
    }

    protected SessionManager getSessionManager() {
        return this.sessionManager;
    }

    protected Queue<Subscription> getTransferredSubscriptions() {
        return this.mD;
    }

    protected void removeSubscription(Subscription subscription) {
        this.hd.remove(subscription);
    }

    protected void resetDiagnostics() {
        this.mv.clR();
        this.ckX();
    }

    protected void setChannel(ServerSecureChannel serverSecureChannel) {
        Object object;
        ServerSecureChannel serverSecureChannel2 = this.mt;
        if (serverSecureChannel2 != null && serverSecureChannel2 instanceof OpcTcpServerSecureChannel) {
            object = (OpcTcpServerSecureChannel)serverSecureChannel2;
            ((OpcTcpServerSecureChannel)object).getConnection().setActiveSession(false);
        }
        this.mt = serverSecureChannel;
        logger.trace("setChannel: serverSecureChannel=" + (serverSecureChannel == null ? "null" : serverSecureChannel));
        if (serverSecureChannel != null) {
            object = serverSecureChannel.getEndpoint().getEndpointUrl();
            this.mv.clt().set((String)object);
            this.mw.cma().set("UA Binary");
            this.mw.cmd().set(UriUtil.getTransportProtocol((String)object).toLowerCase(Locale.ROOT));
            this.mw.cmb().set(serverSecureChannel.getMessageSecurityMode());
            this.mw.cmc().set(serverSecureChannel.getSecurityPolicy().getPolicyUri());
        }
        this.ckX();
    }

    protected void setLocaleIds(String[] stringArray) {
        if (stringArray != null) {
            this.mA.clear();
            for (String string : stringArray) {
                this.mA.add(LocalizedText.toLocale(string));
            }
        }
        this.mv.clw().set(stringArray);
        this.ckX();
    }

    protected void setMaxResponseMessageSize(UnsignedInteger unsignedInteger) {
        this.mv.clx().set(unsignedInteger);
        this.ckX();
    }

    protected void setSessionName(String string) {
        this.mv.clH().set(string);
        this.ckX();
    }

    protected void setSessionTimeout(double d2) {
        logger.debug("setSessionTimeout: {}", (Object)d2);
        this.mC = d2;
        this.mv.clb().set(this.mC);
        this.ckX();
    }

    protected void updateDiagnostics() {
        SessionManager sessionManager = this.getSessionManager();
        if (sessionManager != null) {
            sessionManager.getServer().getDiagnosticsManager().updateSession(this);
        }
    }

    List<Subscription> cla() {
        return this.hd;
    }

    void a(ServiceRequest serviceRequest) {
        this.mz = System.currentTimeMillis();
        if (this.isDiagnosticsEnabled()) {
            this.mv.clj().set(DateTime.currentTime());
            String string = serviceRequest.getClass().getName().replace("Request", "").replaceAll(".*[.]", "");
            SessionDiagnostics.ServiceCounter serviceCounter = this.mv.u(string);
            if (serviceCounter != null) {
                serviceCounter.clT();
            }
            this.mv.clL().clT();
            if (serviceRequest instanceof PublishRequest) {
                this.mv.cln().incrementAndGet();
            }
            this.updateDiagnostics();
        }
        this.ckX();
    }

    void a(ServiceResponse serviceResponse) {
        if (this.isDiagnosticsEnabled()) {
            StatusCode statusCode = serviceResponse.getResponseHeader().getServiceResult();
            if (statusCode.isBad()) {
                String string = serviceResponse.getClass().getName().replace("Response", "").replaceAll(".*[.]", "");
                SessionDiagnostics.ServiceCounter serviceCounter = this.mv.u(string);
                if (serviceCounter != null) {
                    serviceCounter.clS();
                }
                this.mv.clL().clS();
                if (statusCode.getValue().equals(StatusCodes.Bad_UserAccessDenied)) {
                    this.mv.clO().incrementAndGet();
                }
            }
            if (serviceResponse instanceof PublishResponse) {
                this.mv.cln().decrementAndGet();
            }
            this.updateDiagnostics();
            this.ckX();
        }
    }
}

