/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.InternalArguments;
import com.prosysopc.ua.server.ReverseConnectionStatus;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Consumer;
import java.util.function.Function;

public final class ReverseConnectionParameters {
    private final String lM;
    private final String lN;
    private final Function<List<String>, String> lO;
    private final List<Integer> lP;
    private final Executor lQ;
    private final Consumer<ReverseConnectionStatus> lR;

    public static Builder builder() {
        return new Builder();
    }

    public static ReverseConnectionParameters from(String string, String string2) {
        Builder builder = ReverseConnectionParameters.builder();
        builder.setClientServerEndpointUrl(string);
        builder.setEndpointUrlForClientConnection(string2);
        return builder.build();
    }

    private ReverseConnectionParameters(String string, String string2, List<Integer> list, Executor executor, Consumer<ReverseConnectionStatus> consumer, Function<List<String>, String> function) {
        this.lM = string;
        this.lN = string2;
        this.lP = Collections.unmodifiableList(new ArrayList<Integer>(list));
        this.lQ = executor;
        this.lR = consumer;
        this.lO = function;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ReverseConnectionParameters)) {
            return false;
        }
        ReverseConnectionParameters reverseConnectionParameters = (ReverseConnectionParameters)object;
        return Objects.equals(this.lM, reverseConnectionParameters.lM);
    }

    public String getClientServerEndpointUrl() {
        return this.lM;
    }

    public String getEndpointUrlForClientConnection() {
        return this.lN;
    }

    public Function<List<String>, String> getEndpointUrlForClientConnectionSelector() {
        return this.lO;
    }

    public List<Integer> getRetryWaitIntervals() {
        return this.lP;
    }

    public int hashCode() {
        return Objects.hash(this.lM);
    }

    public void internalFireStatusNotification(ReverseConnectionStatus reverseConnectionStatus) {
        if (this.lQ == null || this.lR == null) {
            return;
        }
        try {
            this.lQ.execute(() -> this.lR.accept(reverseConnectionStatus));
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    public Builder toBuilder() {
        Builder builder = ReverseConnectionParameters.builder();
        builder.setClientServerEndpointUrl(this.lM);
        builder.setEndpointUrlForClientConnection(this.lN);
        builder.setStatusListener(this.lQ, this.lR);
        builder.setEndpointUrlForClientConnectionSelector(this.lO);
        builder.getRetryWaitIntervals().clear();
        builder.getRetryWaitIntervals().addAll(this.getRetryWaitIntervals());
        return builder;
    }

    public String toString() {
        return "ReverseConnectionParameters [clientServerEndpointUrl=" + this.lM + ", endpointUrlForClientConnection=" + this.lN + ", retryWaitIntervals=" + this.lP + "]";
    }

    public static class Builder {
        private String lM;
        private String lN;
        private final List<Integer> lP;
        private Executor lQ;
        private Consumer<ReverseConnectionStatus> lR;
        private Function<List<String>, String> lO = list -> (String)list.get(0);

        private Builder() {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            arrayList.add(100);
            arrayList.add(500);
            arrayList.add(1000);
            this.lP = arrayList;
        }

        public ReverseConnectionParameters build() {
            return new ReverseConnectionParameters(this.lM, this.lN, this.lP, this.lQ, this.lR, this.lO);
        }

        public String getClientServerEndpointUrl() {
            return this.lM;
        }

        public String getEndpointUrlForClientConnection() {
            return this.lN;
        }

        public Function<List<String>, String> getEndpointUrlForClientConnectionSelector() {
            return this.lO;
        }

        public List<Integer> getRetryWaitIntervals() {
            return this.lP;
        }

        public Builder setClientServerEndpointUrl(String string) {
            this.lM = string;
            return this;
        }

        public Builder setEndpointUrlForClientConnection(String string) {
            this.lN = string;
            return this;
        }

        public void setEndpointUrlForClientConnectionSelector(Function<List<String>, String> function) {
            InternalArguments.checkNotNull(function, "endpointUrlForClientConnectionSelector");
            this.lO = function;
        }

        public Builder setStatusListener(Executor executor, Consumer<ReverseConnectionStatus> consumer) {
            this.lQ = executor;
            this.lR = consumer;
            return this;
        }
    }
}

