/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.AnnotationException;
import com.prosysopc.ua.AnnotationUtils;
import com.prosysopc.ua.InternalUaNodeSetNodeManagerUaNodeParser;
import com.prosysopc.ua.NodeMap;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.UaNodeSet;
import com.prosysopc.ua.nodes.UaDataType;
import com.prosysopc.ua.nodes.UaInstance;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaNodeFactory;
import com.prosysopc.ua.nodes.UaNodeFactoryException;
import com.prosysopc.ua.nodes.UaObject;
import com.prosysopc.ua.nodes.UaReference;
import com.prosysopc.ua.nodes.UaReferenceType;
import com.prosysopc.ua.nodes.UaType;
import com.prosysopc.ua.nodes.UaValueNode;
import com.prosysopc.ua.nodes.UaVariable;
import com.prosysopc.ua.server.EventManagerUaNode;
import com.prosysopc.ua.server.HistoryManager;
import com.prosysopc.ua.server.InvalidTypeNodeException;
import com.prosysopc.ua.server.IoManagerUaNode;
import com.prosysopc.ua.server.MethodManagerUaNode;
import com.prosysopc.ua.server.ModelChangeType;
import com.prosysopc.ua.server.NodeBuilderException;
import com.prosysopc.ua.server.NodeManager;
import com.prosysopc.ua.server.NodeMapUaNode;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.server.Subscription;
import com.prosysopc.ua.server.UaInstantiationException;
import com.prosysopc.ua.server.UaServer;
import com.prosysopc.ua.server.instantiation.NodeBuilder;
import com.prosysopc.ua.server.instantiation.UaNodeBuilderConfiguration;
import com.prosysopc.ua.server.nodes.UaExternalNode;
import com.prosysopc.ua.server.nodes.UaServerNodeFactory;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.AggregateFilterResult;
import com.prosysopc.ua.stack.core.IdType;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.stack.core.MonitoringFilter;
import com.prosysopc.ua.stack.core.MonitoringMode;
import com.prosysopc.ua.stack.core.MonitoringParameters;
import com.prosysopc.ua.stack.core.NodeAttributes;
import com.prosysopc.ua.stack.core.NodeClass;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.utils.NumericRange;
import com.prosysopc.ua.types.opcua.BaseEventType;
import com.prosysopc.ua.types.opcua.FolderType;
import com.prosysopc.ua.types.opcua.server.FolderTypeNode;
import java.util.Collections;
import java.util.Locale;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeManagerUaNode
extends NodeManager {
    private static boolean lE = true;
    private static final char lF = '/';
    static Logger logger = LoggerFactory.getLogger(NodeManagerUaNode.class);
    private UaNodeBuilderConfiguration lG = null;
    private UaNodeFactory nodeFactory;
    private char lH;
    private String lI;
    private NodeMap lJ;

    public NodeManagerUaNode(UaServer uaServer, String string) {
        super(uaServer, string);
        this.initialize();
    }

    public void addComponent(UaNode uaNode, UaInstance uaInstance) throws StatusException {
        this.addNodeAndReference(uaNode, uaInstance, Identifiers.HasComponent);
    }

    @Override
    public UaNode addNode(UaNode uaNode) throws StatusException {
        NodeId nodeId = uaNode.getNodeId();
        if (nodeId == null || nodeId.equals(NodeId.NULL)) {
            throw new StatusException("NodeId==null", StatusCodes.Bad_NodeIdInvalid);
        }
        UaNode uaNode2 = this.getNodeOrExternal(nodeId);
        if (uaNode2 == uaNode) {
            return uaNode2;
        }
        if (lE && uaNode2 != null && !(uaNode2 instanceof UaExternalNode)) {
            throw new StatusException("A different node with the same nodeId (" + nodeId + ") already exists in the nodeManager. Existing node: " + this.getNode(nodeId));
        }
        if (nodeId.getNamespaceIndex() != this.getNamespaceIndex()) {
            throw new StatusException(String.format(Locale.ROOT, "NodeId of node %s does not belong to this NodeManager (namespaceIndex %d vs. expected %d)", uaNode.getBrowseName(), nodeId.getNamespaceIndex(), this.getNamespaceIndex()), StatusCodes.Bad_NodeIdRejected);
        }
        if (uaNode2 instanceof UaExternalNode) {
            this.replaceExternalNode((UaExternalNode)uaNode2, uaNode);
        }
        logger.debug("newNode: {}", (Object)nodeId);
        this.lJ.addNode(uaNode);
        this.getNodeManagerTable().getNodeManagerRoot().addModelChange(uaNode, ModelChangeType.NodeAdded);
        return uaNode;
    }

    public UaNode addNodeAndReference(UaNode uaNode, UaNode uaNode2, NodeId nodeId) throws StatusException {
        UaNode uaNode3 = this.addNode(uaNode2);
        this.addReference(uaNode, uaNode2, nodeId, false);
        return uaNode3;
    }

    public void addReference(NodeId nodeId, ExpandedNodeId expandedNodeId, NodeId nodeId2, boolean bl) throws StatusException {
        if (nodeId == null || expandedNodeId == null || nodeId2 == null) {
            throw new IllegalArgumentException("None of the parameters may be null");
        }
        if (expandedNodeId.isLocal()) {
            try {
                this.addReference(nodeId, this.getNamespaceTable().toNodeId(expandedNodeId), nodeId2, bl);
            }
            catch (ServiceResultException serviceResultException) {
                throw new IllegalArgumentException("Could not convert a local ExpandedNodeId to NodeId", serviceResultException);
            }
        } else {
            UaNode uaNode = this.getNode(nodeId);
            uaNode.addReference(expandedNodeId, nodeId2, bl);
        }
    }

    public void addReference(NodeId nodeId, NodeId nodeId2, NodeId nodeId3, boolean bl) throws StatusException {
        if (nodeId3 == null) {
            throw new NullPointerException("referenceType");
        }
        UaNode uaNode = this.getNodeOrExternal(nodeId);
        UaNode uaNode2 = this.getNodeOrExternal(nodeId2);
        this.addReference(uaNode, uaNode2, nodeId3, bl);
    }

    public void addReference(UaNode uaNode, UaNode uaNode2, NodeId nodeId, boolean bl) {
        uaNode.addReference(uaNode2, nodeId, bl);
    }

    public <T extends UaType> T addType(ExpandedNodeId expandedNodeId, String string, T t2) throws UaNodeFactoryException, StatusException {
        try {
            return this.addType(this.getNamespaceTable().toNodeId(expandedNodeId), string, t2);
        }
        catch (ServiceResultException serviceResultException) {
            throw new StatusException(serviceResultException);
        }
    }

    public <T extends UaType> T addType(NodeId nodeId, String string, T t2) throws StatusException, UaNodeFactoryException {
        UaType uaType = (UaType)this.nodeFactory.createNode(t2.getNodeClass(), nodeId, string, this.getDefaultLocale());
        this.addNodeAndReference(t2, uaType, Identifiers.HasSubtype);
        return (T)uaType;
    }

    public <T extends BaseEventType> T createEvent(Class<T> clazz) {
        NodeBuilder<T> nodeBuilder = this.createNodeBuilder(clazz);
        nodeBuilder.setBrowseName(QualifiedName.NULL);
        nodeBuilder.setDisplayName(LocalizedText.NULL);
        nodeBuilder.setNodeId(NodeId.NULL);
        try {
            return (T)((BaseEventType)nodeBuilder.build());
        }
        catch (NodeBuilderException nodeBuilderException) {
            throw new UaInstantiationException("Creating the node failed", nodeBuilderException);
        }
    }

    public <T extends BaseEventType> T createEvent(ExpandedNodeId expandedNodeId) {
        try {
            return this.createEvent(this.getNamespaceTable().toNodeId(expandedNodeId));
        }
        catch (ServiceResultException serviceResultException) {
            throw new UaInstantiationException("Creating the node failed", serviceResultException);
        }
    }

    public <T extends BaseEventType> T createEvent(NodeId nodeId) {
        NodeBuilder<T> nodeBuilder = this.createNodeBuilder(nodeId);
        nodeBuilder.setBrowseName(QualifiedName.NULL);
        nodeBuilder.setDisplayName(LocalizedText.NULL);
        nodeBuilder.setNodeId(NodeId.NULL);
        try {
            return (T)((BaseEventType)nodeBuilder.build());
        }
        catch (NodeBuilderException nodeBuilderException) {
            throw new UaInstantiationException("Creating the node failed", nodeBuilderException);
        }
    }

    public FolderType createFolder(String string, NodeId nodeId) {
        return this.createInstance(FolderTypeNode.class, string, nodeId);
    }

    public <T extends UaInstance> T createInstance(Class<T> clazz, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        NodeBuilder<T> nodeBuilder = this.createNodeBuilder(clazz);
        nodeBuilder.setBrowseName(qualifiedName);
        nodeBuilder.setDisplayName(localizedText);
        nodeBuilder.setNodeId(nodeId);
        try {
            return nodeBuilder.build();
        }
        catch (NodeBuilderException nodeBuilderException) {
            throw new UaInstantiationException("Creating the node failed", nodeBuilderException);
        }
    }

    public <T extends UaInstance> T createInstance(Class<T> clazz, String string) {
        UaInstance uaInstance = this.createInstance(this.b(clazz), string);
        return (T)uaInstance;
    }

    public <T extends UaInstance> T createInstance(Class<T> clazz, String string, NodeId nodeId) {
        UaInstance uaInstance = this.createInstance(this.b(clazz), string, nodeId);
        return (T)uaInstance;
    }

    public UaInstance createInstance(ExpandedNodeId expandedNodeId, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        try {
            return this.createInstance(this.getNamespaceTable().toNodeId(expandedNodeId), nodeId, qualifiedName, localizedText);
        }
        catch (ServiceResultException serviceResultException) {
            throw new UaInstantiationException("Cannot instantiate from typeId that points to another server", serviceResultException);
        }
    }

    public UaInstance createInstance(ExpandedNodeId expandedNodeId, String string) {
        try {
            return this.createInstance(this.getNamespaceTable().toNodeId(expandedNodeId), string);
        }
        catch (ServiceResultException serviceResultException) {
            throw new UaInstantiationException("Cannot instantiate from typeId that points to another server", serviceResultException);
        }
    }

    public UaInstance createInstance(ExpandedNodeId expandedNodeId, String string, NodeId nodeId) {
        try {
            return this.createInstance(this.getNamespaceTable().toNodeId(expandedNodeId), string, nodeId);
        }
        catch (ServiceResultException serviceResultException) {
            throw new UaInstantiationException("Cannot instantiate from typeId that points to another server", serviceResultException);
        }
    }

    public UaInstance createInstance(NodeId nodeId, NodeId nodeId2, QualifiedName qualifiedName, LocalizedText localizedText) {
        NodeBuilder nodeBuilder = this.createNodeBuilder(nodeId);
        nodeBuilder.setBrowseName(qualifiedName);
        nodeBuilder.setDisplayName(localizedText);
        nodeBuilder.setNodeId(nodeId2);
        try {
            return nodeBuilder.build();
        }
        catch (NodeBuilderException nodeBuilderException) {
            throw new UaInstantiationException("Creating the node failed", nodeBuilderException);
        }
    }

    public UaInstance createInstance(NodeId nodeId, String string) {
        try {
            return this.createNodeBuilder(nodeId).setName(string).build();
        }
        catch (NodeBuilderException nodeBuilderException) {
            throw new UaInstantiationException("Creating the node with builder failed", nodeBuilderException);
        }
    }

    public UaInstance createInstance(NodeId nodeId, String string, NodeId nodeId2) {
        try {
            return this.createNodeBuilder(nodeId).setNodeId(nodeId2).setName(string).build();
        }
        catch (NodeBuilderException nodeBuilderException) {
            throw new UaInstantiationException("Creating the node with builder failed", nodeBuilderException);
        }
    }

    public <T extends UaInstance> NodeBuilder<T> createNodeBuilder(Class<T> clazz) {
        return this.createNodeBuilder(this.b(clazz), this.getNodeBuilderConfiguration());
    }

    public <T extends UaInstance> NodeBuilder<T> createNodeBuilder(Class<T> clazz, UaNodeBuilderConfiguration uaNodeBuilderConfiguration) {
        return this.createNodeBuilder(this.b(clazz), uaNodeBuilderConfiguration);
    }

    public <T extends UaInstance> NodeBuilder<T> createNodeBuilder(ExpandedNodeId expandedNodeId) {
        try {
            return this.createNodeBuilder(this.getNamespaceTable().toNodeId(expandedNodeId));
        }
        catch (ServiceResultException serviceResultException) {
            throw new UaInstantiationException("Invalid type node for instantiation.");
        }
    }

    public <T extends UaInstance> NodeBuilder<T> createNodeBuilder(ExpandedNodeId expandedNodeId, UaNodeBuilderConfiguration uaNodeBuilderConfiguration) {
        try {
            return this.createNodeBuilder(this.getNamespaceTable().toNodeId(expandedNodeId), uaNodeBuilderConfiguration);
        }
        catch (ServiceResultException serviceResultException) {
            throw new UaInstantiationException("Invalid type node for instantiation.");
        }
    }

    public <T extends UaInstance> NodeBuilder<T> createNodeBuilder(NodeId nodeId) {
        return this.createNodeBuilder(nodeId, this.getNodeBuilderConfiguration());
    }

    public <T extends UaInstance> NodeBuilder<T> createNodeBuilder(NodeId nodeId, UaNodeBuilderConfiguration uaNodeBuilderConfiguration) {
        try {
            NodeBuilder nodeBuilder = new NodeBuilder(this, uaNodeBuilderConfiguration, this.getType(nodeId));
            nodeBuilder.setDefaultNameSpaceIndex(this.getNamespaceIndex());
            return nodeBuilder;
        }
        catch (InvalidTypeNodeException invalidTypeNodeException) {
            throw new UaInstantiationException("Invalid type node for instantiation.");
        }
        catch (StatusException statusException) {
            throw new UaInstantiationException("Could not get type node.");
        }
    }

    public NodeId createNodeId(UaNode uaNode, QualifiedName qualifiedName) {
        return this.createNodeId(uaNode, qualifiedName, this.getNamespaceIndex());
    }

    public NodeId createNodeId(UaNode uaNode, QualifiedName qualifiedName, int n2) {
        String string = this.getNodeIdFormat();
        if (string == null || NodeId.isNull(uaNode.getNodeId())) {
            return new NodeId(n2, UUID.randomUUID());
        }
        String string2 = qualifiedName.getNamespaceIndex() + ":" + qualifiedName.getName();
        return new NodeId(n2, String.format(Locale.ROOT, string, uaNode.getNodeId().getValue().toString(), string2));
    }

    public NodeId createNodeId(UaNode uaNode, String string) {
        return this.createNodeId(uaNode, string, this.getNamespaceIndex());
    }

    public NodeId createNodeId(UaNode uaNode, String string, int n2) {
        return this.createNodeId(uaNode, QualifiedName.parseQualifiedName(string), n2);
    }

    public UaNode deleteNode(NodeId nodeId, boolean bl, boolean bl2) throws StatusException {
        UaNode uaNode = this.getNode(nodeId);
        return this.deleteNode(uaNode, bl, bl2);
    }

    public UaNode deleteNode(UaNode uaNode, boolean bl, boolean bl2) throws StatusException {
        return this.deleteNode(uaNode, bl, bl2, false);
    }

    public void deleteReference(NodeId nodeId, ExpandedNodeId expandedNodeId, NodeId nodeId2) throws StatusException {
        this.deleteReference(this.getNode(nodeId), expandedNodeId, nodeId2);
    }

    public void deleteReference(UaNode uaNode, ExpandedNodeId expandedNodeId, NodeId nodeId) throws StatusException {
        this.a(ServiceContext.INTERNAL_OPERATION_CONTEXT, uaNode, expandedNodeId, null, nodeId, false, true, null);
    }

    public void deleteReference(UaNode uaNode, UaNode uaNode2, NodeId nodeId) throws StatusException {
        this.a(ServiceContext.INTERNAL_OPERATION_CONTEXT, uaNode, null, uaNode2, nodeId, false, true, null);
    }

    @Override
    public UaNode findNode(NodeId nodeId) {
        String string;
        String string2;
        int n2;
        UaNode uaNode = this.lJ.getNode(nodeId);
        if (uaNode == null && nodeId.getIdType().equals(IdType.String) && (n2 = (string2 = (String)nodeId.getValue()).lastIndexOf(this.lH)) > 0 && !(string = string2.substring(0, n2)).isEmpty()) {
            NodeId nodeId2 = new NodeId(this.getNamespaceIndex(), string);
            UaNode uaNode2 = this.findNode(nodeId2);
            if (uaNode2 == null) {
                uaNode2 = this.findNode(new NodeId(this.getNamespaceIndex(), string));
            }
            if (uaNode2 == null) {
                try {
                    uaNode2 = this.findNode(new NodeId(this.getNamespaceIndex(), Integer.parseInt(string)));
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
            }
            if (uaNode2 != null) {
                String string3 = string2.substring(n2 + 1);
                uaNode = uaNode2.getProperty(QualifiedName.parseQualifiedName(string3));
            }
        }
        return uaNode;
    }

    public UaDataType getDataType(NodeId nodeId) throws StatusException {
        return (UaDataType)this.getNode(nodeId);
    }

    @Override
    public IoManagerUaNode getIoManager() {
        return (IoManagerUaNode)super.getIoManager();
    }

    public UaNodeBuilderConfiguration getNodeBuilderConfiguration() {
        UaNodeBuilderConfiguration uaNodeBuilderConfiguration = this.lG;
        if (uaNodeBuilderConfiguration == null) {
            return this.getNodeManagerTable().getNodeBuilderConfiguration();
        }
        return uaNodeBuilderConfiguration;
    }

    public UaNodeFactory getNodeFactory() {
        return this.nodeFactory;
    }

    public char getNodeIdDelimiter() {
        return this.lH;
    }

    public String getNodeIdFormat() {
        return this.lI;
    }

    public UaNode getNodeOrExternal(NodeId nodeId) {
        UaNode uaNode = null;
        try {
            if (nodeId.getNamespaceIndex() == this.getNamespaceIndex() && (uaNode = this.lJ.getNode(nodeId)) == null) {
                uaNode = this.getNodeManagerTable().getExternalNode(nodeId);
            }
            if (uaNode == null) {
                uaNode = this.getNodeManagerTable().getNodeOrExternal(nodeId);
            }
        }
        catch (StatusException statusException) {
            return null;
        }
        return uaNode;
    }

    public NodeMap getNodes() {
        return this.lJ;
    }

    public UaType getType(NodeId nodeId) throws StatusException {
        return (UaType)this.getNode(nodeId);
    }

    @Override
    public NodeId getVariableDataType(NodeId nodeId, UaValueNode uaValueNode) throws StatusException {
        return uaValueNode == null ? NodeId.NULL : uaValueNode.getDataTypeId();
    }

    @Override
    public boolean hasNode(NodeId nodeId) {
        return this.findNode(nodeId) != null;
    }

    public void setNodeBuilderConfiguration(UaNodeBuilderConfiguration uaNodeBuilderConfiguration) {
        this.lG = uaNodeBuilderConfiguration;
    }

    public void setNodeFactory(UaNodeFactory uaNodeFactory) {
        this.nodeFactory = uaNodeFactory;
    }

    public void setNodeIdDelimiter(char c2) {
        this.lH = c2;
        this.lI = "%s" + c2 + "%s";
    }

    @Override
    public boolean supportsUaNode() {
        return true;
    }

    public UaNodeSet toNodeSet() {
        InternalUaNodeSetNodeManagerUaNodeParser internalUaNodeSetNodeManagerUaNodeParser = new InternalUaNodeSetNodeManagerUaNodeParser(this, Collections.emptySet(), Collections.emptySet());
        return internalUaNodeSetNodeManagerUaNodeParser.parse();
    }

    private void c(UaNode uaNode) throws StatusException {
        UaReference[] uaReferenceArray = uaNode.getReferences(Identifiers.HasChild, false);
        if (uaReferenceArray == null) {
            logger.error("deleteChildNodes: references={}", (Object)uaReferenceArray);
            return;
        }
        for (UaReference uaReference : uaReferenceArray) {
            this.deleteNode(uaReference.getTargetNode(), false, true, true);
        }
    }

    private void a(ServiceContext serviceContext, UaNode uaNode, ExpandedNodeId expandedNodeId, UaNode uaNode2, NodeId nodeId, boolean bl, Boolean bl2, UaReferenceType uaReferenceType) throws StatusException {
        if (uaNode2 == null && !ExpandedNodeId.isNull(expandedNodeId) && expandedNodeId.isLocal()) {
            uaNode2 = this.getNode(expandedNodeId, StatusCodes.Bad_TargetNodeIdInvalid);
        }
        if (!serviceContext.isInternal()) {
            this.fireDeleteReference(serviceContext, uaNode.getNodeId(), uaNode, expandedNodeId, uaNode2, nodeId, uaReferenceType, bl, bl2);
        }
        if (uaNode2 == null) {
            uaNode.deleteReference(expandedNodeId, nodeId, bl);
        } else {
            uaNode.deleteReference(uaNode2, nodeId, bl);
            if (bl2.booleanValue()) {
                uaNode2.deleteReference(uaNode, nodeId, !bl);
            }
        }
    }

    private NodeId b(Class<? extends UaInstance> clazz) {
        ExpandedNodeId expandedNodeId;
        try {
            expandedNodeId = AnnotationUtils.readTypeDefinitionId(clazz);
        }
        catch (AnnotationException annotationException) {
            throw new UaInstantiationException("Could not read type definition node identifier (expecting Annotation TypeDefinitionId) from the class " + clazz, annotationException);
        }
        try {
            return this.getNamespaceTable().toNodeId(expandedNodeId);
        }
        catch (ServiceResultException serviceResultException) {
            throw new UaInstantiationException("Could convert the TypeDefinitionId ExpandedNodeId to NodeId, most likely the information model xml has not been loaded." + clazz, serviceResultException);
        }
    }

    private void initialize() {
        this.setNodeIdDelimiter('/');
        this.setIoManager(new IoManagerUaNode(this));
        MethodManagerUaNode methodManagerUaNode = new MethodManagerUaNode(this);
        this.setMethodManager(methodManagerUaNode);
        EventManagerUaNode eventManagerUaNode = new EventManagerUaNode(this);
        this.setEventManager(eventManagerUaNode);
        HistoryManager historyManager = new HistoryManager(this);
        this.setHistoryManager(historyManager);
        this.nodeFactory = new UaServerNodeFactory(this);
        this.lJ = this.createNodeMap();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected NodeId addNode(ServiceContext var1_1, NodeId var2_2, NodeId var3_3, QualifiedName var4_4, NodeClass var5_5, ExpandedNodeId var6_6, NodeAttributes var7_7, NodeId var8_8) throws StatusException {
        if (NodeManagerUaNode.logger.isDebugEnabled()) {
            NodeManagerUaNode.logger.debug("addNode: (this={}) nodeId={}; parentNodeId={}; browseName={}; referenceTypeId={}", new Object[]{this, var2_2, var3_3, var4_4, var8_8});
        }
        var9_9 = null;
        var10_10 = null;
        var10_10 = var3_3.isNullNodeId() != false ? null : (var1_1.isInternal() == false ? this.getNode(var3_3, StatusCodes.Bad_ParentNodeIdInvalid) : this.getNodeOrExternal(var3_3));
        if (!var1_1.isInternal() && this.hasNode(var2_2)) {
            throw new StatusException(StatusCodes.Bad_NodeIdExists);
        }
        var11_11 = var7_7.getDisplayName();
        if (var11_11 == null || var11_11.getText() == "" || var11_11.getText() == null) {
            var11_11 = new LocalizedText(var4_4.toString(), Locale.ENGLISH);
        }
        var12_12 = null;
        if (!(ExpandedNodeId.isNull(var6_6) || var5_5.equals(NodeClass.Object) || var5_5.equals(NodeClass.Variable))) {
            switch (1.bm[var5_5.ordinal()]) {
                case 1: {
                    NodeManagerUaNode.logger.warn("Method nodes cannot be source of TypeDefinition Reference, source: {}", (Object)var2_2);
                    break;
                }
                case 2: {
                    NodeManagerUaNode.logger.warn("VariableType nodes cannot be source of TypeDefinition Reference, source: {}", (Object)var2_2);
                    break;
                }
                case 3: {
                    NodeManagerUaNode.logger.warn("ObjectType nodes cannot be source of TypeDefinition Reference, source: {}", (Object)var2_2);
                    break;
                }
                default: {
                    throw new StatusException(StatusCodes.Bad_TypeDefinitionInvalid);
                }
            }
        }
        if (ExpandedNodeId.isNull(var6_6) || !var6_6.isLocal()) {
            var12_12 = null;
        } else if (!var1_1.isInternal()) {
            try {
                var12_12 = this.findNode(var6_6);
                if (var12_12 != null || !this.getNamespaceTable().toNodeId(var6_6).equals(var2_2)) ** GOTO lbl41
                var12_12 = var9_9;
            }
            catch (ServiceResultException var13_13) {
                throw new StatusException(StatusCodes.Bad_TypeDefinitionInvalid, (Throwable)var13_13);
            }
        } else {
            try {
                var12_12 = this.getNodeOrExternal(this.getNamespaceTable().toNodeId(var6_6));
            }
            catch (ServiceResultException var13_14) {
                throw new StatusException(StatusCodes.Bad_TypeDefinitionInvalid, (Throwable)var13_14);
            }
        }
lbl41:
        // 4 sources

        var13_15 = this.getNamespaceIndex() < 2 || NodeId.isNull(var8_8) != false ? null : this.getReferenceType(var8_8);
        var9_9 = this.findNode(var2_2);
        if (var9_9 == null || var1_1.isInternal()) {
            try {
                if (!var1_1.isInternal()) {
                    this.fireAddNode(var1_1, var3_3, var10_10, var2_2, var5_5, var4_4, var7_7, var13_15, var6_6, var12_12);
                    var9_9 = this.createNodeForAddNodesRequest(var2_2, var4_4, var5_5, var6_6, var11_11);
                } else {
                    var9_9 = this.createNodeForNodeSet2(var2_2, var4_4, var5_5, var6_6, var11_11);
                }
                var9_9.setAttributes(var7_7);
                if (var10_10 != null) {
                    var10_10.addReference(var9_9, var8_8, false);
                }
                this.addNode(var9_9);
                if (!var1_1.isInternal()) {
                    this.fireAfterAddNode(var1_1, var3_3, var10_10, var2_2, var9_9, var5_5, var4_4, var7_7, var13_15, var6_6, var12_12);
                }
                return var9_9.getNodeId();
            }
            catch (UaNodeFactoryException var14_16) {
                NodeManagerUaNode.logger.error("UaNodeFactoryException: ", (Throwable)var14_16);
                throw new StatusException(StatusCodes.Bad_InternalError, (Throwable)var14_16);
            }
        }
        throw new StatusException(StatusCodes.Bad_NodeIdExists);
    }

    @Override
    protected void addReference(ServiceContext serviceContext, NodeId nodeId, ExpandedNodeId expandedNodeId, NodeId nodeId2, boolean bl, NodeClass nodeClass, String string) throws StatusException {
        UaNode uaNode = this.getNode(nodeId, StatusCodes.Bad_SourceNodeIdInvalid);
        if (ExpandedNodeId.isNull(expandedNodeId)) {
            throw new StatusException(StatusCodes.Bad_TargetNodeIdInvalid);
        }
        if (!expandedNodeId.isLocal()) {
            throw new StatusException(StatusCodes.Bad_NotSupported);
        }
        UaNode uaNode2 = this.getNode(expandedNodeId, StatusCodes.Bad_TargetNodeIdInvalid);
        UaReferenceType uaReferenceType = this.getReferenceType(nodeId2);
        this.fireAddReference(serviceContext, nodeId, uaNode, expandedNodeId, uaNode2, nodeId2, uaReferenceType, bl);
        this.addReference(uaNode, uaNode2, nodeId2, !bl);
        this.fireAfterAddReference(serviceContext, nodeId, uaNode, expandedNodeId, uaNode2, nodeId2, uaReferenceType, bl);
    }

    @Override
    protected void close() {
        super.close();
        NodeMap nodeMap = this.lJ;
        if (nodeMap != null) {
            nodeMap.clear();
            this.getNodeManagerTable().invalidatePreviousNodeCaches();
        }
    }

    @Override
    protected void createMonitoredDataItem(ServiceContext serviceContext, Subscription subscription, NodeId nodeId, UnsignedInteger unsignedInteger, NumericRange numericRange, MonitoringParameters monitoringParameters, MonitoringFilter monitoringFilter, AggregateFilterResult aggregateFilterResult, MonitoringMode monitoringMode) throws StatusException {
        UaNode uaNode = this.getNode(nodeId);
        if (uaNode instanceof UaExternalNode) {
            throw new StatusException(StatusCodes.Bad_NodeIdUnknown);
        }
        if (!uaNode.supportsAttribute(unsignedInteger)) {
            throw new StatusException(StatusCodes.Bad_AttributeIdInvalid);
        }
        logger.debug("createMonitoredDataItem: node{}", (Object)uaNode);
        this.fireCreateMonitoredDataItem(serviceContext, subscription, nodeId, uaNode, unsignedInteger, numericRange, monitoringParameters, monitoringFilter, aggregateFilterResult, monitoringMode);
    }

    protected UaNode createNodeForAddNodesRequest(NodeId nodeId, QualifiedName qualifiedName, NodeClass nodeClass, ExpandedNodeId expandedNodeId, LocalizedText localizedText) {
        if (NodeClass.Variable == nodeClass || NodeClass.Object == nodeClass) {
            try {
                return this.createNodeBuilder(expandedNodeId).setNodeId(nodeId).setBrowseName(qualifiedName).setDisplayName(localizedText).build();
            }
            catch (Exception exception) {
                throw new UaNodeFactoryException("Could not create instance of typedefinition: " + expandedNodeId, exception);
            }
        }
        return this.nodeFactory.createNode(nodeClass, nodeId, qualifiedName, localizedText, expandedNodeId);
    }

    protected UaNode createNodeForNodeSet2(NodeId nodeId, QualifiedName qualifiedName, NodeClass nodeClass, ExpandedNodeId expandedNodeId, LocalizedText localizedText) {
        return this.nodeFactory.createNode(nodeClass, nodeId, qualifiedName, localizedText, expandedNodeId);
    }

    protected NodeMap createNodeMap() {
        return new NodeMapUaNode(this.nodeFactory);
    }

    @Override
    protected void deleteNode(ServiceContext serviceContext, NodeId nodeId, Boolean bl) throws StatusException {
        UaNode uaNode = this.getNode(nodeId);
        this.fireDeleteNode(serviceContext, nodeId, uaNode, bl);
        this.deleteNode(uaNode, (boolean)bl, false);
    }

    protected UaNode deleteNode(UaNode uaNode, boolean bl, boolean bl2, boolean bl3) throws StatusException {
        NodeManager object;
        Object object2;
        if (uaNode == null) {
            return null;
        }
        if (bl3 && (object2 = uaNode.getReferences(Identifiers.HasChild, true)) != null && ((UaReference[])object2).length > 1) {
            return null;
        }
        if (this.lJ.hasNode(uaNode.getNodeId())) {
            this.getNodeManagerTable().getNodeManagerRoot().addModelChange(uaNode, ModelChangeType.NodeDeleted);
        }
        if (bl2) {
            this.c(uaNode);
        }
        object2 = this.lJ.remove(uaNode);
        this.getNodeManagerTable().invalidatePreviousNodeCaches();
        if (object2 == null && uaNode.getNodeId().getNamespaceIndex() != this.getNamespaceIndex() && (object = this.getNodeManagerTable().getNodeManager(uaNode.getNodeId())) instanceof NodeManagerUaNode) {
            ((NodeManagerUaNode)object).deleteNode(uaNode, bl, bl2);
        }
        for (UaReference uaReference : uaNode.getReferences()) {
            uaReference.delete();
        }
        return object2;
    }

    @Override
    protected void deleteReference(ServiceContext serviceContext, NodeId nodeId, ExpandedNodeId expandedNodeId, NodeId nodeId2, Boolean bl, Boolean bl2) throws StatusException {
        UaNode uaNode = this.getNode(nodeId, StatusCodes.Bad_SourceNodeIdInvalid);
        UaReferenceType uaReferenceType = this.getReferenceType(nodeId2);
        this.a(serviceContext, uaNode, expandedNodeId, null, nodeId2, bl == false, bl2, uaReferenceType);
    }

    @Override
    protected QualifiedName getBrowseName(ExpandedNodeId expandedNodeId, UaNode uaNode) {
        if (uaNode == null || uaNode instanceof UaExternalNode) {
            try {
                uaNode = this.findNode(expandedNodeId);
            }
            catch (ServiceResultException serviceResultException) {
                // empty catch block
            }
            if (uaNode == null) {
                return QualifiedName.NULL;
            }
        }
        return uaNode.getBrowseName();
    }

    @Override
    protected LocalizedText getDisplayName(ExpandedNodeId expandedNodeId, UaNode uaNode, Locale locale) {
        if (uaNode == null || uaNode instanceof UaExternalNode) {
            return null;
        }
        return uaNode.getDisplayName();
    }

    protected UaNode getNode(ExpandedNodeId expandedNodeId, UnsignedInteger unsignedInteger) throws StatusException {
        try {
            return this.getNode(expandedNodeId);
        }
        catch (StatusException statusException) {
            if (statusException.getStatusCode().getValue().equals(StatusCodes.Bad_NodeIdInvalid)) {
                throw statusException;
            }
            throw new StatusException(statusException.getMessage(), unsignedInteger);
        }
    }

    protected UaNode getNode(NodeId nodeId, UnsignedInteger unsignedInteger) throws StatusException {
        try {
            return this.getNode(nodeId);
        }
        catch (StatusException statusException) {
            if (statusException.getStatusCode().getValue().equals(StatusCodes.Bad_NodeIdInvalid)) {
                throw statusException;
            }
            throw new StatusException(statusException.getMessage(), unsignedInteger);
        }
    }

    @Override
    protected NodeClass getNodeClass(NodeId nodeId, UaNode uaNode) {
        if (uaNode == null) {
            try {
                uaNode = this.getNode(nodeId);
            }
            catch (StatusException statusException) {
                // empty catch block
            }
        }
        return uaNode == null ? null : uaNode.getNodeClass();
    }

    @Override
    protected UaReference[] getReferences(NodeId nodeId, UaNode uaNode) {
        return uaNode == null ? null : uaNode.getReferences();
    }

    @Override
    protected ExpandedNodeId getTypeDefinition(ExpandedNodeId expandedNodeId, UaNode uaNode) {
        if (uaNode instanceof UaInstance) {
            return ((UaInstance)uaNode).getTypeDefinitionId();
        }
        return null;
    }

    protected void replaceExternalNode(UaExternalNode uaExternalNode, UaNode uaNode) throws StatusException {
        for (UaReference uaReference : uaExternalNode.getReferences()) {
            UaNode uaNode2 = uaReference.getSourceNode();
            UaNode uaNode3 = uaReference.getTargetNode();
            NodeId nodeId = uaReference.getReferenceTypeId();
            if (uaNode2 == uaExternalNode) {
                uaNode2 = uaNode;
                uaNode3.deleteReference(uaReference);
            } else if (uaNode3 == uaExternalNode) {
                uaNode3 = uaNode;
                uaNode2.deleteReference(uaReference);
            } else {
                logger.error("Unexpected error copying reference from ExternalNode, reference skipped");
                continue;
            }
            uaNode2.addReference(uaNode3, nodeId, false);
        }
        this.getNodeManagerTable().getExternalNodeManager().removeNode(uaExternalNode);
    }

    @Override
    protected boolean requireUaNode() {
        return true;
    }

    UaObject a(UaNode uaNode, NodeId nodeId, String string, Locale locale) throws StatusException, UaNodeFactoryException {
        UaObject uaObject = (UaObject)this.nodeFactory.createNode(NodeClass.Object, nodeId, string, locale, Identifiers.FolderType);
        this.addNodeAndReference(uaNode, uaObject, Identifiers.Organizes);
        return uaObject;
    }

    UaObject a(NodeId nodeId, String string, UaType uaType, UaNode uaNode, NodeId nodeId2) throws StatusException, UaNodeFactoryException {
        UaObject uaObject = (UaObject)this.nodeFactory.createNode(NodeClass.Object, nodeId, string, this.getDefaultLocale());
        uaObject.setTypeDefinition(uaType);
        this.addNodeAndReference(uaNode, uaObject, nodeId2);
        return uaObject;
    }

    UaVariable a(NodeId nodeId, String string, NodeId nodeId2, NodeId nodeId3, UaInstance uaInstance) throws UaNodeFactoryException, StatusException {
        UaType uaType = (UaType)this.getNodeOrExternal(nodeId2);
        UaVariable uaVariable = this.a(nodeId, string, uaType, nodeId3, uaInstance);
        return uaVariable;
    }

    UaVariable a(NodeId nodeId, String string, UaType uaType, NodeId nodeId2, UaInstance uaInstance) throws StatusException, UaNodeFactoryException {
        UaDataType uaDataType = this.getDataType(nodeId2);
        return this.a(nodeId, string, uaType, uaDataType, uaInstance);
    }

    UaVariable a(NodeId nodeId, String string, UaType uaType, UaDataType uaDataType, UaInstance uaInstance) throws StatusException, UaNodeFactoryException {
        NodeId nodeId2 = uaType == null ? null : uaType.getNodeId();
        UaVariable uaVariable = (UaVariable)this.nodeFactory.createNode(NodeClass.Variable, nodeId, string, this.getDefaultLocale(), nodeId2);
        uaVariable.setTypeDefinition(uaType);
        uaVariable.setDataType(uaDataType);
        this.addComponent(uaInstance, uaVariable);
        return uaVariable;
    }

    void a(NodeId nodeId, ExpandedNodeId expandedNodeId, NodeId nodeId2, Boolean bl, Boolean bl2) throws StatusException {
        UaNode uaNode;
        try {
            uaNode = this.getNode(nodeId);
        }
        catch (StatusException statusException) {
            throw new StatusException(StatusCodes.Bad_SourceNodeIdInvalid);
        }
        boolean bl3 = bl == false;
        uaNode.deleteReference(expandedNodeId, nodeId2, bl3);
        if (bl2.booleanValue()) {
            UaNode uaNode2;
            try {
                uaNode2 = this.getNode(expandedNodeId);
            }
            catch (StatusException statusException) {
                throw new StatusException(StatusCodes.Bad_TargetNodeIdInvalid);
            }
            uaNode2.deleteReference(this.getNamespaceTable().toExpandedNodeId(nodeId), nodeId2, (boolean)bl);
        }
    }
}

