/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.AccessLevels;
import com.prosysopc.ua.DataTypeConverter;
import com.prosysopc.ua.ModelException;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.UaAddressSpace;
import com.prosysopc.ua.UaException;
import com.prosysopc.ua.UaNodeSet;
import com.prosysopc.ua.UaNodeSetException;
import com.prosysopc.ua.nodes.UaDataType;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaNodeFactoryException;
import com.prosysopc.ua.nodes.UaType;
import com.prosysopc.ua.server.BrowseContinuationPoint;
import com.prosysopc.ua.server.ExternalNodeManager;
import com.prosysopc.ua.server.HistoryContinuationPoint;
import com.prosysopc.ua.server.HistoryManager;
import com.prosysopc.ua.server.HistoryResult;
import com.prosysopc.ua.server.IoManager;
import com.prosysopc.ua.server.ModelParser;
import com.prosysopc.ua.server.MonitoredDataItem;
import com.prosysopc.ua.server.MonitoredEventItem;
import com.prosysopc.ua.server.MonitoredItem;
import com.prosysopc.ua.server.NamespacePair;
import com.prosysopc.ua.server.NodeManager;
import com.prosysopc.ua.server.NodeManagerRoot;
import com.prosysopc.ua.server.NodeManagerTableListener;
import com.prosysopc.ua.server.PredefinedIdPair;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.server.Subscription;
import com.prosysopc.ua.server.UaNodeSetLoadOptions;
import com.prosysopc.ua.server.UaServer;
import com.prosysopc.ua.server.a;
import com.prosysopc.ua.server.b;
import com.prosysopc.ua.server.instantiation.InstanceDeclarationHierarchyCache;
import com.prosysopc.ua.server.instantiation.TypeDefinitionBasedNodeBuilderConfiguration;
import com.prosysopc.ua.server.instantiation.UaNodeBuilderConfiguration;
import com.prosysopc.ua.server.nodes.UaExternalNode;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.ExtensionObject;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.common.IdentifierDescriptions;
import com.prosysopc.ua.stack.common.NamespaceTable;
import com.prosysopc.ua.stack.common.ServerTable;
import com.prosysopc.ua.stack.common.ServiceFaultException;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.AddNodesItem;
import com.prosysopc.ua.stack.core.AddReferencesItem;
import com.prosysopc.ua.stack.core.AggregateFilterResult;
import com.prosysopc.ua.stack.core.Argument;
import com.prosysopc.ua.stack.core.BrowseDirection;
import com.prosysopc.ua.stack.core.BrowsePathTarget;
import com.prosysopc.ua.stack.core.BrowseResultMask;
import com.prosysopc.ua.stack.core.DataTypeAttributes;
import com.prosysopc.ua.stack.core.EventFilter;
import com.prosysopc.ua.stack.core.EventFilterResult;
import com.prosysopc.ua.stack.core.HistoryReadDetails;
import com.prosysopc.ua.stack.core.HistoryUpdateDetails;
import com.prosysopc.ua.stack.core.HistoryUpdateResult;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.stack.core.MethodAttributes;
import com.prosysopc.ua.stack.core.MonitoringFilter;
import com.prosysopc.ua.stack.core.MonitoringMode;
import com.prosysopc.ua.stack.core.MonitoringParameters;
import com.prosysopc.ua.stack.core.NodeAttributes;
import com.prosysopc.ua.stack.core.NodeClass;
import com.prosysopc.ua.stack.core.ObjectAttributes;
import com.prosysopc.ua.stack.core.ObjectTypeAttributes;
import com.prosysopc.ua.stack.core.QueryFirstRequest;
import com.prosysopc.ua.stack.core.QueryFirstResponse;
import com.prosysopc.ua.stack.core.QueryNextRequest;
import com.prosysopc.ua.stack.core.QueryNextResponse;
import com.prosysopc.ua.stack.core.ReferenceDescription;
import com.prosysopc.ua.stack.core.ReferenceTypeAttributes;
import com.prosysopc.ua.stack.core.RelativePath;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.core.TimestampsToReturn;
import com.prosysopc.ua.stack.core.VariableAttributes;
import com.prosysopc.ua.stack.core.VariableTypeAttributes;
import com.prosysopc.ua.stack.core.ViewAttributes;
import com.prosysopc.ua.stack.core.ViewDescription;
import com.prosysopc.ua.stack.encoding.DecodingException;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.encoding.EncodingException;
import com.prosysopc.ua.stack.utils.NumericRange;
import com.prosysopc.ua.types.opcua.server.FolderTypeNode;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class NodeManagerTable
implements UaAddressSpace {
    private static final Logger logger = LoggerFactory.getLogger(NodeManagerTable.class);
    static boolean ku = false;
    private DataTypeConverter en;
    private final ExternalNodeManager kv;
    private final InstanceDeclarationHierarchyCache kw = new InstanceDeclarationHierarchyCache();
    private NodeManagerTableListener kx = null;
    private boolean ky;
    private final b kz = new b();
    private final UaServer hz;
    private final AtomicReference<UaNodeBuilderConfiguration> kA;

    public NodeManagerTable(UaServer uaServer) {
        this.hz = uaServer;
        TypeDefinitionBasedNodeBuilderConfiguration typeDefinitionBasedNodeBuilderConfiguration = TypeDefinitionBasedNodeBuilderConfiguration.builder().build();
        this.kA = new AtomicReference<TypeDefinitionBasedNodeBuilderConfiguration>(typeDefinitionBasedNodeBuilderConfiguration);
        this.kv = new ExternalNodeManager(this);
    }

    @Override
    public void addNode(UaNode uaNode) {
        NodeManager nodeManager = this.kz.h(uaNode.getNodeId().getNamespaceIndex());
        if (nodeManager != null) {
            try {
                nodeManager.addNode(uaNode);
            }
            catch (StatusException statusException) {
                logger.error("Could not add node", (Throwable)statusException);
                throw new IllegalStateException("Could not add node", statusException);
            }
        }
    }

    public int addNodeManager(int n2, NodeManager nodeManager) {
        String string = nodeManager.getNamespaceUri();
        int n3 = this.getNamespaceTable().getIndex(string);
        if (n3 == -1) {
            n3 = this.getNamespaceTable().add(n2, string);
        }
        this.kz.a(n3, nodeManager);
        if (this.hz.isRunning()) {
            this.hz.updateNamespaceArray();
        }
        return n3;
    }

    public void close() {
        for (NodeManager nodeManager : this.kz.values()) {
            nodeManager.close();
        }
    }

    @Override
    public UaNode findNode(NodeId nodeId) {
        if (NodeId.isNull(nodeId)) {
            return null;
        }
        try {
            return this.getNodeManager(nodeId).findNode(nodeId);
        }
        catch (StatusException statusException) {
            return null;
        }
    }

    public UaDataType getDataType(NodeId nodeId) throws StatusException {
        return (UaDataType)this.getNode(nodeId);
    }

    @Override
    public DataTypeConverter getDataTypeConverter() {
        if (this.en == null) {
            this.en = new DataTypeConverter(this);
        }
        return this.en;
    }

    @Override
    public EncoderContext getEncoderContext() {
        return this.hz.getEncoderContext();
    }

    public UaNode getExternalNode(NodeId nodeId) throws StatusException {
        return this.kv.getNode(nodeId);
    }

    public ExternalNodeManager getExternalNodeManager() {
        return this.kv;
    }

    public HistoryManager getHistoryManager(NodeId nodeId) throws StatusException {
        HistoryManager historyManager = this.getNodeManager(nodeId).getHistoryManager();
        if (historyManager == null) {
            throw new StatusException(StatusCodes.Bad_NotSupported);
        }
        return historyManager;
    }

    public InstanceDeclarationHierarchyCache getInstanceDeclarationHierarchyCache() {
        return this.kw;
    }

    public IoManager getIoManager(NodeId nodeId) throws StatusException {
        IoManager ioManager = this.getNodeManager(nodeId).getIoManager();
        if (ioManager == null) {
            throw new StatusException(StatusCodes.Bad_NotSupported);
        }
        return ioManager;
    }

    public NodeManagerTableListener getListener() {
        return this.kx;
    }

    @Override
    public NamespaceTable getNamespaceTable() {
        return this.getServer().getNamespaceTable();
    }

    @Override
    public UaNode getNode(ExpandedNodeId expandedNodeId) throws StatusException {
        if (ExpandedNodeId.isNull(expandedNodeId)) {
            throw new StatusException("nodeId==null", StatusCodes.Bad_NodeIdUnknown);
        }
        try {
            return this.getNode(this.getNamespaceTable().toNodeId(expandedNodeId));
        }
        catch (ServiceResultException serviceResultException) {
            throw new StatusException(serviceResultException);
        }
    }

    @Override
    public <T extends UaNode> T getNode(ExpandedNodeId expandedNodeId, Class<T> clazz) throws StatusException {
        UaNode uaNode = this.getNode(expandedNodeId);
        return (T)uaNode;
    }

    @Override
    public UaNode getNode(NodeId nodeId) throws StatusException {
        if (NodeId.isNull(nodeId)) {
            throw new StatusException("nodeId==null", StatusCodes.Bad_NodeIdUnknown);
        }
        NodeManager nodeManager = this.getNodeManager(nodeId);
        UaNode uaNode = nodeManager.findNode(nodeId);
        if ((uaNode == null || uaNode instanceof UaExternalNode) && nodeManager.requireUaNode() || !nodeManager.hasNode(nodeId)) {
            logger.debug("getNode: nodeId={} nodeManager={}", (Object)nodeId, (Object)nodeManager);
            throw new StatusException("nodeId=" + nodeId, StatusCodes.Bad_NodeIdUnknown);
        }
        return uaNode;
    }

    @Override
    public <T extends UaNode> T getNode(NodeId nodeId, Class<T> clazz) throws StatusException {
        ExpandedNodeId expandedNodeId = this.getNamespaceTable().toExpandedNodeId(nodeId);
        return this.getNode(expandedNodeId, clazz);
    }

    public UaNodeBuilderConfiguration getNodeBuilderConfiguration() {
        return this.kA.get();
    }

    public NodeClass getNodeClass(ExpandedNodeId expandedNodeId, UaNode uaNode) {
        try {
            return this.getNodeManager(expandedNodeId).getNodeClass(expandedNodeId, uaNode);
        }
        catch (StatusException statusException) {
            return null;
        }
    }

    public NodeClass getNodeClass(NodeId nodeId, UaNode uaNode) {
        try {
            return this.getNodeManager(nodeId).getNodeClass(nodeId, uaNode);
        }
        catch (StatusException statusException) {
            return null;
        }
    }

    public boolean getNodeManagementEnabled() {
        return this.ky;
    }

    public NodeManager getNodeManager(ExpandedNodeId expandedNodeId) throws StatusException {
        int n2 = expandedNodeId.getNamespaceIndex();
        if (n2 == 0) {
            try {
                n2 = this.getNamespaceTable().toNodeId(expandedNodeId).getNamespaceIndex();
            }
            catch (ServiceResultException serviceResultException) {
                throw new StatusException(serviceResultException);
            }
        }
        return this.getNodeManager(n2);
    }

    public NodeManager getNodeManager(int n2) throws StatusException {
        NodeManager nodeManager = this.kz.h(n2);
        if (nodeManager == null) {
            throw new StatusException(StatusCodes.Bad_NodeIdUnknown);
        }
        return nodeManager;
    }

    public NodeManager getNodeManager(NodeId nodeId) throws StatusException {
        return this.getNodeManager(nodeId.getNamespaceIndex());
    }

    public NodeManager getNodeManager(String string) throws StatusException {
        return this.getNodeManager(this.getNamespaceTable().getIndex(string));
    }

    public NodeManagerRoot getNodeManagerRoot() {
        return this.hz.getNodeManagerRoot();
    }

    public UaNode getNodeOrExternal(NodeId nodeId) throws StatusException {
        try {
            UaNode uaNode = this.getNodeManager(nodeId).findNode(nodeId);
            if (uaNode == null) {
                return this.getExternalNode(nodeId);
            }
            return uaNode;
        }
        catch (StatusException statusException) {
            return this.kv.getNode(nodeId);
        }
    }

    @Override
    public FolderTypeNode getObjectsFolder() {
        return (FolderTypeNode)this.getNodeManagerRoot().getObjectsFolder();
    }

    @Override
    public FolderTypeNode getRoot() {
        return (FolderTypeNode)this.getNodeManagerRoot().getRoot();
    }

    public UaServer getServer() {
        return this.hz;
    }

    public ServerTable getServerTable() {
        return this.getEncoderContext().getServerTable();
    }

    public UaType getType(NodeId nodeId) throws StatusException {
        return (UaType)this.getNode(nodeId);
    }

    public boolean hasNode(NodeId nodeId) {
        try {
            return this.getNodeManager(nodeId).hasNode(nodeId);
        }
        catch (StatusException statusException) {
            return false;
        }
    }

    public boolean hasNodeManager(String string) {
        return this.kz.h(this.getNamespaceTable().getIndex(string)) != null;
    }

    public void invalidatePreviousNodeCaches() {
        this.kz.values().forEach(nodeManager -> nodeManager.invalidatePreviousNodeCache());
    }

    public boolean isTypeOf(NodeId nodeId, UaType uaType, NodeId nodeId2, UaType uaType2) throws StatusException {
        return this.getNodeManager(nodeId).getIsOfType(nodeId, uaType, nodeId2, uaType2);
    }

    @Override
    public void loadModel(InputStream inputStream) throws SAXException, IOException, ModelException {
        if (ku) {
            try {
                UaNodeSet uaNodeSet = UaNodeSet.parseXml(inputStream);
                this.loadModel(uaNodeSet);
            }
            catch (Exception exception) {
                throw new ModelException(exception.getMessage(), exception);
            }
        } else {
            this.loadModel(inputStream, null, false);
        }
    }

    public void loadModel(InputStream inputStream, Collection<ExpandedNodeId> collection, boolean bl) throws SAXException, ModelException, IOException {
        ModelParser modelParser = this.createModelParser();
        modelParser.setIgnoredNodes(collection);
        logger.debug("loadModel: Parsing XML");
        modelParser.parseFile(inputStream);
        logger.debug("loadModel: Creating model");
        try {
            modelParser.createModel(bl);
            logger.debug("loadModel: Completed");
        }
        catch (ServiceException serviceException) {
            logger.warn("Failed to load model from stream", (Throwable)serviceException);
            throw new RuntimeException(serviceException);
        }
    }

    public void loadModel(UaNodeSet ... uaNodeSetArray) throws UaException {
        this.loadModel(UaNodeSetLoadOptions.defaults(), uaNodeSetArray);
    }

    public void loadModel(UaNodeSetLoadOptions uaNodeSetLoadOptions, UaNodeSet ... uaNodeSetArray) throws UaException {
        for (UaNodeSet uaNodeSet : uaNodeSetArray) {
            if (!uaNodeSetLoadOptions.isIgnoreErrors() && uaNodeSet.getLog().getErrorCount() > 0L) {
                throw new UaNodeSetException("Given UaNodeSet(s) contained errors");
            }
            if (uaNodeSetLoadOptions.isIgnoreWarnings() || uaNodeSet.getLog().getWarningCount() <= 0L) continue;
            throw new UaNodeSetException("Given UaNodeSet(s) contained warnings");
        }
        a a2 = a.a(this.getEncoderContext(), uaNodeSetLoadOptions, uaNodeSetArray);
        a2.ckg().a(this, false);
    }

    @Override
    public void loadModel(URI uRI) throws SAXException, IOException, ModelException {
        logger.info("Loading model from {}", (Object)uRI);
        this.loadModel(uRI.toURL().openStream());
    }

    public synchronized void loadModel(URI uRI, Collection<ExpandedNodeId> collection, boolean bl) throws SAXException, IOException, ModelException {
        logger.info("Loading model from {}", (Object)uRI);
        ModelParser modelParser = this.createModelParser();
        modelParser.setIgnoredNodes(collection);
        logger.debug("loadModel: Parsing XML");
        modelParser.parseFile(uRI);
        logger.debug("loadModel: Creating model");
        try {
            modelParser.createModel(bl);
            logger.debug("loadModel: Completed");
        }
        catch (ServiceException serviceException) {
            logger.warn("Failed to load model from " + uRI, (Throwable)serviceException);
            throw new RuntimeException(serviceException);
        }
    }

    @Deprecated
    public void loadNodesFromXml(URL uRL, URL uRL2, Map<String, ModelParserForUaDefinedTypes.ParentDefinition> map) throws NumberFormatException, IllegalArgumentException, IOException, IllegalAccessException {
        this.loadNodesFromXml(uRL, uRL2, map, null);
    }

    @Deprecated
    public synchronized void loadNodesFromXml(URL uRL, URL uRL2, Map<String, ModelParserForUaDefinedTypes.ParentDefinition> map, String string) throws NumberFormatException, IllegalArgumentException, IOException, IllegalAccessException {
        ModelParserForUaDefinedTypes modelParserForUaDefinedTypes = new ModelParserForUaDefinedTypes(this, uRL, uRL2 == null ? ModelParserForUaDefinedTypes.getStandardIds() : ModelParserForUaDefinedTypes.getCsvIds(uRL2), this.getNamespaceTable(), map);
        modelParserForUaDefinedTypes.setTargetNamespace(string);
        List<Exception> list = modelParserForUaDefinedTypes.parseFile();
        for (Exception exception : list) {
            logger.error("Parsing error - " + uRL + " - ", (Throwable)exception);
        }
        if (list.isEmpty()) {
            try {
                modelParserForUaDefinedTypes.createModel();
            }
            catch (ServiceFaultException serviceFaultException) {
                logger.error("Model creation failed due to ServiceFaultException - " + uRL + " - ", (Throwable)serviceFaultException);
                return;
            }
            catch (ServiceResultException serviceResultException) {
                logger.error("Model creation failed due to ServiceResultException - " + uRL + " - ", (Throwable)serviceResultException);
                return;
            }
            catch (StatusException statusException) {
                logger.error("Model creation failed due to StatusException - " + uRL + " - ", (Throwable)statusException);
                return;
            }
        }
    }

    public NodeManager removeNodeManager(int n2) {
        return this.removeNodeManager(n2, true);
    }

    public NodeManager removeNodeManager(int n2, boolean bl) {
        if (bl) {
            this.getNamespaceTable().remove(n2);
            this.hz.updateNamespaceArray();
        }
        return this.kz.i(n2);
    }

    public void setListener(NodeManagerTableListener nodeManagerTableListener) {
        this.kx = nodeManagerTableListener;
    }

    public void setNodeBuilderConfiguration(UaNodeBuilderConfiguration uaNodeBuilderConfiguration) {
        this.kA.set(uaNodeBuilderConfiguration);
    }

    public void setNodeManagementEnabled(boolean bl) {
        this.ky = bl;
    }

    @Override
    public BrowsePathTarget[] translateBrowsePathToNodeIds(NodeId nodeId, RelativePath relativePath) throws StatusException, ServiceException {
        return this.translateBrowsePath(ServiceContext.INTERNAL_OPERATION_CONTEXT, nodeId, relativePath);
    }

    private void a(ServiceContext serviceContext, AddReferencesItem addReferencesItem, NodeId nodeId, ExpandedNodeId expandedNodeId, NodeId nodeId2, boolean bl, NodeClass nodeClass, String string) throws StatusException {
        this.getNodeManager(addReferencesItem.getSourceNodeId()).addReference(serviceContext, nodeId, expandedNodeId, nodeId2, bl, nodeClass, string);
    }

    protected NodeId addNode(ServiceContext serviceContext, AddNodesItem addNodesItem) throws StatusException {
        NodeAttributes nodeAttributes;
        ExpandedNodeId expandedNodeId = addNodesItem.getRequestedNewNodeId();
        NodeId nodeId = null;
        NodeId nodeId2 = null;
        try {
            try {
                nodeId = this.getNamespaceTable().toNodeId(expandedNodeId);
                try {
                    this.getNodeManager(nodeId);
                }
                catch (Exception exception) {
                    logger.debug("addNode: NodeManager for namespace {} not found: trying to create", (Object)expandedNodeId.getNamespaceUri());
                    this.createNewNodeManager(serviceContext, expandedNodeId.getNamespaceUri());
                }
            }
            catch (ServiceResultException serviceResultException) {
                logger.debug("addNode: NodeManager for namespace {} not found: trying to create", (Object)expandedNodeId.getNamespaceUri());
                this.createNewNodeManager(serviceContext, expandedNodeId.getNamespaceUri());
                nodeId = this.getNamespaceTable().toNodeId(expandedNodeId);
            }
        }
        catch (ServiceResultException serviceResultException) {
            logger.error("addNode: ", (Throwable)serviceResultException);
            throw new StatusException(StatusCodes.Bad_NodeIdInvalid);
        }
        try {
            nodeId2 = this.getNamespaceTable().toNodeId(addNodesItem.getParentNodeId());
        }
        catch (ServiceResultException serviceResultException) {
            logger.error("addNode: ", (Throwable)serviceResultException);
            throw new StatusException(StatusCodes.Bad_ParentNodeIdInvalid);
        }
        try {
            nodeAttributes = (NodeAttributes)addNodesItem.getNodeAttributes().decode(this.getEncoderContext());
        }
        catch (DecodingException decodingException) {
            logger.error("addNode: ", (Throwable)decodingException);
            throw new StatusException(StatusCodes.Bad_NodeAttributesInvalid);
        }
        ExpandedNodeId expandedNodeId2 = addNodesItem.getTypeDefinition();
        QualifiedName qualifiedName = addNodesItem.getBrowseName();
        NodeClass nodeClass = addNodesItem.getNodeClass();
        NodeId nodeId3 = addNodesItem.getReferenceTypeId();
        return this.addNode(serviceContext, nodeId, nodeId2, qualifiedName, nodeClass, expandedNodeId2, nodeAttributes, nodeId3);
    }

    protected NodeId addNode(ServiceContext serviceContext, NodeId nodeId, NodeId nodeId2, QualifiedName qualifiedName, NodeClass nodeClass, ExpandedNodeId expandedNodeId, NodeAttributes nodeAttributes, NodeId nodeId3) throws StatusException {
        return this.getNodeManager(nodeId).addNode(serviceContext, nodeId, nodeId2, qualifiedName, nodeClass, expandedNodeId, nodeAttributes, nodeId3);
    }

    protected void addReference(ServiceContext serviceContext, AddReferencesItem addReferencesItem) throws StatusException {
        NodeId nodeId = addReferencesItem.getSourceNodeId();
        ExpandedNodeId expandedNodeId = addReferencesItem.getTargetNodeId();
        NodeId nodeId2 = addReferencesItem.getReferenceTypeId();
        boolean bl = addReferencesItem.getIsForward();
        NodeClass nodeClass = addReferencesItem.getTargetNodeClass();
        String string = addReferencesItem.getTargetServerUri();
        this.a(serviceContext, addReferencesItem, nodeId, expandedNodeId, nodeId2, bl, nodeClass, string);
    }

    protected void afterCreateMonitoredDataItem(ServiceContext serviceContext, Subscription subscription, MonitoredDataItem monitoredDataItem) throws StatusException {
        this.getNodeManager(monitoredDataItem.getNodeId()).afterCreateMonitoredDataItem(serviceContext, subscription, monitoredDataItem);
    }

    protected void afterCreateMonitoredEventItem(ServiceContext serviceContext, Subscription subscription, MonitoredEventItem monitoredEventItem) throws StatusException {
        this.getNodeManager(monitoredEventItem.getNodeId()).afterCreateMonitoredEventItem(serviceContext, subscription, monitoredEventItem);
    }

    protected void afterDeleteMonitoredItem(ServiceContext serviceContext, Subscription subscription, MonitoredItem monitoredItem) throws StatusException {
        this.getNodeManager(monitoredItem.getNodeId()).afterDeleteMonitoredItem(serviceContext, subscription, monitoredItem);
    }

    protected void afterModifyMonitoredDataItem(ServiceContext serviceContext, Subscription subscription, MonitoredDataItem monitoredDataItem) throws StatusException {
        this.getNodeManager(monitoredDataItem.getNodeId()).afterModifyMonitoredDataItem(serviceContext, subscription, monitoredDataItem);
    }

    protected void afterModifyMonitoredEventItem(ServiceContext serviceContext, Subscription subscription, MonitoredEventItem monitoredEventItem) throws StatusException {
        this.getNodeManager(monitoredEventItem.getNodeId()).afterModifyMonitoredEventItem(serviceContext, subscription, monitoredEventItem);
    }

    protected BrowseContinuationPoint browseNode(ServiceContext serviceContext, List<ReferenceDescription> list, NodeId nodeId, int n2, BrowseDirection browseDirection, NodeId nodeId2, Boolean bl, QualifiedName qualifiedName, EnumSet<NodeClass> enumSet, EnumSet<BrowseResultMask> enumSet2, ViewDescription viewDescription, int n3) throws ServiceException, StatusException {
        return this.getNodeManager(nodeId).browseNode(serviceContext, list, nodeId, n2, browseDirection, nodeId2, bl, qualifiedName, enumSet, enumSet2, viewDescription, n3);
    }

    protected Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, NodeId nodeId2, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        logger.debug("callMethod: objectId={}; methodId={}", (Object)nodeId, (Object)nodeId2);
        logger.debug(" inputArguments={}", (Object)Arrays.toString(variantArray));
        return this.getNodeManager(nodeId).callMethod(serviceContext, nodeId, nodeId2, variantArray, statusCodeArray, diagnosticInfoArray);
    }

    protected void checkNodeManagementEnabled() throws ServiceException {
        if (!this.getNodeManagementEnabled()) {
            throw new ServiceException(StatusCodes.Bad_ServiceUnsupported);
        }
    }

    protected ModelParser createModelParser() {
        return new ModelParser(this);
    }

    protected void createMonitoredDataItem(ServiceContext serviceContext, Subscription subscription, NodeId nodeId, UnsignedInteger unsignedInteger, NumericRange numericRange, MonitoringParameters monitoringParameters, MonitoringFilter monitoringFilter, AggregateFilterResult aggregateFilterResult, MonitoringMode monitoringMode) throws StatusException {
        this.getNodeManager(nodeId).createMonitoredDataItem(serviceContext, subscription, nodeId, unsignedInteger, numericRange, monitoringParameters, monitoringFilter, aggregateFilterResult, monitoringMode);
    }

    protected void createMonitoredEventItem(ServiceContext serviceContext, Subscription subscription, NodeId nodeId, EventFilter eventFilter, EventFilterResult eventFilterResult) throws StatusException {
        this.getNodeManager(nodeId).createMonitoredEventItem(serviceContext, subscription, nodeId, eventFilter, eventFilterResult);
    }

    protected void createNewNodeManager(ServiceContext serviceContext, String string) throws StatusException {
        NodeManager nodeManager;
        if (serviceContext.isInternal() || this.getNodeManagementEnabled()) {
            nodeManager = this.hz.createNewNodeManager(serviceContext, string);
            if (nodeManager == null) {
                throw new StatusException(StatusCodes.Bad_NodeIdRejected);
            }
        } else {
            throw new StatusException(StatusCodes.Bad_NodeIdRejected);
        }
        int n2 = nodeManager.getNamespaceIndex();
        this.addNodeManager(n2, nodeManager);
        this.hz.updateNamespaceArray();
        logger.debug("createNewNodeManager: newNodeManager={}", (Object)nodeManager);
    }

    protected void deleteMonitoredItem(ServiceContext serviceContext, Subscription subscription, MonitoredItem monitoredItem) throws StatusException {
        this.getNodeManager(monitoredItem.getNodeId()).deleteMonitoredItem(serviceContext, subscription, monitoredItem);
    }

    protected void deleteNode(ServiceContext serviceContext, ExpandedNodeId expandedNodeId, boolean bl) throws StatusException {
        NodeId nodeId;
        try {
            nodeId = this.getNamespaceTable().toNodeId(expandedNodeId);
        }
        catch (ServiceResultException serviceResultException) {
            throw new StatusException(StatusCodes.Bad_NodeIdInvalid);
        }
        this.getNodeManager(expandedNodeId).deleteNode(serviceContext, nodeId, bl);
    }

    protected void deleteNode(ServiceContext serviceContext, NodeId nodeId, Boolean bl) throws StatusException {
        this.getNodeManager(nodeId).deleteNode(serviceContext, nodeId, bl);
    }

    protected void deleteReference(ServiceContext serviceContext, NodeId nodeId, ExpandedNodeId expandedNodeId, NodeId nodeId2, Boolean bl, Boolean bl2) throws StatusException {
        this.getNodeManager(nodeId).deleteReference(serviceContext, nodeId, expandedNodeId, nodeId2, bl, bl2);
        if (!this.getNamespaceTable().namespaceEquals(nodeId, expandedNodeId)) {
            this.getNodeManager(expandedNodeId).deleteReference(serviceContext, nodeId, expandedNodeId, nodeId2, bl, bl2);
        }
    }

    protected HistoryResult historyRead(ServiceContext serviceContext, Object object, TimestampsToReturn timestampsToReturn, NodeId nodeId, NumericRange numericRange, HistoryContinuationPoint historyContinuationPoint, HistoryReadDetails historyReadDetails, int n2) throws StatusException {
        return this.getHistoryManager(nodeId).historyRead(serviceContext, object, timestampsToReturn, nodeId, numericRange, historyContinuationPoint, historyReadDetails, n2);
    }

    protected void historyUpdate(ServiceContext serviceContext, Object object, HistoryUpdateDetails historyUpdateDetails, HistoryUpdateResult historyUpdateResult) throws StatusException {
        this.getHistoryManager(HistoryManager.getNodeIdFromHistoryUpdateDetails(historyUpdateDetails)).historyUpdate(serviceContext, object, historyUpdateDetails, historyUpdateResult);
    }

    protected void init() throws StatusException, UaNodeFactoryException {
        for (NodeManager nodeManager : this.kz.values()) {
            logger.debug("Initializing NodeManager: {}", (Object)nodeManager);
            nodeManager.init();
        }
    }

    protected void initializeMonitoredDataItem(ServiceContext serviceContext, MonitoredDataItem monitoredDataItem, DataValue dataValue) throws StatusException {
        this.getIoManager(monitoredDataItem.getNodeId()).initializeMonitoredDataItem(serviceContext, monitoredDataItem, dataValue);
    }

    protected void modifyMonitoredDataItem(ServiceContext serviceContext, Subscription subscription, MonitoredDataItem monitoredDataItem, MonitoringParameters monitoringParameters, MonitoringFilter monitoringFilter, AggregateFilterResult aggregateFilterResult) throws StatusException {
        this.getNodeManager(monitoredDataItem.getNodeId()).modifyMonitoredDataItem(serviceContext, subscription, monitoredDataItem, monitoringParameters, monitoringFilter, aggregateFilterResult);
    }

    protected void modifyMonitoredEventItem(ServiceContext serviceContext, Subscription subscription, MonitoredEventItem monitoredEventItem, EventFilter eventFilter, EventFilterResult eventFilterResult) throws StatusException {
        this.getNodeManager(monitoredEventItem.getNodeId()).modifyMonitoredEventItem(serviceContext, subscription, monitoredEventItem, eventFilter, eventFilterResult);
    }

    protected void queryFirst(ServiceContext serviceContext, QueryFirstRequest queryFirstRequest, QueryFirstResponse queryFirstResponse) throws ServiceException {
        if (this.kx == null) {
            throw new ServiceException(StatusCodes.Bad_NotImplemented);
        }
        this.kx.queryFirst(serviceContext, queryFirstRequest, queryFirstResponse);
    }

    protected void queryNext(ServiceContext serviceContext, QueryNextRequest queryNextRequest, QueryNextResponse queryNextResponse) throws ServiceException {
        if (this.kx == null) {
            throw new ServiceException(StatusCodes.Bad_NotImplemented);
        }
        this.kx.queryNext(serviceContext, queryNextRequest, queryNextResponse);
    }

    protected void readAttribute(ServiceContext serviceContext, Object object, NodeId nodeId, UnsignedInteger unsignedInteger, NumericRange numericRange, TimestampsToReturn timestampsToReturn, DateTime dateTime, DataValue dataValue) throws StatusException {
        this.getIoManager(nodeId).readAttribute(serviceContext, object, nodeId, unsignedInteger, numericRange, timestampsToReturn, dateTime, dataValue);
    }

    protected NodeId registerNode(ServiceContext serviceContext, NodeId nodeId) throws StatusException {
        return this.getNodeManager(nodeId).registerNode(serviceContext, nodeId);
    }

    protected void releaseHistoryContinuationPoint(ServiceContext serviceContext, NodeId nodeId, ByteString byteString) throws StatusException {
        this.getHistoryManager(nodeId).releaseHistoryContinuationPoint(serviceContext, nodeId, byteString);
    }

    protected void start() throws StatusException, UaNodeFactoryException {
        for (NodeManager nodeManager : this.kz.values()) {
            nodeManager.start();
        }
    }

    protected BrowsePathTarget[] translateBrowsePath(ServiceContext serviceContext, NodeId nodeId, RelativePath relativePath) throws StatusException, ServiceException {
        return this.getNodeManager(nodeId).translateBrowsePath(serviceContext, nodeId, relativePath);
    }

    protected void unregisterNode(ServiceContext serviceContext, NodeId nodeId) throws StatusException {
        this.getNodeManager(nodeId).unregisterNode(serviceContext, nodeId);
    }

    protected boolean writeAttribute(ServiceContext serviceContext, Object object, NodeId nodeId, UnsignedInteger unsignedInteger, NumericRange numericRange, DataValue dataValue) throws StatusException {
        return this.getIoManager(nodeId).writeAttribute(serviceContext, object, nodeId, unsignedInteger, numericRange, dataValue);
    }

    b cku() {
        return this.kz;
    }

    @Deprecated
    public static class ModelParserForUaDefinedTypes
    extends DefaultHandler {
        private static final ExpandedNodeId kC = new ExpandedNodeId(Identifiers.PropertyType);
        private static Map<String, PredefinedIdPair> kD = null;
        private static final Logger logger = LoggerFactory.getLogger(ModelParserForUaDefinedTypes.class);
        private static Map<Object, String> kE = null;
        private List<Argument> kF;
        private String kG;
        private AddReferencesItem kH;
        private Locale defaultLocale;
        private List<a> kI;
        private final EncoderContext at;
        private final NodeManagerTable kJ;
        private String kK;
        private List<NamespacePair> kL;
        private final NamespaceTable iX;
        private List<NodeAttributes> kM;
        private List<AddNodesItem> kN;
        private List<AddNodesItem> kO;
        private Map<String, ParentDefinition> kP;
        private final List<Exception> kQ;
        private final Map<String, PredefinedIdPair> kR;
        private String kS;
        private boolean aT;
        private boolean kT;
        private List<AddReferencesItem> kU;
        private List<String> kV;
        private String targetNamespace;
        private final URL kW;

        public static Map<String, PredefinedIdPair> getCsvIds(URL uRL) throws NumberFormatException, IllegalArgumentException, IOException {
            HashMap<String, PredefinedIdPair> hashMap = new HashMap<String, PredefinedIdPair>();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                String[] stringArray = string.split(",");
                try {
                    hashMap.put(stringArray[0], new PredefinedIdPair(new UnsignedInteger(Integer.parseInt(stringArray[1])), NodeClass.valueOf(stringArray[2])));
                }
                catch (NumberFormatException numberFormatException) {
                    hashMap.put(stringArray[0], new PredefinedIdPair(stringArray[1], NodeClass.valueOf(stringArray[2])));
                }
            }
            return hashMap;
        }

        public static synchronized Map<String, PredefinedIdPair> getIdentifierPairs() {
            if (kD == null) {
                Field[] fieldArray;
                kD = new ConcurrentHashMap<String, PredefinedIdPair>();
                Class<Identifiers> clazz = Identifiers.class;
                for (Field field : fieldArray = clazz.getFields()) {
                    Object object;
                    try {
                        object = field.get(null);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        continue;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        continue;
                    }
                    if (!(object instanceof NodeId)) continue;
                    kD.put(field.getName(), new PredefinedIdPair(((NodeId)object).getValue(), null));
                }
            }
            return kD;
        }

        public static synchronized Map<Object, String> getReverseIdentifierPairs() {
            if (kE == null) {
                Field[] fieldArray;
                kE = new ConcurrentHashMap<Object, String>();
                Class<Identifiers> clazz = Identifiers.class;
                for (Field field : fieldArray = clazz.getFields()) {
                    Object object;
                    try {
                        object = field.get(null);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        continue;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        continue;
                    }
                    if (!(object instanceof NodeId)) continue;
                    kE.put(((NodeId)object).getValue(), field.getName());
                }
            }
            return kE;
        }

        public static Map<String, PredefinedIdPair> getStandardIds() throws IOException, IllegalArgumentException, IllegalAccessException {
            return ModelParserForUaDefinedTypes.getIdentifierPairs();
        }

        public ModelParserForUaDefinedTypes(NodeManagerTable nodeManagerTable, URL uRL, Map<String, PredefinedIdPair> map, NamespaceTable namespaceTable) {
            this.kJ = nodeManagerTable;
            this.at = nodeManagerTable.getEncoderContext();
            this.kW = uRL;
            this.kR = map;
            this.iX = namespaceTable;
            this.kQ = new ArrayList<Exception>();
        }

        public ModelParserForUaDefinedTypes(NodeManagerTable nodeManagerTable, URL uRL, Map<String, PredefinedIdPair> map, NamespaceTable namespaceTable, Map<String, ParentDefinition> map2) {
            this(nodeManagerTable, uRL, map, namespaceTable);
            this.kP = map2;
        }

        @Override
        public void characters(char[] cArray, int n2, int n3) throws SAXException {
            if (this.aT) {
                this.kS = this.kS + new String(cArray, n2, n3);
            }
        }

        public void createModel() throws ServiceResultException, StatusException {
            ArrayList<AddNodesItem> arrayList = new ArrayList<AddNodesItem>();
            for (AddNodesItem abstractStructure : this.kO) {
                if (abstractStructure.getNodeClass().equals(NodeClass.ReferenceType)) {
                    this.kJ.addNode(ServiceContext.INTERNAL_OPERATION_CONTEXT, abstractStructure);
                    continue;
                }
                arrayList.add(abstractStructure);
            }
            for (AddNodesItem addNodesItem : arrayList) {
                this.kJ.addNode(ServiceContext.INTERNAL_OPERATION_CONTEXT, addNodesItem);
            }
            for (AddReferencesItem addReferencesItem : this.kU) {
                this.kJ.addReference(ServiceContext.INTERNAL_OPERATION_CONTEXT, addReferencesItem);
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            a a2 = a.valueOf(string2);
            switch (a2) {
                case lr: 
                case lz: 
                case lw: 
                case lb: 
                case lm: 
                case lq: 
                case ly: 
                case lt: 
                case lA: 
                case lk: 
                case ls: {
                    Object object;
                    if (a2 == a.lw && this.aT && this.kN.size() != 0) {
                        ExpandedNodeId expandedNodeId = this.s(this.kS);
                        try {
                            this.kH.setReferenceTypeId(this.iX.toNodeId(expandedNodeId));
                        }
                        catch (ServiceResultException serviceResultException) {
                            this.a(serviceResultException);
                        }
                        this.aT = false;
                        break;
                    }
                    if (a2.equals((Object)a.lk) || a2.equals((Object)a.ls)) {
                        object = this.kF.toArray(new Argument[0]);
                        ((VariableAttributes)this.ckz()).setValue(object);
                        ((VariableAttributes)this.ckz()).setValueRank(1);
                        ((VariableAttributes)this.ckz()).setArrayDimensions(new UnsignedInteger[]{new UnsignedInteger(((Argument[])object).length)});
                    }
                    object = null;
                    try {
                        object = ExtensionObject.binaryEncode(this.ckz(), this.at);
                    }
                    catch (EncodingException encodingException) {
                        this.a(encodingException);
                    }
                    this.ckB().setNodeAttributes((ExtensionObject)object);
                    AddNodesItem addNodesItem = this.ckG();
                    if (a.valueOf(string2) == a.lt) {
                        addNodesItem.setTypeDefinition(this.iX.toExpandedNodeId(Identifiers.PropertyType));
                    }
                    this.kO.add(addNodesItem);
                    this.ckH();
                    this.ckE();
                    break;
                }
                case kY: {
                    if (this.aT) {
                        this.ckB().setBrowseName(new QualifiedName(this.kS));
                    }
                    this.aT = false;
                    break;
                }
                case lf: {
                    if (this.aT) {
                        this.ckz().setDisplayName(new LocalizedText(this.kS, this.defaultLocale));
                    }
                    this.aT = false;
                    break;
                }
                case lc: {
                    this.aT = false;
                    break;
                }
                case ll: {
                    if (this.aT) {
                        ((ReferenceTypeAttributes)this.ckz()).setInverseName(new LocalizedText(this.kS, this.defaultLocale));
                    }
                    this.aT = false;
                    break;
                }
                case ld: {
                    if (this.aT) {
                        if (this.g(2).equals((Object)a.kX)) {
                            this.cky().setDescription(new LocalizedText(this.kS, this.defaultLocale));
                        } else {
                            this.ckz().setDescription(new LocalizedText(this.kS, this.defaultLocale));
                        }
                    }
                    this.aT = false;
                    break;
                }
                case lu: {
                    ExpandedNodeId expandedNodeId = this.ckB().getRequestedNewNodeId();
                    ExpandedNodeId expandedNodeId2 = this.kH.getTargetNodeId();
                    AddReferencesItem addReferencesItem = this.kH.clone();
                    try {
                        logger.debug("sourceId={}", (Object)expandedNodeId);
                        addReferencesItem.setSourceNodeId(this.toNodeId(expandedNodeId));
                    }
                    catch (ServiceResultException serviceResultException) {
                        this.a(serviceResultException);
                        break;
                    }
                    addReferencesItem.setTargetNodeId(expandedNodeId2);
                    this.kU.add(addReferencesItem);
                    break;
                }
                case lx: {
                    if (!this.aT) break;
                    this.kH.setTargetNodeId(this.s(this.kS));
                    this.aT = false;
                    break;
                }
                case ln: {
                    break;
                }
                case lo: {
                    if (!this.aT) break;
                    try {
                        this.b(this.kG, this.kS);
                    }
                    catch (Exception exception) {
                        this.a(exception);
                    }
                    this.aT = false;
                    break;
                }
                case kX: {
                    break;
                }
                case kZ: {
                    break;
                }
                case lp: {
                    break;
                }
                case lv: {
                    break;
                }
                case le: {
                    break;
                }
                case la: {
                    break;
                }
                case lj: {
                    break;
                }
                case lh: {
                    break;
                }
                case li: {
                    break;
                }
            }
            this.ckF();
        }

        public List<Exception> parseFile() {
            InputStreamReader inputStreamReader;
            XMLReader xMLReader;
            this.kF = new ArrayList<Argument>();
            this.kO = new ArrayList<AddNodesItem>();
            this.kU = new ArrayList<AddReferencesItem>();
            this.kI = new ArrayList<a>();
            this.kM = new ArrayList<NodeAttributes>();
            this.kN = new ArrayList<AddNodesItem>();
            this.kV = new ArrayList<String>();
            this.defaultLocale = Locale.ENGLISH;
            if (this.targetNamespace == null) {
                this.targetNamespace = "http://opcfoundation.org/UA/";
            }
            this.kL = new ArrayList<NamespacePair>();
            try {
                xMLReader = XMLReaderFactory.createXMLReader();
            }
            catch (Exception exception) {
                this.a(exception);
                return this.kQ;
            }
            logger.debug("XMLReader class: {}", xMLReader.getClass());
            xMLReader.setContentHandler(this);
            xMLReader.setErrorHandler(this);
            try {
                inputStreamReader = new InputStreamReader(this.kW.openStream());
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.a(fileNotFoundException);
                return this.kQ;
            }
            catch (IOException iOException) {
                this.a(iOException);
                return this.kQ;
            }
            try {
                xMLReader.parse(new InputSource(inputStreamReader));
            }
            catch (Exception exception) {
                logger.error("Exception while parsing", (Throwable)exception);
                return this.kQ;
            }
            return this.kQ;
        }

        public void setTargetNamespace(String string) {
            this.targetNamespace = string;
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            a a2 = a.valueOf(string2);
            this.a(a2);
            switch (a2) {
                case lr: {
                    this.a(attributes, this.H(attributes), NodeClass.ObjectType);
                    break;
                }
                case lz: {
                    this.a(attributes, this.K(attributes), NodeClass.VariableType);
                    break;
                }
                case lw: {
                    if (this.ckB() != null) {
                        this.p();
                        break;
                    }
                    this.a(attributes, this.I(attributes), NodeClass.ReferenceType);
                    break;
                }
                case lb: {
                    this.a(attributes, this.D(attributes), NodeClass.DataType);
                    break;
                }
                case lm: {
                    this.a(attributes, this.E(attributes), NodeClass.Method);
                    break;
                }
                case lq: {
                    this.a(attributes, this.G(attributes), NodeClass.Object);
                    break;
                }
                case ly: {
                    VariableAttributes variableAttributes = this.C(attributes);
                    this.a(attributes, variableAttributes, NodeClass.Variable);
                    break;
                }
                case lt: {
                    VariableAttributes variableAttributes = this.C(attributes);
                    this.a(attributes, variableAttributes, NodeClass.Variable, kC);
                    break;
                }
                case lA: {
                    this.a(attributes, this.L(attributes), NodeClass.View);
                    break;
                }
                case kY: {
                    this.p();
                    break;
                }
                case lf: {
                    this.p();
                    break;
                }
                case lc: {
                    this.p();
                    break;
                }
                case ll: {
                    this.p();
                    break;
                }
                case ld: {
                    this.p();
                    break;
                }
                case lu: {
                    this.kH = this.y(attributes);
                    break;
                }
                case lx: {
                    this.p();
                    break;
                }
                case ln: {
                    for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
                        if (!attributes.getLocalName(i2).equalsIgnoreCase("TargetNamespace")) continue;
                        this.targetNamespace = attributes.getValue(i2);
                    }
                    break;
                }
                case lo: {
                    this.F(attributes);
                    this.p();
                    break;
                }
                case lk: {
                    this.ckv();
                    this.kF.clear();
                    break;
                }
                case ls: {
                    this.ckw();
                    this.kF.clear();
                    break;
                }
                case kX: {
                    this.x(attributes);
                    break;
                }
                case kZ: {
                    break;
                }
                case lp: {
                    break;
                }
                case lv: {
                    break;
                }
                case le: {
                    break;
                }
                case la: {
                    break;
                }
                case lj: {
                    break;
                }
                case lh: {
                    break;
                }
                case li: {
                    break;
                }
            }
        }

        private void a(Exception exception) {
            this.kQ.add(exception);
        }

        private void x(Attributes attributes) {
            Argument argument;
            String string = null;
            String string2 = null;
            for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
                if (attributes.getLocalName(i2).equalsIgnoreCase("Name")) {
                    string = attributes.getValue(i2);
                }
                if (!attributes.getLocalName(i2).equalsIgnoreCase("DataType")) continue;
                string2 = attributes.getValue(i2);
            }
            try {
                argument = new Argument(string, this.iX.toNodeId(this.s(string2)), -1, null, null);
            }
            catch (ServiceResultException serviceResultException) {
                this.kQ.add(new Exception("Unable to get a data type for argument=" + string + ", data type=" + string2));
                return;
            }
            this.a(argument);
        }

        private void ckv() {
            VariableAttributes variableAttributes = new VariableAttributes();
            variableAttributes.setDataType(Identifiers.Argument);
            this.a(variableAttributes);
            ExpandedNodeId expandedNodeId = this.ckB().getRequestedNewNodeId();
            String string = this.ckx() + "_InputArguments";
            ExpandedNodeId expandedNodeId2 = new ExpandedNodeId(new UnsignedInteger(0), this.targetNamespace, this.kR.get(string).getId());
            ExpandedNodeId expandedNodeId3 = this.iX.toExpandedNodeId(Identifiers.PropertyType);
            NodeId nodeId = Identifiers.HasProperty;
            AddNodesItem addNodesItem = new AddNodesItem(expandedNodeId, nodeId, expandedNodeId2, new QualifiedName(0, "InputArguments"), NodeClass.Variable, null, expandedNodeId3);
            this.d(addNodesItem);
            this.t(this.kK);
        }

        private void a(Attributes attributes, NodeAttributes nodeAttributes, NodeClass nodeClass) {
            ExpandedNodeId expandedNodeId = this.B(attributes);
            this.a(attributes, nodeAttributes, nodeClass, expandedNodeId);
        }

        private void a(Attributes attributes, NodeAttributes nodeAttributes, NodeClass nodeClass, ExpandedNodeId expandedNodeId) {
            ExtensionObject extensionObject;
            if (nodeAttributes == null) {
                return;
            }
            this.a(nodeAttributes);
            ExpandedNodeId expandedNodeId2 = this.a(nodeClass, attributes);
            ExpandedNodeId expandedNodeId3 = this.A(attributes);
            NodeId nodeId = this.b(nodeClass, expandedNodeId);
            try {
                extensionObject = ExtensionObject.binaryEncode(nodeAttributes, this.at);
            }
            catch (EncodingException encodingException) {
                logger.error("EncodingException: ", (Throwable)encodingException);
                extensionObject = null;
            }
            AddNodesItem addNodesItem = new AddNodesItem(expandedNodeId2, nodeId, expandedNodeId3, this.z(attributes), nodeClass, extensionObject, expandedNodeId);
            this.d(addNodesItem);
            this.t(this.kK);
        }

        private void ckw() {
            VariableAttributes variableAttributes = new VariableAttributes();
            variableAttributes.setDataType(Identifiers.Argument);
            this.a(variableAttributes);
            ExpandedNodeId expandedNodeId = this.ckB().getRequestedNewNodeId();
            String string = this.ckB().getBrowseName().getName() + "_OutputArguments";
            ExpandedNodeId expandedNodeId2 = new ExpandedNodeId(new UnsignedInteger(0), this.targetNamespace, this.kR.get(string).getId());
            ExpandedNodeId expandedNodeId3 = this.iX.toExpandedNodeId(Identifiers.PropertyType);
            NodeId nodeId = Identifiers.HasProperty;
            AddNodesItem addNodesItem = new AddNodesItem(expandedNodeId, nodeId, expandedNodeId2, new QualifiedName(0, "OutputArguments"), NodeClass.Variable, null, expandedNodeId3);
            this.d(addNodesItem);
            this.t(this.kK);
        }

        private void b(String string, String string2) throws Exception {
            this.iX.add(-1, string2);
        }

        private AddReferencesItem y(Attributes attributes) {
            boolean bl = false;
            boolean bl2 = true;
            for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
                if (attributes.getLocalName(i2).equalsIgnoreCase("IsInverse")) {
                    bl = Boolean.parseBoolean(attributes.getValue(i2));
                }
                if (!attributes.getLocalName(i2).equalsIgnoreCase("IsOneWay")) continue;
                bl2 = Boolean.parseBoolean(attributes.getValue(i2));
            }
            this.kT = bl2;
            AddReferencesItem addReferencesItem = new AddReferencesItem(null, null, !bl, null, null, null);
            return addReferencesItem;
        }

        private ExpandedNodeId c(NodeClass nodeClass) {
            NodeId nodeId = this.d(nodeClass);
            return new ExpandedNodeId(new UnsignedInteger(0), nodeId.getNamespaceIndex(), nodeId.getValue());
        }

        private NodeId d(NodeClass nodeClass) {
            switch (nodeClass) {
                case Object: {
                    return Identifiers.ObjectsFolder;
                }
                case Variable: {
                    this.a(new Exception("No default parent id for Variables"));
                    return NodeId.NULL;
                }
                case Method: {
                    return Identifiers.ObjectTypesFolder;
                }
                case ObjectType: {
                    return Identifiers.BaseObjectType;
                }
                case VariableType: {
                    return Identifiers.BaseVariableType;
                }
                case ReferenceType: {
                    return Identifiers.ReferenceTypesFolder;
                }
                case DataType: {
                    return Identifiers.DataTypesFolder;
                }
                case View: {
                    return Identifiers.ViewsFolder;
                }
            }
            return NodeId.NULL;
        }

        private NodeId a(NodeClass nodeClass, ExpandedNodeId expandedNodeId) {
            if (kC.equals(expandedNodeId)) {
                return Identifiers.HasProperty;
            }
            switch (nodeClass) {
                case ObjectType: 
                case VariableType: 
                case ReferenceType: 
                case DataType: {
                    return Identifiers.HasSubtype;
                }
                case Object: 
                case Variable: 
                case Method: {
                    return Identifiers.HasComponent;
                }
                case View: {
                    return Identifiers.Organizes;
                }
            }
            return null;
        }

        private QualifiedName z(Attributes attributes) {
            for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
                if (!attributes.getLocalName(i2).equalsIgnoreCase("SymbolicName")) continue;
                String[] stringArray = attributes.getValue(i2).split(":");
                return new QualifiedName(stringArray[stringArray.length - 1]);
            }
            return new QualifiedName("");
        }

        private NodeId a(int n2, String string) {
            Object object = this.kR.get(string).getId();
            if (object instanceof UnsignedInteger) {
                return new NodeId(n2, (UnsignedInteger)object);
            }
            if (object instanceof String) {
                return new NodeId(n2, (String)object);
            }
            throw new RuntimeException("Other Id types than UnsignedIntegers and Strings are not yet supported");
        }

        private ExpandedNodeId A(Attributes attributes) {
            String string = attributes.getValue("", "SymbolicName");
            if (string == null) {
                return ExpandedNodeId.NULL;
            }
            String[] stringArray = string.split(":");
            String string2 = stringArray[stringArray.length - 1];
            StringBuilder stringBuilder = new StringBuilder();
            for (int i2 = 0; i2 < this.kN.size(); ++i2) {
                String[] stringArray2 = this.kV.get(i2).split(":");
                String string3 = stringArray2[stringArray2.length - 1];
                stringBuilder.append(string3);
                stringBuilder.append("_");
            }
            stringBuilder.append(string2);
            String string4 = stringBuilder.toString();
            try {
                return new ExpandedNodeId(UnsignedInteger.ZERO, this.targetNamespace, this.kR.get(string4).getId());
            }
            catch (Exception exception) {
                this.a(new RuntimeException("NodeId not found for designId=" + string4, exception));
                return null;
            }
        }

        private ExpandedNodeId a(NodeClass nodeClass, Attributes attributes) {
            Object object;
            ParentDefinition parentDefinition;
            ExpandedNodeId expandedNodeId = null;
            if (this.kP != null && (parentDefinition = this.kP.get(this.kK)) != null && (object = parentDefinition.getParent()) != null) {
                return this.iX.toExpandedNodeId((NodeId)object);
            }
            for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
                if (!attributes.getLocalName(i2).equalsIgnoreCase("BaseType")) continue;
                object = attributes.getValue(i2).replaceAll("tns:", "");
                expandedNodeId = this.iX.toExpandedNodeId(this.a(0, (String)object));
                break;
            }
            if (expandedNodeId != null) {
                return expandedNodeId;
            }
            if (this.kN.size() > 0) {
                expandedNodeId = this.ckB().getRequestedNewNodeId();
            }
            if (expandedNodeId != null) {
                return expandedNodeId;
            }
            String[] stringArray = this.kK.split("_");
            if (stringArray.length > 1) {
                object = this.kK.replaceAll("_" + stringArray[stringArray.length - 1], "").replaceAll("tns:", "");
                try {
                    expandedNodeId = new ExpandedNodeId(this.a(0, (String)object));
                }
                catch (Exception exception) {
                    try {
                        new ExpandedNodeId(this.a(0, (String)object + "Type"));
                    }
                    catch (Exception exception2) {
                        this.a(new Exception("Unable to find implicit parent " + (String)object));
                        expandedNodeId = this.iX.toExpandedNodeId(this.d(this.ckB().getNodeClass()));
                    }
                }
            }
            if (expandedNodeId != null) {
                return expandedNodeId;
            }
            expandedNodeId = this.c(nodeClass);
            return expandedNodeId;
        }

        private NodeId b(NodeClass nodeClass, ExpandedNodeId expandedNodeId) {
            NodeId nodeId;
            ParentDefinition parentDefinition;
            if (this.kP != null && (parentDefinition = this.kP.get(this.kK)) != null && (nodeId = parentDefinition.getParentReferenceType()) != null) {
                return nodeId;
            }
            return this.a(nodeClass, expandedNodeId);
        }

        private String ckx() {
            if (this.kV.size() != 0) {
                StringBuilder stringBuilder = new StringBuilder();
                for (int i2 = 0; i2 < this.kV.size(); ++i2) {
                    String[] stringArray = this.kV.get(i2).split(":");
                    String string = stringArray[stringArray.length - 1];
                    if (i2 > 0) {
                        stringBuilder.append("_");
                    }
                    stringBuilder.append(string);
                }
                return stringBuilder.toString();
            }
            return null;
        }

        private ExpandedNodeId B(Attributes attributes) {
            String string = null;
            for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
                String string2 = attributes.getLocalName(i2);
                if (!string2.equalsIgnoreCase("TypeDefinition")) continue;
                string = attributes.getValue(i2);
            }
            if (string == null) {
                return null;
            }
            return this.s(string);
        }

        private ExpandedNodeId s(String string) {
            String[] stringArray = string.split(":");
            if (stringArray.length == 1) {
                return new ExpandedNodeId(this.a(this.iX.getIndex(this.targetNamespace), string));
            }
            if (stringArray.length == 2) {
                if (stringArray[0].equals("ua") || stringArray[0].equals("tns")) {
                    NodeId nodeId = IdentifierDescriptions.toNodeId(stringArray[1]);
                    return new ExpandedNodeId(new UnsignedInteger(0), "http://opcfoundation.org/UA/", nodeId.getValue());
                }
                return new ExpandedNodeId(this.a(this.iX.getIndex(this.targetNamespace), stringArray[1]));
            }
            return ExpandedNodeId.NULL;
        }

        private VariableAttributes C(Attributes attributes) {
            VariableAttributes variableAttributes;
            try {
                variableAttributes = this.J(attributes);
            }
            catch (ServiceResultException serviceResultException) {
                logger.error("ServiceResultException: ", (Throwable)serviceResultException);
                return null;
            }
            if (variableAttributes.getAccessLevel() == null || variableAttributes.getAccessLevel().intValue() == 0) {
                variableAttributes.setAccessLevel((UnsignedByte)AccessLevels.READ_ONLY.asBuiltInType());
            }
            return variableAttributes;
        }

        private Variant parseVariant(String string, NodeId nodeId) {
            return this.kJ.getNodeManagerRoot().getDataTypeConverter().parseVariant(string, nodeId);
        }

        private Argument cky() {
            if (this.kF.size() != 0) {
                return this.kF.get(this.kF.size() - 1);
            }
            return null;
        }

        private NodeAttributes ckz() {
            if (this.kM.size() != 0) {
                return this.kM.get(this.kM.size() - 1);
            }
            return null;
        }

        private a ckA() {
            if (this.kI.size() != 0) {
                return this.kI.get(this.kI.size() - 1);
            }
            return null;
        }

        private a g(int n2) {
            if (this.kI.size() >= n2) {
                return this.kI.get(this.kI.size() - n2);
            }
            return null;
        }

        private AddNodesItem ckB() {
            if (this.kN.size() != 0) {
                return this.kN.get(this.kN.size() - 1);
            }
            return null;
        }

        private String ckC() {
            if (this.kV.size() != 0) {
                return this.kV.get(this.kV.size() - 1);
            }
            return null;
        }

        private Argument ckD() {
            Argument argument = this.cky();
            if (argument != null) {
                this.kF.remove(argument);
            }
            return argument;
        }

        private NodeAttributes ckE() {
            NodeAttributes nodeAttributes = this.ckz();
            if (nodeAttributes != null) {
                this.kM.remove(nodeAttributes);
            }
            return nodeAttributes;
        }

        private a ckF() {
            a a2 = this.ckA();
            if (a2 != null) {
                this.kI.remove((Object)a2);
            }
            return a2;
        }

        private AddNodesItem ckG() {
            AddNodesItem addNodesItem = this.ckB();
            if (addNodesItem != null) {
                this.kN.remove(addNodesItem);
            }
            return addNodesItem;
        }

        private String ckH() {
            String string = this.ckC();
            if (string != null) {
                this.kV.remove(string);
            }
            return string;
        }

        private void p() {
            this.aT = true;
            this.kS = "";
        }

        private void a(Argument argument) {
            this.kF.add(argument);
        }

        private void a(NodeAttributes nodeAttributes) {
            this.kM.add(nodeAttributes);
        }

        private void a(a a2) {
            this.kI.add(a2);
        }

        private void d(AddNodesItem addNodesItem) {
            this.ckB();
            this.kN.add(addNodesItem);
        }

        private void t(String string) {
            this.kV.add(string);
        }

        private DataTypeAttributes D(Attributes attributes) {
            DataTypeAttributes dataTypeAttributes = new DataTypeAttributes();
            for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
                if (!attributes.getLocalName(i2).equalsIgnoreCase("IsAbstract")) continue;
                dataTypeAttributes.setIsAbstract(Boolean.parseBoolean(attributes.getValue(i2)));
            }
            this.a(dataTypeAttributes, attributes);
            return dataTypeAttributes;
        }

        private MethodAttributes E(Attributes attributes) {
            MethodAttributes methodAttributes = new MethodAttributes();
            for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
                if (!attributes.getLocalName(i2).equalsIgnoreCase("NonExecutable")) continue;
                methodAttributes.setExecutable(!Boolean.parseBoolean(attributes.getValue(i2)));
            }
            this.a(methodAttributes, attributes);
            return methodAttributes;
        }

        private void F(Attributes attributes) {
            for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
                if (!attributes.getLocalName(i2).equalsIgnoreCase("Name")) continue;
                this.kG = attributes.getValue(i2);
            }
        }

        private void a(NodeAttributes nodeAttributes, Attributes attributes) {
            for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
                if (attributes.getLocalName(i2).equalsIgnoreCase("SymbolicName")) {
                    this.kK = attributes.getValue(i2);
                }
                if (!attributes.getLocalName(i2).equalsIgnoreCase("WriteAccess")) continue;
                nodeAttributes.setWriteMask(new UnsignedInteger(Long.parseLong(attributes.getValue(i2))));
            }
        }

        private ObjectAttributes G(Attributes attributes) {
            ObjectAttributes objectAttributes = new ObjectAttributes();
            for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
            }
            this.a(objectAttributes, attributes);
            return objectAttributes;
        }

        private ObjectTypeAttributes H(Attributes attributes) {
            ObjectTypeAttributes objectTypeAttributes = new ObjectTypeAttributes();
            for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
                if (!attributes.getLocalName(i2).equalsIgnoreCase("IsAbstract")) continue;
                objectTypeAttributes.setIsAbstract(Boolean.parseBoolean(attributes.getValue(i2)));
            }
            this.a(objectTypeAttributes, attributes);
            return objectTypeAttributes;
        }

        private ReferenceTypeAttributes I(Attributes attributes) {
            ReferenceTypeAttributes referenceTypeAttributes = new ReferenceTypeAttributes();
            for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
                if (attributes.getLocalName(i2).equalsIgnoreCase("IsAbstract")) {
                    referenceTypeAttributes.setIsAbstract(Boolean.parseBoolean(attributes.getValue(i2)));
                }
                if (!attributes.getLocalName(i2).equalsIgnoreCase("Symmetric")) continue;
                referenceTypeAttributes.setSymmetric(Boolean.parseBoolean(attributes.getValue(i2)));
            }
            this.a(referenceTypeAttributes, attributes);
            return referenceTypeAttributes;
        }

        private VariableAttributes J(Attributes attributes) throws ServiceResultException {
            VariableAttributes variableAttributes = new VariableAttributes();
            String string = null;
            for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
                if (attributes.getLocalName(i2).equalsIgnoreCase("DataType")) {
                    variableAttributes.setDataType(this.iX.toNodeId(this.s(attributes.getValue(i2))));
                }
                if (attributes.getLocalName(i2).equalsIgnoreCase("Historizing")) {
                    variableAttributes.setHistorizing(Boolean.parseBoolean(attributes.getValue(i2)));
                }
                if (attributes.getLocalName(i2).equalsIgnoreCase("MinimumSamplingInterval")) {
                    variableAttributes.setMinimumSamplingInterval(Double.parseDouble(attributes.getValue(i2)));
                }
                if (!attributes.getLocalName(i2).equalsIgnoreCase("DefaultValue")) continue;
                string = attributes.getValue(i2);
            }
            NodeId nodeId = variableAttributes.getDataType();
            if (string != null && nodeId != null) {
                variableAttributes.setValue(this.parseVariant(string, nodeId).getValue());
            } else {
                variableAttributes.setValue(string);
            }
            this.a(variableAttributes, attributes);
            return variableAttributes;
        }

        private VariableTypeAttributes K(Attributes attributes) {
            VariableTypeAttributes variableTypeAttributes = new VariableTypeAttributes();
            for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
                if (!attributes.getLocalName(i2).equalsIgnoreCase("AccessLevel")) continue;
                variableTypeAttributes.setIsAbstract(Boolean.parseBoolean(attributes.getValue(i2)));
            }
            this.a(variableTypeAttributes, attributes);
            return variableTypeAttributes;
        }

        private ViewAttributes L(Attributes attributes) {
            ViewAttributes viewAttributes = new ViewAttributes();
            for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
                if (!attributes.getLocalName(i2).equalsIgnoreCase("ContainsNoLoops")) continue;
                viewAttributes.setContainsNoLoops(Boolean.parseBoolean(attributes.getValue(i2)));
            }
            this.a(viewAttributes, attributes);
            return viewAttributes;
        }

        private NodeId toNodeId(ExpandedNodeId expandedNodeId) throws ServiceResultException {
            return this.iX.toNodeId(expandedNodeId);
        }

        private static enum a {
            kX,
            kY,
            kZ,
            la,
            lb,
            lc,
            ld,
            le,
            lf,
            lg,
            lh,
            li,
            lj,
            lk,
            ll,
            lm,
            ln,
            lo,
            lp,
            lq,
            lr,
            ls,
            lt,
            lu,
            lv,
            lw,
            lx,
            ly,
            lz,
            lA;

        }

        public static class ParentDefinition {
            private final NodeId lC;
            private final NodeId lD;

            public ParentDefinition(NodeId nodeId, NodeId nodeId2) {
                this.lC = nodeId;
                this.lD = nodeId2;
            }

            public NodeId getParent() {
                return this.lC;
            }

            public NodeId getParentReferenceType() {
                return this.lD;
            }
        }
    }
}

