/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.UaNodeFactoryException;
import com.prosysopc.ua.nodes.UaView;
import com.prosysopc.ua.server.BrowseContinuationPoint;
import com.prosysopc.ua.server.NodeManagerTable;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.server.ServiceHandler;
import com.prosysopc.ua.server.Session;
import com.prosysopc.ua.server.SessionManager;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.common.ServiceFaultException;
import com.prosysopc.ua.stack.core.AddNodesItem;
import com.prosysopc.ua.stack.core.AddNodesRequest;
import com.prosysopc.ua.stack.core.AddNodesResponse;
import com.prosysopc.ua.stack.core.AddNodesResult;
import com.prosysopc.ua.stack.core.AddReferencesItem;
import com.prosysopc.ua.stack.core.AddReferencesRequest;
import com.prosysopc.ua.stack.core.AddReferencesResponse;
import com.prosysopc.ua.stack.core.BrowseDescription;
import com.prosysopc.ua.stack.core.BrowseDirection;
import com.prosysopc.ua.stack.core.BrowseNextRequest;
import com.prosysopc.ua.stack.core.BrowseNextResponse;
import com.prosysopc.ua.stack.core.BrowsePath;
import com.prosysopc.ua.stack.core.BrowsePathResult;
import com.prosysopc.ua.stack.core.BrowsePathTarget;
import com.prosysopc.ua.stack.core.BrowseRequest;
import com.prosysopc.ua.stack.core.BrowseResponse;
import com.prosysopc.ua.stack.core.BrowseResult;
import com.prosysopc.ua.stack.core.BrowseResultMask;
import com.prosysopc.ua.stack.core.CallMethodRequest;
import com.prosysopc.ua.stack.core.CallMethodResult;
import com.prosysopc.ua.stack.core.CallRequest;
import com.prosysopc.ua.stack.core.CallResponse;
import com.prosysopc.ua.stack.core.DeleteNodesItem;
import com.prosysopc.ua.stack.core.DeleteNodesRequest;
import com.prosysopc.ua.stack.core.DeleteNodesResponse;
import com.prosysopc.ua.stack.core.DeleteReferencesItem;
import com.prosysopc.ua.stack.core.DeleteReferencesRequest;
import com.prosysopc.ua.stack.core.DeleteReferencesResponse;
import com.prosysopc.ua.stack.core.NodeClass;
import com.prosysopc.ua.stack.core.QueryFirstRequest;
import com.prosysopc.ua.stack.core.QueryFirstResponse;
import com.prosysopc.ua.stack.core.QueryNextRequest;
import com.prosysopc.ua.stack.core.QueryNextResponse;
import com.prosysopc.ua.stack.core.ReferenceDescription;
import com.prosysopc.ua.stack.core.RegisterNodesRequest;
import com.prosysopc.ua.stack.core.RegisterNodesResponse;
import com.prosysopc.ua.stack.core.RelativePath;
import com.prosysopc.ua.stack.core.RelativePathElement;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.core.TranslateBrowsePathsToNodeIdsRequest;
import com.prosysopc.ua.stack.core.TranslateBrowsePathsToNodeIdsResponse;
import com.prosysopc.ua.stack.core.UnregisterNodesRequest;
import com.prosysopc.ua.stack.core.UnregisterNodesResponse;
import com.prosysopc.ua.stack.core.ViewDescription;
import com.prosysopc.ua.stack.transport.endpoint.EndpointServiceRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeManagementServiceHandler
extends ServiceHandler {
    private static Logger logger = LoggerFactory.getLogger(NodeManagementServiceHandler.class);
    private int kd = 10000;

    public NodeManagementServiceHandler(SessionManager sessionManager, NodeManagerTable nodeManagerTable) {
        super(sessionManager, nodeManagerTable);
    }

    public int getMaxNodesPerBrowse() {
        return this.getOperationLimits().getMaxNodesPerBrowse().intValue();
    }

    public int getMaxNodesPerMethodCall() {
        return this.getOperationLimits().getMaxNodesPerMethodCall().intValue();
    }

    public int getMaxNodesPerNodeManagement() {
        return this.getOperationLimits().getMaxNodesPerNodeManagement().intValue();
    }

    public int getMaxNodesPerRegisterNodes() {
        return this.getOperationLimits().getMaxNodesPerRegisterNodes().intValue();
    }

    public int getMaxNodesPerTranslateBrowsePathsToNodeIds() {
        return this.getOperationLimits().getMaxNodesPerTranslateBrowsePathsToNodeIds().intValue();
    }

    public int getMaxReferencesPerNode() {
        return this.kd;
    }

    public final void onAddNodes(EndpointServiceRequest<AddNodesRequest, AddNodesResponse> endpointServiceRequest) throws ServiceFaultException {
        AddNodesRequest addNodesRequest = endpointServiceRequest.getRequest();
        AddNodesResponse addNodesResponse = new AddNodesResponse();
        ServiceContext serviceContext = null;
        try {
            serviceContext = this.validateRequest(endpointServiceRequest);
            this.addNodes(serviceContext, addNodesRequest, addNodesResponse);
        }
        catch (ServiceException serviceException) {
            this.handleServiceResultException(addNodesResponse, serviceException);
        }
        addNodesResponse.setDiagnosticInfos(this.validateResponse(addNodesRequest, addNodesResponse, serviceContext, addNodesResponse.getDiagnosticInfos()));
        endpointServiceRequest.sendResponse(addNodesResponse, NodeManagementServiceHandler.localizationHintsForServiceContext(serviceContext));
    }

    public final void onAddReferences(EndpointServiceRequest<AddReferencesRequest, AddReferencesResponse> endpointServiceRequest) throws ServiceFaultException {
        AddReferencesRequest addReferencesRequest = endpointServiceRequest.getRequest();
        AddReferencesResponse addReferencesResponse = new AddReferencesResponse();
        ServiceContext serviceContext = null;
        try {
            serviceContext = this.validateRequest(endpointServiceRequest);
            this.addReferences(serviceContext, addReferencesRequest, addReferencesResponse);
        }
        catch (ServiceException serviceException) {
            this.handleServiceResultException(addReferencesResponse, serviceException);
        }
        addReferencesResponse.setDiagnosticInfos(this.validateResponse(addReferencesRequest, addReferencesResponse, serviceContext, addReferencesResponse.getDiagnosticInfos()));
        endpointServiceRequest.sendResponse(addReferencesResponse, NodeManagementServiceHandler.localizationHintsForServiceContext(serviceContext));
    }

    public final void onBrowse(EndpointServiceRequest<BrowseRequest, BrowseResponse> endpointServiceRequest) throws ServiceFaultException {
        BrowseRequest browseRequest = endpointServiceRequest.getRequest();
        BrowseResponse browseResponse = new BrowseResponse();
        ServiceContext serviceContext = null;
        try {
            serviceContext = this.validateRequest(endpointServiceRequest);
            this.browse(serviceContext, browseRequest, browseResponse);
        }
        catch (ServiceException serviceException) {
            this.handleServiceResultException(browseResponse, serviceException);
        }
        browseResponse.setDiagnosticInfos(this.validateResponse(browseRequest, browseResponse, serviceContext, browseResponse.getDiagnosticInfos()));
        endpointServiceRequest.sendResponse(browseResponse, NodeManagementServiceHandler.localizationHintsForServiceContext(serviceContext));
    }

    public final void onBrowseNext(EndpointServiceRequest<BrowseNextRequest, BrowseNextResponse> endpointServiceRequest) throws ServiceFaultException {
        BrowseNextRequest browseNextRequest = endpointServiceRequest.getRequest();
        BrowseNextResponse browseNextResponse = new BrowseNextResponse();
        ServiceContext serviceContext = null;
        try {
            serviceContext = this.validateRequest(endpointServiceRequest);
            this.browseNext(serviceContext, browseNextRequest, browseNextResponse);
        }
        catch (ServiceException serviceException) {
            this.handleServiceResultException(browseNextResponse, serviceException);
        }
        browseNextResponse.setDiagnosticInfos(this.validateResponse(browseNextRequest, browseNextResponse, serviceContext, browseNextResponse.getDiagnosticInfos()));
        endpointServiceRequest.sendResponse(browseNextResponse, NodeManagementServiceHandler.localizationHintsForServiceContext(serviceContext));
    }

    public final void onCall(EndpointServiceRequest<CallRequest, CallResponse> endpointServiceRequest) throws ServiceFaultException {
        CallRequest callRequest = endpointServiceRequest.getRequest();
        CallResponse callResponse = new CallResponse();
        ServiceContext serviceContext = null;
        try {
            serviceContext = this.validateRequest(endpointServiceRequest);
            this.call(serviceContext, callRequest, callResponse);
        }
        catch (ServiceException serviceException) {
            this.handleServiceResultException(callResponse, serviceException);
        }
        callResponse.setDiagnosticInfos(this.validateResponse(callRequest, callResponse, serviceContext, callResponse.getDiagnosticInfos()));
        endpointServiceRequest.sendResponse(callResponse, NodeManagementServiceHandler.localizationHintsForServiceContext(serviceContext));
    }

    public final void onDeleteNodes(EndpointServiceRequest<DeleteNodesRequest, DeleteNodesResponse> endpointServiceRequest) throws ServiceFaultException {
        DeleteNodesRequest deleteNodesRequest = endpointServiceRequest.getRequest();
        DeleteNodesResponse deleteNodesResponse = new DeleteNodesResponse();
        ServiceContext serviceContext = null;
        try {
            serviceContext = this.validateRequest(endpointServiceRequest);
            this.deleteNodes(serviceContext, deleteNodesRequest, deleteNodesResponse);
        }
        catch (ServiceException serviceException) {
            this.handleServiceResultException(deleteNodesResponse, serviceException);
        }
        deleteNodesResponse.setDiagnosticInfos(this.validateResponse(deleteNodesRequest, deleteNodesResponse, serviceContext, deleteNodesResponse.getDiagnosticInfos()));
        endpointServiceRequest.sendResponse(deleteNodesResponse, NodeManagementServiceHandler.localizationHintsForServiceContext(serviceContext));
    }

    public final void onDeleteReferences(EndpointServiceRequest<DeleteReferencesRequest, DeleteReferencesResponse> endpointServiceRequest) throws ServiceFaultException {
        DeleteReferencesRequest deleteReferencesRequest = endpointServiceRequest.getRequest();
        DeleteReferencesResponse deleteReferencesResponse = new DeleteReferencesResponse();
        ServiceContext serviceContext = null;
        try {
            serviceContext = this.validateRequest(endpointServiceRequest);
            this.deleteReferences(serviceContext, deleteReferencesRequest, deleteReferencesResponse);
        }
        catch (ServiceException serviceException) {
            this.handleServiceResultException(deleteReferencesResponse, serviceException);
        }
        deleteReferencesResponse.setDiagnosticInfos(this.validateResponse(deleteReferencesRequest, deleteReferencesResponse, serviceContext, deleteReferencesResponse.getDiagnosticInfos()));
        endpointServiceRequest.sendResponse(deleteReferencesResponse, NodeManagementServiceHandler.localizationHintsForServiceContext(serviceContext));
    }

    public final void onQueryFirst(EndpointServiceRequest<QueryFirstRequest, QueryFirstResponse> endpointServiceRequest) throws ServiceFaultException {
        QueryFirstRequest queryFirstRequest = endpointServiceRequest.getRequest();
        QueryFirstResponse queryFirstResponse = new QueryFirstResponse();
        ServiceContext serviceContext = null;
        try {
            serviceContext = this.validateRequest(endpointServiceRequest);
            this.queryFirst(serviceContext, queryFirstRequest, queryFirstResponse);
        }
        catch (ServiceException serviceException) {
            this.handleServiceResultException(queryFirstResponse, serviceException);
        }
        queryFirstResponse.setDiagnosticInfos(this.validateResponse(queryFirstRequest, queryFirstResponse, serviceContext, queryFirstResponse.getDiagnosticInfos()));
        endpointServiceRequest.sendResponse(queryFirstResponse, NodeManagementServiceHandler.localizationHintsForServiceContext(serviceContext));
    }

    public final void onQueryNext(EndpointServiceRequest<QueryNextRequest, QueryNextResponse> endpointServiceRequest) throws ServiceFaultException {
        QueryNextRequest queryNextRequest = endpointServiceRequest.getRequest();
        QueryNextResponse queryNextResponse = new QueryNextResponse();
        ServiceContext serviceContext = null;
        try {
            serviceContext = this.validateRequest(endpointServiceRequest);
            this.queryNext(serviceContext, queryNextRequest, queryNextResponse);
        }
        catch (ServiceException serviceException) {
            this.handleServiceResultException(queryNextResponse, serviceException);
        }
        this.validateResponse(queryNextRequest, queryNextResponse, serviceContext);
        endpointServiceRequest.sendResponse(queryNextResponse, NodeManagementServiceHandler.localizationHintsForServiceContext(serviceContext));
    }

    public final void onRegisterNodes(EndpointServiceRequest<RegisterNodesRequest, RegisterNodesResponse> endpointServiceRequest) throws ServiceFaultException {
        RegisterNodesRequest registerNodesRequest = endpointServiceRequest.getRequest();
        RegisterNodesResponse registerNodesResponse = new RegisterNodesResponse();
        ServiceContext serviceContext = null;
        try {
            serviceContext = this.validateRequest(endpointServiceRequest);
            this.registerNodes(serviceContext, registerNodesRequest, registerNodesResponse);
        }
        catch (ServiceException serviceException) {
            this.handleServiceResultException(registerNodesResponse, serviceException);
        }
        this.validateResponse(registerNodesRequest, registerNodesResponse, serviceContext);
        endpointServiceRequest.sendResponse(registerNodesResponse, NodeManagementServiceHandler.localizationHintsForServiceContext(serviceContext));
    }

    public final void onTranslateBrowsePathsToNodeIds(EndpointServiceRequest<TranslateBrowsePathsToNodeIdsRequest, TranslateBrowsePathsToNodeIdsResponse> endpointServiceRequest) throws ServiceFaultException {
        TranslateBrowsePathsToNodeIdsRequest translateBrowsePathsToNodeIdsRequest = endpointServiceRequest.getRequest();
        TranslateBrowsePathsToNodeIdsResponse translateBrowsePathsToNodeIdsResponse = new TranslateBrowsePathsToNodeIdsResponse();
        ServiceContext serviceContext = null;
        try {
            serviceContext = this.validateRequest(endpointServiceRequest);
            this.translateBrowsePathsToNodeIds(serviceContext, translateBrowsePathsToNodeIdsRequest, translateBrowsePathsToNodeIdsResponse);
        }
        catch (ServiceException serviceException) {
            this.handleServiceResultException(translateBrowsePathsToNodeIdsResponse, serviceException);
        }
        translateBrowsePathsToNodeIdsResponse.setDiagnosticInfos(this.validateResponse(translateBrowsePathsToNodeIdsRequest, translateBrowsePathsToNodeIdsResponse, serviceContext, translateBrowsePathsToNodeIdsResponse.getDiagnosticInfos()));
        endpointServiceRequest.sendResponse(translateBrowsePathsToNodeIdsResponse, NodeManagementServiceHandler.localizationHintsForServiceContext(serviceContext));
    }

    public final void onUnregisterNodes(EndpointServiceRequest<UnregisterNodesRequest, UnregisterNodesResponse> endpointServiceRequest) throws ServiceFaultException {
        UnregisterNodesRequest unregisterNodesRequest = endpointServiceRequest.getRequest();
        UnregisterNodesResponse unregisterNodesResponse = new UnregisterNodesResponse();
        ServiceContext serviceContext = null;
        try {
            serviceContext = this.validateRequest(endpointServiceRequest);
            this.unregisterNodes(serviceContext, unregisterNodesRequest, unregisterNodesResponse);
        }
        catch (ServiceException serviceException) {
            this.handleServiceResultException(unregisterNodesResponse, serviceException);
        }
        this.validateResponse(unregisterNodesRequest, unregisterNodesResponse, serviceContext);
        endpointServiceRequest.sendResponse(unregisterNodesResponse, NodeManagementServiceHandler.localizationHintsForServiceContext(serviceContext));
    }

    public void setMaxNodesPerBrowse(int n2) {
        this.getOperationLimits().setMaxNodesPerBrowse(UnsignedInteger.valueOf(n2));
    }

    public void setMaxNodesPerMethodCall(int n2) {
        this.getOperationLimits().setMaxNodesPerMethodCall(UnsignedInteger.valueOf(n2));
    }

    public void setMaxNodesPerNodeManagement(int n2) {
        this.getOperationLimits().setMaxNodesPerNodeManagement(UnsignedInteger.valueOf(n2));
    }

    public void setMaxNodesPerRegisterNodes(int n2) {
        this.getOperationLimits().setMaxNodesPerRegisterNodes(UnsignedInteger.valueOf(n2));
    }

    public void setMaxNodesPerTranslateBrowsePathsToNodeIds(int n2) {
        this.getOperationLimits().setMaxNodesPerTranslateBrowsePathsToNodeIds(UnsignedInteger.valueOf(n2));
    }

    public void setMaxReferencesPerNode(int n2) {
        this.kd = n2;
    }

    public void start() throws StatusException, UaNodeFactoryException {
        this.getNodeManagerTable().start();
    }

    private void checkNodeManagementEnabled() throws ServiceException {
        this.getNodeManagerTable().checkNodeManagementEnabled();
    }

    protected NodeId addNode(ServiceContext serviceContext, AddNodesItem addNodesItem) throws StatusException, ServiceException, UaNodeFactoryException {
        return this.getNodeManagerTable().addNode(serviceContext, addNodesItem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addNodes(ServiceContext serviceContext, AddNodesRequest addNodesRequest, AddNodesResponse addNodesResponse) throws ServiceException {
        this.checkNodeManagementEnabled();
        Object[] objectArray = addNodesRequest.getNodesToAdd();
        this.checkRequestLength(objectArray, this.getMaxNodesPerNodeManagement());
        AddNodesResult[] addNodesResultArray = new AddNodesResult[objectArray.length];
        DiagnosticInfo[] diagnosticInfoArray = new DiagnosticInfo[objectArray.length];
        this.getServer().getNodeManagerRoot().beginModelChange();
        try {
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                addNodesResultArray[i2] = new AddNodesResult();
                try {
                    NodeId nodeId = this.addNode(serviceContext, (AddNodesItem)objectArray[i2]);
                    addNodesResultArray[i2].setAddedNodeId(nodeId);
                    addNodesResultArray[i2].setStatusCode(StatusCode.GOOD);
                    continue;
                }
                catch (StatusException statusException) {
                    logger.warn("StatusException: ", (Throwable)statusException);
                    addNodesResultArray[i2].setStatusCode(statusException.getStatusCode());
                    diagnosticInfoArray[i2] = statusException.getDiagnosticInfo();
                    continue;
                }
                catch (UaNodeFactoryException uaNodeFactoryException) {
                    logger.error("UaNodeFactoryException: ", (Throwable)uaNodeFactoryException);
                    addNodesResultArray[i2].setStatusCode(new StatusCode(StatusCodes.Bad_NodeClassInvalid));
                }
            }
        }
        finally {
            this.getServer().getNodeManagerRoot().endModelChange();
        }
        addNodesResponse.setResults(addNodesResultArray);
        addNodesResponse.setDiagnosticInfos(diagnosticInfoArray);
    }

    protected void addReference(ServiceContext serviceContext, AddReferencesItem addReferencesItem) throws StatusException, ServiceException {
        this.getNodeManagerTable().addReference(serviceContext, addReferencesItem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addReferences(ServiceContext serviceContext, AddReferencesRequest addReferencesRequest, AddReferencesResponse addReferencesResponse) throws ServiceException {
        this.checkNodeManagementEnabled();
        Object[] objectArray = addReferencesRequest.getReferencesToAdd();
        this.checkRequestLength(objectArray, this.getMaxNodesPerNodeManagement());
        StatusCode[] statusCodeArray = new StatusCode[objectArray.length];
        DiagnosticInfo[] diagnosticInfoArray = new DiagnosticInfo[objectArray.length];
        this.getServer().getNodeManagerRoot().beginModelChange();
        try {
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                try {
                    this.addReference(serviceContext, (AddReferencesItem)objectArray[i2]);
                    statusCodeArray[i2] = StatusCode.GOOD;
                    continue;
                }
                catch (StatusException statusException) {
                    logger.warn("StatusException: ", (Throwable)statusException);
                    statusCodeArray[i2] = statusException.getStatusCode();
                    diagnosticInfoArray[i2] = statusException.getDiagnosticInfo();
                }
            }
        }
        finally {
            this.getServer().getNodeManagerRoot().endModelChange();
        }
        addReferencesResponse.setResults(statusCodeArray);
        addReferencesResponse.setDiagnosticInfos(diagnosticInfoArray);
    }

    protected void browse(ServiceContext serviceContext, BrowseRequest browseRequest, BrowseResponse browseResponse) throws ServiceException {
        Object[] objectArray = browseRequest.getNodesToBrowse();
        this.checkRequestLength(objectArray, this.getMaxNodesPerBrowse());
        ViewDescription viewDescription = browseRequest.getView();
        UaView uaView = viewDescription == null || NodeId.isNull(viewDescription.getViewId()) ? null : this.getView(viewDescription.getViewId(), viewDescription.getViewVersion(), viewDescription.getTimestamp());
        logger.debug("browse: view={}", uaView);
        int n2 = browseRequest.getRequestedMaxReferencesPerNode().getValue() < (long)this.kd ? browseRequest.getRequestedMaxReferencesPerNode().intValue() : this.kd;
        BrowseResult[] browseResultArray = new BrowseResult[objectArray.length];
        DiagnosticInfo[] diagnosticInfoArray = new DiagnosticInfo[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            try {
                EnumSet<BrowseResultMask> enumSet;
                browseResultArray[i2] = new BrowseResult();
                ArrayList<ReferenceDescription> arrayList = new ArrayList<ReferenceDescription>();
                Object object = objectArray[i2];
                EnumSet<NodeClass> enumSet2 = ((BrowseDescription)object).getNodeClassMask().getValue() == 0L ? NodeClass.ALL : NodeClass.getSet(((BrowseDescription)object).getNodeClassMask());
                EnumSet<BrowseResultMask> enumSet3 = enumSet = ((BrowseDescription)object).getResultMask().getValue() == 0L ? BrowseResultMask.NONE : BrowseResultMask.getSet(((BrowseDescription)object).getResultMask());
                if (((BrowseDescription)object).getBrowseDirection() == null) {
                    throw new StatusException("BrowseDirection==null", StatusCodes.Bad_BrowseDirectionInvalid);
                }
                BrowseContinuationPoint browseContinuationPoint = this.browseNode(serviceContext, arrayList, ((BrowseDescription)object).getNodeId(), n2, ((BrowseDescription)object).getBrowseDirection(), ((BrowseDescription)object).getReferenceTypeId(), ((BrowseDescription)object).getIncludeSubtypes(), enumSet2, enumSet, viewDescription, 0);
                if (browseContinuationPoint != null) {
                    browseResultArray[i2].setContinuationPoint(serviceContext.getSession().addBrowseContinuationPoint(browseContinuationPoint));
                }
                browseResultArray[i2].setReferences(arrayList.toArray(new ReferenceDescription[arrayList.size()]));
                browseResultArray[i2].setStatusCode(StatusCode.GOOD);
                continue;
            }
            catch (ServiceException serviceException) {
                logger.debug("ServiceException: ", (Throwable)serviceException);
                browseResultArray[i2].setStatusCode(serviceException.getServiceResult());
                diagnosticInfoArray[i2] = serviceException.getDiagnosticInfo();
                browseResponse.setDiagnosticInfos(diagnosticInfoArray);
                continue;
            }
            catch (StatusException statusException) {
                logger.debug("StatusException: ", (Throwable)statusException);
                browseResultArray[i2].setStatusCode(statusException.getStatusCode());
                diagnosticInfoArray[i2] = statusException.getDiagnosticInfo();
                browseResponse.setDiagnosticInfos(diagnosticInfoArray);
            }
        }
        browseResponse.setResults(browseResultArray);
    }

    protected void browseNext(ServiceContext serviceContext, BrowseNextRequest browseNextRequest, BrowseNextResponse browseNextResponse) throws ServiceException {
        Object[] objectArray = browseNextRequest.getContinuationPoints();
        this.checkRequestLength(objectArray, this.getMaxNodesPerBrowse());
        logger.debug("browseNext: continuationPoints={} releaseContinuationPoints={}", (Object)Arrays.toString(objectArray), (Object)browseNextRequest.getReleaseContinuationPoints());
        BrowseResult[] browseResultArray = new BrowseResult[objectArray.length];
        DiagnosticInfo[] diagnosticInfoArray = new DiagnosticInfo[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            try {
                browseResultArray[i2] = new BrowseResult();
                Session session = serviceContext.getSession();
                BrowseContinuationPoint browseContinuationPoint = session.getBrowseContinuationPoint((ByteString)objectArray[i2]);
                if (!browseNextRequest.getReleaseContinuationPoints().booleanValue()) {
                    logger.debug("browseNext: c={}", (Object)browseContinuationPoint);
                    ArrayList<ReferenceDescription> arrayList = new ArrayList<ReferenceDescription>();
                    browseContinuationPoint = this.browseNode(serviceContext, arrayList, browseContinuationPoint.getNodeId(), browseContinuationPoint.getMaxResultsToReturn(), browseContinuationPoint.getBrowseDirection(), browseContinuationPoint.getReferenceTypeId(), browseContinuationPoint.isIncludeSubtypes(), browseContinuationPoint.getNodeClassMask(), browseContinuationPoint.getResultMask(), browseContinuationPoint.getView(), browseContinuationPoint.getIndex());
                    if (browseContinuationPoint != null) {
                        browseResultArray[i2].setContinuationPoint(session.addBrowseContinuationPoint(browseContinuationPoint));
                    }
                    browseResultArray[i2].setReferences(arrayList.toArray(new ReferenceDescription[arrayList.size()]));
                }
                browseResultArray[i2].setStatusCode(StatusCode.GOOD);
                continue;
            }
            catch (StatusException statusException) {
                logger.debug("StatusException: ", (Throwable)statusException);
                browseResultArray[i2].setStatusCode(statusException.getStatusCode());
                diagnosticInfoArray[i2] = statusException.getDiagnosticInfo();
            }
        }
        browseNextResponse.setResults(browseResultArray);
        browseNextResponse.setDiagnosticInfos(diagnosticInfoArray);
    }

    protected BrowseContinuationPoint browseNode(ServiceContext serviceContext, List<ReferenceDescription> list, NodeId nodeId, int n2, BrowseDirection browseDirection, NodeId nodeId2, Boolean bl, EnumSet<NodeClass> enumSet, EnumSet<BrowseResultMask> enumSet2, ViewDescription viewDescription, int n3) throws ServiceException, StatusException {
        return this.getNodeManagerTable().browseNode(serviceContext, list, nodeId, n2, browseDirection, nodeId2, bl, null, enumSet, enumSet2, viewDescription, n3);
    }

    protected void call(ServiceContext serviceContext, CallRequest callRequest, CallResponse callResponse) throws ServiceException {
        Object[] objectArray = callRequest.getMethodsToCall();
        this.checkRequestLength(objectArray, this.getMaxNodesPerMethodCall());
        CallMethodResult[] callMethodResultArray = new CallMethodResult[objectArray.length];
        DiagnosticInfo[] diagnosticInfoArray = new DiagnosticInfo[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            Object object = objectArray[i2];
            Variant[] variantArray = Variant.asVariantArray(((CallMethodRequest)object).getInputArguments());
            callMethodResultArray[i2] = new CallMethodResult();
            int n2 = variantArray == null ? 0 : variantArray.length;
            StatusCode[] statusCodeArray = variantArray == null ? null : new StatusCode[n2];
            DiagnosticInfo[] diagnosticInfoArray2 = variantArray == null ? null : new DiagnosticInfo[n2];
            try {
                callMethodResultArray[i2].setOutputArguments(Variant.asObjectArray(this.callMethod(serviceContext, ((CallMethodRequest)object).getObjectId(), ((CallMethodRequest)object).getMethodId(), variantArray, statusCodeArray, diagnosticInfoArray2)));
                callMethodResultArray[i2].setStatusCode(StatusCode.GOOD);
            }
            catch (StatusException statusException) {
                logger.debug("Call failed", (Throwable)statusException);
                callMethodResultArray[i2].setStatusCode(statusException.getStatusCode());
                diagnosticInfoArray[i2] = statusException.getDiagnosticInfo();
            }
            callMethodResultArray[i2].setInputArgumentResults(statusCodeArray);
            callMethodResultArray[i2].setInputArgumentDiagnosticInfos(diagnosticInfoArray2);
        }
        callResponse.setResults(callMethodResultArray);
        callResponse.setDiagnosticInfos(diagnosticInfoArray);
    }

    protected Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, NodeId nodeId2, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return this.getNodeManagerTable().callMethod(serviceContext, nodeId, nodeId2, variantArray, statusCodeArray, diagnosticInfoArray);
    }

    protected void deleteNode(ServiceContext serviceContext, DeleteNodesItem deleteNodesItem) throws StatusException {
        this.getNodeManagerTable().deleteNode(serviceContext, deleteNodesItem.getNodeId(), deleteNodesItem.getDeleteTargetReferences());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteNodes(ServiceContext serviceContext, DeleteNodesRequest deleteNodesRequest, DeleteNodesResponse deleteNodesResponse) throws ServiceException {
        this.checkNodeManagementEnabled();
        Object[] objectArray = deleteNodesRequest.getNodesToDelete();
        this.checkRequestLength(objectArray, this.getMaxNodesPerNodeManagement());
        StatusCode[] statusCodeArray = new StatusCode[objectArray.length];
        DiagnosticInfo[] diagnosticInfoArray = new DiagnosticInfo[objectArray.length];
        this.getServer().getNodeManagerRoot().beginModelChange();
        try {
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                try {
                    this.deleteNode(serviceContext, (DeleteNodesItem)objectArray[i2]);
                    statusCodeArray[i2] = StatusCode.GOOD;
                    continue;
                }
                catch (StatusException statusException) {
                    logger.warn("StatusException: ", (Throwable)statusException);
                    statusCodeArray[i2] = statusException.getStatusCode();
                    diagnosticInfoArray[i2] = statusException.getDiagnosticInfo();
                }
            }
        }
        finally {
            this.getServer().getNodeManagerRoot().endModelChange();
        }
        deleteNodesResponse.setResults(statusCodeArray);
        deleteNodesResponse.setDiagnosticInfos(diagnosticInfoArray);
    }

    protected void deleteReference(ServiceContext serviceContext, DeleteReferencesItem deleteReferencesItem) throws StatusException {
        this.getNodeManagerTable().deleteReference(serviceContext, deleteReferencesItem.getSourceNodeId(), deleteReferencesItem.getTargetNodeId(), deleteReferencesItem.getReferenceTypeId(), deleteReferencesItem.getIsForward(), deleteReferencesItem.getDeleteBidirectional());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteReferences(ServiceContext serviceContext, DeleteReferencesRequest deleteReferencesRequest, DeleteReferencesResponse deleteReferencesResponse) throws ServiceException {
        this.checkNodeManagementEnabled();
        Object[] objectArray = deleteReferencesRequest.getReferencesToDelete();
        this.checkRequestLength(objectArray, this.getMaxNodesPerNodeManagement());
        StatusCode[] statusCodeArray = new StatusCode[objectArray.length];
        DiagnosticInfo[] diagnosticInfoArray = new DiagnosticInfo[objectArray.length];
        this.getServer().getNodeManagerRoot().beginModelChange();
        try {
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                try {
                    this.deleteReference(serviceContext, (DeleteReferencesItem)objectArray[i2]);
                    statusCodeArray[i2] = StatusCode.GOOD;
                    continue;
                }
                catch (StatusException statusException) {
                    logger.warn("StatusException: ", (Throwable)statusException);
                    statusCodeArray[i2] = statusException.getStatusCode();
                    diagnosticInfoArray[i2] = statusException.getDiagnosticInfo();
                }
            }
        }
        finally {
            this.getServer().getNodeManagerRoot().endModelChange();
        }
        deleteReferencesResponse.setResults(statusCodeArray);
        deleteReferencesResponse.setDiagnosticInfos(diagnosticInfoArray);
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    protected UaView getView(NodeId nodeId, UnsignedInteger unsignedInteger, DateTime dateTime) throws ServiceException {
        throw new ServiceException(StatusCodes.Bad_ViewIdUnknown);
    }

    protected void init() throws StatusException, UaNodeFactoryException {
        this.getNodeManagerTable().init();
    }

    protected void queryFirst(ServiceContext serviceContext, QueryFirstRequest queryFirstRequest, QueryFirstResponse queryFirstResponse) throws ServiceException {
        this.getNodeManagerTable().queryFirst(serviceContext, queryFirstRequest, queryFirstResponse);
    }

    protected void queryNext(ServiceContext serviceContext, QueryNextRequest queryNextRequest, QueryNextResponse queryNextResponse) throws ServiceException {
        this.getNodeManagerTable().queryNext(serviceContext, queryNextRequest, queryNextResponse);
    }

    protected NodeId registerNode(ServiceContext serviceContext, NodeId nodeId) throws StatusException {
        return this.getNodeManagerTable().registerNode(serviceContext, nodeId);
    }

    protected void registerNodes(ServiceContext serviceContext, RegisterNodesRequest registerNodesRequest, RegisterNodesResponse registerNodesResponse) throws ServiceException {
        Object[] objectArray = registerNodesRequest.getNodesToRegister();
        this.checkRequestLength(objectArray, this.getMaxNodesPerRegisterNodes());
        NodeId[] nodeIdArray = new NodeId[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            try {
                nodeIdArray[i2] = this.registerNode(serviceContext, (NodeId)objectArray[i2]);
                continue;
            }
            catch (StatusException statusException) {
                logger.debug("StatusException: ", (Throwable)statusException);
                nodeIdArray[i2] = objectArray[i2];
            }
        }
        registerNodesResponse.setRegisteredNodeIds(nodeIdArray);
    }

    protected BrowsePathTarget[] translateBrowsePath(ServiceContext serviceContext, NodeId nodeId, RelativePath relativePath) throws StatusException {
        try {
            return this.getNodeManagerTable().translateBrowsePath(serviceContext, nodeId, relativePath);
        }
        catch (ServiceException serviceException) {
            throw new StatusException(serviceException.getServiceResult());
        }
    }

    protected void translateBrowsePathsToNodeIds(ServiceContext serviceContext, TranslateBrowsePathsToNodeIdsRequest translateBrowsePathsToNodeIdsRequest, TranslateBrowsePathsToNodeIdsResponse translateBrowsePathsToNodeIdsResponse) throws ServiceException {
        Object[] objectArray = translateBrowsePathsToNodeIdsRequest.getBrowsePaths();
        this.checkRequestLength(objectArray, this.getMaxNodesPerTranslateBrowsePathsToNodeIds());
        BrowsePathResult[] browsePathResultArray = new BrowsePathResult[objectArray.length];
        DiagnosticInfo[] diagnosticInfoArray = new DiagnosticInfo[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            browsePathResultArray[i2] = new BrowsePathResult();
            try {
                RelativePathElement[] relativePathElementArray = ((BrowsePath)objectArray[i2]).getRelativePath().getElements();
                if (relativePathElementArray == null || relativePathElementArray.length == 0) {
                    throw new StatusException("no elements", StatusCodes.Bad_NothingToDo);
                }
                for (RelativePathElement relativePathElement : relativePathElementArray) {
                    QualifiedName qualifiedName = relativePathElement.getTargetName();
                    if (!QualifiedName.isNull(qualifiedName) && !qualifiedName.getName().isEmpty()) continue;
                    throw new StatusException(StatusCodes.Bad_BrowseNameInvalid);
                }
                browsePathResultArray[i2].setTargets(this.translateBrowsePath(serviceContext, ((BrowsePath)objectArray[i2]).getStartingNode(), ((BrowsePath)objectArray[i2]).getRelativePath()));
                browsePathResultArray[i2].setStatusCode(StatusCode.GOOD);
                continue;
            }
            catch (StatusException statusException) {
                logger.debug("StatusException: ", (Throwable)statusException);
                browsePathResultArray[i2].setStatusCode(statusException.getStatusCode());
                diagnosticInfoArray[i2] = statusException.getDiagnosticInfo();
            }
        }
        translateBrowsePathsToNodeIdsResponse.setResults(browsePathResultArray);
        translateBrowsePathsToNodeIdsResponse.setDiagnosticInfos(diagnosticInfoArray);
    }

    protected void unregisterNode(ServiceContext serviceContext, NodeId nodeId) throws StatusException {
        this.getNodeManagerTable().unregisterNode(serviceContext, nodeId);
    }

    protected void unregisterNodes(ServiceContext serviceContext, UnregisterNodesRequest unregisterNodesRequest, UnregisterNodesResponse unregisterNodesResponse) throws ServiceException {
        Object[] objectArray = unregisterNodesRequest.getNodesToUnregister();
        this.checkRequestLength(objectArray, this.getMaxNodesPerRegisterNodes());
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            try {
                this.unregisterNode(serviceContext, (NodeId)objectArray[i2]);
                continue;
            }
            catch (StatusException statusException) {
                logger.debug("StatusException: ", (Throwable)statusException);
            }
        }
    }
}

