/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaVariable;
import com.prosysopc.ua.server.HistoryContinuationPoint;
import com.prosysopc.ua.server.HistoryManagerListener;
import com.prosysopc.ua.server.HistoryResult;
import com.prosysopc.ua.server.NodeManager;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.server.ServiceManagerBase;
import com.prosysopc.ua.server.Session;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.AccessLevelType;
import com.prosysopc.ua.stack.core.AggregateConfiguration;
import com.prosysopc.ua.stack.core.DeleteAtTimeDetails;
import com.prosysopc.ua.stack.core.DeleteEventDetails;
import com.prosysopc.ua.stack.core.DeleteRawModifiedDetails;
import com.prosysopc.ua.stack.core.EventFilter;
import com.prosysopc.ua.stack.core.HistoryData;
import com.prosysopc.ua.stack.core.HistoryEvent;
import com.prosysopc.ua.stack.core.HistoryEventFieldList;
import com.prosysopc.ua.stack.core.HistoryModifiedData;
import com.prosysopc.ua.stack.core.HistoryReadDetails;
import com.prosysopc.ua.stack.core.HistoryReadValueId;
import com.prosysopc.ua.stack.core.HistoryUpdateDetails;
import com.prosysopc.ua.stack.core.HistoryUpdateResult;
import com.prosysopc.ua.stack.core.PerformUpdateType;
import com.prosysopc.ua.stack.core.ReadAtTimeDetails;
import com.prosysopc.ua.stack.core.ReadEventDetails;
import com.prosysopc.ua.stack.core.ReadProcessedDetails;
import com.prosysopc.ua.stack.core.ReadRawModifiedDetails;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.core.TimestampsToReturn;
import com.prosysopc.ua.stack.core.UpdateDataDetails;
import com.prosysopc.ua.stack.core.UpdateEventDetails;
import com.prosysopc.ua.stack.core.UpdateStructureDataDetails;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.stack.utils.NumericRange;
import java.util.concurrent.atomic.AtomicReference;

public class HistoryManager
extends ServiceManagerBase {
    private static final HistoryManagerListener ja = new HistoryManagerListener(){

        @Override
        public Object onBeginHistoryRead(ServiceContext serviceContext, HistoryReadDetails historyReadDetails, TimestampsToReturn timestampsToReturn, HistoryReadValueId[] historyReadValueIdArray, HistoryContinuationPoint[] historyContinuationPointArray, HistoryResult[] historyResultArray) throws ServiceException {
            return null;
        }

        @Override
        public Object onBeginHistoryUpdate(ServiceContext serviceContext, HistoryUpdateDetails[] historyUpdateDetailsArray, HistoryUpdateResult[] historyUpdateResultArray, DiagnosticInfo[] diagnosticInfoArray) throws ServiceException {
            return null;
        }

        @Override
        public void onDeleteAtTimes(ServiceContext serviceContext, Object object, NodeId nodeId, UaNode uaNode, DateTime[] dateTimeArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        }

        @Override
        public void onDeleteEvents(ServiceContext serviceContext, Object object, NodeId nodeId, UaNode uaNode, ByteString[] byteStringArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        }

        @Override
        public void onDeleteModified(ServiceContext serviceContext, Object object, NodeId nodeId, UaNode uaNode, DateTime dateTime, DateTime dateTime2) throws StatusException {
        }

        @Override
        public void onDeleteRaw(ServiceContext serviceContext, Object object, NodeId nodeId, UaNode uaNode, DateTime dateTime, DateTime dateTime2) throws StatusException {
        }

        @Override
        public void onEndHistoryRead(ServiceContext serviceContext, Object object, HistoryReadDetails historyReadDetails, TimestampsToReturn timestampsToReturn, HistoryReadValueId[] historyReadValueIdArray, HistoryContinuationPoint[] historyContinuationPointArray, HistoryResult[] historyResultArray) throws ServiceException {
        }

        @Override
        public void onEndHistoryUpdate(ServiceContext serviceContext, Object object, HistoryUpdateDetails[] historyUpdateDetailsArray, HistoryUpdateResult[] historyUpdateResultArray, DiagnosticInfo[] diagnosticInfoArray) throws ServiceException {
        }

        @Override
        public Object onReadAtTimes(ServiceContext serviceContext, Object object, TimestampsToReturn timestampsToReturn, NodeId nodeId, UaNode uaNode, Object object2, DateTime[] dateTimeArray, Boolean bl, NumericRange numericRange, HistoryData historyData) throws StatusException {
            return null;
        }

        @Override
        public Object onReadEvents(ServiceContext serviceContext, Object object, NodeId nodeId, UaNode uaNode, Object object2, DateTime dateTime, DateTime dateTime2, UnsignedInteger unsignedInteger, EventFilter eventFilter, HistoryEvent historyEvent) throws StatusException {
            return null;
        }

        @Override
        public Object onReadModified(ServiceContext serviceContext, Object object, TimestampsToReturn timestampsToReturn, NodeId nodeId, UaNode uaNode, Object object2, DateTime dateTime, DateTime dateTime2, UnsignedInteger unsignedInteger, NumericRange numericRange, HistoryModifiedData historyModifiedData) throws StatusException {
            return null;
        }

        @Override
        public Object onReadProcessed(ServiceContext serviceContext, Object object, TimestampsToReturn timestampsToReturn, NodeId nodeId, UaNode uaNode, Object object2, DateTime dateTime, DateTime dateTime2, Double d2, NodeId nodeId2, AggregateConfiguration aggregateConfiguration, NumericRange numericRange, HistoryData historyData) throws StatusException {
            return null;
        }

        @Override
        public Object onReadRaw(ServiceContext serviceContext, Object object, TimestampsToReturn timestampsToReturn, NodeId nodeId, UaNode uaNode, Object object2, DateTime dateTime, DateTime dateTime2, UnsignedInteger unsignedInteger, Boolean bl, NumericRange numericRange, HistoryData historyData) throws StatusException {
            return null;
        }

        @Override
        public void onUpdateData(ServiceContext serviceContext, Object object, NodeId nodeId, UaNode uaNode, DataValue[] dataValueArray, PerformUpdateType performUpdateType, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        }

        @Override
        public void onUpdateEvent(ServiceContext serviceContext, Object object, NodeId nodeId, UaNode uaNode, Variant[] variantArray, EventFilter eventFilter, PerformUpdateType performUpdateType, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        }

        @Override
        public void onUpdateStructureData(ServiceContext serviceContext, Object object, NodeId nodeId, UaNode uaNode, DataValue[] dataValueArray, PerformUpdateType performUpdateType, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) {
        }
    };
    private final AtomicReference<HistoryManagerListener> listener = new AtomicReference<HistoryManagerListener>(ja);

    public static NodeId getNodeIdFromHistoryUpdateDetails(HistoryUpdateDetails historyUpdateDetails) {
        if (historyUpdateDetails == null) {
            return null;
        }
        try {
            return (NodeId)historyUpdateDetails.get("NodeId");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public HistoryManager(NodeManager nodeManager) {
        super(nodeManager.getServer());
        nodeManager.setHistoryManager(this);
    }

    public HistoryManagerListener getListener() {
        return this.listener.get();
    }

    public void setListener(HistoryManagerListener historyManagerListener) {
        this.listener.set(historyManagerListener);
    }

    private Object a(ServiceContext serviceContext, HistoryReadDetails historyReadDetails, TimestampsToReturn timestampsToReturn, HistoryReadValueId[] historyReadValueIdArray, HistoryContinuationPoint[] historyContinuationPointArray, HistoryResult[] historyResultArray) throws ServiceException {
        return this.getListener().onBeginHistoryRead(serviceContext, historyReadDetails, timestampsToReturn, historyReadValueIdArray, historyContinuationPointArray, historyResultArray);
    }

    private Object a(ServiceContext serviceContext, HistoryUpdateDetails[] historyUpdateDetailsArray, HistoryUpdateResult[] historyUpdateResultArray, DiagnosticInfo[] diagnosticInfoArray) throws ServiceException {
        return this.getListener().onBeginHistoryUpdate(serviceContext, historyUpdateDetailsArray, historyUpdateResultArray, diagnosticInfoArray);
    }

    private void a(ServiceContext serviceContext, Object object, NodeId nodeId, UaNode uaNode, DateTime[] dateTimeArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        this.getListener().onDeleteAtTimes(serviceContext, object, nodeId, uaNode, dateTimeArray, statusCodeArray, diagnosticInfoArray);
    }

    private void a(ServiceContext serviceContext, Object object, NodeId nodeId, UaNode uaNode, ByteString[] byteStringArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        this.getListener().onDeleteEvents(serviceContext, object, nodeId, uaNode, byteStringArray, statusCodeArray, diagnosticInfoArray);
    }

    private void a(ServiceContext serviceContext, Object object, NodeId nodeId, UaNode uaNode, DateTime dateTime, DateTime dateTime2) throws StatusException {
        this.getListener().onDeleteModified(serviceContext, object, nodeId, uaNode, dateTime, dateTime2);
    }

    private void b(ServiceContext serviceContext, Object object, NodeId nodeId, UaNode uaNode, DateTime dateTime, DateTime dateTime2) throws StatusException {
        this.getListener().onDeleteRaw(serviceContext, object, nodeId, uaNode, dateTime, dateTime2);
    }

    private void a(ServiceContext serviceContext, Object object, HistoryReadDetails historyReadDetails, TimestampsToReturn timestampsToReturn, HistoryReadValueId[] historyReadValueIdArray, HistoryContinuationPoint[] historyContinuationPointArray, HistoryResult[] historyResultArray) throws ServiceException {
        this.getListener().onEndHistoryRead(serviceContext, object, historyReadDetails, timestampsToReturn, historyReadValueIdArray, historyContinuationPointArray, historyResultArray);
    }

    private void a(ServiceContext serviceContext, Object object, HistoryUpdateDetails[] historyUpdateDetailsArray, HistoryUpdateResult[] historyUpdateResultArray, DiagnosticInfo[] diagnosticInfoArray) throws ServiceException {
        this.getListener().onEndHistoryUpdate(serviceContext, object, historyUpdateDetailsArray, historyUpdateResultArray, diagnosticInfoArray);
    }

    private Object a(ServiceContext serviceContext, Object object, TimestampsToReturn timestampsToReturn, NodeId nodeId, UaNode uaNode, Object object2, DateTime[] dateTimeArray, Boolean bl, NumericRange numericRange, HistoryData historyData) throws StatusException {
        return this.getListener().onReadAtTimes(serviceContext, object, timestampsToReturn, nodeId, uaNode, object2, dateTimeArray, bl, numericRange, historyData);
    }

    private Object a(ServiceContext serviceContext, Object object, NodeId nodeId, UaNode uaNode, Object object2, DateTime dateTime, DateTime dateTime2, UnsignedInteger unsignedInteger, EventFilter eventFilter, HistoryEvent historyEvent) throws StatusException {
        return this.getListener().onReadEvents(serviceContext, object, nodeId, uaNode, object2, dateTime, dateTime2, unsignedInteger, eventFilter, historyEvent);
    }

    private Object a(ServiceContext serviceContext, Object object, TimestampsToReturn timestampsToReturn, NodeId nodeId, UaNode uaNode, Object object2, DateTime dateTime, DateTime dateTime2, UnsignedInteger unsignedInteger, NumericRange numericRange, HistoryModifiedData historyModifiedData) throws StatusException {
        return this.getListener().onReadModified(serviceContext, object, timestampsToReturn, nodeId, uaNode, object2, dateTime, dateTime2, unsignedInteger, numericRange, historyModifiedData);
    }

    private Object a(ServiceContext serviceContext, Object object, TimestampsToReturn timestampsToReturn, NodeId nodeId, UaNode uaNode, Object object2, DateTime dateTime, DateTime dateTime2, Double d2, NodeId nodeId2, AggregateConfiguration aggregateConfiguration, NumericRange numericRange, HistoryData historyData) throws StatusException {
        return this.getListener().onReadProcessed(serviceContext, object, timestampsToReturn, nodeId, uaNode, object2, dateTime, dateTime2, d2, nodeId2, aggregateConfiguration, numericRange, historyData);
    }

    private Object a(ServiceContext serviceContext, Object object, TimestampsToReturn timestampsToReturn, NodeId nodeId, UaNode uaNode, Object object2, DateTime dateTime, DateTime dateTime2, UnsignedInteger unsignedInteger, Boolean bl, NumericRange numericRange, HistoryData historyData) throws StatusException {
        return this.getListener().onReadRaw(serviceContext, object, timestampsToReturn, nodeId, uaNode, object2, dateTime, dateTime2, unsignedInteger, bl, numericRange, historyData);
    }

    private void a(ServiceContext serviceContext, Object object, NodeId nodeId, UaNode uaNode, DataValue[] dataValueArray, PerformUpdateType performUpdateType, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        this.getListener().onUpdateData(serviceContext, object, nodeId, uaNode, dataValueArray, performUpdateType, statusCodeArray, diagnosticInfoArray);
    }

    private void a(ServiceContext serviceContext, Object object, NodeId nodeId, UaNode uaNode, Variant[] variantArray, EventFilter eventFilter, PerformUpdateType performUpdateType, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        this.getListener().onUpdateEvent(serviceContext, object, nodeId, uaNode, variantArray, eventFilter, performUpdateType, statusCodeArray, diagnosticInfoArray);
    }

    private void b(ServiceContext serviceContext, Object object, NodeId nodeId, UaNode uaNode, DataValue[] dataValueArray, PerformUpdateType performUpdateType, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        this.getListener().onUpdateStructureData(serviceContext, object, nodeId, uaNode, dataValueArray, performUpdateType, statusCodeArray, diagnosticInfoArray);
    }

    protected Object beginHistoryRead(ServiceContext serviceContext, HistoryReadDetails historyReadDetails, TimestampsToReturn timestampsToReturn, HistoryReadValueId[] historyReadValueIdArray, HistoryContinuationPoint[] historyContinuationPointArray, HistoryResult[] historyResultArray) throws ServiceException {
        return this.a(serviceContext, historyReadDetails, timestampsToReturn, historyReadValueIdArray, historyContinuationPointArray, historyResultArray);
    }

    protected Object beginHistoryUpdate(ServiceContext serviceContext, HistoryUpdateDetails[] historyUpdateDetailsArray, HistoryUpdateResult[] historyUpdateResultArray, DiagnosticInfo[] diagnosticInfoArray) throws ServiceException {
        return this.a(serviceContext, historyUpdateDetailsArray, historyUpdateResultArray, diagnosticInfoArray);
    }

    protected void deleteAtTimes(ServiceContext serviceContext, Object object, NodeId nodeId, UaNode uaNode, DateTime[] dateTimeArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
    }

    protected void deleteEvents(ServiceContext serviceContext, Object object, NodeId nodeId, UaNode uaNode, ByteString[] byteStringArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
    }

    protected void deleteModified(ServiceContext serviceContext, Object object, NodeId nodeId, UaNode uaNode, DateTime dateTime, DateTime dateTime2) throws StatusException {
    }

    protected void deleteRaw(ServiceContext serviceContext, Object object, NodeId nodeId, UaNode uaNode, DateTime dateTime, DateTime dateTime2) throws StatusException {
    }

    protected void endHistoryRead(ServiceContext serviceContext, Object object, HistoryReadDetails historyReadDetails, TimestampsToReturn timestampsToReturn, HistoryReadValueId[] historyReadValueIdArray, HistoryContinuationPoint[] historyContinuationPointArray, HistoryResult[] historyResultArray) throws ServiceException {
        this.a(serviceContext, object, historyReadDetails, timestampsToReturn, historyReadValueIdArray, historyContinuationPointArray, historyResultArray);
    }

    protected void endHistoryUpdate(ServiceContext serviceContext, Object object, HistoryUpdateDetails[] historyUpdateDetailsArray, HistoryUpdateResult[] historyUpdateResultArray, DiagnosticInfo[] diagnosticInfoArray) throws ServiceException {
        this.a(serviceContext, object, historyUpdateDetailsArray, historyUpdateResultArray, diagnosticInfoArray);
    }

    protected HistoryResult historyRead(ServiceContext serviceContext, Object object, TimestampsToReturn timestampsToReturn, NodeId nodeId, NumericRange numericRange, HistoryContinuationPoint historyContinuationPoint, HistoryReadDetails historyReadDetails, int n2) throws StatusException {
        AbstractStructure abstractStructure;
        UaNode uaNode = this.getNode(nodeId);
        UaVariable uaVariable = null;
        if (uaNode instanceof UaVariable) {
            uaVariable = (UaVariable)uaNode;
            this.getNodeManagerTable().getIoManager(nodeId).checkAccessLevel(serviceContext, object, nodeId, uaVariable, AccessLevelType.Options.HistoryRead);
        }
        Object object2 = null;
        if (historyContinuationPoint != null) {
            historyReadDetails = historyContinuationPoint.getDetails();
            timestampsToReturn = historyContinuationPoint.getTimestampsToReturn();
            object2 = historyContinuationPoint.getUserContinuationPoint();
        }
        Object object3 = null;
        if (historyReadDetails instanceof ReadEventDetails) {
            ReadEventDetails readEventDetails = (ReadEventDetails)historyReadDetails;
            HistoryEvent historyEvent = new HistoryEvent();
            object3 = this.a(serviceContext, object, nodeId, uaNode, object2, readEventDetails.getStartTime(), readEventDetails.getEndTime(), readEventDetails.getNumValuesPerNode(), readEventDetails.getFilter(), historyEvent);
            if (object3 == null) {
                object3 = this.readEvents(serviceContext, object, object, nodeId, uaNode, object2, readEventDetails.getStartTime(), readEventDetails.getEndTime(), readEventDetails.getNumValuesPerNode(), readEventDetails.getFilter(), historyEvent);
            }
            abstractStructure = historyEvent;
        } else if (historyReadDetails instanceof ReadRawModifiedDetails) {
            ReadRawModifiedDetails readRawModifiedDetails = (ReadRawModifiedDetails)historyReadDetails;
            if (readRawModifiedDetails.getIsReadModified().booleanValue()) {
                if (readRawModifiedDetails.getReturnBounds() != null && readRawModifiedDetails.getReturnBounds().booleanValue()) {
                    throw new StatusException(StatusCodes.Bad_InvalidArgument);
                }
                HistoryModifiedData historyModifiedData = new HistoryModifiedData();
                object3 = this.a(serviceContext, object, timestampsToReturn, nodeId, uaNode, object2, readRawModifiedDetails.getStartTime(), readRawModifiedDetails.getEndTime(), readRawModifiedDetails.getNumValuesPerNode(), numericRange, historyModifiedData);
                if (object3 == null) {
                    object3 = this.readModified(serviceContext, object, timestampsToReturn, nodeId, uaNode, object2, readRawModifiedDetails.getStartTime(), readRawModifiedDetails.getEndTime(), readRawModifiedDetails.getNumValuesPerNode(), numericRange, historyModifiedData);
                }
                abstractStructure = historyModifiedData;
            } else {
                HistoryData historyData = new HistoryData();
                object3 = this.a(serviceContext, object, timestampsToReturn, nodeId, uaNode, object2, readRawModifiedDetails.getStartTime(), readRawModifiedDetails.getEndTime(), readRawModifiedDetails.getNumValuesPerNode(), readRawModifiedDetails.getReturnBounds(), numericRange, historyData);
                if (object3 == null) {
                    object3 = this.readRaw(serviceContext, object, timestampsToReturn, nodeId, uaNode, object2, readRawModifiedDetails.getStartTime(), readRawModifiedDetails.getEndTime(), readRawModifiedDetails.getNumValuesPerNode(), readRawModifiedDetails.getReturnBounds(), numericRange, historyData);
                }
                abstractStructure = historyData;
            }
        } else if (historyReadDetails instanceof ReadProcessedDetails) {
            NodeId nodeId2;
            ReadProcessedDetails readProcessedDetails = (ReadProcessedDetails)historyReadDetails;
            if (readProcessedDetails.getStartTime().equals(readProcessedDetails.getEndTime())) {
                throw new StatusException("StartTime must not equal EndTime for a ReadProcessed request.", StatusCodes.Bad_InvalidArgument);
            }
            HistoryData historyData = new HistoryData();
            try {
                nodeId2 = readProcessedDetails.getAggregateType()[n2];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new StatusException(StatusCodes.Bad_AggregateListMismatch);
            }
            object3 = this.a(serviceContext, object, timestampsToReturn, nodeId, uaNode, object2, readProcessedDetails.getStartTime(), readProcessedDetails.getEndTime(), readProcessedDetails.getProcessingInterval(), nodeId2, readProcessedDetails.getAggregateConfiguration(), numericRange, historyData);
            if (object3 == null) {
                object3 = this.readProcessed(serviceContext, object, timestampsToReturn, nodeId, uaNode, object2, readProcessedDetails.getStartTime(), readProcessedDetails.getEndTime(), readProcessedDetails.getProcessingInterval(), nodeId2, readProcessedDetails.getAggregateConfiguration(), numericRange, historyData);
            }
            abstractStructure = historyData;
        } else if (historyReadDetails instanceof ReadAtTimeDetails) {
            ReadAtTimeDetails readAtTimeDetails = (ReadAtTimeDetails)historyReadDetails;
            HistoryData historyData = new HistoryData();
            object3 = this.a(serviceContext, object, timestampsToReturn, nodeId, uaNode, object2, readAtTimeDetails.getReqTimes(), readAtTimeDetails.getUseSimpleBounds(), numericRange, historyData);
            if (object3 == null) {
                object3 = this.readAtTimes(serviceContext, object, timestampsToReturn, nodeId, uaNode, object2, readAtTimeDetails.getReqTimes(), numericRange, historyData);
            }
            abstractStructure = historyData;
        } else {
            throw new StatusException(StatusCodes.Bad_HistoryOperationInvalid);
        }
        return new HistoryResult(abstractStructure, object3);
    }

    protected void historyUpdate(ServiceContext serviceContext, Object object, HistoryUpdateDetails historyUpdateDetails, HistoryUpdateResult historyUpdateResult) throws StatusException {
        UaNode uaNode = this.getNode(HistoryManager.getNodeIdFromHistoryUpdateDetails(historyUpdateDetails));
        StatusCode[] statusCodeArray = null;
        DiagnosticInfo[] diagnosticInfoArray = null;
        if (historyUpdateDetails instanceof DeleteAtTimeDetails) {
            DeleteAtTimeDetails deleteAtTimeDetails = (DeleteAtTimeDetails)historyUpdateDetails;
            DateTime[] dateTimeArray = deleteAtTimeDetails.getReqTimes();
            statusCodeArray = new StatusCode[dateTimeArray.length];
            diagnosticInfoArray = new DiagnosticInfo[dateTimeArray.length];
            this.a(serviceContext, object, deleteAtTimeDetails.getNodeId(), uaNode, dateTimeArray, statusCodeArray, diagnosticInfoArray);
            this.deleteAtTimes(serviceContext, object, deleteAtTimeDetails.getNodeId(), uaNode, dateTimeArray, statusCodeArray, diagnosticInfoArray);
        } else if (historyUpdateDetails instanceof DeleteEventDetails) {
            DeleteEventDetails deleteEventDetails = (DeleteEventDetails)historyUpdateDetails;
            ByteString[] byteStringArray = deleteEventDetails.getEventIds();
            statusCodeArray = new StatusCode[byteStringArray.length];
            diagnosticInfoArray = new DiagnosticInfo[byteStringArray.length];
            this.a(serviceContext, object, deleteEventDetails.getNodeId(), uaNode, byteStringArray, statusCodeArray, diagnosticInfoArray);
            this.deleteEvents(serviceContext, object, deleteEventDetails.getNodeId(), uaNode, byteStringArray, statusCodeArray, diagnosticInfoArray);
        } else if (historyUpdateDetails instanceof DeleteRawModifiedDetails) {
            DeleteRawModifiedDetails deleteRawModifiedDetails = (DeleteRawModifiedDetails)historyUpdateDetails;
            if (deleteRawModifiedDetails.getIsDeleteModified().booleanValue()) {
                this.a(serviceContext, object, deleteRawModifiedDetails.getNodeId(), uaNode, deleteRawModifiedDetails.getStartTime(), deleteRawModifiedDetails.getEndTime());
                this.deleteModified(serviceContext, object, deleteRawModifiedDetails.getNodeId(), uaNode, deleteRawModifiedDetails.getStartTime(), deleteRawModifiedDetails.getEndTime());
            } else {
                this.b(serviceContext, object, deleteRawModifiedDetails.getNodeId(), uaNode, deleteRawModifiedDetails.getStartTime(), deleteRawModifiedDetails.getEndTime());
                this.deleteRaw(serviceContext, object, deleteRawModifiedDetails.getNodeId(), uaNode, deleteRawModifiedDetails.getStartTime(), deleteRawModifiedDetails.getEndTime());
            }
        } else if (historyUpdateDetails instanceof UpdateDataDetails) {
            UpdateDataDetails updateDataDetails = (UpdateDataDetails)historyUpdateDetails;
            DataValue[] dataValueArray = updateDataDetails.getUpdateValues();
            statusCodeArray = new StatusCode[dataValueArray.length];
            diagnosticInfoArray = new DiagnosticInfo[dataValueArray.length];
            this.a(serviceContext, object, updateDataDetails.getNodeId(), uaNode, dataValueArray, updateDataDetails.getPerformInsertReplace(), statusCodeArray, diagnosticInfoArray);
            this.updateData(serviceContext, object, updateDataDetails.getNodeId(), uaNode, dataValueArray, updateDataDetails.getPerformInsertReplace(), statusCodeArray, diagnosticInfoArray);
        } else if (historyUpdateDetails instanceof UpdateStructureDataDetails) {
            UpdateStructureDataDetails updateStructureDataDetails = (UpdateStructureDataDetails)historyUpdateDetails;
            DataValue[] dataValueArray = updateStructureDataDetails.getUpdateValues();
            statusCodeArray = new StatusCode[dataValueArray.length];
            diagnosticInfoArray = new DiagnosticInfo[dataValueArray.length];
            this.b(serviceContext, object, updateStructureDataDetails.getNodeId(), uaNode, dataValueArray, updateStructureDataDetails.getPerformInsertReplace(), statusCodeArray, diagnosticInfoArray);
            this.updateStructureData(serviceContext, object, updateStructureDataDetails.getNodeId(), uaNode, dataValueArray, updateStructureDataDetails.getPerformInsertReplace(), statusCodeArray, diagnosticInfoArray);
        } else if (historyUpdateDetails instanceof UpdateEventDetails) {
            UpdateEventDetails updateEventDetails = (UpdateEventDetails)historyUpdateDetails;
            for (HistoryEventFieldList historyEventFieldList : updateEventDetails.getEventData()) {
                Variant[] variantArray = Variant.asVariantArray(historyEventFieldList.getEventFields());
                int n2 = variantArray == null ? 0 : variantArray.length;
                statusCodeArray = new StatusCode[n2];
                diagnosticInfoArray = new DiagnosticInfo[n2];
                this.a(serviceContext, object, updateEventDetails.getNodeId(), uaNode, variantArray, updateEventDetails.getFilter(), updateEventDetails.getPerformInsertReplace(), statusCodeArray, diagnosticInfoArray);
                this.updateEvent(serviceContext, object, updateEventDetails.getNodeId(), uaNode, variantArray, updateEventDetails.getFilter(), updateEventDetails.getPerformInsertReplace(), statusCodeArray, diagnosticInfoArray);
            }
        } else {
            throw new StatusException(StatusCodes.Bad_HistoryOperationInvalid);
        }
        historyUpdateResult.setOperationResults(statusCodeArray);
        historyUpdateResult.setDiagnosticInfos(diagnosticInfoArray);
    }

    protected Object readAtTimes(ServiceContext serviceContext, Object object, TimestampsToReturn timestampsToReturn, NodeId nodeId, UaNode uaNode, Object object2, DateTime[] dateTimeArray, NumericRange numericRange, HistoryData historyData) throws StatusException {
        return null;
    }

    protected Object readEvents(ServiceContext serviceContext, Object object, Object object2, NodeId nodeId, UaNode uaNode, Object object3, DateTime dateTime, DateTime dateTime2, UnsignedInteger unsignedInteger, EventFilter eventFilter, HistoryEvent historyEvent) throws StatusException {
        return null;
    }

    protected Object readModified(ServiceContext serviceContext, Object object, TimestampsToReturn timestampsToReturn, NodeId nodeId, UaNode uaNode, Object object2, DateTime dateTime, DateTime dateTime2, UnsignedInteger unsignedInteger, NumericRange numericRange, HistoryModifiedData historyModifiedData) throws StatusException {
        return null;
    }

    protected Object readProcessed(ServiceContext serviceContext, Object object, TimestampsToReturn timestampsToReturn, NodeId nodeId, UaNode uaNode, Object object2, DateTime dateTime, DateTime dateTime2, Double d2, NodeId nodeId2, AggregateConfiguration aggregateConfiguration, NumericRange numericRange, HistoryData historyData) throws StatusException {
        return null;
    }

    protected Object readRaw(ServiceContext serviceContext, Object object, TimestampsToReturn timestampsToReturn, NodeId nodeId, UaNode uaNode, Object object2, DateTime dateTime, DateTime dateTime2, UnsignedInteger unsignedInteger, Boolean bl, NumericRange numericRange, HistoryData historyData) throws StatusException {
        return null;
    }

    protected void releaseHistoryContinuationPoint(ServiceContext serviceContext, NodeId nodeId, ByteString byteString) throws StatusException {
        Session session = serviceContext.getSession();
        if (session.getHistoryContinuationPoint(byteString) == null) {
            throw new StatusException(StatusCodes.Bad_ContinuationPointInvalid);
        }
    }

    @Override
    protected boolean requireUaNode() {
        return false;
    }

    protected void updateData(ServiceContext serviceContext, Object object, NodeId nodeId, UaNode uaNode, DataValue[] dataValueArray, PerformUpdateType performUpdateType, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
    }

    protected void updateEvent(ServiceContext serviceContext, Object object, NodeId nodeId, UaNode uaNode, Variant[] variantArray, EventFilter eventFilter, PerformUpdateType performUpdateType, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
    }

    protected void updateStructureData(ServiceContext serviceContext, Object object, NodeId nodeId, UaNode uaNode, DataValue[] dataValueArray, PerformUpdateType performUpdateType, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
    }
}

