/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.nodes;

import com.prosysopc.ua.InternalUaNodeParameters;
import com.prosysopc.ua.RegisteredClasses;
import com.prosysopc.ua.UaAddressSpace;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.UaQualifiedName;
import com.prosysopc.ua.nodes.UaInstance;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaNodeFactory;
import com.prosysopc.ua.nodes.UaNodeFactoryException;
import com.prosysopc.ua.nodes.UaType;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.common.NamespaceTable;
import com.prosysopc.ua.stack.core.NodeClass;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractUaNodeFactory
implements UaNodeFactory {
    private static final Logger logger = LoggerFactory.getLogger(AbstractUaNodeFactory.class);
    private final UaAddressSpace ii;
    private final Map<NodeClass, Function<UaNode.Parameters, ? extends UaNode>> ij;
    private final Map<UaNodeId, Function<UaNode.Parameters, ? extends UaNode>> ik;

    protected AbstractUaNodeFactory(UaAddressSpace uaAddressSpace) {
        this.ii = uaAddressSpace;
        this.ij = new EnumMap<NodeClass, Function<UaNode.Parameters, ? extends UaNode>>(NodeClass.class);
        this.ik = new HashMap<UaNodeId, Function<UaNode.Parameters, ? extends UaNode>>();
    }

    @Override
    public UaNode createNode(NodeClass nodeClass, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) throws UaNodeFactoryException {
        return this.createNode(nodeClass, nodeId, qualifiedName, localizedText, (NodeId)null);
    }

    @Override
    public UaNode createNode(NodeClass nodeClass, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText, ExpandedNodeId expandedNodeId) throws UaNodeFactoryException {
        Function<UaNode.Parameters, ? extends UaNode> function = this.getConstructor(nodeClass, UaNodeId.fromLocal(expandedNodeId, this.getNamespaceTable()));
        if (function == null) {
            throw new UaNodeFactoryException(String.format(Locale.ROOT, "Cannot find constructor for nodeClass=%s typeDefinition=%s", nodeClass, expandedNodeId), null);
        }
        return this.createInstance(function, nodeId, qualifiedName, localizedText, expandedNodeId);
    }

    @Override
    public UaNode createNode(NodeClass nodeClass, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText, NodeId nodeId2) throws UaNodeFactoryException {
        Function<UaNode.Parameters, ? extends UaNode> function = this.getConstructor(nodeClass, UaNodeId.fromLocal(nodeId2, this.getNamespaceTable()));
        return this.createInstance(function, nodeId, qualifiedName, localizedText, nodeId2 == null ? null : new ExpandedNodeId(nodeId2));
    }

    @Override
    public UaNode createNode(NodeClass nodeClass, NodeId nodeId, String string, Locale locale) throws UaNodeFactoryException {
        return this.createNode(nodeClass, nodeId, new QualifiedName(string), new LocalizedText(string, locale));
    }

    @Override
    public UaNode createNode(NodeClass nodeClass, NodeId nodeId, String string, Locale locale, ExpandedNodeId expandedNodeId) throws UaNodeFactoryException {
        return this.createNode(nodeClass, nodeId, new QualifiedName(string), new LocalizedText(string, locale), expandedNodeId);
    }

    @Override
    public UaNode createNode(NodeClass nodeClass, NodeId nodeId, String string, Locale locale, NodeId nodeId2) throws UaNodeFactoryException {
        return this.createNode(nodeClass, nodeId, new QualifiedName(string), new LocalizedText(string, locale), nodeId2);
    }

    @Override
    public <T extends UaNode> void registerNodeClass(NodeClass nodeClass, Function<UaNode.Parameters, T> function) throws UaNodeFactoryException {
        this.ij.put(nodeClass, function);
    }

    @Override
    public <T extends UaNode> void registerTypeDefinition(UaNodeId uaNodeId, Function<UaNode.Parameters, T> function) throws UaNodeFactoryException {
        this.ik.put(uaNodeId, function);
    }

    protected UaNode createInstance(Function<UaNode.Parameters, ? extends UaNode> function, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText, ExpandedNodeId expandedNodeId) throws UaNodeFactoryException {
        logger.debug("createInstance: constructor:{} , nodeId:{}, browseName:{}, typeDefinition: {}", new Object[]{function, nodeId, qualifiedName, expandedNodeId});
        try {
            NamespaceTable namespaceTable = this.ii.getNamespaceTable();
            UaQualifiedName uaQualifiedName = QualifiedName.isNull(qualifiedName) ? null : UaQualifiedName.from(qualifiedName, namespaceTable);
            InternalUaNodeParameters internalUaNodeParameters = new InternalUaNodeParameters(this.ii, UaNodeId.fromLocal(nodeId, namespaceTable), uaQualifiedName, localizedText);
            UaNode uaNode = function.apply(internalUaNodeParameters);
            if (uaNode instanceof UaInstance) {
                ((UaInstance)uaNode).setTypeDefinitionId(expandedNodeId);
            }
            return uaNode;
        }
        catch (Exception exception) {
            logger.debug("Error in UaServerNodeFactory.createInstance:", (Throwable)exception);
            throw new UaNodeFactoryException("Cannot create a new UaNode instance using constructor " + function.getClass(), exception);
        }
    }

    protected Function<UaNode.Parameters, ? extends UaNode> getConstructor(NodeClass nodeClass, UaNodeId uaNodeId) {
        if (uaNodeId != null) {
            if (this.ik.containsKey(uaNodeId)) {
                return this.ik.get(uaNodeId);
            }
            Function<UaNode.Parameters, ? extends UaInstance> function = this.getRegisteredClasses().getConstructor(uaNodeId);
            if (function != null) {
                return function;
            }
            UaType uaType = null;
            try {
                UaType uaType2 = this.getType(uaNodeId);
                uaType = uaType2.getSuperType();
            }
            catch (Exception exception) {
                logger.error("Could not resolve super type as UaType, typeId: {}", (Object)uaNodeId);
            }
            if (uaType != null) {
                return this.getConstructor(nodeClass, UaNodeId.fromLocal(uaType.getNodeId(), this.ii.getNamespaceTable()));
            }
        }
        return this.ij.get(nodeClass);
    }

    protected abstract NamespaceTable getNamespaceTable();

    protected abstract RegisteredClasses getRegisteredClasses();

    protected abstract UaType getType(UaNodeId var1) throws Exception;
}

