/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.client.nodes;

import com.prosysopc.ua.DataTypeConversionException;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.UaException;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.client.nodes.UaClientReference;
import com.prosysopc.ua.client.nodes.UaInstanceImpl;
import com.prosysopc.ua.client.nodes.a;
import com.prosysopc.ua.nodes.DataChangeListener;
import com.prosysopc.ua.nodes.UaDataType;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.nodes.UaVariable;
import com.prosysopc.ua.nodes.UaVariableType;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.AccessLevelExType;
import com.prosysopc.ua.stack.core.AccessLevelType;
import com.prosysopc.ua.stack.core.AttributeWriteMask;
import com.prosysopc.ua.stack.core.Attributes;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.stack.core.NodeAttributes;
import com.prosysopc.ua.stack.core.NodeClass;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.core.VariableAttributes;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class UaVariableImpl
extends UaInstanceImpl
implements UaVariable {
    private static final Logger logger = LoggerFactory.getLogger(UaVariableImpl.class);
    private AccessLevelType hZ = AccessLevelType.of(AccessLevelType.Options.values());
    private AccessLevelExType ia = null;
    private UnsignedInteger[] bs = null;
    private UaDataType ib;
    private NodeId ic = Identifiers.BaseDataType;
    private AccessLevelType id = AccessLevelType.of(AccessLevelType.Options.values());
    private DataValue fo = new DataValue();
    private int valueRank = -1;
    boolean ie = false;
    double if = -1.0;

    public UaVariableImpl(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
    }

    public UaVariableImpl(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText, LocalizedText localizedText2, AttributeWriteMask attributeWriteMask, AttributeWriteMask attributeWriteMask2, UaClientReference[] uaClientReferenceArray, UaProperty[] uaPropertyArray, NodeId nodeId2, Integer n2, UnsignedInteger[] unsignedIntegerArray, AccessLevelType accessLevelType, AccessLevelType accessLevelType2, Double d2, Boolean bl) {
        super(addressSpace, nodeId, qualifiedName, localizedText, localizedText2, attributeWriteMask, attributeWriteMask2, uaClientReferenceArray, uaPropertyArray);
        this.setDataTypeId(nodeId2);
        this.valueRank = n2;
        this.bs = unsignedIntegerArray;
        this.hZ = accessLevelType;
        this.id = accessLevelType2;
        this.if = d2;
        this.ie = bl;
    }

    public UaVariableImpl(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText, NodeId nodeId2) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
        this.setDataTypeId(nodeId2);
    }

    public UaVariableImpl(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText, UaDataType uaDataType) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
        this.setDataType(uaDataType);
    }

    public UaVariableImpl(AddressSpace addressSpace, NodeId nodeId, String string, Locale locale, NodeId nodeId2) {
        super(addressSpace, nodeId, string, locale);
        this.setDataTypeId(nodeId2);
    }

    public UaVariableImpl(AddressSpace addressSpace, NodeId nodeId, String string, Locale locale, UaDataType uaDataType) {
        super(addressSpace, nodeId, string, locale);
        this.setDataType(uaDataType);
    }

    protected UaVariableImpl(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void addDataChangeListener(DataChangeListener dataChangeListener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AccessLevelType getAccessLevel() {
        return this.hZ;
    }

    @Override
    public UnsignedInteger[] getArrayDimensions() {
        return this.bs;
    }

    @Override
    public NodeAttributes getAttributes() {
        return this.getAttributes(new VariableAttributes());
    }

    @Override
    public UaDataType getDataType() {
        if (this.ib == null && !NodeId.isNull(this.ic)) {
            try {
                this.ib = this.addressSpace.getDataType(this.getDataTypeId());
            }
            catch (UaException uaException) {
                throw new RuntimeException(uaException);
            }
        }
        return this.ib;
    }

    @Override
    public NodeId getDataTypeId() {
        return this.ic;
    }

    @Override
    public Boolean getHistorizing() {
        return this.ie;
    }

    @Override
    public Double getMinimumSamplingInterval() {
        return this.if;
    }

    @Override
    public final NodeClass getNodeClass() {
        return NodeClass.Variable;
    }

    @Override
    public AccessLevelType getUserAccessLevel() {
        return this.id;
    }

    @Override
    public DataValue getValue() {
        return this.fo;
    }

    @Override
    public Integer getValueRank() {
        return this.valueRank;
    }

    @Override
    public boolean hasUserWriteAccess(UnsignedInteger unsignedInteger) {
        if (unsignedInteger.equals(Attributes.Value)) {
            return this.id.contains(AccessLevelType.Options.CurrentWrite);
        }
        return super.hasUserWriteAccess(unsignedInteger);
    }

    @Override
    public boolean hasWriteAccess(UnsignedInteger unsignedInteger) {
        if (unsignedInteger.equals(Attributes.Value)) {
            return this.hZ.contains(AccessLevelType.Options.CurrentWrite);
        }
        return super.hasWriteAccess(unsignedInteger);
    }

    public DataValue readValue() throws StatusException, ServiceException {
        DataValue dataValue = this.addressSpace.getClient().readValue(this.getNodeId());
        this.setValue(dataValue);
        return this.getValue();
    }

    @Override
    public void removeDataChangeListener(DataChangeListener dataChangeListener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAccessLevel(AccessLevelType accessLevelType) {
        this.hZ = accessLevelType;
    }

    @Override
    public void setArrayDimensions(UnsignedInteger[] unsignedIntegerArray) {
        this.bs = unsignedIntegerArray;
    }

    @Override
    public void setAttribute(UnsignedInteger unsignedInteger, DataValue dataValue) throws StatusException {
        if (unsignedInteger.equals(Attributes.Value)) {
            this.setValue(dataValue);
        } else {
            super.setAttribute(unsignedInteger, dataValue);
        }
    }

    public void setAttributes(VariableAttributes variableAttributes) {
        super.setAttributes(variableAttributes);
        this.setArrayDimensions(variableAttributes.getArrayDimensions());
        this.setDataTypeId(variableAttributes.getDataType());
        this.setHistorizing(variableAttributes.getHistorizing());
        this.setMinimumSamplingInterval(variableAttributes.getMinimumSamplingInterval());
        try {
            this.setValue(new DataValue(new Variant(variableAttributes.getValue()), StatusCode.GOOD, DateTime.currentTime(), DateTime.currentTime()));
        }
        catch (StatusException statusException) {
            logger.error("StatusException: ", (Throwable)statusException);
        }
        this.setValueRank(variableAttributes.getValueRank());
    }

    @Override
    public void setDataType(UaDataType uaDataType) {
        this.setDataTypeId(uaDataType.getNodeId());
        if (uaDataType instanceof UaVariableType) {
            this.setTypeDefinitionId(new ExpandedNodeId(uaDataType.getNodeId()));
        }
        this.ib = uaDataType;
    }

    @Override
    public void setDataTypeId(NodeId nodeId) {
        this.ic = nodeId;
    }

    @Override
    public void setHistorizing(Boolean bl) {
        this.ie = bl;
    }

    @Override
    public void setMinimumSamplingInterval(Double d2) {
        this.if = d2;
    }

    @Override
    public void setUserAccessLevel(AccessLevelType accessLevelType) {
        this.id = accessLevelType;
    }

    @Override
    public void setValue(DataValue dataValue) throws StatusException {
        if (!(dataValue = a.a(dataValue, this.getDataTypeId(), this.getAddressSpace())).equals(this.fo)) {
            this.fo = dataValue;
        }
    }

    @Override
    public void setValue(Object object) throws StatusException {
        DataValue dataValue;
        if (object instanceof DataValue) {
            dataValue = (DataValue)object;
        } else {
            Variant variant = object instanceof Variant ? (Variant)object : new Variant(object);
            dataValue = new DataValue(variant);
        }
        this.setValue(dataValue);
    }

    @Override
    public void setValueRank(int n2) {
        this.valueRank = n2;
    }

    @Override
    public String toString() {
        String string = "";
        if (this.bs != null && this.bs.length > 0) {
            string = "ArrayDImensions=" + Arrays.toString(this.bs);
        }
        return String.format(Locale.ROOT, "%s DataType=%s, ValueRank=%s%s, MinimumSamplingInterval=%f, AccessLevel=%s, UserAccessLevel=%s, Historizing=%s, Value=%s", super.toString(), this.ic, this.valueRank, string, this.if, this.hZ, this.id, this.ie, this.getValue());
    }

    public boolean writeValue(Object object) throws StatusException, ServiceException {
        boolean bl = this.addressSpace.getClient().writeValue(this.getNodeId(), object);
        if (bl) {
            this.setValue(object);
        }
        return bl;
    }

    public boolean writeValue(Object object, boolean bl) throws StatusException, ServiceException, DataTypeConversionException {
        Object object2;
        if (bl) {
            if (object instanceof DataValue) {
                DataValue dataValue = ((DataValue)object).clone();
                dataValue.setValue(this.addressSpace.getDataTypeConverter().convert(dataValue.getValue(), this.getDataTypeId()));
                object2 = dataValue;
            }
            if (object instanceof Variant) {
                object2 = this.addressSpace.getDataTypeConverter().convert((Variant)object, this.getDataTypeId());
            }
            object2 = this.addressSpace.getDataTypeConverter().convert(new Variant(object), this.getDataTypeId());
        } else {
            object2 = object;
        }
        boolean bl2 = this.addressSpace.getClient().writeValue(this.getNodeId(), object2);
        if (bl2) {
            this.setValue(object);
        }
        return bl2;
    }

    private UnsignedInteger i(Object object) {
        if (object instanceof UnsignedInteger) {
            return (UnsignedInteger)object;
        }
        if (object instanceof Number) {
            return UnsignedInteger.valueOf(((Number)object).intValue());
        }
        throw new ClassCastException("Cannot cast value toUnsignedInteger: " + object);
    }

    protected VariableAttributes getAttributes(VariableAttributes variableAttributes) {
        super.getAttributes(variableAttributes);
        variableAttributes.setAccessLevel((UnsignedByte)this.getAccessLevel().asBuiltInType());
        variableAttributes.setArrayDimensions(this.getArrayDimensions());
        variableAttributes.setDataType(this.getDataTypeId());
        variableAttributes.setHistorizing(this.getHistorizing());
        variableAttributes.setMinimumSamplingInterval(this.getMinimumSamplingInterval());
        variableAttributes.setUserAccessLevel((UnsignedByte)this.getUserAccessLevel().asBuiltInType());
        variableAttributes.setValue(this.getValue().getValue().getValue());
        variableAttributes.setValueRank(this.getValueRank());
        return variableAttributes;
    }

    @Override
    protected void getAttributesMap(Map<UnsignedInteger, Object> map) {
        super.getAttributesMap(map);
        map.put(Attributes.AccessLevel, this.getAccessLevel().asBuiltInType());
        map.put(Attributes.ArrayDimensions, this.getArrayDimensions());
        map.put(Attributes.DataType, this.getDataTypeId());
        map.put(Attributes.Historizing, this.getHistorizing());
        map.put(Attributes.MinimumSamplingInterval, this.getMinimumSamplingInterval());
        map.put(Attributes.UserAccessLevel, this.getUserAccessLevel().asBuiltInType());
        map.put(Attributes.Value, this.getValue().getValue().getValue());
        map.put(Attributes.ValueRank, this.getValueRank());
    }

    @Override
    protected void initSupportedAttributes(List<UnsignedInteger> list) {
        super.initSupportedAttributes(list);
        list.add(Attributes.Value);
        list.add(Attributes.DataType);
        list.add(Attributes.ValueRank);
        list.add(Attributes.ArrayDimensions);
        list.add(Attributes.AccessLevel);
        list.add(Attributes.UserAccessLevel);
        list.add(Attributes.MinimumSamplingInterval);
        list.add(Attributes.Historizing);
        if (this.getAddressSpace().isRead104Attributes()) {
            list.add(Attributes.AccessLevelEx);
        }
    }

    @Override
    protected void readAttributeValue(UnsignedInteger unsignedInteger, DataValue dataValue) throws StatusException {
        if (unsignedInteger.equals(Attributes.DataType)) {
            dataValue.setValue(new Variant(this.getDataTypeId()));
        } else if (unsignedInteger.equals(Attributes.AccessLevel)) {
            dataValue.setValue(new Variant(this.getAccessLevel()));
        } else if (unsignedInteger.equals(Attributes.UserAccessLevel)) {
            dataValue.setValue(new Variant(this.getUserAccessLevel()));
        } else if (unsignedInteger.equals(Attributes.MinimumSamplingInterval)) {
            dataValue.setValue(new Variant(this.getMinimumSamplingInterval()));
        } else if (unsignedInteger.equals(Attributes.Historizing)) {
            dataValue.setValue(new Variant(this.getHistorizing()));
        } else if (unsignedInteger.equals(Attributes.Value)) {
            DateTime dateTime = this.getValue().getServerTimestamp();
            try {
                this.readValue();
            }
            catch (ServiceException serviceException) {
                logger.debug("readAttribute: Could not update value of node " + this + " Exception=", (Throwable)serviceException);
            }
            dataValue.setValue(this.getValue().getValue());
            dataValue.setSourceTimestamp(this.getValue().getSourceTimestamp());
            dataValue.setSourcePicoseconds(this.getValue().getSourcePicoseconds());
            dataValue.setServerTimestamp(dateTime);
            dataValue.setServerPicoseconds(this.getValue().getServerPicoseconds());
            dataValue.setStatusCode(this.getValue().getStatusCode());
        } else if (unsignedInteger.equals(Attributes.ValueRank)) {
            dataValue.setValue(new Variant(this.getValueRank()));
        } else if (unsignedInteger.equals(Attributes.ArrayDimensions)) {
            dataValue.setValue(new Variant(this.getArrayDimensions()));
        } else if (Attributes.AccessLevelEx.equals(unsignedInteger)) {
            dataValue.setValue(new Variant(this.ia));
        } else {
            super.readAttributeValue(unsignedInteger, dataValue);
        }
    }

    @Override
    protected void writeAttributeValue(UnsignedInteger unsignedInteger, Object object, StatusCode statusCode, DateTime dateTime, UnsignedShort unsignedShort) throws StatusException {
        block17: {
            try {
                if (unsignedInteger.equals(Attributes.AccessLevel)) {
                    this.hZ = object instanceof AccessLevelType ? (AccessLevelType)object : AccessLevelType.of((UnsignedByte)object);
                    break block17;
                }
                if (unsignedInteger.equals(Attributes.UserAccessLevel)) {
                    this.id = object instanceof AccessLevelType ? (AccessLevelType)object : AccessLevelType.of((UnsignedByte)object);
                    break block17;
                }
                if (unsignedInteger.equals(Attributes.MinimumSamplingInterval)) {
                    this.if = (Double)object;
                    break block17;
                }
                if (unsignedInteger.equals(Attributes.Historizing)) {
                    this.ie = (Boolean)object;
                    break block17;
                }
                if (unsignedInteger.equals(Attributes.DataType)) {
                    if (object instanceof NodeId) {
                        this.setDataTypeId((NodeId)object);
                        break block17;
                    }
                    if (object instanceof ExpandedNodeId) {
                        try {
                            this.setDataTypeId(this.addressSpace.getNamespaceTable().toNodeId((ExpandedNodeId)object));
                            break block17;
                        }
                        catch (ServiceResultException serviceResultException) {
                            throw new StatusException(serviceResultException);
                        }
                    }
                    throw new StatusException("Cannot set NodeId to the specified value", StatusCodes.Bad_InvalidArgument);
                }
                if (unsignedInteger.equals(Attributes.ValueRank)) {
                    this.valueRank = (Integer)object;
                } else if (unsignedInteger.equals(Attributes.ArrayDimensions)) {
                    this.bs = (UnsignedInteger[])object;
                } else if (Attributes.AccessLevelEx.equals(unsignedInteger)) {
                    this.ia = object == null ? null : (object instanceof AccessLevelExType ? (AccessLevelExType)object : AccessLevelExType.of((UnsignedInteger)object));
                } else {
                    super.writeAttributeValue(unsignedInteger, object, statusCode, dateTime, unsignedShort);
                }
            }
            catch (RuntimeException runtimeException) {
                throw new StatusException("Cannot write value", StatusCodes.Bad_InvalidArgument, null, (Throwable)runtimeException);
            }
        }
    }
}

