/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.client;

import com.prosysopc.ua.ApplicationIdentity;
import com.prosysopc.ua.DataTypeConversionException;
import com.prosysopc.ua.MethodCallStatusException;
import com.prosysopc.ua.OperationLimits;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.SessionActivationException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.SubscriptionBase;
import com.prosysopc.ua.UaAddress;
import com.prosysopc.ua.UaApplication;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.UserIdentity;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.client.ClientCodegenModel;
import com.prosysopc.ua.client.ClientCodegenModelProvider;
import com.prosysopc.ua.client.ConnectException;
import com.prosysopc.ua.client.InvalidServerEndpointException;
import com.prosysopc.ua.client.ReconnectState;
import com.prosysopc.ua.client.ReconnectStatus;
import com.prosysopc.ua.client.ServerConnectionException;
import com.prosysopc.ua.client.ServerStatusListener;
import com.prosysopc.ua.client.Subscription;
import com.prosysopc.ua.client.UaClientListener;
import com.prosysopc.ua.client.h;
import com.prosysopc.ua.client.i;
import com.prosysopc.ua.stack.application.Application;
import com.prosysopc.ua.stack.application.Client;
import com.prosysopc.ua.stack.application.Session;
import com.prosysopc.ua.stack.application.SessionChannel;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.ExtensionObject;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.ServiceRequest;
import com.prosysopc.ua.stack.builtintypes.ServiceResponse;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.common.NamespaceTable;
import com.prosysopc.ua.stack.common.ServerTable;
import com.prosysopc.ua.stack.common.ServiceFaultException;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.ActivateSessionResponse;
import com.prosysopc.ua.stack.core.AggregateConfiguration;
import com.prosysopc.ua.stack.core.Attributes;
import com.prosysopc.ua.stack.core.BuildInfo;
import com.prosysopc.ua.stack.core.CallMethodRequest;
import com.prosysopc.ua.stack.core.CallMethodResult;
import com.prosysopc.ua.stack.core.CallRequest;
import com.prosysopc.ua.stack.core.CallResponse;
import com.prosysopc.ua.stack.core.CreateSubscriptionResponse;
import com.prosysopc.ua.stack.core.DeleteAtTimeDetails;
import com.prosysopc.ua.stack.core.DeleteEventDetails;
import com.prosysopc.ua.stack.core.DeleteRawModifiedDetails;
import com.prosysopc.ua.stack.core.DeleteSubscriptionsResponse;
import com.prosysopc.ua.stack.core.EndpointConfiguration;
import com.prosysopc.ua.stack.core.EndpointDescription;
import com.prosysopc.ua.stack.core.EventFilter;
import com.prosysopc.ua.stack.core.GetEndpointsRequest;
import com.prosysopc.ua.stack.core.GetEndpointsResponse;
import com.prosysopc.ua.stack.core.HistoryData;
import com.prosysopc.ua.stack.core.HistoryEvent;
import com.prosysopc.ua.stack.core.HistoryEventFieldList;
import com.prosysopc.ua.stack.core.HistoryModifiedData;
import com.prosysopc.ua.stack.core.HistoryReadDetails;
import com.prosysopc.ua.stack.core.HistoryReadResponse;
import com.prosysopc.ua.stack.core.HistoryReadResult;
import com.prosysopc.ua.stack.core.HistoryReadValueId;
import com.prosysopc.ua.stack.core.HistoryUpdateDetails;
import com.prosysopc.ua.stack.core.HistoryUpdateResponse;
import com.prosysopc.ua.stack.core.HistoryUpdateResult;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.stack.core.IssuedIdentityToken;
import com.prosysopc.ua.stack.core.MessageSecurityMode;
import com.prosysopc.ua.stack.core.ModificationInfo;
import com.prosysopc.ua.stack.core.ModifySubscriptionResponse;
import com.prosysopc.ua.stack.core.PerformUpdateType;
import com.prosysopc.ua.stack.core.PublishRequest;
import com.prosysopc.ua.stack.core.PublishResponse;
import com.prosysopc.ua.stack.core.ReadAtTimeDetails;
import com.prosysopc.ua.stack.core.ReadEventDetails;
import com.prosysopc.ua.stack.core.ReadProcessedDetails;
import com.prosysopc.ua.stack.core.ReadRawModifiedDetails;
import com.prosysopc.ua.stack.core.ReadRequest;
import com.prosysopc.ua.stack.core.ReadResponse;
import com.prosysopc.ua.stack.core.ReadValueId;
import com.prosysopc.ua.stack.core.RequestHeader;
import com.prosysopc.ua.stack.core.ResponseHeader;
import com.prosysopc.ua.stack.core.ServerState;
import com.prosysopc.ua.stack.core.ServerStatusDataType;
import com.prosysopc.ua.stack.core.SetPublishingModeResponse;
import com.prosysopc.ua.stack.core.SignatureData;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.core.SubscriptionAcknowledgement;
import com.prosysopc.ua.stack.core.TimestampsToReturn;
import com.prosysopc.ua.stack.core.TransferResult;
import com.prosysopc.ua.stack.core.TransferSubscriptionsResponse;
import com.prosysopc.ua.stack.core.UpdateDataDetails;
import com.prosysopc.ua.stack.core.UpdateEventDetails;
import com.prosysopc.ua.stack.core.UpdateStructureDataDetails;
import com.prosysopc.ua.stack.core.UserIdentityToken;
import com.prosysopc.ua.stack.core.UserNameIdentityToken;
import com.prosysopc.ua.stack.core.UserTokenPolicy;
import com.prosysopc.ua.stack.core.UserTokenType;
import com.prosysopc.ua.stack.core.VariableIdentifiers;
import com.prosysopc.ua.stack.core.WriteRequest;
import com.prosysopc.ua.stack.core.WriteResponse;
import com.prosysopc.ua.stack.core.WriteValue;
import com.prosysopc.ua.stack.encoding.DecodingException;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.encoding.EncodingException;
import com.prosysopc.ua.stack.transport.AsyncResult;
import com.prosysopc.ua.stack.transport.ChannelService;
import com.prosysopc.ua.stack.transport.Endpoint;
import com.prosysopc.ua.stack.transport.ResultListener;
import com.prosysopc.ua.stack.transport.ReverseConnectionListener;
import com.prosysopc.ua.stack.transport.ReverseTransportChannelSettings;
import com.prosysopc.ua.stack.transport.SecureChannel;
import com.prosysopc.ua.stack.transport.TransportChannelSettings;
import com.prosysopc.ua.stack.transport.https.HttpsSettings;
import com.prosysopc.ua.stack.transport.impl.AsyncResultImpl;
import com.prosysopc.ua.stack.transport.security.Cert;
import com.prosysopc.ua.stack.transport.security.HttpsSecurityPolicy;
import com.prosysopc.ua.stack.transport.security.SecurityMode;
import com.prosysopc.ua.stack.transport.security.SecurityPolicy;
import com.prosysopc.ua.stack.transport.tcp.io.TcpConnection;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.stack.utils.EndpointUtil;
import com.prosysopc.ua.stack.utils.MultiDimensionArrayUtils;
import com.prosysopc.ua.stack.utils.NumericRange;
import com.prosysopc.ua.stack.utils.StackUtils;
import com.prosysopc.ua.typedictionary.TypeDictionary;
import com.prosysopc.ua.typedictionary.TypeDictionaryException;
import com.prosysopc.ua.typedictionary.UaDataTypeSpecification;
import com.prosysopc.ua.types.gds.client.GdsClientInformationModel;
import com.prosysopc.ua.types.opcua.client.ClientInformationModel;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Timer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UaClient
extends UaApplication {
    public static final Double MAX_CACHE_AGE = new Double(2.147483647E9);
    private static UaApplication.Protocol cy = UaApplication.Protocol.OpcTcp;
    private static final Logger logger = LoggerFactory.getLogger(UaClient.class);
    private static Set<StatusCode> gd;
    private static boolean ge;
    private static final Map<UnsignedInteger, Class<?>> gf;
    private BlockingQueue<SubscriptionAcknowledgement> gg = new LinkedBlockingDeque<SubscriptionAcknowledgement>();
    private OperationLimits gh;
    private UaAddress gi = null;
    private AddressSpace addressSpace;
    private ApplicationIdentity applicationIdentity = new ApplicationIdentity();
    private String gj = null;
    private volatile boolean gk = true;
    private final AtomicReference<SessionChannel> gl = new AtomicReference<Object>(null);
    private final Client gm = Client.createClientApplication(null);
    private int connectTimeout = 60000;
    private UnsignedInteger gn = UnsignedInteger.valueOf(0L);
    private EndpointDescription[] go;
    private double gp = 0.0;
    private TimestampsToReturn gq = TimestampsToReturn.Both;
    private EndpointDescription gr;
    private final EndpointConfiguration gs = Endpoint.createDefaultEndpointConfiguration();
    private volatile boolean gt;
    private final HttpsSettings gu = new HttpsSettings();
    private boolean gv;
    private final AtomicReference<DiagnosticInfo[]> gw = new AtomicReference<Object>(null);
    private final AtomicLong gx = new AtomicLong();
    private final AtomicReference<ResponseHeader> gy = new AtomicReference<Object>(null);
    private final SessionChannel.RequestValidator gz = new SessionChannel.RequestValidator(){

        @Override
        public <T extends ServiceResponse> void validateServiceRequest(SessionChannel sessionChannel, ServiceRequest<T> serviceRequest) throws ServiceResultException {
            UaClient.this.validateServiceRequest(serviceRequest);
        }
    };
    private UaClientListener gA = null;
    private Locale locale = Locale.getDefault(Locale.Category.DISPLAY);
    private UnsignedInteger gB = UnsignedInteger.ZERO;
    private boolean gC;
    private EnumSet<UaApplication.DiagnosticMask> gD = EnumSet.noneOf(UaApplication.DiagnosticMask.class);
    private volatile double gE = 2.0;
    private final AtomicInteger gF = new AtomicInteger(0);
    private UnsignedInteger gG = UnsignedInteger.MAX_VALUE;
    f gH;
    private volatile Thread gI;
    private Timer gJ;
    private SecureChannel gK;
    private SecurityMode gL = SecurityMode.BASIC128RSA15_SIGN_ENCRYPT;
    private ApplicationIdentity gM = new ApplicationIdentity();
    private final AtomicReference<e> gN = new AtomicReference();
    private final List<ServerStatusListener> gO = new CopyOnWriteArrayList<ServerStatusListener>();
    private final AtomicBoolean gP = new AtomicBoolean(false);
    private boolean gQ;
    private final AtomicLong gR = new AtomicLong(0L);
    private EnumSet<UaApplication.DiagnosticMask> gS = EnumSet.noneOf(UaApplication.DiagnosticMask.class);
    private volatile Session gT;
    private String gU;
    private Double gV = 3600000.0;
    private long gW;
    private long gX = 1000L;
    private long gY = 10000L;
    private UnsignedInteger gZ = null;
    private UserIdentity cu = new UserIdentity();
    private boolean ha = true;
    private boolean hb = true;
    private TypeDictionary hc = new TypeDictionary(this);
    final List<Subscription> hd = new CopyOnWriteArrayList<Subscription>();
    private ReverseConnectionListener he = null;
    private UaAddress hf = null;
    private boolean hg = true;
    private boolean hh = true;
    private TcpConnection.SocketFactory hi;

    public static Set<StatusCode> getCommErrorCodes() {
        return gd;
    }

    public static UaApplication.Protocol getDefaultProtocol() {
        return cy;
    }

    public static boolean isUseCommErrorCodes() {
        return ge;
    }

    public static void setDefaultProtocol(UaApplication.Protocol protocol) {
        cy = protocol;
    }

    public static void setUseCommErrorCodes(boolean bl) {
        ge = bl;
    }

    private static void a(UnsignedInteger unsignedInteger, Class<?> clazz) {
        Class<?> clazz2 = gf.put(unsignedInteger, clazz);
        if (clazz2 != null) {
            throw new Error("Duplication mapping for AttributeId " + unsignedInteger + " existing: " + clazz2 + ", new:" + clazz);
        }
    }

    public UaClient() {
    }

    public UaClient(String string) {
        this();
        this.setAddress(string);
    }

    public UaClient(UaAddress uaAddress) {
        this.setAddress(uaAddress);
    }

    public void addServerStatusListener(ServerStatusListener serverStatusListener) {
        if (!this.hasServerStatusListener(serverStatusListener)) {
            this.gO.add(serverStatusListener);
        }
    }

    public Subscription addSubscription(Subscription subscription) throws ServiceException, StatusException {
        logger.debug("addSubscription ID was:{}", (Object)subscription.getSubscriptionId());
        if (subscription.getClient() != null) {
            subscription.transferTo(this);
        } else {
            subscription.setClient(this);
            if (!this.hd.contains(subscription)) {
                this.hd.add(subscription);
            }
            if (this.isConnected()) {
                this.a(subscription, false);
            }
        }
        logger.debug("addSubscription: added subscription={}", (Object)subscription);
        this.cjn();
        return subscription;
    }

    public CallResponse call(CallMethodRequest ... callMethodRequestArray) throws ServiceException {
        try {
            CallResponse callResponse = this.ciq().Call(this.getRequestHeader(), callMethodRequestArray);
            this.checkServiceResult(callResponse, callResponse.getDiagnosticInfos());
            return callResponse;
        }
        catch (ServiceFaultException serviceFaultException) {
            throw new ServiceException(serviceFaultException);
        }
        catch (ServiceResultException serviceResultException) {
            throw new ServiceException(serviceResultException);
        }
    }

    public Variant[] call(NodeId nodeId, NodeId nodeId2, Variant ... variantArray) throws ServiceException, MethodCallStatusException {
        CallMethodRequest callMethodRequest = new CallMethodRequest(nodeId, nodeId2, Variant.asObjectArray(variantArray));
        CallResponse callResponse = this.call(callMethodRequest);
        CallMethodResult callMethodResult = callResponse.getResults()[0];
        DiagnosticInfo[] diagnosticInfoArray = callResponse.getDiagnosticInfos();
        this.a(callMethodResult, diagnosticInfoArray == null || diagnosticInfoArray.length == 0 ? null : diagnosticInfoArray[0]);
        return Variant.asVariantArray(callMethodResult.getOutputArguments());
    }

    public AsyncResult<CallResponse> callAsync(CallMethodRequest ... callMethodRequestArray) {
        try {
            return this.ciq().CallAsync(new CallRequest(this.getRequestHeader(), callMethodRequestArray));
        }
        catch (ServerConnectionException serverConnectionException) {
            return AsyncResultImpl.failed(new ServiceResultException(StatusCodes.Bad_ServerNotConnected, (Throwable)serverConnectionException));
        }
    }

    public synchronized void connect() throws ServiceException, ConnectException, SessionActivationException, InvalidServerEndpointException {
        logger.debug("connect");
        if (this.gI != null) {
            if (this.gk) {
                logger.warn("connect() should not be called after obtaining the initial connection. AutoReconnect is true, SDK is handling all reconnections.");
            } else {
                logger.warn("connect() should not be called after obtaining the initial connection. AutoReconnect is false, call reconnect() in a loop instead for making manual reconnection attempts.");
            }
        }
        if (!this.isConnected()) {
            try {
                this.cjg();
                this.cjv();
                if (this.gr == null) {
                    this.cjh();
                }
                this.cjg();
                this.cjf();
                this.cjj();
                this.ciV();
                this.ciW();
                this.ciP();
                DataValue dataValue = this.cji();
                try {
                    logger.debug("NamespaceTable: {}", (Object)this.a(true, dataValue));
                }
                catch (StatusException statusException) {
                    logger.error("Cannot Read NamespaceArray from the server", (Throwable)statusException);
                }
                this.cjk();
                this.ciT();
                this.startPublishing();
            }
            catch (ServiceException serviceException) {
                this.disconnect();
                throw serviceException;
            }
            catch (RuntimeException runtimeException) {
                this.disconnect();
                throw runtimeException;
            }
        }
    }

    public void disconnect() {
        this.disconnect(60000L);
    }

    public void disconnect(long l2) {
        this.disconnect(UnsignedInteger.valueOf(l2));
    }

    public void disconnect(long l2, TimeUnit timeUnit) {
        this.disconnect(timeUnit.toMillis(l2));
    }

    public synchronized void disconnect(UnsignedInteger unsignedInteger) {
        this.stopPublishing();
        this.f(unsignedInteger);
        this.ciR();
    }

    public EndpointDescription[] discoverEndpoints() throws InvalidServerEndpointException, ConnectException, ServiceException {
        return this.discoverEndpoints(this.cja());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EndpointDescription[] discoverEndpoints(UaApplication.Protocol ... protocolArray) throws InvalidServerEndpointException, ConnectException, ServiceException {
        SecureChannel secureChannel;
        Object object;
        String string;
        this.cjg();
        Client client = this.gm != null ? this.gm : Client.createClientApplication(null);
        String string2 = string = this.gi == null ? null : this.gi.getAddress();
        if (logger.isDebugEnabled()) {
            logger.debug("discoverEndpoints: connectUri=" + string + " protocols=" + Arrays.toString((Object[])protocolArray));
        }
        EndpointDescription endpointDescription = new EndpointDescription();
        endpointDescription.setEndpointUrl(string);
        endpointDescription.setSecurityMode(MessageSecurityMode.None);
        endpointDescription.setSecurityPolicyUri(SecurityPolicy.NONE.getPolicyUri());
        if (this.isInReverseMode()) {
            object = new ReverseTransportChannelSettings();
            ((ReverseTransportChannelSettings)object).setReverseConnectionListener(this.he);
            ((TransportChannelSettings)object).setDescription(endpointDescription);
            ((TransportChannelSettings)object).setOpctcpSettings(null);
            secureChannel = client.createReverseSecureChannel(this.hf.getAddress(), (ReverseTransportChannelSettings)object);
            if (string == null) {
                string = endpointDescription.getEndpointUrl();
            }
        } else {
            object = new TransportChannelSettings();
            ((TransportChannelSettings)object).setDescription(endpointDescription);
            ((TransportChannelSettings)object).setOpctcpSettings(null);
            secureChannel = client.createSecureChannel(string, (TransportChannelSettings)object);
        }
        object = new ChannelService(secureChannel);
        try {
            EndpointDescription[] endpointDescriptionArray = this.a((ChannelService)object, string, protocolArray);
            if (endpointDescriptionArray == null || endpointDescriptionArray.length == 0) {
                endpointDescriptionArray = this.a((ChannelService)object, null, new UaApplication.Protocol[0]);
            }
            EndpointDescription[] endpointDescriptionArray2 = endpointDescriptionArray;
            secureChannel.close();
            secureChannel.dispose();
            return endpointDescriptionArray2;
        }
        catch (Throwable throwable) {
            try {
                secureChannel.close();
                secureChannel.dispose();
                throw throwable;
            }
            catch (ServiceResultException serviceResultException) {
                logger.debug("Connection failed", (Throwable)serviceResultException);
                if (serviceResultException.getStatusCode().getValue().equals(StatusCodes.Bad_ServerUriInvalid)) {
                    throw new InvalidServerEndpointException("Server URI invalid", this.cjd(), null, serviceResultException);
                }
                throw new ConnectException("Failed to retrieve endpoints. The server is not available", this.cjd(), null, serviceResultException);
            }
        }
    }

    public OperationLimits getActualOperationLimits() {
        return this.gh != null ? this.gh : this.getOperationLimits();
    }

    public int getActualPublishRequestSetpoint() {
        int n2 = this.gF.get();
        if (n2 > 0) {
            return n2;
        }
        return (int)Math.ceil((double)this.hd.size() * this.getPublishRequestFactor());
    }

    public UaAddress getAddress() {
        return this.gi;
    }

    @Override
    public AddressSpace getAddressSpace() {
        if (this.addressSpace == null) {
            this.addressSpace = new AddressSpace(this);
        }
        return this.addressSpace;
    }

    @Override
    public ApplicationIdentity getApplicationIdentity() {
        return this.applicationIdentity;
    }

    public String getAuditEntryId() {
        return this.gj;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public double getDefaultMaxAge() {
        return this.gp;
    }

    public TimestampsToReturn getDefaultTimestampsToReturn() {
        return this.gq;
    }

    @Override
    public EncoderContext getEncoderContext() {
        return this.gm.getEncoderContext();
    }

    public EndpointDescription getEndpoint() {
        return this.gr;
    }

    public EndpointConfiguration getEndpointConfiguration() {
        return this.gs;
    }

    @Deprecated
    public String getHost() {
        return this.ciZ();
    }

    public HttpsSettings getHttpsSettings() {
        if (this.gm != null) {
            return this.gm.getApplicationHttpsSettings();
        }
        return this.gu;
    }

    public DiagnosticInfo[] getLastOperationDiagnostics() {
        return this.gw.get();
    }

    public DateTime getLastResponseTimestamp() {
        return this.gy.get().getTimestamp();
    }

    public DiagnosticInfo getLastServiceDiagnostics() {
        return this.gy.get().getServiceDiagnostics();
    }

    public StatusCode getLastServiceResult() {
        return this.gy.get().getServiceResult();
    }

    public UaClientListener getListener() {
        return this.gA;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public UnsignedInteger getMaxResponseMessageSize() {
        return this.gB;
    }

    @Override
    public NamespaceTable getNamespaceTable() {
        if (!this.gC) {
            try {
                this.b((DataValue)null);
            }
            catch (Exception exception) {
                logger.error("Could not get namespace table from server", (Throwable)exception);
            }
        }
        return super.getNamespaceTable();
    }

    public NamespaceTable getNamespaceTable(boolean bl) throws ServiceException, StatusException {
        if (!this.gC || bl) {
            this.b((DataValue)null);
        }
        return this.getNamespaceTable();
    }

    public EnumSet<UaApplication.DiagnosticMask> getOperationDiagnosticMask() {
        return this.gD;
    }

    @Deprecated
    public int getPort() {
        if (this.gi == null) {
            return 0;
        }
        return this.gi.getPort();
    }

    @Deprecated
    public UaApplication.Protocol getProtocol() {
        return this.cja();
    }

    public double getPublishRequestFactor() {
        return this.gE;
    }

    public int getPublishRequestSetpoint() {
        return this.gF.get();
    }

    public UnsignedInteger getPublishRequestTimeout() {
        return this.gG;
    }

    public UaAddress getReverseAddress() {
        return this.hf;
    }

    public ReverseConnectionListener getReverseConnectionListener() {
        return this.he;
    }

    public SecureChannel getSecureChannel() throws ServerConnectionException {
        return this.ciq().getSecureChannel();
    }

    public SecurityMode getSecurityMode() {
        return this.gL;
    }

    public ApplicationIdentity getServerIdentity() {
        return this.gM;
    }

    @Deprecated
    public String getServerName() {
        if (this.gi == null) {
            return "";
        }
        return this.gi.getServerName();
    }

    public ServerState getServerState() {
        Optional<e> optional = Optional.ofNullable(this.gN.get());
        ServerStatusDataType serverStatusDataType = optional.map(e2 -> e2.ht).orElse(null);
        StatusCode statusCode = optional.map(e2 -> e2.hu).orElse(null);
        return serverStatusDataType != null ? serverStatusDataType.getState() : (statusCode == null || statusCode.equals(StatusCode.BAD) ? ServerState.Unknown : ServerState.CommunicationFault);
    }

    public ServerStatusDataType getServerStatus() throws StatusException, ServerConnectionException {
        if (!this.isConnected()) {
            throw new ServerConnectionException("Not connected to server", this.cjd(), this.gL);
        }
        StatusCode statusCode = this.cjb();
        if (statusCode != null && statusCode.isBad()) {
            throw new StatusException("ServerStatus not available", statusCode);
        }
        if (this.gX > 0L) {
            int n2 = 0;
            try {
                while (this.cjc() == null && this.isConnected() && n2++ < 10) {
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.cjc();
    }

    public StatusCode getServerStatusError() {
        return this.cjb();
    }

    @Override
    public ServerTable getServerTable() {
        if (!this.gQ) {
            try {
                this.cjq();
            }
            catch (Exception exception) {
                logger.error("Could not get server table from server", (Throwable)exception);
            }
        }
        return this.getEncoderContext().getServerTable();
    }

    public ServerTable getServerTable(boolean bl) throws ServiceException, StatusException {
        if (!this.gQ || bl) {
            this.cjq();
        }
        return this.getEncoderContext().getServerTable();
    }

    public long getServerTimeDifference() {
        return this.gR.get();
    }

    public EnumSet<UaApplication.DiagnosticMask> getServiceDiagnosticMask() {
        return this.gS;
    }

    public Session getSession() {
        SessionChannel sessionChannel = this.gl.get();
        logger.trace("getSession: sessionChannel={}", (Object)sessionChannel);
        if (sessionChannel == null) {
            return null;
        }
        return sessionChannel.getSession();
    }

    public String getSessionName() {
        return this.gU;
    }

    public double getSessionTimeout() {
        return this.gV;
    }

    public TcpConnection.SocketFactory getSocketFactory() {
        return this.hi;
    }

    public long getStatusCheckInterval() {
        return this.gX;
    }

    public long getStatusCheckTimeout() {
        return this.gY;
    }

    public Subscription getSubscription(int n2) {
        return this.hd.get(n2);
    }

    public Subscription getSubscriptionById(UnsignedInteger unsignedInteger) {
        if (unsignedInteger != null) {
            for (Subscription subscription : this.hd) {
                if (!unsignedInteger.equals(subscription.getSubscriptionId())) continue;
                return subscription;
            }
        }
        return null;
    }

    public int getSubscriptionCount() {
        return this.hd.size();
    }

    public Subscription[] getSubscriptions() {
        return this.hd.toArray(new Subscription[this.hd.size()]);
    }

    public List<SecurityMode> getSupportedSecurityModes() throws InvalidServerEndpointException, ServerConnectionException, ServiceException {
        EndpointDescription[] endpointDescriptionArray = this.discoverEndpoints();
        ArrayList<SecurityMode> arrayList = new ArrayList<SecurityMode>();
        for (EndpointDescription endpointDescription : endpointDescriptionArray) {
            try {
                SecurityMode securityMode = new SecurityMode(SecurityPolicy.getSecurityPolicy(endpointDescription.getSecurityPolicyUri()), endpointDescription.getSecurityMode());
                if (arrayList.contains(securityMode)) continue;
                arrayList.add(securityMode);
            }
            catch (ServiceResultException serviceResultException) {
                logger.info("Unknown security policy supported by the server.", (Throwable)serviceResultException);
            }
        }
        return arrayList;
    }

    public UserTokenPolicy[] getSupportedUserIdentityTokens() throws ServerConnectionException, ServiceException {
        EndpointDescription endpointDescription = this.gr;
        try {
            if (this.gr == null) {
                this.cjh();
            }
            UserTokenPolicy[] userTokenPolicyArray = this.gr.getUserIdentityTokens();
            return userTokenPolicyArray;
        }
        finally {
            this.gr = endpointDescription;
        }
    }

    public int getTimeout() {
        if (this.gZ == null) {
            return -1;
        }
        return this.gZ.intValue();
    }

    public TypeDictionary getTypeDictionary() {
        return this.hc;
    }

    @Deprecated
    public String getUri() {
        return this.cjd();
    }

    public UserIdentity getUserIdentity() {
        return this.cu;
    }

    public boolean hasServerStatusListener(ServerStatusListener serverStatusListener) {
        if (serverStatusListener == null) {
            throw new NullPointerException("null listener not allowed");
        }
        return this.gO.contains(serverStatusListener);
    }

    public boolean hasSubscription(UnsignedInteger unsignedInteger) {
        return this.getSubscriptionById(unsignedInteger) != null;
    }

    public HistoryUpdateResult historyDeleteAtTimes(NodeId nodeId, DateTime[] dateTimeArray) throws StatusException, ServerConnectionException, ServiceException {
        DeleteAtTimeDetails deleteAtTimeDetails = new DeleteAtTimeDetails(nodeId, dateTimeArray);
        HistoryUpdateResult[] historyUpdateResultArray = this.historyUpdate(deleteAtTimeDetails);
        this.checkOperationResult(historyUpdateResultArray[0].getStatusCode());
        return historyUpdateResultArray[0];
    }

    public HistoryUpdateResult historyDeleteEvents(NodeId nodeId, List<ByteString> list) throws StatusException, ServerConnectionException, ServiceException {
        DeleteEventDetails deleteEventDetails = new DeleteEventDetails(nodeId, list.toArray(new ByteString[list.size()]));
        HistoryUpdateResult[] historyUpdateResultArray = this.historyUpdate(deleteEventDetails);
        this.checkOperationResult(historyUpdateResultArray[0].getStatusCode());
        return historyUpdateResultArray[0];
    }

    public HistoryUpdateResult historyDeleteModified(NodeId nodeId, DateTime dateTime, DateTime dateTime2) throws StatusException, ServerConnectionException, ServiceException {
        DeleteRawModifiedDetails deleteRawModifiedDetails = new DeleteRawModifiedDetails(nodeId, true, dateTime, dateTime2);
        HistoryUpdateResult[] historyUpdateResultArray = this.historyUpdate(deleteRawModifiedDetails);
        this.checkOperationResult(historyUpdateResultArray[0].getStatusCode());
        return historyUpdateResultArray[0];
    }

    public HistoryUpdateResult historyDeleteRaw(NodeId nodeId, DateTime dateTime, DateTime dateTime2) throws StatusException, ServerConnectionException, ServiceException {
        DeleteRawModifiedDetails deleteRawModifiedDetails = new DeleteRawModifiedDetails(nodeId, false, dateTime, dateTime2);
        HistoryUpdateResult[] historyUpdateResultArray = this.historyUpdate(deleteRawModifiedDetails);
        this.checkOperationResult(historyUpdateResultArray[0].getStatusCode());
        return historyUpdateResultArray[0];
    }

    public HistoryReadResult[] historyRead(HistoryReadDetails historyReadDetails, TimestampsToReturn timestampsToReturn, Boolean bl, HistoryReadValueId ... historyReadValueIdArray) throws ServerConnectionException, ServiceException {
        if (historyReadDetails == null) {
            throw new NullPointerException("details");
        }
        if (historyReadValueIdArray == null) {
            throw new NullPointerException("nodesToRead");
        }
        try {
            HistoryReadResponse historyReadResponse = this.ciq().HistoryRead(this.getRequestHeader(), ExtensionObject.binaryEncode(historyReadDetails, this.gm.getEncoderContext()), timestampsToReturn, bl, historyReadValueIdArray);
            this.checkServiceResult(historyReadResponse, historyReadResponse.getDiagnosticInfos());
            this.a(historyReadResponse.getResults(), historyReadValueIdArray);
            return historyReadResponse.getResults();
        }
        catch (ServiceFaultException serviceFaultException) {
            throw new ServiceException(serviceFaultException);
        }
        catch (EncodingException encodingException) {
            throw new IllegalArgumentException(encodingException);
        }
        catch (ServiceResultException serviceResultException) {
            throw new ServiceException(serviceResultException);
        }
    }

    public AsyncResult<HistoryReadResponse> historyReadAsync(HistoryReadDetails historyReadDetails, TimestampsToReturn timestampsToReturn, Boolean bl, HistoryReadValueId ... historyReadValueIdArray) {
        if (historyReadDetails == null) {
            throw new NullPointerException("details");
        }
        if (historyReadValueIdArray == null) {
            throw new NullPointerException("nodesToRead");
        }
        try {
            return this.ciq().HistoryReadAsync(this.getRequestHeader(), ExtensionObject.binaryEncode(historyReadDetails, this.gm.getEncoderContext()), timestampsToReturn, bl, historyReadValueIdArray);
        }
        catch (EncodingException encodingException) {
            throw new IllegalArgumentException(encodingException);
        }
        catch (ServerConnectionException serverConnectionException) {
            return AsyncResultImpl.failed(new ServiceResultException(StatusCodes.Bad_ServerNotConnected, (Throwable)serverConnectionException));
        }
    }

    public DataValue[] historyReadAtTimes(NodeId nodeId, DateTime[] dateTimeArray, NumericRange numericRange, TimestampsToReturn timestampsToReturn) throws StatusException, ServerConnectionException, ServiceException, DecodingException {
        return this.historyReadAtTimes(nodeId, dateTimeArray, numericRange, timestampsToReturn, (Boolean)false);
    }

    public DataValue[] historyReadAtTimes(NodeId nodeId, DateTime[] dateTimeArray, NumericRange numericRange, TimestampsToReturn timestampsToReturn, Boolean bl) throws StatusException, ServerConnectionException, ServiceException, DecodingException {
        ReadAtTimeDetails readAtTimeDetails = new ReadAtTimeDetails(dateTimeArray, bl);
        return this.a(nodeId, numericRange, timestampsToReturn, (HistoryReadDetails)readAtTimeDetails);
    }

    public HistoryReadResult[] historyReadAtTimes(NodeId[] nodeIdArray2, DateTime[] dateTimeArray, NumericRange numericRange, TimestampsToReturn timestampsToReturn, Boolean bl) throws ServerConnectionException, ServiceException, DecodingException, EncodingException {
        ReadAtTimeDetails readAtTimeDetails = new ReadAtTimeDetails(dateTimeArray, bl);
        return this.a(nodeIdArray2, this.getActualOperationLimits().getMaxNodesHistoryReadData().intValue(), (NodeId[] nodeIdArray) -> this.a(nodeIdArray, numericRange, timestampsToReturn, readAtTimeDetails));
    }

    public HistoryEventFieldList[] historyReadEvents(NodeId nodeId, DateTime dateTime, DateTime dateTime2, UnsignedInteger unsignedInteger, EventFilter eventFilter, TimestampsToReturn timestampsToReturn) throws StatusException, ServerConnectionException, ServiceException, DecodingException {
        ReadEventDetails readEventDetails = new ReadEventDetails(unsignedInteger, dateTime, dateTime2, eventFilter);
        return this.b(nodeId, null, timestampsToReturn, (HistoryReadDetails)readEventDetails);
    }

    public HistoryReadResult[] historyReadEvents(NodeId[] nodeIdArray2, DateTime dateTime, DateTime dateTime2, UnsignedInteger unsignedInteger, EventFilter eventFilter, TimestampsToReturn timestampsToReturn) throws ServerConnectionException, ServiceException, DecodingException, EncodingException {
        ReadEventDetails readEventDetails = new ReadEventDetails(unsignedInteger, dateTime, dateTime2, eventFilter);
        return this.a(nodeIdArray2, this.getActualOperationLimits().getMaxNodesHistoryReadEvents().intValue(), (NodeId[] nodeIdArray) -> this.b(nodeIdArray, null, timestampsToReturn, readEventDetails));
    }

    public HistoryModifiedData historyReadModified(NodeId nodeId, DateTime dateTime, DateTime dateTime2, UnsignedInteger unsignedInteger, NumericRange numericRange, TimestampsToReturn timestampsToReturn) throws StatusException, ServerConnectionException, ServiceException, DecodingException {
        ReadRawModifiedDetails readRawModifiedDetails = new ReadRawModifiedDetails(true, dateTime, dateTime2, unsignedInteger, false);
        return this.c(nodeId, numericRange, timestampsToReturn, (HistoryReadDetails)readRawModifiedDetails);
    }

    public HistoryReadResult[] historyReadModified(NodeId[] nodeIdArray2, DateTime dateTime, DateTime dateTime2, UnsignedInteger unsignedInteger, NumericRange numericRange, TimestampsToReturn timestampsToReturn) throws ServerConnectionException, ServiceException, DecodingException, EncodingException {
        ReadRawModifiedDetails readRawModifiedDetails = new ReadRawModifiedDetails(true, dateTime, dateTime2, unsignedInteger, false);
        return this.a(nodeIdArray2, this.getActualOperationLimits().getMaxNodesHistoryReadData().intValue(), (NodeId[] nodeIdArray) -> this.c(nodeIdArray, numericRange, timestampsToReturn, readRawModifiedDetails));
    }

    public DataValue[] historyReadProcessed(NodeId nodeId, DateTime dateTime, DateTime dateTime2, Double d2, NodeId nodeId2, AggregateConfiguration aggregateConfiguration, NumericRange numericRange, TimestampsToReturn timestampsToReturn) throws ServerConnectionException, ServiceException, DecodingException, StatusException {
        ReadProcessedDetails readProcessedDetails = new ReadProcessedDetails(dateTime, dateTime2, d2, new NodeId[]{nodeId2}, aggregateConfiguration);
        return this.a(nodeId, numericRange, timestampsToReturn, (HistoryReadDetails)readProcessedDetails);
    }

    public HistoryReadResult[] historyReadProcessed(NodeId[] nodeIdArray2, DateTime dateTime, DateTime dateTime2, Double d2, NodeId nodeId, AggregateConfiguration aggregateConfiguration, NumericRange numericRange, TimestampsToReturn timestampsToReturn) throws ServerConnectionException, ServiceException, DecodingException, EncodingException {
        ReadProcessedDetails readProcessedDetails = new ReadProcessedDetails(dateTime, dateTime2, d2, new NodeId[]{nodeId}, aggregateConfiguration);
        return this.a(nodeIdArray2, this.getActualOperationLimits().getMaxNodesHistoryReadData().intValue(), (NodeId[] nodeIdArray) -> this.a(nodeIdArray, numericRange, timestampsToReturn, readProcessedDetails));
    }

    public DataValue[] historyReadRaw(NodeId nodeId, DateTime dateTime, DateTime dateTime2, long l2, Boolean bl, NumericRange numericRange, TimestampsToReturn timestampsToReturn) throws ServerConnectionException, DecodingException, ServiceException, StatusException {
        return this.historyReadRaw(nodeId, dateTime, dateTime2, UnsignedInteger.valueOf(l2), bl, numericRange, timestampsToReturn);
    }

    public DataValue[] historyReadRaw(NodeId nodeId, DateTime dateTime, DateTime dateTime2, UnsignedInteger unsignedInteger, Boolean bl, NumericRange numericRange, TimestampsToReturn timestampsToReturn) throws ServerConnectionException, ServiceException, DecodingException, StatusException {
        ReadRawModifiedDetails readRawModifiedDetails = new ReadRawModifiedDetails(false, dateTime, dateTime2, unsignedInteger, bl);
        return this.a(nodeId, numericRange, timestampsToReturn, (HistoryReadDetails)readRawModifiedDetails);
    }

    public HistoryReadResult[] historyReadRaw(NodeId[] nodeIdArray2, DateTime dateTime, DateTime dateTime2, long l2, Boolean bl, NumericRange numericRange, TimestampsToReturn timestampsToReturn) throws ServerConnectionException, ServiceException, DecodingException, EncodingException {
        ReadRawModifiedDetails readRawModifiedDetails = new ReadRawModifiedDetails(false, dateTime, dateTime2, UnsignedInteger.valueOf(l2), bl);
        return this.a(nodeIdArray2, this.getActualOperationLimits().getMaxNodesHistoryReadData().intValue(), (NodeId[] nodeIdArray) -> this.a(nodeIdArray, numericRange, timestampsToReturn, readRawModifiedDetails));
    }

    public HistoryUpdateResult[] historyUpdate(HistoryUpdateDetails ... historyUpdateDetailsArray) throws ServerConnectionException, ServiceException {
        if (historyUpdateDetailsArray == null) {
            throw new NullPointerException("details");
        }
        try {
            ExtensionObject[] extensionObjectArray = new ExtensionObject[historyUpdateDetailsArray.length];
            for (int i2 = 0; i2 < historyUpdateDetailsArray.length; ++i2) {
                extensionObjectArray[i2] = ExtensionObject.binaryEncode(historyUpdateDetailsArray[i2], this.gm.getEncoderContext());
            }
            HistoryUpdateResponse historyUpdateResponse = this.ciq().HistoryUpdate(this.getRequestHeader(), extensionObjectArray);
            this.checkServiceResult(historyUpdateResponse, historyUpdateResponse.getDiagnosticInfos());
            this.a(historyUpdateResponse.getResults(), historyUpdateDetailsArray);
            return historyUpdateResponse.getResults();
        }
        catch (ServiceFaultException serviceFaultException) {
            throw new ServiceException(serviceFaultException);
        }
        catch (EncodingException encodingException) {
            throw new IllegalArgumentException(encodingException);
        }
        catch (ServiceResultException serviceResultException) {
            throw new ServiceException(serviceResultException);
        }
    }

    public AsyncResult<HistoryUpdateResponse> historyUpdateAsync(HistoryUpdateDetails ... historyUpdateDetailsArray) throws ServerConnectionException {
        if (historyUpdateDetailsArray == null) {
            throw new NullPointerException("details");
        }
        try {
            ExtensionObject[] extensionObjectArray = new ExtensionObject[historyUpdateDetailsArray.length];
            for (int i2 = 0; i2 < historyUpdateDetailsArray.length; ++i2) {
                extensionObjectArray[i2] = ExtensionObject.binaryEncode(historyUpdateDetailsArray[i2], this.gm.getEncoderContext());
            }
            return this.ciq().HistoryUpdateAsync(this.getRequestHeader(), extensionObjectArray);
        }
        catch (EncodingException encodingException) {
            throw new IllegalArgumentException(encodingException);
        }
    }

    public HistoryUpdateResult historyUpdateData(NodeId nodeId, PerformUpdateType performUpdateType, DataValue[] dataValueArray) throws StatusException, ServerConnectionException, ServiceException {
        UpdateDataDetails updateDataDetails = new UpdateDataDetails(nodeId, performUpdateType, dataValueArray);
        HistoryUpdateResult[] historyUpdateResultArray = this.historyUpdate(updateDataDetails);
        this.checkOperationResult(historyUpdateResultArray[0].getStatusCode());
        return historyUpdateResultArray[0];
    }

    public HistoryUpdateResult historyUpdateEvent(NodeId nodeId, PerformUpdateType performUpdateType, EventFilter eventFilter, HistoryEventFieldList[] historyEventFieldListArray) throws StatusException, ServerConnectionException, ServiceException {
        UpdateEventDetails updateEventDetails = new UpdateEventDetails(nodeId, performUpdateType, eventFilter, historyEventFieldListArray);
        HistoryUpdateResult[] historyUpdateResultArray = this.historyUpdate(updateEventDetails);
        this.checkOperationResult(historyUpdateResultArray[0].getStatusCode());
        return historyUpdateResultArray[0];
    }

    public HistoryUpdateResult historyUpdateStructureData(NodeId nodeId, PerformUpdateType performUpdateType, DataValue[] dataValueArray) throws StatusException, ServerConnectionException, ServiceException {
        UpdateStructureDataDetails updateStructureDataDetails = new UpdateStructureDataDetails(nodeId, performUpdateType, dataValueArray);
        HistoryUpdateResult[] historyUpdateResultArray = this.historyUpdate(updateStructureDataDetails);
        this.checkOperationResult(historyUpdateResultArray[0].getStatusCode());
        return historyUpdateResultArray[0];
    }

    public boolean isAutoReconnect() {
        return this.gk;
    }

    public boolean isConnected() {
        return this.getSession() != null;
    }

    public boolean isInitTypeDictionaryAutoUsage() {
        return this.hh;
    }

    public boolean isInitTypeDictionaryOnConnect() {
        return this.hg;
    }

    public boolean isInReverseMode() {
        return this.hf != null;
    }

    public boolean isKeepSubscriptions() {
        return this.gv;
    }

    public boolean isValidateCreateSessionResponseCert() {
        return this.hb;
    }

    public boolean isValidateDiscoveredEndpoints() {
        return this.ha;
    }

    public ReadResponse read(Double d2, TimestampsToReturn timestampsToReturn, ReadValueId ... readValueIdArray) throws ServiceException {
        int n2 = 0;
        if (readValueIdArray.length > 1 && this.getActualOperationLimits() != null) {
            try {
                n2 = this.getActualOperationLimits().getMaxNodesPerRead().intValue();
            }
            catch (Exception exception) {
                logger.debug("read: Failed to get operationLimits.MaxNodesPerRead: ", (Throwable)exception);
            }
        }
        if (n2 > 0 && n2 < readValueIdArray.length) {
            ResponseHeader responseHeader = null;
            DataValue[] dataValueArray = new DataValue[readValueIdArray.length];
            DiagnosticInfo[] diagnosticInfoArray = new DiagnosticInfo[readValueIdArray.length];
            for (int i2 = 0; i2 < readValueIdArray.length; i2 += n2) {
                int n3 = Math.min(n2, readValueIdArray.length - i2);
                ReadValueId[] readValueIdArray2 = Arrays.copyOfRange(readValueIdArray, i2, i2 + n3);
                ReadResponse readResponse = this.a(d2, timestampsToReturn, readValueIdArray2);
                responseHeader = readResponse.getResponseHeader();
                for (int i3 = 0; i3 < n3; ++i3) {
                    dataValueArray[i2 + i3] = readResponse.getResults()[i3];
                }
                DiagnosticInfo[] diagnosticInfoArray2 = readResponse.getDiagnosticInfos();
                if (diagnosticInfoArray2 == null) continue;
                for (int i4 = 0; i4 < n3 && i4 < diagnosticInfoArray2.length; ++i4) {
                    diagnosticInfoArray[i2 + i4] = diagnosticInfoArray2[i4];
                }
            }
            return new ReadResponse(responseHeader, dataValueArray, diagnosticInfoArray);
        }
        return this.a(d2, timestampsToReturn, readValueIdArray);
    }

    public AsyncResult<ReadResponse> readAsync(Double d2, TimestampsToReturn timestampsToReturn, ReadValueId ... readValueIdArray) {
        ReadRequest readRequest = new ReadRequest(this.getRequestHeader(), new Double(d2), timestampsToReturn, readValueIdArray);
        try {
            return this.ciq().ReadAsync(readRequest);
        }
        catch (ServerConnectionException serverConnectionException) {
            return AsyncResultImpl.failed(new ServiceResultException(StatusCodes.Bad_ServerNotConnected, (Throwable)serverConnectionException));
        }
    }

    public DataValue readAttribute(ExpandedNodeId expandedNodeId, UnsignedInteger unsignedInteger) throws ServiceException, StatusException {
        return this.readAttribute(this.toNodeId(expandedNodeId), unsignedInteger);
    }

    public DataValue readAttribute(ExpandedNodeId expandedNodeId, UnsignedInteger unsignedInteger, NumericRange numericRange, Double d2) throws ServiceException, StatusException {
        return this.readAttribute(this.toNodeId(expandedNodeId), unsignedInteger, numericRange, d2);
    }

    public DataValue readAttribute(NodeId nodeId, UnsignedInteger unsignedInteger) throws ServiceException, StatusException {
        UnsignedInteger[] unsignedIntegerArray = new UnsignedInteger[]{unsignedInteger};
        DataValue dataValue = this.readAttributes(nodeId, unsignedIntegerArray)[0];
        this.checkOperationResult(dataValue.getStatusCode());
        return dataValue;
    }

    public DataValue readAttribute(NodeId nodeId, UnsignedInteger unsignedInteger, NumericRange numericRange, Double d2) throws ServiceException, StatusException {
        NumericRange[] numericRangeArray;
        UnsignedInteger[] unsignedIntegerArray = new UnsignedInteger[]{unsignedInteger};
        if (numericRange == null) {
            numericRangeArray = null;
        } else {
            NumericRange[] numericRangeArray2 = new NumericRange[1];
            numericRangeArray = numericRangeArray2;
            numericRangeArray2[0] = numericRange;
        }
        NumericRange[] numericRangeArray3 = numericRangeArray;
        DataValue dataValue = this.readAttributes(nodeId, unsignedIntegerArray, numericRangeArray3, d2)[0];
        this.checkOperationResult(dataValue.getStatusCode());
        return dataValue;
    }

    public DataValue[] readAttributes(ExpandedNodeId expandedNodeId, UnsignedInteger ... unsignedIntegerArray) throws ServiceException, StatusException {
        return this.readAttributes(this.toNodeId(expandedNodeId), unsignedIntegerArray);
    }

    public DataValue[] readAttributes(ExpandedNodeId expandedNodeId, UnsignedInteger[] unsignedIntegerArray, NumericRange[] numericRangeArray, Double d2) throws ServiceException, StatusException {
        return this.readAttributes(this.toNodeId(expandedNodeId), unsignedIntegerArray, numericRangeArray, d2);
    }

    public DataValue[] readAttributes(NodeId nodeId, UnsignedInteger ... unsignedIntegerArray) throws ServiceException {
        return this.readAttributes(nodeId, unsignedIntegerArray, null, (Double)this.getDefaultMaxAge());
    }

    public DataValue[] readAttributes(NodeId nodeId, UnsignedInteger[] unsignedIntegerArray, NumericRange[] numericRangeArray, Double d2) throws ServiceException {
        ReadValueId[] readValueIdArray = new ReadValueId[unsignedIntegerArray.length];
        for (int i2 = 0; i2 < unsignedIntegerArray.length; ++i2) {
            readValueIdArray[i2] = new ReadValueId(nodeId, unsignedIntegerArray[i2], numericRangeArray == null ? null : NumericRange.toString(numericRangeArray[i2]), null);
        }
        ReadResponse readResponse = this.read(d2, this.getDefaultTimestampsToReturn(), readValueIdArray);
        DataValue[] dataValueArray = readResponse.getResults();
        return dataValueArray;
    }

    public DataValue readValue(ExpandedNodeId expandedNodeId) throws ServiceException, StatusException {
        return this.readValue(this.toNodeId(expandedNodeId));
    }

    public DataValue readValue(ExpandedNodeId expandedNodeId, Double d2) throws ServiceException, StatusException {
        return this.readValue(this.toNodeId(expandedNodeId), d2);
    }

    public DataValue readValue(ExpandedNodeId expandedNodeId, NumericRange numericRange) throws ServiceException, StatusException {
        return this.readValue(this.toNodeId(expandedNodeId), numericRange);
    }

    public DataValue readValue(ExpandedNodeId expandedNodeId, NumericRange numericRange, Double d2) throws ServiceException, StatusException {
        return this.readValue(this.toNodeId(expandedNodeId), numericRange, d2);
    }

    public DataValue readValue(NodeId nodeId) throws ServiceException, StatusException {
        return this.readAttribute(nodeId, Attributes.Value);
    }

    public DataValue readValue(NodeId nodeId, Double d2) throws ServiceException, StatusException {
        return this.readAttribute(nodeId, Attributes.Value, null, d2);
    }

    public DataValue readValue(NodeId nodeId, NumericRange numericRange) throws ServiceException, StatusException {
        return this.readValue(nodeId, numericRange, (Double)this.getDefaultMaxAge());
    }

    public DataValue readValue(NodeId nodeId, NumericRange numericRange, Double d2) throws ServiceException, StatusException {
        return this.readAttribute(nodeId, Attributes.Value, numericRange, d2);
    }

    public DataValue[] readValues(ExpandedNodeId[] expandedNodeIdArray) throws ServiceException, StatusException {
        return this.readValues(this.a(expandedNodeIdArray));
    }

    public DataValue[] readValues(ExpandedNodeId[] expandedNodeIdArray, NumericRange[] numericRangeArray) throws ServiceException, StatusException {
        return this.readValues(this.a(expandedNodeIdArray), numericRangeArray);
    }

    public DataValue[] readValues(ExpandedNodeId[] expandedNodeIdArray, NumericRange[] numericRangeArray, TimestampsToReturn timestampsToReturn) throws ServiceException, StatusException {
        return this.readValues(this.a(expandedNodeIdArray), numericRangeArray, timestampsToReturn);
    }

    public DataValue[] readValues(ExpandedNodeId[] expandedNodeIdArray, NumericRange[] numericRangeArray, TimestampsToReturn timestampsToReturn, Double d2) throws ServiceException, StatusException {
        return this.readValues(this.a(expandedNodeIdArray), numericRangeArray, timestampsToReturn, d2);
    }

    public DataValue[] readValues(ExpandedNodeId[] expandedNodeIdArray, TimestampsToReturn timestampsToReturn) throws ServiceException, StatusException {
        return this.readValues(this.a(expandedNodeIdArray), timestampsToReturn);
    }

    public DataValue[] readValues(NodeId[] nodeIdArray) throws ServiceException {
        return this.readValues(nodeIdArray, this.getDefaultTimestampsToReturn());
    }

    public DataValue[] readValues(NodeId[] nodeIdArray, NumericRange[] numericRangeArray) throws ServiceException {
        ReadValueId[] readValueIdArray = new ReadValueId[nodeIdArray.length];
        for (int i2 = 0; i2 < nodeIdArray.length; ++i2) {
            readValueIdArray[i2] = new ReadValueId(nodeIdArray[i2], Attributes.Value, numericRangeArray == null ? null : NumericRange.toString(numericRangeArray[i2]), null);
        }
        ReadResponse readResponse = this.read(this.getDefaultMaxAge(), this.getDefaultTimestampsToReturn(), readValueIdArray);
        DataValue[] dataValueArray = readResponse.getResults();
        return dataValueArray;
    }

    public DataValue[] readValues(NodeId[] nodeIdArray, NumericRange[] numericRangeArray, TimestampsToReturn timestampsToReturn) throws ServiceException {
        return this.readValues(nodeIdArray, numericRangeArray, timestampsToReturn, (Double)this.getDefaultMaxAge());
    }

    public DataValue[] readValues(NodeId[] nodeIdArray, NumericRange[] numericRangeArray, TimestampsToReturn timestampsToReturn, Double d2) throws ServiceException {
        ReadValueId[] readValueIdArray = new ReadValueId[nodeIdArray.length];
        for (int i2 = 0; i2 < nodeIdArray.length; ++i2) {
            readValueIdArray[i2] = new ReadValueId(nodeIdArray[i2], Attributes.Value, numericRangeArray == null ? null : NumericRange.toString(numericRangeArray[i2]), null);
        }
        ReadResponse readResponse = this.read(d2, timestampsToReturn, readValueIdArray);
        DataValue[] dataValueArray = readResponse.getResults();
        return dataValueArray;
    }

    public DataValue[] readValues(NodeId[] nodeIdArray, TimestampsToReturn timestampsToReturn) throws ServiceException {
        return this.readValues(nodeIdArray, null, timestampsToReturn);
    }

    public boolean reconnect() throws ServiceException, ConnectException, SessionActivationException {
        boolean bl;
        Consumer<ReconnectStatus> consumer = reconnectStatus -> Optional.ofNullable(this.getListener()).ifPresent(uaClientListener -> uaClientListener.onReconnect((ReconnectStatus)reconnectStatus));
        try {
            consumer.accept(ReconnectStatus.builder().setState(ReconnectState.CONNECTING).build());
            bl = this.ciX();
            consumer.accept(ReconnectStatus.builder().setState(ReconnectState.CONNECTED).build());
        }
        catch (ServiceException serviceException) {
            consumer.accept(ReconnectStatus.builder().setState(ReconnectState.ERROR).setError(serviceException).build());
            throw serviceException;
        }
        return bl;
    }

    public void registerModel(ClientCodegenModel clientCodegenModel) {
        this.registerModelInternal(clientCodegenModel);
    }

    public boolean removeServerStatusListener(ServerStatusListener serverStatusListener) {
        return this.gO.remove(serverStatusListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatusCode removeSubscription(Subscription subscription) throws ServiceException {
        boolean bl;
        logger.debug("removeSubscription: {}", (Object)subscription);
        if (subscription == null) {
            return StatusCode.valueOf(StatusCodes.Good_NoData);
        }
        StatusCode statusCode = null;
        try {
            StatusCode[] statusCodeArray = this.a(new SubscriptionBase[]{subscription});
            if (statusCodeArray != null && statusCodeArray.length > 0) {
                statusCode = statusCodeArray[0];
            }
            if (subscription.getClient() == this) {
                subscription.reset();
            }
            bl = this.hd.remove(subscription);
        }
        catch (Throwable throwable) {
            if (subscription.getClient() == this) {
                subscription.reset();
            }
            boolean bl2 = this.hd.remove(subscription);
            logger.debug("removed: {}", (Object)bl2);
            if (statusCode == null) {
                statusCode = bl2 ? StatusCode.GOOD : StatusCode.valueOf(StatusCodes.Good_NoData);
            }
            throw throwable;
        }
        logger.debug("removed: {}", (Object)bl);
        if (statusCode == null) {
            statusCode = bl ? StatusCode.GOOD : StatusCode.valueOf(StatusCodes.Good_NoData);
        }
        return statusCode;
    }

    public StatusCode[] removeSubscriptions(Subscription[] subscriptionArray) throws ServiceException {
        StatusCode[] statusCodeArray = this.a(subscriptionArray);
        if (statusCodeArray == null) {
            statusCodeArray = new StatusCode[subscriptionArray.length];
        }
        this.resetSubscriptionsAfterRemove(subscriptionArray, statusCodeArray);
        return statusCodeArray;
    }

    public AsyncResult<StatusCode[]> removeSubscriptionsAsync(final Subscription ... subscriptionArray) throws ServiceException {
        final AsyncResultImpl<StatusCode[]> asyncResultImpl = new AsyncResultImpl<StatusCode[]>();
        AsyncResult<DeleteSubscriptionsResponse> asyncResult = this.b(subscriptionArray);
        if (asyncResult == null) {
            StatusCode[] statusCodeArray = new StatusCode[subscriptionArray.length];
            this.resetSubscriptionsAfterRemove(subscriptionArray, statusCodeArray);
            asyncResultImpl.setResult(statusCodeArray);
        } else {
            asyncResult.setListener(new ResultListener<DeleteSubscriptionsResponse>(){

                public void a(DeleteSubscriptionsResponse deleteSubscriptionsResponse) {
                    StatusCode[] statusCodeArray = deleteSubscriptionsResponse.getResults();
                    UaClient.this.resetSubscriptionsAfterRemove(subscriptionArray, statusCodeArray);
                    asyncResultImpl.setResult(statusCodeArray);
                }

                @Override
                public void onError(ServiceResultException serviceResultException) {
                    asyncResultImpl.setError(serviceResultException);
                }

                @Override
                public /* synthetic */ void onCompleted(Object object) {
                    this.a((DeleteSubscriptionsResponse)object);
                }
            });
        }
        return asyncResultImpl;
    }

    public void resetEndpoint() {
        this.gr = null;
    }

    public <T extends ServiceResponse> T serviceRequest(ServiceRequest<T> serviceRequest) throws ServiceException {
        try {
            if (serviceRequest.getRequestHeader() == null) {
                serviceRequest.setRequestHeader(this.getRequestHeader());
            }
            T t2 = this.ciq().serviceRequest(serviceRequest);
            this.checkServiceResult((ServiceResponse)t2, null);
            return t2;
        }
        catch (ServiceResultException serviceResultException) {
            throw new ServiceException(serviceResultException);
        }
    }

    public <T extends ServiceResponse> AsyncResult<T> serviceRequestAsync(ServiceRequest<T> serviceRequest) throws ServiceException {
        if (serviceRequest.getRequestHeader() == null) {
            serviceRequest.setRequestHeader(this.getRequestHeader());
        }
        return this.ciq().serviceRequestAsync(serviceRequest);
    }

    public <T extends ServiceResponse> T sessionlessRequest(ServiceRequest<T> serviceRequest) throws InvalidServerEndpointException, ServerConnectionException, ServiceException {
        if (this.isConnected()) {
            return this.serviceRequest(serviceRequest);
        }
        if (this.gr == null) {
            this.cjg();
            this.cjh();
            this.cjf();
        }
        this.ciV();
        try {
            T t2 = this.gK.serviceRequest(serviceRequest);
            return t2;
        }
        catch (ServiceResultException serviceResultException) {
            throw new ServiceException(serviceResultException);
        }
        finally {
            this.disconnect();
        }
    }

    public void setAddress(String string) {
        this.setAddress(UaAddress.parse(string));
    }

    public void setAddress(UaAddress uaAddress) {
        this.gi = uaAddress;
        this.ciS();
    }

    public void setApplicationIdentity(ApplicationIdentity applicationIdentity) {
        this.applicationIdentity = applicationIdentity;
    }

    public void setAuditEntryId(String string) {
        this.gj = string;
    }

    public void setAutoReconnect(boolean bl) {
        this.gk = bl;
    }

    public void setConnectTimeout(int n2) {
        this.connectTimeout = n2;
    }

    public void setConnectTimeout(int n2, TimeUnit timeUnit) {
        this.connectTimeout = (int)timeUnit.toMillis(n2);
    }

    public void setDefaultMaxAge(double d2) {
        if (d2 < 0.0) {
            throw new IllegalArgumentException("defaultMaxAge cannot be less than 0");
        }
        this.gp = d2;
    }

    public void setDefaultTimestampsToReturn(TimestampsToReturn timestampsToReturn) {
        this.gq = timestampsToReturn;
    }

    public void setEndpoint(EndpointDescription endpointDescription) {
        this.ciQ();
        if (endpointDescription != null) {
            this.setUri(endpointDescription.getEndpointUrl());
            try {
                SecurityPolicy securityPolicy = SecurityPolicy.getSecurityPolicy(endpointDescription.getSecurityPolicyUri());
                this.gL = new SecurityMode(securityPolicy, endpointDescription.getSecurityMode());
            }
            catch (ServiceResultException serviceResultException) {
                logger.error("Converting SecurityPolicyUri to SecurityPolicy failed", (Throwable)serviceResultException);
            }
        }
        this.gr = endpointDescription;
    }

    public void setInitTypeDictionaryAutoUsage(boolean bl) {
        this.hh = bl;
    }

    public void setInitTypeDictionaryOnConnect(boolean bl) {
        this.hg = bl;
    }

    public void setKeepSubscriptions(boolean bl) {
        this.gv = bl;
    }

    public void setListener(UaClientListener uaClientListener) {
        this.gA = uaClientListener;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setMaxResponseMessageSize(int n2) {
        this.setMaxResponseMessageSize(UnsignedInteger.valueOf(n2));
    }

    public void setMaxResponseMessageSize(UnsignedInteger unsignedInteger) {
        this.gB = unsignedInteger == null ? UnsignedInteger.ZERO : unsignedInteger;
    }

    public void setOperationDiagnosticMask(EnumSet<UaApplication.DiagnosticMask> enumSet) {
        this.gD = enumSet;
        this.cjt();
    }

    public synchronized void setPublishRequestFactor(double d2) {
        logger.debug("setPublishRequestFactor: {}", (Object)d2);
        this.gE = d2;
        this.resetPublishRequestSetpoint();
    }

    public void setPublishRequestSetpoint(int n2) {
        this.gF.set(n2);
    }

    public void setPublishRequestTimeout(long l2) {
        this.setPublishRequestTimeout(UnsignedInteger.valueOf(l2));
    }

    public void setPublishRequestTimeout(long l2, TimeUnit timeUnit) {
        this.setPublishRequestTimeout(timeUnit.toMillis(l2));
    }

    public void setPublishRequestTimeout(UnsignedInteger unsignedInteger) {
        this.gG = unsignedInteger.getValue() == 0L ? UnsignedInteger.MAX_VALUE : unsignedInteger;
    }

    public void setReverseAddress(UaAddress uaAddress) {
        this.hf = uaAddress;
    }

    public void setReverseConnectionListener(ReverseConnectionListener reverseConnectionListener) {
        this.he = reverseConnectionListener;
    }

    public void setReversePort(int n2) {
        this.setReverseAddress(UaAddress.wildcardOpcTcp(n2));
    }

    public void setSecurityMode(SecurityMode securityMode) {
        if (!securityMode.equals(this.gL)) {
            this.ciQ();
            this.gL = securityMode;
            this.resetEndpoint();
        }
    }

    public void setServiceDiagnosticMask(EnumSet<UaApplication.DiagnosticMask> enumSet) {
        this.gS = enumSet;
        this.cjt();
    }

    public void setSessionName(String string) {
        this.gU = string;
    }

    public void setSessionTimeout(double d2) {
        this.gV = d2;
    }

    public void setSessionTimeout(long l2, TimeUnit timeUnit) {
        double d2;
        switch (timeUnit) {
            case MICROSECONDS: {
                d2 = (double)l2 / 1000.0;
                break;
            }
            case NANOSECONDS: {
                d2 = (double)l2 / 1000000.0;
                break;
            }
            default: {
                d2 = timeUnit.toMillis(l2);
            }
        }
        this.setSessionTimeout(d2);
    }

    public void setSocketFactory(TcpConnection.SocketFactory socketFactory) {
        this.hi = socketFactory;
    }

    public void setStatusCheckInterval(long l2) {
        if (l2 != this.gX) {
            this.gX = l2;
            this.cjn();
        }
    }

    public void setStatusCheckInterval(long l2, TimeUnit timeUnit) {
        this.setStatusCheckInterval(timeUnit.toMillis(l2));
    }

    public void setStatusCheckTimeout(long l2) {
        this.gY = l2;
    }

    public void setStatusCheckTimeout(long l2, TimeUnit timeUnit) {
        this.gY = timeUnit.toMillis(l2);
    }

    public void setTimeout(long l2) {
        this.setTimeout(UnsignedInteger.valueOf(l2));
    }

    public void setTimeout(long l2, TimeUnit timeUnit) {
        this.setTimeout(timeUnit.toMillis(l2));
    }

    public void setTimeout(UnsignedInteger unsignedInteger) {
        this.gZ = unsignedInteger;
    }

    @Deprecated
    public void setUri(String string) {
        this.setAddress(string);
        this.go = null;
    }

    public void setUserIdentity(UserIdentity userIdentity) throws SessionActivationException {
        if (userIdentity == null) {
            userIdentity = new UserIdentity();
        }
        if (!this.cu.equals(userIdentity)) {
            this.cu = userIdentity;
            this.cje();
        }
    }

    public void setValidateCreateSessionResponseCert(boolean bl) {
        this.hb = bl;
    }

    public void setValidateDiscoveredEndpoints(boolean bl) {
        this.ha = bl;
    }

    public void updateServerStatus() {
        Cloneable cloneable;
        ServerState serverState;
        ServerState serverState2;
        block16: {
            StatusCode statusCode = this.cjb();
            serverState2 = this.getServerState();
            logger.trace("updateServerStatus: oldState={} error={}", (Object)serverState2, (Object)statusCode);
            serverState = ServerState.Unknown;
            try {
                if (!this.gP.get()) {
                    cloneable = null;
                    ReadValueId readValueId = new ReadValueId(Identifiers.Server_ServerStatus, Attributes.Value, null, null);
                    RequestHeader requestHeader = this.a(UnsignedInteger.ZERO, UnsignedInteger.valueOf(this.gY), null);
                    ReadResponse readResponse = this.ciq().Read(requestHeader, 0.0, TimestampsToReturn.Both, readValueId);
                    this.checkServiceResult(readResponse, readResponse.getDiagnosticInfos());
                    if (readResponse.getResults().length > 0) {
                        cloneable = readResponse.getResults()[0];
                    }
                    if (cloneable == null) {
                        this.a(null, StatusCode.BAD);
                    } else {
                        ServerStatusDataType serverStatusDataType;
                        Object object;
                        Object object2 = object = ((DataValue)cloneable).isNull() ? null : ((DataValue)cloneable).getValue().getValue();
                        boolean bl = object != null && object instanceof ServerStatusDataType && ((DataValue)cloneable).getStatusCode() != null && ((DataValue)cloneable).getStatusCode().isGood() ? (serverStatusDataType = (ServerStatusDataType)object).getBuildInfo() != null || serverStatusDataType.getCurrentTime() != null || serverStatusDataType.getSecondsTillShutdown() != null || serverStatusDataType.getShutdownReason() != null || serverStatusDataType.getStartTime() != null || serverStatusDataType.getState() != null : false;
                        if (bl) {
                            this.a((ServerStatusDataType)object, ((DataValue)cloneable).getStatusCode());
                        } else {
                            this.cjp();
                        }
                        serverStatusDataType = this.cjc();
                        if (serverStatusDataType.getCurrentTime() != null) {
                            this.gR.set(serverStatusDataType.getCurrentTime().getTimeInMillis() - System.currentTimeMillis());
                        }
                        serverState = serverStatusDataType.getState();
                    }
                } else {
                    this.cjp();
                    cloneable = this.cjc();
                    if (((ServerStatusDataType)cloneable).getCurrentTime() != null) {
                        this.gR.set(((ServerStatusDataType)cloneable).getCurrentTime().getTimeInMillis() - System.currentTimeMillis());
                    }
                    serverState = ((ServerStatusDataType)cloneable).getState();
                }
            }
            catch (ServerConnectionException serverConnectionException) {
                logger.debug("updateServerStatus", (Throwable)serverConnectionException);
                this.a(null, StatusCodes.Bad_ServerNotConnected);
                serverState = ServerState.CommunicationFault;
            }
            catch (ServiceException serviceException) {
                logger.debug("updateServerStatus", (Throwable)serviceException);
                this.a(null, serviceException.getServiceResult());
                serverState = ServerState.CommunicationFault;
            }
            catch (ServiceResultException serviceResultException) {
                logger.debug("updateServerStatus", (Throwable)serviceResultException);
                this.a(null, serviceResultException.getStatusCode());
                if (serviceResultException.getStatusCode().getValue().equals(StatusCodes.Bad_SessionNotActivated)) break block16;
                serverState = ServerState.CommunicationFault;
            }
        }
        this.ciY();
        if (!serverState.equals(serverState2)) {
            this.a(serverState2, serverState);
        }
        cloneable = this.cjc();
        if (serverState.equals(ServerState.Shutdown)) {
            long l2;
            long l3 = l2 = cloneable == null ? 0L : ((ServerStatusDataType)cloneable).getSecondsTillShutdown().getValue();
            if (l2 > 0L) {
                this.a(l2, cloneable == null ? new LocalizedText("") : ((ServerStatusDataType)cloneable).getShutdownReason());
                this.f(null);
                this.gW = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(l2 + 10L);
            }
        }
    }

    public WriteResponse write(WriteValue ... writeValueArray) throws ServiceException {
        int n2 = 0;
        if (writeValueArray.length > 1 && this.getActualOperationLimits() != null) {
            try {
                n2 = this.getActualOperationLimits().getMaxNodesPerWrite().intValue();
            }
            catch (Exception exception) {
                logger.debug("Error while parsing operation limits", (Throwable)exception);
            }
        }
        if (n2 > 0 && n2 < writeValueArray.length) {
            ResponseHeader responseHeader = null;
            StatusCode[] statusCodeArray = new StatusCode[writeValueArray.length];
            DiagnosticInfo[] diagnosticInfoArray = new DiagnosticInfo[writeValueArray.length];
            for (int i2 = 0; i2 < writeValueArray.length; i2 += n2) {
                int n3 = Math.min(n2, writeValueArray.length - i2);
                WriteValue[] writeValueArray2 = Arrays.copyOfRange(writeValueArray, i2, i2 + n3);
                WriteResponse writeResponse = this.a(writeValueArray2);
                responseHeader = writeResponse.getResponseHeader();
                for (int i3 = 0; i3 < n3; ++i3) {
                    statusCodeArray[i2 + i3] = writeResponse.getResults()[i3];
                }
                DiagnosticInfo[] diagnosticInfoArray2 = writeResponse.getDiagnosticInfos();
                if (diagnosticInfoArray2 != null && diagnosticInfoArray2.length == n3) {
                    for (int i4 = 0; i4 < n3; ++i4) {
                        diagnosticInfoArray[i2 + i4] = diagnosticInfoArray2[i4];
                    }
                    continue;
                }
                if (diagnosticInfoArray2 == null || diagnosticInfoArray2.length <= 0 || diagnosticInfoArray2.length == n3) continue;
                logger.warn("The length of the DiagnosticInfo array in WriteResponse was {}, but the expected length was {}, ignoring the DiagnosticInfo array", (Object)diagnosticInfoArray2.length, (Object)n3);
            }
            return new WriteResponse(responseHeader, statusCodeArray, diagnosticInfoArray);
        }
        return this.a(writeValueArray);
    }

    public AsyncResult<WriteResponse> writeAsync(WriteValue ... writeValueArray) {
        WriteRequest writeRequest = new WriteRequest(this.getRequestHeader(), writeValueArray);
        try {
            return this.ciq().WriteAsync(writeRequest);
        }
        catch (ServerConnectionException serverConnectionException) {
            return AsyncResultImpl.failed(new ServiceResultException(StatusCodes.Bad_ServerNotConnected, (Throwable)serverConnectionException));
        }
    }

    public boolean writeAttribute(NodeId nodeId, UnsignedInteger unsignedInteger, Object object) throws ServiceException, StatusException {
        WriteValue[] writeValueArray = new WriteValue[]{new WriteValue(nodeId, unsignedInteger, null, this.g(object))};
        WriteResponse writeResponse = this.write(writeValueArray);
        StatusCode statusCode = writeResponse.getResults()[0];
        this.checkOperationResult(statusCode);
        return statusCode.equals(StatusCode.GOOD);
    }

    public boolean writeAttribute(NodeId nodeId, UnsignedInteger unsignedInteger, Object object, boolean bl) throws DataTypeConversionException, ServiceException, StatusException {
        Object object2;
        if (bl) {
            if (Attributes.Value.equals(unsignedInteger)) {
                NodeId nodeId2;
                try {
                    nodeId2 = (NodeId)this.readAttribute(nodeId, Attributes.DataType).getValue().getValue();
                }
                catch (Exception exception) {
                    throw new DataTypeConversionException("Cannot resolve DataType of node with NodeId: " + nodeId);
                }
                if (object instanceof DataValue) {
                    DataValue dataValue = ((DataValue)object).clone();
                    dataValue.setValue(this.getAddressSpace().getDataTypeConverter().convert(dataValue.getValue(), nodeId2));
                    object2 = dataValue;
                }
                object2 = this.getAddressSpace().getDataTypeConverter().convert(this.h(object), nodeId2);
            } else {
                Class<?> clazz = gf.get(unsignedInteger);
                if (clazz == null) {
                    throw new DataTypeConversionException("This method does not support autoconversion for AttributeId: " + unsignedInteger);
                }
                if (object instanceof DataValue) {
                    DataValue dataValue = ((DataValue)object).clone();
                    dataValue.setValue(this.getAddressSpace().getDataTypeConverter().convert(dataValue.getValue(), clazz));
                    object2 = dataValue;
                }
                object2 = this.getAddressSpace().getDataTypeConverter().convert(this.h(object), clazz);
            }
        } else {
            object2 = object;
        }
        return this.writeAttribute(nodeId, unsignedInteger, object2);
    }

    public boolean writeAttribute(NodeId nodeId, UnsignedInteger unsignedInteger, Object object, NumericRange numericRange) throws ServiceException, StatusException {
        WriteValue[] writeValueArray = new WriteValue[]{new WriteValue(nodeId, unsignedInteger, NumericRange.toString(numericRange), this.g(object))};
        WriteResponse writeResponse = this.write(writeValueArray);
        StatusCode statusCode = writeResponse.getResults()[0];
        this.checkOperationResult(statusCode);
        return statusCode.equals(StatusCode.GOOD);
    }

    public boolean writeValue(NodeId nodeId, Object object) throws ServiceException, StatusException {
        return this.writeAttribute(nodeId, Attributes.Value, object);
    }

    public boolean writeValue(NodeId nodeId, Object object, boolean bl) throws DataTypeConversionException, ServiceException, StatusException {
        return this.writeAttribute(nodeId, Attributes.Value, object, bl);
    }

    public boolean writeValue(NodeId nodeId, Object object, NumericRange numericRange) throws ServiceException, StatusException {
        return this.writeAttribute(nodeId, Attributes.Value, object, numericRange);
    }

    public StatusCode[] writeValues(NodeId[] nodeIdArray, Object[] objectArray) throws ServiceException {
        WriteValue[] writeValueArray = new WriteValue[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            writeValueArray[i2] = new WriteValue(nodeIdArray[i2], Attributes.Value, null, this.g(objectArray[i2]));
        }
        WriteResponse writeResponse = this.write(writeValueArray);
        return writeResponse.getResults();
    }

    public StatusCode[] writeValues(NodeId[] nodeIdArray, Object[] objectArray, NumericRange[] numericRangeArray) throws ServiceException {
        WriteValue[] writeValueArray = new WriteValue[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            writeValueArray[i2] = new WriteValue(nodeIdArray[i2], Attributes.Value, NumericRange.toString(numericRangeArray[i2]), this.g(objectArray[i2]));
        }
        WriteResponse writeResponse = this.write(writeValueArray);
        return writeResponse.getResults();
    }

    private void ciP() throws SessionActivationException {
        Object object;
        Object object2;
        Object object3 = null;
        logger.debug("activateSessionChannel: endpoint={}", (Object)this.getSession().getEndpoint().getEndpointUrl());
        SignatureData signatureData = null;
        try {
            object2 = null;
            switch (this.cu.getType()) {
                case Anonymous: {
                    object3 = EndpointUtil.createAnonymousIdentityToken(this.getSession().getEndpoint());
                    break;
                }
                case Certificate: {
                    signatureData = new SignatureData();
                    object3 = EndpointUtil.createX509IdentityToken(this.getSession().getEndpoint(), this.getSession().getServerNonce(), this.cu.getCertificate(), this.cu.getPrivateKey().getPrivateKey(), signatureData);
                    break;
                }
                case IssuedToken: {
                    object = (Locale[])EndpointUtil.createIssuedIdentityToken(this.getSession().getEndpoint(), this.getSession().getServerNonce(), this.cu.getIssuedIdentityToken());
                    object2 = ((IssuedIdentityToken)object).getEncryptionAlgorithm();
                    object3 = object;
                    break;
                }
                case UserName: {
                    UserNameIdentityToken userNameIdentityToken = (UserNameIdentityToken)EndpointUtil.createUserNameIdentityToken(this.getSession().getEndpoint(), this.getSession().getServerNonce(), this.cu.getName(), this.cu.getPassword());
                    object2 = userNameIdentityToken.getEncryptionAlgorithm();
                    object3 = userNameIdentityToken;
                    break;
                }
            }
            logger.debug("UserToken encryption algorithm: {}", object2);
            if (object2 != null && SecurityMode.NONE.equals(this.gL) && this.validateApplicationCertificate(this.getServerIdentity()).isNotGood()) {
                throw new SessionActivationException("User Token encryption cannot be done for SecurityMode NONE, server certificate is not trusted", this.cu, StatusCodes.Bad_CertificateUntrusted);
            }
        }
        catch (ServiceResultException serviceResultException) {
            logger.debug("ServiceResultException: ", (Throwable)serviceResultException);
            throw new SessionActivationException("Failed to initialize User Identity Token: " + serviceResultException.getMessage(), this.cu, serviceResultException);
        }
        try {
            object2 = this.gm.getApplication();
            for (Locale locale : ((Application)object2).getLocales()) {
                ((Application)object2).removeLocale(locale);
            }
            ((Application)object2).addLocale(this.locale);
            object = this.ciq().activate((UserIdentityToken)object3, signatureData);
            StatusCode statusCode = ((ActivateSessionResponse)object).getResponseHeader().getServiceResult();
            if (statusCode.isBad()) {
                throw new SessionActivationException("Failed to activate Session.", this.cu, statusCode);
            }
        }
        catch (ServiceResultException serviceResultException) {
            logger.debug("ServiceResultException: ", (Throwable)serviceResultException);
            throw new SessionActivationException("Failed to activate Session.", this.cu, serviceResultException);
        }
        catch (ServerConnectionException serverConnectionException) {
            logger.debug("ServerConnectionException: ", (Throwable)serverConnectionException);
            throw new SessionActivationException("Failed to activate Session; not connected to the Server", this.cu, serverConnectionException.getServiceResult());
        }
    }

    private void a(CallMethodResult callMethodResult, DiagnosticInfo diagnosticInfo) throws MethodCallStatusException {
        if (callMethodResult.getStatusCode().isBad()) {
            throw new MethodCallStatusException(callMethodResult.getStatusCode(), diagnosticInfo, callMethodResult.getInputArgumentResults(), callMethodResult.getInputArgumentDiagnosticInfos());
        }
    }

    private void ciQ() {
        if (this.isConnected()) {
            throw new IllegalStateException("Cannot change connection or security settings when connected");
        }
    }

    private void ciR() {
        this.gN.set(null);
        this.gP.set(false);
        this.gR.set(0L);
        this.gM = null;
        this.gh = null;
    }

    private void f(UnsignedInteger unsignedInteger) {
        SessionChannel sessionChannel = this.gl.get();
        if (sessionChannel != null && sessionChannel.getSession() != null) {
            try {
                sessionChannel.CloseSession(this.a(null, unsignedInteger, null), !this.gv);
            }
            catch (ServiceResultException serviceResultException) {
                logger.info("Failed to CloseSession: ", (Throwable)serviceResultException);
            }
            if (!this.gv) {
                this.a(null, this.hd);
            }
        }
        if (sessionChannel != null) {
            sessionChannel.closeSecureChannel();
        }
        this.a((SessionChannel)null);
        this.gT = null;
    }

    private void ciS() {
        this.getAddressSpace().cir();
        TypeDictionary typeDictionary = this.getTypeDictionary();
        if (typeDictionary != null) {
            typeDictionary.clearCaches();
        }
        this.resetEndpoint();
        this.go = null;
    }

    private void ciT() throws ServiceException {
        logger.debug("connectSubscriptions");
        try {
            this.cjs();
        }
        catch (ServiceException serviceException) {
            logger.debug("transferSubscriptions: ", (Throwable)serviceException);
            this.a(null, this.hd);
        }
        this.a(true);
    }

    private void ciU() throws ConnectException, SessionActivationException, ServiceException {
        logger.debug("createAndActivateSessionChannel: unable to activate old session");
        try {
            this.ciW();
        }
        catch (Exception exception) {
            logger.debug("createAndActivateSessionChannel: re-init endpoint and retry.", (Throwable)exception);
            this.cjh();
            if (this.gr == null) {
                throw new ConnectException("No endpoint found", this.cjd(), this.gL);
            }
            this.ciV();
            this.ciW();
        }
        this.ciP();
        this.ciT();
        logger.debug("createAndActivateSessionChannel: New session created and activated");
        try {
            logger.debug("NamespaceTable: {}", (Object)this.getNamespaceTable(true));
        }
        catch (StatusException statusException) {
            logger.error("Cannot Read NamespaceArray from the server", (Throwable)statusException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ciV() throws ConnectException {
        SessionChannel sessionChannel = this.gl.get();
        this.a((SessionChannel)null);
        if (sessionChannel != null) {
            sessionChannel.closeSecureChannel();
        }
        UaClient uaClient = this;
        synchronized (uaClient) {
            try {
                if (this.isInReverseMode()) {
                    ReverseTransportChannelSettings reverseTransportChannelSettings = new ReverseTransportChannelSettings();
                    reverseTransportChannelSettings.setReverseConnectionListener(this.he);
                    reverseTransportChannelSettings.setConfiguration(this.gs);
                    reverseTransportChannelSettings.setDescription(this.gr);
                    reverseTransportChannelSettings.setOpctcpSettings(null);
                    this.gK = this.gm.createReverseSecureChannel(this.hf.getAddress(), reverseTransportChannelSettings);
                } else {
                    TransportChannelSettings transportChannelSettings = new TransportChannelSettings();
                    transportChannelSettings.setConfiguration(this.gs);
                    transportChannelSettings.setDescription(this.gr);
                    transportChannelSettings.setOpctcpSettings(null);
                    UaAddress uaAddress = this.resolveConnectionAddress(this.gi, this.gr);
                    this.gK = this.gm.createSecureChannel(uaAddress.getAddress(), transportChannelSettings);
                }
            }
            catch (ServiceResultException serviceResultException) {
                this.gK = null;
                throw new ConnectException("Failed to create secure channel to server: ", this.gr.getEndpointUrl(), this.gL, serviceResultException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ciW() throws ServiceException {
        logger.debug("createSessionChannel");
        UaClient uaClient = this;
        synchronized (uaClient) {
            this.gT = null;
            try {
                Cert cert;
                Cert cert2 = null;
                if (this.gr.getServerCertificate() != null && this.gr.getServerCertificate().getLength() != 0) {
                    cert2 = new Cert(this.gr.getServerCertificate().getValue());
                }
                EndpointDescription[] endpointDescriptionArray = this.ha ? this.go : null;
                this.gT = this.gm.createSession(this.gK, this.getMaxResponseMessageSize(), this.getSessionTimeout(), this.getSessionName(), endpointDescriptionArray);
                ByteString byteString = this.gT.getEndpoint().getServerCertificate();
                logger.debug("createSessionChannel: session.getEndpoint().getServerCertificate()={}", (Object)byteString);
                Cert cert3 = this.gT.getServerCertificate();
                if (!EndpointUtil.needsCertificate(this.getEndpoint()) && cert3 != null) {
                    logger.info("Server sent a certificate, although SecurityPolicy NONE is used");
                }
                if ((byteString == null || byteString.getLength() == 0) && cert3 != null) {
                    logger.debug("createSessionChannel: session.getServerCertificate().getEncoded()={}", (Object)cert3.getEncoded());
                    this.gT.getEndpoint().setServerCertificate(ByteString.valueOf(cert3.getEncoded()));
                } else if (!SecurityMode.NONE.equals(this.gL)) {
                    Cert cert4 = cert = this.gT.getEndpoint().getServerCertificate() == null ? null : new Cert(this.gT.getEndpoint().getServerCertificate().getValue());
                    if (this.hb && cert3 != null && !Objects.equals(cert, cert3)) {
                        throw new ServiceException("Different cert in CreateSessionResponse.serverCertificate and endpoints", StatusCodes.Bad_UnexpectedError);
                    }
                }
                if (!SecurityMode.NONE.equals(this.gL)) {
                    cert = cert3;
                    if (this.hb && !Objects.equals(cert2, cert)) {
                        throw new ServiceException("Certificates in endpoint and CreateSessionResponse not same", StatusCodes.Bad_UnexpectedError);
                    }
                }
            }
            catch (ServiceResultException serviceResultException) {
                logger.debug("createSessionChannel: serviceResult={}", (Object)serviceResultException.getStatusCode());
                this.gK.closeAsync();
                this.gK = null;
                if (StatusCodes.Bad_UnexpectedError.equals(serviceResultException.getStatusCode().getValue())) {
                    throw new InvalidServerEndpointException("Failed to create session channel to server: ", this.cjd(), this.gL, serviceResultException);
                }
                throw new ConnectException("Failed to create session channel to server: ", this.cjd(), this.gL, serviceResultException);
            }
        }
        this.a(this.gT.createSessionChannel(this.gK, this.gm));
        logger.debug("MessageSecurityMode: {}, SecurityPolicy: {}, UserIdentity type: {}", new Object[]{this.getSecurityMode().getMessageSecurityMode(), this.getSecurityMode().getSecurityPolicy(), this.getUserIdentity().getType()});
        if (MessageSecurityMode.None == this.getSecurityMode().getMessageSecurityMode() && SecurityPolicy.NONE == this.getSecurityMode().getSecurityPolicy() && UserTokenType.Anonymous == this.getUserIdentity().getType()) {
            logger.debug("SecurityMode NONE and UserTokenType Anonymous, skipping nonce checks");
        } else {
            logger.debug("Validating that the server send long enough nonce (min 32bytes), is: {}", (Object)this.gT.getServerNonce());
            if (this.gT.getServerNonce() == null || this.gT.getServerNonce().getLength() < 32) {
                throw new ConnectException("Received less than 32 byte nonce from the server, was:" + this.gT.getServerNonce(), this.cjd(), this.gL);
            }
        }
        if (this.gA != null) {
            this.gA.onAfterCreateSessionChannel(this, this.getSession());
        }
    }

    private boolean a(Subscription subscription, boolean bl) throws ServiceException {
        CreateSubscriptionResponse createSubscriptionResponse;
        logger.debug("createSubscription: subscription={}, allowModification={}, isModified={}", new Object[]{subscription.getSubscriptionId(), bl, subscription.isModified()});
        if (subscription.getSubscriptionId() != null && subscription.getSubscriptionId().getValue() != 0L) {
            try {
                if (bl && subscription.isModified()) {
                    this.a((SubscriptionBase)subscription);
                }
                return false;
            }
            catch (ServiceException serviceException) {
                logger.debug("createSubscription: cannot modify: invalid subscription={} Exception={}", (Object)subscription.getSubscriptionId(), (Object)serviceException);
                subscription.reset();
            }
        }
        try {
            logger.debug("createSubscription: subscription={}", (Object)subscription);
            createSubscriptionResponse = this.ciq().CreateSubscription(this.getRequestHeader(), subscription.getPublishingInterval(), UnsignedInteger.valueOf(subscription.getLifetimeCount()), UnsignedInteger.valueOf(subscription.getMaxKeepAliveCount()), UnsignedInteger.valueOf(subscription.getMaxNotificationsPerPublish()), subscription.isPublishingEnabled(), UnsignedByte.valueOf(subscription.getPriority()));
            logger.debug("createSubscription: reponse={}", (Object)createSubscriptionResponse.getResponseHeader().getServiceResult());
        }
        catch (ServiceFaultException serviceFaultException) {
            throw new ServiceException(serviceFaultException);
        }
        catch (ServiceResultException serviceResultException) {
            throw new ServiceException(serviceResultException);
        }
        this.checkServiceResult(createSubscriptionResponse, null);
        logger.debug("createSubscription: response SubscriptionId={}, RevisedPublishingInterval={}, RevisedMaxKeepAliveCount={}, RevisedLifetimeCount={}", new Object[]{createSubscriptionResponse.getSubscriptionId(), createSubscriptionResponse.getRevisedPublishingInterval(), createSubscriptionResponse.getRevisedMaxKeepAliveCount(), createSubscriptionResponse.getRevisedLifetimeCount()});
        if (createSubscriptionResponse.getSubscriptionId() == null || UnsignedInteger.ZERO.equals(createSubscriptionResponse.getSubscriptionId())) {
            logger.error("CreateSubscriptionResponse returned SubscriptionId of 0 which is not valid id");
        }
        subscription.setSubscriptionId(createSubscriptionResponse.getSubscriptionId());
        subscription.setPublishingInterval(createSubscriptionResponse.getRevisedPublishingInterval());
        subscription.setLifetimeCount(createSubscriptionResponse.getRevisedLifetimeCount());
        subscription.setMaxKeepAliveCount(createSubscriptionResponse.getRevisedMaxKeepAliveCount());
        subscription.setClient(this);
        subscription.createItems();
        subscription.fireAfterCreate();
        return true;
    }

    private void a(boolean bl) {
        this.gt = false;
        int n2 = 0;
        for (Subscription subscription : this.hd) {
            try {
                this.a(subscription, bl);
            }
            catch (Exception exception) {
                ServiceException serviceException;
                logger.warn("Failed to create subscription to the server: {}", (Object)subscription, (Object)exception);
                this.gt = true;
                ++n2;
                if (!(exception instanceof ServiceException) || (serviceException = (ServiceException)exception).getServiceResult() == null || !StatusCodes.Bad_TooManySubscriptions.equals(serviceException.getServiceResult().getValue())) continue;
                logger.warn("Failure due to Bad_TooManySubscriptions, skipping rest of the subscriptions, total number of failures so far was: {}, total number of subscriptions: {}", (Object)n2, (Object)this.hd.size());
                return;
            }
        }
        if (n2 > 0) {
            logger.warn("Total {} failures for creating subscriptions to the server, total number of subscriptions: {}", (Object)n2, (Object)this.hd.size());
        }
    }

    private StatusCode[] a(SubscriptionBase ... subscriptionBaseArray) throws ServiceException {
        if (this.isConnected()) {
            DeleteSubscriptionsResponse deleteSubscriptionsResponse;
            UnsignedInteger[] unsignedIntegerArray = new UnsignedInteger[subscriptionBaseArray.length];
            for (int i2 = 0; i2 < subscriptionBaseArray.length; ++i2) {
                unsignedIntegerArray[i2] = subscriptionBaseArray[i2].getSubscriptionId();
            }
            try {
                deleteSubscriptionsResponse = this.ciq().DeleteSubscriptions(this.getRequestHeader(), unsignedIntegerArray);
                logger.debug("deleteSubscriptions: response={}", (Object)deleteSubscriptionsResponse);
            }
            catch (ServiceFaultException serviceFaultException) {
                throw new ServiceException(serviceFaultException);
            }
            catch (ServiceResultException serviceResultException) {
                throw new ServiceException(serviceResultException);
            }
            this.checkServiceResult(deleteSubscriptionsResponse, null);
            StatusCode[] statusCodeArray = deleteSubscriptionsResponse.getResults();
            if (statusCodeArray != null && statusCodeArray.length != subscriptionBaseArray.length && logger.isWarnEnabled()) {
                logger.warn("Received {} DeleteSubscriptions results when expecting {}, received StatusCodes: {}", new Object[]{statusCodeArray.length, subscriptionBaseArray.length, MultiDimensionArrayUtils.toString(statusCodeArray)});
            }
            return statusCodeArray;
        }
        return null;
    }

    private AsyncResult<DeleteSubscriptionsResponse> b(SubscriptionBase ... subscriptionBaseArray) throws ServiceException {
        if (this.isConnected()) {
            UnsignedInteger[] unsignedIntegerArray = new UnsignedInteger[subscriptionBaseArray.length];
            for (int i2 = 0; i2 < subscriptionBaseArray.length; ++i2) {
                unsignedIntegerArray[i2] = subscriptionBaseArray[i2].getSubscriptionId();
            }
            return this.ciq().DeleteSubscriptionsAsync(this.getRequestHeader(), unsignedIntegerArray);
        }
        return null;
    }

    private void a(TransferResult[] transferResultArray, List<Subscription> list) {
        if (logger.isDebugEnabled()) {
            logger.debug("disconnectSubscriptions: " + Arrays.toString(transferResultArray));
        }
        for (int i2 = 0; i2 < list.size(); ++i2) {
            if (transferResultArray != null && transferResultArray[i2] != null && !transferResultArray[i2].getStatusCode().isBad()) continue;
            list.get(i2).reset();
        }
    }

    private EndpointDescription[] a(ChannelService channelService, String string, UaApplication.Protocol ... protocolArray) throws ServiceFaultException, ServiceResultException, ServiceException {
        String[] stringArray = new String[protocolArray.length];
        for (int i2 = 0; i2 < protocolArray.length; ++i2) {
            stringArray[i2] = protocolArray[i2].getTransportProfileUri();
        }
        GetEndpointsRequest getEndpointsRequest = new GetEndpointsRequest(this.getRequestHeader(), string, stringArray, stringArray);
        GetEndpointsResponse getEndpointsResponse = channelService.GetEndpoints(getEndpointsRequest);
        this.checkServiceResult(getEndpointsResponse, null);
        return getEndpointsResponse.getEndpoints();
    }

    private ReadResponse a(Double d2, TimestampsToReturn timestampsToReturn, ReadValueId ... readValueIdArray) throws ServiceException {
        try {
            ReadResponse readResponse = this.ciq().Read(this.getRequestHeader(), d2, timestampsToReturn, readValueIdArray);
            this.checkServiceResult(readResponse, readResponse.getDiagnosticInfos());
            this.a(readResponse.getResults(), readValueIdArray);
            return readResponse;
        }
        catch (ServiceFaultException serviceFaultException) {
            throw new ServiceException(serviceFaultException);
        }
        catch (ServiceResultException serviceResultException) {
            throw new ServiceException(serviceResultException);
        }
    }

    private boolean ciX() throws ServiceException, ConnectException, SessionActivationException {
        logger.debug("reconnect: Reconnecting to server");
        if (this.gk && !Thread.currentThread().equals(this.gI)) {
            throw new IllegalStateException("AutoReconnect is true, SDK is handling reconnections automatically, thus reconnect shall not be called manually");
        }
        try {
            this.ciV();
        }
        catch (Exception exception) {
            logger.debug("Failed to create secure channel: {}", (Throwable)exception);
            if (exception.getCause() instanceof ServiceResultException) {
                throw new ServiceException((ServiceResultException)exception.getCause());
            }
            throw new ServiceException(exception.getMessage(), StatusCodes.Bad_ServerNotConnected, null, (Throwable)exception);
        }
        logger.debug("reconnect: secure channel created");
        boolean bl = false;
        if (this.gT == null) {
            this.ciU();
        } else {
            this.a(this.gT.createSessionChannel(this.gK, this.gm));
            logger.debug("reconnect: setting channel ok");
            try {
                this.ciP();
                logger.debug("reconnect: Old session re-activated");
                this.cjr();
                this.a(true);
                bl = true;
            }
            catch (SessionActivationException sessionActivationException) {
                this.ciU();
            }
        }
        logger.info("reconnect: Reconnected to server " + (bl ? "(session reactivated)" : "(new session)"));
        return bl;
    }

    private WriteResponse a(WriteValue ... writeValueArray) throws ServiceException {
        try {
            WriteResponse writeResponse = this.ciq().Write(this.getRequestHeader(), writeValueArray);
            this.checkServiceResult(writeResponse, writeResponse.getDiagnosticInfos());
            this.a(writeResponse.getResults(), (Object[])writeValueArray);
            return writeResponse;
        }
        catch (ServiceFaultException serviceFaultException) {
            throw new ServiceException(serviceFaultException);
        }
        catch (ServiceResultException serviceResultException) {
            throw new ServiceException(serviceResultException);
        }
    }

    private void a(long l2, LocalizedText localizedText) {
        for (ServerStatusListener serverStatusListener : this.gO) {
            try {
                serverStatusListener.onShutdown(this, l2, localizedText);
            }
            catch (Exception exception) {
                logger.error("Exception in ServerStatusListener", (Throwable)exception);
            }
        }
    }

    private void a(ServerState serverState, ServerState serverState2) {
        for (ServerStatusListener serverStatusListener : this.gO) {
            try {
                serverStatusListener.onStateChange(this, serverState, serverState2);
            }
            catch (Exception exception) {
                logger.error("Exception in ServerStatusListener", (Throwable)exception);
            }
        }
    }

    private void ciY() {
        for (ServerStatusListener serverStatusListener : this.gO) {
            try {
                Optional<e> optional = Optional.ofNullable(this.gN.get());
                ServerStatusDataType serverStatusDataType = optional.map(e2 -> e2.ht).orElse(null);
                StatusCode statusCode = optional.map(e2 -> e2.hu).orElse(null);
                StatusCode statusCode2 = statusCode == null ? StatusCode.GOOD : statusCode;
                serverStatusListener.onStatusChange(this, serverStatusDataType, statusCode2);
            }
            catch (Exception exception) {
                logger.error("Exception in ServerStatusListener", (Throwable)exception);
            }
        }
    }

    private EndpointDescription[] getEndpoints() throws InvalidServerEndpointException, ConnectException, ServiceException {
        this.go = this.discoverEndpoints();
        if (logger.isDebugEnabled()) {
            logger.debug("endpoints:" + Arrays.toString(this.go));
        }
        if (this.go == null || this.go.length == 0) {
            throw new ServiceException("GetEndpointsResponse, endpoint list received from the server is empty.", StatusCodes.Bad_UnexpectedError);
        }
        EndpointDescription[] endpointDescriptionArray = this.a(this.go, this.cjd());
        if (endpointDescriptionArray.length == 0 && this.cjl()) {
            try {
                InetAddress inetAddress = InetAddress.getLocalHost();
                endpointDescriptionArray = this.a(this.go, this.cjd().replaceFirst("localhost", inetAddress.getHostName()));
                endpointDescriptionArray = this.a(this.go, this.cjd().replaceFirst("localhost", inetAddress.getCanonicalHostName()));
            }
            catch (UnknownHostException unknownHostException) {
                logger.info("Cannot convert localhost to HostName: ", (Throwable)unknownHostException);
            }
        }
        if (endpointDescriptionArray.length == 0) {
            endpointDescriptionArray = this.a(this.go, (String)null);
        }
        if (endpointDescriptionArray.length == 0) {
            throw new InvalidServerEndpointException("Requested endpoint not supported by the server", this.cjd(), this.getSecurityMode());
        }
        endpointDescriptionArray = EndpointUtil.sortBySecurityLevel(endpointDescriptionArray);
        return endpointDescriptionArray;
    }

    private String ciZ() {
        if (this.gi == null) {
            return "";
        }
        return this.gi.getHost();
    }

    private UnsignedInteger a(Map<NodeId, DataValue> map, String string, NodeId nodeId, UnsignedInteger unsignedInteger) {
        try {
            DataValue dataValue = map.get(nodeId);
            if (dataValue.getStatusCode().isNotGood()) {
                throw new StatusException(dataValue.getStatusCode());
            }
            if (!(dataValue.getValue().getValue() instanceof UnsignedInteger)) {
                throw new IllegalStateException("OperationLimit value something else than UnsignedInteger");
            }
            return (UnsignedInteger)dataValue.getValue().getValue();
        }
        catch (Exception exception) {
            logger.warn("Could not Read OperationLimit: {} with NodeId: {}, either the server does not have the node or the read didn't return a Good value that can be interpreted as UnsignedInteger, value was: {}, using default value of {} instead (note that this will be overriden by clientside limits if lower)", new Object[]{string, nodeId, map.get(nodeId), unsignedInteger});
            return unsignedInteger;
        }
    }

    private UaApplication.Protocol cja() {
        if (this.gi == null) {
            return UaApplication.Protocol.OpcTcp;
        }
        return this.gi.getProtocol();
    }

    private RequestHeader a(UnsignedInteger unsignedInteger, UnsignedInteger unsignedInteger2, String string) {
        RequestHeader requestHeader = new RequestHeader();
        requestHeader.setReturnDiagnostics(unsignedInteger);
        requestHeader.setTimeoutHint(unsignedInteger2);
        requestHeader.setAuditEntryId(string);
        requestHeader.setTimestamp(DateTime.currentTime());
        requestHeader.setRequestHandle(this.cjm());
        return requestHeader;
    }

    private StatusCode cjb() {
        return Optional.ofNullable(this.gN.get()).map(e2 -> e2.hu).orElse(null);
    }

    private ServerStatusDataType cjc() {
        return Optional.ofNullable(this.gN.get()).map(e2 -> e2.ht).orElse(null);
    }

    private SubscriptionAcknowledgement[] getSubscriptionAcknowledgements() {
        ArrayList arrayList = new ArrayList();
        this.gg.drainTo(arrayList);
        return arrayList.toArray(new SubscriptionAcknowledgement[0]);
    }

    private String cjd() {
        if (this.gi == null) {
            return "";
        }
        return this.gi.getAddress();
    }

    private HistoryReadResult[] a(NodeId[] nodeIdArray, int n2, d d2) throws ServiceException, DecodingException, EncodingException {
        if (Integer.compareUnsigned(n2, Integer.MAX_VALUE) > 0) {
            n2 = Integer.MAX_VALUE;
        }
        if (n2 >= nodeIdArray.length) {
            return d2.read(nodeIdArray);
        }
        ArrayList<HistoryReadResult[]> arrayList = new ArrayList<HistoryReadResult[]>();
        for (int i2 = 0; i2 < nodeIdArray.length; i2 += n2) {
            int n3 = Math.min(n2, nodeIdArray.length - i2);
            NodeId[] nodeIdArray2 = new NodeId[n3];
            System.arraycopy(nodeIdArray, i2, nodeIdArray2, 0, n3);
            arrayList.add(d2.read(nodeIdArray2));
        }
        return (HistoryReadResult[])arrayList.stream().flatMap(Arrays::stream).toArray(HistoryReadResult[]::new);
    }

    private boolean a(PublishResponse publishResponse) throws ServiceException {
        logger.debug("handlePublishResponse: response={}", (Object)publishResponse.getNotificationMessage().getSequenceNumber());
        logger.trace("handlePublishResponse: response={}", (Object)publishResponse);
        if (this.isConnected()) {
            this.checkServiceResult(publishResponse, publishResponse.getDiagnosticInfos());
            if (this.gA != null && !this.gA.validatePublishResponse(this, publishResponse)) {
                return false;
            }
            Subscription subscription = this.getSubscriptionById(publishResponse.getSubscriptionId());
            if (subscription == null) {
                logger.info("handlePublishResponse: no subscription with ID={} SequenceNumber={}; response discarded", (Object)publishResponse.getSubscriptionId(), (Object)publishResponse.getNotificationMessage().getSequenceNumber());
                return false;
            }
            subscription.onPublishResponse(publishResponse);
            return true;
        }
        logger.debug("handlePublishResponse: not connected; response discarded");
        return false;
    }

    private DataValue[] a(NodeId nodeId, NumericRange numericRange, TimestampsToReturn timestampsToReturn, HistoryReadDetails historyReadDetails) throws ServiceException, StatusException, DecodingException {
        ByteString byteString;
        logger.debug("historyReadAll: nodeId: {}, indexRange: {}, timestampsToReturn: {}, historyReadDetails: {}", new Object[]{nodeId, numericRange, timestampsToReturn, historyReadDetails});
        HistoryReadValueId historyReadValueId = new HistoryReadValueId();
        historyReadValueId.setNodeId(nodeId);
        if (numericRange != null) {
            historyReadValueId.setIndexRange(numericRange.toString());
        }
        ArrayList<DataValue> arrayList = null;
        do {
            ExtensionObject extensionObject;
            HistoryReadResult[] historyReadResultArray = this.historyRead(historyReadDetails, timestampsToReturn, false, historyReadValueId);
            this.checkOperationResult(historyReadResultArray[0].getStatusCode());
            logger.debug("historyReadAll: Got StatusCode: {}", (Object)historyReadResultArray[0].getStatusCode());
            if (historyReadResultArray[0].getStatusCode().getValue().equals(StatusCodes.Good_NoData)) {
                if (historyReadResultArray[0].getHistoryData() == null) break;
                logger.warn("historyReadAll: Received StatusCode Good_NoData, but also received HistoryData");
            }
            if ((extensionObject = historyReadResultArray[0].getHistoryData()) == null) {
                logger.debug("historyReadAll: HistoryData is null");
                break;
            }
            HistoryData historyData = (HistoryData)extensionObject.decode(this.gm.getEncoderContext());
            byteString = historyReadResultArray[0].getContinuationPoint();
            if (byteString == null && arrayList == null) {
                if (historyData.getDataValues() != null) {
                    logger.debug("historyReadAll: Read complete, returning {} values", (Object)historyData.getDataValues().length);
                } else {
                    logger.debug("historyReadAll: Read complete, returning null");
                }
                return historyData.getDataValues();
            }
            if (arrayList == null) {
                arrayList = new ArrayList<DataValue>();
            }
            arrayList.addAll(Arrays.asList(historyData.getDataValues()));
            historyReadValueId.setContinuationPoint(byteString);
            if (historyData.getDataValues().length == 0 && byteString != null) {
                logger.info("historyReadAll: Received empty HistoryData with continuationPoint");
                break;
            }
            logger.debug("historyReadAll: got {} values", (Object)historyData.getDataValues().length);
        } while (byteString != null);
        if (arrayList != null) {
            logger.debug("historyReadAll: Read complete, returning an array of {} DataValues", (Object)arrayList.size());
        } else {
            logger.debug("historyReadAll: Read complete, returning an empty DataValue array");
        }
        return arrayList == null ? new DataValue[]{} : arrayList.toArray(new DataValue[arrayList.size()]);
    }

    private HistoryReadResult[] a(NodeId[] nodeIdArray, final NumericRange numericRange, TimestampsToReturn timestampsToReturn, HistoryReadDetails historyReadDetails) throws ServiceException, DecodingException, EncodingException {
        Cloneable cloneable;
        DataValue[] dataValueArray;
        Object object;
        AbstractStructure[] abstractStructureArray;
        logger.debug("historyReadAll: nodeIds: {}, timestampsToReturn: {}, historyReadDetails: {}", new Object[]{nodeIdArray, timestampsToReturn, historyReadDetails});
        class A {
            private boolean hk = false;
            private StatusCode statusCode = null;
            private final List<DataValue> hl = new ArrayList<DataValue>();
            private final HistoryReadValueId hm = new HistoryReadValueId();

            public A(NodeId nodeId) {
                this.hm.setNodeId(nodeId);
                if (numericRange != null) {
                    this.hm.setIndexRange(numericRange.toString());
                }
            }

            public void setDone() {
                this.hk = true;
            }
        }
        A[] aArray = new A[nodeIdArray.length];
        ArrayList<A> arrayList = new ArrayList<A>(nodeIdArray.length);
        for (int i2 = 0; i2 < nodeIdArray.length; ++i2) {
            aArray[i2] = new A(nodeIdArray[i2]);
            arrayList.add(aArray[i2]);
        }
        do {
            abstractStructureArray = (HistoryReadValueId[])arrayList.stream().map(a2 -> ((A)a2).hm).toArray(HistoryReadValueId[]::new);
            HistoryReadResult[] historyReadResultArray = this.historyRead(historyReadDetails, timestampsToReturn, false, (HistoryReadValueId[])abstractStructureArray);
            for (int i3 = 0; i3 < historyReadResultArray.length; ++i3) {
                object = (A)arrayList.get(i3);
                dataValueArray = historyReadResultArray[i3];
                ((A)object).statusCode = dataValueArray.getStatusCode();
                logger.debug("historyReadAll: Got StatusCode: {}", (Object)dataValueArray.getStatusCode());
                if (dataValueArray.getStatusCode().isBad()) {
                    ((A)object).setDone();
                    continue;
                }
                if (dataValueArray.getStatusCode().getValue().equals(StatusCodes.Good_NoData)) {
                    if (dataValueArray.getHistoryData() != null) {
                        logger.warn("historyReadAll: Received StatusCode Good_NoData, but also received HistoryData");
                    } else {
                        ((A)object).setDone();
                        continue;
                    }
                }
                if ((cloneable = dataValueArray.getHistoryData()) == null) {
                    logger.debug("historyReadAll: HistoryData is null");
                    ((A)object).setDone();
                    continue;
                }
                HistoryData historyData = (HistoryData)cloneable.decode(this.gm.getEncoderContext());
                ByteString byteString = dataValueArray.getContinuationPoint();
                if (byteString == null) {
                    ((A)object).setDone();
                }
                if (historyData.getDataValues() == null) {
                    ((A)object).setDone();
                    continue;
                }
                ((A)object).hl.addAll(Arrays.asList(historyData.getDataValues()));
                ((A)object).hm.setContinuationPoint(byteString);
                if (historyData.getDataValues().length == 0 && byteString != null) {
                    logger.info("historyReadAll: Received empty HistoryData with continuationPoint");
                    ((A)object).setDone();
                    continue;
                }
                logger.debug("historyReadAll: got {} values", (Object)historyData.getDataValues().length);
            }
            arrayList.removeIf(a2 -> ((A)a2).hk);
        } while (!arrayList.isEmpty());
        abstractStructureArray = new HistoryReadResult[nodeIdArray.length];
        for (int i4 = 0; i4 < nodeIdArray.length; ++i4) {
            A a3 = aArray[i4];
            object = a3.hl;
            dataValueArray = object.toArray(new DataValue[object.size()]);
            cloneable = new HistoryData(dataValueArray);
            abstractStructureArray[i4] = new HistoryReadResult(a3.statusCode, null, ExtensionObject.binaryEncode((Structure)cloneable, this.gm.getEncoderContext()));
        }
        return abstractStructureArray;
    }

    private HistoryEventFieldList[] b(NodeId nodeId, NumericRange numericRange, TimestampsToReturn timestampsToReturn, HistoryReadDetails historyReadDetails) throws ServiceException, StatusException, DecodingException {
        ByteString byteString;
        HistoryReadValueId historyReadValueId = new HistoryReadValueId();
        historyReadValueId.setNodeId(nodeId);
        if (numericRange != null) {
            historyReadValueId.setIndexRange(numericRange.toString());
        }
        ArrayList<HistoryEventFieldList> arrayList = null;
        do {
            ExtensionObject extensionObject;
            HistoryReadResult[] historyReadResultArray = this.historyRead(historyReadDetails, timestampsToReturn, false, historyReadValueId);
            this.checkOperationResult(historyReadResultArray[0].getStatusCode());
            if (historyReadResultArray[0].getStatusCode().getValue().equals(StatusCodes.Good_NoData) || (extensionObject = historyReadResultArray[0].getHistoryData()) == null) break;
            HistoryEvent historyEvent = (HistoryEvent)extensionObject.decode(this.gm.getEncoderContext());
            byteString = historyReadResultArray[0].getContinuationPoint();
            if (byteString == null && arrayList == null) {
                return historyEvent.getEvents();
            }
            if (arrayList == null) {
                arrayList = new ArrayList<HistoryEventFieldList>();
            }
            arrayList.addAll(Arrays.asList(historyEvent.getEvents()));
            historyReadValueId.setContinuationPoint(byteString);
        } while (byteString != null);
        return arrayList == null ? new HistoryEventFieldList[]{} : arrayList.toArray(new HistoryEventFieldList[arrayList.size()]);
    }

    private HistoryReadResult[] b(NodeId[] nodeIdArray, final NumericRange numericRange, TimestampsToReturn timestampsToReturn, HistoryReadDetails historyReadDetails) throws ServiceException, DecodingException, EncodingException {
        Cloneable cloneable;
        HistoryEventFieldList[] historyEventFieldListArray;
        Object object;
        AbstractStructure[] abstractStructureArray;
        class B {
            private boolean hk = false;
            private StatusCode statusCode = null;
            private final List<HistoryEventFieldList> hl = new ArrayList<HistoryEventFieldList>();
            private final HistoryReadValueId hm = new HistoryReadValueId();

            public B(NodeId nodeId) {
                this.hm.setNodeId(nodeId);
                if (numericRange != null) {
                    this.hm.setIndexRange(numericRange.toString());
                }
            }

            public void setDone() {
                this.hk = true;
            }
        }
        B[] bArray = new B[nodeIdArray.length];
        ArrayList<B> arrayList = new ArrayList<B>(nodeIdArray.length);
        for (int i2 = 0; i2 < nodeIdArray.length; ++i2) {
            bArray[i2] = new B(nodeIdArray[i2]);
            arrayList.add(bArray[i2]);
        }
        do {
            abstractStructureArray = (HistoryReadValueId[])arrayList.stream().map(b2 -> ((B)b2).hm).toArray(HistoryReadValueId[]::new);
            HistoryReadResult[] historyReadResultArray = this.historyRead(historyReadDetails, timestampsToReturn, false, (HistoryReadValueId[])abstractStructureArray);
            for (int i3 = 0; i3 < historyReadResultArray.length; ++i3) {
                object = (B)arrayList.get(i3);
                historyEventFieldListArray = historyReadResultArray[i3];
                ((B)object).statusCode = historyEventFieldListArray.getStatusCode();
                if (historyEventFieldListArray.getStatusCode().isBad() || historyEventFieldListArray.getStatusCode().getValue().equals(StatusCodes.Good_NoData)) {
                    ((B)object).setDone();
                    continue;
                }
                cloneable = historyEventFieldListArray.getHistoryData();
                if (cloneable == null) {
                    ((B)object).setDone();
                    continue;
                }
                HistoryEvent historyEvent = (HistoryEvent)cloneable.decode(this.gm.getEncoderContext());
                ByteString byteString = historyReadResultArray[0].getContinuationPoint();
                if (historyEvent.getEvents() != null) {
                    ((B)object).hl.addAll(Arrays.asList(historyEvent.getEvents()));
                }
                ((B)object).hm.setContinuationPoint(byteString);
                if (byteString != null) continue;
                ((B)object).setDone();
            }
            arrayList.removeIf(b2 -> ((B)b2).hk);
        } while (!arrayList.isEmpty());
        abstractStructureArray = new HistoryReadResult[nodeIdArray.length];
        for (int i4 = 0; i4 < nodeIdArray.length; ++i4) {
            B b3 = bArray[i4];
            object = b3.hl;
            historyEventFieldListArray = object.toArray(new HistoryEventFieldList[object.size()]);
            cloneable = new HistoryEvent(historyEventFieldListArray);
            abstractStructureArray[i4] = new HistoryReadResult(b3.statusCode, null, ExtensionObject.binaryEncode((Structure)cloneable, this.gm.getEncoderContext()));
        }
        return abstractStructureArray;
    }

    private HistoryModifiedData c(NodeId nodeId, NumericRange numericRange, TimestampsToReturn timestampsToReturn, HistoryReadDetails historyReadDetails) throws ServiceException, StatusException, DecodingException {
        ByteString byteString;
        HistoryReadValueId historyReadValueId = new HistoryReadValueId();
        historyReadValueId.setNodeId(nodeId);
        if (numericRange != null) {
            historyReadValueId.setIndexRange(numericRange.toString());
        }
        ArrayList<DataValue> arrayList = null;
        ArrayList<ModificationInfo> arrayList2 = null;
        do {
            ExtensionObject extensionObject;
            HistoryReadResult[] historyReadResultArray = this.historyRead(historyReadDetails, timestampsToReturn, false, historyReadValueId);
            this.checkOperationResult(historyReadResultArray[0].getStatusCode());
            if (historyReadResultArray[0].getStatusCode().getValue().equals(StatusCodes.Good_NoData) || (extensionObject = historyReadResultArray[0].getHistoryData()) == null) break;
            HistoryModifiedData historyModifiedData = (HistoryModifiedData)extensionObject.decode(this.gm.getEncoderContext());
            byteString = historyReadResultArray[0].getContinuationPoint();
            if (byteString == null && arrayList == null) {
                return historyModifiedData;
            }
            if (arrayList == null) {
                arrayList = new ArrayList<DataValue>();
                arrayList2 = new ArrayList<ModificationInfo>();
            }
            arrayList.addAll(Arrays.asList(historyModifiedData.getDataValues()));
            arrayList2.addAll(Arrays.asList(historyModifiedData.getModificationInfos()));
            historyReadValueId.setContinuationPoint(byteString);
        } while (byteString != null);
        return arrayList == null ? new HistoryModifiedData(new DataValue[0], new ModificationInfo[0]) : new HistoryModifiedData(arrayList.toArray(new DataValue[arrayList.size()]), arrayList2.toArray(new ModificationInfo[arrayList2.size()]));
    }

    private HistoryReadResult[] c(NodeId[] nodeIdArray, final NumericRange numericRange, TimestampsToReturn timestampsToReturn, HistoryReadDetails historyReadDetails) throws ServiceException, DecodingException, EncodingException {
        Object object;
        ModificationInfo[] modificationInfoArray;
        Object object2;
        DataValue[] dataValueArray;
        Object object3;
        AbstractStructure[] abstractStructureArray;
        class C {
            private boolean hk = false;
            private StatusCode statusCode = null;
            private final List<DataValue> hl = new ArrayList<DataValue>();
            private final List<ModificationInfo> hs = new ArrayList<ModificationInfo>();
            private final HistoryReadValueId hm = new HistoryReadValueId();

            public C(NodeId nodeId) {
                this.hm.setNodeId(nodeId);
                if (numericRange != null) {
                    this.hm.setIndexRange(numericRange.toString());
                }
            }

            public void setDone() {
                this.hk = true;
            }
        }
        C[] cArray = new C[nodeIdArray.length];
        ArrayList<C> arrayList = new ArrayList<C>(nodeIdArray.length);
        for (int i2 = 0; i2 < nodeIdArray.length; ++i2) {
            cArray[i2] = new C(nodeIdArray[i2]);
            arrayList.add(cArray[i2]);
        }
        do {
            abstractStructureArray = (HistoryReadValueId[])arrayList.stream().map(c2 -> ((C)c2).hm).toArray(HistoryReadValueId[]::new);
            HistoryReadResult[] historyReadResultArray = this.historyRead(historyReadDetails, timestampsToReturn, false, (HistoryReadValueId[])abstractStructureArray);
            for (int i3 = 0; i3 < historyReadResultArray.length; ++i3) {
                object3 = (C)arrayList.get(i3);
                dataValueArray = historyReadResultArray[i3];
                ((C)object3).statusCode = dataValueArray.getStatusCode();
                if (dataValueArray.getStatusCode().isBad()) {
                    ((C)object3).setDone();
                    continue;
                }
                if (dataValueArray.getStatusCode().getValue().equals(StatusCodes.Good_NoData)) {
                    ((C)object3).setDone();
                    continue;
                }
                object2 = dataValueArray.getHistoryData();
                if (object2 == null) {
                    ((C)object3).setDone();
                    continue;
                }
                modificationInfoArray = (ModificationInfo[])((ExtensionObject)object2).decode(this.gm.getEncoderContext());
                object = dataValueArray.getContinuationPoint();
                if (modificationInfoArray.getDataValues() != null) {
                    ((C)object3).hl.addAll(Arrays.asList(modificationInfoArray.getDataValues()));
                }
                if (modificationInfoArray.getModificationInfos() != null) {
                    ((C)object3).hs.addAll(Arrays.asList(modificationInfoArray.getModificationInfos()));
                }
                ((C)object3).hm.setContinuationPoint((ByteString)object);
                if (object != null) continue;
                ((C)object3).setDone();
            }
            arrayList.removeIf(c2 -> ((C)c2).hk);
        } while (!arrayList.isEmpty());
        abstractStructureArray = new HistoryReadResult[nodeIdArray.length];
        for (int i4 = 0; i4 < nodeIdArray.length; ++i4) {
            C c3 = cArray[i4];
            object3 = c3.hl;
            dataValueArray = object3.toArray(new DataValue[object3.size()]);
            object2 = c3.hs;
            modificationInfoArray = object2.toArray(new ModificationInfo[object2.size()]);
            object = new HistoryModifiedData(dataValueArray, modificationInfoArray);
            abstractStructureArray[i4] = new HistoryReadResult(c3.statusCode, null, ExtensionObject.binaryEncode((Structure)object, this.gm.getEncoderContext()));
        }
        return abstractStructureArray;
    }

    private void cje() throws SessionActivationException {
        if (this.isConnected()) {
            this.ciP();
        }
    }

    private void cjf() {
        Application application = this.gm.getApplication();
        application.setApplicationName(this.getApplicationIdentity().getApplicationDescription().getApplicationName());
        application.setApplicationUri(this.getApplicationIdentity().getApplicationDescription().getApplicationUri());
        application.setProductUri(this.getApplicationIdentity().getApplicationDescription().getProductUri());
    }

    private void cjg() {
        this.gm.getApplication().setApplicationUri(this.applicationIdentity.getApplicationDescription().getApplicationUri());
        this.gm.getApplication().removeApplicationInstanceCertificates();
        if (this.applicationIdentity.getKeys() != null) {
            this.gm.getApplication().addApplicationInstanceCertificate(this.applicationIdentity.getKeys());
        }
        this.gm.getApplicationHttpsSettings().readFrom(this.gu);
        this.gm.getApplicationHttpsSettings().setKeyPair(this.applicationIdentity.getHttpsCertificate(), new Cert[0]);
        this.gm.getApplicatioOpcTcpSettings().setConnectTimeout(this.connectTimeout);
        this.gm.getApplicatioOpcTcpSettings().setReverseHelloAcceptTimeout(this.connectTimeout);
        this.gm.getApplicatioOpcTcpSettings().setSocketFactory(this.hi);
    }

    private void cjh() throws InvalidServerEndpointException, ConnectException, ServiceException {
        if (this.cjd() == null) {
            throw new NullPointerException("Uri not defined.");
        }
        EndpointDescription[] endpointDescriptionArray = this.getEndpoints();
        this.gr = endpointDescriptionArray[endpointDescriptionArray.length - 1];
        if (!this.gr.getEndpointUrl().equals(this.cjd())) {
            logger.info("Using an alternate endpoint URL '{}' instead of the requested '{}'", (Object)this.gr.getEndpointUrl(), (Object)this.cjd());
        }
        logger.debug("initEndpoint: endpoint={}", (Object)this.gr);
    }

    private DataValue cji() {
        OperationLimits.Builder builder;
        Map<NodeId, DataValue> map;
        i i2;
        HashSet<NodeId> hashSet;
        try {
            hashSet = new HashSet<NodeId>();
            hashSet.add(VariableIdentifiers.Server_ServerCapabilities_OperationLimits_MaxNodesPerRead);
            i2 = this.getAddressSpace().a(hashSet, Attributes.Value, TimestampsToReturn.Both, false);
            map = i2.d(Attributes.Value);
            builder = this.getOperationLimits().toBuilder();
            builder.setMaxNodesPerRead(this.a(map, "Server/ServerCapabilities/OperationLimits/MaxNodesPerRead", VariableIdentifiers.Server_ServerCapabilities_OperationLimits_MaxNodesPerRead, UnsignedInteger.MAX_VALUE));
            this.gh = OperationLimits.min(this.getOperationLimits(), builder.build());
            logger.debug("MaxNodesPerRead OperationLimits: {}", (Object)this.gh.getMaxNodesPerRead());
        }
        catch (Exception exception) {
            this.gh = this.getOperationLimits();
            logger.warn("Could not read the MaxNodesPerRead OperationLimit, using default: {}", (Object)this.getActualOperationLimits().getMaxNodesPerRead(), (Object)exception);
        }
        try {
            hashSet = new HashSet();
            hashSet.add(VariableIdentifiers.Server_ServerCapabilities_OperationLimits_MaxMonitoredItemsPerCall);
            hashSet.add(VariableIdentifiers.Server_ServerCapabilities_OperationLimits_MaxNodesPerBrowse);
            hashSet.add(VariableIdentifiers.Server_ServerCapabilities_OperationLimits_MaxNodesPerHistoryReadData);
            hashSet.add(VariableIdentifiers.Server_ServerCapabilities_OperationLimits_MaxNodesPerHistoryReadEvents);
            hashSet.add(VariableIdentifiers.Server_ServerCapabilities_OperationLimits_MaxNodesPerHistoryUpdateData);
            hashSet.add(VariableIdentifiers.Server_ServerCapabilities_OperationLimits_MaxNodesPerHistoryUpdateEvents);
            hashSet.add(VariableIdentifiers.Server_ServerCapabilities_OperationLimits_MaxNodesPerMethodCall);
            hashSet.add(VariableIdentifiers.Server_ServerCapabilities_OperationLimits_MaxNodesPerNodeManagement);
            hashSet.add(VariableIdentifiers.Server_ServerCapabilities_OperationLimits_MaxNodesPerRegisterNodes);
            hashSet.add(VariableIdentifiers.Server_ServerCapabilities_OperationLimits_MaxNodesPerTranslateBrowsePathsToNodeIds);
            hashSet.add(VariableIdentifiers.Server_ServerCapabilities_OperationLimits_MaxNodesPerWrite);
            hashSet.add(Identifiers.Server_NamespaceArray);
            i2 = this.getAddressSpace().a(hashSet, Attributes.Value, TimestampsToReturn.Both, false);
            map = i2.d(Attributes.Value);
            builder = OperationLimits.builder();
            builder.setMaxNodesPerRead(this.getActualOperationLimits().getMaxNodesPerRead());
            builder.setMaxMonitoredItemsPerCall(this.a(map, "Server/ServerCapabilities/OperationLimits/MaxMonitoredItemsPerCall", VariableIdentifiers.Server_ServerCapabilities_OperationLimits_MaxMonitoredItemsPerCall, UnsignedInteger.MAX_VALUE));
            builder.setMaxNodesPerBrowse(this.a(map, "Server/ServerCapabilities/OperationLimits/MaxNodesPerBrowse", VariableIdentifiers.Server_ServerCapabilities_OperationLimits_MaxNodesPerBrowse, UnsignedInteger.MAX_VALUE));
            builder.setMaxNodesPerHistoryReadData(this.a(map, "Server/ServerCapabilities/OperationLimits/MaxNodesPerHistoryReadData", VariableIdentifiers.Server_ServerCapabilities_OperationLimits_MaxNodesPerHistoryReadData, UnsignedInteger.MAX_VALUE));
            builder.setMaxNodesPerHistoryReadEvents(this.a(map, "Server/ServerCapabilities/OperationLimits/MaxNodesPerHistoryReadEvents", VariableIdentifiers.Server_ServerCapabilities_OperationLimits_MaxNodesPerHistoryReadEvents, UnsignedInteger.MAX_VALUE));
            builder.setMaxNodesPerHistoryUpdateData(this.a(map, "Server/ServerCapabilities/OperationLimits/MaxNodesPerHistoryUpdateData", VariableIdentifiers.Server_ServerCapabilities_OperationLimits_MaxNodesPerHistoryUpdateData, UnsignedInteger.MAX_VALUE));
            builder.setMaxNodesPerHistoryUpdateEvents(this.a(map, "Server/ServerCapabilities/OperationLimits/MaxNodesPerHistoryUpdateEvents", VariableIdentifiers.Server_ServerCapabilities_OperationLimits_MaxNodesPerHistoryUpdateEvents, UnsignedInteger.MAX_VALUE));
            builder.setMaxNodesPerMethodCall(this.a(map, "Server/ServerCapabilities/OperationLimits/MaxNodesPerMethodCall", VariableIdentifiers.Server_ServerCapabilities_OperationLimits_MaxNodesPerMethodCall, UnsignedInteger.MAX_VALUE));
            builder.setMaxNodesPerNodeManagement(this.a(map, "Server/ServerCapabilities/OperationLimits/MaxNodesPerNodeManagement", VariableIdentifiers.Server_ServerCapabilities_OperationLimits_MaxNodesPerNodeManagement, UnsignedInteger.MAX_VALUE));
            builder.setMaxNodesPerRegisterNodes(this.a(map, "Server/ServerCapabilities/OperationLimits/MaxNodesPerRegisterNodes", VariableIdentifiers.Server_ServerCapabilities_OperationLimits_MaxNodesPerRegisterNodes, UnsignedInteger.MAX_VALUE));
            builder.setMaxNodesPerTranslateBrowsePathsToNodeIds(this.a(map, "Server/ServerCapabilities/OperationLimits/MaxNodesPerTranslateBrowsePathsToNodeIds", VariableIdentifiers.Server_ServerCapabilities_OperationLimits_MaxNodesPerTranslateBrowsePathsToNodeIds, UnsignedInteger.MAX_VALUE));
            builder.setMaxNodesPerWrite(this.a(map, "Server/ServerCapabilities/OperationLimits/MaxNodesPerWrite", VariableIdentifiers.Server_ServerCapabilities_OperationLimits_MaxNodesPerWrite, UnsignedInteger.MAX_VALUE));
            OperationLimits operationLimits = builder.build();
            OperationLimits operationLimits2 = this.getOperationLimits();
            this.gh = OperationLimits.min(operationLimits, operationLimits2);
            logger.debug("Initialized OperationLimits to: {}, client side limits were: {} and serverside limits were: {}", new Object[]{this.gh, operationLimits2, operationLimits});
            logger.info("Using {}", (Object)this.gh);
            return map.get(Identifiers.Server_NamespaceArray);
        }
        catch (NullPointerException nullPointerException) {
            logger.info("Server doesn't support OperationLimits nodes or gives Null values, using client defaults: {}", (Object)this.getOperationLimits(), (Object)nullPointerException);
            this.gh = this.getOperationLimits();
            return null;
        }
        catch (Exception exception) {
            this.gh = this.getOperationLimits();
            logger.info("Failed to init OperationLimits from the server, using client defaults: {}", (Object)this.getOperationLimits(), (Object)exception);
            return null;
        }
    }

    private void cjj() throws ServiceException {
        StatusCode statusCode;
        if (this.gr == null) {
            throw new IllegalStateException("Endpoint should not be null");
        }
        if (this.gr.getServerCertificate() == null && !this.gL.getMessageSecurityMode().equals(MessageSecurityMode.None)) {
            throw new ServiceException("Missing server certificate", StatusCodes.Bad_CertificateInvalid);
        }
        Cert cert = null;
        if (this.gr.getServerCertificate() != null && this.gr.getServerCertificate().getLength() != 0) {
            try {
                cert = new Cert(this.gr.getServerCertificate().getValue());
            }
            catch (ServiceResultException serviceResultException) {
                throw new ServiceException(serviceResultException);
            }
        }
        this.gM = new ApplicationIdentity(cert, null);
        this.gM.setApplicationDescription(this.gr.getServer(), false);
        if (!this.gL.getMessageSecurityMode().equals(MessageSecurityMode.None) && (statusCode = this.validateApplicationCertificate(this.gM)).isBad()) {
            throw new ServiceException("Invalid server certificate", statusCode);
        }
    }

    private void cjk() {
        if (this.hg) {
            try {
                this.hc.init();
            }
            catch (TypeDictionaryException typeDictionaryException) {
                logger.warn("Could not init TypeDictionary, decoding custom Structures might not work", (Throwable)typeDictionaryException);
            }
        }
        if (this.hh) {
            this.getEncoderContext().setDynamicDataTypeSpecificationProvider(uaNodeId -> {
                logger.debug("Trying to resolve id {} DataTypeSpecification", uaNodeId);
                UaDataTypeSpecification uaDataTypeSpecification = this.hc.getDataTypeSpecification((UaNodeId)uaNodeId);
                if (uaDataTypeSpecification == null) {
                    logger.debug("Could not resolve id {} DataTypeSpecification", uaNodeId);
                } else {
                    logger.debug("Resolved id {} DataTypeSpecification to: {}", uaNodeId, (Object)uaDataTypeSpecification);
                }
                return uaDataTypeSpecification;
            });
        }
    }

    private boolean cjl() {
        return this.ciZ().isEmpty() || this.ciZ().toLowerCase(Locale.ROOT).equals("localhost");
    }

    private UnsignedInteger cjm() {
        long l2 = 0L;
        while (l2 == 0L) {
            long l3 = this.gx.incrementAndGet();
            l2 = l3 & 0xFFFFFFFFL;
        }
        return UnsignedInteger.valueOf(l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cjn() {
        if (this.isConnected() && this.gI != null) {
            UaClient uaClient = this;
            synchronized (uaClient) {
                this.notify();
            }
        }
    }

    private DataValue g(Object object) {
        DataValue dataValue;
        if (object instanceof DataValue) {
            dataValue = (DataValue)object;
        } else {
            Variant variant = this.h(object);
            dataValue = new DataValue(variant, StatusCode.GOOD);
        }
        return dataValue;
    }

    private Variant h(Object object) {
        Variant variant = object instanceof Variant ? (Variant)object : new Variant(object);
        return variant;
    }

    private BuildInfo cjo() throws ServiceException {
        NodeId[] nodeIdArray = new NodeId[]{Identifiers.Server_ServerStatus_BuildInfo_ProductUri, Identifiers.Server_ServerStatus_BuildInfo_ManufacturerName, Identifiers.Server_ServerStatus_BuildInfo_ProductName, Identifiers.Server_ServerStatus_BuildInfo_SoftwareVersion, Identifiers.Server_ServerStatus_BuildInfo_BuildNumber, Identifiers.Server_ServerStatus_BuildInfo_BuildDate};
        DataValue[] dataValueArray = this.readValues(nodeIdArray, TimestampsToReturn.Neither);
        BuildInfo buildInfo = new BuildInfo(dataValueArray[0].getValue().asClass(String.class, null), dataValueArray[1].getValue().asClass(String.class, null), dataValueArray[2].getValue().asClass(String.class, null), dataValueArray[3].getValue().asClass(String.class, null), dataValueArray[4].getValue().asClass(String.class, null), dataValueArray[5].getValue().asClass(DateTime.class, null));
        return buildInfo;
    }

    private AsyncResult<i> a(boolean bl, final Map<NodeId, Set<UnsignedInteger>> map, final TimestampsToReturn timestampsToReturn) {
        if (!bl) {
            final AsyncResultImpl<i> asyncResultImpl = new AsyncResultImpl<i>();
            StackUtils.getBlockingWorkExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        asyncResultImpl.setResult(UaClient.this.b(false, map, timestampsToReturn));
                    }
                    catch (ServiceException serviceException) {
                        asyncResultImpl.setError(new ServiceResultException(serviceException.getServiceResult(), (Throwable)serviceException));
                    }
                }
            });
            return asyncResultImpl;
        }
        int n2 = this.getActualOperationLimits().getMaxNodesPerRead().intValue();
        Set<h> set = h.a(map, timestampsToReturn).b(n2);
        final HashSet<AsyncResult<i>> hashSet = new HashSet<AsyncResult<i>>();
        for (h h2 : set) {
            hashSet.add(this.a(false, h2.ciH(), h2.getTimestampsToReturn()));
        }
        final AsyncResultImpl asyncResultImpl = new AsyncResultImpl();
        StackUtils.getBlockingWorkExecutor().execute(new Runnable(){

            @Override
            public void run() {
                HashSet<i> hashSet2 = new HashSet<i>();
                for (AsyncResult asyncResult : hashSet) {
                    try {
                        hashSet2.add((i)asyncResult.waitForResult());
                    }
                    catch (ServiceResultException serviceResultException) {
                        asyncResultImpl.setError(serviceResultException);
                        break;
                    }
                }
                asyncResultImpl.setResult(i.c(hashSet2));
            }
        });
        return asyncResultImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cjp() throws ServiceException {
        NodeId[] nodeIdArray = new NodeId[]{Identifiers.Server_ServerStatus_StartTime, Identifiers.Server_ServerStatus_CurrentTime, Identifiers.Server_ServerStatus_State, Identifiers.Server_ServerStatus_SecondsTillShutdown, Identifiers.Server_ServerStatus_ShutdownReason, Identifiers.Server_ServerStatus_BuildInfo};
        DataValue[] dataValueArray = this.readValues(nodeIdArray, TimestampsToReturn.Neither);
        DateTime dateTime = null;
        DateTime dateTime2 = null;
        ServerState serverState = null;
        BuildInfo buildInfo = null;
        UnsignedInteger unsignedInteger = null;
        LocalizedText localizedText = null;
        try {
            dateTime = dataValueArray[0].getValue().asClass(DateTime.class, null);
            dateTime2 = dataValueArray[1].getValue().asClass(DateTime.class, null);
            serverState = dataValueArray[2].getValue().asClass(ServerState.class, null);
            if (serverState == null) {
                serverState = ServerState.valueOf(((Number)dataValueArray[2].getValue().asClass(Number.class, ServerState.Unknown.getValue())).intValue());
            }
            if ((unsignedInteger = (UnsignedInteger)dataValueArray[3].getValue().asClass(UnsignedInteger.class, null)) == null) {
                Number number = dataValueArray[3].getValue().asClass(Number.class, 0);
                unsignedInteger = UnsignedInteger.valueOf(number.intValue());
            }
            if ((localizedText = (LocalizedText)dataValueArray[4].getValue().asClass(LocalizedText.class, null)) == null) {
                localizedText = new LocalizedText((String)dataValueArray[4].getValue().asClass(String.class, null), Locale.getDefault());
            }
            if ((buildInfo = (BuildInfo)dataValueArray[5].getValue().asClass(BuildInfo.class, null)) == null) {
                buildInfo = this.cjo();
            }
            this.a(new ServerStatusDataType(dateTime, dateTime2, serverState, buildInfo, unsignedInteger, localizedText), StatusCode.GOOD);
            this.gP.set(true);
        }
        catch (Exception exception) {
            logger.debug("Failure in readServerStatusElements", (Throwable)exception);
        }
        finally {
            this.a(new ServerStatusDataType(dateTime, dateTime2, serverState, buildInfo, unsignedInteger, localizedText), StatusCode.GOOD);
            this.gP.set(true);
        }
    }

    private synchronized void b(DataValue dataValue) throws ServiceException, StatusException {
        String[] stringArray = this.getEncoderContext().getNamespaceTable().toArray();
        DataValue dataValue2 = dataValue != null ? dataValue : this.readValue(Identifiers.Server_NamespaceArray);
        this.getEncoderContext().setNamespaceTable(NamespaceTable.createFromArray((String[])dataValue2.getValue().getValue()));
        this.gC = true;
        String[] stringArray2 = this.getEncoderContext().getNamespaceTable().toArray();
        if (stringArray2.length < stringArray.length) {
            logger.warn("refreshNamespaceTable, the old NamespaceArray: {} is not a subset of new NamespaceArray: {}, older NamespaceIndexes are obsolete", (Object)stringArray, (Object)stringArray2);
        } else {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (Objects.equals(stringArray[i2], stringArray2[i2])) continue;
                logger.warn("refreshNamespaceTable, the old NamespaceArray: {} is not a subset of new NamespaceArray: {}, older NamespaceIndexes are obsolete", (Object)stringArray, (Object)stringArray2);
                break;
            }
        }
        logger.debug("refreshNamespaceTable, old: {}, new: {}", (Object)stringArray, (Object)stringArray2);
    }

    private void cjq() throws ServiceException, StatusException {
        DataValue dataValue = this.readValue(Identifiers.Server_ServerArray);
        this.getEncoderContext().setServerTable(ServerTable.createFromArray((String[])dataValue.getValue().getValue()));
        this.gQ = true;
    }

    private void cjr() {
        for (Subscription subscription : this.hd) {
            try {
                subscription.republishAllAvailable();
            }
            catch (ServiceException serviceException) {
                logger.info("Subscription ID={} no longer valid (), recreating", (Object)subscription.getSubscriptionId(), (Object)serviceException.getServiceResult());
                subscription.reset();
            }
        }
    }

    private EndpointDescription[] a(EndpointDescription[] endpointDescriptionArray, String string) {
        return EndpointUtil.select(endpointDescriptionArray, string, this.cja().toString(), this.gL.getMessageSecurityMode(), this.gL.getSecurityPolicy(), null);
    }

    private void a(SessionChannel sessionChannel) {
        if (sessionChannel != null && Thread.currentThread().isInterrupted()) {
            sessionChannel.closeAsync();
            logger.debug("Closing SessionChannel due to Thread interruption");
            return;
        }
        SessionChannel sessionChannel2 = this.gl.getAndSet(sessionChannel);
        if (sessionChannel2 != null) {
            sessionChannel2.setRequestValidator(null);
        }
        if (sessionChannel != null) {
            sessionChannel.setRequestValidator(this.gz);
        }
    }

    private void a(ServerStatusDataType serverStatusDataType, StatusCode statusCode) {
        if (Thread.currentThread().isInterrupted()) {
            logger.trace("The current thread isInterruped() is true, skipping setting server status");
            return;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("setServerStatusAndError: Status=" + (serverStatusDataType == null ? "null" : serverStatusDataType.getState()) + " Code=" + statusCode);
        }
        this.gN.set(new e(serverStatusDataType, statusCode));
    }

    private void a(ServerStatusDataType serverStatusDataType, UnsignedInteger unsignedInteger) {
        this.a(serverStatusDataType, StatusCode.valueOf(unsignedInteger));
    }

    private NodeId toNodeId(ExpandedNodeId expandedNodeId) throws StatusException {
        NodeId nodeId = null;
        try {
            nodeId = this.getNamespaceTable().toNodeId(expandedNodeId);
        }
        catch (ServiceResultException serviceResultException) {
            throw new StatusException(serviceResultException);
        }
        return nodeId;
    }

    private NodeId[] a(ExpandedNodeId[] expandedNodeIdArray) throws StatusException {
        NodeId[] nodeIdArray = new NodeId[expandedNodeIdArray.length];
        for (int i2 = 0; i2 < expandedNodeIdArray.length; ++i2) {
            nodeIdArray[i2] = this.toNodeId(expandedNodeIdArray[i2]);
        }
        return nodeIdArray;
    }

    private TransferResult[] cjs() throws ServiceException {
        if (logger.isDebugEnabled()) {
            logger.debug("transferSubscriptions: subscriptions.size()={}", (Object)this.hd.size());
        }
        if (this.hd.size() > 0) {
            TransferSubscriptionsResponse transferSubscriptionsResponse;
            ArrayList<Subscription> arrayList = new ArrayList<Subscription>();
            ArrayList<UnsignedInteger> arrayList2 = new ArrayList<UnsignedInteger>();
            for (Subscription transferResultArray2 : this.hd) {
                UnsignedInteger unsignedInteger = transferResultArray2.getSubscriptionId();
                if (unsignedInteger == null || UnsignedInteger.ZERO.equals(unsignedInteger)) continue;
                arrayList.add(transferResultArray2);
                arrayList2.add(unsignedInteger);
            }
            if (arrayList.isEmpty()) {
                return new TransferResult[0];
            }
            try {
                transferSubscriptionsResponse = this.ciq().TransferSubscriptions(this.getRequestHeader(), arrayList2.toArray(new UnsignedInteger[0]), true);
            }
            catch (ServiceFaultException serviceFaultException) {
                throw new ServiceException(serviceFaultException);
            }
            catch (ServiceResultException serviceResultException) {
                throw new ServiceException(serviceResultException);
            }
            this.checkServiceResult(transferSubscriptionsResponse, transferSubscriptionsResponse.getDiagnosticInfos());
            TransferResult[] transferResultArray = transferSubscriptionsResponse.getResults();
            this.a(transferResultArray, arrayList);
            return transferResultArray;
        }
        return new TransferResult[0];
    }

    private void cjt() {
        int n2 = 0;
        for (UaApplication.DiagnosticMask diagnosticMask : this.gD) {
            n2 += diagnosticMask.getValue();
        }
        n2 <<= 5;
        for (UaApplication.DiagnosticMask diagnosticMask : this.gS) {
            n2 += diagnosticMask.getValue();
        }
        this.gn = UnsignedInteger.valueOf(n2);
    }

    protected void addSubscriptionAck(SubscriptionAcknowledgement subscriptionAcknowledgement) {
        this.gg.add(subscriptionAcknowledgement);
    }

    protected HttpsSecurityPolicy[] getHttpsSecurityPolicies() {
        return this.getHttpsSettings().getHttpsSecurityPolicies();
    }

    protected void resetPublishRequestSetpoint() {
        this.gF.set(0);
    }

    protected void resetSubscriptionsAfterRemove(Subscription[] subscriptionArray, StatusCode[] statusCodeArray) {
        for (int i2 = 0; i2 < subscriptionArray.length; ++i2) {
            if (subscriptionArray[i2].getClient() == this) {
                subscriptionArray[i2].reset();
            }
            boolean bl = this.hd.remove(subscriptionArray[i2]);
            if (statusCodeArray[i2] != null) continue;
            statusCodeArray[i2] = bl ? StatusCode.GOOD : StatusCode.valueOf(StatusCodes.Good_NoData);
        }
    }

    protected UaAddress resolveConnectionAddress(UaAddress uaAddress, EndpointDescription endpointDescription) {
        try {
            UaAddress uaAddress2 = UaAddress.parse(endpointDescription.getEndpointUrl());
            String string = uaAddress2.getServerName() == null ? "" : uaAddress2.getServerName();
            return UaAddress.fromComponents(uaAddress.getProtocol(), uaAddress.getHost(), uaAddress.getPort(), string);
        }
        catch (Exception exception) {
            logger.warn("Could not use ServerName component part from EndpointDescription: " + endpointDescription, (Throwable)exception);
            return uaAddress;
        }
    }

    protected void setHttpsSecurityPolicies(HttpsSecurityPolicy[] httpsSecurityPolicyArray) {
        this.getHttpsSettings().setHttpsSecurityPolicies(httpsSecurityPolicyArray);
    }

    protected <T extends ServiceResponse> void validateServiceRequest(ServiceRequest<T> serviceRequest) throws ServiceResultException {
    }

    void checkOperationResult(StatusCode statusCode) throws StatusException {
        if (statusCode.isBad()) {
            DiagnosticInfo[] diagnosticInfoArray = this.gw.get();
            if (diagnosticInfoArray == null || diagnosticInfoArray.length == 0) {
                throw new StatusException(statusCode);
            }
            throw new StatusException(statusCode, diagnosticInfoArray[0]);
        }
    }

    void a(Object[] objectArray, Object[] objectArray2) throws ServiceException {
        if (objectArray == null) {
            throw new ServiceException("Results == null");
        }
        if (objectArray.length != objectArray2.length) {
            throw new ServiceException("Size of results differs from requested");
        }
    }

    void checkServiceResult(ServiceResponse serviceResponse, DiagnosticInfo[] diagnosticInfoArray) throws ServiceException {
        ResponseHeader responseHeader = serviceResponse.getResponseHeader();
        this.gy.set(responseHeader);
        this.gw.set(diagnosticInfoArray);
        if (responseHeader.getServiceResult().isBad()) {
            throw new ServiceException(responseHeader.getServiceResult(), responseHeader.getServiceDiagnostics());
        }
    }

    SessionChannel ciq() throws ServerConnectionException {
        logger.trace("getChannel");
        return Optional.ofNullable(this.gl.get()).orElseThrow(() -> new ServerConnectionException("Server not connected", this.cjd(), this.gL));
    }

    UnsignedInteger cju() {
        return this.gn;
    }

    NamespaceTable a(boolean bl, DataValue dataValue) throws ServiceException, StatusException {
        if (!this.gC || bl) {
            this.b(dataValue);
        }
        return this.getNamespaceTable();
    }

    RequestHeader getRequestHeader() {
        return this.a(this.gn, this.gZ, this.gj);
    }

    void cjv() {
        this.registerModel(ClientInformationModel.MODEL);
        this.registerModel(GdsClientInformationModel.MODEL);
        if (this.isAutoDiscoverCodegenModels()) {
            this.registerAutoDiscoveredModels(ClientCodegenModelProvider.class);
        }
    }

    SubscriptionBase a(SubscriptionBase subscriptionBase) throws ServiceException, ServerConnectionException {
        logger.debug("modifySubscription: isConnected={}", (Object)this.isConnected());
        if (this.isConnected()) {
            ModifySubscriptionResponse modifySubscriptionResponse;
            try {
                logger.debug("modifySubscription: subscription={}", (Object)subscriptionBase);
                modifySubscriptionResponse = this.ciq().ModifySubscription(this.getRequestHeader(), subscriptionBase.getSubscriptionId(), subscriptionBase.getPublishingInterval(), UnsignedInteger.valueOf(subscriptionBase.getLifetimeCount()), UnsignedInteger.valueOf(subscriptionBase.getMaxKeepAliveCount()), UnsignedInteger.valueOf(subscriptionBase.getMaxNotificationsPerPublish()), UnsignedByte.valueOf(subscriptionBase.getPriority()));
                logger.debug("modifySubscription: response={}", (Object)modifySubscriptionResponse.getResponseHeader().getServiceResult());
            }
            catch (ServiceFaultException serviceFaultException) {
                logger.debug("modifySubscription: exception={}", (Throwable)serviceFaultException);
                throw new ServiceException(serviceFaultException);
            }
            catch (ServiceResultException serviceResultException) {
                logger.debug("modifySubscription: exception={}", (Throwable)serviceResultException);
                throw new ServiceException(serviceResultException);
            }
            this.checkServiceResult(modifySubscriptionResponse, null);
            subscriptionBase.setPublishingInterval(modifySubscriptionResponse.getRevisedPublishingInterval());
            subscriptionBase.setLifetimeCount(modifySubscriptionResponse.getRevisedLifetimeCount());
            subscriptionBase.setMaxKeepAliveCount(modifySubscriptionResponse.getRevisedMaxKeepAliveCount());
        }
        return subscriptionBase;
    }

    i b(boolean bl, Map<NodeId, Set<UnsignedInteger>> map, TimestampsToReturn timestampsToReturn) throws ServiceException {
        Object object;
        int n2;
        DataValue[] dataValueArray;
        if (bl) {
            try {
                return this.a(true, map, timestampsToReturn).waitForResult();
            }
            catch (ServiceResultException serviceResultException) {
                if (serviceResultException.getCause() instanceof ServiceException) {
                    throw (ServiceException)serviceResultException.getCause();
                }
                throw new ServiceException("Could not Read", serviceResultException);
            }
        }
        Double d2 = 0.0;
        ArrayList<ReadValueId> arrayList = new ArrayList<ReadValueId>();
        HashMap hashMap = new HashMap();
        for (Map.Entry<NodeId, Set<UnsignedInteger>> entry : map.entrySet()) {
            hashMap.put(entry.getKey(), new HashMap());
            for (UnsignedInteger unsignedInteger : entry.getValue()) {
                arrayList.add(new ReadValueId(entry.getKey(), unsignedInteger, null, null));
            }
        }
        ReadValueId[] readValueIdArray2 = arrayList.toArray(new ReadValueId[0]);
        int n3 = 0;
        if (readValueIdArray2.length > 1 && this.getActualOperationLimits() != null) {
            try {
                n3 = this.getActualOperationLimits().getMaxNodesPerRead().intValue();
            }
            catch (Exception exception) {
                logger.debug("read: Failed to get operationLimits.MaxNodesPerRead: ", (Throwable)exception);
            }
        }
        int n4 = 0;
        if (n3 > 0 && n3 < readValueIdArray2.length) {
            dataValueArray = new DataValue[readValueIdArray2.length];
            for (n2 = 0; n2 < readValueIdArray2.length; n2 += n3) {
                int n5 = Math.min(n3, readValueIdArray2.length - n2);
                ReadValueId[] readValueIdArray3 = Arrays.copyOfRange(readValueIdArray2, n2, n2 + n5);
                object = this.a(d2, timestampsToReturn, readValueIdArray3);
                ++n4;
                for (int i2 = 0; i2 < n5; ++i2) {
                    dataValueArray[n2 + i2] = ((ReadResponse)object).getResults()[i2];
                }
            }
        } else {
            ReadResponse readResponse = this.a(d2, timestampsToReturn, readValueIdArray2);
            ++n4;
            dataValueArray = readResponse.getResults();
        }
        for (n2 = 0; n2 < dataValueArray.length; ++n2) {
            DataValue dataValue = dataValueArray[n2];
            NodeId nodeId = ((ReadValueId)arrayList.get(n2)).getNodeId();
            object = ((ReadValueId)arrayList.get(n2)).getAttributeId();
            ((Map)hashMap.get(nodeId)).put(object, dataValue);
        }
        HashMap hashMap2 = new HashMap();
        for (Map.Entry entry : hashMap.entrySet()) {
            hashMap2.put(entry.getKey(), Collections.unmodifiableMap((Map)entry.getValue()));
        }
        return i.b(Collections.unmodifiableMap(hashMap2), n4);
    }

    void g(UnsignedInteger unsignedInteger) {
        this.gn = unsignedInteger;
    }

    void b(SubscriptionBase subscriptionBase) throws ServiceException, StatusException {
        if (this.isConnected()) {
            SetPublishingModeResponse setPublishingModeResponse;
            try {
                setPublishingModeResponse = this.ciq().SetPublishingMode(this.getRequestHeader(), subscriptionBase.isPublishingEnabled(), subscriptionBase.getSubscriptionId());
            }
            catch (ServiceFaultException serviceFaultException) {
                throw new ServiceException(serviceFaultException);
            }
            catch (ServiceResultException serviceResultException) {
                throw new ServiceException(serviceResultException);
            }
            this.checkServiceResult(setPublishingModeResponse, setPublishingModeResponse.getDiagnosticInfos());
            this.checkOperationResult(setPublishingModeResponse.getResults()[0]);
        }
    }

    synchronized void startPublishing() {
        logger.debug("startPublishing");
        if (this.gI == null) {
            this.gH = new f(this);
            this.gI = new Thread(this.gH);
            this.gI.setName("PublishTask-" + this.toString());
            this.gI.start();
        }
        if (this.gJ == null) {
            // empty if block
        }
    }

    synchronized void stopPublishing() {
        Thread thread = null;
        if (this.gI != null) {
            thread = this.gI;
            logger.debug("stopPublishing: interrupting publishThread");
            this.notify();
            this.gH.terminate();
            this.gI.interrupt();
            this.gH = null;
            this.gI = null;
        }
        if (this.gJ != null) {
            logger.debug("canceling publishTimer");
            this.gJ.cancel();
            this.gJ = null;
        }
        if (thread != null) {
            try {
                long l2 = System.currentTimeMillis();
                thread.join(60000L);
                long l3 = System.currentTimeMillis();
                if (l3 - l2 > 55000L) {
                    logger.warn("Potential internal error, PublishTask Thread join 60s wait elapsed");
                }
            }
            catch (InterruptedException interruptedException) {
                logger.debug("Interrupted while waiting for PublishTask Thread join");
            }
        }
    }

    static {
        gf = new HashMap();
        UaClient.a(Attributes.AccessLevel, UnsignedByte.class);
        UaClient.a(Attributes.ArrayDimensions, UnsignedInteger[].class);
        UaClient.a(Attributes.BrowseName, QualifiedName.class);
        UaClient.a(Attributes.ContainsNoLoops, Boolean.class);
        UaClient.a(Attributes.DataType, NodeId.class);
        UaClient.a(Attributes.Description, LocalizedText.class);
        UaClient.a(Attributes.DisplayName, LocalizedText.class);
        UaClient.a(Attributes.EventNotifier, UnsignedByte.class);
        UaClient.a(Attributes.Executable, Boolean.class);
        UaClient.a(Attributes.Historizing, Boolean.class);
        UaClient.a(Attributes.InverseName, LocalizedText.class);
        UaClient.a(Attributes.IsAbstract, Boolean.class);
        UaClient.a(Attributes.MinimumSamplingInterval, Double.class);
        UaClient.a(Attributes.NodeClass, Integer.class);
        UaClient.a(Attributes.NodeId, NodeId.class);
        UaClient.a(Attributes.Symmetric, Boolean.class);
        UaClient.a(Attributes.UserAccessLevel, UnsignedByte.class);
        UaClient.a(Attributes.UserExecutable, Boolean.class);
        UaClient.a(Attributes.UserWriteMask, UnsignedInteger.class);
        UaClient.a(Attributes.ValueRank, Integer.class);
        UaClient.a(Attributes.WriteMask, UnsignedInteger.class);
        gd = new HashSet<StatusCode>(Arrays.asList(StatusCode.valueOf(StatusCodes.Bad_ServerNotConnected), StatusCode.valueOf(StatusCodes.Bad_Timeout), StatusCode.valueOf(StatusCodes.Bad_SessionClosed), StatusCode.valueOf(StatusCodes.Bad_SecureChannelIdInvalid), StatusCode.valueOf(StatusCodes.Bad_SecureChannelClosed), StatusCode.valueOf(StatusCodes.Bad_SessionIdInvalid), StatusCode.valueOf(StatusCodes.Bad_SessionNotActivated)));
        ge = false;
    }

    static class f
    implements ResultListener<PublishResponse>,
    Runnable {
        private long hv;
        private final Logger logger = LoggerFactory.getLogger(f.class);
        private final AtomicInteger hw = new AtomicInteger(0);
        private volatile boolean hx = false;
        private final AtomicInteger hy = new AtomicInteger(0);
        private final UaClient em;

        f(UaClient uaClient) {
            this.em = uaClient;
        }

        public void b(PublishResponse publishResponse) {
            this.logger.debug("onCompleted entering");
            int n2 = this.hw.decrementAndGet();
            this.logger.debug("onCompleted publishRequestCount decremented, is={}", (Object)n2);
            try {
                PublishResponse publishResponse2 = publishResponse;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("onCompleted: ServiceResult={} Results={}", (Object)publishResponse2.getResponseHeader().getServiceResult(), (Object)Arrays.toString(publishResponse2.getResults()));
                }
                if (this.em.a(publishResponse2)) {
                    this.cjG();
                }
            }
            catch (ServiceException serviceException) {
                this.a(serviceException, serviceException.getServiceResult().getValue());
            }
            catch (Exception exception) {
                this.logger.error("Failed to handle a complete publish message", (Throwable)exception);
            }
        }

        @Override
        public void onError(ServiceResultException serviceResultException) {
            this.logger.debug("onError entering");
            int n2 = this.hw.decrementAndGet();
            this.logger.debug("onError publishRequestCount decremented, is: {}", (Object)n2);
            this.a(serviceResultException, serviceResultException.getStatusCode().getValue());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.logger.debug("run");
            while (!this.hx) {
                this.cjA();
                this.cjE();
                this.cjB();
                if (!this.hx) {
                    this.cjy();
                }
                try {
                    this.logger.trace("sleep");
                    f f2 = this;
                    synchronized (f2) {
                        this.wait(100L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    this.logger.debug("interrupted");
                }
            }
            this.logger.debug("terminated");
        }

        public void terminate() {
            this.hx = true;
        }

        private void cjy() {
            this.logger.trace("checkServerStatus: statusCheckInterval={}", (Object)this.em.gX);
            if (this.em.gX > 0L) {
                StatusCode statusCode;
                boolean bl = this.em.cjc() != null;
                ServerState serverState = this.em.getServerState();
                boolean bl2 = serverState.equals(ServerState.CommunicationFault);
                if (bl2 && (statusCode = this.em.cjb()) != null) {
                    if (ge) {
                        UnsignedInteger unsignedInteger = statusCode.getValue();
                        bl2 = this.h(unsignedInteger);
                    } else {
                        bl2 = statusCode.isBad() || statusCode.isUncertain();
                    }
                }
                boolean bl3 = bl2 || serverState.equals(ServerState.Shutdown) && System.currentTimeMillis() > this.em.gW;
                boolean bl4 = System.currentTimeMillis() - this.hv > this.em.gX;
                this.logger.trace("checkServerStatus: hasStatus={} commError={} isConnected={} timeToCheck={} timeToReconnect={}, status={}", new Object[]{bl, bl2, this.em.isConnected(), bl4, bl3, this.em.cjb()});
                if (this.em.isAutoReconnect() && bl3) {
                    try {
                        this.em.reconnect();
                        bl4 = true;
                    }
                    catch (Exception exception) {
                        this.logger.debug("checkServerStatus: reconnect failed: ", (Throwable)exception);
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            this.logger.debug("Interrupted", (Throwable)interruptedException);
                            Thread.currentThread().interrupt();
                            return;
                        }
                    }
                }
                if (this.em.isConnected() && (!bl || bl4)) {
                    this.em.updateServerStatus();
                    this.hv = System.currentTimeMillis();
                    if (this.em.gt) {
                        this.em.a(false);
                    }
                    for (Subscription subscription : this.em.hd) {
                        subscription.recreateMonitoredItems();
                    }
                }
            }
        }

        private void cjz() {
            for (Subscription subscription : this.em.hd) {
                subscription.checkTimeout();
            }
        }

        private int cjA() {
            int n2 = this.em.gF.get();
            int n3 = this.hw.get();
            int n4 = this.hy.getAndSet(0);
            if (n4 > 0) {
                this.logger.debug("decrementPublishRequestSetpoint: sp={} currentCount={} tooManyPublishRequests={}", new Object[]{n2, n3, n4});
                n2 = n2 == 0 || n3 > 0 && n2 > n3 ? n3 : (n2 > n4 ? (n2 -= n4) : 1);
                this.logger.debug("decrementPublishRequestSetpoint: sp={}", (Object)n2);
                this.em.gF.set(n2);
            }
            return n2;
        }

        private void a(Exception exception, UnsignedInteger unsignedInteger) {
            if (StatusCodes.Bad_TooManyPublishRequests.equals(unsignedInteger)) {
                this.hy.incrementAndGet();
                this.logger.debug("Got Bad_TooManyPublishRequest from the server. Current requests={}, toomanys={}", (Object)this.hw.get(), (Object)this.hy.get());
            } else if (StatusCodes.Bad_NoSubscription.equals(unsignedInteger)) {
                if (this.cjD()) {
                    this.logger.info("Got Bad_NoSubscription as a PublishResponse, although we have connected Subscriptions");
                }
            } else if (this.h(unsignedInteger)) {
                this.logger.debug("onError: {}", (Object)exception.getMessage());
            } else {
                this.logger.warn("onError: ", (Throwable)exception);
            }
        }

        private void cjB() {
            for (Subscription subscription : this.em.hd) {
                try {
                    subscription.handleNotificationDatas();
                }
                catch (Exception exception) {
                    this.logger.error("handlePublishResponses", (Throwable)exception);
                }
            }
            this.cjz();
        }

        private boolean cjC() {
            boolean bl = false;
            for (Subscription subscription : this.em.getSubscriptions()) {
                UnsignedInteger unsignedInteger = subscription.getSubscriptionId();
                boolean bl2 = subscription.isConnected();
                boolean bl3 = subscription.isAlive();
                this.logger.trace("hasConnectedAliveSubscriptions: id:{}, connected:{}, alive:{}", new Object[]{unsignedInteger, bl2, bl3});
                if (!bl2 || !bl3) continue;
                bl = true;
                if (!this.logger.isTraceEnabled()) break;
            }
            return bl;
        }

        private boolean cjD() {
            boolean bl = false;
            for (Subscription subscription : this.em.getSubscriptions()) {
                UnsignedInteger unsignedInteger = subscription.getSubscriptionId();
                boolean bl2 = subscription.isConnected();
                boolean bl3 = subscription.isTimeout();
                this.logger.trace("hasConnectedNonTimeoutedSubscriptions: id:{}, connected:{}, timeout:{}", new Object[]{unsignedInteger, bl2, bl3});
                if (!bl2 || bl3) continue;
                bl = true;
                if (!this.logger.isTraceEnabled()) break;
            }
            return bl;
        }

        private boolean hasPublishResponses() {
            for (Subscription subscription : this.em.hd) {
                if (!subscription.hasPublishResponses()) continue;
                return true;
            }
            return false;
        }

        private boolean isActive() {
            ServerStatusDataType serverStatusDataType = null;
            try {
                serverStatusDataType = this.em.getServerStatus();
                this.logger.trace("isActive: status={}", (Object)serverStatusDataType);
                if (serverStatusDataType == null && this.em.gX == 0L) {
                    return true;
                }
                return serverStatusDataType != null && serverStatusDataType.getState().equals(ServerState.Running);
            }
            catch (ServerConnectionException serverConnectionException) {
                this.logger.trace("isActive: exception=", (Throwable)serverConnectionException);
                return false;
            }
            catch (StatusException statusException) {
                this.logger.trace("isActive: exception=", (Throwable)statusException);
                return false;
            }
        }

        private void cjE() {
            boolean bl = this.cjC();
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("queuePublishRequests: subscription count:{}, hasConnectedAliveSubscriptions:{}", (Object)this.em.hd.size(), (Object)bl);
            }
            if (bl) {
                for (int i2 = 0; i2 < 5 && this.cjG(); ++i2) {
                }
            }
        }

        private void cjF() {
            this.em.a(null);
        }

        private synchronized boolean cjG() {
            int n2 = this.hw.get();
            int n3 = this.em.getActualPublishRequestSetpoint();
            this.logger.trace("sendPublishRequest: requestCount={}, setPoint={}", (Object)n2, (Object)n3);
            if (this.isActive() && n2 < n3) {
                try {
                    SessionChannel sessionChannel = this.em.ciq();
                    if (sessionChannel == null || sessionChannel.getSecureChannel() == null) {
                        this.logger.debug("sendPublishRequest: channel/secureChannel=null");
                    } else {
                        this.logger.debug("sendPublishRequest: channel={} secureChannel.isOpen={}", (Object)sessionChannel, (Object)sessionChannel.getSecureChannel().isOpen());
                    }
                    if (sessionChannel != null) {
                        RequestHeader requestHeader = this.em.a(null, this.em.getPublishRequestTimeout(), null);
                        PublishRequest publishRequest = new PublishRequest(requestHeader, this.em.getSubscriptionAcknowledgements());
                        if (this.em.gA != null) {
                            this.em.gA.onBeforePublishRequest(this.em, publishRequest);
                        }
                        AsyncResult<PublishResponse> asyncResult = sessionChannel.PublishAsync(publishRequest);
                        asyncResult.setListener(this);
                        int n4 = this.hw.incrementAndGet();
                        this.logger.debug("sendPublishRequest, publishRequestCount: {}", (Object)n4);
                        return true;
                    }
                }
                catch (ServerConnectionException serverConnectionException) {
                    this.logger.debug("ServerConnectionException: ", (Throwable)serverConnectionException);
                }
            }
            return false;
        }

        protected boolean h(UnsignedInteger unsignedInteger) {
            return gd.contains(StatusCode.valueOf(unsignedInteger));
        }

        @Override
        public /* synthetic */ void onCompleted(Object object) {
            this.b((PublishResponse)object);
        }
    }

    private static class e {
        final ServerStatusDataType ht;
        final StatusCode hu;

        private e(ServerStatusDataType serverStatusDataType, StatusCode statusCode) {
            this.ht = serverStatusDataType;
            this.hu = statusCode;
        }
    }

    @FunctionalInterface
    private static interface d {
        public HistoryReadResult[] read(NodeId[] var1) throws ServiceException, DecodingException, EncodingException;
    }
}

