/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.client;

import com.prosysopc.ua.MethodCallStatusException;
import com.prosysopc.ua.MonitoredItemBase;
import com.prosysopc.ua.OperationLimits;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.SubscriptionBase;
import com.prosysopc.ua.client.MonitoredDataItem;
import com.prosysopc.ua.client.MonitoredEventItem;
import com.prosysopc.ua.client.MonitoredItem;
import com.prosysopc.ua.client.ServerConnectionException;
import com.prosysopc.ua.client.SubscriptionAliveListener;
import com.prosysopc.ua.client.SubscriptionNotificationListener;
import com.prosysopc.ua.client.UaClient;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.ExtensionObject;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.ServiceResponse;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.common.ServiceFaultException;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.CreateMonitoredItemsResponse;
import com.prosysopc.ua.stack.core.DataChangeNotification;
import com.prosysopc.ua.stack.core.DeleteMonitoredItemsResponse;
import com.prosysopc.ua.stack.core.EventFieldList;
import com.prosysopc.ua.stack.core.EventNotificationList;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.stack.core.ModifyMonitoredItemsResponse;
import com.prosysopc.ua.stack.core.MonitoredItemCreateRequest;
import com.prosysopc.ua.stack.core.MonitoredItemCreateResult;
import com.prosysopc.ua.stack.core.MonitoredItemModifyRequest;
import com.prosysopc.ua.stack.core.MonitoredItemModifyResult;
import com.prosysopc.ua.stack.core.MonitoredItemNotification;
import com.prosysopc.ua.stack.core.MonitoringFilterResult;
import com.prosysopc.ua.stack.core.MonitoringMode;
import com.prosysopc.ua.stack.core.MonitoringParameters;
import com.prosysopc.ua.stack.core.NotificationData;
import com.prosysopc.ua.stack.core.PublishResponse;
import com.prosysopc.ua.stack.core.ReadValueId;
import com.prosysopc.ua.stack.core.RepublishResponse;
import com.prosysopc.ua.stack.core.ResponseHeader;
import com.prosysopc.ua.stack.core.ServerState;
import com.prosysopc.ua.stack.core.SetMonitoringModeResponse;
import com.prosysopc.ua.stack.core.StatusChangeNotification;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.core.SubscriptionAcknowledgement;
import com.prosysopc.ua.stack.core.TimestampsToReturn;
import com.prosysopc.ua.stack.core.TransferSubscriptionsResponse;
import com.prosysopc.ua.stack.encoding.DecodingException;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.encoding.EncodingException;
import com.prosysopc.ua.stack.utils.AttributesUtil;
import com.prosysopc.ua.stack.utils.MultiDimensionArrayUtils;
import com.prosysopc.ua.stack.utils.NumericRange;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Subscription
extends SubscriptionBase {
    static final ExtensionObject[] fI = new ExtensionObject[0];
    private static final long fJ = UnsignedInteger.MAX_VALUE.longValue() / 2L;
    private static final Logger logger = LoggerFactory.getLogger(Subscription.class);
    private final List<SubscriptionAliveListener> fK = new CopyOnWriteArrayList<SubscriptionAliveListener>();
    private volatile UaClient em;
    private DiagnosticInfo cs;
    private volatile Instant fL;
    private DiagnosticInfo[] fM;
    private volatile UnsignedInteger fN = UnsignedInteger.ZERO;
    private ResponseHeader fO;
    private final AtomicReference<a> fP = new AtomicReference();
    private int fQ = -1;
    private int fR = 100;
    private final List<SubscriptionNotificationListener> fS = new CopyOnWriteArrayList<SubscriptionNotificationListener>();
    private final ConcurrentSkipListMap<UnsignedInteger, ExtensionObject[]> fT = new ConcurrentSkipListMap();
    private boolean fU = true;
    private StatusCode fV = StatusCode.GOOD;
    private volatile boolean fW;
    private volatile boolean fX = true;
    private double fY = 1.1;
    private double fZ = 1.3;
    private TimestampsToReturn fh = TimestampsToReturn.Source;
    private boolean ga = true;
    protected boolean modified;

    static void a(ConcurrentSkipListMap<UnsignedInteger, ExtensionObject[]> concurrentSkipListMap, UnsignedInteger unsignedInteger, ExtensionObject[] extensionObjectArray) {
        Object[] objectArray = concurrentSkipListMap.put(unsignedInteger, extensionObjectArray);
        if (objectArray != null && objectArray != fI) {
            if (extensionObjectArray == fI) {
                concurrentSkipListMap.put(unsignedInteger, (ExtensionObject[])objectArray);
                logger.debug("Ignoring a keepalive notification, since data has already been received for the sequence number: {}", (Object)unsignedInteger);
            } else if (!Arrays.deepEquals(extensionObjectArray, objectArray)) {
                logger.error("Received data again with the same sequence number: {}, but data doesn't match previous", (Object)unsignedInteger);
            } else {
                logger.warn("Received data again with the same sequence number: {}", (Object)unsignedInteger);
            }
        }
    }

    public Subscription() {
        this(true, 1000.0, 60L, 20L, 0L, 0);
    }

    public Subscription(Boolean bl, Double d2, long l2, long l3, long l4, int n2) {
        super(null, bl, d2, UnsignedInteger.valueOf(l2), UnsignedInteger.valueOf(l3), UnsignedInteger.valueOf(l4), UnsignedByte.valueOf(n2));
    }

    public Subscription(UnsignedInteger unsignedInteger, UnsignedInteger unsignedInteger2, UnsignedInteger unsignedInteger3, Double d2, Boolean bl, UnsignedByte unsignedByte) {
        super(null, bl, d2, unsignedInteger2, unsignedInteger3, unsignedInteger, unsignedByte);
    }

    public void addAliveListener(SubscriptionAliveListener subscriptionAliveListener) {
        if (!this.hasAliveListener(subscriptionAliveListener)) {
            this.fK.add(subscriptionAliveListener);
        }
    }

    public MonitoredItemCreateResult addItem(MonitoredItem monitoredItem) throws ServiceException, StatusException {
        this.addItem(monitoredItem, monitoredItem.getClientHandle());
        monitoredItem.a(this);
        try {
            CreateMonitoredItemsResponse createMonitoredItemsResponse = this.createMonitoredItems(monitoredItem);
            if (createMonitoredItemsResponse != null && createMonitoredItemsResponse.getResults() != null && createMonitoredItemsResponse.getResults().length >= 1) {
                if (createMonitoredItemsResponse.getResults().length > 1 && logger.isWarnEnabled()) {
                    logger.warn("Got more than one CreateMonitoredItemResponse for one added item: {}, results: {}", (Object)monitoredItem, (Object)MultiDimensionArrayUtils.toString(createMonitoredItemsResponse.getResults()));
                }
                this.em.checkOperationResult(createMonitoredItemsResponse.getResults()[0].getStatusCode());
                return createMonitoredItemsResponse.getResults()[0];
            }
        }
        catch (ServiceException serviceException) {
            throw serviceException;
        }
        catch (StatusException statusException) {
            throw statusException;
        }
        return null;
    }

    public MonitoredItemCreateResult[] addItems(MonitoredItem ... monitoredItemArray) throws ServiceException {
        for (int i2 = 0; i2 < monitoredItemArray.length; ++i2) {
            this.addItem(monitoredItemArray[i2], monitoredItemArray[i2].getClientHandle());
            monitoredItemArray[i2].a(this);
        }
        CreateMonitoredItemsResponse createMonitoredItemsResponse = this.createMonitoredItems(monitoredItemArray);
        if (createMonitoredItemsResponse != null) {
            return createMonitoredItemsResponse.getResults();
        }
        return null;
    }

    public void addNotificationListener(SubscriptionNotificationListener subscriptionNotificationListener) {
        if (!this.hasNotificationListener(subscriptionNotificationListener)) {
            this.fS.add(subscriptionNotificationListener);
        }
    }

    public void conditionRefresh() throws MethodCallStatusException, ServiceException {
        this.em.call(Identifiers.Server, Identifiers.ConditionType_ConditionRefresh, new Variant(this.getSubscriptionId()));
    }

    public double getAliveDetectionFactor() {
        return this.fY;
    }

    public SubscriptionAliveListener[] getAliveListeners() {
        return this.fK.toArray(new SubscriptionAliveListener[this.fK.size()]);
    }

    public UnsignedInteger[] getAvailableSequenceNumbers() {
        List<UnsignedInteger> list = this.getAvailableSequenceNumbersList();
        return list.toArray(new UnsignedInteger[list.size()]);
    }

    public UaClient getClient() {
        return this.em;
    }

    public DiagnosticInfo getDiagnosticInfo() {
        return this.cs;
    }

    @Override
    public MonitoredItem getItem(NodeId nodeId, UnsignedInteger unsignedInteger) {
        return (MonitoredItem)super.getItem(nodeId, unsignedInteger);
    }

    public Instant getLastAlive() {
        return this.fL;
    }

    public DiagnosticInfo[] getLastOperationDiagnostics() {
        return this.fM;
    }

    public UnsignedInteger getLastSequenceNumber() {
        return this.fN;
    }

    public DiagnosticInfo getLastServiceDiagnostics() {
        return this.fO.getServiceDiagnostics();
    }

    public StatusCode getLastServiceResult() {
        return this.fO.getServiceResult();
    }

    public int getMaxMonitoredItemsPerCall() {
        if (this.fQ < 0) {
            return this.ciO();
        }
        return this.fQ;
    }

    public int getNotificationBufferSize() {
        return this.fR;
    }

    public SubscriptionNotificationListener[] getNotificationListeners() {
        return this.fS.toArray(new SubscriptionNotificationListener[this.fS.size()]);
    }

    public StatusCode getStatus() {
        return this.fV;
    }

    public double getTimeoutDetectionFactor() {
        return this.fZ;
    }

    public TimestampsToReturn getTimestampsToReturn() {
        return this.fh;
    }

    public boolean hasAliveListener(SubscriptionAliveListener subscriptionAliveListener) {
        if (subscriptionAliveListener == null) {
            throw new NullPointerException("null listener not allowed");
        }
        return this.fK.contains(subscriptionAliveListener);
    }

    public boolean hasNotificationListener(SubscriptionNotificationListener subscriptionNotificationListener) {
        if (subscriptionNotificationListener == null) {
            throw new NullPointerException("null listener not allowed");
        }
        return this.fS.contains(subscriptionNotificationListener);
    }

    public boolean isAlive() {
        return this.fX;
    }

    public boolean isConnected() {
        UnsignedInteger unsignedInteger = this.getSubscriptionId();
        return unsignedInteger != null && !unsignedInteger.equals(UnsignedInteger.ZERO);
    }

    public boolean isModified() {
        return this.modified;
    }

    public boolean isRecreateFailedItems() {
        return this.ga;
    }

    public boolean isRetransmissionEnabled() {
        return this.fU;
    }

    public boolean isTimeout() {
        return this.fW;
    }

    public String itemsToString() {
        return this.items.toString();
    }

    public DataValue[] readAll(Double d2, TimestampsToReturn timestampsToReturn) throws ServiceException {
        MonitoredItemBase[] monitoredItemBaseArray = this.getItems();
        ReadValueId[] readValueIdArray = new ReadValueId[monitoredItemBaseArray.length];
        for (int i2 = 0; i2 < monitoredItemBaseArray.length; ++i2) {
            if (!(monitoredItemBaseArray[i2] instanceof MonitoredDataItem)) continue;
            MonitoredDataItem monitoredDataItem = (MonitoredDataItem)monitoredItemBaseArray[i2];
            readValueIdArray[i2] = new ReadValueId(monitoredDataItem.getNodeId(), monitoredDataItem.getAttributeId(), NumericRange.toString(monitoredDataItem.getIndexRange()), monitoredDataItem.getDataEncoding());
        }
        return this.em.read(d2, timestampsToReturn, readValueIdArray).getResults();
    }

    public void removeAliveListener(SubscriptionAliveListener subscriptionAliveListener) {
        this.fK.remove(subscriptionAliveListener);
    }

    @Override
    public MonitoredItemBase removeItem(MonitoredItemBase monitoredItemBase) throws ServiceException, StatusException {
        logger.debug("removeItem: {}", (Object)monitoredItemBase);
        return this.removeItem(monitoredItemBase.getClientHandle());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MonitoredItemBase removeItem(UnsignedInteger unsignedInteger) throws ServiceException, StatusException {
        MonitoredItemBase monitoredItemBase = super.removeItem(unsignedInteger);
        if (monitoredItemBase != null && !UnsignedInteger.ZERO.equals(monitoredItemBase.getMonitoredItemId())) {
            try {
                DeleteMonitoredItemsResponse deleteMonitoredItemsResponse = this.deleteMonitoredItems(monitoredItemBase);
                if (deleteMonitoredItemsResponse != null && deleteMonitoredItemsResponse.getResults()[0].isBad()) {
                    throw new StatusException(deleteMonitoredItemsResponse.getResults()[0]);
                }
            }
            finally {
                ((MonitoredItem)monitoredItemBase).setMonitoredItemId(UnsignedInteger.ZERO);
            }
        }
        return monitoredItemBase;
    }

    public StatusCode[] removeItems() throws ServiceException {
        return this.removeItems(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatusCode[] removeItems(MonitoredItemBase ... monitoredItemBaseArray) throws ServiceException {
        if (monitoredItemBaseArray == null) {
            monitoredItemBaseArray = this.getItems();
        }
        StatusCode[] statusCodeArray = new StatusCode[monitoredItemBaseArray.length];
        for (MonitoredItemBase object2 : monitoredItemBaseArray) {
            try {
                if (null == object2) continue;
                super.removeItem(object2.getClientHandle());
            }
            catch (StatusException statusException) {
                // empty catch block
            }
        }
        ArrayList arrayList = new ArrayList();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (int i2 = 0; i2 < monitoredItemBaseArray.length; ++i2) {
            MonitoredItemBase monitoredItemBase = monitoredItemBaseArray[i2];
            if (monitoredItemBase != null && !UnsignedInteger.ZERO.equals(monitoredItemBase.getMonitoredItemId())) {
                arrayList.add(monitoredItemBase);
                arrayList2.add(i2);
                continue;
            }
            statusCodeArray[i2] = StatusCode.GOOD;
        }
        if (!arrayList.isEmpty()) {
            Object object3;
            try {
                object3 = this.deleteMonitoredItems(arrayList.toArray(new MonitoredItemBase[0]));
                if (object3 != null) {
                    StatusCode[] statusCodeArray2 = ((DeleteMonitoredItemsResponse)object3).getResults();
                    for (int i2 = 0; i2 < statusCodeArray2.length; ++i2) {
                        statusCodeArray[((Integer)arrayList2.get((int)i2)).intValue()] = statusCodeArray2[i2];
                    }
                }
            }
            finally {
                object3 = arrayList.iterator();
                while (object3.hasNext()) {
                    MonitoredItemBase monitoredItemBase = (MonitoredItemBase)object3.next();
                    ((MonitoredItem)monitoredItemBase).setMonitoredItemId(UnsignedInteger.ZERO);
                }
            }
        }
        return statusCodeArray;
    }

    public void removeNotificationListener(SubscriptionNotificationListener subscriptionNotificationListener) {
        this.fS.remove(subscriptionNotificationListener);
    }

    public void republishAllAvailable() throws ServiceException {
        StatusCode statusCode = StatusCode.GOOD;
        UnsignedInteger unsignedInteger = this.fN;
        while (statusCode.isGood()) {
            unsignedInteger = this.fN;
            long l2 = unsignedInteger.longValue() + 1L;
            if (l2 > 0xFFFFFFFFL) {
                l2 = 1L;
            }
            statusCode = this.a(l2, false);
        }
        if (!statusCode.getValue().equals(StatusCodes.Bad_MessageNotAvailable)) {
            throw new ServiceException(statusCode);
        }
        this.fN = unsignedInteger;
    }

    public void resendData() throws MethodCallStatusException, ServiceException {
        this.em.call(Identifiers.Server, Identifiers.Server_ResendData, new Variant(this.getSubscriptionId()));
    }

    public void setAliveDetectionFactor(double d2) {
        if (d2 <= 1.0) {
            throw new IllegalArgumentException("aliveDetectionFactor must be greater than 1");
        }
        this.fY = d2;
    }

    public void setMaxMonitoredItemsPerCall(int n2) {
        this.fQ = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMonitoringMode(MonitoringMode monitoringMode) throws ServiceException {
        this.beginUpdate();
        try {
            for (MonitoredItemBase monitoredItemBase : this.items.values()) {
                monitoredItemBase.setMonitoringMode(monitoringMode);
            }
        }
        finally {
            this.endUpdate();
        }
    }

    public void setNotificationBufferSize(int n2) {
        this.fR = n2;
    }

    @Override
    public void setPublishingInterval(long l2, TimeUnit timeUnit) throws ServiceException {
        super.setPublishingInterval(l2, timeUnit);
    }

    public void setRecreateFailedItems(boolean bl) {
        this.ga = bl;
    }

    public void setRetransmissionEnabled(boolean bl) {
        this.fU = bl;
    }

    public void setTimeoutDetectionFactor(double d2) {
        if (d2 <= 1.0) {
            throw new IllegalArgumentException("timeoutDetectionFactor must be greater than 1");
        }
        this.fZ = d2;
    }

    public void setTimestampsToReturn(TimestampsToReturn timestampsToReturn) {
        this.fh = timestampsToReturn;
    }

    public void transferTo(UaClient uaClient) throws ServiceException, StatusException {
        this.transferTo(uaClient, this.getSubscriptionId(), true);
    }

    public void transferTo(UaClient uaClient, boolean bl) throws ServiceException, StatusException {
        this.transferTo(uaClient, this.getSubscriptionId(), bl);
    }

    public void transferTo(UaClient uaClient, UnsignedInteger unsignedInteger) throws ServiceException, StatusException {
        this.transferTo(uaClient, unsignedInteger, true);
    }

    public void updateItems() throws ServiceException {
        ArrayList<MonitoredItem> arrayList = new ArrayList<MonitoredItem>();
        for (MonitoredItemBase monitoredItemBase : this.items.values()) {
            MonitoredItem monitoredItem = (MonitoredItem)monitoredItemBase;
            if (!monitoredItem.isModified()) continue;
            arrayList.add(monitoredItem);
        }
        this.modifyMonitoredItems(arrayList);
        for (MonitoredItem monitoredItem : arrayList) {
            monitoredItem.clearModified();
        }
    }

    public void updateMonitoringModes() throws ServiceException {
        for (MonitoringMode monitoringMode : MonitoringMode.values()) {
            ArrayList<MonitoredItem> arrayList = new ArrayList<MonitoredItem>();
            for (MonitoredItemBase monitoredItemBase : this.items.values()) {
                MonitoredItem monitoredItem = (MonitoredItem)monitoredItemBase;
                if (!monitoredItem.isMonitoringModeModified() || !monitoredItem.getMonitoringMode().equals(monitoringMode)) continue;
                arrayList.add(monitoredItem);
            }
            this.setMonitoringMode(monitoringMode, arrayList);
            for (MonitoredItem monitoredItem : arrayList) {
                monitoredItem.clearMonitoringModeModified();
            }
        }
    }

    private void acknowledge(UnsignedInteger unsignedInteger) {
        logger.debug("acknowledge: requestedSeqNumber={}", (Object)unsignedInteger);
        UaClient uaClient = this.getClient();
        if (uaClient != null) {
            uaClient.addSubscriptionAck(new SubscriptionAcknowledgement(this.getSubscriptionId(), unsignedInteger));
        }
        logger.debug("acknowledge: availableSequenceNumbers={}", this.getAvailableSequenceNumbersList());
    }

    private StatusCode a(long l2, boolean bl) {
        StatusCode statusCode;
        ExtensionObject[] extensionObjectArray;
        logger.trace("callRepublish: id=:{}, targetSequenceNumber={}, notifyMissingData={}", new Object[]{this.getSubscriptionId(), l2, bl});
        this.fN = this.fN.add(1);
        if (bl && !this.getAvailableSequenceNumbersList().contains(this.fN)) {
            logger.info("Missing NotificationMessage (SequenceNumber={})  no longer available from server.  Target SequenceNumber={}", (Object)this.fN, (Object)l2);
            this.fireMissingData(this.fN, l2, 0L, null);
            return StatusCode.GOOD;
        }
        UnsignedInteger unsignedInteger = this.fN;
        logger.info("Requesting missing NotificationMessage (SequenceNumber={}) from the server using Republish: Target SequenceNumber={}", (Object)unsignedInteger, (Object)l2);
        RepublishResponse republishResponse = null;
        try {
            extensionObjectArray = null;
            try {
                extensionObjectArray = this.em.ciq();
            }
            catch (ServerConnectionException serverConnectionException) {
                // empty catch block
            }
            if (extensionObjectArray == null) {
                return StatusCode.valueOf(StatusCodes.Bad_ServerNotConnected);
            }
            republishResponse = extensionObjectArray.Republish(this.em.getRequestHeader(), this.getSubscriptionId(), this.fN);
            statusCode = republishResponse.getResponseHeader().getServiceResult();
        }
        catch (ServiceResultException serviceResultException) {
            statusCode = serviceResultException.getStatusCode();
        }
        if (statusCode.isBad()) {
            logger.debug("Republish failed: Error={}", (Object)statusCode);
        } else if (logger.isDebugEnabled()) {
            logger.debug("Republish: serviceResult={}", (Object)statusCode);
        }
        if (statusCode.getValue().equals(StatusCodes.Bad_MessageNotAvailable)) {
            logger.info("Message not available");
            long l3 = (l2 + this.fN.longValue()) / 2L;
            if (bl) {
                this.a(l2, l3, statusCode);
            }
            this.fL = Instant.now();
            return statusCode;
        }
        if (republishResponse == null) {
            logger.info("Failed to get a response to Republish (SequenceNumber={}): Error={}", (Object)unsignedInteger, (Object)statusCode);
            if (bl) {
                this.a(l2, this.fN.longValue() + 1L, statusCode);
            }
            return statusCode;
        }
        if (!unsignedInteger.equals(republishResponse.getNotificationMessage().getSequenceNumber())) {
            logger.info("Received SequenceNumber ({}) for Republish is different than the one requested ({})", (Object)republishResponse.getNotificationMessage().getSequenceNumber(), (Object)unsignedInteger);
        }
        if ((extensionObjectArray = republishResponse.getNotificationMessage().getNotificationData()) != null && extensionObjectArray.length > 0) {
            if (this.em.getListener() == null || this.em.getListener().validateRepublishResponse(this.em, republishResponse)) {
                this.a(extensionObjectArray);
            } else {
                logger.info("NotificationData returned for Republish (SequenceNumber={}) is not valid, ignoring", (Object)unsignedInteger);
            }
        } else if (republishResponse.getResponseHeader().getServiceResult().isGood()) {
            logger.warn("NotificationData returned for Republish (SequenceNumber={}) is empty", (Object)unsignedInteger);
        }
        this.acknowledge(unsignedInteger);
        this.fL = Instant.now();
        return StatusCode.GOOD;
    }

    private MonitoringFilterResult a(MonitoredItem monitoredItem, ExtensionObject extensionObject) {
        MonitoringFilterResult monitoringFilterResult = null;
        if (extensionObject != null) {
            try {
                monitoringFilterResult = (MonitoringFilterResult)extensionObject.decode(this.em.getEncoderContext());
            }
            catch (DecodingException decodingException) {
                logger.info("Cannot decode FilterResult of item " + monitoredItem.getNodeId(), (Throwable)decodingException);
            }
        }
        return monitoringFilterResult;
    }

    private CreateMonitoredItemsResponse a(MonitoredItemBase ... monitoredItemBaseArray) throws ServiceException {
        CreateMonitoredItemsResponse createMonitoredItemsResponse;
        MonitoredItemCreateResult[] monitoredItemCreateResultArray;
        MonitoredItemCreateResult[] monitoredItemCreateResultArray2;
        LinkedHashMap<MonitoredItemCreateResult[], MonitoredItemCreateRequest> linkedHashMap = new LinkedHashMap<MonitoredItemCreateResult[], MonitoredItemCreateRequest>();
        Integer[] integerArray = new Integer[monitoredItemBaseArray.length];
        int n2 = 0;
        for (int i2 = 0; i2 < monitoredItemBaseArray.length; ++i2) {
            try {
                monitoredItemCreateResultArray2 = monitoredItemBaseArray[i2];
                monitoredItemCreateResultArray = new ReadValueId(monitoredItemCreateResultArray2.getNodeId(), monitoredItemCreateResultArray2.getAttributeId(), NumericRange.toString(monitoredItemCreateResultArray2.getIndexRange()), monitoredItemCreateResultArray2.getDataEncoding());
                MonitoringParameters monitoringParameters = this.getMonitoringParameters((MonitoredItemBase)monitoredItemCreateResultArray2);
                linkedHashMap.put(monitoredItemCreateResultArray2, new MonitoredItemCreateRequest((ReadValueId)monitoredItemCreateResultArray, monitoredItemCreateResultArray2.getMonitoringMode(), monitoringParameters));
                integerArray[i2] = n2++;
                continue;
            }
            catch (RuntimeException runtimeException) {
                logger.error("Caught RuntimeException while trying to create MonitoredItems, skipping item: {}", (Object)monitoredItemBaseArray[i2], (Object)runtimeException);
                integerArray[i2] = null;
            }
        }
        try {
            createMonitoredItemsResponse = this.em.ciq().CreateMonitoredItems(this.em.getRequestHeader(), this.getSubscriptionId(), this.getTimestampsToReturn(), linkedHashMap.values().toArray(new MonitoredItemCreateRequest[linkedHashMap.size()]));
        }
        catch (ServiceFaultException serviceFaultException) {
            throw new ServiceException(serviceFaultException);
        }
        catch (ServiceResultException serviceResultException) {
            throw new ServiceException(serviceResultException);
        }
        this.checkServiceResult(createMonitoredItemsResponse, createMonitoredItemsResponse.getDiagnosticInfos());
        monitoredItemCreateResultArray2 = createMonitoredItemsResponse.getResults();
        if (monitoredItemCreateResultArray2 == null || monitoredItemCreateResultArray2.length == 0) {
            throw new ServiceException("The server returned empty Results for the call", StatusCodes.Bad_UnexpectedError);
        }
        if (monitoredItemCreateResultArray2.length < linkedHashMap.size()) {
            logger.warn("Received fewer MonitoredItemCreateResults than expected, got {} while expecting {}", (Object)monitoredItemCreateResultArray2.length, (Object)linkedHashMap.size());
        }
        if (monitoredItemCreateResultArray2.length > linkedHashMap.size()) {
            logger.warn("Received more MonitoredItemCreateResults than expected, got {} while expecting {}", (Object)monitoredItemCreateResultArray2.length, (Object)linkedHashMap.size());
        }
        monitoredItemCreateResultArray = new MonitoredItemCreateResult[monitoredItemBaseArray.length];
        for (int i3 = 0; i3 < monitoredItemBaseArray.length; ++i3) {
            Object object;
            MonitoredItemCreateResult monitoredItemCreateResult;
            MonitoredItem monitoredItem = (MonitoredItem)monitoredItemBaseArray[i3];
            Integer n3 = integerArray[i3];
            if (n3 != null) {
                if (n3 < monitoredItemCreateResultArray2.length) {
                    monitoredItemCreateResultArray[i3] = monitoredItemCreateResult = monitoredItemCreateResultArray2[n3];
                    object = monitoredItemCreateResult.getMonitoredItemId();
                    logger.debug("createMonitoredItems: i={}, monitoredItemId={}, resultStatus={}", new Object[]{i3, object, monitoredItemCreateResult.getStatusCode()});
                    monitoredItem.setMonitoredItemId((UnsignedInteger)object);
                    MonitoringFilterResult monitoringFilterResult = this.a(monitoredItem, monitoredItemCreateResult.getFilterResult());
                    StatusCode statusCode = monitoredItemCreateResult.getStatusCode();
                    monitoredItem.setErrorCode(statusCode);
                    monitoredItem.setFilterResult(monitoringFilterResult);
                    if (statusCode != null && statusCode.isGood()) {
                        monitoredItem.setRevisedQueueSize(monitoredItemCreateResult.getRevisedQueueSize());
                        if (!(monitoredItem instanceof MonitoredDataItem)) continue;
                        MonitoredDataItem monitoredDataItem = (MonitoredDataItem)monitoredItem;
                        monitoredDataItem.setRevisedSamplingInterval(monitoredItemCreateResult.getRevisedSamplingInterval());
                        continue;
                    }
                    logger.debug("createMonitoredItems: status is not good, ignoring RevisedQueueSize and RevisedSamplingInterval");
                    continue;
                }
                monitoredItem.setErrorCode(StatusCode.valueOf(StatusCodes.Bad_UnexpectedError));
                continue;
            }
            logger.debug("createMonitoredItems: i={}, was skipped, setting error code to Bad_UnexpectedError", (Object)i3);
            monitoredItemCreateResult = new MonitoredItemCreateResult();
            monitoredItemCreateResult.setStatusCode(StatusCode.valueOf(StatusCodes.Bad_UnexpectedError));
            monitoredItemCreateResult.setRevisedQueueSize(UnsignedInteger.valueOf(0L));
            monitoredItemCreateResult.setRevisedSamplingInterval(0.0);
            monitoredItemCreateResult.setMonitoredItemId(UnsignedInteger.valueOf(0L));
            object = new MonitoringFilterResult();
            try {
                monitoredItemCreateResult.setFilterResult(ExtensionObject.binaryEncode((Structure)object, this.em.getEncoderContext()));
            }
            catch (EncodingException encodingException) {
                logger.error("Internal failure duing creating FilterResult for MonitoredItem that was skipped", (Throwable)encodingException);
            }
            monitoredItemCreateResultArray[i3] = monitoredItemCreateResult;
            monitoredItem.setMonitoredItemId(monitoredItemCreateResult.getMonitoredItemId());
            monitoredItem.setErrorCode(monitoredItemCreateResult.getStatusCode());
            monitoredItem.setFilterResult((MonitoringFilterResult)object);
        }
        createMonitoredItemsResponse.setResults(monitoredItemCreateResultArray);
        return createMonitoredItemsResponse;
    }

    private DeleteMonitoredItemsResponse b(MonitoredItemBase ... monitoredItemBaseArray) throws ServiceException {
        DeleteMonitoredItemsResponse deleteMonitoredItemsResponse;
        UnsignedInteger[] unsignedIntegerArray = new UnsignedInteger[monitoredItemBaseArray.length];
        for (int i2 = 0; i2 < monitoredItemBaseArray.length; ++i2) {
            unsignedIntegerArray[i2] = monitoredItemBaseArray[i2].getMonitoredItemId();
        }
        try {
            logger.debug("DeleteMonitoredItems");
            deleteMonitoredItemsResponse = this.em.ciq().DeleteMonitoredItems(this.em.getRequestHeader(), this.getSubscriptionId(), unsignedIntegerArray);
            logger.debug("DeleteMonitoredItems: response={}", (Object)deleteMonitoredItemsResponse);
        }
        catch (ServiceFaultException serviceFaultException) {
            throw new ServiceException(serviceFaultException);
        }
        catch (ServiceResultException serviceResultException) {
            throw new ServiceException(serviceResultException);
        }
        this.checkServiceResult(deleteMonitoredItemsResponse, deleteMonitoredItemsResponse.getDiagnosticInfos());
        return deleteMonitoredItemsResponse;
    }

    private boolean a(long l2, long l3, StatusCode statusCode) {
        logger.debug("doMissingData: newSequenceNumber={}", (Object)l3);
        long l4 = this.fireMissingData(this.fN, l2, l3, statusCode);
        if (l4 > 0L && l4 != l3 && l4 < l2) {
            l3 = l4;
            logger.debug("doMissingData: (modified) newSequenceNumber={}", (Object)l3);
        }
        if (l3 >= l2) {
            logger.debug("doMissingData: break; newSequenceNumber >= sequenceNumber");
            return false;
        }
        this.fN = UnsignedInteger.valueOf(l3);
        return true;
    }

    private ModifyMonitoredItemsResponse d(List<MonitoredItem> list) throws ServiceException {
        ModifyMonitoredItemsResponse modifyMonitoredItemsResponse;
        MonitoredItemModifyRequest[] monitoredItemModifyRequestArray = new MonitoredItemModifyRequest[list.size()];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            MonitoredItemBase monitoredItemBase = list.get(i2);
            monitoredItemModifyRequestArray[i2] = new MonitoredItemModifyRequest(monitoredItemBase.getMonitoredItemId(), this.getMonitoringParameters(monitoredItemBase));
        }
        try {
            modifyMonitoredItemsResponse = this.em.ciq().ModifyMonitoredItems(this.em.getRequestHeader(), this.getSubscriptionId(), this.getTimestampsToReturn(), monitoredItemModifyRequestArray);
        }
        catch (ServiceFaultException serviceFaultException) {
            throw new ServiceException(serviceFaultException);
        }
        catch (ServiceResultException serviceResultException) {
            throw new ServiceException(serviceResultException);
        }
        this.checkServiceResult(modifyMonitoredItemsResponse, modifyMonitoredItemsResponse.getDiagnosticInfos());
        for (int i3 = 0; i3 < list.size(); ++i3) {
            MonitoredItem monitoredItem = list.get(i3);
            MonitoredItemModifyResult monitoredItemModifyResult = modifyMonitoredItemsResponse.getResults()[i3];
            UnsignedInteger unsignedInteger = monitoredItem.getMonitoredItemId();
            logger.debug("modifyMonitoredItems: i={}, monitoredItemId={}, resultStatus={}", new Object[]{i3, unsignedInteger, monitoredItemModifyResult.getStatusCode()});
            monitoredItem.setFilterResult(this.a(monitoredItem, monitoredItemModifyResult.getFilterResult()));
            StatusCode statusCode = monitoredItemModifyResult.getStatusCode();
            if (statusCode != null && statusCode.isGood()) {
                monitoredItem.setRevisedQueueSize(monitoredItemModifyResult.getRevisedQueueSize());
                if (!(monitoredItem instanceof MonitoredDataItem)) continue;
                MonitoredDataItem monitoredDataItem = (MonitoredDataItem)monitoredItem;
                monitoredDataItem.setRevisedSamplingInterval(monitoredItemModifyResult.getRevisedSamplingInterval());
                continue;
            }
            logger.debug("modifyMonitoredItems: status is not good, ignoring RevisedQueueSize and RevisedSamplingInterval");
        }
        return modifyMonitoredItemsResponse;
    }

    private void c(long l2) throws ServerConnectionException, ServiceException {
        if (this.isRetransmissionEnabled() && this.isConnected()) {
            StatusCode statusCode;
            while (this.fN != null && this.fN.longValue() < l2 && !(statusCode = this.a(l2, true)).isBad()) {
            }
        } else if (this.fN != null && this.fN.longValue() < l2) {
            this.a(l2, 0L, null);
        }
    }

    private SetMonitoringModeResponse a(MonitoringMode monitoringMode, List<MonitoredItem> list) throws ServiceException {
        SetMonitoringModeResponse setMonitoringModeResponse;
        UnsignedInteger[] unsignedIntegerArray = new UnsignedInteger[list.size()];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            MonitoredItemBase monitoredItemBase = list.get(i2);
            unsignedIntegerArray[i2] = monitoredItemBase.getMonitoredItemId();
        }
        try {
            setMonitoringModeResponse = this.em.ciq().SetMonitoringMode(this.em.getRequestHeader(), this.getSubscriptionId(), monitoringMode, unsignedIntegerArray);
        }
        catch (ServiceFaultException serviceFaultException) {
            throw new ServiceException(serviceFaultException);
        }
        catch (ServiceResultException serviceResultException) {
            throw new ServiceException(serviceResultException);
        }
        this.checkServiceResult(setMonitoringModeResponse, setMonitoringModeResponse.getDiagnosticInfos());
        for (int i3 = 0; i3 < list.size(); ++i3) {
            MonitoredItemBase monitoredItemBase = list.get(i3);
            monitoredItemBase.setMonitoringMode(monitoringMode);
        }
        return setMonitoringModeResponse;
    }

    private int ciO() {
        int n2 = 0;
        OperationLimits operationLimits = this.getOperationLimits();
        if (operationLimits != null) {
            try {
                n2 = operationLimits.getMaxMonitoredItemsPerCall().intValue();
            }
            catch (Exception exception) {
                logger.debug("operationLimits", (Throwable)exception);
            }
        }
        logger.debug("getMaxMonitoredItemsPerCall={}", (Object)n2);
        return n2;
    }

    private OperationLimits getOperationLimits() {
        return this.em.getActualOperationLimits();
    }

    private void a(ExtensionObject[] extensionObjectArray) {
        UaClient uaClient = this.em;
        if (uaClient == null) {
            logger.debug("handleNotificationData: client is null, therefore skipping handling");
            return;
        }
        EncoderContext encoderContext = uaClient.getEncoderContext();
        if (encoderContext == null) {
            logger.debug("handleNotificationData: encoder context is null, skipping handling");
            return;
        }
        logger.debug("handleNotificationData: notificationDatas.length={}", (Object)extensionObjectArray.length);
        for (ExtensionObject extensionObject : extensionObjectArray) {
            MonitoredItem classCastException;
            Object object;
            NotificationData notificationData;
            NotificationData notificationData2;
            if (extensionObject == null) {
                logger.debug("handleNotificationData: o=null");
                continue;
            }
            try {
                notificationData2 = (NotificationData)extensionObject.decode(encoderContext);
                logger.debug("handleNotificationData: notificationData={}", (Object)notificationData2);
            }
            catch (DecodingException decodingException) {
                logger.info("handleNotificationData: Failed to decode notification {}", (Object)extensionObject, (Object)decodingException);
                this.fireError(extensionObject, decodingException);
                continue;
            }
            catch (RuntimeException runtimeException) {
                logger.error("handleNotificationData: Got RuntimeException while decoding NotificationData {}", (Object)extensionObject, (Object)runtimeException);
                throw runtimeException;
            }
            if (notificationData2 instanceof DataChangeNotification) {
                notificationData = (DataChangeNotification)notificationData2;
                object = ((DataChangeNotification)notificationData).getMonitoredItems();
                if (object == null) {
                    logger.debug("handleNotificationData: dataChangeNotification.getMonitoredItems()=null");
                } else {
                    logger.debug("handleNotificationData: dataChangeNotification.length={}", (Object)((MonitoredItemNotification[])object).length);
                    for (MonitoredItemNotification monitoredItemNotification : object) {
                        if (monitoredItemNotification == null) {
                            logger.debug("handleNotificationData: MonitoredItemNotification=null");
                            continue;
                        }
                        logger.debug("handleNotificationData: MonitoredItemNotification ClientHandle={} Value={}", (Object)monitoredItemNotification.getClientHandle(), (Object)monitoredItemNotification.getValue());
                        try {
                            classCastException = (MonitoredDataItem)this.getItem(monitoredItemNotification.getClientHandle());
                            logger.debug("item={}; firing data changes", (Object)classCastException);
                            this.fireDataChange((MonitoredDataItem)classCastException, monitoredItemNotification.getValue());
                            logger.debug("Setting value {} to {}", (Object)monitoredItemNotification.getValue(), (Object)classCastException);
                            ((MonitoredDataItem)classCastException).setValue(monitoredItemNotification.getValue());
                        }
                        catch (StatusException exception) {
                            logger.debug("handleNotificationData: ", (Throwable)exception);
                            if (!this.isConnected()) break;
                            if (exception.getStatusCode().getValue().equals(StatusCodes.Bad_MonitoredItemIdInvalid)) {
                                logger.info("handleNotificationData: unknown clientHandle={} subscriptionId={}", (Object)monitoredItemNotification.getClientHandle(), (Object)this.getSubscriptionId());
                            }
                            this.fireError(monitoredItemNotification, exception);
                        }
                        catch (ClassCastException classCastException2) {
                            logger.debug("handleNotificationData: ", (Throwable)classCastException2);
                            this.fireError(monitoredItemNotification, classCastException2);
                        }
                        catch (Exception exception) {
                            logger.error("handleNotificationData: Unexpected error (most likely MonitoredDataItem.setValue did throw RuntimeException which it should not)", (Throwable)exception);
                            this.fireError(monitoredItemNotification, exception);
                        }
                    }
                    logger.debug("handleNotificationData: handled all MonitoredItemNotifications length={}", (Object)((MonitoredItemNotification[])object).length);
                }
            } else if (notificationData2 instanceof StatusChangeNotification) {
                notificationData = (StatusChangeNotification)notificationData2;
                object = this.fV;
                this.fV = ((StatusChangeNotification)notificationData).getStatus();
                this.cs = ((StatusChangeNotification)notificationData).getDiagnosticInfo();
                logger.debug("handleNotificationData: statusChange status={} diagnosticInfo={}", (Object)this.fV, (Object)this.cs);
                try {
                    this.fireStatusChange((StatusCode)object, this.fV, this.cs);
                }
                catch (ClassCastException classCastException3) {
                    logger.debug("handleNotificationData: ", (Throwable)classCastException3);
                    this.fireError(notificationData, classCastException3);
                }
            } else if (notificationData2 instanceof EventNotificationList) {
                notificationData = (EventNotificationList)notificationData2;
                object = ((EventNotificationList)notificationData).getEvents();
                if (object != null) {
                    logger.debug("handleNotificationData: events.length={}", (Object)((MonitoredItemNotification[])object).length);
                    for (MonitoredItemNotification monitoredItemNotification : object) {
                        if (monitoredItemNotification == null) continue;
                        try {
                            classCastException = (MonitoredEventItem)this.getItem(((EventFieldList)((Object)monitoredItemNotification)).getClientHandle());
                            Variant[] classCastException2 = Variant.asVariantArray(((EventFieldList)((Object)monitoredItemNotification)).getEventFields());
                            if (classCastException == null) {
                                logger.debug("item=null");
                                continue;
                            }
                            if (logger.isDebugEnabled()) {
                                logger.debug("handleNotificationData: EventFieldList clientHandle={} itemId={} nodeId={} eventFields={}", new Object[]{((EventFieldList)((Object)monitoredItemNotification)).getClientHandle(), classCastException.getMonitoredItemId(), classCastException.getNodeId(), Arrays.toString(((EventFieldList)((Object)monitoredItemNotification)).getEventFields())});
                            }
                            this.fireEvent((MonitoredEventItem)classCastException, classCastException2);
                            ((MonitoredEventItem)classCastException).doEvent(classCastException2);
                        }
                        catch (StatusException statusException) {
                            logger.debug("handleNotificationData: ", (Throwable)statusException);
                            if (statusException.getStatusCode().getValue().equals(StatusCodes.Bad_MonitoredItemIdInvalid)) {
                                logger.info("handleNotificationData: unknown clientHandle={}", (Object)((EventFieldList)((Object)monitoredItemNotification)).getClientHandle());
                            }
                            this.fireError(monitoredItemNotification, statusException);
                        }
                        catch (ClassCastException classCastException4) {
                            logger.debug("handleNotificationData: ", (Throwable)classCastException4);
                            this.fireError(monitoredItemNotification, classCastException4);
                        }
                    }
                } else {
                    logger.debug("handleNotificationData: eventNotificationList.getEvents() was null");
                }
            } else {
                logger.debug("handleNotificationData: unknown notificationData type, or it is null");
            }
            this.fireNotification(notificationData2);
        }
        logger.debug("handleNotificationData: handled all notificationDatas.length={}", (Object)extensionObjectArray.length);
    }

    private void e(UnsignedInteger unsignedInteger) {
        for (UnsignedInteger unsignedInteger2 : this.getAvailableSequenceNumbersList()) {
            if (unsignedInteger2.getValue() <= unsignedInteger.getValue() || unsignedInteger2.getValue() - unsignedInteger.getValue() >= fJ || this.fT.containsKey(unsignedInteger2)) continue;
            logger.info("Invalid sequence number {} in availableSequenceNumbers list received from server. Current SequenceNumber={}", (Object)unsignedInteger2, (Object)unsignedInteger);
        }
    }

    private void setAvailableSequenceNumbers(UnsignedInteger[] unsignedIntegerArray) {
        if (unsignedIntegerArray != null && unsignedIntegerArray.length > 0) {
            UnsignedInteger unsignedInteger = Collections.max(Arrays.asList(unsignedIntegerArray));
            logger.debug("setAvailableSequenceNumbers: availableSequenceNumbers={} latest={}", (Object)unsignedIntegerArray, (Object)unsignedInteger);
            this.fP.set(new a(unsignedIntegerArray, unsignedInteger.longValue()));
        } else {
            this.fP.set(null);
        }
    }

    private void a(UnsignedInteger unsignedInteger, UnsignedInteger[] unsignedIntegerArray) {
        if (unsignedIntegerArray != null) {
            logger.debug("addAvailableSequenceNumbers: lastSequenceNumber={} seqNumbers={}", (Object)this.fN, (Object)Arrays.toString(unsignedIntegerArray));
            long l2 = unsignedInteger.getValue();
            a a2 = null;
            do {
                long l3;
                if ((a2 = this.fP.get()) == null || l2 > (l3 = a2.gc) || l3 > fJ && l2 < 100L) continue;
                logger.debug("setAvailableSequenceNumbers not updated, sequenceNumber={} latestAvailableSequenceNumber={}", (Object)l2, (Object)l3);
                break;
            } while (!this.fP.compareAndSet(a2, new a(unsignedIntegerArray, l2)));
            logger.debug("addAvailableSequenceNumbers: availableSequenceNumbers={}", this.getAvailableSequenceNumbersList());
        }
    }

    @Override
    protected void applyUpdates() throws ServiceException {
        super.applyUpdates();
        if (this.updateCount == 0) {
            this.updateSubscription();
            this.updateItems();
            this.updateMonitoringModes();
        }
    }

    protected void checkOperationResult(StatusCode statusCode) throws StatusException {
        if (statusCode.isBad()) {
            if (this.fM == null) {
                throw new StatusException(statusCode);
            }
            throw new StatusException(statusCode, this.fM[0]);
        }
    }

    protected void checkServiceResult(ServiceResponse serviceResponse, DiagnosticInfo[] diagnosticInfoArray) throws ServiceException {
        this.fO = serviceResponse.getResponseHeader();
        this.fM = diagnosticInfoArray;
        if (this.getLastServiceResult().isBad()) {
            throw new ServiceException(this.getLastServiceResult());
        }
    }

    protected void checkTimeout() {
        Instant instant = this.getLastAlive();
        if (instant != null) {
            boolean bl;
            boolean bl2;
            long l2 = Duration.between(Instant.now(), instant).toMillis();
            boolean bl3 = bl2 = (double)l2 > this.getPublishingInterval() * (double)this.getMaxKeepAliveCount() * this.fZ;
            if (bl2 && logger.isDebugEnabled()) {
                logger.debug("checkTimeout: timeout, msAfterLastAlive={}", (Object)l2);
            }
            this.setTimeout(bl2);
            boolean bl4 = bl = (double)l2 > this.getPublishingInterval() * (double)this.getLifetimeCount() * this.fY;
            if (bl && logger.isDebugEnabled()) {
                logger.debug("checkTimeout: lifetime ended, msAfterLastAlive={}", (Object)l2);
            }
            this.setAlive(!bl);
        }
    }

    protected void createItems() throws ServiceException {
        this.createMonitoredItems(this.items.values().toArray(new MonitoredItemBase[this.items.size()]));
    }

    protected CreateMonitoredItemsResponse createMonitoredItems(MonitoredItemBase ... monitoredItemBaseArray) throws ServiceException {
        if (this.serverConnected() && monitoredItemBaseArray.length > 0) {
            int n2;
            if (logger.isDebugEnabled()) {
                logger.debug("createMonitoredItems: " + (monitoredItemBaseArray.length < 100 ? Arrays.toString(monitoredItemBaseArray) : monitoredItemBaseArray.length + " items"));
            }
            if ((n2 = this.getMaxMonitoredItemsPerCall()) > 0 && n2 < monitoredItemBaseArray.length) {
                ResponseHeader responseHeader = null;
                MonitoredItemCreateResult[] monitoredItemCreateResultArray = new MonitoredItemCreateResult[monitoredItemBaseArray.length];
                DiagnosticInfo[] diagnosticInfoArray = new DiagnosticInfo[monitoredItemBaseArray.length];
                for (int i2 = 0; i2 < monitoredItemBaseArray.length; i2 += n2) {
                    int n3 = Math.min(n2, monitoredItemBaseArray.length - i2);
                    MonitoredItemBase[] monitoredItemBaseArray2 = Arrays.copyOfRange(monitoredItemBaseArray, i2, i2 + n3);
                    CreateMonitoredItemsResponse createMonitoredItemsResponse = this.a(monitoredItemBaseArray2);
                    responseHeader = createMonitoredItemsResponse.getResponseHeader();
                    for (int i3 = 0; i3 < n3; ++i3) {
                        monitoredItemCreateResultArray[i2 + i3] = createMonitoredItemsResponse.getResults()[i3];
                    }
                    DiagnosticInfo[] diagnosticInfoArray2 = createMonitoredItemsResponse.getDiagnosticInfos();
                    if (diagnosticInfoArray2 == null || diagnosticInfoArray2.length <= 0) continue;
                    for (int i4 = 0; i4 < n3; ++i4) {
                        diagnosticInfoArray[i2 + i4] = diagnosticInfoArray2[i4];
                    }
                }
                return new CreateMonitoredItemsResponse(responseHeader, monitoredItemCreateResultArray, diagnosticInfoArray);
            }
            return this.a(monitoredItemBaseArray);
        }
        return null;
    }

    protected DeleteMonitoredItemsResponse deleteMonitoredItems(MonitoredItemBase ... monitoredItemBaseArray) throws ServiceException {
        if (this.isConnected() && monitoredItemBaseArray.length > 0) {
            int n2 = this.getMaxMonitoredItemsPerCall();
            if (n2 > 0 && n2 < monitoredItemBaseArray.length) {
                ResponseHeader responseHeader = null;
                StatusCode[] statusCodeArray = new StatusCode[monitoredItemBaseArray.length];
                DiagnosticInfo[] diagnosticInfoArray = new DiagnosticInfo[monitoredItemBaseArray.length];
                for (int i2 = 0; i2 < monitoredItemBaseArray.length; i2 += n2) {
                    int n3 = Math.min(n2, monitoredItemBaseArray.length - i2);
                    MonitoredItemBase[] monitoredItemBaseArray2 = Arrays.copyOfRange(monitoredItemBaseArray, i2, i2 + n3);
                    DeleteMonitoredItemsResponse deleteMonitoredItemsResponse = this.b(monitoredItemBaseArray2);
                    responseHeader = deleteMonitoredItemsResponse.getResponseHeader();
                    for (int i3 = 0; i3 < n3; ++i3) {
                        statusCodeArray[i2 + i3] = deleteMonitoredItemsResponse.getResults()[i3];
                    }
                    DiagnosticInfo[] diagnosticInfoArray2 = deleteMonitoredItemsResponse.getDiagnosticInfos();
                    if (diagnosticInfoArray2 != null && diagnosticInfoArray2.length == n3) {
                        for (int i4 = 0; i4 < n3; ++i4) {
                            diagnosticInfoArray[i2 + i4] = diagnosticInfoArray2[i4];
                        }
                        continue;
                    }
                    if (diagnosticInfoArray2 == null || diagnosticInfoArray2.length <= 0 || diagnosticInfoArray2.length == n3) continue;
                    logger.warn("The length of the DiagnosticInfo array in DeleteMonitoredItemsResponse was {}, but the expected length was {}, ignoring the DiagnosticInfo array", (Object)diagnosticInfoArray2.length, (Object)n3);
                }
                return new DeleteMonitoredItemsResponse(responseHeader, statusCodeArray, diagnosticInfoArray);
            }
            return this.b(monitoredItemBaseArray);
        }
        return null;
    }

    @Override
    protected void enabledChanged() throws ServiceException, StatusException {
        if (this.em != null) {
            this.em.b((SubscriptionBase)this);
        }
    }

    protected void fireAfterCreate() {
        for (SubscriptionAliveListener subscriptionAliveListener : this.fK) {
            if (subscriptionAliveListener == null) continue;
            try {
                subscriptionAliveListener.onAfterCreate(this);
            }
            catch (Exception exception) {
                logger.error("Exception while calling onAlive with listener=" + subscriptionAliveListener, (Throwable)exception);
            }
        }
    }

    protected void fireAlive() {
        for (SubscriptionAliveListener subscriptionAliveListener : this.fK) {
            if (subscriptionAliveListener == null) continue;
            try {
                subscriptionAliveListener.onAlive(this);
            }
            catch (Exception exception) {
                logger.error("Exception while calling onAlive with listener=" + subscriptionAliveListener, (Throwable)exception);
            }
        }
    }

    protected void fireBufferOverflow(UnsignedInteger unsignedInteger, ExtensionObject[] extensionObjectArray) {
        for (SubscriptionNotificationListener subscriptionNotificationListener : this.fS) {
            if (subscriptionNotificationListener == null) continue;
            try {
                subscriptionNotificationListener.onBufferOverflow(this, unsignedInteger, extensionObjectArray);
            }
            catch (Exception exception) {
                logger.error("Exception while calling onBufferOverflow with listener=" + subscriptionNotificationListener, (Throwable)exception);
            }
        }
    }

    protected void fireDataChange(MonitoredDataItem monitoredDataItem, DataValue dataValue) {
        for (SubscriptionNotificationListener subscriptionNotificationListener : this.fS) {
            if (subscriptionNotificationListener == null) continue;
            try {
                subscriptionNotificationListener.onDataChange(this, monitoredDataItem, dataValue);
            }
            catch (Exception exception) {
                logger.error("Exception while calling onDataChange with listener=" + subscriptionNotificationListener, (Throwable)exception);
            }
        }
    }

    protected void fireError(Object object, Exception exception) {
        for (SubscriptionNotificationListener subscriptionNotificationListener : this.fS) {
            if (subscriptionNotificationListener == null) continue;
            try {
                subscriptionNotificationListener.onError(this, object, exception);
            }
            catch (Exception exception2) {
                logger.error("Exception while calling onError with listener=" + subscriptionNotificationListener, (Throwable)exception2);
            }
        }
    }

    protected void fireEvent(MonitoredEventItem monitoredEventItem, Variant[] variantArray) {
        for (SubscriptionNotificationListener subscriptionNotificationListener : this.fS) {
            if (subscriptionNotificationListener == null) continue;
            try {
                subscriptionNotificationListener.onEvent(this, monitoredEventItem, variantArray);
            }
            catch (Exception exception) {
                logger.error("Exception while calling onEvent with listener=" + subscriptionNotificationListener, (Throwable)exception);
            }
        }
    }

    protected void fireLifetimeTimeout() {
        for (SubscriptionAliveListener subscriptionAliveListener : this.fK) {
            if (subscriptionAliveListener == null) continue;
            try {
                subscriptionAliveListener.onLifetimeTimeout(this);
            }
            catch (Exception exception) {
                logger.error("Exception while calling onTimeout with listener=" + subscriptionAliveListener, (Throwable)exception);
            }
        }
    }

    protected long fireMissingData(UnsignedInteger unsignedInteger, long l2, long l3, StatusCode statusCode) {
        for (SubscriptionNotificationListener subscriptionNotificationListener : this.fS) {
            try {
                l3 = subscriptionNotificationListener.onMissingData(this, unsignedInteger, l2, l3, statusCode);
            }
            catch (Exception exception) {
                logger.error("Exception while calling onMissingData with listener=" + subscriptionNotificationListener, (Throwable)exception);
            }
        }
        return l3;
    }

    protected void fireNotification(NotificationData notificationData) {
        logger.debug("fireNotification");
        for (SubscriptionNotificationListener subscriptionNotificationListener : this.fS) {
            if (subscriptionNotificationListener == null) continue;
            try {
                subscriptionNotificationListener.onNotificationData(this, notificationData);
            }
            catch (Exception exception) {
                logger.error("Exception while calling onNotificationData with listener=" + subscriptionNotificationListener, (Throwable)exception);
            }
        }
    }

    protected void fireStatusChange(StatusCode statusCode, StatusCode statusCode2, DiagnosticInfo diagnosticInfo) {
        for (SubscriptionNotificationListener subscriptionNotificationListener : this.fS) {
            if (subscriptionNotificationListener == null) continue;
            try {
                subscriptionNotificationListener.onStatusChange(this, statusCode, statusCode2, diagnosticInfo);
            }
            catch (Exception exception) {
                logger.error("Exception while calling onStatusChange with listener=" + subscriptionNotificationListener, (Throwable)exception);
            }
        }
    }

    protected void fireTimeout() {
        for (SubscriptionAliveListener subscriptionAliveListener : this.fK) {
            if (subscriptionAliveListener == null) continue;
            try {
                subscriptionAliveListener.onTimeout(this);
            }
            catch (Exception exception) {
                logger.error("Exception while calling onTimeout with listener=" + subscriptionAliveListener, (Throwable)exception);
            }
        }
    }

    protected List<UnsignedInteger> getAvailableSequenceNumbersList() {
        a a2 = this.fP.get();
        if (a2 != null) {
            return a2.gb;
        }
        return Collections.emptyList();
    }

    protected MonitoringParameters getMonitoringParameters(MonitoredItemBase monitoredItemBase) {
        ExtensionObject extensionObject;
        try {
            extensionObject = monitoredItemBase.getFilter() == null ? null : ExtensionObject.binaryEncode(monitoredItemBase.getFilter(), this.em.getEncoderContext());
        }
        catch (EncodingException encodingException) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Cannot encode filter of item {%s.%s}", monitoredItemBase.getNodeId(), AttributesUtil.toString(monitoredItemBase.getAttributeId())), encodingException);
        }
        MonitoringParameters monitoringParameters = new MonitoringParameters(monitoredItemBase.getClientHandle(), monitoredItemBase.getSamplingInterval(), extensionObject, UnsignedInteger.valueOf(monitoredItemBase.getQueueSize()), monitoredItemBase.isDiscardOldest());
        return monitoringParameters;
    }

    protected void handleNotificationDatas() throws ServerConnectionException, ServiceException {
        Map.Entry<UnsignedInteger, ExtensionObject[]> entry;
        logger.debug("handleNotificationDatas: id={}, isConnected={}", (Object)this.getSubscriptionId(), (Object)this.isConnected());
        while ((entry = this.fT.pollFirstEntry()) != null) {
            boolean bl;
            logger.debug("handleNotificationDatas: entry={}", entry);
            UnsignedInteger unsignedInteger = entry.getKey();
            ExtensionObject[] extensionObjectArray = entry.getValue();
            long l2 = this.fN == null ? 0L : this.fN.longValue();
            boolean bl2 = bl = l2 - unsignedInteger.longValue() > fJ;
            if (bl) {
                logger.debug("handleNotificationDatas: need Republish: isOverflow");
                this.c(UnsignedInteger.MAX_VALUE.longValue());
                if (l2 > fJ) {
                    this.fN = UnsignedInteger.ZERO;
                    l2 = 0L;
                }
            }
            if (l2 == 0L || unsignedInteger.longValue() > l2 && unsignedInteger.longValue() - l2 < fJ) {
                logger.debug("handleNotificationDatas: need Republish? lastSeqNumber={} VS. sequenceNumber={}", (Object)l2, (Object)unsignedInteger.longValue());
                this.c(unsignedInteger.longValue() - 1L);
                if (this.isAliveNotification(extensionObjectArray)) {
                    logger.debug("handleNotificationDatas: this is Alive Notification");
                    this.fireAlive();
                } else {
                    logger.debug("handleNotificationDatas: calling handleNotificationData");
                    this.a(extensionObjectArray);
                    this.acknowledge(unsignedInteger);
                    logger.debug("handleNotificationDatas: calling handleNotificationData ended, setting new lastSequenceNumber {}", (Object)unsignedInteger);
                    this.fN = unsignedInteger;
                }
                logger.debug("handleNotificationDatas: leaving, lastSequenceNumber={} lastAlive={}", (Object)this.fN, (Object)this.fL);
                continue;
            }
            if (l2 <= 0L) continue;
            logger.warn("Server sent a previously acknowledged sequence number {} for Subscription {}", (Object)unsignedInteger, (Object)this.getSubscriptionId());
        }
        this.e(this.fN);
    }

    protected boolean hasPublishResponses() {
        return !this.fT.isEmpty();
    }

    protected boolean isAliveNotification(ExtensionObject[] extensionObjectArray) {
        return extensionObjectArray.length == 0;
    }

    protected void itemChanged(MonitoredItem monitoredItem) throws ServiceException {
        if (!this.isConnected()) {
            monitoredItem.clearModified();
        } else if (this.updateCount == 0) {
            this.updateItems();
        }
    }

    protected ModifyMonitoredItemsResponse modifyMonitoredItems(List<MonitoredItem> list) throws ServiceException {
        if (this.serverConnected() && list.size() > 0) {
            int n2;
            if (logger.isDebugEnabled()) {
                logger.debug("modifyMonitoredItems: getSubscriptionId()={}; items={}", (Object)this.getSubscriptionId(), (Object)Arrays.toString(list.toArray()));
            }
            if ((n2 = this.getMaxMonitoredItemsPerCall()) > 0 && n2 < list.size()) {
                ResponseHeader responseHeader = null;
                MonitoredItemModifyResult[] monitoredItemModifyResultArray = new MonitoredItemModifyResult[list.size()];
                DiagnosticInfo[] diagnosticInfoArray = new DiagnosticInfo[list.size()];
                for (int i2 = 0; i2 < list.size(); i2 += n2) {
                    int n3 = Math.min(n2, list.size() - i2);
                    List<MonitoredItem> list2 = list.subList(i2, i2 + n3);
                    ModifyMonitoredItemsResponse modifyMonitoredItemsResponse = this.d(list2);
                    responseHeader = modifyMonitoredItemsResponse.getResponseHeader();
                    for (int i3 = 0; i3 < n3; ++i3) {
                        monitoredItemModifyResultArray[i2 + i3] = modifyMonitoredItemsResponse.getResults()[i3];
                    }
                    DiagnosticInfo[] diagnosticInfoArray2 = modifyMonitoredItemsResponse.getDiagnosticInfos();
                    if (diagnosticInfoArray2 == null || diagnosticInfoArray2.length <= 0) continue;
                    for (int i4 = 0; i4 < n3; ++i4) {
                        diagnosticInfoArray[i2 + i4] = diagnosticInfoArray2[i4];
                    }
                }
                return new ModifyMonitoredItemsResponse(responseHeader, monitoredItemModifyResultArray, diagnosticInfoArray);
            }
            return this.d(list);
        }
        return null;
    }

    protected void monitoringModeChanged(MonitoredItem monitoredItem) throws ServiceException {
        if (this.updateCount == 0) {
            this.updateMonitoringModes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onPublishResponse(PublishResponse publishResponse) {
        if (this.em == null) {
            logger.debug("onPublishResponse: client is null, therefore skipping processing because this subscription has been removed from the client");
            return;
        }
        if (publishResponse.getNotificationMessage() != null) {
            UnsignedInteger unsignedInteger;
            if (logger.isDebugEnabled()) {
                logger.debug("onPublishResponse: entering, SubscriptionID={} SequenceNumber={}", (Object)publishResponse.getSubscriptionId(), (Object)publishResponse.getNotificationMessage().getSequenceNumber());
            }
            if ((unsignedInteger = publishResponse.getNotificationMessage().getSequenceNumber()) != null) {
                Map.Entry<UnsignedInteger, ExtensionObject[]> entry;
                long l2;
                this.fL = Instant.now();
                ExtensionObject[] extensionObjectArray = publishResponse.getNotificationMessage().getNotificationData();
                if (extensionObjectArray == null || extensionObjectArray.length == 0) {
                    extensionObjectArray = fI;
                }
                Subscription.a(this.fT, unsignedInteger, extensionObjectArray);
                this.a(unsignedInteger, publishResponse.getAvailableSequenceNumbers());
                logger.debug("onPublishResponse: responseQueue.size()={}", (Object)this.fT.size());
                UnsignedInteger unsignedInteger2 = this.getLastSequenceNumber();
                long l3 = unsignedInteger2 == null ? 0L : unsignedInteger2.getValue();
                long l4 = l2 = l3 == UnsignedInteger.MAX_VALUE.longValue() ? 1L : l3 + 1L;
                if (l3 == 0L || unsignedInteger.getValue() == l2) {
                    entry = this.em;
                    if (entry == null) {
                        return;
                    }
                    UaClient.f f2 = ((UaClient)((Object)entry)).gH;
                    if (f2 != null) {
                        UaClient.f f3 = f2;
                        synchronized (f3) {
                            f2.notify();
                        }
                    }
                }
                while (this.fT.size() > this.fR) {
                    entry = this.fT.pollFirstEntry();
                    if (entry == null) continue;
                    this.fireBufferOverflow((UnsignedInteger)entry.getKey(), (ExtensionObject[])entry.getValue());
                }
            } else {
                logger.debug("onPublishResponse: sequenceNumber=null");
            }
        }
    }

    @Override
    protected void paramChanged() throws ServiceException {
        if (this.isConnected()) {
            if (this.updateCount == 0) {
                this.applyUpdates();
            } else {
                this.modified = true;
            }
        }
    }

    protected void recreateMonitoredItems() {
        if (this.em == null || !this.em.getServerState().equals(ServerState.Running)) {
            return;
        }
        if (!this.isRecreateFailedItems()) {
            return;
        }
        MonitoredItemBase[] monitoredItemBaseArray = this.getItems();
        if (monitoredItemBaseArray.length == 0) {
            return;
        }
        logger.trace("recreateMonitoredItems, Subscription id: {}", (Object)this.getSubscriptionId());
        ArrayList<MonitoredItem> arrayList = new ArrayList<MonitoredItem>();
        for (MonitoredItemBase monitoredItemBase : monitoredItemBaseArray) {
            MonitoredItem monitoredItem = (MonitoredItem)monitoredItemBase;
            logger.trace("recreateMonitoredItems, checking MonitoredItem: {}", (Object)monitoredItem);
            if (StatusCode.valueOf(StatusCodes.Bad_NodeIdUnknown).equals(monitoredItem.getInitialStatus()) || !StatusCode.valueOf(StatusCodes.Bad_NodeIdUnknown).equals(monitoredItem.getErrorCode())) continue;
            logger.debug("Item to be recreated: {}, initialStatus = {}, errorCode = {}", new Object[]{monitoredItem.getExpandedNodeId() != null ? monitoredItem.getExpandedNodeId() : monitoredItem.getNodeId(), monitoredItem.getInitialStatus(), monitoredItem.getErrorCode()});
            arrayList.add(monitoredItem);
        }
        if (!arrayList.isEmpty()) {
            try {
                logger.info("Subscription id {}, retrying {} previously failed items", (Object)this.getSubscriptionId(), (Object)arrayList.size());
                this.em.getNamespaceTable(true);
                this.createMonitoredItems(arrayList.toArray(new MonitoredItem[0]));
            }
            catch (ServiceException | StatusException uaException) {
                logger.warn("Caught Exception when recreating MonitoredItems", (Throwable)uaException);
            }
        }
    }

    protected void reset() {
        this.em = null;
        super.setSubscriptionId(null);
        this.fL = null;
        this.fW = false;
        this.fX = true;
        this.fN = UnsignedInteger.ZERO;
        this.setAvailableSequenceNumbers(null);
    }

    protected boolean serverConnected() {
        return this.em != null && this.em.isConnected();
    }

    protected void setAlive(boolean bl) {
        if (this.fX != bl) {
            this.fX = bl;
            if (!bl) {
                this.fireLifetimeTimeout();
            }
        }
    }

    protected void setClient(UaClient uaClient) {
        if (this.em != uaClient) {
            this.em = uaClient;
        }
    }

    protected SetMonitoringModeResponse setMonitoringMode(MonitoringMode monitoringMode, List<MonitoredItem> list) throws ServiceException {
        if (this.serverConnected() && list.size() > 0) {
            int n2;
            if (logger.isDebugEnabled()) {
                logger.debug("modifyMonitoredItems: getSubscriptionId()={}; items={}", (Object)this.getSubscriptionId(), list);
            }
            if ((n2 = this.getMaxMonitoredItemsPerCall()) > 0 && n2 < list.size()) {
                ResponseHeader responseHeader = null;
                StatusCode[] statusCodeArray = new StatusCode[list.size()];
                DiagnosticInfo[] diagnosticInfoArray = new DiagnosticInfo[list.size()];
                for (int i2 = 0; i2 < list.size(); i2 += n2) {
                    int n3 = Math.min(n2, list.size() - i2);
                    List<MonitoredItem> list2 = list.subList(i2, i2 + n3);
                    SetMonitoringModeResponse setMonitoringModeResponse = this.a(monitoringMode, list2);
                    responseHeader = setMonitoringModeResponse.getResponseHeader();
                    for (int i3 = 0; i3 < n3; ++i3) {
                        statusCodeArray[i2 + i3] = setMonitoringModeResponse.getResults()[i3];
                    }
                    DiagnosticInfo[] diagnosticInfoArray2 = setMonitoringModeResponse.getDiagnosticInfos();
                    if (diagnosticInfoArray2 == null || diagnosticInfoArray2.length <= 0) continue;
                    for (int i4 = 0; i4 < n3; ++i4) {
                        diagnosticInfoArray[i2 + i4] = diagnosticInfoArray2[i4];
                    }
                }
                return new SetMonitoringModeResponse(responseHeader, statusCodeArray, diagnosticInfoArray);
            }
            return this.a(monitoringMode, list);
        }
        return null;
    }

    protected void setSubscriptionId(int n2) {
        this.setSubscriptionId(UnsignedInteger.valueOf(n2));
    }

    @Override
    protected void setSubscriptionId(UnsignedInteger unsignedInteger) {
        super.setSubscriptionId(unsignedInteger);
        if (unsignedInteger == null || unsignedInteger.getValue() == 0L) {
            this.reset();
        }
    }

    protected void setTimeout(boolean bl) {
        if (bl != this.fW) {
            this.fW = bl;
            if (this.fW) {
                this.fireTimeout();
            }
        }
    }

    protected void transferTo(UaClient uaClient, UnsignedInteger unsignedInteger, boolean bl) throws ServiceException, StatusException {
        if (this.em != uaClient) {
            if (this.isConnected()) {
                if (uaClient.isConnected()) {
                    TransferSubscriptionsResponse transferSubscriptionsResponse;
                    UnsignedInteger[] unsignedIntegerArray = new UnsignedInteger[]{unsignedInteger};
                    try {
                        transferSubscriptionsResponse = uaClient.ciq().TransferSubscriptions(uaClient.getRequestHeader(), unsignedIntegerArray, bl);
                    }
                    catch (ServiceFaultException serviceFaultException) {
                        throw new ServiceException(serviceFaultException);
                    }
                    catch (ServiceResultException serviceResultException) {
                        throw new ServiceException(serviceResultException);
                    }
                    this.checkServiceResult(transferSubscriptionsResponse, transferSubscriptionsResponse.getDiagnosticInfos());
                    this.checkOperationResult(transferSubscriptionsResponse.getResults()[0].getStatusCode());
                    this.setAvailableSequenceNumbers(transferSubscriptionsResponse.getResults()[0].getAvailableSequenceNumbers());
                }
                if (this.em != null) {
                    this.em.hd.remove(this);
                }
                uaClient.hd.add(this);
            }
            this.setClient(uaClient);
        }
    }

    protected void updateSubscription() throws ServiceException {
        if (this.serverConnected()) {
            this.em.a((SubscriptionBase)this);
        }
        this.modified = false;
    }

    private static class a {
        private final List<UnsignedInteger> gb;
        private final long gc;

        public a(UnsignedInteger[] unsignedIntegerArray, long l2) {
            this.gb = Arrays.asList(unsignedIntegerArray);
            this.gc = l2;
        }
    }
}

