/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua;

import com.prosysopc.ua.UaException;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.common.ServiceFaultException;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.ServiceFault;
import com.prosysopc.ua.stack.core.StatusCodes;
import java.util.Locale;

public class StatusException
extends UaException {
    private final DiagnosticInfo cs;
    private final StatusCode statusCode;

    public static DiagnosticInfo toDiagnosticInfo(ServiceFault serviceFault) {
        return serviceFault == null ? null : serviceFault.getResponseHeader().getServiceDiagnostics();
    }

    public StatusException(ServiceFaultException serviceFaultException) {
        this(serviceFaultException.getMessage(), serviceFaultException);
    }

    public StatusException(ServiceResultException serviceResultException) {
        this(serviceResultException.getMessage(), serviceResultException);
    }

    public StatusException(StatusCode statusCode) {
        super(statusCode.toString());
        this.statusCode = statusCode;
        this.cs = null;
    }

    public StatusException(StatusCode statusCode, DiagnosticInfo diagnosticInfo) {
        this(statusCode.toString(), statusCode, diagnosticInfo, null);
    }

    public StatusException(StatusCode statusCode, Throwable throwable) {
        super(statusCode.toString(), throwable);
        this.statusCode = statusCode;
        this.cs = StatusException.toDiagnosticInfo(ServiceFaultException.toServiceFault(throwable));
    }

    public StatusException(String string) {
        this(string, StatusCodes.Bad_UnexpectedError);
    }

    public StatusException(String string, ServiceFaultException serviceFaultException) {
        this(string, serviceFaultException.getStatusCode(), StatusException.toDiagnosticInfo(serviceFaultException.getServiceFault()), (Throwable)serviceFaultException);
    }

    public StatusException(String string, ServiceResultException serviceResultException) {
        this(string, serviceResultException.getStatusCode(), null, (Throwable)serviceResultException);
    }

    public StatusException(String string, StatusCode statusCode) {
        super(string);
        this.statusCode = statusCode;
        this.cs = new DiagnosticInfo(string, null, null, null, null, null, null);
    }

    public StatusException(String string, StatusCode statusCode, DiagnosticInfo diagnosticInfo, Throwable throwable) {
        super(string, throwable);
        this.statusCode = statusCode;
        this.cs = diagnosticInfo;
    }

    public StatusException(String string, Throwable throwable) {
        this(string, StatusCodes.Bad_UnexpectedError, null, throwable);
    }

    public StatusException(String string, UnsignedInteger unsignedInteger) {
        this(string, StatusCode.valueOf(unsignedInteger));
    }

    public StatusException(String string, UnsignedInteger unsignedInteger, DiagnosticInfo diagnosticInfo, Throwable throwable) {
        this(string, StatusCode.valueOf(unsignedInteger), diagnosticInfo, throwable);
    }

    public StatusException(UnsignedInteger unsignedInteger) {
        this(StatusCode.valueOf(unsignedInteger));
    }

    public StatusException(UnsignedInteger unsignedInteger, DiagnosticInfo diagnosticInfo) {
        this(unsignedInteger.toString(), unsignedInteger, diagnosticInfo, null);
    }

    public StatusException(UnsignedInteger unsignedInteger, Throwable throwable) {
        this(StatusCode.valueOf(unsignedInteger), throwable);
    }

    public DiagnosticInfo getDiagnosticInfo() {
        return this.cs;
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    @Override
    public String toString() {
        String string;
        String string2 = string = this.cs == null ? "" : this.cs.toString();
        if (string.length() > 0) {
            string = " Diagnostics=" + string;
        }
        return String.format(Locale.ROOT, "%s StatusCode=%s%s", super.toString(), this.statusCode, string);
    }
}

