/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua;

import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.core.MonitoringFilter;
import com.prosysopc.ua.stack.core.MonitoringFilterResult;
import com.prosysopc.ua.stack.core.MonitoringMode;
import com.prosysopc.ua.stack.utils.AttributesUtil;
import com.prosysopc.ua.stack.utils.NumericRange;
import java.util.Locale;

public abstract class MonitoredItemBase {
    protected static int maxQueueSize = 1000000;
    private MonitoringFilter cc = null;
    private MonitoringFilterResult cd;
    protected final UnsignedInteger attributeId;
    protected UnsignedInteger clientHandle;
    protected final QualifiedName dataEncoding;
    protected boolean discardOldest = false;
    protected UnsignedInteger monitoredItemId;
    protected volatile MonitoringMode monitoringMode = MonitoringMode.Disabled;
    protected volatile MonitoringMode prevMonitoringMode = null;
    protected final NodeId nodeId;
    protected long queueSize;
    private volatile Object ce;

    public MonitoredItemBase(UnsignedInteger unsignedInteger, UnsignedInteger unsignedInteger2, NodeId nodeId, UnsignedInteger unsignedInteger3, MonitoringMode monitoringMode) {
        this.clientHandle = unsignedInteger;
        this.monitoredItemId = unsignedInteger2;
        this.nodeId = nodeId;
        this.attributeId = unsignedInteger3;
        this.dataEncoding = null;
        this.monitoringMode = monitoringMode;
        this.queueSize = this.getDefaultQueueSize();
    }

    public void close() {
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        MonitoredItemBase monitoredItemBase = (MonitoredItemBase)object;
        if (this.monitoredItemId == null ? monitoredItemBase.monitoredItemId != null : !this.monitoredItemId.equals(monitoredItemBase.monitoredItemId)) {
            return false;
        }
        if (this.nodeId == null ? monitoredItemBase.nodeId != null : !this.nodeId.equals(monitoredItemBase.nodeId)) {
            return false;
        }
        if (this.attributeId == null ? monitoredItemBase.attributeId != null : !this.attributeId.equals(monitoredItemBase.attributeId)) {
            return false;
        }
        return !(this.clientHandle == null ? monitoredItemBase.clientHandle != null : !this.clientHandle.equals(monitoredItemBase.clientHandle));
    }

    public UnsignedInteger getAttributeId() {
        return this.attributeId;
    }

    public UnsignedInteger getClientHandle() {
        return this.clientHandle;
    }

    public QualifiedName getDataEncoding() {
        return this.dataEncoding;
    }

    public MonitoringFilter getFilter() {
        return this.cc;
    }

    public MonitoringFilterResult getFilterResult() {
        return this.cd;
    }

    public NumericRange getIndexRange() {
        return null;
    }

    public UnsignedInteger getMonitoredItemId() {
        return this.monitoredItemId;
    }

    public MonitoringMode getMonitoringMode() {
        return this.monitoringMode;
    }

    public NodeId getNodeId() {
        return this.nodeId;
    }

    public long getQueueSize() {
        return this.queueSize;
    }

    public double getSamplingInterval() {
        return 0.0;
    }

    public Object getUserData() {
        return this.ce;
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.attributeId == null ? 0 : this.attributeId.hashCode());
        n3 = 31 * n3 + (this.nodeId == null ? 0 : this.nodeId.hashCode());
        return n3;
    }

    public boolean isDiscardOldest() {
        return this.discardOldest;
    }

    public void setDiscardOldest(boolean bl) {
        this.discardOldest = bl;
    }

    public void setMonitoringMode(MonitoringMode monitoringMode) throws ServiceException {
        if (monitoringMode == null) {
            throw new NullPointerException("monitoringMode");
        }
        MonitoringMode monitoringMode2 = this.monitoringMode;
        if (monitoringMode2 != monitoringMode) {
            this.prevMonitoringMode = monitoringMode2;
            this.monitoringMode = monitoringMode;
            this.monitoringModeChanged();
            this.updateQueue();
        }
    }

    public void setQueueSize(long l2) throws ServiceException {
        this.setQueueSize(UnsignedInteger.valueOf(l2));
    }

    public void setQueueSize(UnsignedInteger unsignedInteger) throws ServiceException {
        long l2 = unsignedInteger.getValue();
        if (l2 == 0L) {
            l2 = this.getDefaultQueueSize();
        } else if (l2 > (long)maxQueueSize) {
            l2 = maxQueueSize;
        }
        if (l2 != this.queueSize) {
            this.queueSize = l2;
            this.updateQueue();
        }
    }

    public void setUserData(Object object) {
        this.ce = object;
    }

    public String toString() {
        return String.format(Locale.ROOT, "ClientHandle=%s, MonitoredItemId=%s, NodeId=%s, AttributeId=%s", this.clientHandle, this.monitoredItemId, this.getNodeIdAsString(), AttributesUtil.toString(this.attributeId));
    }

    protected abstract long getDefaultQueueSize();

    protected String getNodeIdAsString() {
        if (this.nodeId != null) {
            return this.nodeId.toString();
        }
        return null;
    }

    protected MonitoringMode getPrevMonitoringMode() {
        return this.prevMonitoringMode;
    }

    protected void monitoringModeChanged() throws ServiceException {
    }

    protected void setFilter(MonitoringFilter monitoringFilter) throws ServiceException {
        if (monitoringFilter == null && this.cc == null) {
            return;
        }
        if (monitoringFilter != null && monitoringFilter.equals(this.cc)) {
            return;
        }
        this.cc = monitoringFilter;
        this.updateFilter();
    }

    protected void setFilterResult(MonitoringFilterResult monitoringFilterResult) {
        this.cd = monitoringFilterResult;
    }

    protected void setMonitoredItemId(UnsignedInteger unsignedInteger) {
        this.monitoredItemId = unsignedInteger;
    }

    protected void updateFilter() throws ServiceException {
    }

    protected void updateQueue() throws ServiceException {
    }
}

