/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua;

import com.prosysopc.ua.ModelException;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.UaApplication;
import com.prosysopc.ua.UaArrayDimensions;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.UaOptionSet;
import com.prosysopc.ua.nodes.UaDataType;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.ExtensionObject;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.builtintypes.XmlElement;
import com.prosysopc.ua.stack.common.NamespaceTable;
import com.prosysopc.ua.stack.common.ServerTable;
import com.prosysopc.ua.stack.core.AccessLevelType;
import com.prosysopc.ua.stack.core.AddNodesItem;
import com.prosysopc.ua.stack.core.AddReferencesItem;
import com.prosysopc.ua.stack.core.DataTypeAttributes;
import com.prosysopc.ua.stack.core.DataTypeIdentifiers;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.stack.core.MethodAttributes;
import com.prosysopc.ua.stack.core.NodeAttributes;
import com.prosysopc.ua.stack.core.NodeClass;
import com.prosysopc.ua.stack.core.ObjectAttributes;
import com.prosysopc.ua.stack.core.ObjectTypeAttributes;
import com.prosysopc.ua.stack.core.ReferenceTypeAttributes;
import com.prosysopc.ua.stack.core.ReferenceTypeIdentifiers;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.core.VariableAttributes;
import com.prosysopc.ua.stack.core.VariableTypeAttributes;
import com.prosysopc.ua.stack.core.ViewAttributes;
import com.prosysopc.ua.stack.encoding.DecodingException;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.encoding.xml.XmlDecoder;
import com.prosysopc.ua.stack.utils.MultiDimensionArrayUtils;
import com.prosysopc.ua.stack.utils.OSUtil;
import com.prosysopc.ua.stack.utils.XMLFactoryCache;
import com.prosysopc.ua.typedictionary.DynamicOptionSetStructure;
import com.prosysopc.ua.typedictionary.DynamicStructure;
import com.prosysopc.ua.typedictionary.DynamicUIntOptionSet;
import com.prosysopc.ua.typedictionary.EnumerationSpecification;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.OptionSetSpecification;
import com.prosysopc.ua.typedictionary.OptionSetStructureSpecification;
import com.prosysopc.ua.typedictionary.OptionSpecification;
import com.prosysopc.ua.typedictionary.SimpleTypeSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public abstract class ModelParserBase {
    public static final String UTF8_BOM = "\ufeff";
    private static final boolean aC = OSUtil.isAndroid();
    private static boolean aD = false;
    private static final Logger logger = LoggerFactory.getLogger(ModelParserBase.class);
    private String alias;
    private final HashMap<String, NodeId> aE = new HashMap();
    private final UaApplication aF;
    private boolean aG;
    private final Set<ExpandedNodeId> aH = new TreeSet<ExpandedNodeId>();
    private String aI;
    private String aJ;
    private final NamespaceTable aK;
    private Locator locator;
    private final d aL = new d();
    private final Set<UaNodeId> aM = new HashSet<UaNodeId>();
    private AddNodesItem aN;
    private NodeAttributes aO;
    private AddReferencesItem aP;
    private final List<AddReferencesItem> aQ = new ArrayList<AddReferencesItem>();
    private final List<AddNodesItem> nodes = new ArrayList<AddNodesItem>();
    private final StringBuilder aR = new StringBuilder();
    private b aS;
    private boolean aT;
    private XMLReader reader;
    private int aU = 0;
    private boolean aV;
    private int aW = 0;
    private final List<AddReferencesItem> aX = new ArrayList<AddReferencesItem>();
    private final UnsignedInteger aY = UnsignedInteger.ZERO;
    private TransformerHandler aZ;
    private DOMResult ba;
    List<String> aA = new ArrayList<String>();
    private final List<VariableAttributes> bb = new ArrayList<VariableAttributes>();
    private final List<VariableTypeAttributes> bc = new ArrayList<VariableTypeAttributes>();
    private Map<UaNodeId, StructureSpecification> bd = new HashMap<UaNodeId, StructureSpecification>();
    private Map<UaNodeId, e> be = new HashMap<UaNodeId, e>();
    private Map<UaNodeId, UaNodeId> bf = new HashMap<UaNodeId, UaNodeId>();
    private Map<UaNodeId, UaNodeId> bg = new HashMap<UaNodeId, UaNodeId>();
    private Map<UaNodeId, UaNodeId> bh = new HashMap<UaNodeId, UaNodeId>();
    private Set<UaNodeId> bi = new HashSet<UaNodeId>();
    private Map<UaNodeId, UaNodeId> bj = new HashMap<UaNodeId, UaNodeId>();
    private Map<UaNodeId, UaNodeId> bk = new HashMap<UaNodeId, UaNodeId>();
    private Map<UaNodeId, UaNodeId> bl = new HashMap<UaNodeId, UaNodeId>();

    public static boolean isSkipValuesOnAndroid() {
        return aD;
    }

    public static void setSkipValuesOnAndroid(boolean bl) {
        aD = bl;
    }

    public ModelParserBase(UaApplication uaApplication) {
        this.aF = uaApplication;
        this.aK = new NamespaceTable();
    }

    public void createModel(boolean bl) throws ModelException, ServiceException {
        logger.debug("Starting model creation..");
        this.setFailOnFirstError(bl);
        ArrayList<AddNodesItem> arrayList = new ArrayList<AddNodesItem>();
        ArrayList<AddNodesItem> arrayList2 = new ArrayList<AddNodesItem>();
        ArrayList<AddNodesItem> arrayList3 = new ArrayList<AddNodesItem>();
        ArrayList<AddNodesItem> arrayList4 = new ArrayList<AddNodesItem>();
        ArrayList<AddNodesItem> arrayList5 = new ArrayList<AddNodesItem>();
        ArrayList<AddNodesItem> arrayList6 = new ArrayList<AddNodesItem>();
        ArrayList<AddNodesItem> arrayList7 = new ArrayList<AddNodesItem>();
        ArrayList<AddNodesItem> arrayList8 = new ArrayList<AddNodesItem>();
        block10: for (AddNodesItem cloneable2 : this.nodes) {
            if (this.aH.contains(cloneable2.getRequestedNewNodeId())) {
                logger.debug("ignored: {} NodeId={}", (Object)cloneable2.getBrowseName(), (Object)cloneable2.getRequestedNewNodeId());
                continue;
            }
            if (cloneable2.getNodeClass() == null) {
                arrayList5.add(cloneable2);
                continue;
            }
            switch (cloneable2.getNodeClass()) {
                case ReferenceType: {
                    arrayList.add(cloneable2);
                    continue block10;
                }
                case DataType: {
                    arrayList2.add(cloneable2);
                    continue block10;
                }
                case Method: {
                    arrayList8.add(cloneable2);
                    continue block10;
                }
                case Object: {
                    arrayList3.add(cloneable2);
                    continue block10;
                }
                case ObjectType: {
                    arrayList6.add(cloneable2);
                    continue block10;
                }
                case Variable: {
                    arrayList4.add(cloneable2);
                    continue block10;
                }
                case VariableType: {
                    arrayList7.add(cloneable2);
                    continue block10;
                }
                case View: {
                    arrayList5.add(cloneable2);
                    continue block10;
                }
            }
            logger.warn("Encountered unkown NodeClass, ignoring node: " + cloneable2.getNodeClass());
        }
        ArrayList arrayList9 = new ArrayList();
        ArrayList<AddReferencesItem> arrayList10 = new ArrayList<AddReferencesItem>();
        for (AddReferencesItem addReferencesItem : this.aX) {
            if (this.aM.contains(UaNodeId.fromLocal(addReferencesItem.getSourceNodeId(), this.aF.getNamespaceTable()))) {
                if (ReferenceTypeIdentifiers.HasSubtype.equals(addReferencesItem.getReferenceTypeId())) {
                    arrayList9.add(addReferencesItem);
                    continue;
                }
                arrayList10.add(addReferencesItem);
                continue;
            }
            arrayList10.add(addReferencesItem);
        }
        this.addNodes(arrayList, "ReferenceTypes");
        this.addNodes(arrayList2, "DataTypes");
        this.addReferences(arrayList9);
        this.q();
        this.r();
        this.addNodes(arrayList6, "ObjectTypeNodes");
        this.addNodes(arrayList7, "VariableTypeNodes");
        this.addNodes(arrayList3, "ObjectNodes");
        this.addNodes(arrayList4, "VariableNodes");
        this.addNodes(arrayList5, "OtherNodes");
        this.addNodes(arrayList8, "MethodNodes");
        this.addReferences(arrayList10);
        for (AddNodesItem addNodesItem : arrayList3) {
            this.afterCreate(addNodesItem);
        }
        logger.debug("createModel: done. Errors={}", (Object)this.aA.size());
        if (!this.aA.isEmpty()) {
            throw new ModelException(this.aA);
        }
    }

    public EncoderContext getEncoderContext() {
        return this.aF.getEncoderContext();
    }

    public List<String> getErrorList() {
        return this.aA;
    }

    public Collection<ExpandedNodeId> getIgnoredNodes() {
        return this.aH;
    }

    public List<AddNodesItem> getNodes() {
        return this.nodes;
    }

    public List<AddReferencesItem> getReferences() {
        return this.aX;
    }

    public boolean isFailOnFirstError() {
        return this.aG;
    }

    public boolean isReadingExtensions() {
        return this.aU > 0;
    }

    public void parseFile(InputStream inputStream) throws IOException, SAXException, ModelException {
        this.parseFile(inputStream, StandardCharsets.UTF_8);
    }

    public void parseFile(InputStream inputStream, Charset charset) throws IOException, SAXException, ModelException {
        logger.debug("parseFile: charset={}" + charset);
        this.aI = "stream";
        this.reader = XMLReaderFactory.createXMLReader();
        this.reader.setContentHandler(this.aL);
        this.reader.setErrorHandler(this.aL);
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        inputStream.mark(10);
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, charset);
        logger.debug("encoding={}", (Object)inputStreamReader.getEncoding());
        char[] cArray = new char[2];
        inputStreamReader.read(cArray, 0, inputStreamReader.getEncoding().equals("UTF8") ? 1 : 2);
        if (logger.isDebugEnabled()) {
            logger.debug(String.format(Locale.ROOT, "cbuf=%04x %04x bom=%04x", (int)cArray[0], (int)cArray[1], (int)UTF8_BOM.charAt(0)));
        }
        if (cArray[0] != UTF8_BOM.charAt(0)) {
            inputStream.reset();
            inputStreamReader = new InputStreamReader(inputStream, charset);
        }
        this.reader.parse(new InputSource(inputStreamReader));
        if (!this.aA.isEmpty()) {
            throw new ModelException(this.aA);
        }
    }

    public void parseFile(URI uRI) throws SAXException, IOException, ModelException {
        if (logger.isDebugEnabled()) {
            logger.debug("parseFile:" + uRI);
        }
        this.aI = uRI.toString();
        InputStream inputStream = uRI.toURL().openStream();
        this.parseFile(inputStream);
    }

    public void setFailOnFirstError(boolean bl) {
        this.aG = bl;
    }

    public void setIgnoredNodes(Collection<ExpandedNodeId> collection) {
        if (collection != null) {
            this.aH.addAll(collection);
        }
    }

    private void a(AddNodesItem addNodesItem) throws ModelException {
        try {
            NodeId nodeId = this.doAddNode(addNodesItem);
            if (!nodeId.getValue().equals(addNodesItem.getRequestedNewNodeId().getValue())) {
                logger.warn("addNode: {} requested NodeId={} actual NodeId={}", new Object[]{addNodesItem.getBrowseName(), addNodesItem.getRequestedNewNodeId(), nodeId});
            } else {
                logger.debug("addNode:{} requested NodeId={}", (Object)addNodesItem.getBrowseName(), (Object)addNodesItem.getRequestedNewNodeId());
            }
        }
        catch (Exception exception) {
            this.a(this.aG, this.aA, exception, "Failed to create node: " + addNodesItem.getBrowseName() + " with id:" + addNodesItem.getRequestedNewNodeId());
        }
    }

    private void addReference(AddReferencesItem addReferencesItem) throws ModelException {
        block3: {
            try {
                this.doAddReference(addReferencesItem);
                if (logger.isDebugEnabled()) {
                    logger.debug("createModel: Adding refitem: " + addReferencesItem.getSourceNodeId() + " --> " + addReferencesItem.getTargetNodeId() + " forward:" + addReferencesItem.getIsForward() + " type: " + addReferencesItem.getReferenceTypeId());
                }
            }
            catch (Exception exception) {
                if (this.isIgnoredReference(addReferencesItem)) break block3;
                this.a(this.aG, this.aA, exception, "Failed to create reference: " + addReferencesItem.getSourceNodeId() + "--->" + addReferencesItem.getTargetNodeId() + " forward:" + addReferencesItem.getIsForward() + " type: " + addReferencesItem.getReferenceTypeId());
            }
        }
    }

    private void c(Variant variant) {
        if (this.aO != null) {
            logger.debug("addValue: {}", (Object)variant);
            if (this.aO instanceof VariableAttributes) {
                ((VariableAttributes)this.aO).setValue(variant.getValue());
                if (variant.getValue() != null && variant.getValue() instanceof ExtensionObject && ((ExtensionObject)variant.getValue()).isEncoded()) {
                    this.bb.add((VariableAttributes)this.aO);
                }
            }
            if (this.aO instanceof VariableTypeAttributes) {
                ((VariableTypeAttributes)this.aO).setValue(variant.getValue());
                if (variant.getValue() != null && variant.getValue() instanceof ExtensionObject && ((ExtensionObject)variant.getValue()).isEncoded()) {
                    this.bc.add((VariableTypeAttributes)this.aO);
                }
            }
        }
    }

    private void f() {
        this.aE.put(this.alias, this.a(this.aR.toString(), false));
    }

    private void a(Attributes attributes) {
        this.aN = this.g(attributes);
        this.aO = this.b(attributes);
        this.aN.setNodeClass(NodeClass.DataType);
    }

    private NodeAttributes b(Attributes attributes) {
        DataTypeAttributes dataTypeAttributes = new DataTypeAttributes();
        this.a(attributes, dataTypeAttributes);
        dataTypeAttributes.setIsAbstract(this.a(attributes, "IsAbstract", false));
        return dataTypeAttributes;
    }

    private void c(Attributes attributes) {
        this.aS = new b();
        this.aS.isUnion = this.a(attributes, "IsUnion", false);
        this.aS.isOptionSet = this.a(attributes, "IsOptionSet", false);
    }

    private void d(Attributes attributes) {
        if (this.aS == null) {
            logger.warn("Field tag outside of Definition block, ignoring..");
            return;
        }
        a a2 = new a();
        a2.name = this.b(attributes, "Name", "");
        String string = this.b(attributes, "Value", null);
        if (string == null || string.isEmpty()) {
            String string2 = this.b(attributes, "DataType", "i=24");
            a2.bo = this.a(string2, true);
            a2.bp = this.a(attributes, "IsOptional", false);
            a2.bt = this.a(attributes, "AllowSubTypes", false);
            a2.br = this.a(attributes, "ValueRank", -1);
            if (a2.br >= 1) {
                String string3 = Arrays.toString(new int[a2.br.intValue()]);
                string3 = string3.substring(1, string3.length() - 1);
                string3 = string3.replaceAll("\\s", "");
                a2.bs = this.a(attributes, "ArrayDimensions", string3);
            }
        } else {
            a2.bq = this.a(attributes, "Value", -1);
        }
        this.aS.fields.add(a2);
    }

    private void e(Attributes attributes) {
        this.aN = this.g(attributes);
        this.aO = this.f(attributes);
        this.aN.setNodeClass(NodeClass.Method);
    }

    private NodeAttributes f(Attributes attributes) {
        MethodAttributes methodAttributes = new MethodAttributes();
        this.a(attributes, methodAttributes);
        methodAttributes.setExecutable(this.a(attributes, "Executable", true));
        methodAttributes.setUserExecutable(this.a(attributes, "UserExecutable", true));
        return methodAttributes;
    }

    private void a(boolean bl, List<String> list, Exception exception, String string) throws ModelException {
        logger.warn("createModel: " + string + " ", (Throwable)exception);
        if (bl) {
            if (this.locator != null) {
                throw new ModelException(string, exception, this.locator.getLineNumber());
            }
            throw new ModelException(string, exception);
        }
        if (this.locator != null) {
            list.add(string + exception + " (near line " + this.locator.getLineNumber() + ")");
        } else {
            list.add(string + exception);
        }
    }

    private AddNodesItem g(Attributes attributes) {
        AddNodesItem addNodesItem = new AddNodesItem();
        ExpandedNodeId expandedNodeId = this.a(attributes, "NodeId");
        if (expandedNodeId == null) {
            throw new NullPointerException("createNode: NodeId should not be null");
        }
        addNodesItem.setRequestedNewNodeId(expandedNodeId);
        addNodesItem.setBrowseName(this.b(attributes, "BrowseName"));
        logger.debug("Creating node: {}", (Object)addNodesItem.getBrowseName().getName());
        return addNodesItem;
    }

    private void h(Attributes attributes) {
        this.aN = this.g(attributes);
        this.aO = this.i(attributes);
        this.aN.setNodeClass(NodeClass.Object);
    }

    private ObjectAttributes i(Attributes attributes) {
        ObjectAttributes objectAttributes = new ObjectAttributes();
        this.a(attributes, objectAttributes);
        objectAttributes.setEventNotifier(this.a(attributes, "EventNotifier", UnsignedByte.valueOf(0)));
        return objectAttributes;
    }

    private void j(Attributes attributes) {
        this.aN = this.g(attributes);
        this.aO = this.k(attributes);
        this.aN.setNodeClass(NodeClass.ObjectType);
    }

    private NodeAttributes k(Attributes attributes) {
        ObjectTypeAttributes objectTypeAttributes = new ObjectTypeAttributes();
        this.a(attributes, objectTypeAttributes);
        objectTypeAttributes.setIsAbstract(this.a(attributes, "IsAbstract", false));
        return objectTypeAttributes;
    }

    private void l(Attributes attributes) {
        if (this.aN != null) {
            this.aP = new AddReferencesItem();
            this.aP.setIsForward(this.a(attributes, "IsForward", true));
            this.aP.setReferenceTypeId(this.toGlobalNodeId(this.a(attributes, "ReferenceType", Identifiers.References)));
            NodeId nodeId = this.toGlobalNodeId(this.aN.getRequestedNewNodeId());
            this.aP.setSourceNodeId(nodeId);
        }
    }

    private void m(Attributes attributes) {
        this.aN = this.g(attributes);
        this.aO = this.n(attributes);
        this.aN.setNodeClass(NodeClass.ReferenceType);
    }

    private NodeAttributes n(Attributes attributes) {
        ReferenceTypeAttributes referenceTypeAttributes = new ReferenceTypeAttributes();
        this.a(attributes, referenceTypeAttributes);
        referenceTypeAttributes.setIsAbstract(this.a(attributes, "IsAbstract", false));
        referenceTypeAttributes.setSymmetric(this.a(attributes, "Symmetric", false));
        return referenceTypeAttributes;
    }

    private void g() throws TransformerConfigurationException, SAXException {
        this.ba = new DOMResult();
        this.aZ = XMLFactoryCache.getSAXTransformerFactory().newTransformerHandler();
        this.aZ.setResult(this.ba);
        this.aZ.startDocument();
        logger.debug("Created valueHandler");
    }

    private void o(Attributes attributes) {
        this.aN = this.g(attributes);
        this.aO = this.p(attributes);
        this.aN.setNodeClass(NodeClass.Variable);
    }

    private NodeAttributes p(Attributes attributes) {
        VariableAttributes variableAttributes = new VariableAttributes();
        this.a(attributes, variableAttributes);
        variableAttributes.setAccessLevel(this.u(attributes));
        variableAttributes.setArrayDimensions(this.a(attributes, "ArrayDimensions", ""));
        variableAttributes.setDataType(this.toGlobalNodeId(this.a(attributes, "DataType", Identifiers.BaseDataType)));
        variableAttributes.setHistorizing(this.a(attributes, "Historizing", false));
        variableAttributes.setMinimumSamplingInterval(this.a(attributes, "MinimumSamplingInterval", 0.0));
        variableAttributes.setUserAccessLevel(this.a(attributes, "UserAccessLevel", UnsignedByte.valueOf(1)));
        variableAttributes.setValueRank(this.a(attributes, "ValueRank", -1));
        return variableAttributes;
    }

    private void q(Attributes attributes) {
        this.aN = this.g(attributes);
        this.aO = this.r(attributes);
        this.aN.setNodeClass(NodeClass.VariableType);
    }

    private NodeAttributes r(Attributes attributes) {
        VariableTypeAttributes variableTypeAttributes = new VariableTypeAttributes();
        this.a(attributes, variableTypeAttributes);
        variableTypeAttributes.setIsAbstract(this.a(attributes, "IsAbstract", false));
        variableTypeAttributes.setValueRank(this.a(attributes, "ValueRank", -1));
        variableTypeAttributes.setArrayDimensions(this.a(attributes, "ArrayDimensions", ""));
        variableTypeAttributes.setDataType(this.toGlobalNodeId(this.a(attributes, "DataType", Identifiers.BaseDataType)));
        return variableTypeAttributes;
    }

    private void s(Attributes attributes) {
        this.aN = this.g(attributes);
        this.aO = this.t(attributes);
        this.aN.setNodeClass(NodeClass.View);
    }

    private NodeAttributes t(Attributes attributes) {
        ViewAttributes viewAttributes = new ViewAttributes();
        this.a(attributes, viewAttributes);
        viewAttributes.setContainsNoLoops(this.a(attributes, "ContainsNoLoops", false));
        return viewAttributes;
    }

    private void h() {
        logger.debug("Read extensions - readingExtensions:={}", (Object)this.aU);
    }

    private void j() {
        if (this.aO == null) {
            return;
        }
        this.aN.setNodeAttributes(new ExtensionObject(this.aO));
        this.nodes.add(this.aN);
        int n2 = -1;
        try {
            n2 = this.aF.getNamespaceTable().toNodeId(this.aN.getRequestedNewNodeId()).getNamespaceIndex();
        }
        catch (Exception exception) {
            n2 = -1;
        }
        UaNodeId uaNodeId = UaNodeId.fromLocal(this.aN.getRequestedNewNodeId(), this.aF.getNamespaceTable());
        boolean bl = NodeClass.DataType.equals(this.aN.getNodeClass());
        if (bl) {
            this.aM.add(uaNodeId);
        }
        if (bl && !this.aF.getKnownDataTypeDictionary().knownAddressSpaceNamespaces().contains(uaNodeId.getNamespaceUri()) && n2 != 0 && !this.aF.getEncoderContext().getDataTypeSpecifications().containsKey(uaNodeId)) {
            e e2 = new e();
            e2.name = this.aN.getBrowseName().getName();
            e2.cb = this.aS != null ? this.aS : new b();
            e2.typeId = uaNodeId;
            this.be.put(uaNodeId, e2);
        }
        if (this.bk.containsKey(uaNodeId) && !this.bi.contains(uaNodeId)) {
            this.a(uaNodeId, this.bk.get(uaNodeId));
        }
        this.aN = null;
        this.aO = null;
        this.aS = null;
    }

    private void k() {
        if (this.aP != null) {
            if (this.aT) {
                this.aP.setTargetNodeId(this.toGlobalExpandedNodeId(this.h(this.aR.toString())));
            }
            this.aT = false;
            if (logger.isDebugEnabled()) {
                logger.debug("referenceToString(nodeReference): {}", (Object)this.a(this.aP));
            }
            this.aQ.add(this.aP);
            this.aP = null;
        }
    }

    private void l() {
        if (this.aQ.size() == 0) {
            logger.debug("Zero references..");
        }
        for (AddReferencesItem addReferencesItem : this.aQ) {
            UaNodeId uaNodeId;
            UaNodeId uaNodeId2;
            if (addReferencesItem.getReferenceTypeId().equals(Identifiers.HasTypeDefinition) && addReferencesItem.getIsForward().booleanValue()) {
                this.aN.setTypeDefinition(addReferencesItem.getTargetNodeId());
            }
            this.aX.add(addReferencesItem);
            if (Identifiers.HasEncoding.equals(addReferencesItem.getReferenceTypeId())) {
                uaNodeId2 = UaNodeId.fromLocal(addReferencesItem.getSourceNodeId(), this.aF.getNamespaceTable());
                uaNodeId = UaNodeId.fromLocal(addReferencesItem.getTargetNodeId(), this.aF.getNamespaceTable());
                if (addReferencesItem.getIsForward().booleanValue()) {
                    this.bl.put(uaNodeId2, uaNodeId);
                    this.bk.put(uaNodeId, uaNodeId2);
                } else {
                    this.a(uaNodeId2, uaNodeId);
                }
            }
            if (!Identifiers.HasSubtype.equals(addReferencesItem.getReferenceTypeId())) continue;
            uaNodeId2 = UaNodeId.fromLocal(addReferencesItem.getSourceNodeId(), this.aF.getNamespaceTable());
            uaNodeId = UaNodeId.fromLocal(addReferencesItem.getTargetNodeId(), this.aF.getNamespaceTable());
            if (addReferencesItem.getIsForward().booleanValue()) {
                this.bj.put(uaNodeId, uaNodeId2);
                continue;
            }
            this.bj.put(uaNodeId2, uaNodeId);
        }
        this.aQ.clear();
    }

    private void m() {
        String string = this.aR.toString().trim();
        this.addNamespaceUri(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void n() throws TransformerFactoryConfigurationError, TransformerException, SAXException, DecodingException {
        this.aZ.endDocument();
        if (!ModelParserBase.aC || !ModelParserBase.aD) {
            ModelParserBase.logger.debug("finalizing value:{}", (Object)this.ba.getNode());
            var1_1 = new StringWriter();
            var2_2 = XMLFactoryCache.getTransformerFactory().newTransformer();
            var2_2.setOutputProperty("omit-xml-declaration", "yes");
            var2_2.transform(new DOMSource(this.ba.getNode()), new StreamResult(var1_1));
            var3_3 = var1_1.toString();
            ModelParserBase.logger.debug("Parsed XML of value:\n{}", (Object)var3_3);
            var4_4 = new XmlElement(var3_3);
            var5_5 = new XmlDecoder(var4_4, this.getEncoderContext());
            try {
                var5_5.setNamespaceTable(this.aK);
                this.c(var5_5.getVariant(""));
            }
            catch (Exception var6_6) {
                ModelParserBase.logger.warn("Could not load the value of node: {}, (it is probably non-codegenerated Structure)", (Object)this.aN.getRequestedNewNodeId(), (Object)var6_6);
                if (!ModelParserBase.logger.isDebugEnabled()) ** GOTO lbl25
                ModelParserBase.logger.debug("Failure was: ", (Throwable)var6_6);
            }
            finally {
                var5_5.close();
            }
        } else {
            ModelParserBase.logger.debug("finalizing value: skipping because we are on android and skipValuesOnAndroid setting is true");
        }
lbl25:
        // 4 sources

        this.aZ = null;
    }

    private UnsignedByte u(Attributes attributes) {
        UnsignedInteger unsignedInteger = this.a(attributes, "AccessLevel", UnsignedInteger.ONE);
        if (unsignedInteger.longValue() <= 255L) {
            return UnsignedByte.valueOf(unsignedInteger.longValue());
        }
        HashSet<AccessLevelType.Options> hashSet = new HashSet<AccessLevelType.Options>();
        for (AccessLevelType.Options options : AccessLevelType.Options.values()) {
            if (!unsignedInteger.isBitSet(options.getBitPosition())) continue;
            hashSet.add(options);
        }
        UnsignedByte unsignedByte = (UnsignedByte)AccessLevelType.of(hashSet).asBuiltInType();
        logger.warn("Encountered larger than Byte AccessLevel value: {}, truncated to: {} (AccessLevelEx is not yet supported)", (Object)unsignedInteger, (Object)unsignedByte);
        return unsignedByte;
    }

    private UnsignedInteger[] a(Attributes attributes, String string, String string2) {
        String string3 = string2;
        for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
            if (!attributes.getLocalName(i2).equalsIgnoreCase(string)) continue;
            string3 = attributes.getValue(i2);
            break;
        }
        if ("".equals(string3) || string3 == null) {
            return null;
        }
        if (string3.indexOf(",") < 0) {
            try {
                return new UnsignedInteger[]{UnsignedInteger.parseUnsignedInteger(string3)};
            }
            catch (Exception exception) {
                return null;
            }
        }
        String[] stringArray = string3.split(",");
        try {
            UnsignedInteger[] unsignedIntegerArray = new UnsignedInteger[stringArray.length];
            for (int i3 = 0; i3 < stringArray.length; ++i3) {
                unsignedIntegerArray[i3] = UnsignedInteger.parseUnsignedInteger(stringArray[i3]);
            }
            return unsignedIntegerArray;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Boolean a(Attributes attributes, String string, boolean bl) {
        Boolean bl2 = bl;
        for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
            if (!attributes.getLocalName(i2).equalsIgnoreCase(string)) continue;
            bl2 = Boolean.parseBoolean(attributes.getValue(i2));
            break;
        }
        return bl2;
    }

    private Double a(Attributes attributes, String string, double d2) {
        double d3 = d2;
        for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
            if (!attributes.getLocalName(i2).equalsIgnoreCase(string)) continue;
            d3 = Double.parseDouble(attributes.getValue(i2));
            break;
        }
        return d3;
    }

    private ExpandedNodeId a(Attributes attributes, String string) {
        ExpandedNodeId expandedNodeId = null;
        for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
            if (!attributes.getLocalName(i2).equalsIgnoreCase(string)) continue;
            NodeId nodeId = this.h(attributes.getValue(i2));
            expandedNodeId = this.toGlobalExpandedNodeId(nodeId);
            break;
        }
        return expandedNodeId;
    }

    private Integer a(Attributes attributes, String string, int n2) {
        int n3 = n2;
        for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
            if (!attributes.getLocalName(i2).equalsIgnoreCase(string)) continue;
            n3 = Integer.parseInt(attributes.getValue(i2));
            break;
        }
        return n3;
    }

    private String c(NodeId nodeId) {
        String string = this.aK.getUri(nodeId.getNamespaceIndex());
        if (string == null) {
            throw new IllegalArgumentException("Invalid NamespaceIndex for nodeId=" + nodeId + " localNamespaceTable=" + this.aK);
        }
        return string;
    }

    private void a(Attributes attributes, NodeAttributes nodeAttributes) {
        nodeAttributes.setUserWriteMask(this.a(attributes, "UserWriteMask", UnsignedInteger.valueOf(0L)));
        nodeAttributes.setWriteMask(this.a(attributes, "WriteMask", UnsignedInteger.valueOf(0L)));
    }

    private NodeId a(Attributes attributes, String string, NodeId nodeId) {
        NodeId nodeId2 = nodeId;
        for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
            if (!attributes.getLocalName(i2).equalsIgnoreCase(string)) continue;
            nodeId2 = this.h(attributes.getValue(i2));
            break;
        }
        return nodeId2;
    }

    private NodeId h(String string) {
        return this.a(string, true);
    }

    private NodeId a(String string, boolean bl) {
        if (bl && this.aE.containsKey(string)) {
            return this.aE.get(string);
        }
        return NodeId.parseNodeId(string);
    }

    private QualifiedName b(Attributes attributes, String string) {
        QualifiedName qualifiedName = null;
        for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
            if (!attributes.getLocalName(i2).equalsIgnoreCase(string)) continue;
            qualifiedName = this.b(QualifiedName.parseQualifiedName(attributes.getValue(i2)));
            break;
        }
        return qualifiedName;
    }

    private String b(Attributes attributes, String string, String string2) {
        String string3 = string2;
        for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
            if (!attributes.getLocalName(i2).equalsIgnoreCase(string)) continue;
            string3 = attributes.getValue(i2);
            break;
        }
        return string3;
    }

    private UnsignedByte a(Attributes attributes, String string, UnsignedByte unsignedByte) {
        UnsignedByte unsignedByte2 = unsignedByte;
        for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
            if (!attributes.getLocalName(i2).equalsIgnoreCase(string)) continue;
            unsignedByte2 = UnsignedByte.parseUnsignedByte(attributes.getValue(i2));
            break;
        }
        return unsignedByte2;
    }

    private UnsignedInteger a(Attributes attributes, String string, UnsignedInteger unsignedInteger) {
        UnsignedInteger unsignedInteger2 = unsignedInteger;
        for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
            if (!attributes.getLocalName(i2).equalsIgnoreCase(string)) continue;
            unsignedInteger2 = UnsignedInteger.parseUnsignedInteger(attributes.getValue(i2));
            break;
        }
        return unsignedInteger2;
    }

    private boolean o() {
        return this.aW > 0;
    }

    private int a(int n2) {
        String string = this.aK.getUri(n2);
        return this.getNamespaceTable().getIndex(string);
    }

    private void p() {
        this.aT = true;
        this.aR.setLength(0);
    }

    private void v(Attributes attributes) {
        this.alias = this.b(attributes, "Alias", "");
    }

    private void w(Attributes attributes) {
        this.aJ = this.b(attributes, "Locale", "");
    }

    private String a(AddReferencesItem addReferencesItem) {
        return String.format(Locale.ROOT, "finalizeReference: %s->%s (isForward=%s)", addReferencesItem.getSourceNodeId(), addReferencesItem.getTargetNodeId(), addReferencesItem.getIsForward());
    }

    private void a(UaNodeId uaNodeId, UaNodeId uaNodeId2) {
        if ("Default Binary".equalsIgnoreCase(this.aN.getBrowseName().getName())) {
            this.bf.put(uaNodeId2, uaNodeId);
            this.bi.add(uaNodeId);
        } else if ("Default XML".equalsIgnoreCase(this.aN.getBrowseName().getName())) {
            this.bg.put(uaNodeId2, uaNodeId);
            this.bi.add(uaNodeId);
        } else if ("Default JSON".equalsIgnoreCase(this.aN.getBrowseName().getName())) {
            this.bh.put(uaNodeId2, uaNodeId);
            this.bi.add(uaNodeId);
        }
        this.bl.put(uaNodeId2, uaNodeId);
        this.bk.put(uaNodeId, uaNodeId2);
    }

    private FieldSpecification a(FieldSpecification fieldSpecification, UaNodeId uaNodeId) {
        UaNodeId uaNodeId2 = fieldSpecification.getDataTypeId();
        FieldSpecification.Builder builder = fieldSpecification.toBuilder();
        Class<Object> clazz = null;
        try {
            UaDataType uaDataType = this.aF.getAddressSpace().getNode(uaNodeId2.asExpandedNodeId(), UaDataType.class);
            clazz = fieldSpecification.isAllowSubTypes() ? (uaDataType.inheritsFrom(Identifiers.Structure) ? ExtensionObject.class : Object.class) : uaDataType.getJavaClass();
        }
        catch (Exception exception) {
            logger.error("Cannot get the DataType node {}", (Object)uaNodeId2, (Object)exception);
        }
        if (clazz == null) {
            logger.error("Cannot resolve Java Class mappings for DataType: {} while trying to resolve Structure type: {}", (Object)uaNodeId2, (Object)uaNodeId);
            clazz = DynamicStructure.class;
        }
        if (fieldSpecification.getValueRank() > 0) {
            clazz = MultiDimensionArrayUtils.arrayClassOf(clazz, fieldSpecification.getValueRank());
        }
        builder.setJavaClass(clazz);
        return builder.build();
    }

    private void q() {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        ArrayList arrayList4 = new ArrayList();
        ArrayList arrayList5 = new ArrayList();
        this.be.forEach((uaNodeId, e2) -> {
            try {
                UaDataType uaDataType = (UaDataType)this.aF.getAddressSpace().findNode(uaNodeId.asNodeId(this.aF.getNamespaceTable()));
                if (uaDataType.inheritsFrom(DataTypeIdentifiers.OptionSet)) {
                    arrayList4.add(e2);
                } else if (uaDataType.inheritsFrom(DataTypeIdentifiers.Enumeration)) {
                    arrayList2.add(e2);
                } else if (uaDataType.inheritsFrom(DataTypeIdentifiers.Structure)) {
                    arrayList5.add(e2);
                } else if (e2.cb.isOptionSet) {
                    arrayList3.add(e2);
                } else {
                    arrayList.add(e2);
                }
            }
            catch (Exception exception) {
                logger.warn("Cannot resolve UaDataTypeSpecifications of {}, skipping", uaNodeId, (Object)exception);
                return;
            }
        });
        arrayList.forEach(this::c);
        arrayList2.forEach(this::a);
        arrayList3.forEach(this::b);
        arrayList4.forEach(this::d);
        arrayList5.forEach(this::d);
        ConcurrentHashMap<UaNodeId, StructureSpecification> concurrentHashMap = new ConcurrentHashMap<UaNodeId, StructureSpecification>();
        concurrentHashMap.putAll(this.bd);
        logger.debug("StructureSpecifications to resolve: {}", (Object)concurrentHashMap.size());
        if (!concurrentHashMap.isEmpty()) {
            boolean bl = true;
            while (bl) {
                bl = false;
                for (Map.Entry entry : concurrentHashMap.entrySet()) {
                    if (!this.a((StructureSpecification)entry.getValue(), concurrentHashMap.keySet())) continue;
                    concurrentHashMap.remove(entry.getKey());
                    bl = true;
                }
                if (!concurrentHashMap.isEmpty()) continue;
                bl = false;
            }
        }
        if (!concurrentHashMap.isEmpty()) {
            logger.warn("Failed to resolve custom Structure types: {}", concurrentHashMap.keySet());
        } else {
            logger.debug("Resolved all unknown Structure types");
        }
    }

    private void r() {
        ExtensionObject extensionObject;
        logger.debug("Undecoded Variable Values count: {}", (Object)this.bb.size());
        logger.debug("Undecoded VariableType Values count: {}", (Object)this.bc.size());
        logger.debug("Attempting to decode them now");
        for (VariableAttributes nodeAttributes : this.bb) {
            extensionObject = (ExtensionObject)nodeAttributes.getValue();
            try {
                nodeAttributes.setValue(extensionObject.decode(this.getEncoderContext(), this.aK));
            }
            catch (DecodingException decodingException) {
                logger.debug("Could not decode {}", (Object)extensionObject, (Object)decodingException);
            }
        }
        for (VariableTypeAttributes variableTypeAttributes : this.bc) {
            extensionObject = (ExtensionObject)variableTypeAttributes.getValue();
            try {
                variableTypeAttributes.setValue(extensionObject.decode(this.getEncoderContext(), this.aK));
            }
            catch (DecodingException decodingException) {
                logger.debug("Could not decode {}", (Object)extensionObject, (Object)decodingException);
            }
        }
    }

    private void t() {
        if (this.aT && this.aO != null) {
            this.aO.setDescription(new LocalizedText(this.aR.toString(), this.aJ));
        }
        this.aT = false;
    }

    private void u() {
        if (this.aT && this.aO != null) {
            this.aO.setDisplayName(new LocalizedText(this.aR.toString(), this.aJ));
        }
        this.aT = false;
    }

    private void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    private void v() {
        if (this.aT && this.aO != null) {
            ((ReferenceTypeAttributes)this.aO).setInverseName(new LocalizedText(this.aR.toString(), this.aJ));
        }
        this.aT = false;
    }

    private void w() {
        logger.debug("Reading extensions - readingExtensions:={}", (Object)this.aU);
    }

    private QualifiedName b(QualifiedName qualifiedName) {
        return new QualifiedName(this.a(qualifiedName.getNamespaceIndex()), qualifiedName.getName());
    }

    private boolean a(StructureSpecification structureSpecification, Set<UaNodeId> set) {
        UaNodeId uaNodeId = this.bj.get(structureSpecification.getTypeId());
        if (uaNodeId != null && set.contains(uaNodeId)) {
            logger.debug("Skipping temporarily type {}, since super type {} is not yet processed", (Object)structureSpecification.getTypeId(), (Object)uaNodeId);
            return false;
        }
        StructureSpecification.Builder builder = structureSpecification.toBuilder();
        builder.setBinaryEncodeId(this.bf.get(structureSpecification.getTypeId()));
        builder.setXmlEncodeId(this.bg.get(structureSpecification.getTypeId()));
        builder.setJsonEncodeId(this.bh.get(structureSpecification.getTypeId()));
        ArrayList<FieldSpecification> arrayList = new ArrayList<FieldSpecification>();
        UaNodeId uaNodeId2 = UaNodeId.fromLocal(Identifiers.Structure, this.aF.getNamespaceTable());
        if (!uaNodeId2.equals(uaNodeId) && this.aF.getEncoderContext().getStructureSpecification(uaNodeId) != null) {
            StructureSpecification structureSpecification2 = this.aF.getEncoderContext().getStructureSpecification(uaNodeId);
            if (StructureSpecification.StructureType.OPTIONAL == structureSpecification2.getStructureType()) {
                builder.setStructureType(StructureSpecification.StructureType.OPTIONAL);
            } else {
                builder.setStructureType(structureSpecification.getStructureType());
            }
            for (FieldSpecification fieldSpecification : structureSpecification2.getFields()) {
                arrayList.add(fieldSpecification);
            }
            structureSpecification2.getSuperTypeIds().forEach(builder::addSuperTypeId);
            builder.addSuperTypeId(structureSpecification2.getTypeId());
        } else {
            builder.setStructureType(structureSpecification.getStructureType());
            builder.addSuperTypeId(UaIds.Structure);
        }
        for (FieldSpecification fieldSpecification : structureSpecification.getFields()) {
            arrayList.add(this.a(fieldSpecification, structureSpecification.getTypeId()));
        }
        builder.setFields(arrayList);
        this.aF.getEncoderContext().addDataTypeSpecification(builder.build());
        logger.debug("Resolved partial StructureSpecification for typeId: {}", (Object)structureSpecification.getTypeId());
        return true;
    }

    private void a(char[] cArray, int n2, int n3) {
        try {
            String string = new String(cArray, n2, n3);
            string = string.trim();
            if (string.isEmpty()) {
                return;
            }
            logger.debug("valueCharacters: {}", (Object)string);
            this.aZ.characters(cArray, n2, n3);
        }
        catch (SAXException sAXException) {
            logger.error("Error in valueCharacters, start=" + n2 + " ,length=" + n3 + " ch len=" + cArray.length, (Throwable)sAXException);
        }
        catch (Exception exception) {
            String string = new String(cArray, n2, n3);
            string = string.trim();
            logger.error("Error in valueCharacters, start=" + n2 + " ,length=" + n3 + " ch len=" + cArray.length + " chars:" + (string.isEmpty() ? "isEmpty()=true" : string), (Throwable)exception);
        }
    }

    private void a(String string, String string2, String string3) {
        logger.debug("valueEndElement: localName={}", (Object)string2);
        try {
            this.aZ.endElement(string, string2, string3);
        }
        catch (SAXException sAXException) {
            logger.error("Error in valueEndElement: localName=" + string2, (Throwable)sAXException);
        }
        catch (EmptyStackException emptyStackException) {
            logger.error("Error in valueEndElement: localName=" + string2, (Throwable)emptyStackException);
        }
    }

    private void a(String string, String string2, String string3, Attributes attributes) {
        logger.debug("valueStartElement: {}", (Object)string2);
        try {
            this.aZ.startElement(string, string2, string3, attributes);
        }
        catch (SAXException sAXException) {
            logger.error("Error in valueStartElement", (Throwable)sAXException);
        }
    }

    private void a(e e2) {
        if (this.aF.getEncoderContext().getEnumerationSpecification(e2.typeId) == null) {
            EnumerationSpecification.Builder builder = EnumerationSpecification.builder();
            builder.setTypeId(e2.typeId);
            builder.setName(e2.name);
            HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
            for (a a2 : e2.cb.fields) {
                hashMap.put(a2.bq, a2.name);
            }
            builder.setMappings(hashMap);
            this.aF.getEncoderContext().addDataTypeSpecification(builder.build());
        } else {
            logger.debug("EncoderContext already had EnumerationSpecification for type {}, ignoring parsing", (Object)e2.typeId);
        }
    }

    private void b(e e2) {
        if (this.aF.getEncoderContext().getOptionSetSpecification(e2.typeId) != null) {
            return;
        }
        try {
            OptionSetSpecification.Builder<UaOptionSet.Builder> builder = OptionSetSpecification.builder();
            builder.setName(e2.name);
            builder.setTypeId(e2.typeId);
            builder.setJavaClass(DynamicUIntOptionSet.class);
            HashSet<NodeId> hashSet = new HashSet<NodeId>();
            hashSet.add(DataTypeIdentifiers.Byte);
            hashSet.add(DataTypeIdentifiers.UInt16);
            hashSet.add(DataTypeIdentifiers.UInt32);
            hashSet.add(DataTypeIdentifiers.UInt64);
            UaDataType uaDataType = (UaDataType)this.aF.getAddressSpace().findNode(e2.typeId.asNodeId(this.aF.getNamespaceTable()));
            while (uaDataType != null) {
                if ((uaDataType = (UaDataType)uaDataType.getSuperType()) == null) {
                    logger.warn("Encountered numeric OptionSet type that doesn't inherit from Byte, UInt16, UInt32 or UInt64, skipping: {}", (Object)e2.typeId);
                }
                if (!hashSet.contains(uaDataType.getNodeId())) continue;
                builder.setBaseTypeId(UaNodeId.fromStandard(uaDataType.getNodeId()));
                break;
            }
            for (a a2 : e2.cb.fields) {
                OptionSpecification.Builder builder2 = OptionSpecification.builder();
                builder2.setName(a2.name);
                builder2.setBitPosition(a2.bq);
                builder.addOptions(builder2.build());
            }
            this.aF.getEncoderContext().addDataTypeSpecification(builder.build());
        }
        catch (Exception exception) {
            logger.warn("Cannot resolve UaDataTypeSpecification for (numeric) OptionSet type: {}, skipping", (Object)e2.typeId);
        }
    }

    private void c(e e2) {
        if (this.aF.getEncoderContext().getDataTypeSpecifications().containsKey(e2.typeId)) {
            return;
        }
        try {
            SimpleTypeSpecification.Builder builder = SimpleTypeSpecification.builder();
            builder.setName(e2.name);
            builder.setTypeId(e2.typeId);
            UaDataType uaDataType = (UaDataType)this.aF.getAddressSpace().findNode(e2.typeId.asNodeId(this.aF.getNamespaceTable()));
            SimpleTypeSpecification simpleTypeSpecification = null;
            while (simpleTypeSpecification == null) {
                uaDataType = (UaDataType)uaDataType.getSuperType();
                simpleTypeSpecification = this.aF.getEncoderContext().getSimpleTypeSpecification(UaNodeId.fromLocal(uaDataType.getNodeId(), this.aF.getNamespaceTable()));
            }
            builder.setBaseTypeId(simpleTypeSpecification.getBaseTypeId());
            builder.setJavaClass(simpleTypeSpecification.getJavaClass());
            this.aF.getEncoderContext().addDataTypeSpecification(builder.build());
        }
        catch (Exception exception) {
            logger.warn("Cannot resolve UaDataTypeSpecification for Simple type: {}, skipping", (Object)e2.typeId);
        }
    }

    private void d(e e2) {
        boolean bl = false;
        boolean bl2 = false;
        for (a object : e2.cb.fields) {
            if (Boolean.TRUE.equals(object.bp)) {
                bl = true;
                break;
            }
            if (!Boolean.TRUE.equals(object.bt)) continue;
            bl2 = true;
            break;
        }
        if (this.aF.getEncoderContext().getDataTypeSpecification(e2.typeId) == null) {
            StructureSpecification.Builder<Structure.Builder> builder = e2.cb.isOptionSet ? OptionSetStructureSpecification.builder() : StructureSpecification.builder();
            builder.setTypeId(e2.typeId);
            builder.setName(e2.name);
            if (e2.cb.isUnion) {
                if (bl2) {
                    builder.setStructureType(StructureSpecification.StructureType.UNION_SUBTYPES);
                } else {
                    builder.setStructureType(StructureSpecification.StructureType.UNION);
                }
            } else if (bl) {
                builder.setStructureType(StructureSpecification.StructureType.OPTIONAL);
            } else if (bl2) {
                builder.setStructureType(StructureSpecification.StructureType.SUBTYPES);
            } else {
                builder.setStructureType(StructureSpecification.StructureType.NORMAL);
            }
            if (!e2.cb.isOptionSet) {
                for (a a2 : e2.cb.fields) {
                    FieldSpecification.Builder builder2 = FieldSpecification.builder();
                    UaNodeId uaNodeId = UaNodeId.fromLocal(a2.bo, this.aK);
                    builder2.setDataTypeId(uaNodeId);
                    builder2.setIsOptional(Boolean.TRUE.equals(a2.bp));
                    builder2.setAllowSubTypes(Boolean.TRUE.equals(a2.bt));
                    builder2.setValueRank(a2.br);
                    builder2.setName(a2.name);
                    if (a2.bs != null) {
                        builder2.setArrayDimensions(UaArrayDimensions.valueOf(a2.bs));
                    }
                    builder.addField(builder2.build());
                }
            } else {
                OptionSetStructureSpecification.Builder builder3 = (OptionSetStructureSpecification.Builder)builder;
                builder3.setBaseTypeId(UaIds.OptionSet);
                builder3.setJavaClass((Class)DynamicOptionSetStructure.class);
                for (a a3 : e2.cb.fields) {
                    OptionSpecification.Builder builder4 = OptionSpecification.builder();
                    builder4.setName(a3.name);
                    builder4.setBitPosition(a3.bq);
                    builder3.addOptions(builder4.build());
                }
            }
            StructureSpecification structureSpecification = builder.build();
            this.bd.put(structureSpecification.getTypeId(), structureSpecification);
        } else {
            logger.debug("EncoderContext already had StructureSpecification for type {}, ignoring parsing", (Object)e2.typeId);
        }
    }

    protected void addNamespaceUri(String string) {
        this.aK.add(string);
        this.getNamespaceTable().add(string);
    }

    protected void addNodes(List<AddNodesItem> list, String string) throws ModelException, ServiceException {
        logger.debug("addNodes: {}", (Object)string);
        for (AddNodesItem addNodesItem : list) {
            this.a(addNodesItem);
        }
    }

    protected void addReferences(List<AddReferencesItem> list) throws ModelException {
        for (AddReferencesItem addReferencesItem : list) {
            this.addReference(addReferencesItem);
        }
    }

    protected void afterCreate(AddNodesItem addNodesItem) {
    }

    protected void characters(char[] cArray, int n2, int n3) {
        try {
            if (this.o()) {
                this.a(cArray, n2, n3);
            } else if (this.aT) {
                this.aR.append(cArray, n2, n3);
            }
        }
        catch (Exception exception) {
            logger.error("Error in ModelParser2.characters, start=" + n2 + ", length=" + n3, (Throwable)exception);
        }
    }

    protected NodeId doAddNode(AddNodesItem addNodesItem) throws StatusException, ServiceException {
        throw new StatusException(StatusCodes.Bad_NotImplemented);
    }

    protected void doAddReference(AddReferencesItem addReferencesItem) throws StatusException, ServiceException {
        throw new StatusException(StatusCodes.Bad_NotImplemented);
    }

    protected void endElement(String string, String string2, String string3) throws SAXException {
        logger.debug("endElement: {}", (Object)string2);
        try {
            if (this.o()) {
                this.a(string, string2, string3);
                if (string2.equals("Value")) {
                    logger.debug("endElement: readingValue={}", (Object)this.aW);
                    --this.aW;
                    if (this.aW <= 0) {
                        this.n();
                    }
                }
                return;
            }
            if (this.isReadingNamespaces() && string2.equals("Uri")) {
                this.m();
                return;
            }
            if (this.isReadingExtensions()) {
                if (string2.equals("Extensions")) {
                    logger.debug("endElement: readingExtensions={}", (Object)this.aU);
                    --this.aU;
                    if (this.aU <= 0) {
                        this.h();
                    }
                }
                return;
            }
            c c2 = c.valueOf(string2);
            switch (c2) {
                case bI: {
                    this.aV = false;
                    break;
                }
                case bP: 
                case bQ: 
                case bS: 
                case bT: 
                case bU: 
                case bV: 
                case bW: 
                case bX: {
                    this.j();
                    break;
                }
                case bu: {
                    this.f();
                    break;
                }
                case by: {
                    this.t();
                    break;
                }
                case bz: {
                    this.u();
                    break;
                }
                case bE: {
                    this.v();
                    break;
                }
                case bY: {
                    logger.error("endElement reached Value with readingValue false, localName={}", (Object)string2);
                    break;
                }
                case bJ: {
                    this.k();
                    break;
                }
                case bK: {
                    this.l();
                    break;
                }
                case bC: {
                    logger.error("endElement reached Extensions with readingExtensions false, localName={}", (Object)string2);
                    break;
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (!this.isReadingExtensions()) {
                logger.info("Unknown element in XML: " + string2);
            }
        }
        catch (Exception exception) {
            try {
                this.a(this.aG, this.aA, exception, "Error in ModelParser2.endElement: localName=" + string2);
            }
            catch (ModelException modelException) {
                throw new SAXException("Error in ModelParser2.endElement: localName=" + string2, modelException);
            }
        }
    }

    protected NamespaceTable getNamespaceTable() {
        return this.aF.getNamespaceTable();
    }

    protected abstract UaNode getNode(NodeId var1) throws StatusException;

    protected ServerTable getServerTable() {
        return this.aF.getServerTable();
    }

    protected boolean isIgnoredReference(AddReferencesItem addReferencesItem) {
        return this.aH.contains(this.getNamespaceTable().toExpandedNodeId(addReferencesItem.getSourceNodeId())) || this.aH.contains(addReferencesItem.getTargetNodeId());
    }

    protected boolean isReadingNamespaces() {
        return this.aV;
    }

    protected void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        logger.debug("startElement: {} readingValue={}", (Object)string2, (Object)this.aW);
        try {
            if (this.o()) {
                if (string2.equals("Value")) {
                    ++this.aW;
                }
                this.a(string, string2, string3, attributes);
                return;
            }
            if (this.isReadingNamespaces()) {
                if (string2.equals("Uri")) {
                    this.p();
                }
                return;
            }
            if (this.isReadingExtensions()) {
                if (string2.equals("Extensions")) {
                    ++this.aU;
                }
                return;
            }
            c c2 = c.valueOf(string2);
            switch (c2) {
                case bI: {
                    this.aV = true;
                    break;
                }
                case bP: {
                    this.a(attributes);
                    break;
                }
                case bQ: {
                    this.e(attributes);
                    break;
                }
                case bS: {
                    this.h(attributes);
                    break;
                }
                case bT: {
                    this.j(attributes);
                    break;
                }
                case bU: {
                    this.m(attributes);
                    break;
                }
                case bV: {
                    this.o(attributes);
                    break;
                }
                case bW: {
                    this.q(attributes);
                    break;
                }
                case bX: {
                    this.s(attributes);
                    break;
                }
                case bu: {
                    this.v(attributes);
                    this.p();
                    break;
                }
                case by: 
                case bz: 
                case bE: {
                    this.w(attributes);
                    this.p();
                    break;
                }
                case bY: {
                    ++this.aW;
                    this.g();
                    this.a(string, string2, string3, attributes);
                    logger.debug("Start - readingValue={}, element={}", (Object)this.aW, (Object)string2);
                    break;
                }
                case bK: {
                    break;
                }
                case bJ: {
                    this.l(attributes);
                    this.p();
                    break;
                }
                case bx: {
                    this.c(attributes);
                    break;
                }
                case bD: {
                    this.d(attributes);
                    break;
                }
                case bC: {
                    ++this.aU;
                    this.w();
                    break;
                }
                default: {
                    logger.debug("Ignoring element {} in {}", (Object)string2, (Object)this.aI);
                    break;
                }
            }
        }
        catch (Exception exception) {
            try {
                this.a(this.aG, this.aA, exception, "Error in ModelParser2.startElement: localName=" + string2);
            }
            catch (ModelException modelException) {
                throw new SAXException("Error in ModelParser2.startElement: localName=" + string2, modelException);
            }
        }
    }

    protected ExpandedNodeId toGlobalExpandedNodeId(NodeId nodeId) {
        return new ExpandedNodeId(this.aY, this.c(nodeId), nodeId.getValue());
    }

    protected NodeId toGlobalNodeId(ExpandedNodeId expandedNodeId) {
        return NodeId.get(expandedNodeId.getIdType(), this.getNamespaceTable().getIndex(expandedNodeId.getNamespaceUri()), expandedNodeId.getValue());
    }

    protected NodeId toGlobalNodeId(NodeId nodeId) {
        return NodeId.get(nodeId.getIdType(), this.a(nodeId.getNamespaceIndex()), nodeId.getValue());
    }

    private static class e {
        public b cb;
        public String name;
        public UaNodeId typeId;

        private e() {
        }
    }

    private class d
    extends DefaultHandler {
        private d() {
        }

        @Override
        public void characters(char[] cArray, int n2, int n3) throws SAXException {
            ModelParserBase.this.characters(cArray, n2, n3);
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            ModelParserBase.this.endElement(string, string2, string3);
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            ModelParserBase.this.setDocumentLocator(locator);
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            ModelParserBase.this.startElement(string, string2, string3, attributes);
        }
    }

    private static enum c {
        bu,
        bv,
        bw,
        bx,
        by,
        bz,
        bA,
        bB,
        bC,
        bD,
        bE,
        bF,
        bG,
        bH,
        bI,
        bJ,
        bK,
        bL,
        bM,
        bN,
        bO,
        bP,
        bQ,
        bR,
        bS,
        bT,
        bU,
        bV,
        bW,
        bX,
        bY;

    }

    private static class b {
        public boolean isUnion = false;
        public boolean isOptionSet = false;
        public final List<a> fields = new ArrayList<a>();

        private b() {
        }
    }

    private static class a {
        public NodeId bo;
        public Boolean bp;
        public String name;
        public Integer bq;
        public Integer br;
        public UnsignedInteger[] bs;
        public Boolean bt;

        private a() {
        }
    }
}

