/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platHwScan.ui;

import com.tridium.platHwScan.BHardwareScanService;
import com.tridium.platHwScan.enums.BHwScanStatusEnum;
import com.tridium.platHwScan.enums.BPortTypeEnum;
import com.tridium.platHwScan.enums.BWifiModeEnum;
import com.tridium.platHwScan.ports.BPort;
import com.tridium.platHwScan.ports.BWifiPort;
import com.tridium.platHwScan.ui.BCalloutLabel;
import com.tridium.platHwScan.ui.BHardwareScanFormatPalette;
import com.tridium.platHwScan.ui.BHardwareScanReferenceTableBinding;
import com.tridium.platHwScan.util.BHardwareRef;
import java.util.Enumeration;
import java.util.Vector;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BInsets;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BGridPane;
import javax.baja.workbench.BWbShell;

@NiagaraType
@NiagaraProperty(name="formatPalette", type="BHardwareScanFormatPalette", defaultValue="new BHardwareScanFormatPalette()")
public class BHardwareScanServiceReferenceTable
extends BGridPane {
    @Generated
    public static final Property formatPalette = BHardwareScanServiceReferenceTable.newProperty((int)0, (BValue)new BHardwareScanFormatPalette(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BHardwareScanServiceReferenceTable.class);
    private static final String[] COL_HDRS = new String[]{"HardwareRefTable.reference", "HardwareRefTable.location", "HardwareRefTable.description", "HardwareRefTable.portType", "HardwareRefTable.status"};

    @Generated
    public BHardwareScanFormatPalette getFormatPalette() {
        return (BHardwareScanFormatPalette)this.get(formatPalette);
    }

    @Generated
    public void setFormatPalette(BHardwareScanFormatPalette v) {
        this.set(formatPalette, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() {
        this.setColumnCount(COL_HDRS.length);
        this.setColumnAlign(BHalign.fill);
        this.setValign(BValign.top);
        for (int i = 0; i < COL_HDRS.length; ++i) {
            if (!COL_HDRS[i].endsWith(".description")) continue;
            this.setStretchColumn(i);
        }
        BWbShell shell = BWbShell.getWbShell((BWidget)this);
        if (shell == null) {
            return;
        }
        BHardwareScanReferenceTableBinding binding = new BHardwareScanReferenceTableBinding();
        binding.setOrd(BOrd.make((BOrd)shell.getActiveOrd(), (String)"service:platHwScan:HardwareScanService"));
        this.add(null, (BValue)binding);
    }

    public void addLabels() {
        BWbShell shell = BWbShell.getWbShell((BWidget)this);
        if (shell == null) {
            return;
        }
        BHardwareScanFormatPalette palette = this.getFormatPalette();
        this.formatHeaders(palette);
        BHardwareScanService scanService = (BHardwareScanService)BOrd.make((BOrd)shell.getActiveOrd(), (String)"service:platHwScan:HardwareScanService").get();
        scanService.checkPropertiesLoaded();
        scanService.lease(Integer.MAX_VALUE);
        Vector refs = scanService.getBaseBoardType().getHardwareRefs();
        Enumeration elems = refs.elements();
        while (elems.hasMoreElements()) {
            BPort port;
            BHardwareRef ref = (BHardwareRef)elems.nextElement();
            if (ref.getPortType().equals((Object)BPortTypeEnum.unknown)) continue;
            BHardwareScanService.LOG.fine(BHardwareScanService.LEX.getText("HardwareRefTable.formatting", new Object[]{ref}));
            BLabel refLabel = this.makeRefLabel(ref.getReference(), palette);
            BLabel locationLabel = this.makeLabel(ref.getLocation(), palette);
            BLabel descriptionLabel = this.makeLabel(ref.getDescription(), palette);
            this.add(null, (BValue)refLabel);
            this.add(null, (BValue)locationLabel);
            this.add(null, (BValue)descriptionLabel);
            if (ref.getDescription().equals("Invalid Configuration")) {
                refLabel.setForeground(BBrush.makeSolid((BColor)BColor.red));
                locationLabel.setForeground(BBrush.makeSolid((BColor)BColor.red));
                descriptionLabel.setForeground(BBrush.makeSolid((BColor)BColor.red));
                this.add(null, (BValue)new BLabel(""));
                this.add(null, (BValue)new BLabel(""));
                continue;
            }
            double gridWidth = this.getWidth();
            descriptionLabel.setWordWrapEnabled(true, gridWidth / 3.0);
            BPortTypeEnum portType = ref.getPortType();
            if (portType.equals((Object)BPortTypeEnum.noPort)) {
                this.add(null, (BValue)this.makeLabel(" ", palette));
            } else {
                this.add(null, (BValue)this.makeLabel(BHardwareScanService.LEX.getText(portType.getTag()), palette));
            }
            BHwScanStatusEnum status = ref.getStatus();
            if (status.equals((Object)BHwScanStatusEnum.none)) {
                this.add(null, (BValue)this.makeLabel(" ", palette));
                continue;
            }
            String statusString = BHardwareScanService.LEX.getText(status.getTag());
            if (status.equals((Object)BHwScanStatusEnum.inUse) || status.equals((Object)BHwScanStatusEnum.serialShell) && !portType.equals((Object)BPortTypeEnum.noPort)) {
                port = scanService.getPort(ref.getDescription());
                this.lease();
                statusString = BHardwareScanService.LEX.getText("HardwareRefTable.ownedByStatus", new Object[]{BHardwareScanService.LEX.getText(port.getOwner().trim())});
            }
            if (portType.equals((Object)BPortTypeEnum.wifi)) {
                port = (BWifiPort)scanService.getPort(ref.getDescription());
                this.lease();
                BWifiModeEnum mode = port.getMode();
                if (mode != BWifiModeEnum.disabled) {
                    String modeString = BHardwareScanService.LEX.getText(port.getMode().getTag());
                    statusString = BHardwareScanService.LEX.getText("HardwareRefTable.wifiStatus", new Object[]{statusString, modeString});
                }
            }
            BLabel statusLabel = this.makeLabel(statusString, palette);
            this.add(null, (BValue)statusLabel);
        }
    }

    private void formatHeaders(BHardwareScanFormatPalette palette) {
        for (String colHdr : COL_HDRS) {
            BCalloutLabel label = new BCalloutLabel(BHardwareScanService.LEX.getText(colHdr));
            label.setBorder(BBorder.solid);
            label.setPadding(palette.getHeaderPadding());
            label.setFont(palette.getBoldFont());
            if (colHdr.equals("HardwareRefTable.reference")) {
                label.setForeground(palette.getReferenceColor());
            } else {
                label.setForeground(palette.getDataColor());
            }
            this.add(null, (BValue)label);
        }
    }

    private BLabel makeLabel(String s, BHardwareScanFormatPalette palette) {
        return this.makeLabel(s, palette.getNormalFont(), palette.getDataColor(), palette.getDataBackgroundColor(), palette.getTablePadding());
    }

    private BLabel makeLabel(String s, BFont font, BBrush foreground, BBrush background, BInsets padding) {
        BLabel label = new BLabel(s, font);
        label.setPadding(padding);
        label.setForeground(foreground);
        label.setBackground(background);
        return label;
    }

    private BLabel makeRefLabel(String s, BHardwareScanFormatPalette palette) {
        return this.makeLabel(s, palette.getBoldFont(), palette.getReferenceColor(), palette.getReferenceBackgroundColor(), palette.getTablePadding());
    }

    public void reload() {
        for (BWidget widget : this.getChildWidgets()) {
            this.remove((BComplex)widget);
        }
        this.addLabels();
        this.computePreferredSize();
    }
}

