/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.dt;

import com.tridium.bql.filter.BFilterSet;
import com.tridium.bql.filter.BNullFilter;
import com.tridium.orion.BIOrionAssociation;
import com.tridium.orion.BIOrionDatabaseObject;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionSpace;
import com.tridium.orion.BOrionType;
import com.tridium.orion.BOrionTypeId;
import com.tridium.orion.BTypeDependency;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionException;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.db.sql.SelectVisitor;
import com.tridium.orion.priv.dt.BDynamicTableColumn;
import com.tridium.orion.priv.dt.BDynamicTableColumnsProvider;
import com.tridium.orion.priv.dt.BDynamicTableReportType;
import com.tridium.orion.priv.dt.DynamicTableUtil;
import com.tridium.orion.priv.model.DynamicOrionType;
import com.tridium.orion.priv.ui.BDynamicTableOptions;
import com.tridium.orion.priv.util.CountingUtil;
import com.tridium.orion.sql.BISqlQueryFilter;
import com.tridium.orion.sql.BJoin;
import com.tridium.orion.sql.BPage;
import com.tridium.orion.sql.BSqlExtent;
import com.tridium.orion.sql.BSqlQuery;
import com.tridium.orion.sql.SqlColumns;
import com.tridium.query.BOrderByCol;
import java.util.Comparator;
import java.util.HashMap;
import java.util.ListIterator;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentList;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.IFilter;
import javax.baja.query.BExpression;
import javax.baja.query.BExtent;
import javax.baja.query.BOrderByColumn;
import javax.baja.query.BOrdering;
import javax.baja.query.BProjection;
import javax.baja.query.BProjectionColumn;
import javax.baja.query.BQuery;
import javax.baja.rdb.BRdbms;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.util.BTypeSpec;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="icon", type="BIcon", defaultValue="BIcon.make(\"module://icons/x16/widgets/table.png\")"), @NiagaraProperty(name="rowType", type="BOrionTypeId", defaultValue="BOrionTypeId.DEFAULT"), @NiagaraProperty(name="dbOrd", type="BOrd", defaultValue="BOrd.NULL", facets={@Facet(value="BFacets.make(BFacets.TARGET_TYPE, \"orion:OrionDatabase\")")}), @NiagaraProperty(name="appOrd", type="BOrd", defaultValue="BOrd.NULL", facets={@Facet(value="BFacets.make(BFacets.TARGET_TYPE, \"orion:IOrionApp\")")}), @NiagaraProperty(name="reportType", type="BDynamicTableReportType", defaultValue="BDynamicTableReportType.optimized"), @NiagaraProperty(name="coalesce", type="boolean", defaultValue="true", flags=4), @NiagaraProperty(name="countResult", type="boolean", defaultValue="false", flags=4)})
public class BDynamicTable
extends BComponent
implements BIOrionDatabaseObject {
    @Generated
    public static final Property icon = BDynamicTable.newProperty((int)0, (BValue)BIcon.make((String)"module://icons/x16/widgets/table.png"), null);
    @Generated
    public static final Property rowType = BDynamicTable.newProperty((int)0, (BValue)BOrionTypeId.DEFAULT, null);
    @Generated
    public static final Property dbOrd = BDynamicTable.newProperty((int)0, (BValue)BOrd.NULL, (BFacets)BFacets.make((String)"targetType", (String)"orion:OrionDatabase"));
    @Generated
    public static final Property appOrd = BDynamicTable.newProperty((int)0, (BValue)BOrd.NULL, (BFacets)BFacets.make((String)"targetType", (String)"orion:IOrionApp"));
    @Generated
    public static final Property reportType = BDynamicTable.newProperty((int)0, (BValue)BDynamicTableReportType.optimized, null);
    @Generated
    public static final Property coalesce = BDynamicTable.newProperty((int)4, (boolean)true, null);
    @Generated
    public static final Property countResult = BDynamicTable.newProperty((int)4, (boolean)false, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BDynamicTable.class);
    private BObject resolveBase = this;
    protected static BDynamicTableColumnsProvider defaultColumnsProvider = new BDynamicTableColumnsProvider();
    public static final int MAX_RESULT_SIZE = Integer.getInteger("niagara.dynamicTable.maxResultSize", 20000);

    @Generated
    public BIcon getIcon() {
        return (BIcon)this.get(icon);
    }

    @Generated
    public void setIcon(BIcon v) {
        this.set(icon, (BValue)v, null);
    }

    @Generated
    public BOrionTypeId getRowType() {
        return (BOrionTypeId)this.get(rowType);
    }

    @Generated
    public void setRowType(BOrionTypeId v) {
        this.set(rowType, (BValue)v, null);
    }

    @Generated
    public BOrd getDbOrd() {
        return (BOrd)this.get(dbOrd);
    }

    @Generated
    public void setDbOrd(BOrd v) {
        this.set(dbOrd, (BValue)v, null);
    }

    @Generated
    public BOrd getAppOrd() {
        return (BOrd)this.get(appOrd);
    }

    @Generated
    public void setAppOrd(BOrd v) {
        this.set(appOrd, (BValue)v, null);
    }

    @Generated
    public BDynamicTableReportType getReportType() {
        return (BDynamicTableReportType)this.get(reportType);
    }

    @Generated
    public void setReportType(BDynamicTableReportType v) {
        this.set(reportType, (BValue)v, null);
    }

    @Generated
    public boolean getCoalesce() {
        return this.getBoolean(coalesce);
    }

    @Generated
    public void setCoalesce(boolean v) {
        this.setBoolean(coalesce, v, null);
    }

    @Generated
    public boolean getCountResult() {
        return this.getBoolean(countResult);
    }

    @Generated
    public void setCountResult(boolean v) {
        this.setBoolean(countResult, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        if (Sys.isStationStarted()) {
            this.checkReportTypeAvailability();
        }
    }

    public void stationStarted() throws Exception {
        this.checkReportTypeAvailability();
    }

    public void checkReportTypeAvailability() {
        if (!SelectVisitor.dbSupportsPagination((BRdbms)this.getOrionDatabase().getRdbms())) {
            if (this.getReportType() != BDynamicTableReportType.fullReport) {
                this.setReportType(BDynamicTableReportType.fullReport);
            }
            if (!Flags.isReadonly((BComplex)this, (Slot)reportType)) {
                this.setFlags((Slot)reportType, this.getFlags((Slot)reportType) | 1);
            }
        } else if (Flags.isReadonly((BComplex)this, (Slot)reportType)) {
            this.setFlags((Slot)reportType, this.getFlags((Slot)reportType) & 0xFFFFFFFE);
            this.setReportType(BDynamicTableReportType.optimized);
        }
    }

    public void changed(Property p, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        if (p.equals(dbOrd) || p.equals(reportType)) {
            this.checkReportTypeAvailability();
        }
        super.changed(p, cx);
    }

    public BINavNode[] getNavChildren() {
        Array a = new Array((Object[])super.getNavChildren());
        a = a.filter(new IFilter(){

            public boolean accept(Object obj) {
                return !(obj instanceof BDynamicTableColumn) && !(obj instanceof BISqlQueryFilter);
            }
        });
        return (BINavNode[])a.trim();
    }

    public BObject getResolveBase() {
        return this.resolveBase;
    }

    public void setResolveBase(BObject resolveBase) {
        this.resolveBase = resolveBase;
    }

    public BOrionDatabase getOrionDatabase() {
        return this.getOrionDatabase(this.getResolveBase());
    }

    public BOrionDatabase getOrionDatabase(BObject base) {
        if (!this.getDbOrd().isNull()) {
            return (BOrionDatabase)this.getDbOrd().get(base);
        }
        if (!this.getAppOrd().isNull()) {
            BOrionSpace orion = (BOrionSpace)BOrd.make((String)"orion:").get(base);
            BOrionDatabase db = orion.getOrionDatabaseForApp(this.getAppOrd());
            if (db == null) {
                throw new OrionException("Database not available.");
            }
            return db;
        }
        throw new OrionException("Database not configured.");
    }

    public OrionType makeDynamicRowType() {
        BOrionDatabase db = this.getOrionDatabase();
        Array dprops = new Array(Property.class);
        SlotCursor c = this.getProperties();
        while (c.next(BDynamicTableColumn.class)) {
            BDynamicTableColumn col = (BDynamicTableColumn)c.get();
            dprops.add((Object)col.makeDynamicProperty(db));
        }
        return DynamicOrionType.makeTemporary((Property[])((Property[])dprops.trim()));
    }

    public BDynamicTableColumn[] getColumns() {
        SlotCursor c = this.getProperties();
        Array cols = new Array(BDynamicTableColumn.class);
        while (c.next(BDynamicTableColumn.class)) {
            cols.add((Object)((BDynamicTableColumn)c.get()));
        }
        return (BDynamicTableColumn[])cols.trim();
    }

    public BDynamicTableColumn[] getVisibleColumns(Context cx) {
        BDynamicTableColumn[] columns = this.getWorkingColumns(cx);
        Array cols = new Array(BDynamicTableColumn.class);
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i].getHiddenKey()) continue;
            cols.add((Object)columns[i]);
        }
        return (BDynamicTableColumn[])cols.trim();
    }

    public BDynamicTableOptions getOptions(Context cx) {
        BDynamicTableOptions options = null;
        if (BWidget.getApplication() != null) {
            options = BDynamicTableOptions.make();
        }
        return options;
    }

    public BDynamicTableColumn[] getWorkingColumns(Context cx) {
        BDynamicTableOptions options = this.getOptions(cx);
        BDynamicTableColumn[] columns = null;
        if (options != null) {
            columns = options.getColumns(this, cx);
        }
        if (columns != null) {
            return this.filterColumns(columns, cx);
        }
        columns = this.getColumns();
        if (columns.length == 0) {
            columns = this.getDefaultColumns();
        }
        return this.filterColumns(columns, cx);
    }

    public BDynamicTableColumn[] getDefaultColumns() {
        BOrionTypeId rowType = this.getRowType();
        if (rowType.equals((Object)BOrionTypeId.DEFAULT)) {
            return new BDynamicTableColumn[0];
        }
        return this.getDefaultColumnsProvider().getDefaultColumns(this);
    }

    public BDynamicTableColumn[] filterColumns(BDynamicTableColumn[] columns, Context cx) {
        if (cx == null) {
            return columns;
        }
        Array a = new Array(BDynamicTableColumn.class);
        BOrionDatabase db = this.getOrionDatabase();
        for (int i = 0; i < columns.length; ++i) {
            if (!BDynamicTable.hasPermissionForColumn(columns[i], db, cx)) continue;
            a.add((Object)columns[i]);
        }
        return (BDynamicTableColumn[])a.trim();
    }

    public static boolean hasPermissionForColumn(BDynamicTableColumn column, BOrionDatabase db, Context cx) {
        column.lease();
        OrionType orionType = (OrionType)column.getFromType().getTypeSpec().getResolvedType();
        BOrionType bOrionType = db.getType(orionType);
        return bOrionType != null && bOrionType.getPermissions(cx).hasOperatorRead();
    }

    public boolean hasDefaultFilters(Context cx) {
        BDynamicTableColumn[] working = this.getWorkingColumns(cx);
        for (int i = 0; i < working.length; ++i) {
            if (working[i].getDefaultFilter().getType().equals(BNullFilter.TYPE)) continue;
            return true;
        }
        return false;
    }

    public BDynamicTableColumnsProvider getDefaultColumnsProvider() {
        BOrionTypeId rowType = this.getRowType();
        BDynamicTableColumnsProvider[] providers = (BDynamicTableColumnsProvider[])this.getChildren(BDynamicTableColumnsProvider.class);
        if (providers.length > 0) {
            return providers[providers.length - 1];
        }
        BTypeSpec typeSpec = rowType.getTypeSpec();
        Type type = null;
        try {
            type = typeSpec.getResolvedType();
        }
        catch (Exception e) {
            return defaultColumnsProvider;
        }
        AgentList list = Sys.getRegistry().getAgents(type.getTypeInfo()).filter(AgentFilter.is((Type)BDynamicTableColumnsProvider.TYPE));
        if (list.size() == 0) {
            return defaultColumnsProvider;
        }
        return (BDynamicTableColumnsProvider)list.getDefault().getInstance();
    }

    public boolean isDefaultColumnsArray(BDynamicTableColumn[] cols) {
        BDynamicTableColumn[] defaultColumns = this.getDefaultColumns();
        if (cols.length != defaultColumns.length) {
            return false;
        }
        for (int i = 0; i < cols.length; ++i) {
            if (cols[i].equivalent((Object)defaultColumns[i])) continue;
            return false;
        }
        return true;
    }

    public void setColumns(BDynamicTableColumn[] cols) {
        this.getDefaultColumnsProvider().setColumns(this, cols);
    }

    public boolean supportsPaginatedQuery(Context cx) {
        return SelectVisitor.dbSupportsPagination((BRdbms)this.getOrionDatabase().getRdbms());
    }

    public BDynamicTableReportType getWorkingReportType(Context cx) {
        BDynamicTableOptions options = this.getOptions(cx);
        if (options == null) {
            return this.getReportType();
        }
        return options.getReportType(this, cx);
    }

    public OrionCursor resolve(OrionSession session, int sortCol, boolean asc, BPage page, BFilterSet filterSet, Context cx) throws Exception {
        BQuery query = this.getQuery(sortCol, asc, page, filterSet, cx);
        return this.resolve(session, query);
    }

    public OrionCursor resolve(OrionSession session, BQuery query) throws Exception {
        int count;
        if (this.getCountResult() && (count = CountingUtil.getCount((BQuery)((BQuery)query.newCopy()), (OrionSession)session)) >= MAX_RESULT_SIZE) {
            throw new OutOfMemoryError("Query too large (Exceeded " + MAX_RESULT_SIZE + " rows)");
        }
        return session.select(query);
    }

    public BQuery getQuery(int sortCol, boolean asc, BFilterSet filterSet, Context cx) throws Exception {
        return this.getQuery(sortCol, asc, null, filterSet, cx);
    }

    public BQuery getQuery(int sortCol, boolean asc, BPage page, BFilterSet filterSet, Context cx) throws Exception {
        BTypeDependency d2;
        if (!this.getCoalesce() && page != null || !this.supportsPaginatedQuery(cx) || this.getWorkingReportType(cx) != BDynamicTableReportType.optimized) {
            BSqlQuery query = (BSqlQuery)this.getQueryNonCoalesced(sortCol, asc, filterSet, cx);
            query.page(page);
            return query;
        }
        BOrionDatabase db = this.getOrionDatabase();
        BOrionTypeId rowType = this.getRowType();
        Property firstRowKeyProperty = ((OrionType)rowType.getTypeSpec().getResolvedType()).getKey()[0];
        BSqlQuery q = new BSqlQuery();
        BProjection projection = new BProjection();
        BDynamicTableColumn[] columns = this.getWorkingColumns(cx);
        boolean first = true;
        int columnCount = 0;
        for (int i = 0; i < columns.length; ++i) {
            BDynamicTableColumn col = columns[i];
            BProjectionColumn projectionColumn = SqlColumns.make((BTypeSpec)col.getFromType().getTypeSpec(), (String)col.getFromProperty());
            projection.add(projectionColumn);
            if (sortCol == columnCount) {
                BOrderByCol ordBy = new BOrderByCol((BExpression)projectionColumn.getColumnExpression().newCopy());
                if (!asc) {
                    ordBy.desc();
                }
                q.orderBy(BOrdering.make((BOrderByColumn)ordBy));
            }
            ++columnCount;
        }
        if (page != null) {
            q.page(page);
        }
        Array joins = new Array(BTypeDependency.class);
        Array linkedJoins = new Array(BTypeDependency.class);
        HashMap<BTypeDependency, BTypeDependency> hashJoins = new HashMap<BTypeDependency, BTypeDependency>();
        Array columnsArray = new Array((Object[])columns);
        columnsArray = columnsArray.sort((Comparator)new ColumnComparator());
        for (int i = 0; i < columnsArray.size(); ++i) {
            BDynamicTableColumn col = (BDynamicTableColumn)((Object)columnsArray.get(i));
            BTypeDependency linkedD = col.getLinkedDependency();
            if (!(BDynamicTable.isNull(linkedD) || joins.contains((Object)linkedD) || linkedJoins.contains((Object)linkedD))) {
                linkedJoins.add((Object)linkedD);
            }
            if (BDynamicTable.isNull(d2 = col.getDependency()) || joins.contains((Object)d2) || linkedJoins.contains((Object)d2)) continue;
            if (BDynamicTable.isNull(linkedD) && d2.getToTypeId().equals((Object)rowType) && !firstRowKeyProperty.getName().equals(d2.getToProperty())) {
                joins.add((Object)d2);
                continue;
            }
            if (!BDynamicTable.isNull(linkedD) && linkedD.getToTypeId().equals((Object)rowType) && firstRowKeyProperty.getName().equals(linkedD.getToProperty())) {
                linkedJoins.remove((Object)linkedD);
                linkedJoins.add((Object)d2);
                hashJoins.put(d2, linkedD);
                continue;
            }
            if (BDynamicTable.isNull(linkedD) && d2.getToTypeId().equals((Object)rowType) && firstRowKeyProperty.getName().equals(d2.getToProperty()) && d2.getFromTypeId().getTypeSpec().getResolvedType().is(BIOrionAssociation.TYPE)) {
                hashJoins.put(d2, d2);
                linkedJoins.add((Object)d2);
                continue;
            }
            linkedJoins.add((Object)d2);
        }
        q.select(projection);
        BSqlExtent fromExtent = new BSqlExtent(rowType.getTypeSpec());
        if (joins.size() > 0 || linkedJoins.size() > 0) {
            fromExtent.alias("P");
        }
        q.from((BExtent)fromExtent);
        if (filterSet != null && filterSet.anyActive()) {
            q.where(filterSet.getQueryPredicate());
        }
        int joinCount = 0;
        for (BTypeDependency d2 : linkedJoins) {
            BTypeDependency linkedD = (BTypeDependency)hashJoins.get(d2);
            OrionType fromType = db.getType(d2.getFromTypeId());
            OrionType toType = db.getType(d2.getToTypeId());
            DynamicTableUtil.join(q, BJoin.leftOuterJoin, fromType, fromType.getProperty(d2.getFromProperty()), toType, toType.getProperty(d2.getToProperty()), filterSet, ++joinCount, linkedD, db);
            if (BDynamicTable.isNull(linkedD)) continue;
            ++joinCount;
        }
        ListIterator x = joins.iterator();
        while (x.hasNext()) {
            ++joinCount;
            d2 = (BTypeDependency)x.next();
            OrionType fromType = db.getType(d2.getFromTypeId());
            OrionType toType = db.getType(d2.getToTypeId());
            q.join(BJoin.leftOuterJoin, toType, toType.getProperty(d2.getToProperty()), fromType, fromType.getProperty(d2.getFromProperty()));
        }
        BISqlQueryFilter[] queryFilters = (BISqlQueryFilter[])this.getChildren(BISqlQueryFilter.class);
        for (int i = 0; i < queryFilters.length; ++i) {
            q = queryFilters[i].filter(q, db, cx);
        }
        return q;
    }

    public static boolean isNull(BTypeDependency d) {
        return d == null || d.isNull() || d.isSelf();
    }

    public BQuery getQueryNonCoalesced(int sortCol, boolean asc, BFilterSet filterSet, Context cx) throws Exception {
        BOrionDatabase db = this.getOrionDatabase();
        BOrionTypeId rowType = this.getRowType();
        BSqlQuery q = new BSqlQuery();
        BProjection projection = new BProjection();
        BDynamicTableColumn[] columns = this.getWorkingColumns(cx);
        boolean first = true;
        int columnCount = 0;
        Array joins = new Array(BTypeDependency.class);
        for (int i = 0; i < columns.length; ++i) {
            BTypeDependency d;
            BDynamicTableColumn col = columns[i];
            BProjectionColumn projectionColumn = SqlColumns.make((BTypeSpec)col.getFromType().getTypeSpec(), (String)col.getFromProperty());
            projection.add(projectionColumn);
            if (sortCol == columnCount) {
                BOrderByCol ordBy = new BOrderByCol((BExpression)projectionColumn.getColumnExpression().newCopy());
                if (!asc) {
                    ordBy.desc();
                }
                q.orderBy(BOrdering.make((BOrderByColumn)ordBy));
            }
            if (!((d = col.getLinkedDependency()).isSelf() || d.isNull() || joins.contains((Object)d))) {
                joins.add((Object)d);
            }
            if (!((d = col.getDependency()).isSelf() || d.isNull() || joins.contains((Object)d))) {
                joins.add((Object)d);
            }
            ++columnCount;
        }
        q.select(projection);
        q.from((BExtent)new BSqlExtent(rowType.getTypeSpec()));
        for (BTypeDependency d : joins) {
            OrionType fromType = db.getType(d.getFromTypeId());
            OrionType toType = db.getType(d.getToTypeId());
            q.join(BJoin.leftOuterJoin, toType, toType.getProperty(d.getToProperty()), fromType, fromType.getProperty(d.getFromProperty()));
        }
        if (filterSet != null && filterSet.anyActive()) {
            q.where(filterSet.getQueryPredicate());
        }
        BISqlQueryFilter[] queryFilters = (BISqlQueryFilter[])this.getChildren(BISqlQueryFilter.class);
        for (int i = 0; i < queryFilters.length; ++i) {
            q = queryFilters[i].filter(q, db, cx);
        }
        return q;
    }

    public static class ColumnComparator
    implements Comparator<BDynamicTableColumn> {
        @Override
        public int compare(BDynamicTableColumn o1, BDynamicTableColumn o2) {
            BDynamicTableColumn c1 = o1;
            BDynamicTableColumn c2 = o2;
            if (this.hasLink(c1) && !this.hasLink(c2)) {
                return -1;
            }
            if (!this.hasLink(c1) & this.hasLink(c2)) {
                return 1;
            }
            return 0;
        }

        public int hashCode() {
            return System.identityHashCode(this);
        }

        @Override
        public boolean equals(Object obj) {
            return false;
        }

        public boolean hasLink(BDynamicTableColumn c) {
            return !c.getLinkedDependency().equals((Object)BTypeDependency.NULL);
        }
    }
}

