/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.control.trigger;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Random;
import java.util.StringTokenizer;
import javax.baja.control.trigger.BTimeTrigger;
import javax.baja.control.trigger.BTriggerMode;
import javax.baja.control.trigger.TriggerScheduler;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BTime;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BDaysOfWeekBits;
import javax.baja.util.LexiconText;

@NiagaraType
public final class BDailyTriggerMode
extends BTriggerMode {
    public static final BDailyTriggerMode DEFAULT = new BDailyTriggerMode();
    public static final Type TYPE = Sys.loadType(BDailyTriggerMode.class);
    private BTime timeOfDay = BTime.make((int)2, (int)0, (int)0);
    private BDaysOfWeekBits daysOfWeek = BDaysOfWeekBits.DEFAULT;
    private BRelTime randInterval = BRelTime.make((long)0L);
    private BAbsTime scheduledTime;
    private static final Random rand = new Random();
    private static final LexiconText dispName = LexiconText.make((String)"control", (String)"trigger.daily");

    private BDailyTriggerMode() {
    }

    public static BDailyTriggerMode make() {
        return DEFAULT;
    }

    public static BDailyTriggerMode make(BTime timeOfDay) {
        BDailyTriggerMode m = new BDailyTriggerMode();
        m.timeOfDay = timeOfDay;
        return m;
    }

    public static BDailyTriggerMode make(BTime timeOfDay, BDaysOfWeekBits daysOfWeek) {
        BDailyTriggerMode m = new BDailyTriggerMode();
        m.timeOfDay = timeOfDay;
        m.daysOfWeek = daysOfWeek;
        return m;
    }

    public static BDailyTriggerMode make(BTime timeOfDay, BDaysOfWeekBits daysOfWeek, BRelTime randInterval) {
        BDailyTriggerMode m = new BDailyTriggerMode();
        m.timeOfDay = timeOfDay;
        m.daysOfWeek = daysOfWeek;
        m.randInterval = randInterval;
        return m;
    }

    @Override
    public String getDisplayName(Context cx) {
        return dispName.getText(cx);
    }

    public BTime getTimeOfDay() {
        return this.timeOfDay;
    }

    public BDaysOfWeekBits getDaysOfWeek() {
        return this.daysOfWeek;
    }

    public BRelTime getRandomizationInterval() {
        return this.randInterval;
    }

    @Override
    public TriggerScheduler makeScheduler(BTimeTrigger trigger) {
        return new DailyTriggerScheduler(trigger);
    }

    public int hashCode() {
        return this.timeOfDay.hashCode() ^ this.daysOfWeek.hashCode() ^ this.randInterval.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof BDailyTriggerMode) {
            BDailyTriggerMode dtt = (BDailyTriggerMode)((Object)o);
            return this.timeOfDay.equals((Object)dtt.timeOfDay) && this.daysOfWeek.equals((Object)dtt.daysOfWeek) && this.randInterval.equals((Object)dtt.randInterval);
        }
        return false;
    }

    public void encode(DataOutput out) throws IOException {
        this.timeOfDay.encode(out);
        this.daysOfWeek.encode(out);
        this.randInterval.encode(out);
    }

    public BObject decode(DataInput in) throws IOException {
        return BDailyTriggerMode.make((BTime)BTime.DEFAULT.decode(in), (BDaysOfWeekBits)BDaysOfWeekBits.DEFAULT.decode(in), (BRelTime)BRelTime.DEFAULT.decode(in));
    }

    public String encodeToString() {
        return this.timeOfDay.encodeToString() + ";" + this.daysOfWeek.encodeToString() + ";" + this.randInterval.encodeToString();
    }

    public BObject decodeFromString(String s) throws IOException {
        StringTokenizer st = new StringTokenizer(s, ";");
        return BDailyTriggerMode.make((BTime)BTime.DEFAULT.decodeFromString(st.nextToken()), (BDaysOfWeekBits)BDaysOfWeekBits.DEFAULT.decodeFromString(st.nextToken()), (BRelTime)BRelTime.DEFAULT.decodeFromString(st.nextToken()));
    }

    public String toString(Context cx) {
        StringBuilder s = new StringBuilder();
        s.append(this.timeOfDay.toString(cx));
        s.append(' ');
        s.append(this.daysOfWeek.toString(cx));
        if (this.randInterval.getMillis() != 0L) {
            s.append(" +~").append(this.randInterval.toString(cx));
        }
        return s.toString();
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    private class DailyTriggerScheduler
    extends TriggerScheduler {
        private Clock.Ticket ticket;

        public DailyTriggerScheduler(BTimeTrigger trigger) {
            super(trigger);
        }

        @Override
        public void start() {
            BAbsTime now = Clock.time();
            BDailyTriggerMode.this.scheduledTime = this.getNextTriggerTime(now, this.getTrigger().getLastTrigger());
            this.ticket = Clock.schedule((BComponent)this.getTrigger(), (BAbsTime)BDailyTriggerMode.this.scheduledTime, (Action)BTimeTrigger.checkTime, null);
        }

        @Override
        public void stop() {
            if (this.ticket != null) {
                this.ticket.cancel();
            }
            this.ticket = null;
        }

        @Override
        public boolean isTriggerTime(BAbsTime time) {
            boolean fireTime = this.isFireTime(time);
            if (this.ticket != null) {
                BDailyTriggerMode.this.scheduledTime = fireTime ? this.getNextTriggerTime(time, time) : this.getNextTriggerTime(time, this.getTrigger().getLastTrigger());
                this.ticket.cancel();
                this.ticket = Clock.schedule((BComponent)this.getTrigger(), (BAbsTime)BDailyTriggerMode.this.scheduledTime, (Action)BTimeTrigger.checkTime, null);
            }
            return fireTime;
        }

        @Override
        BAbsTime getScheduledTriggerTime() {
            return BDailyTriggerMode.this.scheduledTime;
        }

        @Override
        public BAbsTime getNextTriggerTime(BAbsTime start, BAbsTime previous) {
            if (BDailyTriggerMode.this.daysOfWeek.isEmpty()) {
                return BAbsTime.END_OF_TIME;
            }
            BAbsTime t = BAbsTime.make((BAbsTime)start, (BTime)BDailyTriggerMode.this.timeOfDay);
            if (BDailyTriggerMode.this.daysOfWeek.includes(start) && !t.isBefore(start)) {
                if (BDailyTriggerMode.this.randInterval.getMillis() == 0L) {
                    return t;
                }
                long randMillis = (long)((double)BDailyTriggerMode.this.randInterval.getMillis() * rand.nextDouble());
                BAbsTime randTime = t.add(BRelTime.make((long)randMillis));
                if (randTime.isAfter(BAbsTime.now())) {
                    return randTime;
                }
                return t;
            }
            long previousMillis = previous != null && !previous.equals((Object)BAbsTime.END_OF_TIME) ? previous.getMillis() : 0L;
            long elapsed = t.getMillis() - previousMillis;
            if (BDailyTriggerMode.this.daysOfWeek.includes(t) && elapsed >= 86400000L - (BDailyTriggerMode.this.randInterval.getMillis() + 60000L)) {
                BAbsTime maxT = t.add(BDailyTriggerMode.this.randInterval);
                if (BDailyTriggerMode.this.scheduledTime != null && !BDailyTriggerMode.this.scheduledTime.isBefore(start) && maxT.getMillis() >= BDailyTriggerMode.this.scheduledTime.getMillis()) {
                    return BDailyTriggerMode.this.scheduledTime;
                }
                if (!maxT.isBefore(start)) {
                    return maxT;
                }
            }
            t = t.nextDay();
            while (!BDailyTriggerMode.this.daysOfWeek.includes(t)) {
                t = t.nextDay();
            }
            if (BDailyTriggerMode.this.randInterval.getMillis() == 0L) {
                return t;
            }
            long randMillis = (long)((double)BDailyTriggerMode.this.randInterval.getMillis() * rand.nextDouble());
            BAbsTime randTime = t.add(BRelTime.make((long)randMillis));
            if (randTime.isAfter(BAbsTime.now())) {
                return randTime;
            }
            return t;
        }

        private boolean isFireTime(BAbsTime time) {
            return !time.isBefore(this.getTrigger().getNextTrigger());
        }
    }
}

