/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.control.ext;

import javax.baja.control.BControlPoint;
import javax.baja.control.BDiscretePoint;
import javax.baja.control.BPointExtension;
import javax.baja.control.enums.BCountTransition;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIEnum;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="changeOfStateCountTransition", type="BCountTransition", defaultValue="BCountTransition.both"), @NiagaraProperty(name="propagateFlags", type="BStatus", defaultValue="BStatus.make(BStatus.FAULT | BStatus.DOWN | BStatus.DISABLED )"), @NiagaraProperty(name="invalidValueFlags", type="BStatus", defaultValue="BStatus.make(BStatus.FAULT | BStatus.DOWN | BStatus.DISABLED)"), @NiagaraProperty(name="changeOfStateTime", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", flags=65), @NiagaraProperty(name="changeOfStateCount", type="int", defaultValue="0", flags=1), @NiagaraProperty(name="timeOfStateCountReset", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", flags=65), @NiagaraProperty(name="elapsedActiveTime", type="BRelTime", defaultValue="BRelTime.DEFAULT", flags=1), @NiagaraProperty(name="elapsedActiveTimeNumeric", type="BStatusNumeric", defaultValue="new BStatusNumeric()", flags=1), @NiagaraProperty(name="timeOfActiveTimeReset", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", flags=65), @NiagaraProperty(name="eaTimeUpdateInterval", type="BRelTime", defaultValue="BRelTime.makeSeconds(10)", flags=8)})
@NiagaraActions(value={@NiagaraAction(name="timerExpired", flags=4), @NiagaraAction(name="resetChangeOfStateCount", flags=128), @NiagaraAction(name="resetElapsedActiveTime", flags=128)})
public class BDiscreteTotalizerExt
extends BPointExtension {
    @Generated
    public static final Property changeOfStateCountTransition = BDiscreteTotalizerExt.newProperty((int)0, (BValue)BCountTransition.both, null);
    @Generated
    public static final Property propagateFlags = BDiscreteTotalizerExt.newProperty((int)0, (BValue)BStatus.make((int)7), null);
    @Generated
    public static final Property invalidValueFlags = BDiscreteTotalizerExt.newProperty((int)0, (BValue)BStatus.make((int)7), null);
    @Generated
    public static final Property changeOfStateTime = BDiscreteTotalizerExt.newProperty((int)65, (BValue)BAbsTime.DEFAULT, null);
    @Generated
    public static final Property changeOfStateCount = BDiscreteTotalizerExt.newProperty((int)1, (int)0, null);
    @Generated
    public static final Property timeOfStateCountReset = BDiscreteTotalizerExt.newProperty((int)65, (BValue)BAbsTime.DEFAULT, null);
    @Generated
    public static final Property elapsedActiveTime = BDiscreteTotalizerExt.newProperty((int)1, (BValue)BRelTime.DEFAULT, null);
    @Generated
    public static final Property elapsedActiveTimeNumeric = BDiscreteTotalizerExt.newProperty((int)1, (BValue)new BStatusNumeric(), null);
    @Generated
    public static final Property timeOfActiveTimeReset = BDiscreteTotalizerExt.newProperty((int)65, (BValue)BAbsTime.DEFAULT, null);
    @Generated
    public static final Property eaTimeUpdateInterval = BDiscreteTotalizerExt.newProperty((int)8, (BValue)BRelTime.makeSeconds((int)10), null);
    @Generated
    public static final Action timerExpired = BDiscreteTotalizerExt.newAction((int)4, null);
    @Generated
    public static final Action resetChangeOfStateCount = BDiscreteTotalizerExt.newAction((int)128, null);
    @Generated
    public static final Action resetElapsedActiveTime = BDiscreteTotalizerExt.newAction((int)128, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BDiscreteTotalizerExt.class);
    private final Object updateLock = new Object();
    private Clock.Ticket ticket;
    private boolean lastActive;
    private boolean forceUpdate;
    private long lastEATUpdateTime;
    private long lastActiveTime;
    private long elapsedTimeMillis;
    private int cosCount;
    private static final Context SKIP_FIELD_UPDATE = new BasicContext();

    @Generated
    public BCountTransition getChangeOfStateCountTransition() {
        return (BCountTransition)this.get(changeOfStateCountTransition);
    }

    @Generated
    public void setChangeOfStateCountTransition(BCountTransition v) {
        this.set(changeOfStateCountTransition, (BValue)v, null);
    }

    @Generated
    public BStatus getPropagateFlags() {
        return (BStatus)this.get(propagateFlags);
    }

    @Generated
    public void setPropagateFlags(BStatus v) {
        this.set(propagateFlags, (BValue)v, null);
    }

    @Generated
    public BStatus getInvalidValueFlags() {
        return (BStatus)this.get(invalidValueFlags);
    }

    @Generated
    public void setInvalidValueFlags(BStatus v) {
        this.set(invalidValueFlags, (BValue)v, null);
    }

    @Generated
    public BAbsTime getChangeOfStateTime() {
        return (BAbsTime)this.get(changeOfStateTime);
    }

    @Generated
    public void setChangeOfStateTime(BAbsTime v) {
        this.set(changeOfStateTime, (BValue)v, null);
    }

    @Generated
    public int getChangeOfStateCount() {
        return this.getInt(changeOfStateCount);
    }

    @Generated
    public void setChangeOfStateCount(int v) {
        this.setInt(changeOfStateCount, v, null);
    }

    @Generated
    public BAbsTime getTimeOfStateCountReset() {
        return (BAbsTime)this.get(timeOfStateCountReset);
    }

    @Generated
    public void setTimeOfStateCountReset(BAbsTime v) {
        this.set(timeOfStateCountReset, (BValue)v, null);
    }

    @Generated
    public BRelTime getElapsedActiveTime() {
        return (BRelTime)this.get(elapsedActiveTime);
    }

    @Generated
    public void setElapsedActiveTime(BRelTime v) {
        this.set(elapsedActiveTime, (BValue)v, null);
    }

    @Generated
    public BStatusNumeric getElapsedActiveTimeNumeric() {
        return (BStatusNumeric)this.get(elapsedActiveTimeNumeric);
    }

    @Generated
    public void setElapsedActiveTimeNumeric(BStatusNumeric v) {
        this.set(elapsedActiveTimeNumeric, (BValue)v, null);
    }

    @Generated
    public BAbsTime getTimeOfActiveTimeReset() {
        return (BAbsTime)this.get(timeOfActiveTimeReset);
    }

    @Generated
    public void setTimeOfActiveTimeReset(BAbsTime v) {
        this.set(timeOfActiveTimeReset, (BValue)v, null);
    }

    @Generated
    public BRelTime getEaTimeUpdateInterval() {
        return (BRelTime)this.get(eaTimeUpdateInterval);
    }

    @Generated
    public void setEaTimeUpdateInterval(BRelTime v) {
        this.set(eaTimeUpdateInterval, (BValue)v, null);
    }

    @Generated
    public void timerExpired() {
        this.invoke(timerExpired, null, null);
    }

    @Generated
    public void resetChangeOfStateCount() {
        this.invoke(resetChangeOfStateCount, null, null);
    }

    @Generated
    public void resetElapsedActiveTime() {
        this.invoke(resetElapsedActiveTime, null, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void started() {
        if (BAbsTime.DEFAULT.equals((Object)this.getChangeOfStateTime())) {
            this.setChangeOfStateTime(BAbsTime.make());
        }
        if (BAbsTime.DEFAULT.equals((Object)this.getTimeOfStateCountReset())) {
            this.setTimeOfStateCountReset(BAbsTime.make());
        }
        if (BAbsTime.DEFAULT.equals((Object)this.getTimeOfActiveTimeReset())) {
            this.setTimeOfActiveTimeReset(BAbsTime.make());
        }
        Object object = this.updateLock;
        synchronized (object) {
            this.elapsedTimeMillis = this.getElapsedActiveTime().getMillis();
            this.cosCount = this.getChangeOfStateCount();
        }
        BControlPoint point = this.getParentPoint();
        if (point != null) {
            this.update(point.getOutStatusValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopped() {
        Object object = this.updateLock;
        synchronized (object) {
            if (this.ticket != null) {
                this.ticket.cancel();
                this.ticket = null;
            }
        }
    }

    public final Object fw(int x, Object a, Object b, Object c, Object d) {
        if (x == 2) {
            this.fwChanged((Property)a, (Context)b);
        }
        return super.fw(x, a, b, c, d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fwChanged(Property p, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        if (p.equals(changeOfStateCount)) {
            if (cx != SKIP_FIELD_UPDATE) {
                Object object = this.updateLock;
                synchronized (object) {
                    this.cosCount = this.getChangeOfStateCount();
                }
            }
        } else if (p.equals(elapsedActiveTime)) {
            if (cx != SKIP_FIELD_UPDATE) {
                Object object = this.updateLock;
                synchronized (object) {
                    this.elapsedTimeMillis = this.getElapsedActiveTime().getMillis();
                }
                this.getElapsedActiveTimeNumeric().setDouble(BStatusNumeric.value, (double)this.elapsedTimeMillis, SKIP_FIELD_UPDATE);
            }
        } else if (p.equals(elapsedActiveTimeNumeric) && cx != SKIP_FIELD_UPDATE) {
            Object object = this.updateLock;
            synchronized (object) {
                this.elapsedTimeMillis = (long)this.getElapsedActiveTimeNumeric().getNumeric();
            }
            this.set(elapsedActiveTime, (BValue)BRelTime.make((long)this.elapsedTimeMillis), SKIP_FIELD_UPDATE);
        }
    }

    @Override
    public boolean requiresPointSubscription() {
        return true;
    }

    @Override
    public boolean isParentLegal(BComponent parent) {
        if (!super.isParentLegal(parent)) {
            return false;
        }
        return parent instanceof BDiscretePoint;
    }

    @Override
    protected boolean isSiblingLegal(BComponent sibling) {
        return true;
    }

    public void doTimerExpired() {
        BControlPoint point = this.getParentPoint();
        if (point != null) {
            this.update(point.getOutStatusValue());
        }
    }

    @Override
    public void onExecute(BStatusValue out, Context cx) {
        this.update(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doResetChangeOfStateCount() {
        Object object = this.updateLock;
        synchronized (object) {
            this.cosCount = 0;
        }
        this.setInt(changeOfStateCount, this.cosCount, SKIP_FIELD_UPDATE);
        this.setTimeOfStateCountReset(Clock.time());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doResetElapsedActiveTime() {
        Object object = this.updateLock;
        synchronized (object) {
            this.lastActiveTime = 0L;
            this.elapsedTimeMillis = 0L;
        }
        this.set(elapsedActiveTime, (BValue)BRelTime.make((long)this.elapsedTimeMillis), SKIP_FIELD_UPDATE);
        this.getElapsedActiveTimeNumeric().setDouble(BStatusNumeric.value, (double)this.elapsedTimeMillis, SKIP_FIELD_UPDATE);
        this.setTimeOfActiveTimeReset(Clock.time());
        BControlPoint point = this.getParentPoint();
        if (point != null) {
            this.update(point.getOutStatusValue());
        }
        Object object2 = this.updateLock;
        synchronized (object2) {
            this.forceUpdate = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(BStatusValue out) {
        BAbsTime cosTime = null;
        boolean setElapsedAfterLock = false;
        Object object = this.updateLock;
        synchronized (object) {
            if (!this.isRunning()) {
                return;
            }
            boolean isValueValid = (out.getStatus().getBits() & this.getInvalidValueFlags().getBits()) == 0;
            boolean isActive = ((BIEnum)out).getEnum().isActive();
            boolean countIt = false;
            if (isValueValid) {
                switch (this.getChangeOfStateCountTransition().getOrdinal()) {
                    case 0: {
                        countIt = !this.lastActive && isActive;
                        break;
                    }
                    case 1: {
                        countIt = this.lastActive && !isActive;
                        break;
                    }
                    default: {
                        countIt = this.lastActive != isActive;
                    }
                }
                this.lastActive = isActive;
            }
            if (countIt) {
                ++this.cosCount;
                cosTime = Clock.time();
            }
            long now = Clock.ticks();
            boolean isElapsedTimeUpdated = false;
            if (this.lastActiveTime != 0L) {
                this.elapsedTimeMillis += now - this.lastActiveTime;
                isElapsedTimeUpdated = true;
            }
            if (isActive && isValueValid) {
                this.lastActiveTime = now;
                if (this.ticket == null || this.ticket.isExpired()) {
                    this.ticket = Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.make((long)1000L), (Action)timerExpired, null);
                }
            } else {
                this.lastActiveTime = 0L;
                if (this.ticket != null && !this.ticket.isExpired()) {
                    this.ticket.cancel();
                }
                this.ticket = null;
            }
            if (isElapsedTimeUpdated && (this.forceUpdate || now - this.lastEATUpdateTime > this.getEaTimeUpdateInterval().getMillis())) {
                setElapsedAfterLock = true;
                this.lastEATUpdateTime = now;
                this.forceUpdate = false;
            }
        }
        if (cosTime != null) {
            this.setInt(changeOfStateCount, this.cosCount, SKIP_FIELD_UPDATE);
            this.setChangeOfStateTime(cosTime);
        }
        if (setElapsedAfterLock) {
            this.set(elapsedActiveTime, (BValue)BRelTime.make((long)this.elapsedTimeMillis), SKIP_FIELD_UPDATE);
            this.getElapsedActiveTimeNumeric().setDouble(BStatusNumeric.value, (double)this.elapsedTimeMillis, SKIP_FIELD_UPDATE);
            BControlPoint parentPoint = this.getParentPoint();
            if (parentPoint != null) {
                parentPoint.execute();
            }
        }
        this.getElapsedActiveTimeNumeric().set(BStatusValue.status, (BValue)BStatus.make((int)(out.getStatus().getBits() & this.getPropagateFlags().getBits())), SKIP_FIELD_UPDATE);
    }
}

