/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.jsonToolkit.outbound.schema.support;

import com.tridium.driver.util.DrUtil;
import com.tridium.json.JSONWriter;
import com.tridiumx.jsonToolkit.outbound.schema.BIJsonArray;
import com.tridiumx.jsonToolkit.outbound.schema.BIJsonSchemaMember;
import com.tridiumx.jsonToolkit.outbound.schema.BJsonSchema;
import com.tridiumx.jsonToolkit.outbound.schema.BJsonSchemaBoundMember;
import com.tridiumx.jsonToolkit.outbound.schema.config.BJsonSchemaNameCasing;
import com.tridiumx.jsonToolkit.outbound.schema.config.BJsonSchemaNameSource;
import com.tridiumx.jsonToolkit.outbound.schema.config.BJsonSchemaNameSpacing;
import com.tridiumx.jsonToolkit.outbound.schema.support.BJsonSchemaService;
import com.tridiumx.jsonToolkit.outbound.schema.support.JsonSchemaUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BComplex;
import javax.baja.sys.BObject;
import javax.baja.sys.BStation;
import javax.baja.sys.Slot;
import javax.baja.sys.Type;

public final class JsonSchemaNameUtil {
    private static final Pattern SLOT_PATTERN = Pattern.compile("slot:/", 16);
    public static final Logger logger = BJsonSchemaService.childLogger("jsonSchema");

    private JsonSchemaNameUtil() {
    }

    public static JSONWriter writeKey(BIJsonSchemaMember member, JSONWriter json, String name) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("writing key for " + name);
        }
        if (!(member.getParent() instanceof BIJsonArray)) {
            String newName = JsonSchemaNameUtil.applyNamingRules(member, name);
            json.key(SlotPath.unescape((String)newName));
        }
        return json;
    }

    public static String getJsonName(BJsonSchemaBoundMember member) {
        BJsonSchemaNameSource nameSource = member.getJsonNameSource();
        String jsonName = "";
        switch (nameSource.getOrdinal()) {
            case 2: {
                if (!member.isBindOrdSet()) break;
                jsonName = JsonSchemaNameUtil.getDisplayNameOfTarget(member.getOrdTarget());
                break;
            }
            case 1: {
                if (!member.isBindOrdSet()) break;
                jsonName = JsonSchemaNameUtil.getNameOfTarget(member.getOrdTarget());
                break;
            }
            case 0: {
                jsonName = member.getDisplayName(null);
                break;
            }
            case 3: {
                jsonName = JsonSchemaNameUtil.getNameOfTargetsParent(member.getOrdTarget());
                break;
            }
            case 4: {
                jsonName = JsonSchemaNameUtil.getTargetsPath(member.getOrdTarget());
            }
        }
        return JsonSchemaNameUtil.applyNamingRules(member, jsonName);
    }

    public static String getNameOfTarget(OrdTarget ordTarget) {
        if (ordTarget != null) {
            BObject target = ordTarget.get();
            return target.isSimple() ? ordTarget.getPropertyInParent().getName() : target.asComplex().getName();
        }
        return "";
    }

    public static String getNameOfTargetsParent(OrdTarget ordTarget) {
        String parentName = "";
        if (ordTarget != null) {
            BComplex parent = ordTarget.getParent();
            if (parent == null) {
                parent = ordTarget.get().asComplex().getParent();
            }
            if (parent.getPropertyInParent() != null) {
                parentName = parent.getPropertyInParent().getName();
            } else if (parent.getName() != null) {
                parentName = parent.getName();
            } else if (parent instanceof BStation) {
                parentName = ((BStation)parent.as(BStation.class)).getStationName();
            }
        }
        return parentName;
    }

    public static String getDisplayNameOfTarget(OrdTarget ordTarget) {
        if (ordTarget != null) {
            BObject target = ordTarget.get();
            return target.isSimple() ? ordTarget.getParent().getDisplayName((Slot)ordTarget.getPropertyInParent(), null) : target.asComplex().getDisplayName(null);
        }
        return "";
    }

    public static String getTargetsPath(OrdTarget ordTarget) {
        if (ordTarget != null) {
            return SLOT_PATTERN.matcher(JsonSchemaUtil.getSlotPath(ordTarget)).replaceAll(Matcher.quoteReplacement(""));
        }
        return "";
    }

    public static String getNameOfNearest(OrdTarget ordTarget, Type type) {
        BComplex nearest = JsonSchemaNameUtil.getNearest(ordTarget, type);
        return nearest != null ? nearest.getName() : "";
    }

    public static BComplex getNearest(OrdTarget ordTarget, Type type) {
        BObject target = ordTarget.get();
        BComplex complex = target.isComplex() ? target.asComplex() : ordTarget.getParent();
        return complex.getType().is(type) ? complex : DrUtil.getParent((BComplex)complex, (Type)type);
    }

    public static String applyNamingRules(BIJsonSchemaMember member, String name) {
        if (logger.isLoggable(Level.FINE)) {
            logger.finest("applyNamingRules " + name);
        }
        BJsonSchema schema = member.getSchema();
        return JsonSchemaNameUtil.applyRules(name, schema.getConfig().getNameCasingRule(), schema.getConfig().getNameSpacingRule());
    }

    private static String applyRules(String in, BJsonSchemaNameCasing casingRule, BJsonSchemaNameSpacing spacingRule) {
        StringBuilder builder = new StringBuilder();
        int last = 0;
        boolean isFirstChar = true;
        for (int i = 0; i < in.length(); ++i) {
            boolean caseChange;
            int c = in.charAt(i);
            boolean isLastChar = i == in.length() - 1;
            boolean bl = caseChange = !isFirstChar && !isLastChar && !Character.isWhitespace((char)c) && !Character.isWhitespace((char)last) && Character.isLowerCase((char)last) && Character.isUpperCase((char)c);
            if (Character.isWhitespace((char)c)) {
                String replacement = JsonSchemaNameUtil.handleWhiteSpace((char)c, isFirstChar, isLastChar, spacingRule);
                if (!replacement.isEmpty()) {
                    builder.append(replacement);
                }
                last = c;
                continue;
            }
            if (caseChange && spacingRule == BJsonSchemaNameSpacing.add) {
                builder.append(' ');
                last = 32;
            }
            builder.append(JsonSchemaNameUtil.handleChar((char)c, (char)last, isFirstChar, casingRule));
            last = c;
            isFirstChar = false;
        }
        return builder.toString();
    }

    private static char handleChar(char c, char lastChar, boolean isFirstChar, BJsonSchemaNameCasing casingRule) {
        switch (casingRule.getOrdinal()) {
            case 0: {
                return isFirstChar ? Character.toLowerCase(c) : (Character.isWhitespace(lastChar) ? Character.toUpperCase(c) : c);
            }
            case 1: {
                return isFirstChar || Character.isWhitespace(lastChar) ? Character.toUpperCase(c) : c;
            }
            case 2: {
                return Character.toUpperCase(c);
            }
            case 3: {
                return Character.toLowerCase(c);
            }
        }
        return c;
    }

    private static String handleWhiteSpace(char c, boolean isFirstChar, boolean isLastChar, BJsonSchemaNameSpacing spacingRule) {
        switch (spacingRule.getOrdinal()) {
            case 0: {
                return "";
            }
            case 1: {
                return String.valueOf(c);
            }
            case 3: {
                return isFirstChar || isLastChar ? "" : "-";
            }
            case 4: {
                return isFirstChar || isLastChar ? "" : "_";
            }
            case 5: {
                try {
                    return isFirstChar || isLastChar ? "" : URLEncoder.encode(String.valueOf(c), "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    logger.warning("Problem url encoding json name: " + e.getMessage());
                }
            }
        }
        return String.valueOf(c);
    }
}

