/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.jsonToolkit.outbound.schema.query.style;

import com.tridiumx.jsonToolkit.outbound.schema.query.BJsonSchemaBoundQueryResult;
import com.tridiumx.jsonToolkit.outbound.schema.query.style.BQueryResultWriter;
import com.tridiumx.jsonToolkit.outbound.schema.support.BJsonSchemaService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.sys.BObject;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Sys;

public class QueryStyleManager {
    private List<BQueryResultWriter> writers;
    private static final QueryStyleManager INSTANCE = new QueryStyleManager();
    private static final Logger log = BJsonSchemaService.childLogger("queryStyle");

    private QueryStyleManager() {
    }

    public static QueryStyleManager getInstance() {
        return INSTANCE;
    }

    public List<BQueryResultWriter> getQueryStyles() {
        if (this.writers == null) {
            this.writers = new ArrayList<BQueryResultWriter>();
            AgentList agents = Sys.getRegistry().getAgents(BJsonSchemaBoundQueryResult.TYPE.getTypeInfo());
            Arrays.stream(agents.list()).forEach(this::registerStyle);
        }
        return Collections.unmodifiableList(this.writers);
    }

    private void registerStyle(AgentInfo agentInfo) {
        block5: {
            try {
                BObject agentInstance = agentInfo.getInstance();
                if (agentInstance instanceof BQueryResultWriter) {
                    this.writers.add((BQueryResultWriter)agentInstance.as(BQueryResultWriter.class));
                } else if (log.isLoggable(Level.FINE)) {
                    log.fine(String.format("Cannot register type %s as a query output writer as it is not a %s", agentInstance.getType().getTypeName(), BQueryResultWriter.class.getSimpleName()));
                }
            }
            catch (BajaRuntimeException bre) {
                if (!log.isLoggable(Level.FINE)) break block5;
                log.fine(String.format("Cannot register type %s due to instantiation error", agentInfo.getAgentType().getTypeName()));
                bre.printStackTrace();
            }
        }
    }
}

